#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/connpool/connect_pool.hpp"

namespace acl
{

/**
 * redis ӳ̳࣬ connect_pool connect_pool ͨõй
 * TCP ӳصͨ÷
 * redis connection pool inherting from connect_pool, which includes
 * TCP connection pool methods.
 */
class ACL_CPP_API redis_pool : public connect_pool
{
public:
	/**
	 * 캯
	 * @param addr {const char*} ˵ַʽip:port
	 * @param count {int} ӳص
	 * @param idx {size_t} ӳضڼе±λ( 0 ʼ)
	 */
	redis_pool(const char* addr, int count, size_t idx = 0);

	virtual ~redis_pool();

	/**
	 * ӳʱʱ估 IO дʱʱ()
	 * @param conn_timeout {int} ӳʱʱ
	 * @param rw_timeout {int}  IO дʱʱ()
	 * @return {redis_pool&}
	 */
	redis_pool& set_timeout(int conn_timeout, int rw_timeout);

protected:
	/**
	 * ി麯: ô˺һµ
	 * @return {connect_client*}
	 */
	virtual connect_client* create_connect();

private:
	int   conn_timeout_;
	int   rw_timeout_;
};

} // namespace acl
