#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <time.h>
#include "acl_cpp/connpool/connect_client.hpp"
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/mime/rfc2047.hpp"

namespace acl {

class socket_stream;

typedef class memcache mem_cache;

/**
 * memcached ͻͨЭ⣬ֳ֧Զ
 */
class ACL_CPP_API memcache : public connect_client
{
public:
	/**
	* 캯
	* @param addr {const char*} memcached ַʽΪ
	*  ip:port: 127.0.0.1:11211
	* @param conn_timeout {int} ӳʱʱ()
	* @param rw_timeout {int} IO дʱʱ()
	*/
	memcache(const char* addr = "127.0.0.1:11211",
		int conn_timeout = 180, int rw_timeout = 300);

	~memcache();

	/**
	 *  key ǰ׺ʵʵ key  ǰ׺+ԭʼkey ɣȱʡʱǰ׺
	 * Ӧùͬһ memcached ʱӦ key ǰ׺
	 * ԱӦõ key ظ
	 * @param keypre {const char*} ǿʱ key ǰ׺ȡ key ǰ׺
	 * @return {memcache&}
	 */
	memcache& set_prefix(const char* keypre);

	/**
	 * ڱֵĳжʱǷҪԶȱʡΪԶ
	 * @param onoff {bool} Ϊ true ʱʾϿԶ
	 * @return {memcache&}
	 */
	memcache& auto_retry(bool onoff);

	/**
	 * Ƿ KEY ֵб룬ȱʱ key 룬Ӧõ key п
	 * ֵַʱô˺ key б
	 * @param onoff {bool} Ϊ true ʾڲҪ key б
	 * @return {memcache&}
	 */
	memcache& encode_key(bool onoff);

	/**
	*  memcached ޸Ļµݻ
	* @param key {const char*} ֵ
	* @param klen {size_t} key ֵ
	* @param dat {const void*} 
	* @param dlen {size_t} data ݳ
	* @param timeout {time_t} 泬ʱʱ()
	* @param flags {unsigned short} ı־λ
	* @return {bool} Ƿɹ
	*/
	bool set(const char* key, size_t klen,
		const void* dat, size_t dlen,
		time_t timeout = 0, unsigned short flags = 0);

	/**
	*  memcached ޸Ļµݻ
	* @param key {const char*} ֵַ
	* @param dat {const void*} 
	* @param dlen {size_t} data ݳ
	* @param timeout {time_t} 泬ʱʱ()
	* @param flags {unsigned short} ı־λ
	* @return {bool} Ƿɹ
	*/
	bool set(const char* key, const void* dat, size_t dlen,
		time_t timeout = 0, unsigned short flags = 0);

	/**
	*  memcached ѾڵļĹڣΪĿǰ libmemcached û
	* ṩ˽ӿڣԸúʵֵķʽȵ get ȡӦֵȻ
	*  set øüֵʱ
	* @param key {const char*} ֵ
	* @param klen {size_t} key ֵ
	* @param timeout {time_t} ʱ()
	* @return {bool} Ƿɹ
	*/
	bool set(const char* key, size_t klen, time_t timeout = 0);

	/**
	*  memcached ѾڵļĹڣΪĿǰ libmemcached û
	* ṩ˽ӿڣԸúʵֵķʽȵ get ȡӦֵȻ
	*  set øüֵʱ
	* @param key {const char*} ֵַ
	* @param timeout {time_t} ʱ()
	* @return {bool} Ƿɹ
	*/
	bool set(const char* key, time_t timeout = 0);

	/**
	 * ʽʽϴʱúͷ
	 * @param key {const char*} ֵַ
	 * @param dlen {size_t} ܳ
	 * @param timeout {time_t} ݵĹʱ()
	 * @param flags {unsigned short} ı־λ
	 * @return {bool} Ƿɹ
	 */
	bool set_begin(const char* key, size_t dlen,
		time_t timeout = 0, unsigned short flags = 0);

	/**
	 * ѭñϴֵڲԶѾϴܺǷﵽ set_begin
	 * õܳȣﵽԶһ "\r\n"߲Ӧٵô˺ϴݣ
	 * һµϴ̿ʼ
	 * @param data {const void*} ݵַָ
	 * @param len {data} data ݳ
	 * @return {bool} Ƿɹ
	 */
	bool set_data(const void* data, size_t len);

	/**
	*  memcached лöӦֵĻ
	* @param key {const char*} ֵַ
	* @param klen {size_t} ֵ
	* @param buf {string&} 洢ĻڲȻոû
	* @param flags {unsigned short*} 洢ı־λ
	* @return {bool}  true ʾȷýֵʾֵӦ
	*  ݲڻ
	*/
	bool get(const char* key, size_t klen, string& buf,
		unsigned short* flags = NULL);

	/**
	*  memcached лöӦֵĻ
	* @param key {const char*} ֵַ
	* @param buf {string&} 洢ĻڲȻոû
	* @param flags {unsigned short*} 洢ı־λ
	* @return {bool}  true ʾȷýֵʾֵӦ
	*  ݲڻ
	*/
	bool get(const char* key, string& buf, unsigned short* flags = NULL);

	/**
	 * ʽʽӷ˻ȡݣЭ
	 * @param key {const void*} ֵ
	 * @param klen {size_t} key ֵ
	 * @param flags {unsigned short*} 洢ı־λ
	 * @return {int} ĳȣΣ
	 *   0ʾ
	 *  -1ʾ
	 *  >0ʾĳ
	 */
	int get_begin(const void* key, size_t klen, unsigned short* flags = NULL);

	/**
	 * ʽʽӷ˻ȡݣЭ
	 * @param key {const char*} ֵַ
	 * @param flags {unsigned short*} 洢ı־λ
	 * @return {int} ĳȣΣ
	 *   0ʾ
	 *  -1ʾ
	 *  >0ʾĳ
	 */
	int get_begin(const char* key, unsigned short* flags = NULL);

	/**
	 * ʽʽӷ˻ȡݣѭñ
	 * @param buf {void*} ַ
	 * @param size {size_t} С
	 * @return {int} ѶݴСΪΣ
	 *  0ʾݶ
	 *  > 0: ʾζݳ
	 *  -1ʾ
	 */
	int  get_data(void* buf, size_t size);

	/**
	*  memcached ɾ
	* @param key {const char*} ֵ
	* @param klen {size_t} ֵ
	* @return {bool} ɾǷɹ
	*/
	bool del(const char* key, size_t klen);

	/**
	*  memcached ɾ
	* @param key {const char*} ֵַ
	* @return {bool} ɾǷɹ
	*/
	bool del(const char* key);

	/**
	* ϴβ memcached Ϣ
	* @return {const char*} ϢΪ
	*/
	const char* last_serror() const;

	/**
	* ϴβ memcached Ĵ
	* @return {int} 
	*/
	int  last_error() const;

	/**
	*  memcached , Ϊ set/get/del Զ
	* memcached ӣԲʾصô˺ memcached
	* 
	* @return {bool} Ƿɹ
	*/
	virtual bool open();

	/**
	* ر memcached ӣһúҪãΪ
	* ʱԶô˺
	*/
	void close();

	/**
	* г memcached ӵһЩԣ
	*/
	void property_list();

private:
	bool set(const string& key, const void* dat, size_t dlen,
		time_t timeout, unsigned short flags);
	bool get(const string& key, string& buf, unsigned short* flags);
	const string& build_key(const char* key, size_t klen);

	string* keypre_;         // ǿʱַ KEY ֵǰµ KEY
	rfc2047 coder_;          // Ҫ KEY ʱı
	int   conn_timeout_;     // ӳʱʱ
	int   rw_timeout_;       //  IO ʱʱ
	bool  encode_key_;       // ǷҪ KEY б

	bool  opened_;           // Ƿ
	bool  retry_;            // Ƿ֧ж
	char* addr_;             // ַ(ip:port)
	int   enum_;             // ţ
	string ebuf_;            // 洢Ϣ
	string kbuf_;            // 洢ת KEY ֵ

	size_t content_length_;  // ʽϴ/شʱֵ¼ܳ
	size_t length_;          // Ѿϴ/صܺ

	socket_stream* conn_;    // ˷Ӷ
	string req_line_;        // 洢
	string res_line_;        // 洢Ӧ
	bool error_happen(const char* line);
};

} // namespace acl
