#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stdlib/log.hpp"
#include "acl_cpp/http/http_header.hpp"

namespace acl {

class socket_stream;
class session;
class HttpServletRequest;
class HttpServletResponse;

/**
 *  HTTP ͻĻ࣬Ҫ̳и
 */
class ACL_CPP_API HttpServlet
{
public:
	HttpServlet(void);
	virtual ~HttpServlet(void) = 0;

	/**
	 * ñַ˱ַڽ HTTP ʱԶ
	 * ַתΪַú doRun ֮ǰòЧ
	 * @param charset {const char*} ַָΪգ
	 *  ַ
	 * @return {HttpServlet&}
	 */
	HttpServlet& setLocalCharset(const char* charset);

	/**
	 *  HTTP Ự̵ IO дʱʱ䣻ú doRun ֮ǰòЧ
	 * @param rw_timeout {int} дʱʱ()
	 * @return {HttpServlet&}
	 */
	HttpServlet& setRwTimeout(int rw_timeout);

	/**
	 *  POST ÷ǷҪݣĬΪú doRun
	 * ֮ǰòЧΪ MIME ʽʹñ˽ݣҲ
	 * н
	 * @param on {bool} ǷҪ
	 * @return {HttpServlet&}
	 */
	HttpServlet& setParseBody(bool on);

	/**
	 *  POST ÷ý󳤶ȣ壬ú doRun
	 * ֮ǰòЧ
	 * @param length {int} 󳤶ƣ峤ȹֱӷ false
	 * @return {HttpServlet&}
	 */
	HttpServlet& setParseBodyLimit(int length);

	/**
	 * HttpServlet ʼУ HTTP 󣬲ص doXXX 麯
	 * @param session {session&} 洢 session ݵĶ
	 * @param stream {socket_stream*}  acl_master ܿ
	 *  ʱòǿգ apache  CGI ʽʱò
	 *  Ϊ NULL⣬úڲرӣӦӦд
	 *  ĹرԷ acl_master ܹ
	 * @return {bool} ش
	 */
	bool doRun(session& session, socket_stream* stream = NULL);

	/**
	 * HttpServlet ʼУ HTTP 󣬲ص doXXX 麯
	 * ñζŲ memcached 洢 session 
	 * @param memcached_addr {const char*} memcached ַʽIP:PORT
	 * @param stream {socket_stream*} ͬ
	 * @return {bool} ش
	 */
	bool doRun(const char* memcached_addr = "127.0.0.1:11211",
		socket_stream* stream = NULL);

	/**
	 *  HTTP Ϊ GET ʽʱ麯
	 */
	virtual bool doGet(HttpServletRequest&, HttpServletResponse&)
	{
		logger_error("child not implement doGet yet!");
		return false;
	}

	/**
	 *  HTTP Ϊ POST ʽʱ麯
	 */
	virtual bool doPost(HttpServletRequest&, HttpServletResponse&)
	{
		logger_error("child not implement doPost yet!");
		return false;
	}

	/**
	 *  HTTP Ϊ PUT ʽʱ麯
	 */
	virtual bool doPut(HttpServletRequest&, HttpServletResponse&)
	{
		logger_error("child not implement doPut yet!");
		return false;
	}

	/**
	 *  HTTP Ϊ CONNECT ʽʱ麯
	 */
	virtual bool doConnect(HttpServletRequest&, HttpServletResponse&)
	{
		logger_error("child not implement doConnect yet!");
		return false;
	}

	/**
	 *  HTTP Ϊ PURGE ʽʱ麯÷ SQUID Ļ
	 * ʱõ
	 */
	virtual bool doPurge(HttpServletRequest&, HttpServletResponse&)
	{
		logger_error("child not implement doPurge yet!");
		return false;
	}

	/**
	 *  HTTP Ϊ DELETE ʽʱ麯
	 */
	virtual bool doDelete(HttpServletRequest&, HttpServletResponse&)
	{
		logger_error("child not implement doPurge yet!");
		return false;
	}

	/**
	 *  HTTP Ϊ HEAD ʽʱ麯
	 */
	virtual bool doHead(HttpServletRequest&, HttpServletResponse&)
	{
		logger_error("child not implement doPurge yet!");
		return false;
	}

	/**
	 *  HTTP Ϊ OPTION ʽʱ麯
	 */
	virtual bool doOption(HttpServletRequest&, HttpServletResponse&)
	{
		logger_error("child not implement doPurge yet!");
		return false;
	}

	/**
	 *  HTTP 󷽷δ֪ʱ麯
	 */
	virtual bool doUnknown(HttpServletRequest&, HttpServletResponse&)
	{
		logger_error("child not implement doUnknown yet!");
		return false;
	}

	/**
	 *  HTTP ʱ麯
	 */
	virtual bool doError(HttpServletRequest&, HttpServletResponse&)
	{
		logger_error("child not implement doError yet!");
		return false;
	}

protected:
private:
	char local_charset_[32];
	int  rw_timeout_;
	bool parse_body_enable_;
	int  parse_body_limit_;
};

} // namespace acl
