#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/db/db_service.hpp"

namespace acl {

class ACL_CPP_API db_service_mysql : public db_service
{
	/**
	 * Ϊ mysql ݿʱĹ캯
	 * @param dbaddr {const char*} mysql ַ
	 * @param dbname {const char*} ݿ
	 * @param dbuser {const char*} ݿû
	 * @param dbpass {const char*} ݿû
	 * @param dbflags {unsigned long} ݿӱ־λ
	 * @param auto_commit {bool} ޸ʱǷԶύ
	 * @param conn_timeout {int} ݿӳʱʱ
	 * @param rw_timeout {int} ݿʱIOдʱʱ
	 * @param dblimit {size_t} ݿӳصĸ
	 * @param nthread {int} ̳߳ص߳
	 * @param win32_gui {bool} ǷǴϢǣڲ
	 *  ͨѶģʽԶΪ WIN32 ϢȻͨõ׽
	 *  ͨѶʽ
	 */
	db_service_mysql(const char* dbaddr, const char* dbname,
		const char* dbuser, const char* dbpass,
		unsigned long dbflags = 0, bool auto_commit = true,
		int conn_timeout = 60, int rw_timeout = 60,
		size_t dblimit = 100, int nthread = 2, bool win32_gui = false);

	~db_service_mysql(void);

private:
	// ݿַ
	string dbaddr_;
	// ݿ
	string dbname_;
	// ݿû
	string dbuser_;
	// ݿû
	string dbpass_;
	// ݿӱ־λ
	unsigned long dbflags_;
	// ޸ʱǷԶύ
	bool auto_commit_;
	// ݿⳬʱʱ
	int conn_timeout_;
	// ݿʱĶдʱʱ
	int rw_timeout_;

	// ി麯
	virtual db_handle* db_create(void);
};

}
