#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <list>

namespace acl {

class db_handle;
class locker;

class ACL_CPP_API db_pool
{
public:
	/**
	 * ݿ⹹캯
	 * @param dblimit {int} ݿӳص
	 */
	db_pool(int dblimit = 64);
	virtual ~db_pool();

	/**
	 * ݿӳػһݿ󣬸úݿû
	 * db_handle::open ݿӣȻʹøݿӶ
	 *  db_pool->put(db_handle*) ӹ黹ݿӳأ
	 * ɸúõӾ deleteӳصڲ
	 * @return {db_handle*} ؿգʾ
	 */
	db_handle* peek();

	/**
	 * ݿӳػһݿ󣬲Ҫݿӣû
	 * ʽٵ db_handle::open ̣
	 *  db_pool->put(db_handle*) ӹ黹ݿӳأ
	 * ɸúõӾ deleteӳصڲ
	 * @param charset {const char*} ݿʱʹõַ
	 * @return {db_handle*} ݿӶ󣬷ؿձʾ
	 */
	db_handle* peek_open(const char* charset = "utf8");

	/**
	 * ݿӷŻӳУݿӳл
	 * ӦͨúŻأֱ deleteΪ
	 * ᵼӳصڲ
	 * @param conn {db_handle*} ݿӾӾ
	 *   peek ģҲԵ̬
	 * @param keep {bool} 黹ӳصݿӾǷ
	 *  ӣڲԶɾӾ
	 */
	void put(db_handle* conn, bool keep = true);

	/**
	 * ݿӳеĹͷŵԼٶԺݿ
	 * @param ttl {time_t} ݿӵĿʱڵڴֵʱ
	 *  ӽͷţ idle Ϊ 0 ʱҪͷеݿ;
	 *  Ϊ -1 ʱ򲻽ͷӲ
	 * @param exclusive {bool} ڲǷҪӻ
	 * @return {int} ͷŵݿӵĸ(>= 0)
	 */
	int check_idle(time_t ttl, bool exclusive = true);

	/**
	 * ӳпӵڣͨݿ
	 * ں(idle >= 0)û db_pool::put ʱԶ
	 * Ӳرգڲһֱ
	 * @param idle {int} ӳпӵӴʱ䣬ֵ
	 *  Ϊ -1 ʱʾӣΪ 0 ʱʾڲκγ
	 * @return {db_pool&}
	 */
	db_pool& set_idle(int idle);

	/**
	 * ԶӵʱȱʡֵΪ 30 
	 * @param n {int} ʱ
	 * @return {db_pool&}
	 */
	db_pool& set_check_inter(int n);

	/**
	 * õǰݿӳص
	 * @return {int}
	 */
	int get_dblimit() const
	{
		return dblimit_;
	}

	/**
	 * õǰݿӳصǰ
	 * @return {int}
	 */
	int get_dbcount() const
	{
		return dbcount_;
	}
protected:
	/**
	 * 麯 DB ķ
	 * @return {db_handle*}
	 */
	virtual db_handle* create() = 0;
private:
	std::list<db_handle*> pool_;
	int   dblimit_;  // ӳص
	int   dbcount_;  // ǰѾ򿪵
	locker* locker_;
	char  id_[128];  // ʵΨһ ID ʶ
	time_t ttl_;     // ӳпӱͷŵĳʱֵ
	time_t last_check_;  // ϴμӵʱ
	int    check_inter_; // ӵʱ

	// ñʵΨһ ID ʶ
	void set_id();
};

} // namespace acl
