/*
 * @file	mymalloc.h
 * @author	zsx
 * @date	2003-12-15
 * @version	1.0
 * @brief	ļΪʹACLʱĸ߼ڴӿڣûӦҪʹô˽ӿ
 *		ڴķ估ͷ, ûе acl_mem_hook.h еĺ
 *		ӿעԼڴͷŵȹӿڣٵ acl_myxxx 
 *		ĺʱԶлûԼڴӿڵ
 */

#ifndef	ACL_MYMALLOC_INCLUDE_H
#define	ACL_MYMALLOC_INCLUDE_H

#ifdef  __cplusplus
extern "C" {
#endif

#include "acl_define.h"
#include "acl_malloc.h"

/**
 * ̬ڴĺ궨壬ʼ·ڴռ
 * @param size {size_t} 䳤
 * @return {void *}
 */
#define acl_mymalloc(size) acl_malloc_glue(__FILE__, __LINE__, size)

/**
 * ̬ڴĺ궨壬ʼ·ڴռΪ
 * @param nmemb {size_t} Ԫظ
 * @param size {size_t} ÿԪصĳ
 * @return {void *}
 */
#define acl_mycalloc(nmemb, size) acl_calloc_glue(__FILE__, __LINE__, nmemb, size)

/**
 * ¶̬ڴĺ궨
 * @param ptr {void*} ԭڴַ
 * @param size {size_t} ·ڴʱҪĳ
 * @return {void *}
 */
#define acl_myrealloc(ptr, size) acl_realloc_glue(__FILE__, __LINE__, (ptr), size)

/**
 * ַ̬궨
 * @param str {const char*} Դַ
 * @return {char*} µַ acl_myfree ͷ
 */
#define acl_mystrdup(str) acl_strdup_glue(__FILE__, __LINE__, (str))

/**
 * ַ̬궨壬޶ڴռС
 * @param str {const char*} Դַ
 * @param len {size_t} ַڴռСֵ
 * @return {char*} µַ acl_myfree ͷ
 */
#define acl_mystrndup(str, len) acl_strndup_glue(__FILE__, __LINE__, (str), len)

/**
 * ̬ڴ궨
 * @param ptr {const void*} Դڴַ
 * @param len {size_t} ԴڴС
 * @return {void*} µַ acl_myfree ͷ
 */
#define acl_mymemdup(ptr, len) acl_memdup_glue(__FILE__, __LINE__, (ptr), len)

/**
 * ͷŶ̬ڴռ
 * @param _ptr_ {void*} ̬ڴַ
 */
#define acl_myfree(_ptr_) do {  \
	acl_free_glue(__FILE__, __LINE__, (_ptr_));  \
	(_ptr_) = NULL;  \
} while (0)

/**
 * XXX: Ϊúڻص޷к궨ת, ƴ˺
 */
#define	acl_myfree_fn acl_free_fn_glue

#ifdef  __cplusplus
}
#endif

#endif

