#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stream/istream.hpp"
#include "acl_cpp/stream/ostream.hpp"

namespace acl {

class string;

class ACL_CPP_API fstream
	: public istream
	, public ostream
{
public:
	fstream(void);
	virtual ~fstream(void);

	/**
	 * ļ·ļ, Ĵļķʽ
	 * @param path {const char*} ļ
	 * @param oflags {unsigned int} ־λ, We're assuming that O_RDONLY: 0x0000,
	 *  O_WRONLY: 0x0001, O_RDWR: 0x0002, O_APPEND: 0x0008, O_CREAT: 0x0100,
	 *  O_TRUNC: 0x0200, O_EXCL: 0x0400; just for win32, O_TEXT: 0x4000,
	 *  O_BINARY: 0x8000, O_RAW: O_BINARY, O_SEQUENTIAL: 0x0020, O_RANDOM: 0x0010.
	 * @param mode {int} ļʱģʽ(: 0600)
	 * @return {bool} ļǷɹ
	 */
	bool open(const char* path, unsigned int oflags, int mode);

	/**
	 * Զ/дʽļļʱ򴴽ļļʱ
	 * ļ, ļΪ 0700
	 * @param path {const char*} ļ
	 * @return {bool} ļǷɹ
	 */
	bool open_trunc(const char* path);

	/**
	 * Զ/дʽļļΪ 0700, ļ򴴽ļ
	 * 򿪾ļ
	 * @return {bool} ļǷɹ
	 */
	bool create(const char* path);

#ifdef WIN32
	/**
	 * ϵͳļ fstream ļ
	 * @param fh ϵͳļ
	 * @param oflags 򿪱־λ
	 */
	void open(void* fh, unsigned int oflags);

	/**
	 * ƶļָλ
	 * @param offset {__int64} ƫ
	 * @param whence {int} ƶSEEK_SETļʼλúƶ,
	 *  SEEK_CURӵǰļָλƶ, SEEK_ENDļβǰƶ
	 * @return {acl_off_t} ʱֵ >= 0ʱ -1
	 */
	__int64 fseek(__int64 offset, int whence);

	/**
	 * õǰϵͳļָļеƫλ
	 * @return {acl_off_t} ʱֵ >= 0ʱ -1
	 */
	__int64 ftell();

	/**
	 * ļߴضָС
	 * @param length {acl_off_t} ļضϺĴСߴ
	 * @return {bool} Ƿɹ
	 */
	bool ftruncate(__int64 length);

	/**
	 * õǰļĴС
	 * @return {acl_off_t} ʱֵ >= 0 -1
	 */
	__int64 fsize(void) const;

	/**
	 * ϵͳļ
	 * @return ϵͳļʱ ACL_FILE_INVALID
	 */
	void* file_handle() const;
#else
	void open(int fh, unsigned int oflags);
	long long int fseek(long long int offset, int whence);
	long long int ftell();
	bool ftruncate(long long int length);
	long long int fsize(void) const;
	int file_handle() const;
#endif
	/**
	 * ļȫ·
	 * @return {const char*} ؿʾļδ򿪻
	 */
	const char* file_path() const;
};

} // namespace acl
