#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <vector>
#include "acl_cpp/http/http_header.hpp"
#include "acl_cpp/http/http_ctype.hpp"
#include "acl_cpp/http/http_type.hpp"

namespace acl {

class istream;
class ostream;
class socket_stream;
class http_client;
class http_mime;
class session;
class HttpSession;
class HttpCookie;
class HttpServletResponse;

/**
 *  HTTP ͻص࣬಻Ӧ̳УûҲҪ
 * 򴴽
 */
class ACL_CPP_API HttpServletRequest
{
public:
	/**
	 * 캯
	 * @param res {HttpServletResponse&}
	 * @param store {session&} 洢ỰݵĶ
	 * @param stream {socket_stream&} ڲر
	 * @param local_charset {const char*} ֵַǿʱ
	 *  ڲԶ HTTP תΪַת
	 * @param body_parse {bool}  POST òָǷҪ
	 *  ȡ HTTP 岢 n/v ʽзΪ true 
	 *  ȡ HTTP ݣзû getParameter
	 *  ʱԻ URL еĲͬʱԻ POST 
	 *  ĲòΪ false ʱ򲻶ȡ壬Ѷ
	 *  ദ
	 * @param body_limit {int}  POST Ϊı
	 *  ʱ˲ĳȣΪ MIME
	 *  ʽ body_read Ϊ false˲Ч
	 */
	HttpServletRequest(HttpServletResponse& res, session& store,
		socket_stream& stream, const char* local_charset = NULL,
		bool body_parse = true, int body_limit = 102400);
	~HttpServletRequest(void);

	/**
	 *  HTTP ͻ󷽷GET, POST, PUT, CONNECT, PURGE
	 * @return {http_method_t}
	 */
	http_method_t getMethod(void) const;

	/**
	 *  HTTP ͻ cookie 󼯺
	 * @return {const std::vector<HttpCookie*>&}
	 */
	const std::vector<HttpCookie*>& getCookies(void) const;

	/**
	 *  HTTP ͻĳ cookie ֵ
	 * @param name {const char*} cookie ƣǿ
	 * @return {const char*} cookie ֵ NULL ʱʾ
	 *  cookie ֵ
	 */
	const char* getCookieValue(const char* name) const;

	/**
	 *  HTTP  cookie 
	 * @param name {const char*} cookie ǿַ
	 * @param value {const char*} cookie ֵǿַ
	 */
	void setCookie(const char* name, const char* value);

	/**
	 *  HTTP ͷеĳֵֶ
	 * @param name {const char*} HTTP ͷеֶǿ
	 * @return {const char*} HTTP ͷеֵֶ NULL
	 *  ʱʾ
	 */
	const char* getHeader(const char* name) const;

	/**
	 *  HTTP GET ʽ URL еĲ֣ ? Ĳ
	 * @return {const char*} ûнURL ֣
	 *   NULL ʾ URL ûв
	 */
	const char* getQueryString(void) const;

	/**
	 *   http://test.com.cn/cgi-bin/test?name=value е
	 * /cgi-bin/test ·
	 * @return {const char*} ؿձʾڣ
	 */
	const char* getPathInfo(void) const;

	/**
	 *   http://test.com.cn/cgi-bin/test?name=value е
	 * /cgi-bin/test?name=value ·
	 * @return {const char*} ؿձʾڣ
	 */
	const char* getRequestUri(void) const;

	/**
	 *  HTTP Ựص HttpSession 
	 * @param create {bool}  session ʱǷڻԶ
	 *  ĳͻ˵ session ҸòΪ false ʱú
	 *  ص session ûб޷жд
	 * @param sid {const char*}  session ڣ create ǿʱ
	 *   sid ǿգʹôֵûΨһỰͬʱӽͻ˵
	 *  cookie 
	 * @return {HttpSession&}
	 *  עȼ COOKIE > create = true > sid != NULL
	 */
	HttpSession& getSession(bool create = true, const char* sid = NULL);

	/**
	 *  HTTP ͻӹ
	 * @return {istream&}
	 */
	istream& getInputStream(void) const;

	/**
	 *  HTTP ݵݳ
	 * @return {acl_int64}  -1 ʾΪ GET 
	 *   HTTP ͷû Content-Length ֶ
	 */
#ifdef WIN32
	__int64 getContentLength(void) const;
#else
	long long int getContentLength(void) const;
#endif
	/**
	 *  HTTP ͷ Content-Type: text/html; charset=gb2312
	 * Content-Type ֵֶ
	 * @param part {bool} Ϊ true 򷵻 text򷵻
	 * ֵ磺text/html; charset=gb2312
	 * @return {const char*}  NULL ʾ Content-Type ֶβ
	 */
	const char* getContentType(bool part = true) const;

	/**
	 *  HTTP ͷе Content-Type: text/html; charset=gb2312
	 * е charset ֵֶ gb2312
	 * @return {const char*}  NULL ʾ Content-Type ֶ 
	 *  charset=xxx 
	 */
	const char* getCharacterEncoding(void) const;

	/**
	 * رصֶַ
	 * @ return {const char*}  NULL ʾûñַ
	 */
	const char* getLocalCharset(void) const;

	/**
	 *  HTTP ӵı IP ַ
	 * @return {const char*} ؿգʾ޷
	 */
	const char* getLocalAddr(void) const;

	/**
	 *  HTTP ӵı PORT 
	 * @return {unsigned short}  0 ʾ޷
	 */
	unsigned short getLocalPort(void) const;

	/**
	 *  HTTP ӵԶ̿ͻ IP ַ
	 * @return {const char*} ؿգʾ޷
	 */
	const char* getRemoteAddr(void) const;

	/**
	 *  HTTP ӵԶ̿ͻ PORT 
	 * @return {unsigned short}  0 ʾ޷
	 */
	unsigned short getRemotePort(void) const;

	/**
	 *  HTTP ͷõ Host ֶ
	 * @return {const char*} Ϊգʾ
	 */
	const char* getRemoteHost(void) const;

	/**
	 *  HTTP ͷõ User-Agent ֶ
	 * @return {const char*} Ϊգʾ
	 */
	const char* getUserAgent(void) const;

	/**
	 *  HTTP еĲֵֵѾ URL 
	 * תɱҪַ GET ǻ
	 * URL  ? Ĳֵ POST Ի
	 * URL  ? ĲֵеĲֵ
	 */
	const char* getParameter(const char* name) const;

	/**
	 *  HTTP ͷе Content-Type Ϊ
	 * multipart/form-data; boundary=xxx ʽʱ˵Ϊļϴ
	 * ͣͨ˺ http_mime 
	 * @return {const http_mime*}  NULL ˵û MIME 
	 *  صֵûֹͷţΪ HttpServletRequest 
	 *  лԶͷ
	 */
	http_mime* getHttpMime(void) const;

	/**
	 *  HTTP ݵ
	 * @return {http_request_t}һ POST еϴ
	 *  ļӦöԣҪøúǷϴͣ
	 *  ú HTTP_REQUEST_OTHER ʱûͨ
	 *  getContentType þַ
	 */
	http_request_t getRequestType(void) const;

	/**
	 *  HTTP ҳ referer URL
	 * @return {const char*} Ϊ NULL ˵ûֱӷʱ URL
	 */
	const char* getRequestReferer(void) const;

	/**
	 * ø HTTP ͷõ http_ctype 
	 * @return {const http_ctype&}
	 */
	const http_ctype& getHttpCtype(void) const;

	/**
	 * ж HTTP ͻǷҪ󱣳ֳ
	 * @return {bool}
	 */
	bool isKeepAlive(void) const;

	/**
	 * ͻҪ󱣳ֳʱ HTTP ͷлñֵʱ
	 * @return {int} ֵ < 0 ʾ Keep-Alive ֶ
	 */
	int getKeepAlive(void) const;

	/*
	 *  HTTP Ϊ POST ͨö HTTP 
	 * IO ʱʱֵ()
	 * @param rw_timeout {int} ʱĳʱʱ()
	 */
	void setRwTimeout(int rw_timeout);

	/**
	 * ϴγĴ
	 * @return {http_request_error_t}
	 */
	http_request_error_t getLastError(void) const;

	/**
	 *  HttpServlet Էģʽ( CGI ʽ)ʱԵô
	 * ÿͻӵ HTTP 󣬴ӶøĲ
	 * @return {http_client*} Էģʽʱ˺ HTTP ͻ
	 *  ӷǿն󣻵 CGI ʽʱ򷵻ؿָ
	 */
	http_client* getClient(void) const;

	/**
	 *  HTTP ͷУļ
	 * @param out {ostream&}
	 * @param prompt {const char*} ʾ
	 */	 
	void fprint_header(ostream& out, const char* prompt);
private:
	http_request_error_t req_error_;
	char cookie_name_[64];
	HttpServletResponse& res_;
	session& store_;
	HttpSession* http_session_;
	socket_stream& stream_;
	bool body_parse_;
	int  body_limit_;

	std::vector<HttpCookie*> cookies_;
	bool cookies_inited_;
	http_client* client_;
	http_method_t method_;
	bool cgi_mode_;
	http_ctype content_type_;
	char localAddr_[32];
	char remoteAddr_[32];
	char localCharset_[32];
	int  rw_timeout_;
	std::vector<HTTP_PARAM*> params_;
	http_request_t request_type_;
	http_mime* mime_;

	bool readHeaderCalled_;
	bool readHeader(void);

	void parseParameters(const char* str);
};

} // namespace acl
