#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/db/db_handle.hpp"

typedef struct sqlite3 sqlite3;

namespace acl {

class charset_conv;

class ACL_CPP_API db_sqlite : public db_handle
{
public:
	db_sqlite(const char* dbfile);
	~db_sqlite(void);

	/**
	 * صǰ sqlite İ汾Ϣ
	 */
	const char* version(void) const;

	/**
	 * ݿ򿪺ͨ˺ݿĲã
	 * õҪϸѭ sqlite ѡҪ
	 * @param pragma {const char*} ѡݣʽΪ
	 *  PRAGMA xxx=xxx
	 *  磺PRAGMA synchronous = NORMAL
	 * @return {bool} ݿǷɹ
	 */
	bool set_conf(const char* pragma);

	/**
	 * ݿ򿪵ô˺ѡ
	 * @param pragma {const char*} ѡݣʽΪ
	 *  PRAGMA xxx
	 *  磺PRAGMA synchronous
	 * @param out {string&} ֵǿ洢
	 * @return {const char*} Ϊ˵òڻݿδ
	 */
	const char* get_conf(const char* pragma, string& out);

	/**
	 * ݿ򿪵ݿѡ
	 * @param pragma {const char*} ָѡòΪգ
	 *  еѡʽΪPRAGMA xxx磺PRAGMA synchronous
	 */
	void show_conf(const char* pragma = NULL);

	/**
	 * ݿ򿪺еӰļ¼
	 * @return {int} Ӱ-1 ʾ
	 */
	int affect_total_count() const;

	/**
	 * ֱӻ sqlite ľ NULL ʾ sqlite ûд
	 * ʱڲԶر sqlite
	 * @return {sqlite3*}
	 */
	sqlite3* get_conn() const
	{
		return db_;
	}

	/************************************************************************/
	/*            Ϊ db_handle ӿ                             */
	/************************************************************************/

	/**
	 * ݿ
	 * @return {const char*}
	 */
	virtual const char* dbtype() const;

	/**
	 * ϴݿĳ
	 * @return {int}
	 */
	virtual int get_errno() const;

	/**
	 * ϴݿĳ
	 * @return {const char*}
	 */
	virtual const char* get_error() const;

	/**
	 *  db_handle Ĵӿ
	 * @param local_charset {const char*} ַ
	 * @return {bool} Ƿɹ
	 */
	virtual bool open(const char* local_charset = "GBK");

	/**
	 *  db_handle ĴӿڣݿǷѾ
	 * @return {bool}  true ݿѾ
	 */
	virtual bool is_opened() const;

	/**
	 *  db_handle Ĵӿ
	 * @return {bool} رǷɹ
	 */
	virtual bool close(void);

	/**
	 *  db_handle Ĵӿڣʵִ˽ӿжݱǷ
	 * @return {bool} Ƿ
	 */
	virtual bool tbl_exists(const char* tbl_name);

	/**
	 *  db_handle Ĵӿ
	 * @param sql {const char*} ׼ SQL 䣬ǿգһҪע
	 *  SQL 뾭ת崦Էֹ SQL ע빥
	 * @return {bool} ִǷɹ
	 */
	virtual bool sql_select(const char* sql);

	/**
	 *  db_handle Ĵӿ
	 * @param sql {const char*} ׼ SQL 䣬ǿգһҪע
	 *  SQL 뾭ת崦Էֹ SQL ע빥
	 * @return {bool} ִǷɹ
	 */
	virtual bool sql_update(const char* sql);

	/**
	 *  db_handle Ĵӿڣϴ sql Ӱļ¼
	 * @return {int} Ӱ-1 ʾ
	 */
	virtual int affect_count() const;
private:
	// sqlite 
	sqlite3* db_;

	// ݴ洢ļ
	string dbfile_;

	// ַת
	charset_conv* conv_;

	// ַ
	string local_charset_;

	// ִSQLѯĺ
	bool exec_sql(const char* sql);
};

} // namespace acl
