#include "acl_stdafx.hpp"
#include <utility>
#include "acl_cpp/stdlib/snprintf.hpp"
#include "acl_cpp/stdlib/log.hpp"
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/stdlib/escape.hpp"
#include "acl_cpp/session/session.hpp"

namespace acl
{

session::session(time_t ttl /* = 0 */, const char* sid /* = NULL */)
: sid_(64)
, ttl_(ttl)
, dirty_(false)
{
	struct timeval tv;

	(void) gettimeofday(&tv, NULL);
	if (sid == NULL || *sid == 0)
	{
		sid_.format("acl.%d.%d.%d", (int) tv.tv_sec,
			(int) tv.tv_usec, rand());
		sid_.todo_ = TODO_NUL;
		sid_saved_ = false;
	}
	else
	{
		sid_.copy(sid);
		sid_.todo_ = TODO_NUL;
		sid_saved_ = true;
	}
}

session::~session()
{
	reset();
}

void session::set_sid(const char* sid)
{
	sid_.copy(sid);
	sid_.todo_ = TODO_NUL;

	// пѾ洢ں cache 
	if (!sid_saved_)
		sid_saved_ = true;

	// ϴεм
	reset();
}

void session::reset()
{
	attrs_clear(attrs_);
	attrs_clear(attrs_cache_);
}

void session::attrs_clear(std::map<string, session_string>& attrs)
{
	attrs.clear();
}

bool session::flush()
{
	if (!dirty_)
		return true;
	dirty_ = false;

	// ôӿڣԭ sid 
	if (get_attrs(attrs_) == true)
	{
		if (!sid_saved_)
			sid_saved_ = true;
	}

	std::map<string, session_string>::iterator it_cache =
		attrs_cache_.begin();
	for (; it_cache != attrs_cache_.end(); ++it_cache)
	{
		// ѴڣҪͷԭֵֵ

		std::map<string, session_string>::iterator it_attr =
			attrs_.find(it_cache->first);
		if (it_attr == attrs_.end())
		{
			if (it_cache->second.todo_ == TODO_SET)
				attrs_.insert(std::make_pair(it_cache->first,
					it_cache->second));
		}
		else if (it_cache->second.todo_ == TODO_SET)
		{
			// µ
			attrs_.insert(std::make_pair(it_cache->first,
				it_cache->second));
		}
		else if (it_cache->second.todo_ == TODO_DEL)
		{
			attrs_.erase(it_attr);
		}
		else
		{
			logger_warn("unknown todo(%d)",
				(int) it_cache->second.todo_);
		}
	}

	// ݣΪڲѾ attrs_ У
	// ֻҪ attrs_cache_ ռ
	attrs_cache_.clear();

	// ôӿڣ memcached ƻ
	if (set_attrs(attrs_) == false)
	{
		logger_error("set cache error, sid(%s)", sid_.c_str());
		attrs_clear(attrs_);  // Լ

		return false;
	}

	attrs_clear(attrs_);  // Լ

	if (!sid_saved_)
		sid_saved_ = true;
	return true;
}

bool session::set(const char* name, const char* value)
{
	return set(name, value, strlen(value));
}

bool session::set_delay(const char* name, const void* value, size_t len)
{
	session_string ss(len);
	ss.copy(value, len);
	ss.todo_ = TODO_SET;
	attrs_cache_.insert(std::make_pair(string(name), ss));

	dirty_ = true;
	return true;
}

bool session::set(const char* name, const void* value, size_t len)
{
	// ֱӲ cache (/޸) ֶ

	// ôӿڣԭ sid 
	if (get_attrs(attrs_) == false)
	{
		session_string ss(len);
		ss.copy(value, len);
		ss.todo_ = TODO_SET;
		attrs_cache_.insert(std::make_pair(string(name), ss));
	}
	// ڶӦ sid ݣԭ
	else
	{
		if (!sid_saved_)
			sid_saved_ = true;

		// ѴڣҪͷԭֵֵ
		session_string ss(len);
		ss.copy(value, len);
		ss.todo_ = TODO_SET;
		attrs_cache_.insert(std::make_pair(string(name), ss));
	}

	// ôӿڣ memcached ƻ
	if (set_attrs(attrs_) == false)
	{
		logger_error("set cache error, sid(%s)", sid_.c_str());
		attrs_clear(attrs_);  // Լ

		return false;
	}
	attrs_clear(attrs_);  // Լ

	if (!sid_saved_)
		sid_saved_ = true;
	return true;
}

const char* session::get(const char* name)
{
	const session_string* bf = get_buf(name);
	if (bf == NULL)
		return "";
	return bf->c_str();
}

const session_string* session::get_buf(const char* name)
{
	if (get_attrs(attrs_) == false)
		return NULL;

	std::map<string, session_string>::const_iterator cit = attrs_.find(name);
	if (cit == attrs_.end())
		return NULL;
	return &cit->second;
}

bool session::set_ttl(time_t ttl, bool delay)
{
	if (ttl == ttl_)
		return true;

	// ӳ޸ģسԱͳһ flush
	else if (delay)
	{
		ttl_ = ttl;
		dirty_ = true;
		return true;
	}

	//  sid ûں cache ϴ洢ڶбһ
	else if (!sid_saved_)
	{
		ttl_ = ttl;
		return true;
	}

	// ޸ĺ cache Ը sid  ttl
	else if (set_timeout(ttl) == true)
	{
		ttl_ = ttl;
		return true;
	}
	else
		return false;
}

bool session::del_delay(const char* name)
{
	std::map<string, session_string>::iterator it = attrs_cache_.find(name);
	if (it != attrs_cache_.end())
		it->second.todo_ = TODO_DEL;
	dirty_ = true;
	return true;
}

bool session::del(const char* name)
{
	// ֱӲ cache ɾֶ

	if (get_attrs(attrs_) == false)
		return true;

	std::map<string, session_string>::iterator it = attrs_.find(name);
	if (it == attrs_.end())
		return false;

	// ɾͷŶӦĶ
	attrs_.erase(it);

	//  sid ѾûݣӦý sid  memcached ɾ
	if (attrs_.empty())
	{
		// 麯ɾ sid ӦĻ
		if (remove() == false)
		{
			logger_error("del sid(%s) error", sid_.c_str());
			return false;
		}
		return true;
	}

	// ʣ

	if (set_attrs(attrs_) == false)
	{
		logger_error("set cache error, sid(%s)", sid_.c_str());
		attrs_clear(attrs_);  // Լ

		return false;
	}
	attrs_clear(attrs_);  // Լ

	return true;
}

//  handlersocket ı뷽ʽ

void session::serialize(const std::map<string, session_string>& attrs,
	string& out)
{
	out.clear(); // 

	std::map<string, session_string>::const_iterator it = attrs.begin();
	if (it == attrs.end())
		return;

	// ӵһ
	const char ch = 1;
	escape(it->first.c_str(), it->first.length(), out);
	escape(&ch, 1, out);
	escape(it->second.c_str(), it->second.length(), out);
	++it;

	// Ӻ
	for (; it != attrs.end(); ++it)
	{
		// һĶҪӷָ
		out << '\t';
		escape(it->first.c_str(), it->first.length(), out);
		escape(&ch, 1, out);
		escape(it->second.c_str(), it->second.length(), out);
	}
}

//  handlersocket Ľ뷽ʽ

void session::deserialize(string& buf, std::map<string, session_string>& attrs)
{
	attrs_clear(attrs);  //  session ǰһβѯ״̬

	ACL_ARGV* tokens = acl_argv_split(buf.c_str(), "\t");
	ACL_ITER  iter;
	acl_foreach(iter, tokens)
	{
		char* ptr = (char*) iter.data;

		// ظʹԭڴΪ tokens Ѿ洢м
		buf.clear();
		if (unescape(ptr, strlen(ptr), buf) == false)
		{
			logger_error("unescape error");
			continue;
		}
		ptr = buf.c_str();
		// Ϊ acl::string ϶ܱ֤ݵβ \0
		// strchr ʱ뵣Խ⣬ std::string ֤
		char* p1 = strchr(ptr, 1);
		if (p1 == NULL || *(p1 + 1) == 0)
			continue;
		*p1++ = 0;
		//std::map<string, session_string>::iterator it = attrs.find(ptr);

		size_t len = buf.length() - (p1 - buf.c_str());
		session_string ss(len);
		ss.copy(p1, len);
		ss.todo_ = TODO_SET;
		attrs.insert(std::make_pair(string(ptr), ss));
	}

	acl_argv_free(tokens);
}

} // namespace acl
