#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <vector>
#include <list>
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/stdlib/pipe_stream.hpp"
#include "acl_cpp/stdlib/xml.hpp"

struct ACL_XML;
struct ACL_XML_NODE;
struct ACL_XML_ATTR;

/**
 *  ACL  XML ķװ C++ ûʹã̫עأ
 * ֱʹø࣬ڷִҷǳעܣֱʹ ACL 
 * XML ΪҲǵ ACL е XML ̣жο
 * ̣ܻ΢ӰһЩܣһӦӰ΢
 */

namespace acl {

class xml1;
class xml1_node;

class ACL_CPP_API xml1_attr : public xml_attr
{
public:
	/**
	 * @override 
	 * @return {const char*} Զ᷵ؿָ룬ֵ
	 *  пΪ "\0"
	 */
	const char* get_name(void) const;

	/**
	 * @override ֵ
	 * @return {const char*} ֵԶ᷵ؿָ룬ֵ
	 *  пΪ "\0"
	 */
	const char* get_value(void) const;

protected:
	friend class xml1_node;

	xml1_attr(xml_node* node, ACL_XML_ATTR* attr);
	~xml1_attr(void) {}

private:
	ACL_XML_ATTR* attr_;
};

class ACL_CPP_API xml1_node : public xml_node
{
public:
	/**
	 * @override ȡñ XML ڵıǩ
	 * @return {const char*}  XML ڵǩؿգ˵
	 *  ڱǩ xxxxԷһҪжϷֵ
	 */
	const char* tag_name(void) const;

	/**
	 * @override  XML ڵ ID Բڣ򷵻ؿָ
	 * @return {const char*}  ID ԴʱضӦֵ򷵻ؿ
	 */
	const char* id(void) const;

	/**
	 * @override ظ XML ڵ
	 * @return {const char*} ؿ˵û
	 */
	const char* text(void) const;

	/**
	 * @override ظ XML ڵĳֵ
	 * @param name {const char*} 
	 * @return {const char*} ֵؿ˵Բ
	 */
	const char* attr_value(const char* name) const;

	/**
	 * @override ڵʱҪô˺õһԶ
	 * @return {const xml_attr*} صһԶΪգʾ
	 *  ýڵû
	 */
	const xml_attr* first_attr(void) const;

	/**
	 * @override ڵʱñһԶ
	 * @return {const xml_attr*} һԶΪգʾ
	 *  
	 */
	const xml_attr* next_attr(void) const;

	/**
	 * @override  XML ڵ
	 * @param name {const char*} 
	 * @param value {const char*} ֵ
	 * @return {xml_node&}
	 */
	xml_node& add_attr(const char* name, const char* value);

	/**
	 * @override  xml ڵı
	 * @param str {const char*} ַ
	 * @return {xml_node&}
	 */
	xml_node& set_text(const char* str);

	/**
	 * @override  xml ڵ xml_node ӽڵ
	 * @param child {xml_node*} ӽڵ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {xml_node&} return_child Ϊ true ӽڵã
	 *  򷵻ر xml ڵ
	 */
	xml_node& add_child(xml_node* child, bool return_child = false);

	/**
	 * @override ڵ㼰ӽڵ xml з룬ڴ潫 xml
	 *  ͳһͷ
	 * @return {int} رͷŵĽڵ
	 */
	int detach(void);

	/**
	 * @override ñڵĸڵ
	 * @return {xml_node&}
	 */
	xml_node& get_parent(void) const;

	/**
	 * @override ñڵһӽڵ㣬ӽڵʱȵô˺
	 * @return {xml_node*} ؿձʾûӽڵ
	 */
	xml_node* first_child(void);

	/**
	 * @override ñڵһӽڵ
	 * @return {xml_node*} ؿձʾ̽
	 */
	xml_node* next_child(void);

	/**
	 * @override ظ XML ڵ XML е
	 * @return {int}
	 */
	int depth(void) const;

	/**
	 * @override
	 * @return {bool}
	 */
	bool is_root(void) const;

	/**
	 * @override ظ xml ڵһӽڵĸ
	 * @return {int} Զ >= 0
	 */
	int children_count(void) const;

public:
	/**
	 * ȡӦ ACL е XML ڵ
	 * @return {ACL_XML_NODE*} ؽڵעýڵûܵͷ
	 */
	ACL_XML_NODE* get_xml_node(void) const;

	/**
	 * ñڵĸڵ
	 * @param node {xml_node*} ڵ
	 * @return {xml_node&} رڵ
	 */
	xml_node& set_parent(xml_node* node);

protected:
	friend class xml1;

	/**
	 * xml ڵ㹹캯
	 * @param xml_ptr {xml*} xml 󣬷ǿ
	 * @param node {ACL_XML_NODE*} C е xml ڵָ
	 */
	xml1_node(xml* xml_ptr, ACL_XML_NODE* node);

	/**
	 * ҪöǶ̬
	 */
	~xml1_node(void);

private:
	ACL_XML_NODE *node_;
	ACL_ITER* child_iter_;
	ACL_ITER* attr_iter_;

	xml_node* parent_;
	xml1_node* parent_internal_;
};

class string;

class ACL_CPP_API xml1 : public xml
{
public:
	/**
	 * 캯
	 * @param data {const char*} xml ʽַ
	 *  xml ַҲǲֵ xml ַҲǿָ룬
	 *  ΣûȻòֻ xml ַ update
	 *  ڵ update н xmlʵ캯
	 *   data ǿʱҲ update
	 */
	xml1(const char* data = NULL);
	~xml1(void);

	/**
	 * @override ڷǱպϵıǩǷҪԱպַ '/'ȱʡΪ
	 * @param on {bool}
	 * @return {xml&}
	 */
	xml& ignore_slash(bool on);

	/**
	 * @override ǷԶ xml 룬ȱΪ
	 * @param on {bool}
	 * @return {xml&}
	 */
	xml& xml_decode(bool on);

	/**
	 * @override ʽʽѭñ XML ݣҲһ
	 *  XML ݣظʹø XML  XML
	 * Ӧڽһ XML ǰ reset() 
	 * һεĽ
	 * @param data {const char*} xml 
	 */
	void update(const char* data);

	/**
	 * @override  XML ״̬ XML Զ XML 
	 * нڷʹñ XML ǰҪñ
	 * ڲ XML ״̬һεĽ
	 */
	void reset(void);

	/**
	 * @override ӽ XML ԭʼнȡı
	 * @return {const string&} ؽã
	 *  ûҪͷ
	 */
	const string& getText(void);

	/**
	 * @override  XML ȡĳǩнڵ㼯
	 * @param tag {const char*} ǩ(ִСд)
	 * @return {const std::vector<xml_node*>&} ؽĶã
	 *  ѯΪգüΪգempty() == true
	 *  עصе xml_node ڵݿ޸ģɾýڵ㣬
	 *  ΪÿڲԶɾĻ
	 */
	const std::vector<xml_node*>&
		getElementsByTagName(const char* tag) const;

	/**
	 * @override  xml лöӦǩĵһ xml ڵ
	 * @param tag {const char*} ǩ(ִСд)
	 * @return {xml_node*} ؿձñǩӦ xml ڵ㲻
	 */
	xml_node* getFirstElementByTag(const char* tag) const;

	/**
	 * @override  xml ле༶ǩͬ xml ڵļ
	 * @param tags {const char*} ༶ǩ '/' ָǩ xml ݣ
	 *  <root> <first> <second> <third name="test1"> text1 </third> </second> </first> ...
	 *  <root> <first> <second> <third name="test2"> text2 </third> </second> </first> ...
	 *  <root> <first> <second> <third name="test3"> text3 </third> </second> </first> ...
	 *  ͨ༶ǩroot/first/second/third һԲзĽڵ
	 * @return {const std::vector<xml_node*>&}  xml ڵ㼯, 
	 *  ѯΪգüΪգempty() == true
	 *  עصе xml_node ڵݿ޸ģɾýڵ㣬
	 *  ΪÿڲԶɾĻ
	 */
	const std::vector<xml_node*>& getElementsByTags(const char* tags) const;

	/**
	 * @override  xml лָ༶ǩĵһ xml ڵ
	 * @param tags {const char*} ༶ǩ '/' ָǩ xml ݣ
	 *  <root> <first> <second> <third name="test1"> text1 </third> </second> </first> ...
	 *  <root> <first> <second> <third name="test2"> text2 </third> </second> </first> ...
	 *  <root> <first> <second> <third name="test3"> text3 </third> </second> </first> ...
	 *  ͨ༶ǩroot/first/second/third һԲзĽڵ
	 * @return {xml_node*} ؿձʾ
	 */
	xml_node* getFirstElementByTags(const char* tags) const;

	/**
	 * @override  xml л name ֵͬ xml ڵ㼯
	 * @param value {const char*} Ϊ name ֵ
	 * @return {const std::vector<xml_node*>&} ؽĶã
	 *  ѯΪգüΪգempty() == true
	 *  עصе xml_node ڵݿ޸ģɾýڵ㣬
	 *  ΪÿڲԶɾĻ
	 */
	const std::vector<xml_node*>&
		getElementsByName(const char* value) const;

	/**
	 * @override  xml лиֵ xml ڵԪؼ
	 * @param name {const char*} 
	 * @param value {const char*} ֵ
	 * @return {const std::vector<xml_node*>&} ؽĶã
	 *  ѯΪգüΪգempty() == true
	 */
	const std::vector<xml_node*>& getElementsByAttr(
		const char* name, const char* value) const;

	/**
	 * @override  xml лָ id ֵ xml ڵԪ
	 * @param id {const char*} id ֵ
	 * @return {xml_node*} xml ڵԪ,  NULL ʾûз
	 *  xml ڵ, ֵҪͷ
	 */
	xml_node* getElementById(const char* id) const;

	/**
	 * @override һ xml_node ڵ
	 * @param tag {const char*} ǩ
	 * @param text {const char*} ıַ
	 * @return {xml_node*} ² xml_node ҪûֹͷţΪ
	 *  xml ͷʱЩڵԶͷţȻûҲڲʱ
	 *  reset ͷЩ xml_node ڵ
	 */
	xml_node& create_node(const char* tag, const char* text = NULL);

	/**
	 * @override øڵ󣬵Ҫע⣬ýڵΪڵ㣬治
	 *  κݣ xml ڵ㸸
	 * @return {xml_node&}
	 */
	xml_node& get_root(void);

	/**
	 * @override ʼ xml 󲢻õһڵ
	 * @return {xml_node*} ؿձʾ xml Ϊսڵ
	 *  עصĽڵûֹͷţΪö
	 *  ڲԶͷ
	 */
	xml_node* first_node(void);

	/**
	 * @override  xml һ xml ڵ
	 * @return {xml_node*} ؿձʾ
	 *  עصĽڵûֹͷţΪö
	 *  ڲԶͷ
	 */
	xml_node* next_node(void);

	/**
	 * @override  xml תַ
	 * @param out {string&} 洢תĻ
	 */
	void build_xml(string& out) const;

	/**
	 * @override
	 */
	const char* to_string(size_t* len = NULL) const;

public:
	/**
	 * ȡ acl е ACL_XML 
	 * @return {ACL_XML*} ֵΪգעû޸ĸöֵ
	 *  ͷŸö
	 */
	ACL_XML* get_xml(void) const
	{
		return xml_;
	}

private:
	ACL_XML *xml_;
	ACL_ITER* iter_;
	xml1_node* root_;
};

} // namespace acl
