#ifndef ACL_CHUNK_CHAIN_INCLUDE_H
#define ACL_CHUNK_CHAIN_INCLUDE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "acl_define.h"

/**
 * Ͷ
 */
typedef struct ACL_CHAIN ACL_CHAIN;

/**
 * һ
 * @param init_size {size_t} ݶ̬ڴĳʼߴС
 * @param off_begin {acl_int64} ݿʼλ
 * @return {ACL_CHAIN*} 
 */
ACL_API ACL_CHAIN *acl_chain_new(size_t init_size, acl_int64 off_begin);

/**
 * ͷ
 * @param chain {ACL_CHAIN*} 
 */
ACL_API void acl_chain_free(ACL_CHAIN *chain);

/**
 * ݿһƫλ
 * @param chain {ACL_CHAIN*} 
 * @param from_next {acl_int64} ݿһƫλ
 */
ACL_API void acl_chain_set_from_next(ACL_CHAIN *chain, acl_int64 from_next);

/**
 * 󣬲ʼλΪֵ
 * @param chain {ACL_CHAIN*} 
 * @param off_begin {acl_int64} ݿʼλ
 */
ACL_API void acl_chain_reset(ACL_CHAIN *chain, acl_int64 off_begin);

/**
 * õǰݿеһλ
 * @param chain {ACL_CHAIN*} 
 * @return {acl_int64} ݿһλ
 */
ACL_API acl_int64 acl_chain_from_next(ACL_CHAIN *chain);

/**
 * õǰʼλ
 * @param chain {ACL_CHAIN*} 
 * @return {acl_int64} ʼλ
 */
ACL_API acl_int64 acl_chain_off_begin(ACL_CHAIN *chain);

/**
 * õǰݿʼ洢ַָ
 * @param chain {ACL_CHAIN*} 
 * @return {const char*} ݿʼ洢ַָ
 */
ACL_API const char *acl_chain_data(ACL_CHAIN *chain);

/**
 * õǰݿݳ
 * @param chain {ACL_CHAIN*} 
 * @return {int} ݿݳ
 */
ACL_API int acl_chain_data_len(ACL_CHAIN *chain);

/**
 * ǰзݿĸ
 * @param chain {ACL_CHAIN*} 
 * @return {int} ݿĸ
 */
ACL_API int acl_chain_size(ACL_CHAIN *chain);

/**
 * õǰзݿܳ
 * @param chain {ACL_CHAIN*} 
 * @return {int} ݿܳ
 */
ACL_API int acl_chain_chunk_data_len(ACL_CHAIN *chain);

/**
 * һݿ飬ڲԶȥص
 * @param chain {ACL_CHAIN*} 
 * @param data {const void*} ݿָ
 * @param from {acl_int64} ݿʼλ
 * @param dlen {int} ݿĳ
 */
ACL_API void acl_chain_add(ACL_CHAIN *chain, const void *data,
	acl_int64 from, int dlen);

/**
 * ӡǰݿ鼰ݿʼλϢ
 * @param chain {ACL_CHAIN*} 
 */
ACL_API void acl_chain_list(ACL_CHAIN *chain);

#ifdef __cplusplus
}
#endif

#endif
