#include "stdafx.h"
#include "rpc_stats.h"
#include "http_rpc.h"

http_rpc::http_rpc(acl::aio_socket_stream* client, unsigned buf_size)
: client_(client)
, buf_size_(buf_size)
{
	res_buf_ = (char*) acl_mymalloc(buf_size + 1);
	unsigned i;
	for (i = 0; i < buf_size; i++)
		res_buf_[i] = 'x';
	res_buf_[i] = 0;
}

http_rpc::~http_rpc()
{
	//logger("rpc_request destroyed!");
	acl_myfree(res_buf_);
}

//  service_.rpc_fork  RPC ߳еñ
// ģ鷢Ϣ
void http_rpc::rpc_run()
{
	// 
	acl::socket_stream stream;

	//  get_vstream() õ ACL_VSTREAM 
	//  stream Ϊ acl_cpp  acl е
	// ͷնǻ ACL_VSTREAM ACL_VSTREAM 
	// ڲάһ/дڳӵݴУ
	// ÿν ACL_VSTREAM ΪڲĻԴ
	ACL_VSTREAM* vstream = client_->get_vstream();
	ACL_VSTREAM_SET_RWTIMO(vstream, 10);
	(void) stream.open(vstream);
	// Ϊģʽ
	stream.set_tcp_non_blocking(false);

	rpc_req_add();

	// ʼ HTTP 
	handle_conn(&stream);

	rpc_req_del();

	// Ϊģʽ
	stream.set_tcp_non_blocking(true);

	//  ACL_VSTREAM 󶨣ܱ֤ͷʱ
	// رߵӣΪӱڷģҪ
	// 첽رշʽйر
	stream.unbind();
}

void http_rpc::handle_conn(acl::socket_stream* stream)
{
	// HTTP Ӧ
	acl::http_response res(stream);
	// ӦΪ xml ʽ
	res.response_header().set_content_type("text/html");

	//  HTTP ͷ
	if (res.read_header() == false)
	{
		keep_alive_ = false;
		return;
	}

	acl::string buf;
	//  HTTP 
	if (res.get_body(buf) == false)
	{
		keep_alive_ = false;
		return;
	}

	acl::http_client* client = res.get_client();

	// жϿͻǷϣֳ
	keep_alive_ = client->keep_alive();

	// ݸͻ

	res.response_header().set_status(200).set_keep_alive(keep_alive_);
	res.response(res_buf_, buf_size_);
}

void http_rpc::rpc_onover()
{
	//  rpc 
	rpc_del();

	if (keep_alive_)
	{
		rpc_read_wait_add();

		// 첽Ƿɶ
		client_->read_wait(10);
	}
	else
		// ر첽
		client_->close();
}
