#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <list>

namespace acl
{

class event_task;

class ACL_CPP_API event_timer
{
public:
	/**
	 * 캯
	 * @param keep {bool} öʱǷԶ
	 */
	event_timer(bool keep = false);
	virtual ~event_timer();

	/**
	 * ʱΪʱĻص
	 * ͷţһúã
	 * ζŸöʱежʱ񶼴
	 * ʱбɾ
	 * ú
	 * 1) ʱеΪ 0 ʱ
	 * 2) ûظʱҸöʱһʱ񱻴
	 * 3)  del_timer(event_timer*) ú
	 */
	virtual void destroy(void) {}

	/**
	 * ʱǷΪ
	 * @return {bool}
	 */
	bool empty(void) const
	{
		return tasks_.empty();
	}

	/**
	 * ʱ
	 * @return {size_t}
	 */
	size_t length(void) const
	{
		return length_;
	}

	/**
	 * öʱǷԶ
	 * @param on {bool}
	 */
	void keep_timer(bool on);

	/**
	 * жϸöʱǷԶ
	 * @return {bool}
	 */
	bool keep_timer(void) const
	{
		return keep_;
	}

	/**
	 * նʱĶʱ
	 * @return {int} Ķʱĸ
	 */
	int clear(void);

	/**
	 * ʵִ˻صעֹ߽
	 * timer_callback ڲ event_timer 
	 * 򽫻ɴ
	 * @param id {unsigned int} Ӧĳ ID 
	 */
	virtual void timer_callback(unsigned int id) = 0;

	/****************************************************************/
	/*        ԵºһЩµĶʱ ID       */
	/****************************************************************/
#if defined(_WIN32) || defined(_WIN64)
	/**
	 * ԱʱµIDţͨһʱ
	 * ʱ
	 * @param id {unsigned int} ʱʱID
	 * @param delay {__int64} ÿԶöʱͬʱӦĶʱʱ
	 *  IDŴ(΢뼶)
	 * @return {__int64} 뱾ʱĵһᴥĶʱID(΢뼶)
	 */
	__int64 set_task(unsigned int id, __int64 delay);

	/**
	 * ɾʱĳϢIDӦĶʱ
	 * @param {unsigned int} ʱID
	 * @return {__int64} 뱾ʱĵһᴥĶʱID(΢뼶)
	 */
	__int64 del_task(unsigned int id);
#else
	long long int set_task(unsigned int id, long long int delay);
	long long int del_task(unsigned int id);
#endif

	//////////////////////////////////////////////////////////////////////

	/**
	 * еʱĶʱ
	 * @return {long lont int} һҪʱ
	 */
#if defined(_WIN32) || defined(_WIN64)
	__int64 trigger(void);
	__int64 min_delay(void) const
	{
		return min_delay_;
	}
#else
	long long int trigger(void);
	long long int min_delay(void) const
	{
		return min_delay_;
	}
#endif

protected:
#if defined(_WIN32) || defined(_WIN64)
	__int64 min_delay_;
	__int64 present_;
#else
	long long int min_delay_;
	long long int present_;
#endif

private:
	size_t length_;
	std::list<event_task*> tasks_;
	bool keep_;  // öʱǷԶ
#if defined(_WIN32) || defined(_WIN64)
	__int64 set_task(event_task* task);
#else
	long long int set_task(event_task* task);
#endif

	/**
	 * õǰʱʱ
	 */
	void set_time(void);
};

}  // namespace acl
