#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stdlib/string.hpp"
#include <map>

struct ACL_VSTREAM;

namespace acl {

class stream_hook;

class ACL_CPP_API stream
{
public:
	stream(void);
	virtual ~stream(void) = 0;

	/**
	 * ñر
	 * @return {bool} true: رճɹ; false: رʧ
	 */
	bool close(void);

	/**
	* жǷѾ
	* @return {bool} true: Ѿ; false: δ
	*/
	bool eof(void) const;

	/**
	 * ־λ eof_ ־λΪ false
	 */
	void clear_eof(void);

	/**
	* ǰǷ״̬
	* @return {bool} true: Ѿ; false: δ
	*/
	bool opened(void) const;

	/**
	 * õǰ ACL_VSTREAM 
	 * @return {ACL_VSTREAM*}
	 */
	ACL_VSTREAM* get_vstream() const;

	/**
	 *  ACL_VSTREAM İ󶨹ϵͬʱ ACL_VSTREAM 
	 * û ACL_VSTREAMĹȨûͷʱ
	 * رո ACL_VSTREAM ûӹܸ ACL_VSTREAM 
	 * 뽫رգ close/open ĵ⣬ĵ
	 * (д)
	 * @return {ACL_VSTREAM}  NULL ʾѾ ACL_VSTREAM 
	 */
	ACL_VSTREAM* unbind();

	/**
	 * İ󶨶
	 * @param ctx {void*}
	 * @param key {const char* } ʶ ctx ļ
	 * @param replace {bool} Ӧ KEY ʱǷ
	 * @return {bool}  replace Ϊ false  key Ѿʱ򷵻 false
	 */
	bool set_ctx(void* ctx, const char* key = NULL, bool replace = true);

	/**
	 * 󶨵Ķ
	 * @param key {const char* key} ǿʱʹø key ѯӦ ctx 
	 *  򷵻ȱʡ ctx 
	 * @return {void*}
	 */
	void* get_ctx(const char* key = NULL) const;

	/**
	 * ɾа󶨵Ķ
	 * @param key {const char*} ǿʱɾӦ key  ctx 󣬷ɾ
	 *  ȱʡ ctx 
	 * @return {void*} 󲻴ʱ NULLɹɾ󷵻ظö
	 */
	void* del_ctx(const char* key = NULL);

	/**
	 * Ķдʱʱ
	 * @param n {int} ʱʱ(λ: )
	 */
	void set_rw_timeout(int n);

	/**
	 * õǰĶдʱʱ
	 * @return {int} Ķдʱʱ()
	 */
	int get_rw_timeout(void) const;

	/**
	 * עдڲԶ hook->open ̣ɹ򷵻֮ǰעĶ
	 * (ΪNULL)ʧ򷵻ָͬ룬ӦÿͨжϷֵֵ
	 * ǷͬжעǷɹ
	 * xxx: ڵô˷ǰ뱣֤Ѿ
	 * @param hook {stream_hook*} ǿնָ
	 * @return {stream_hook*} ֵֵͬʾɹ
	 */
	stream_hook* setup_hook(stream_hook* hook);

	/**
	 * õǰעд
	 * @return {stream_hook*}
	 */
	stream_hook* get_hook() const;

	/**
	 * ɾǰעд󲢷ظö󣬻ָȱʡĶд
	 * @return {stream_hook*}
	 */
	stream_hook* remove_hook();

protected:
	/**
	 * Ѿ򿪣򲻻ظ
	 */
	void open_stream(bool is_file = false);

	/**
	 * ´Ѿͷٴ
	 */
	void reopen_stream(bool is_file = false);

protected:
	stream_hook* hook_;
	ACL_VSTREAM *stream_;
	bool eof_;
	bool opened_;

	void* default_ctx_;
	std::map<string, void*> ctx_table_;

private:
#if defined(_WIN32) || defined(_WIN64)
	static int read_hook(SOCKET fd, void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
	static int send_hook(SOCKET fd, const void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);

	static int fread_hook(HANDLE fd, void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
	static int fsend_hook(HANDLE fd, const void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
#else
	static int read_hook(int fd, void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
	static int send_hook(int fd, const void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);

	static int fread_hook(int fd, void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
	static int fsend_hook(int fd, const void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
#endif
};

} // namespace acl
