#ifndef	__CONN_CACHE_INCLUDE_H__
#define	__CONN_CACHE_INCLUDE_H__

#include "lib_acl.h"

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct CONN_CACHE {
	ACL_AIO *aio;
	ACL_HTABLE *cache;
	int   conn_limit;
	int   nset;
	int   nget;
	int   nclose;
} CONN_CACHE;

typedef struct CONN CONN;

/**
 * ӳسʼ, úڳʼʱһ
 * @param aio {ACL_AIO*} 첽
 * @param conn_limit {int} ÿһӳص
 * @return {CONN_CACHE*} һӳصĻ
 */
CONN_CACHE *conn_cache_create(ACL_AIO *aio, int conn_limit);

/**
 * ӳһ
 * @param cache {CONN_CAHCE*} ӻ
 * @param timeout {int} ӵĳʱʱ
 * @param free_fn {void (*)(ACL_ASTREAM*, void*)} رʱĻص,
 *  òǿգ򵱸ӱرǰԶ free_fn
 * @param ctx {void*} free_fn Ĳ֮һ
 */
void conn_cache_push_stream(CONN_CACHE *cache, ACL_ASTREAM *stream,
	int timeout, void (*free_fn)(ACL_ASTREAM*, void*), void *ctx);

/**
 * ӳȡӦĳֵӶ
 * @param cache {CONN_CAHCE*} ӻ
 * @param key {const char*} ѯֵ磺192.168.0.1:80
 * @return {CONN*} Ӷ, Ϊ NULL ʾ
 */
CONN *conn_cache_get_conn(CONN_CACHE *cache, const char *key);

/**
 * ӳȡӦĳֵ
 * @param cache {CONN_CAHCE*} ӻ
 * @param key {const char*} ѯֵ磺192.168.0.1:80
 * @param ctx_pptr {void**} ǿգ洢ûԶ
 * @return {ACL_ASTREAM*} 
 */
ACL_ASTREAM *conn_cache_get_stream(CONN_CACHE *cache, const char *key, void **ctx_pptr);

/**
 * ӳɾӦĳֵ
 * @param cache {CONN_CAHCE*} ӻ
 * @param key {const char*} ѯֵ磺192.168.0.1:80
 */
void conn_cache_delete_key(CONN_CACHE *cache, const char *key);

/**
 * ӳɾĳӶҹر
 * @param conn {CONN*} Ӷ
 */
void conn_cache_delete_conn(CONN *conn);

/**
 * ӳɾĳɾӦӶҹر
 * @param cache {CONN_CAHCE*} ӻ
 * @param stream {ACL_ASTREAM*} 
 */
void conn_cache_delete_stream(CONN_CACHE *cache, ACL_ASTREAM *stream);

#ifdef	__cplusplus
}
#endif

#endif
