#include "acl_stdafx.hpp"
#include "acl_cpp/stdlib/log.hpp"
#include "acl_cpp/stream/socket_stream.hpp"
#include "acl_cpp/master/master_threads2.hpp"

namespace acl
{

static master_threads2* __mt = NULL;

master_threads2::master_threads2(void)
{
	// ȫ־̬
	acl_assert(__mt == NULL);
	__mt = this;
}

master_threads2::~master_threads2(void)
{
}

static bool has_called = false;

void master_threads2::run_daemon(int argc, char** argv)
{
#ifndef ACL_WINDOWS
	// ÿֻһʵ
	acl_assert(has_called == false);
	has_called = true;
	daemon_mode_ = true;

	//  acl ܵĶ߳ģ
	acl_threads_server_main(argc, argv, service_main, NULL,
		ACL_MASTER_SERVER_ON_ACCEPT, service_on_accept,
		ACL_MASTER_SERVER_ON_HANDSHAKE, service_on_handshake,
		ACL_MASTER_SERVER_ON_TIMEOUT, service_on_timeout,
		ACL_MASTER_SERVER_ON_CLOSE, service_on_close,
		ACL_MASTER_SERVER_PRE_INIT, service_pre_jail,
		ACL_MASTER_SERVER_POST_INIT, service_init,
		ACL_MASTER_SERVER_EXIT_TIMER, service_exit_timer,
		ACL_MASTER_SERVER_EXIT, service_exit,
		ACL_MASTER_SERVER_THREAD_INIT, thread_init,
		ACL_MASTER_SERVER_THREAD_EXIT, thread_exit,
		ACL_MASTER_SERVER_BOOL_TABLE, conf_.get_bool_cfg(),
		ACL_MASTER_SERVER_INT64_TABLE, conf_.get_int64_cfg(),
		ACL_MASTER_SERVER_INT_TABLE, conf_.get_int_cfg(),
		ACL_MASTER_SERVER_STR_TABLE, conf_.get_str_cfg(),
		ACL_MASTER_SERVER_END);
#else
	logger_fatal("no support win32 yet!");
#endif
}

//////////////////////////////////////////////////////////////////////////

static bool __stop = false;
static int  __count_limit = 1;
static int  __count = 0;
static acl_pthread_pool_t* __thread_pool = NULL;

static void close_sstreams(ACL_EVENT* event, std::vector<ACL_VSTREAM*>& streams)
{
	std::vector<ACL_VSTREAM*>::iterator it = streams.begin();
	for (; it != streams.end(); ++it)
	{
		acl_event_disable_readwrite(event, *it);
		acl_vstream_close(*it);
	}

	streams.clear();
}

bool master_threads2::run_alone(const char* addrs, const char* path /* = NULL */,
	unsigned int count /* = 1 */, int threads_count /* = 1 */)
{
	// ÿֻһʵ
	acl_assert(has_called == false);
	has_called = true;
	daemon_mode_ = false;
	acl_assert(addrs && *addrs);

	__count_limit = count;

	std::vector<ACL_VSTREAM*> sstreams;

#ifdef ACL_WINDOWS
	acl_init();
	ACL_EVENT* eventp = acl_event_new_select_thr(1, 0);
#else
	ACL_EVENT* eventp = acl_event_new_kernel_thr(1, 0);
#endif

	set_event(eventp);  // û¼

	ACL_ARGV*  tokens = acl_argv_split(addrs, ";,| \t");
	ACL_ITER   iter;

	acl_foreach(iter, tokens)
	{
		const char* addr = (const char*) iter.data;
		ACL_VSTREAM* sstream = acl_vstream_listen(addr, 128);
		if (sstream == NULL)
		{
			logger_error("listen %s error(%s)",
				addr, acl_last_serror());
			acl_argv_free(tokens);
			close_sstreams(eventp, sstreams);
			acl_event_free(eventp);
			return false;
		}
		acl_event_enable_listen(eventp, sstream, 0,
			listen_callback, sstream);
		sstreams.push_back(sstream);
	}

	acl_argv_free(tokens);

	// ʼò
	conf_.load(path);

	service_pre_jail(NULL);
	service_init(NULL);

	if (threads_count > 1)
	{
		__thread_pool = acl_thread_pool_create(threads_count, 120);
		acl_pthread_pool_atinit(__thread_pool, thread_begin, NULL);
		acl_pthread_pool_atfree(__thread_pool, thread_finish, NULL);
	}
	else
		thread_init(NULL);

	while (!__stop)
		acl_event_loop(eventp);

	if (__thread_pool)
		acl_pthread_pool_destroy(__thread_pool);
	else
		thread_exit(NULL);

	service_exit(NULL);

	// ڵ acl_event_free ǰ close_sstreamsΪڹر
	// ʱȻж ACL_EVENT ʹ
	close_sstreams(eventp, sstreams);
	acl_event_free(eventp);
	eventp = NULL;

	return true;
}

void master_threads2::listen_callback(int, ACL_EVENT*, ACL_VSTREAM* sstream, void*)
{
	ACL_VSTREAM* client = acl_vstream_accept(sstream, NULL, 0);

	if (client == NULL)
	{
		logger_error("accept error(%s)", acl_last_serror());
		__stop = true;
	}
	else if (__thread_pool != NULL)
	{
		acl_pthread_pool_add(__thread_pool, thread_run, client);
		__count++;
	}
	else
	{
		// ̷߳ʽд
		run_once(client);
		__count++;
	}
}

int master_threads2::thread_begin(void* arg)
{
	thread_init(arg);
	return 0;
}

void master_threads2::thread_finish(void* arg)
{
	thread_exit(arg);
}

void master_threads2::thread_run(void* arg)
{
	ACL_VSTREAM* client = (ACL_VSTREAM*) arg;
	run_once(client);
}

void master_threads2::run_once(ACL_VSTREAM* client)
{
	if (service_on_accept(client) != 0)
	{
		service_on_close(client, NULL);
		acl_vstream_close(client);
		return;
	}

	socket_stream* stream = (socket_stream*) client->context;
	acl_assert(stream);
	ACL_SOCKET fd = stream->sock_handle();
	int   timeout = stream->get_rw_timeout();
	int   ret;

	while (true)
	{
		if (ACL_VSTREAM_BFRD_CNT(client) > 0)
		{
			//  1 ʱʾ client Ѿر
			if (service_main(client, NULL) == 1)
				break;
			continue;
		}

		// acl_read_wait  timeout Ϊ -1 ʱȫ
		// ȴݿɶΪ 0 ʱأ
		// > 0 ʱȴָʱʱ
		if(acl_read_wait(fd, timeout > 0 ? timeout : -1) == 0)
			client->read_ready = 1;
		else if (service_on_timeout(client, NULL) == 0)
			continue;
		else
		{
			service_on_close(client, NULL);

			// stream  service_on_close бɾ
			// ɾʱر׽Ҫ
			// ˴ر׽
			acl_vstream_close(client);
			break;
		}

		//  -1 ʾҪرոÿͻ
		if ((ret = service_main(client, NULL)) == -1)
		{
			service_on_close(client, NULL);

			// stream  service_on_close бɾ
			// ɾʱر׽Ҫ
			// ˴ر׽
			acl_vstream_close(client);
			break;
		}

		// service_main ֻܷ 0  -1
		acl_assert(ret == 0);
	}

	if (__count_limit > 0 && __count >= __count_limit)
		__stop = true;
}

//////////////////////////////////////////////////////////////////////////

void master_threads2::service_pre_jail(void*)
{
	acl_assert(__mt != NULL);

#ifndef ACL_WINDOWS
	if (__mt->daemon_mode())
	{
		ACL_EVENT* eventp = acl_threads_server_event();
		__mt->set_event(eventp);
	}
#endif

	__mt->proc_pre_jail();
}

void master_threads2::service_init(void*)
{
	acl_assert(__mt != NULL);

	__mt->proc_inited_ = true;
	__mt->proc_on_init();
}

int master_threads2::service_exit_timer(size_t nclients, size_t nthreads)
{
	acl_assert(__mt != NULL);
	return __mt->proc_exit_timer(nclients, nthreads) == true ? 1 : 0;
}

void master_threads2::service_exit(void*)
{
	acl_assert(__mt != NULL);
	__mt->proc_on_exit();
}

int master_threads2::thread_init(void*)
{
	acl_assert(__mt != NULL);
	__mt->thread_on_init();
	return 0;
}

void master_threads2::thread_exit(void*)
{
	acl_assert(__mt != NULL);
	__mt->thread_on_exit();
}

int master_threads2::service_on_accept(ACL_VSTREAM* client)
{
	// client->context Ӧռ
	if (client->context != NULL)
		logger_fatal("client->context not null!");

	socket_stream* stream = NEW socket_stream();

	//  client->context Ϊ󣬸ͳһ
	// service_on_close бͷ
	client->context = stream;

	if (stream->open(client) == false)
	{
		logger_error("open stream error(%s)", acl_last_serror());
		//  -1 ϲܵ service_on_close ̣
		// ͷ stream 
		return -1;
	}

	acl_assert(__mt != NULL);

	//  thread_on_accept  falseֱӷظϲ
	//  -1ϲٵ service_on_close ̣Ӷڸù
	// н stream ͷ
	if (__mt->thread_on_accept(stream) == false)
		return -1;

	//  thread_on_handshake  falseֱӷظϲ
	//  -1ϲٵ service_on_close ̣Ӷڸù
	// н stream ͷ
	if (__mt->thread_on_handshake(stream) == false)
		return -1;

	//  0 ʾԼÿͻӣӶϲܽ
	// ؼ
	return 0;
}

int master_threads2::service_on_handshake(ACL_VSTREAM *client)
{
	acl_assert(__mt != NULL);

	// client->context  service_on_accept б
	socket_stream* stream = (socket_stream*) client->context;
	if (stream == NULL)
		logger_fatal("client->context is null!");

	if (__mt->thread_on_handshake(stream) == true)
		return 0;
	return -1;
}

int master_threads2::service_main(ACL_VSTREAM *client, void*)
{
	acl_assert(__mt != NULL);

	// client->context  service_on_accept б
	socket_stream* stream = (socket_stream*) client->context;
	if (stream == NULL)
		logger_fatal("client->context is null!");

	// 麯ʵ֣ true ʾÿܼظ
	// Ҫرո
	// ϲܷ 0 ʾӱֳ
	if (__mt->thread_on_read(stream) == true)
		return 0;

	//  -1 ʾϲرϲرǰ
	// ص service_on_close ̽رǰƺ
	// stream  service_on_close бͷ
	return -1;
}

int master_threads2::service_on_timeout(ACL_VSTREAM* client, void*)
{
	socket_stream* stream = (socket_stream*) client->context;
	if (stream == NULL)
		logger_fatal("client->context is null!");

	acl_assert(__mt != NULL);

	return __mt->thread_on_timeout(stream) == true ? 0 : -1;
}

void master_threads2::service_on_close(ACL_VSTREAM* client, void*)
{
	socket_stream* stream = (socket_stream*) client->context;
	if (stream == NULL)
		logger_fatal("client->context is null!");

	acl_assert(__mt != NULL);

	// ຯԽҪرյƺ
	__mt->thread_on_close(stream);

	// İ󶨹ϵԷֹɾʱ
	// رΪҪڱغ
	// Զر
	(void) stream->unbind();
	delete stream;
}

}  // namespace acl
