#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <vector>
#include <map>
#include <utility>
#include "acl_cpp/redis/redis_command.hpp"

namespace acl
{

class redis_client;

class ACL_CPP_API redis_zset : virtual public redis_command
{
public:
	/**
	 * see redis_command::redis_command()
	 */
	redis_zset(void);

	/**
	 * see redis_command::redis_command(redis_client*)
	 */
	redis_zset(redis_client* conn);

	/**
	 * see redis_command::redis_command(redis_client_cluster* size_t)
	 */
	redis_zset(redis_client_cluster* cluster, size_t max_conns = 0);
	virtual ~redis_zset(void);

	/////////////////////////////////////////////////////////////////////

	/**
	 * ӶӦ key 
	 * add one or more members to a sorted set, or update its score if
	 * it already exists
	 * @param key {const char*} 򼯼ֵ
	 *  the key of a sorted set
	 * @param members "ֵ-Ա"
	 *  the set storing values and stores
	 * @return {int} ³ɹӵ "ֵ-Ա" Ե
	 *  the number of elements added to the sorted set, not including
	 *  elements already existing for which the score was updated
	 *  0ʾһҲδӣΪóԱѾ
	 *     nothing was added to the sorted set
	 * -1ʾ key 򼯶
	 *     error or it was not a sorted set by the key
	 * >0ӵĳԱ
	 *     the number of elements added
	 */
	int zadd(const char* key, const std::map<string, double>& members);
	int zadd(const char* key,
		const std::vector<std::pair<string, double> >&members);
	int zadd(const char* key,
		const std::vector<std::pair<const char*, double> >&members);
	int zadd(const char* key, const std::vector<string>& members,
		const std::vector<double>& scores);
	int zadd(const char* key, const std::vector<const char*>& members,
		const std::vector<double>& scores);
	int zadd(const char* key, const char* members[], double scores[],
		size_t size);
	int zadd(const char* key, const char* members[], size_t members_len[],
		double scores[], size_t size);

	/**
	 * Ӧ򼯵ĳԱ
	 * get the number of elements in a sorted set
	 * @param key {const char*} 򼯼ֵ
	 *  the key of a a sorted set
	 * @return {int} һ򼯵ĳԱ
	 *  the number of elements of the sorted set
	 *   0ü
	 *      the key doesn't exist
	 *  -1üݶЧ򼯶
	 *      error or it wasn't a sorted set by the key
	 *  >0ǰֵӦݶеĳԱ
	 *      the number of elements in the sorted set
	 */
	int zcard(const char* key);

	/**
	 *  key ֵָĳԱ
	 * get the number of elements in a sorted set with scores within
	 * the given values
	 * @param key {const char*} 򼯼ֵ
	 *  the key of a sorted set
	 * @param min {double} Сֵ
	 *  the min score specified
	 * @param max {double} ֵ
	 *  the max socre specified
	 * @return {int} ĳԱ
	 *  the number of elements in specified score range
	 *  0üӦ򼯲ڻ KEY 򼯵ĶӦֵԱΪ
	 *     nothing in the specified score range, or the key doesn't exist
	 *  -1: üݶЧ򼯶
	 *     error or it is not a sorted set by the key
	 */
	int zcount(const char* key, double min, double max);

	/**
	 *  key еĳԱķֵ inc
	 * increase the score of a memeber in a sorted set
	 * @param key {const char*} 򼯼ֵ
	 *  the key of the sorted set
	 * @param inc {double} ֵ
	 *  the value to be increased
	 * @param member{const char*} гԱ
	 *  the specified memeber of a sorted set
	 * @param result {double*} ǿʱ洢ֵ
	 *  if not null, it will store the score result after increment
	 * @return {bool} Ƿɹ
	 *  if successful about the operation
	 */
	bool zincrby(const char* key, double inc, const char* member,
		double* result = NULL);
	bool zincrby(const char* key, double inc, const char* member,
		size_t len, double* result = NULL);

	/**
	 *  key лָλĳԱбԱֵʽ
	 * get the specified range memebers of a sorted set sotred at key
	 * @param key {const char*} 򼯼ֵ
	 *  the key of a sorted set
	 * @param start {int} ʼ±λ
	 *  the begin index of the sorted set
	 * @param stop {int} ±λãͬʱλã
	 *  the end index of the sorted set
	 * @param result {std::vector<string>*} ǿʱ洢ڲȵ
	 *  result.clear() еԪ
	 *  if not NULL, it will store the memebers result
	 * @return {int} гԱ
	 *  the number of memebers
	 *  0: ʾΪջ key 
	 *     the result is empty or the key doesn't exist
	 * -1: ʾ key 򼯶
	 *     error or it's not a sorted set by the key
	 * >0: 
	 *     the number of the memebers result
	 *  ע±λã0 ʾһԱ1 ʾڶԱ-1 ʾһԱ
	 *     -2 ʾڶԱԴ
	 *  Notice: about the index, element by index 0 is the first
	 *   of the sorted set, element by index -1 is the last one. 
	 *
	 *  ɹͨһʽ
	 *  when success, the result can be got by one of the below proccess: 
	 *  1ڵ÷дǿյĴ洢ĵַ
	 *     the most easily way is to set a non-NULL result parameter
	 *     for this function
	 *  2෽ get_value ָ±Ԫ
	 *     get the specified subscript's element by redis_command::get_value
	 *  3෽ get_child ָ±Ԫض(redis_resultȻͨ
	 *     redis_result::argv_to_string Ԫ
	 *     redis_result::argv_to_string Ԫ
	 *     get redis_result object with the given subscript, and get the
	 *     element by redis_result::argv_to_string
	 *  4෽ get_result ȡܽ redis_resultȻͨ
	 *     redis_result::get_child һԪضȻͨʽ 2 ָ
	 *     ķøԪص
	 *     get redis_result object by redis_command::get_result, and get
	 *     the first element by redis_result::get_child, then get the
	 *     element by the way same as the way 2 above.
	 *  5෽ get_children ýԪͨ redis_result 
	 *     ķ argv_to_string ÿһԪضлԪ
	 *     get child array by redis_command::get_children, and get the
	 *     element from one of redis_result array by argv_to_string
	 */
	int zrange(const char* key, int start, int stop,
		std::vector<string>* result);

	/**
	 *  key лָλĳԱֵбԱֵʽ
	 * @param key {const char*} 򼯼ֵ
	 * @param start {int} ʼ±λ
	 * @param stop {int} ±λãͬʱλã
	 * @param result 洢 "Ա-ֵ"ڲȵ out.clear()
	 * @return {int} гԱ
	 *  0: ʾΪջ key 
	 * -1: ʾ key 򼯶
	 * >0: 
	 *  ע±λã0 ʾһԱ1 ʾڶԱ-1 ʾһԱ
	 *     -2 ʾڶԱԴ
	 */
	int zrange_with_scores(const char* key, int start, int stop,
		std::vector<std::pair<string, double> >& out);

	/**
	 *  key У score ֵ min  max ֮( min  max )
	 * ĳԱ򼯳Ա score ֵ(С)
	 * @param key {const char*} 򼯼ֵ
	 * @param min {double} Сֵ
	 * @param max {double} ֵ
	 * @param out {std::vector<string>*} ǿʱ洢Ա
	 * @param offset {const int*} ǿʱʾʼ±
	 * @param count {const int*} ǿʱʾȡĽгԱ
	 * @return {int} гԱ
	 *  0: ʾΪջ key 
	 * -1: ʾ key 򼯶
	 * >0: 
	 *  עoffset  count ͬʱΪǿָʱЧ
	 *
	 *  ɹͨһʽ
	 *  1ڵ÷дǿյĴ洢ĵַ
	 *  2෽ get_value ָ±Ԫ
	 *  3෽ get_child ָ±Ԫض(redis_resultȻͨ
	 *     redis_result::argv_to_string Ԫ
	 *  4෽ get_result ȡܽ redis_resultȻͨ
	 *     redis_result::get_child һԪضȻͨʽ 2 ָ
	 *     ķøԪص
	 *  5෽ get_children ýԪͨ redis_result 
	 *     ķ argv_to_string ÿһԪضлԪ
	 */
	int zrangebyscore(const char* key, double min, double max,
		std::vector<string>* out, const int* offset = NULL,
		const int* count = NULL);

	/**
	 *  key У score ֵ min  max ֮( min  max )
	 * ĳԱ򼯳Ա score ֵ(С)
	 * @param key {const char*} 򼯼ֵ
	 * @param min {const char*} ַʾСֵ
	 * @param max {const char*} ַʾֵ
	 * @param out {std::vector<string>*} ǿʱ洢Ա
	 * @param offset {const int*} ǿʱʾʼ±
	 * @param count {const int*} ǿʱʾȡĽгԱ
	 * @return {int} гԱ
	 *  0: ʾΪջ key 
	 * -1: ʾ key 򼯶
	 * >0: 
	 *  ע
	 * 1offset  count ͬʱΪǿָʱЧ
	 * 2min  max  -inf  +inf ʾ
	 * 3Ĭ£ȡֵʹñ (Сڵڻڵ)Ҳͨǰ
	 *    ( ʹÿѡĿ (Сڻ)磺
	 * 3.1"ZRANGEBYSCORE zset (1 5" з 1 < score <= 5 ĳԱ
	 * 3.2"ZRANGEBYSCORE zset (5 (10" з 5 < score < 10 ĳԱ
	 *
	 *  ɹͨһʽ
	 *  1ڵ÷дǿյĴ洢ĵַ
	 *  2෽ get_value ָ±Ԫ
	 *  3෽ get_child ָ±Ԫض(redis_resultȻͨ
	 *     redis_result::argv_to_string Ԫ
	 *  4෽ get_result ȡܽ redis_resultȻͨ
	 *     redis_result::get_child һԪضȻͨʽ 2 ָ
	 *     ķøԪص
	 *  5෽ get_children ýԪͨ redis_result 
	 *     ķ argv_to_string ÿһԪضлԪ
	 */
	int zrangebyscore(const char* key, const char* min, const char* max,
		std::vector<string>* out, const int* offset = NULL,
		const int* count = NULL);

	/**
	 *  key У score ֵ min  max ֮( min  max )
	 * ĳԱֵ򼯳Ա score ֵ(С)Уֵ(min/max)ʹ
	 * ʾ
	 * @param out 洢ڲȵ out.clear()
	 * @return {int} гԱ
	 */
	int zrangebyscore_with_scores(const char* key, double min, double max,
		std::vector<std::pair<string, double> >& out,
		const int* offset = NULL, const int* count = NULL);

	/**
	 *  key У score ֵ min  max ֮( min  max )
	 * ĳԱֵ򼯳Ա score ֵ(С)Уֵ(min/max)ʹ
	 * ַʾ
	 * @param out 洢ڲȵ out.clear()
	 * @return {int} гԱ
	 */
	int zrangebyscore_with_scores(const char* key, const char* min,
		const char* max, std::vector<std::pair<string, double> >& out,
		const int* offset = NULL, const int* count = NULL);

	/**
	 *  key гԱ member (± 0 ʼ򼯳Ա score
	 * ֵ(С)˳
	 * @param key {const char*} 򼯼ֵ
	 * @param member {const char*} Ա
	 * @param len {size_t} member ĳ
	 * @return {int} ±λֵ-1 --  key 򼯶󣬻Ա
	 */
	int zrank(const char* key, const char* member, size_t len);
	int zrank(const char* key, const char* member);

	/**
	 * ɾĳԱ
	 * @param key {const char*} 򼯼ֵ
	 * @param first_member {const char*} ҪɾĳԱбĵһ
	 * @return {int} ɹɾĳԱ-1 ʾ key 򼯶
	 *  0 ʾ򼯲ڻԱڣ> 0 ʾɹɾĳԱ
	 */
	int zrem(const char* key, const char* first_member, ...);
	int zrem(const char* key, const std::vector<string>& members);
	int zrem(const char* key, const std::vector<const char*>& members);
	int zrem(const char* key, const char* members[], const size_t lens[],
		size_t argc);

	/**
	 * Ƴ key Уָ(rank)ڵгԱ
	 * ֱ± start  stop ָ start  stop ڣ
	 * ± start  stop  0 ΪףҲ˵ 0 ʾ򼯵һԱ
	 *  1 ʾ򼯵ڶԱԴƣ
	 * Ҳʹø±꣬ -1 ʾһԱ -2 ʾڶԱԴ
	 * @param key {const char*} 򼯼ֵ
	 * @param start {int} ʼ±λã 0 ʼ
	 * @param stop {int} ±λ
	 * @return {int} ƳĳԱ
	 *  0ʾ key ڻƳ䲻
	 * -1ʾ key 򼯺϶ֵ
	 */
	int zremrangebyrank(const char* key, int start, int stop);

	/**
	 * Ƴ key У score ֵ min  max ֮( min  max )
	 * ĳԱ԰汾2.1.6ʼscore ֵ min  max ĳԱҲԲڣ
	 * μ ZRANGEBYSCORE 
	 * @param key {const char*} 򼯼ֵ
	 * @param min {double} Сֵ
	 * @param max {double} ֵ
	 * @return {int} ɹɾĳԱ-1 ʾ key 򼯶
	 *  0 ʾ򼯲ڻԱڣ> 0 ʾɹɾĳԱ
	 */
	int zremrangebyscore(const char* key, double min, double max);

	/**
	 * Ƴ key У score ֵ min  max ֮( min  max )
	 * ĳԱ԰汾2.1.6ʼscore ֵ min  max ĳԱҲԲڣ
	 * μ ZRANGEBYSCORE 
	 * @param key {const char*} 򼯼ֵ
	 * @param min {const char*} ַʽСֵμzrangebyscore ע
	 * @param max {const char*} ַʽֵ
	 * @return {int} ɹɾĳԱ-1 ʾ key 򼯶
	 *  0 ʾ򼯲ڻԱڣ> 0 ʾɹɾĳԱ
	 */
	int zremrangebyscore(const char* key, const char* min, const char* max);

	/**
	 *  key лָλĳԱбԱֵݼʽ
	 * @param key {const char*} 򼯼ֵ
	 * @param start {int} ʼ±λ
	 * @param stop {int} ±λãͬʱλã
	 * @param result {std::vector<string>*} ǿʱ洢
	 *  ע±λã0 ʾһԱ1 ʾڶԱ-1 ʾһԱ
	 *     -2 ʾڶԱԴ
	 * @return {int} -1 ʾ
	 */
	int zrevrange(const char* key, int start, int stop,
		std::vector<string>* result);

	/**
	 *  key лָλĳԱֵбԱֵݼʽ
	 * @param key {const char*} 򼯼ֵ
	 * @param start {int} ʼ±λ
	 * @param stop {int} ±λãͬʱλã
	 * @param result 洢 "Ա-ֵ"ڲȵ out.clear()
	 *  ע±λã0 ʾһԱ1 ʾڶԱ-1 ʾһԱ
	 *     -2 ʾڶԱԴ
	 * @return {int} -1 ʾ
	 */
	int zrevrange_with_scores(const char* key, int start, int stop,
		std::vector<std::pair<string, double> >& out);

	/**
	 *  key У score ֵ min  max ֮( min  max )
	 * ĳԱ򼯳Ա score ֵ8(С)
	 * @param key {const char*} 򼯼ֵ
	 * @param min {const char*} ַʾСֵ
	 * @param max {const char*} ַʾֵ
	 * @param out {std::vector<string>*} ǿʱ洢Ա
	 * @param offset {const int*} ǿʱʾʼ±
	 * @param count {const int*} ǿʱʾȡĽгԱ
	 * @return {int} гԱ
	 *  0: ʾΪջ key 
	 * -1: ʾ key 򼯶
	 * >0: 
	 *  ע
	 * 1offset  count ͬʱΪǿָʱЧ
	 * 2min  max  -inf  +inf ʾ
	 * 3Ĭ£ȡֵʹñ (Сڵڻڵ)Ҳͨǰ
	 *    ( ʹÿѡĿ (Сڻ)磺
	 * 3.1"ZRANGEBYSCORE zset (1 5" з 1 < score <= 5 ĳԱ
	 * 3.2"ZRANGEBYSCORE zset (5 (10" з 5 < score < 10 ĳԱ
	 */
	int zrevrangebyscore(const char* key, const char* min, const char* max,
		std::vector<string>* out, const int* offset = NULL,
		const int* count = NULL);

	/**
	 *  key У score ֵ min  max ֮( min  max )
	 * ĳԱֵ򼯳Ա score ֵݼ(С)Уֵ(min/max)ʹ
	 * ʾ
	 * @param out 洢ֵ-ԱԵĽڲȵ out.clear()
	 * @param count {const int*} ǿʱʾȡĽгԱ
	 */
	int zrevrangebyscore_with_scores(const char* key, double min,
		double max, std::vector<std::pair<string, double> >& out,
		const int* offset = NULL, const int* count = NULL);
	int zrevrangebyscore_with_scores(const char* key, const char* min,
		const char* max, std::vector<std::pair<string, double> >& out,
		const int* offset = NULL, const int* count = NULL);

	/**
	 *  key гԱ member (± 0 ʼ)򼯳Ա score
	 * ֵݼ(ӴС)
	 * @param key {const char*} 򼯼ֵ
	 * @param member {const char*} Ա
	 * @param len {size_t} member ĳ
	 * @return {int} ±λֵ-1 --  key 򼯶󣬻Ա
	 */
	int zrevrank(const char* key, const char* member, size_t len);
	int zrevrank(const char* key, const char* member);

	/**
	 *  key УԱ member  score ֵ
	 * @param key {const char*} 򼯼ֵ
	 * @param member {const char*} Ա
	 * @param len {size_t} member ĳ
	 * @param result {double&} 洢ֵ
	 * @return {bool} ڻʱ false򷵻 true
	 */
	bool zscore(const char* key, const char* member, size_t len,
		double& result);
	bool zscore(const char* key, const char* member, double& result);

	/**
	 * һ򼯵Ĳи key  numkeys ָ
	 * ò()浽Ŀ; Ĭ£ĳԱ score
	 * ֵи¸óԱ score ֵ֮
	 * @param dst {const char*} Ŀ򼯼ֵ
	 * @param keys Դ򼯼ֵ-ȨؼϣʹȨѡΪ ÿ  ֱ
	 *  ָһ˷(multiplication factor)ÿ򼯵гԱ score
	 *  ֵڴݸۺϺ(aggregation function)֮ǰҪȳԸ򼯵ӣ
	 *  ûָ WEIGHTS ѡ˷ĬΪ 1
	 * @param aggregate {const char*} ۺϷʽĬ SUM ۺϷʽۺϷʽ£
	 *  SUM: мĳԱ score ֵ֮  ΪиóԱ score ֵ
	 *  MIN: мĳԱ С score ֵΪиóԱ score ֵ
	 *  MAX: мĳԱ  score ֵΪиóԱ score ֵ
	 * @return {int} ±浽Ŀ򼯵ĽеԪ(Ա)Դ
	 *  дͬĳԱֻһԱ -1 ʾ
	 */
	int zunionstore(const char* dst, const std::map<string, double>& keys,
		const char* aggregate = "SUM");

	int zunionstore(const char* dst, const std::vector<string>& keys,
		const std::vector<double>* weights = NULL,
		const char* aggregate = "SUM");

	/**
	 * һ򼯵Ľи key  numkeys ָ
	 * ò()浽Ŀ; Ĭ£ĳԱ score
	 * ֵи¸óԱ score ֵ֮
	 * @return {int} ±浽Ŀ򼯵ĽеԪ(Ա)
	 */
	int zinterstore(const char* dst, const std::map<string, double>& keys,
		const char* aggregate = "SUM");

	int zinterstore(const char* dst, const std::vector<string>& keys,
		const std::vector<double>* weights = NULL,
		const char* aggregate = "SUM");
	
	/**
	 * ڵ򼯺еԪأԪسԱԪطֵ
	 * @param cursor {int} αֵʼʱֵд 0
	 * @param out 洢ڲ׷ӷʽαӽУ
	 *  Ϊֹܽ¸ûڵñǰ
	 * @param pattern {const char*} ƥģʽglob 񣬷ǿʱЧ
	 * @param count {const size_t*} ޶ĽǿָʱЧ
	 * @return {int} һαλã£
	 *   0
	 *  -1: 
	 *  >0: αһλãʹжٽҪ outΪпΪ
	 */
	int zscan(const char* key, int cursor,
		std::vector<std::pair<string, double> >& out,
		const char* pattern = NULL, const size_t* count = NULL);

	/**
	 * 򼯺ϵгԱͬķֵʱ 򼯺ϵԪػݳԱֵ
	 * lexicographical ordering Էظ
	 * 򼯺ϼ key У ֵ min  max ֮ĳԱ
	 * @param min {const char*} Сֵ
	 * @param max {const char*} ֵ
	 * @param out {std::vector<string>*} ǿʱ洢
	 * @param offset {const int*} ǿʱЧӽѡȡ±ʼֵ
	 * @param count {const int*} ǿʱЧӽеָ±λѡȡ
	 * @return {int} гԱ
	 *  0: ʾΪջ key 
	 * -1: ʾ key 򼯶
	 * >0: 
	 * עѡ£
	 * 1Ϸ min  max  (  [   ( ʾ䣨ֵָ
	 *   ᱻڷΧ֮ڣ  [ ʾ䣨ֵָᱻڷΧ֮ڣ
	 * 2ֵ +  -  min Լ max о壬  + ʾ
	 *   ޣ  - ʾޡˣһгԱķֵͬ򼯺Ϸ
	 *   ZRANGEBYLEX <zset> - +  򼯺еԪ
	 */
	int zrangebylex(const char* key, const char* min, const char* max,
		std::vector<string>* out, const int* offset = NULL,
		const int* count = NULL);

	/**
	 * һгԱķֵͬ򼯺ϼ key ˵ ᷵ظüУ 
	 * Ա min  max ΧڵԪ
	 * @return {int} Ԫ
	 */
	int zlexcount(const char* key, const char* min, const char* max);

	/**
	 * һгԱķֵͬ򼯺ϼ key ˵ ƳüУ
	 * Ա min  max ΧڵԪ
	 * @return {int} ƳԪ
	 */
	int zremrangebylex(const char* key, const char* min, const char* max);

private:
	int zrange_get(const char* cmd, const char* key, int start,
		int stop, std::vector<string>* result);
	int zrange_get_with_scores(const char* cmd, const char* key, int start,
		int stop, std::vector<std::pair<string, double> >& out);
	int zrangebyscore_get(const char* cmd, const char* key,
		const char* min, const char* max, std::vector<string>* out,
		const int* offset = NULL, const int* count = NULL);
	int zrangebyscore_get_with_scores(const char* cmd,
		const char* key, const char* min, const char* max,
		std::vector<std::pair<string, double> >& out,
		const int* offset = NULL, const int* count = NULL);
	int zstore(const char* cmd, const char* dst,
		const std::map<string, double>& keys, const char* aggregate);
	int zstore(const char* cmd, const char* dst, const std::vector<string>& keys,
		const std::vector<double>* weights, const char* aggregate);
};

} // namespace acl
