#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <vector>
#include <map>
#include "acl_cpp/redis/redis_command.hpp"

namespace acl
{

class redis_client;
class redis_result;
class string;

class ACL_CPP_API redis_pubsub : virtual public redis_command
{
public:
	/**
	 * see redis_command::redis_command()
	 */
	redis_pubsub(void);

	/**
	 * see redis_command::redis_command(redis_client*)
	 */
	redis_pubsub(redis_client* conn);

	/**
	 * see redis_command::redis_command(redis_client_cluster* size_t)
	 */
	redis_pubsub(redis_client_cluster* cluster, size_t max_conns = 0);

	virtual ~redis_pubsub(void);

	/////////////////////////////////////////////////////////////////////

	/**
	 * Ϣ͵ָƵ channel
	 * post a message to a channel
	 * @param channel {const char*} ϢĿƵ
	 *  the specified channel
	 * @param msg {const char*} Ϣ
	 *  the message to be sent
	 * @param len {size_t} Ϣ
	 *  the message's length
	 * @return {int} ɹĸƵĶ
	 *  the number of clients that received the message
	 *  -1ʾ
	 *      error happened
	 *   0ûж
	 *      no client subscribe the channel
	 *  >0ĸƵĶ
	 *      the number of clients that received the message
	 */
	int publish(const char* channel, const char* msg, size_t len);

	/**
	 * ĸһƵϢڵñĲֻܷ͵У
	 * subscribeunsubscribepsubscribepunsubscribeget_messageֻ
	 * ȡƵؽŰѸ
	 * subscribe one or more channel(s). Once the client enters the
	 * subscribed state it is not supposed to issue any other commands,
	 * except for additional SUBSCRIBE, PSUBSCRIBE, UNSUBSCRIBE
	 * and PUNSUBSCRIBE commands
	 * @param first_channel {const char*} ĵƵбĵһǿַ
	 *  Ƶڱбеһ NULL
	 *  the first non-NULL channel in the channel list, and the last
	 *  parameter must be NULL indicating the end of the channel list
	 * @return {int} صǰѾɹĵƵĵƵ
	 *  the number of channels subscribed by the current client
	 */
	int subscribe(const char* first_channel, ...);
	int subscribe(const std::vector<const char*>& channels);
	int subscribe(const std::vector<string>& channels);

	/**
	 * ȡĸһƵϢ
	 * stop listening for messages posted to the given channels
	 * @param first_channel {const char*} ȡƵбĵһƵ
	 *  the fist channel in channel list, and the last parameter must be
	 *  NULL indicating the end of the channel list
	 * @return {int} ʣĵƵĸ
	 *  the rest channels listened by the current client
	 */
	int unsubscribe(const char* first_channel, ...);
	int unsubscribe(const std::vector<const char*>& channels);
	int unsubscribe(const std::vector<string>& channels);

	/**
	* һϸģʽƵÿģʽ * ΪƥڵñĲ
	* ֻܷ͵Уsubscribeunsubscribepsubscribepunsubscribe
	* get_messageֻȡƵؽŰѸ
	* listen for messages published to channels matching the give patterns
	 * @param first_pattern {const char*} һƥģʽ
	 *  the first pattern in pattern list, the last parameter must be NULL
	 *  int the variable args
	 * @return {int} صǰѾɹĵƵĵƵ
	 *  the number of channels listened by the current client
	 */
	int psubscribe(const char* first_pattern, ...);
	int psubscribe(const std::vector<const char*>& patterns);
	int psubscribe(const std::vector<string>& patterns);

	/**
	 * ģʽƥ䴮ȡĸһƵϢ
	 * stop listening for messaged posted to channels matching
	 * the given patterns
	 * @param first_pattern {const char*} һƥģʽ
	 *  the first parttern in a variable args ending with NULL
	 * @return {int} ʣĵƵĸ
	 *  the rest number of channels be listened by the client
	 */
	int punsubscribe(const char* first_pattern, ...);
	int punsubscribe(const std::vector<const char*>& patterns);
	int punsubscribe(const std::vector<string>& patterns);

	/**
	 * ڶƵѭñĵƵлȡϢ
	 * ڵ subscribe  psubscribe ſɵñȡĵƵϢ
	 * get messages posted to channels after SUBSCRIBE or PSUBSCRIBE
	 * @param channel {string&} ŵǰϢƵ
	 *  buffer for storing the channel associate with the msg
	 * @param msg {string&} ŵǰõϢ
	 *  store the message posted to the channel
	 * @return {bool} Ƿɹ false ʾ
	 *  true on success, false on error
	 */
	bool get_message(string& channel, string& msg);

	/**
	 * гǰĻԾƵԾƵָЩһߵƵ ģʽ
	 * ͻ˲
	 * Lists the currently active channels.
	 * @param channels {std::vector<string>*} ǿʱƵ
	 *  store the active channels
	 * @param first_pattern {const char*} Ϊӵƥģʽһƥַ
	 *  ָΪ NULLʱȡָеĻԾƵڱζһΪ NULL
	 *  the first pattern in a variable args ending with NULL arg, and
	 *  the first arg can be NULL.
	 * @return {int} ػԾƵ -1 ʾ
	 *  the number of active channels. -1 if error
	 *
	 *  ɹͨһʽ
	 *  1෽ get_value ָ±Ԫ
	 *  2෽ get_child ָ±Ԫض(redis_resultȻͨ
	 *     redis_result::argv_to_string Ԫ
	 *  3෽ get_result ȡܽ redis_resultȻͨ
	 *     redis_result::get_child һԪضȻͨʽ 2 ָ
	 *     ķøԪص
	 *  4෽ get_children ýԪͨ redis_result 
	 *     ķ argv_to_string ÿһԪضлԪ
	 *  5ڵ÷дǿյĴ洢ĵַ
	 *
	 */
	int pubsub_channels(std::vector<string>* channels,
		const char* first_pattern, ...);
	int pubsub_channels(const std::vector<const char*>& patterns,
		std::vector<string>* channels);
	int pubsub_channels(const std::vector<string>& patterns,
		std::vector<string>* channels);

	/**
	 * ظƵĶ ģʽĿͻ˲
	 * Returns the number of subscribers (not counting clients
	 * subscribed to patterns) for the specified channels.
	 * @param out {std::map<string, int>&} 洢ѯ out->first 
	 *  Ƶout->second ƵĶ
	 *  store the results
	 * @param first_pattern {const char*} Ϊӵƥģʽһƥַ
	 *  ָΪ NULLʱȡָеĻԾƵڱζһΪ NULL
	 *  the first pattern in a variable args ending with NULL arg, and
	 *  the first arg can be NULL.
	 * @return {int} Ƶ-1 ʾ
	 */
	int pubsub_numsub(std::map<string, int>& out,
		const char* first_channel, ...);
	int pubsub_numsub(const std::vector<const char*>& channels,
		std::map<string, int>& out);
	int pubsub_numsub(const std::vector<string>& channels,
		std::map<string, int>& out);

	/**
	 * ضģʽصĲǶģʽĿͻ˵ ǿͻ˶ĵ
	 * ģʽܺ
	 * Returns the number of subscriptions to patterns.
	 * @return {int} ͻжģʽܺͣ-1 ʾ
	 *  the number of patterns all the clients are subscribed to,
	 *  -1 if error.
	 */
	int pubsub_numpat();

private:
	int subop(const char* cmd, const std::vector<const char*>& channels);
	int subop(const char* cmd, const std::vector<string>& channels);
	int check_channel(const redis_result* obj, const char* cmd,
		const string& channel);
	int pubsub_numsub(std::map<string, int>& out);
};

} // namespace acl
