#ifndef	ACL_TEST_GLOBAL_INCLUDE_H
#define	ACL_TEST_GLOBAL_INCLUDE_H

# ifdef	__plusplus
extern "C" {
# endif

#include "stdlib/acl_define.h"
#include "stdlib/acl_loadcfg.h"
#include "stdlib/acl_array.h"

#include "acl_test_struct.h"

/*-----------------------  ڲӿ  -----------------------------------*/
/* in acl_test_cfg.c */
ACL_API ACL_ARRAY *aut_parse_args_list(const char *str_in);
ACL_API void aut_free_args_list(ACL_ARRAY *a);

/* in acl_test_cfg_general.c */
ACL_API int aut_cfg_add_general_line(const ACL_CFG_LINE *line);

/* in acl_test_inner.c*/
ACL_API AUT_LINE *aut_add_inner_cmd(const ACL_CFG_LINE *line);

/* in acl_test_outer.c */
ACL_API AUT_LINE *aut_add_outer_cmd(const ACL_CFG_LINE *line);

/* in acl_test_token.c */
ACL_API AUT_CMD_TOKEN *aut_line_peer_token(const AUT_LINE *test_line);
ACL_API AUT_LINE *aut_line_peer(const AUT_LINE *test_line);

/* in acl_test_misc.c */
ACL_API void aut_line_free(void *ctx);

/*------------------ ⲿԵõһЩӿ ----------------------------*/

/* in acl_test_cfg.c */

/**
 * :  ȡļ
 * @param  pathname ļ
 * @return  0 ʾɹ, -1 ʾʧ
 */
ACL_API int aut_cfg_parse(const char *pathname);

/**
 * : ӡЧ
 * @return ɹ: 0, ʧ: -1
 */
ACL_API int aut_cfg_print(void);

/* in acl_test_misc.c */

ACL_API AUT_LINE *aut_line_new(const ACL_CFG_LINE *cfg_line);

/**
 * : öӦֵòϵ, Զ̬ʾ
 * @param cmd_name 
 * @return ɹ: ǿָ, ʧ: ָ
 */
ACL_API const ACL_ARRAY *aut_args_get(const char *cmd_name);

/**
 * : ЧĿ
 * @return ɹ: >0, ʧ: -1
 */
ACL_API int aut_size(void);

/**
 * : ±ֵȡӦЧнṹָ
 * @param idx ±ֵ
 * @return ɹ: ǿսṹָ, ʧ: ָ
 *
 */
ACL_API AUT_LINE *aut_index(int idx);

/**
 * : ȽǷ  test_line ¼ͬ
 * @param test_line: ĳһЧصĽṹָ
 * @param cmd_name: ѯ
 * @return 򷵻 0, 򷵻ط 0
 */
ACL_API int aut_line_cmdcmp(const AUT_LINE *test_line, const char *cmd_name);

/**
 * : ȽִнֵǷļĽֵ
 * @param test_line: ĳһЧصĽṹָ
 * @param result: ĳִнֵ
 * @return 򷵻 0, 򷵻ط 0
 */
ACL_API int aut_line_resultcmp(const AUT_LINE *test_line, int result);

/**
 * : ȡøЧļекλ
 * @param test_line: ĳһЧصĽṹָ
 * @return ɹ: >=0, ֵΪк, ʧ: < 0
 */
ACL_API int aut_line_number(const AUT_LINE *test_line);

/**
 * : ȡеЧк
 * @param test_line: ĳһЧصĽṹָ
 * @return ɹ: >=0, ֵΪк, ʧ: < 0
 */
ACL_API int aut_line_valid_linenum(const AUT_LINE *test_line);

/**
 * : øе
 * @param test_line: ĳһЧصĽṹָ
 * @return ȷ 0, 򷵻ط 0
 */
ACL_API const char *aut_line_cmdname(const AUT_LINE *test_line);

/**
 * : ظвĸ
 * @param test_line: ĳһЧصĽṹָ
 * @return ɹ: >= 0, ʧ: -1
 */
ACL_API int aut_line_argc(const AUT_LINE *test_line);

/**
 * : ȡļеĲֵ
 * @param  test_line AUT_LINE ṹָ
 * @param  name ҪҵĹؽ
 * @return ɹ: ǿָ, ʧ: ָ
 */
ACL_API const char *aut_line_getvalue(const AUT_LINE *test_line, const char *name);

/**
 * : ظе
 * @param test_line: ĳһЧصĽṹָ
 * @return ɹ: ǿָ, ʧ: ָ
 */
ACL_API const char *aut_line_argstr(const AUT_LINE *test_line);

/**
 * : ظִнֵ
 * @param test_line: ĳһЧصĽṹָ
 * @return ִнֵ
 * ˵: ûг, ĲǷ򷵻 -1, ޷ָ -1 ֵ
 *       Ƿִֵнֵ
 */
ACL_API int aut_line_result(const AUT_LINE *test_line);

/**
 * : ǷеĽֶ
 * @param test_line: ĳһЧصĽṹָ
 * @return : 1, : 0
 */
ACL_API int aut_line_stop(const AUT_LINE *test_line);

/**
 * : ڲֶ, ڲҪ
 * @param test_line: ĳһЧصĽṹָ
 * @return : 1, : 0
 */
ACL_API int aut_line_reserved(AUT_LINE *test_line);

/**
 * : ߿԰ԼĲӵ test_line ֮
 * @param test_line: ĳһЧصĽṹָ
 * @param arg: ûҪӵĲ
 * @return ɹ: 0, ʧ: -1
 */
ACL_API int aut_line_add_arg(AUT_LINE *test_line, void *arg);

/**
 * :  test_line ɾûԼĲ
 * @param test_line: ĳһЧصĽṹָ
 * @param free_fn: ûԼ
 */
ACL_API void aut_line_del_arg(AUT_LINE *test_line, void (*free_fn) (void *));

/**
 * :  test_line ȡûԼĲ
 * @param test_line: ĳһЧصĽṹָ
 * @return ɹ: ǿָ, ָΪпڲǿ
 */
ACL_API void *aut_line_get_arg(const AUT_LINE *test_line);

/**
 * : ȡеĽβ
 * @param start_linenum ʼִек
 * @return >= 0 ok; < 0 δҵ
 */
ACL_API int aut_end_linenum(int start_linenum);

/**
 * : ӵǰṩ test_line , һֱҵĳṩ־λͬ
 *       test_line.
 * @param test_line: ĳһЧصĽṹָ
 * @param flag: defined as AUT_FLAG_ in acl_test_struct.h
 * @return != NULL, ok find it; == NULL, not found.
 */
ACL_API const AUT_LINE *aut_lookup_from_line(const AUT_LINE *test_line, int flag);

/* in acl_test_runner.c */

/**
 *  ִעĲԺ, κһִеĽԤڽһ
 *      ִ
 * @return ɹ: 0, ʧ: -1
 */
ACL_API int aut_start(void);

/**
 * Թ̽Ҫô˺ͷһЩڴԴ
 */
ACL_API void aut_stop(void);

/**
 *   ҪеԪԵע
 * @param test_fn_tab ԪԺṹ
 */
ACL_API void aut_register(const AUT_FN_ITEM test_fn_tab[]);

/* in acl_test_loop.c */
ACL_API AUT_LINE *aut_loop_make_begin(const ACL_CFG_LINE *cfg_line);
ACL_API AUT_LINE *aut_loop_make_break(const ACL_CFG_LINE *cfg_line);
ACL_API AUT_LINE *aut_loop_make_end(const ACL_CFG_LINE *cfg_line);
ACL_API const AUT_LINE *aut_loop_end(const AUT_LINE *test_begin);
ACL_API int aut_loop_count(const AUT_LINE *test_line);
ACL_API int aut_loop_from(const AUT_LINE *test_line);
ACL_API int aut_loop_to(const AUT_LINE *test_line);

/* in acl_test_log.c */

ACL_API int  aut_log_open(const char *pathname);
ACL_API void aut_log_info(const char *format, ...);
ACL_API void aut_log_warn(const char *format, ...);
ACL_API void aut_log_error(const char *format, ...);
ACL_API void aut_log_fatal(const char *format, ...);
ACL_API void aut_log_panic(const char *format, ...);

# ifdef	__plusplus
}
# endif

#endif

