#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stdlib/pipe_stream.hpp"

namespace acl {
	class string;

class ACL_CPP_API mime_code : public pipe_stream
{
public:
	/**
	 * 캯
	 * @param addCrlf {bool} ʽʱǷĩβ "\r\n"
	 * @param addInvalid {bool} ʽʱǷǷַǷԭ
	 * @param encoding {const char*} ͱʶ
	 */
	mime_code(bool addCrlf, bool addInvalid, const char* encoding_type);
	virtual ~mime_code() = 0;

	/**
	 * ñͱʶ
	 * @return {const char*}
	 */
	const char* get_encoding_type() const
	{
		return encoding_type_;
	}

	/* ʽ뺯ʹ÷ encode_update->encode_update->...->encode_finish */

	/**
	 * , Դ,  out , 
	 * ݲʱ, ڲʱ
	 * @param src {const char*} Դݵַ
	 * @param n {int} Դݳ
	 * @param out {string*} 洢, ͨȽ
	 *  ô˺ǰ out->length() жϸúǽ
	 *  ̻ʱ; ʹ out еĽݣ
	 *  Ӧõ out->clear() ù
	 */
	virtual void encode_update(const char *src, int n,
		string* out);

	/**
	 * Ҫô˺Կܴʱе
	 * Դݽı
	 * @param out {string*} 洢, ͨȽ
	 *  ô˺ǰ out->length() жϸúǽ
	 *  ̻ʱ; ʹ out еĽݣ
	 *  Ӧõ out->clear() ù
	 */
	virtual void encode_finish(string* out);

	/* ʽ뺯ʹ÷ decode_update->decode_update->...->decode_finish */

	/**
	 * , Ӿ, н, 
	 * ݲʱֽ, ڲʱ
	 * , ʱŽн
	 * @param src {const char*} 
	 * @param n {int} ݳ
	 * @param out {string*} 洢, ͨȽ
	 *  ô˺ǰ out->length() жϸúǽ
	 *  ̻ʱ; ʹ out еĽݣ
	 *  Ӧõ out->clear() ù
	 */
	virtual void decode_update(const char *src, int n, string* out);

	/**
	 * Ҫô˺Կܴʱе
	 * ԴݽĽ
	 * @param out {string*} 洢, ͨȽ
	 *  ô˺ǰ out->length() жϸúǽ
	 *  ̻ʱ; ʹ out еĽݣ
	 *  Ӧõ out->clear() ù
	 */
	virtual void decode_finish(string* out);

	/**
	 * ڲ
	 */
	virtual void reset();

	/**
	 * ڱǷԶÿ "\r\n"
	 * @param on {bool}
	 */
	virtual void add_crlf(bool on);

	/**
	 * ڽǷַǷڽ
	 * @param on {bool}
	 */
	virtual void add_invalid(bool on);

	/**
	 * ıӦĽ
	 * @param toTab {const unsigned char*} ַ
	 * @param out {string*} 洢
	 */
	static void create_decode_tab(const unsigned char *toTab, string *out);

	/**
	 * δ麯ʹûĬ麯ʱ
	 * ô˺Լı, ַ
	 * @param toTab {const unsigned char*} 
	 * @param unTab {const unsigned char*} 
	 * @param fillChar {unsigned char} ַ
	 */
	void init(const unsigned char* toTab,
		const unsigned char* unTab, unsigned char fillChar);

	/**
	 * תĹ״̬Ϊתɱͽɣ
	 * ʹ pipe_stream ʽʱָת״̬
	 * ָǴڱ״̬ǽ״̬
	 * @param encoding {bool} Ϊ true ʾΪ״̬
	 *  Ϊ״̬
	 */
	void set_status(bool encoding = true);

	// pipe_stream 麯

	virtual int push_pop(const char* in, size_t len,
		string* out, size_t max = 0);
	virtual int pop_end(string* out, size_t max = 0);
	virtual void clear();

	/**
	 * ̬ݱ MIME_ENC_XXX (μmime_define.hpp) 
	 * Ӧı󣬵е encoding Ϊ MIME_ENC_QP,
	 * MIME_ENC_BASE64, MIME_ENC_UUCODE, MIME_ENC_XXCODE
	 * @param encoding {int} ֻͣΪ MIME_ENC_QP, MIME_ENC_BASE64,
	 *  MIME_ENC_UUCODE, MIME_ENC_XXCODE
	 * @param warn_unsupport {bool} δҵƥıʱǷ¼Ϣ
	 * @return {mime_code*} 󣬵δҵƥıʱ NULL
	 */
	static mime_code* create(int encoding, bool warn_unsupport = true);

private:
	void encode(string* out);
	void decode(string* out);

	char  m_encodeBuf[57];
	int   m_encodeCnt;
	char  m_decodeBuf[76];
	int   m_decodeCnt;
	bool  m_addCrLf;
	bool  m_addInvalid;
	bool  m_encoding;
	const unsigned char *m_toTab;
	const unsigned char *m_unTab;
	unsigned char m_fillChar;
	string* m_pBuf;
	char* encoding_type_;
};

} // namespace acl
