#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <map>

namespace acl {

class session;

/**
 *  HttpSession ࣬Ŀǰݴ洢ִֻ֧ memcached 
 */
class ACL_CPP_API HttpSession
{
public:
	/**
	 * 캯
	 * @param session {session&} 
	 */
	HttpSession(session& session);
	virtual ~HttpSession(void);

	/**
	 * ÿͻڷ˴洢 session ֵַ
	 * @param name {const char*} session ǿ
	 * @return {const char*} session ֵصַԶǿָ룬û
	 *  ͨжϷصַǷΪմ("\0")жǷڻ
	 *  עúطǿݺûӦ̱˷ֵΪ´
	 *      ÿܻʱ
	 */
	virtual const char* getAttribute(const char* name) const;

	/**
	 * ÿͻڷ˴洢 session Ķֵ
	 * @param name {const char*} session ǿ
	 * @param size {size_t*} òǿֵǿʱַָ
	 *  洢ֵĴС
	 * @return {const void*} session ֵΪָʱ˵
	 *  ڲѯʧ
	 *  עúطǿݺûӦ̱˷ֵΪ´
	 *      ÿܻʱ
	 */
	virtual const void* getAttribute(const char* name, size_t* size) const;

	/**
	 * ÷ session ֵַ
	 * @param name {const char*} session ǿ
	 * @param value {const char*} session ֵǿ
	 * @return {bool}  false ˵ʧ
	 */
	virtual bool setAttribute(const char* name, const char* value);

	/**
	 * ÷ session Ķֵ
	 * @param name {const char*} session ǿ
	 * @param value {const void*} session ֵǿ
	 * @param len {size_t} value ݳ
	 * @return {bool}  false ˵ʧ
	 */
	virtual bool setAttribute(const char* name, const void* value, size_t len);

	/**
	 * ɾͻ session еĳֵ
	 * @param name {const char*} session ǿ
	 * @return {bool} ɾǷɹ
	 */
	virtual bool removeAttribute(const char* name);

	/**
	 *  session ڻϵ
	 * @param ttl {time_t} ()
	 * @return {bool} Ƿɹ
	 */
	virtual bool setMaxAge(time_t ttl);

	/**
	 * ʹ session ӷ˵Ļɾʹ session ʧЧ
	 * @return {bool} Ƿʹ session ʧЧ
	 */
	virtual bool invalidate(void);

	/**
	 *  session ID ʶ
	 * @return {const char*} Զ '\0' βķǿָ룬ɸݷ
	 *  ֵǷΪմ("\0")ж sid Ƿ
	 */
	const char* getSid(void) const;

protected:
	session& session_;
};

} // namespace acl
