#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <list>
#include "acl_cpp/http/http_type.hpp"

namespace acl {

class dbuf_pool;

/**
 * http Эͷ cookie 
 */
class ACL_CPP_API HttpCookie
{
public:
	/**
	 * 캯
	 * @param name {const char*} cookie Ϊǿַַ > 0
	 * @param value {const char*} cookie ֵָǿգַȿΪ 0
	 * עڲ
	 * @param dbuf {dbuf_pool*} ǿʱΪڴ
	 */
	HttpCookie(const char* name, const char* value, dbuf_pool* dbuf = NULL);

	/**
	 * ʹøù캯ʱʹ setCookie  cookie 
	 * @param dbuf {dbuf_pool*} ǿʱΪڴ
	 */
	HttpCookie(dbuf_pool* dbuf = NULL);

	/**
	 * 캯
	 * @param cookie {const HttpCookie*} ò NULLڲƿ
	 *  Ա
	 * @param dbuf {dbuf_pool*} ǿʱΪڴ
	 */
	HttpCookie(const HttpCookie* cookie, dbuf_pool* dbuf = NULL);
	/**
	 * 
	 */
	~HttpCookie(void);

	/**
	 *  Set-Cookie: xxx=xxx; domain=xxx; expires=xxx; path=xxx; max-age=xxx; ...
	 * ݽз
	 * @param value {const char*}  xxx=xxx; domain=xxx; ... 
	 * @return {bool} ǷϷ
	 */
	bool setCookie(const char* value);

	/**
	 * ̬ͨ˺ͷ
	 */
	void destroy();

	/**
	 *  cookie 
	 * @param domain {const char*} cookie 
	 * @return {HttpCookie&} رãû
	 */
	HttpCookie& setDomain(const char* domain);

	/**
	 *  cookie  path ֶ
	 * @param path {const char*} path ֵֶ
	 * @return {HttpCookie&} رãû
	 */
	HttpCookie& setPath(const char* path);

	/**
	 *  cookie ĹʱΣõǰʱʱ伴Ϊ cookie
	 * Ĺʱ
	 * @param timeout {time_t} ʱֵ(λΪ)ǰʱӸʱ
	 *  cookie Ĺʱ
	 * @return {HttpCookie&} رãû
	 */
	HttpCookie& setExpires(time_t timeout);

	/**
	 *  cookie Ĺʱַ
	 * @param expires {const char*} ʱ
	 * @return {HttpCookie&} رãû
	 */
	HttpCookie& setExpires(const char* expires);

	/**
	 *  cookie 
	 * @param max_age {int} 
	 * @return {HttpCookie&} رãû
	 */
	HttpCookie& setMaxAge(int max_age);

	/**
	 *  cookie ֵ
	 * @param name {const char*} 
	 * @param value {const char*} ֵ
	 * @return {HttpCookie&} رãû
	 */
	HttpCookie& add(const char* name, const char* value);

	/**
	 *  cookie ƣȡڹֵ
	 * @return {const char*} Ϊȴ 0 ַԶǿָ
	 * עûڵ HttpCookie(const char*, const char*) 
	 *      setCookie(const char*) ɹſԵøú
	 *     򷵻ص "\0"
	 */
	const char* getName(void) const;

	/**
	 *  cookie ֵȡڹ캯ֵ
	 * @return {const char*} ǿָ룬пǿַ("\0")
	 */
	const char* getValue(void) const;

	/**
	 * ַʽĹʱ
	 * @return {const char*} ǿָ룬ֵΪ "\0" ʾ
	 */
	const char* getExpires(void) const;

	/**
	 *  cookie 
	 * @return {const char*} ǿָ룬ֵΪ "\0" ʾ
	 */
	const char* getDomain(void) const;

	/**
	 *  cookie Ĵ洢·
	 * @return {const char*} ǿָ룬ֵΪ "\0" ʾ
	 */
	const char* getPath(void) const;

	/**
	 *  cookie 
	 * @return {int}  -1 ʱʾûи Max-Age ֶ
	 */
	int  getMaxAge(void) const;

	/**
	 * öӦĲֵ
	 * @param name {const char*} 
	 * @param case_insensitive {bool} ǷִСдtrue ʾ
	 *  ִСд
	 * @return {const char*} ǿָ룬ֵΪ "\0" ʾ
	 */
	const char* getParam(const char* name,
		bool case_insensitive = true) const;

	/**
	 * ø cookie ĳ cookie  cookie ֵ֮
	 * Լֵ
	 * @return {const std::list<HTTP_PARAM*>&}
	 */
	const std::list<HTTP_PARAM*>& getParams(void) const;

private:
	dbuf_pool* dbuf_internal_;
	dbuf_pool* dbuf_;
	char  dummy_[1];
	char* name_;
	char* value_;
	std::list<HTTP_PARAM*> params_;

	bool splitNameValue(char* data, HTTP_PARAM* param);
};

} // namespace acl end
