#ifndef ACL_VSTREAM_NET_INCLUDE_H
#define ACL_VSTREAM_NET_INCLUDE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "stdlib/acl_define.h"
#include "stdlib/acl_vstream.h"

/**
 * ĳַUNIXԼ׽֣
 * @param addr {const char*} ַ,
 *  磺127.0.0.1:80; ׽(UNIXƽ̨) 磺/tmp/test.sock
 * @param qlen {int} еĳ
 * @param block_mode {int} Ƿ, ACL_BLOCKING: ģʽ,
 *  ACL_NON_BLOCKING: ģʽ
 * @param bufsize {int} յµĿͻ׽ֵIOС
 * @param rw_timeout {int} յµĿͻ׽ֵIOдʱʱ䣬λΪ
 * @return {ACL_VSTREAM*} ָ
 */
ACL_API ACL_VSTREAM *acl_vstream_listen_ex(const char *addr, int qlen,
		int block_mode, int io_bufsize, int rw_timeout);

/**
 * ĳַUNIXԼ׽֣
 * @param addr {const char*} ַ
 *  磺127.0.0.1:80, ׽, 磺/tmp/test.sockַΪ ip:0 ʱ˿ں
 *  ɲϵͳԶ
 * @param qlen {int} еĳ
 * @return {ACL_VSTREAM*} ָ
 */
ACL_API ACL_VSTREAM *acl_vstream_listen(const char *addr, int qlen);

/**
 * Ӽнһͻ
 * @param listen_stream {ACL_VSTREAM*} 
 * @param client_stream {ACL_VSTREAM*} ظõ ACL_VSTREAM ṹ
 *  Ϊڲһµ ACL_VSTREAM øýṹռ
 * @param ipbuf {char*} Ϊ洢ͻ˵IPַ
 * @param bsize {int}  ipbuf Ϊգʾ ipbuf ĿռС
 * @return {ACL_VSTREAM*} Ϊʾ½յĿͻ
 */
ACL_API ACL_VSTREAM *acl_vstream_accept_ex(ACL_VSTREAM *listen_stream,
		ACL_VSTREAM *client_stream, char *ipbuf, int bsize);

/**
 * Ӽнһͻ
 * @param listen_stream {ACL_VSTREAM*} 
 * @param ipbuf {char*} Ϊ洢ͻ˵IPַ
 * @param bsize {int}  ipbuf Ϊգʾ ipbuf ĿռС
 * @return {ACL_VSTREAM*} Ϊʾ½յĿͻ
 */
ACL_API ACL_VSTREAM *acl_vstream_accept(ACL_VSTREAM *listen_stream,
		char *ipbuf, int bsize);

/**
 * Զӷ
 * @param addr {const char*} ַ, һ׽ӿڷ(UNIXƽ̨),
 *  ׽ӵַ/tmp/test.sock; һTCPַʽΪ:
 *  [${local_ip}@]${remote_addr}, : 60.28.250.199@www.sina.com:80, ˼ǰ󶨱
 *  ַΪ: 60.28.250.199, Զ www.sina.com  80 ˿, OSԶ󶨱
 *  IP ַдΪwww.sina.com:80
 * @param block_mode {int} ӻǷӣACL_BLOCKING, ACL_NON_BLOCKING
 * @param conn_timeout {int} ӳʱʱ()
 * @param rw_timeout {int} ɹĶдʱʱ䣬λΪ
 * @param bufsize {int} ɹĻС
 * @param errorp {int*} Ϊգ洢ʧܺĴ
 * @return {ACL_VSTREAM*} Ϊգʾӳɹ
 */
ACL_API ACL_VSTREAM *acl_vstream_connect_ex(const char *addr, int block_mode,
		int conn_timeout, int rw_timeout, int bufsize, int *errorp);

/**
 * Զӷ
 * @param addr {const char*} ַʽ磺127.0.0.1
 *   ׽ӵַ/tmp/test.sock
 * @param block_mode {int} ӻǷӣACL_BLOCKING, ACL_NON_BLOCKING
 * @param connect_timeout {int} ӳʱʱ()
 * @param rw_timeout {int} ɹĶдʱʱ䣬λΪ
 * @param rw_bufsize {int} ɹĻС
 * @return {ACL_VSTREAM*} Ϊգʾӳɹ
 */
ACL_API ACL_VSTREAM *acl_vstream_connect(const char *addr, int block_mode,
		int connect_timeout, int rw_timeout, int rw_bufsize);

/**
 *  UDP ͨţú󶨱 UDP ַ󶨳ɹ򴴽
 * ACL_VSTREAM , û ACL_VSTREAM Ķдӿ
 * @param addr {const char*}  UDP ַʽip:portַ ip:0 
 *  ϵͳԶ䱾ض˿ں
 * @param rw_timeout {int} дʱʱ()
 * @return {ACL_VSTREAM*}  NULL ʾʧ
 */
ACL_API ACL_VSTREAM *acl_vstream_bind(const char *addr, int rw_timeout);

/**
 * Ϊ UDP IO ģʽ
 * @param stream {ACL_VSTREAM*}
 */
ACL_API void acl_vstream_set_udp_io(ACL_VSTREAM *stream);

#ifdef __cplusplus
}
#endif

#endif

