#ifndef __LIB_ICMP_TYPE_INCLUDE_H__
#define __LIB_ICMP_TYPE_INCLUDE_H__

typedef struct ICMP_CHAT ICMP_CHAT;
typedef struct ICMP_STAT ICMP_STAT;
typedef struct ICMP_HOST ICMP_HOST;
typedef struct ICMP_PKT ICMP_PKT;
typedef struct ICMP_PKT_STATUS ICMP_PKT_STATUS;

/**< ICMP ͨŹÿ PING Ӧ״̬Ϣ */
struct ICMP_STAT {
	double tmin;                    /**< ʱ */
	double tmax;                    /**< ʱ */
	double tsum;                    /**< ʱ */
	double tave;                    /**< ƽʱ */
	size_t nsent;                   /**< Ѿ͵İ */
	size_t nreceived;               /**< Ѿյİ */
	double loss;					/**< ʧİ */
};

/**< ICMP ͵ÿ PING ֮״̬Ӧ */
struct ICMP_PKT_STATUS {
	size_t reply_len;               /**< ظݳ */
	char  frome_ip[32];             /**< Դַ */

	double rtt;                     /**< ʱ()(Round Trip Time) */
	unsigned short seq;             /**< к(seq no) */
	unsigned char ttl;              /**< ʱ(time to live) */
	char status;
#define ICMP_STATUS_OK          0
#define ICMP_STATUS_UNREACH     1
#define ICMP_STATUS_TIMEOUT     2
};

/**< ĿϢṹ */
struct ICMP_HOST {
	ICMP_STAT icmp_stat;        /**< ICMP ͨŹе״̬ */
	char dest_ip[32];           /**< ĿIPַ */
	char domain[64];            /**< ĿIPӦ */
	struct sockaddr_in dest;    /**< ͰʱĿַ */
	struct sockaddr_in from;    /**< հʱԴַ */
	int   from_len;             /**< հʱ洢 from еĵַ */
	int   delay;                /**< PINGʱ䣬λΪ */
	int   timeout;              /**< ʱʱ */
	size_t dlen;                /**< ÿͰĴС(ֽ) */
	size_t npkt;                /**< õĿͰĸ */
	size_t nsent;               /**< Ѿ͸Ŀĸ */

	char  enable_log;           /**< ǷӦϢ־ */
	ACL_RING host_ring;         /**< ɴ ICMP_CHAT->host_head  */
	ACL_RING pkt_head;          /**< ͸Ŀݰͷ */
	ICMP_CHAT *chat;            /**< ͨŶ */

	/**< 㱨ͰӦ״̬ */
	void (*stat_respond)(ICMP_PKT_STATUS*, void*);

	/**< ÷ͰӦʱ */
	void (*stat_timeout)(ICMP_PKT_STATUS*, void*);

	/**< ɴ */
	void (*stat_unreach)(ICMP_PKT_STATUS*, void*);

	/**< İʱĻص */
	void (*stat_finish)(ICMP_HOST*, void*);

	void *arg;                  /**< Ӧôݵ˽вַ */
};

#endif
