#pragma once
#include "acl_cpp/acl_cpp_define.hpp"

#ifdef HOOK_NEW

#if defined(_WIN32) || defined(_WIN64)
# ifdef NDEBUG
void* operator new(size_t n);
void  operator delete(void *p);
# endif
#else
#include <new>
void* operator new(size_t n)  throw (std::bad_alloc);
void  operator delete(void *p) throw();
#endif

#endif

namespace acl {

ACL_CPP_API void  acl_slice_init(void);

/**
 * ڴ亯
 * @param size {size_t} ҪĳߴС
 * @param filename {const char*} Դ
 * @param funcname {const char*} 
 * @param lineno {int} Դк
 * @return {void*} ڴַڴʧܣֱabort
 */
ACL_CPP_API void* acl_new(size_t size, const char* filename,
	const char* funcname, int lineno);


/**
 * ͷڴ溯
 * @param ptr {void*} ڴַ
 * @param filename {const char*} Դ
 * @param funcname {const char*} 
 * @param lineno {int} Դк
 */
ACL_CPP_API void  acl_delete(void *ptr, const char* filename,
	const char* funcname, int lineno);

}
