#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <vector>
#include <list>
#include <map>
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/redis/redis_command.hpp"

namespace acl
{

class redis_result;
class redis_node;
class redis_slot;

class ACL_CPP_API redis_cluster : virtual public redis_command
{
public:
	/**
	 * see redis_command::redis_command()
	 */
	redis_cluster();

	/**
	 * see redis_command::redis_command(redis_client*)
	 */
	redis_cluster(redis_client* conn);

	/**
	 * see redis_command::redis_command(redis_client_cluster* size_t)
	 */
	redis_cluster(redis_client_cluster* cluster, size_t max_conns);

	virtual ~redis_cluster();

	/**
	 * ӿõĹϣۣС 0 Ĺϣֵʾ
	 * add some hash-slots, the last slot value must be < 0 indicating
	 * the end of the slots array
	 * @param first {int} һϣֵۣ >= 0 Ч
	 *  the first hash-slot which must be >= 0
	 * @param slot_list {const int[]} ҪӵĹϣ۵б
	 *  the hash-slots array to be added
	 * @param n {size_t} the count of the hash-slots list
	 * @param slot_list {const std::vector<init>&} ҪӵĹϣ۵б
	 *  the hash-slots list to be added
	 * @return {bool} Ƿɹ
	 *  return true if successful
	 */
	bool cluster_addslots(int first, ...);
	bool cluster_addslots(const int slot_list[], size_t n);
	bool cluster_addslots(const std::vector<int>& slot_list);

	/**
	 * ɾϣۣС 0 Ĺϣ۱ʾ
	 * remove some hash-slots, the last slot value must be < 0 indicating
	 * the end of the slots array
	 * @param first {int} һϣֵۣ >= 0 Ч
	 *  the first hash-slot which must be >= 0
	 * @param slot_list {const int[]} ҪɾĹϣ۵б
	 *  the hash-slots array to be removed
	 * @param n {size_t} the count of the hash-slots list
	 * @param slot_list {const std::vector<init>&} ҪɾĹϣ۵б
	 *  the hash-slots array to be removed
	 * @return {bool} Ƿɹ
	 *  return true if successful
	 */
	bool cluster_delslots(int first, ...);
	bool cluster_delslots(const int slot_list[], size_t n);
	bool cluster_delslots(const std::vector<int>& slot_list);

	/**
	 * ĳϣ۵ǰ洢ļ
	 * get keys array stored in one specified hash-slot
	 * @param slot {size_t} ϣֵ
	 *  the specified hash-slot
	 * @param max {size_t} ƵĽ
	 *  limit the max results count
	 * @param result {std::list<acl::string>&} 洢
	 *  stored the results
	 * @return {int} ѯĸ-1 ʾ
	 *  >= 0 if OK, -1 if error
	 */
	int cluster_getkeysinslot(size_t slot, size_t max, std::list<string>& result);

	/**
	 * ڽ redis Ⱥʱʹôһ redis ӱĽ
	 * let one redis node to link to the other redis node
	 * when buiding the redis cluster
	 * @param ip {const char*} ӵһ redis  IP ַ
	 *  the other redis node's ip to be linked
	 * @param port {int} ӵһ redis  port ˿
	 *  the other redis node's port to be linked
	 * @return {bool} Ƿɹ
	 *  if the linking is successful
	 */
	bool cluster_meet(const char* ip, int port);

	/**
	 * һ redis ״̬ʹ֮ӼȺ룬ϣ-ĶӦϵ
	 * ÷ͬ reset_soft
	 * reset one redis node's status, escaping from the other nodes
	 * of the redis cluster, and clearing slot-to-nodes mapping;
	 * same as reset_soft
	 * @return {bool} Ƿɹ
	 *  if the operation is successful
	 */
	bool cluster_reset();
	bool cluster_reset_hard();
	bool cluster_reset_soft();

	/**
	 * 趨ĳϣڵǰ redis ڵ״̬
	 * set the hash-slot in importing status from the other node
	 * to the current node
	 * @param slot {size_t} ϣֵ
	 *  the hash-slot value
	 * @param src_node {const char*} ùϣ۵ redis Դ
	 *  the source redis-node of the hash-slot importing from
	 * @return {boo} ״̬Ƿɹ
	 *  if success for setting the slot's status
	 */
	bool cluster_setslot_importing(size_t slot, const char* src_node);

	/**
	 * 趨ĳϣڵǰ redis Ǩ״̬
	 * set the hash-slot in migrating status to the other node
	 * from the current node
	 * @param slot {size_t} ϣֵ
	 *  the hash-slot value
	 * @param src_node {const char*} ùϣ۵ redis ǨĿ
	 *  the target redis-node of the hash-slot migrating to
	 * @return {boo} ״̬Ƿɹ
	 *  if success for setting the slot's status
	 */
	bool cluster_setslot_migrating(size_t slot, const char* dst_node);

	/**
	 * /Ǩƹϣɺʹô˲ָùϣΪȶ״̬
	 * set the hash-slot stable after importing or migrating
	 * @param slot {size_t} ϣֵ
	 *  the hash-slot value
	 * @return {bool} ״̬Ƿɹ
	 *  if success for setting the slot's status
	 */
	bool cluster_setslot_stable(size_t slot);

	/**
	 * ָĹϣָĳ redis 㣬ָнΪӵΪ
	 * μٷĵ
	 * set one hash-slot to one redis node, for more help see online doc
	 * @param slot {size_t} ϣֵ
	 *  the hash-slot to be set
	 * @param node {const char*} ոùϣ۵ redis 
	 *  the redis node to be holding the hash-slot
	 * @return {bool} Ƿɹ
	 *  if the operation is successful
	 */
	bool cluster_setslot_node(size_t slot, const char* node);

	/**
	 * ĳָ redis 㱨
	 * get the count of the failure resports by one redis node
	 * @param node {const char*} ָĳ redis 
	 * @return {int} 㱨 >= 0ֵ -1 
	 *  return the failure count reporting by the specified redis node,
	 *  return value >= 0 if successful, or -1 for error happened
	 */
	int cluster_count_failure_reports(const char* node);

	/**
	 * ֻܷ͸һӽ㣬йתƣʹǰĴӽ
	 * Ϊ㣬ҪЭ̣ͬʱҪϿ
	 * this command can only be sent to one slave node for failover
	 * of the master node, make the current slave to be the master
	 * @return {bool} Ƿɹ
	 *  if the operation is successful
	 */
	bool cluster_failover();

	/**
	 * ǿԽһӽΪ㣬òԭЭ̣õ
	 * Ⱥдͬ
	 * force a slave to be the master, not handshake with it's master,
	 * but still need get agreement by majority of the masters in cluster
	 * @return {bool} Ƿɹ
	 *  if the operation is successful
	 */
	bool cluster_failover_force();

	/**
	 * ǿԽһӽΪ㣬òԭͼȺе
	 * Э
	 * force a slave to be the master, not handshake with it's master,
	 * and also no need get agreement by the other masters in cluster
	 * @return {bool} Ƿɹ
	 *  if the operation is successful
	 */
	bool cluster_failover_takeover();

	/**
	 * õǰȺһЩϢ
	 * get running informantion about the redis cluster
	 * @param result {std::map<acl::string, acl::string>&} 洢
	 *  store the result of this operation
	 * @return {bool} Ƿɹ
	 *  if this operation is successful
	 */
	bool cluster_info(std::map<string, string>& result);

	/**
	 * õǰ redis 㽫Ϣ̵ nodes.conf 
	 * let the current node to save the cluster information in nodes.conf
	 * @return {bool} Ƿɹ
	 *  if this operation is successful
	 */
	bool cluster_saveconfig();

	/**
	 * ĳϣеĶ
	 * get all the keys's count in one hash-slot
	 * @param slot {size_t} ָϣ
	 *  the specified hash-slot
	 * @return {int} عϣеĶ-1 ʾ
	 *return the keys's count in the hash-slot, return -1 if error 
	 */
	int cluster_countkeysinslot(size_t slot);

	/**
	 * ָӵǰĽƳ
	 * remove the specified node from the current node
	 * @param node {const char*} ָҪƳĽ
	 *  the speicied node to be removed
	 * @return {bool} Ƿɹ
	 *  if this operation is successful
	 */
	bool cluster_forget(const char* node);

	/**
	 * ĳĹϣ
	 * get the hash-slot wich the key belongs to
	 * @param key {const char*} ֵ
	 *  the key string
	 * @return {int} ϣֵ>= 0 ʾɹ-1 ʾʧ
	 *  return the key's hash-slot, >= 0 if successful, -1 on error
	 */
	int cluster_keyslot(const char* key);

	/**
	 * ָΪӽ㣬ýԭΪӽ㣬Ҳ᷵سɹ
	 * set the specified node to be a slave node
	 * @param node {const char*} ָʶ
	 *  the specified node
	 * @return {bool} Ƿɹ
	 *  if this operation is successful
	 */
	bool cluster_replicate(const char* node);

	bool cluster_set_config_epoch(const char* epoch);

	/**
	 * йϣڼȺи redis ķֲ
	 * get all nodes with all slots
	 * @return {const std::vector<redis_slot*>*} ش洢ϣϢ
	 *  㼯ϣ NULL ʾ
	 *  return all the master nodes with all hash-slots in them,
	 *  and NULL will be returned if error happened, and the return
	 *  value needn't be freed because it can be freed internal
	 */
	const std::vector<redis_slot*>* cluster_slots();
	
	/**
	 * õǰȺн㣬дӽͨ
	 * redis_node::get_slaves 
	 * get all the masters of the cluster, and master's slave nodes
	 * can be got by redis_node::get_slaves
	 * @return {const std::map<string, redis_node*>*}  NULL ʾ
	 *  return NULL if error happened, the return value needn't be
	 *  freed because it can be freed internal
	 */
	const std::map<string, redis_node*>* cluster_nodes();

	/**
	 * ָдӽ
	 * get all slave nodes of the specified master node
	 * @return node {const char*} ʶ NULL ʾ
	 *  ؽҪͷţڲԶά
	 *  one of the master node, NULL if error, and the return value
	 *  needn't be freed because it can be freed internal
	 */
	const std::vector<redis_node*>* cluster_slaves(const char* node);

private:
	std::vector<redis_slot*> slots_;

	redis_slot* get_slot_master(const redis_result* rr);
	redis_slot* get_slot(const redis_result* rr,
		size_t slot_max, size_t slot_min);
	void free_slots();

private:
	std::map<string, redis_node*> masters_;

	redis_node* get_node(string& line);
	void add_slot_range(redis_node* node, char* slots);
	void free_masters();
	redis_node* get_slave(const std::vector<string>& tokens);

private:
	std::vector<redis_node*> slaves_;
	void free_slaves();
};

} // namespace acl
