#pragma once
#include "acl_cpp/master/master_base.hpp"
#include "acl_cpp/master/master_threads2.hpp"

struct ACL_VSTREAM;
struct ACL_EVENT;

namespace acl {

#if 1
typedef class master_threads2 master_threads;
#else

class socket_stream;

/**
 * ̳߳ط࣬Ϊ࣬ҪʵеĴ麯
 * ÿһ̽һʵᱻֹ
 */
class ACL_CPP_API master_threads : public master_base
{
public:
	/**
	 * ʼУøúָ÷ acl_master 
	 * ֮Уһ״̬
	 * @param argc {int}  main дݵĵһʾ
	 * @param argv {char**}  main дݵĵڶ
	 */
	void run_daemon(int argc, char** argv);

	/**
	 * ڵʱĴûԵô˺һЩҪĵԹ
	 * @param addrs {const char*} ַбʽIP:PORT, IP:PORT...
	 * @param path {const char*} ļȫ·
	 * @param count {unsigned int} ѭĴﵽֵԶأ
	 *  ֵΪ 0 ʾһֱѭ
	 * @param threads_count {int} ֵ 1 ʱʾԶ̳߳طʽ
	 *  ֵֻе count != 1 ʱЧ count == 1 һξͷ
	 *  Ҳ̴߳ͻ
	 * @return {bool} Ƿɹ
	 */
	bool run_alone(const char* addrs, const char* path = NULL,
		unsigned int count = 1, int threads_count = 1);

protected:
	// ಻ֱӱʵ
	master_threads();
	virtual ~master_threads();

	/**
	 * 麯ĳͻݿɶرջʱô˺
	 * @param stream {socket_stream*}
	 * @return {bool}  false ʾغҪرӣ
	 *  ʾҪֳӣӦӦ÷ false
	 */
	virtual bool thread_on_read(socket_stream* stream) = 0;

	/**
	 * ̳߳еĳ̻߳һʱĻص
	 * һЩʼ
	 * @param stream {socket_stream*}
	 * @return {bool}  false ʾҪرӣ
	 *  ؽٴ thread_main 
	 *  ע false رʱ thread_on_close 
	 */
	virtual bool thread_on_accept(socket_stream* stream)
	{
		(void) stream;
		return true;
	}

	/**
	 * ĳӵ IO дʱʱĻصú true 
	 * ʾȴһζдϣرո
	 * @param stream {socket_stream*}
	 * @return {bool}  false ʾҪرӣҪ
	 *  
	 */
	virtual bool thread_on_timeout(socket_stream* stream)
	{
		(void) stream;
		return false;
	}

	/**
	 * ĳ̰߳󶨵ӹرʱĻص
	 * @param stream {socket_stream*}
	 * ע thread_on_accept  false رʱú
	 * 
	 */
	virtual void thread_on_close(socket_stream* stream) { (void) stream; }

	/**
	 * ̳߳һ̱߳ʱĻص
	 */
	virtual void thread_on_init() {}

	/**
	 * ̳߳һ߳˳ʱĻص
	 */
	virtual void thread_on_exit() {}

private:
	// ߳̿ʼĻص
	static int thread_begin(void* arg);

	// ߳̽ǰĻص
	static void thread_finish(void* arg);

	// ߳µĴ
	static void thread_run(void* arg);

	// һ
	static void run_once(ACL_VSTREAM* client);

	// ױصĺ
	static void listen_callback(int event_type, ACL_EVENT*,
		ACL_VSTREAM*, void *context);

	//////////////////////////////////////////////////////////////////

	// յһͻʱص˺
	static int service_main(ACL_VSTREAM*, void*);

	// յһͻʱĻصԽһЩʼ
	static int service_on_accept(ACL_VSTREAM*);

	// ͻӶдʱʱĻص
	static int service_on_timeout(ACL_VSTREAM*, void*);

	// ͻӹرʱĻص
	static void service_on_close(ACL_VSTREAM*, void*);

	// лûݺõĻص
	static void service_pre_jail(void*);

	// лûݺõĻص
	static void service_init(void*);

	// ˳ʱõĻص
	static void service_exit(void*);

	// ̴߳õĻص
	static void thread_init(void*);

	// ߳˳ǰõĻص
	static void thread_exit(void*);
};

#endif

} // namespace acl
