#ifndef	ACL_DBUF_POOL_INCLUDE_H
#define	ACL_DBUF_POOL_INCLUDE_H

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct ACL_DBUF_POOL ACL_DBUF_POOL;

/**
 * ڴض
 * @param block_size {size_t} ڴÿڴĴСֽڣ
 * @return {ACL_DBUF_POOL*} ط NULL 
 */
ACL_API ACL_DBUF_POOL *acl_dbuf_pool_create(size_t block_size);

/**
 * ڴ״̬Ὣڴݿͷ
 * @param pool {ACL_DBUF_POOL*} ڴض
 * @param off {size_t} ҪСڴƫλ
 * @return {int}  0 ʾɹ 0 ʾʧ
 */
ACL_API int  acl_dbuf_pool_reset(ACL_DBUF_POOL *pool, size_t off);

/**
 * ڴ
 * @param pool {ACL_DBUF_POOL*} ض
 */
ACL_API void acl_dbuf_pool_destroy(ACL_DBUF_POOL *pool);

/**
 * ָȵڴ
 * @param pool {ACL_DBUF_POOL*} ض
 * @param  len {size_t} ҪڴС
 * @return {void*} ·ڴַ
 */
ACL_API void *acl_dbuf_pool_alloc(ACL_DBUF_POOL *pool, size_t len);

/**
 * ָȵڴ沢ڴ
 * @param pool {ACL_DBUF_POOL*} ض
 * @param len {size_t} Ҫڴ泤
 * @return {void*} ·ڴַ
 */
ACL_API void *acl_dbuf_pool_calloc(ACL_DBUF_POOL *pool, size_t len);

/**
 * ַ̬µڴ沢ַиƣ strdup
 * @param pool {ACL_DBUF_POOL*} ض
 * @param s {const char*} Դַ
 * @return {char*} ¸Ƶַַ
 */
ACL_API char *acl_dbuf_pool_strdup(ACL_DBUF_POOL *pool, const char *s);

/**
 * ַ̬µڴ沢ַиƣ strdup
 * @param pool {ACL_DBUF_POOL*} ض
 * @param s {const char*} Դַ
 * @param len {size_t} ޶ַ
 * @return {char*} ¸Ƶַַ
 */
ACL_API char *acl_dbuf_pool_strndup(ACL_DBUF_POOL *pool,
	const char *s, size_t len);

/**
 * ڴݶ̬ڴ沢ݽи
 * @param pool {ACL_DBUF_POOL*} ض
 * @param addr {const void*} Դڴַ
 * @param len {size_t} Դݳ
 * @return {void*} ¸Ƶݵַ
 */
ACL_API void *acl_dbuf_pool_memdup(ACL_DBUF_POOL *pool,
		const void *addr, size_t len);

/**
 * 黹ڴطڴ
 * @param pool {ACL_DBUF_POOL*} ض
 * @param addr {const void*} ڴطڴַ
 * @return {int} ڴַڴطͷŶΣ򷵻 -1ɹ
 *   0
 */
ACL_API int acl_dbuf_pool_free(ACL_DBUF_POOL *pool, const void *addr);

/**
 * ڴطĳεַ⵱ reset ʱǰͷŵ
 * @param pool {ACL_DBUF_POOL*} ض
 * @param addr {const void*} ڴطڴַ
 * @return {int} ɹ򷵻 0ڴַڴط䣬򷵻 -1
 */
ACL_API int acl_dbuf_pool_keep(ACL_DBUF_POOL *pool, const void *addr);

/**
 * ȡڴطĳεַԱڵ dbuf_reset ʱͷŵ
 * @param pool {ACL_DBUF_POOL*} ض
 * @param addr {const void*} ڴطڴַ
 * @return {int} ɹ򷵻 0ڴַڴط䣬򷵻 -1
 */
ACL_API int acl_dbuf_pool_unkeep(ACL_DBUF_POOL *pool, const void *addr);

/**
 * ڲú
 */
ACL_API void acl_dbuf_pool_test(size_t max);

#ifdef	__cplusplus
}
#endif

#endif
