#ifndef	__LIB_GID_INCLUDE_H__
#define	__LIB_GID_INCLUDE_H__

#ifdef	__cplusplus
extern "C" {
#endif

/* ͨѶЭ鷽ʽ */
#define	GID_PROTO_CMDLINE	0	/* зʽ */
#define	GID_PROTO_JSON		1	/* http ʽݸʽΪ json ʽ */
#define	GID_PROTO_XML		2	/* http ʽݸʽΪ xml ʽ */

/*  */
#define	GID_CMD_NEXT	"new_gid"	/* ȡһΨһ gid */

/*  */

/* ͻصĴ */
#define	GID_OK			200	/*  */
#define	GID_ERR_INIT		400	/* δʼӦӦڳʼʱóʼ gid_client_init */
#define	GID_ERR_CONN		401	/* ӷʧ */
#define	GID_ERR_IO		402	/* ͨʧ */
#define	GID_ERR_PROTO		403	/* Эʽ */
#define	GID_ERR_SERVER		404	/* ڲ */

/* صĴ */
#define GID_ERR_SID		500	/* Ự ID Ų */
#define GID_ERR_OVERRIDE	501	/* ﵽֵ */
#define GID_ERR_SAVE		502	/* 洢ʱ */

/**
 * ʼʹڳӦõøúʼ
 * @param proto {int} ͨЭʽμ棺GID_PROTO_XXX
 * @param server_addr {const char*} gid ַʽip:port 
 *  domain:port  unix  /xxx/xxx/xxx
 */
void gid_client_init(int proto, const char *server_addr);

/**
 * ݴŻô
 * @param errnum {int} ţμ棺GID_ERR_XXX
 * @return {const char*} Ϣ
 */
const char *gid_client_serror(int errnum);

/**
 *  HTTP е URLڲȱʡֵɲֱӵô˺
 * @param url {const char*} URL ַ
 */
void gid_client_set_url(const char *url);

/**
 *  HTTP Ƿ񱣳ֳӣȱʡ±ֳ
 * @param keepalive {int} Ƿ񱣳ֳ
 */
void gid_client_set_keepalive(int keepalive);

/**
 * ڳ£мжϣԴȱʡֵΪ 1
 * @param nretry {int} Դ
 */
void gid_client_set_retry_limit(int nretry);

/**
 *  gid ӳʱʱ䣨룩ȱʡֵΪ 20 
 * @param timeout {int} ʱʱ䣨룩
 */
void gid_client_set_conn_timeout(int timeout);

/**
 * ͨŵĶдʱʱ䣨룩ȱʡֵΪ 20 
 * @param timeout {int} ʱʱ䣨룩
 */
void gid_client_set_rw_timeout(int timeout);

/**
 * һ gid 
 * @param tag {const char*} ʶƣΪգڲȱʡʹ default ǩ
 *  ֵĸʽΪtag_name[:sid]е tag_name Ϊıʶsid Ϊ
 *  ñʶȨIDţֵ˵ sid ƥ䣬ֹʲش
 *  һµıʶ󲢲һ gid ֵʱ sid  sid
 *  ԶΪñʶȨIDţʸñʶ gid ṩ
 *  Ȩ ID 
 * @param errnum {int*} ָǿʱ¼ʱĴ
 * @return {long long int} õһΨһ gid ţֵ < 0 ʾ
 */
long long int gid_next(const char *tag, int *errnum);

/* ȡ gid ĺʹûṩ */

/**
 * зʽӷ˻ȡ gid 
 * @param fd {int} ӵ׽
 * @param tag {const char*} ʶƣΪڲȱʡʹdefault
 * @param errnum {int*} ָǿʱ¼ʱĴ
 * @return {long long int} õһΨһ gid ţ *  ֵΪ < 0 ʾ
 */
long long int gid_cmdline_get(int fd, const char *tag, int *errnum);

/**
 *  http ЭݸʽΪ json ʽӷ˻ȡ gid 
 * @param fd {int} ӵ׽
 * @param tag {const char*} ʶƣΪڲȱʡʹdefault
 * @param errnum {int*} ָǿʱ¼ʱĴ
 * @return {long long int} õһΨһ gid ţֵ < 0 ʾ
 */
long long int gid_json_get(int fd, const char *tag, int *errnum);

/**
 *  http ЭݸʽΪ xml ʽӷ˻ȡ gid 
 * @param fd {int} ӵ׽
 * @param tag {const char*} ʶƣΪڲȱʡʹdefault
 * @param errnum {int*} ָǿʱ¼ʱĴ
 * @return {long long int} õһΨһ gid ţֵ < 0 ʾ
 */
long long int gid_xml_get(int fd, const char *tag, int *errnum);

#ifdef	__cplusplus
}
#endif

#endif
