# Gateway

The API Gateway provides an external route into your functions and collects Cloud Native metrics through Prometheus. The gateway also has a UI built-in which can be used to deploy your own functions or functions from the OpenFaaS Function Store then invoke them. 

The gateway will scale functions according to demand by altering the service replica count in the Docker Swarm or Kubernetes API. Custom alerts generated by AlertManager are received on the /system/alert endpoint.

In summary:

* UI built-in
* Deploy your own functions or from the Function Store
* Instrumentation via Prometheus
* Auto-scaling via AlertManager
* REST API available

![](https://raw.githubusercontent.com/openfaas/faas/master/docs/of-overview.png)

*Pictured: conceptual architecture when Kubernetes is used as the orchestration provider*

## Function Providers

Providers for functions can be written using the [faas-provider](https://github.com/openfaas/faas-provider/) interface in Golang which provides the REST API for interacting with the gateway. The gateway originally interacted with Docker Swarm directly and anything else via a Function Provider - this support was moved into a separate project [faas-swarm](https://github.com/openfaas/faas-swarm/).

## REST API

Swagger docs: https://github.com/openfaas/faas/tree/master/api-docs

## Logs

Logs are available at the function level and can be accessed through Swarm or Kubernetes using native tooling. You can also install a Docker logging driver to aggregate your logs. By default functions will not write the request and response bodies to stdout. You can toggle this behaviour by setting `read_debug` for the request and `write_debug` for the response.

## Tracing

An "X-Call-Id" header is applied to every incoming call through the gateway and is usable for tracing and monitoring calls. We use a UUID for this string.

Header:

```
X-Call-Id
```

Within a function this is available as `Http_X_Call_Id`.

## Environmental overrides
The gateway can be configured through the following environment variables: 

| Option                 | Usage             |
|------------------------|--------------|
| `write_timeout`        | HTTP timeout for writing a response body from your function (in seconds). Default: `8`  |
| `read_timeout`         | HTTP timeout for reading the payload from the client caller (in seconds). Default: `8` |
| `functions_provider_url`             | URL of upstream [functions provider](https://github.com/openfaas/faas-provider/) - i.e. Swarm, Kubernetes, Nomad etc  |
| `faas_nats_address`          | Address of NATS service. Required for asynchronous mode |
| `faas_nats_port`    | Port for NATS service. Requrired for asynchronous mode |
| `faas_prometheus_host`         | Host to connect to Prometheus. Default: `"prometheus"` |
| `faas_promethus_port`         | Port to connect to Prometheus. Default: `9090` |
| `direct_functions`            | `true` or `false` -  functions are invoked directly over overlay network without passing through provider |
| `direct_functions_suffix`     | Provide a DNS suffix for invoking functions directly over overlay network  |
| `basic_auth`              | Set to `true` or `false` to enable embedded basic auth on the /system and /ui endpoints (recommended) |
| `secret_mount_path`       | Set a location where you have mounted `basic-auth-user` and `basic-auth-password`, default: `/run/secrets/`. |
