package compiler

import "go/types"

// This file implements volatile loads/stores in runtime/volatile.LoadT and
// runtime/volatile.StoreT as compiler builtins.

// createVolatileLoad is the implementation of the intrinsic function
// runtime/volatile.LoadT().
func (b *builder) createVolatileLoad() {
	b.createFunctionStart(true)
	addr := b.getValue(b.fn.Params[0], getPos(b.fn))
	b.createNilCheck(b.fn.Params[0], addr, "deref")
	valType := b.getLLVMType(b.fn.Params[0].Type().(*types.Pointer).Elem())
	val := b.CreateLoad(valType, addr, "")
	val.SetVolatile(true)
	b.CreateRet(val)
}

// createVolatileStore is the implementation of the intrinsic function
// runtime/volatile.StoreT().
func (b *builder) createVolatileStore() {
	b.createFunctionStart(true)
	addr := b.getValue(b.fn.Params[0], getPos(b.fn))
	val := b.getValue(b.fn.Params[1], getPos(b.fn))
	b.createNilCheck(b.fn.Params[0], addr, "deref")
	store := b.CreateStore(val, addr)
	store.SetVolatile(true)
	b.CreateRetVoid()
}
