WORDS_PER_GLYPH = 6
BITS_PER_WORD = 8
FONT_WIDTH = 6
FONT_HEIGHT = 8

FONT_6x8 = {
 0x00,0x00,0x00,0x00,0x00,0x00, --
 0x10,0xE3,0x84,0x10,0x01,0x00,	-- !
 0x6D,0xB4,0x80,0x00,0x00,0x00,	-- "
 0x00,0xA7,0xCA,0x29,0xF2,0x80,	-- #
 0x20,0xE4,0x0C,0x09,0xC1,0x00,	-- $
 0x65,0x90,0x84,0x21,0x34,0xC0,	-- %
 0x21,0x45,0x08,0x55,0x23,0x40,	-- &
 0x30,0xC2,0x00,0x00,0x00,0x00,	-- '
 0x10,0x82,0x08,0x20,0x81,0x00,	-- (
 0x20,0x41,0x04,0x10,0x42,0x00,	-- )
 0x00,0xA3,0x9F,0x38,0xA0,0x00,	-- *
 0x00,0x41,0x1F,0x10,0x40,0x00,	-- +
 0x00,0x00,0x00,0x00,0xC3,0x08,	-- ,
 0x00,0x00,0x1F,0x00,0x00,0x00,	-- -
 0x00,0x00,0x00,0x00,0xC3,0x00,	-- .
 0x00,0x10,0x84,0x21,0x00,0x00,	-- /
 0x39,0x14,0xD5,0x65,0x13,0x80,	-- 0
 0x10,0xC1,0x04,0x10,0x43,0x80,	-- 1
 0x39,0x10,0x46,0x21,0x07,0xC0,	-- 2
 0x39,0x10,0x4E,0x05,0x13,0x80,	-- 3
 0x08,0x62,0x92,0x7C,0x20,0x80,	-- 4
 0x7D,0x04,0x1E,0x05,0x13,0x80,	-- 5
 0x18,0x84,0x1E,0x45,0x13,0x80,	-- 6
 0x7C,0x10,0x84,0x20,0x82,0x00,	-- 7
 0x39,0x14,0x4E,0x45,0x13,0x80,	-- 8
 0x39,0x14,0x4F,0x04,0x23,0x00,	-- 9
 0x00,0x03,0x0C,0x00,0xC3,0x00,	-- :
 0x00,0x03,0x0C,0x00,0xC3,0x08,	-- ;
 0x08,0x42,0x10,0x20,0x40,0x80,	-- <
 0x00,0x07,0xC0,0x01,0xF0,0x00,	-- =
 0x20,0x40,0x81,0x08,0x42,0x00,	-- >
 0x39,0x10,0x46,0x10,0x01,0x00,	-- ?
 0x39,0x15,0xD5,0x5D,0x03,0x80,	-- @
 0x39,0x14,0x51,0x7D,0x14,0x40,	-- A
 0x79,0x14,0x5E,0x45,0x17,0x80,	-- B
 0x39,0x14,0x10,0x41,0x13,0x80,	-- C
 0x79,0x14,0x51,0x45,0x17,0x80,	-- D
 0x7D,0x04,0x1E,0x41,0x07,0xC0,	-- E
 0x7D,0x04,0x1E,0x41,0x04,0x00,	-- F
 0x39,0x14,0x17,0x45,0x13,0xC0,	-- G
 0x45,0x14,0x5F,0x45,0x14,0x40,	-- H
 0x38,0x41,0x04,0x10,0x43,0x80,	-- I
 0x04,0x10,0x41,0x45,0x13,0x80,	-- J
 0x45,0x25,0x18,0x51,0x24,0x40,	-- K
 0x41,0x04,0x10,0x41,0x07,0xC0,	-- L
 0x45,0xB5,0x51,0x45,0x14,0x40,	-- M
 0x45,0x95,0x53,0x45,0x14,0x40,	-- N
 0x39,0x14,0x51,0x45,0x13,0x80,	-- O
 0x79,0x14,0x5E,0x41,0x04,0x00,	-- P
 0x39,0x14,0x51,0x55,0x23,0x40,	-- Q
 0x79,0x14,0x5E,0x49,0x14,0x40,	-- R
 0x39,0x14,0x0E,0x05,0x13,0x80,	-- S
 0x7C,0x41,0x04,0x10,0x41,0x00,	-- T
 0x45,0x14,0x51,0x45,0x13,0x80,	-- U
 0x45,0x14,0x51,0x44,0xA1,0x00,	-- V
 0x45,0x15,0x55,0x55,0x52,0x80,	-- W
 0x45,0x12,0x84,0x29,0x14,0x40,	-- X
 0x45,0x14,0x4A,0x10,0x41,0x00,	-- Y
 0x78,0x21,0x08,0x41,0x07,0x80,	-- Z
 0x38,0x82,0x08,0x20,0x83,0x80,	-- [
 0x01,0x02,0x04,0x08,0x10,0x00,	-- \
 0x38,0x20,0x82,0x08,0x23,0x80,	-- ]
 0x10,0xA4,0x40,0x00,0x00,0x00,	-- ^
 0x00,0x00,0x00,0x00,0x00,0x3F,	-- _
 0x30,0xC1,0x00,0x00,0x00,0x00,	-- `
 0x00,0x03,0x81,0x3D,0x13,0xC0,	-- a
 0x41,0x07,0x91,0x45,0x17,0x80,	-- b
 0x00,0x03,0x91,0x41,0x13,0x80,	-- c
 0x04,0x13,0xD1,0x45,0x13,0xC0,	-- d
 0x00,0x03,0x91,0x79,0x03,0x80,	-- e
 0x18,0x82,0x1E,0x20,0x82,0x00,	-- f
 0x00,0x03,0xD1,0x44,0xF0,0x4E,	-- g
 0x41,0x07,0x12,0x49,0x24,0x80,	-- h
 0x10,0x01,0x04,0x10,0x41,0x80,	-- i
 0x08,0x01,0x82,0x08,0x24,0x8C,	-- j
 0x41,0x04,0x94,0x61,0x44,0x80,	-- k
 0x10,0x41,0x04,0x10,0x41,0x80,	-- l
 0x00,0x06,0x95,0x55,0x14,0x40,	-- m
 0x00,0x07,0x12,0x49,0x24,0x80,	-- n
 0x00,0x03,0x91,0x45,0x13,0x80,	-- o
 0x00,0x07,0x91,0x45,0x17,0x90,	-- p
 0x00,0x03,0xD1,0x45,0x13,0xC1,	-- q
 0x00,0x05,0x89,0x20,0x87,0x00,	-- r
 0x00,0x03,0x90,0x38,0x13,0x80,	-- s
 0x00,0x87,0x88,0x20,0xA1,0x00,	-- t
 0x00,0x04,0x92,0x49,0x62,0x80,	-- u
 0x00,0x04,0x51,0x44,0xA1,0x00,	-- v
 0x00,0x04,0x51,0x55,0xF2,0x80,	-- w
 0x00,0x04,0x92,0x31,0x24,0x80,	-- x
 0x00,0x04,0x92,0x48,0xE1,0x18,	-- y
 0x00,0x07,0x82,0x31,0x07,0x80,	-- z
 0x18,0x82,0x18,0x20,0x81,0x80,	-- {
 0x10,0x41,0x00,0x10,0x41,0x00,	-- |
 0x30,0x20,0x83,0x08,0x23,0x00,	-- }
 0x29,0x40,0x00,0x00,0x00,0x00,	-- ~
 0x10,0xE6,0xD1,0x45,0xF0,0x00} --

function NASH:TextWidth(str)
	return FONT_WIDTH*#str
end

function NASH:TextHeight()
	return FONT_HEIGHT
end

function NASH:Print(str, x, y, c, align)
	if x >= self.width or y >= self.height then return end

	align = align or NASH.ALIGN_LEFT
	if align == NASH.ALIGN_CENTER then
		x = x - self:TextWidth(str) / 2
	elseif align == NASH.ALIGN_RIGHT then
		x = x - self:TextWidth(str)
	end

	local startIndex = 0
	local len = #str
	local x0, y0, sx, sy
	local w, h = FONT_WIDTH*len, FONT_HEIGHT

	if y < 0 then
		if y <= -FONT_HEIGHT then return end
		y0 = 0
		sy = -y
		h = FONT_HEIGHT+y
	else
		y0 = y
		sy = 0
    end

	if y0+h > self.height then
        h = self.height - y0
    end

	if x < 0 then
		x0 = 0
		startIndex = math.floor(math.abs(x) / FONT_WIDTH)
		sx = FONT_WIDTH - (math.abs(x) % FONT_WIDTH)
		w = w + x
		if w<=0 then return end
	else 
        x0 = x
		sx = 0
    end

	if x0+w > self.width then
        w = self.width - x0
    end
	
    len = w / FONT_WIDTH
	if (w % FONT_WIDTH) ~= 0 then 
        len = len + 1 
    end

	local currentChar, charCode
	local fontIndex, offset, bit
	local addr
    for i = startIndex+1, len do
		currentChar = string.sub(str, i, i)
		charCode = string.byte(currentChar) - string.byte(" ")
		fontIndex = WORDS_PER_GLYPH * charCode;
		w = math.min(FONT_WIDTH, self.width - x0)
		for yf = sy, h-1 do
			addr = yf * FONT_WIDTH + sx
			for xf = sx, w-1 do
				offset = math.floor(addr / BITS_PER_WORD)
				bit = BITS_PER_WORD - (addr % BITS_PER_WORD)-1;
				if bit_and(bit_rshift(FONT_6x8[fontIndex+offset+1], bit), 0x01) > 0 then
					self:Plot(x0 + xf, y0 + yf, c)
                end
				addr = addr + 1
			end
		end
		sx = 0
		x0 = x0 + FONT_WIDTH
	end
end

--[[!! LEAVE TWO CARRIAGE RETURNS AFTER SOURCE FILE !!]]--

