/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.2)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.zeppelin.interpreter.thrift;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
@Generated(value = "Autogenerated by Thrift Compiler (0.9.2)", date = "2016-6-8")
public class RemoteInterpreterService {

  public interface Iface {

    public void createInterpreter(String intpGroupId, String noteId, String className, Map<String,String> properties) throws org.apache.thrift.TException;

    public void open(String noteId, String className) throws org.apache.thrift.TException;

    public void close(String noteId, String className) throws org.apache.thrift.TException;

    public RemoteInterpreterResult interpret(String noteId, String className, String st, RemoteInterpreterContext interpreterContext) throws org.apache.thrift.TException;

    public void cancel(String noteId, String className, RemoteInterpreterContext interpreterContext) throws org.apache.thrift.TException;

    public int getProgress(String noteId, String className, RemoteInterpreterContext interpreterContext) throws org.apache.thrift.TException;

    public String getFormType(String noteId, String className) throws org.apache.thrift.TException;

    public List<InterpreterCompletion> completion(String noteId, String className, String buf, int cursor) throws org.apache.thrift.TException;

    public void shutdown() throws org.apache.thrift.TException;

    public String getStatus(String noteId, String jobId) throws org.apache.thrift.TException;

    public RemoteInterpreterEvent getEvent() throws org.apache.thrift.TException;

    public void resourcePoolResponseGetAll(List<String> resources) throws org.apache.thrift.TException;

    public void resourceResponseGet(String resourceId, ByteBuffer object) throws org.apache.thrift.TException;

    public List<String> resourcePoolGetAll() throws org.apache.thrift.TException;

    public ByteBuffer resourceGet(String noteId, String paragraphId, String resourceName) throws org.apache.thrift.TException;

    public boolean resourceRemove(String noteId, String paragraphId, String resourceName) throws org.apache.thrift.TException;

    public void angularObjectUpdate(String name, String noteId, String paragraphId, String object) throws org.apache.thrift.TException;

    public void angularObjectAdd(String name, String noteId, String paragraphId, String object) throws org.apache.thrift.TException;

    public void angularObjectRemove(String name, String noteId, String paragraphId) throws org.apache.thrift.TException;

    public void angularRegistryPush(String registry) throws org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void createInterpreter(String intpGroupId, String noteId, String className, Map<String,String> properties, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void open(String noteId, String className, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void close(String noteId, String className, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void interpret(String noteId, String className, String st, RemoteInterpreterContext interpreterContext, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void cancel(String noteId, String className, RemoteInterpreterContext interpreterContext, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getProgress(String noteId, String className, RemoteInterpreterContext interpreterContext, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getFormType(String noteId, String className, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void completion(String noteId, String className, String buf, int cursor, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void shutdown(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getStatus(String noteId, String jobId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getEvent(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void resourcePoolResponseGetAll(List<String> resources, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void resourceResponseGet(String resourceId, ByteBuffer object, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void resourcePoolGetAll(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void resourceGet(String noteId, String paragraphId, String resourceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void resourceRemove(String noteId, String paragraphId, String resourceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void angularObjectUpdate(String name, String noteId, String paragraphId, String object, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void angularObjectAdd(String name, String noteId, String paragraphId, String object, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void angularObjectRemove(String name, String noteId, String paragraphId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void angularRegistryPush(String registry, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public void createInterpreter(String intpGroupId, String noteId, String className, Map<String,String> properties) throws org.apache.thrift.TException
    {
      send_createInterpreter(intpGroupId, noteId, className, properties);
      recv_createInterpreter();
    }

    public void send_createInterpreter(String intpGroupId, String noteId, String className, Map<String,String> properties) throws org.apache.thrift.TException
    {
      createInterpreter_args args = new createInterpreter_args();
      args.setIntpGroupId(intpGroupId);
      args.setNoteId(noteId);
      args.setClassName(className);
      args.setProperties(properties);
      sendBase("createInterpreter", args);
    }

    public void recv_createInterpreter() throws org.apache.thrift.TException
    {
      createInterpreter_result result = new createInterpreter_result();
      receiveBase(result, "createInterpreter");
      return;
    }

    public void open(String noteId, String className) throws org.apache.thrift.TException
    {
      send_open(noteId, className);
      recv_open();
    }

    public void send_open(String noteId, String className) throws org.apache.thrift.TException
    {
      open_args args = new open_args();
      args.setNoteId(noteId);
      args.setClassName(className);
      sendBase("open", args);
    }

    public void recv_open() throws org.apache.thrift.TException
    {
      open_result result = new open_result();
      receiveBase(result, "open");
      return;
    }

    public void close(String noteId, String className) throws org.apache.thrift.TException
    {
      send_close(noteId, className);
      recv_close();
    }

    public void send_close(String noteId, String className) throws org.apache.thrift.TException
    {
      close_args args = new close_args();
      args.setNoteId(noteId);
      args.setClassName(className);
      sendBase("close", args);
    }

    public void recv_close() throws org.apache.thrift.TException
    {
      close_result result = new close_result();
      receiveBase(result, "close");
      return;
    }

    public RemoteInterpreterResult interpret(String noteId, String className, String st, RemoteInterpreterContext interpreterContext) throws org.apache.thrift.TException
    {
      send_interpret(noteId, className, st, interpreterContext);
      return recv_interpret();
    }

    public void send_interpret(String noteId, String className, String st, RemoteInterpreterContext interpreterContext) throws org.apache.thrift.TException
    {
      interpret_args args = new interpret_args();
      args.setNoteId(noteId);
      args.setClassName(className);
      args.setSt(st);
      args.setInterpreterContext(interpreterContext);
      sendBase("interpret", args);
    }

    public RemoteInterpreterResult recv_interpret() throws org.apache.thrift.TException
    {
      interpret_result result = new interpret_result();
      receiveBase(result, "interpret");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "interpret failed: unknown result");
    }

    public void cancel(String noteId, String className, RemoteInterpreterContext interpreterContext) throws org.apache.thrift.TException
    {
      send_cancel(noteId, className, interpreterContext);
      recv_cancel();
    }

    public void send_cancel(String noteId, String className, RemoteInterpreterContext interpreterContext) throws org.apache.thrift.TException
    {
      cancel_args args = new cancel_args();
      args.setNoteId(noteId);
      args.setClassName(className);
      args.setInterpreterContext(interpreterContext);
      sendBase("cancel", args);
    }

    public void recv_cancel() throws org.apache.thrift.TException
    {
      cancel_result result = new cancel_result();
      receiveBase(result, "cancel");
      return;
    }

    public int getProgress(String noteId, String className, RemoteInterpreterContext interpreterContext) throws org.apache.thrift.TException
    {
      send_getProgress(noteId, className, interpreterContext);
      return recv_getProgress();
    }

    public void send_getProgress(String noteId, String className, RemoteInterpreterContext interpreterContext) throws org.apache.thrift.TException
    {
      getProgress_args args = new getProgress_args();
      args.setNoteId(noteId);
      args.setClassName(className);
      args.setInterpreterContext(interpreterContext);
      sendBase("getProgress", args);
    }

    public int recv_getProgress() throws org.apache.thrift.TException
    {
      getProgress_result result = new getProgress_result();
      receiveBase(result, "getProgress");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getProgress failed: unknown result");
    }

    public String getFormType(String noteId, String className) throws org.apache.thrift.TException
    {
      send_getFormType(noteId, className);
      return recv_getFormType();
    }

    public void send_getFormType(String noteId, String className) throws org.apache.thrift.TException
    {
      getFormType_args args = new getFormType_args();
      args.setNoteId(noteId);
      args.setClassName(className);
      sendBase("getFormType", args);
    }

    public String recv_getFormType() throws org.apache.thrift.TException
    {
      getFormType_result result = new getFormType_result();
      receiveBase(result, "getFormType");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getFormType failed: unknown result");
    }

    public List<InterpreterCompletion> completion(String noteId, String className, String buf, int cursor) throws org.apache.thrift.TException
    {
      send_completion(noteId, className, buf, cursor);
      return recv_completion();
    }

    public void send_completion(String noteId, String className, String buf, int cursor) throws org.apache.thrift.TException
    {
      completion_args args = new completion_args();
      args.setNoteId(noteId);
      args.setClassName(className);
      args.setBuf(buf);
      args.setCursor(cursor);
      sendBase("completion", args);
    }

    public List<InterpreterCompletion> recv_completion() throws org.apache.thrift.TException
    {
      completion_result result = new completion_result();
      receiveBase(result, "completion");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "completion failed: unknown result");
    }

    public void shutdown() throws org.apache.thrift.TException
    {
      send_shutdown();
      recv_shutdown();
    }

    public void send_shutdown() throws org.apache.thrift.TException
    {
      shutdown_args args = new shutdown_args();
      sendBase("shutdown", args);
    }

    public void recv_shutdown() throws org.apache.thrift.TException
    {
      shutdown_result result = new shutdown_result();
      receiveBase(result, "shutdown");
      return;
    }

    public String getStatus(String noteId, String jobId) throws org.apache.thrift.TException
    {
      send_getStatus(noteId, jobId);
      return recv_getStatus();
    }

    public void send_getStatus(String noteId, String jobId) throws org.apache.thrift.TException
    {
      getStatus_args args = new getStatus_args();
      args.setNoteId(noteId);
      args.setJobId(jobId);
      sendBase("getStatus", args);
    }

    public String recv_getStatus() throws org.apache.thrift.TException
    {
      getStatus_result result = new getStatus_result();
      receiveBase(result, "getStatus");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getStatus failed: unknown result");
    }

    public RemoteInterpreterEvent getEvent() throws org.apache.thrift.TException
    {
      send_getEvent();
      return recv_getEvent();
    }

    public void send_getEvent() throws org.apache.thrift.TException
    {
      getEvent_args args = new getEvent_args();
      sendBase("getEvent", args);
    }

    public RemoteInterpreterEvent recv_getEvent() throws org.apache.thrift.TException
    {
      getEvent_result result = new getEvent_result();
      receiveBase(result, "getEvent");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getEvent failed: unknown result");
    }

    public void resourcePoolResponseGetAll(List<String> resources) throws org.apache.thrift.TException
    {
      send_resourcePoolResponseGetAll(resources);
      recv_resourcePoolResponseGetAll();
    }

    public void send_resourcePoolResponseGetAll(List<String> resources) throws org.apache.thrift.TException
    {
      resourcePoolResponseGetAll_args args = new resourcePoolResponseGetAll_args();
      args.setResources(resources);
      sendBase("resourcePoolResponseGetAll", args);
    }

    public void recv_resourcePoolResponseGetAll() throws org.apache.thrift.TException
    {
      resourcePoolResponseGetAll_result result = new resourcePoolResponseGetAll_result();
      receiveBase(result, "resourcePoolResponseGetAll");
      return;
    }

    public void resourceResponseGet(String resourceId, ByteBuffer object) throws org.apache.thrift.TException
    {
      send_resourceResponseGet(resourceId, object);
      recv_resourceResponseGet();
    }

    public void send_resourceResponseGet(String resourceId, ByteBuffer object) throws org.apache.thrift.TException
    {
      resourceResponseGet_args args = new resourceResponseGet_args();
      args.setResourceId(resourceId);
      args.setObject(object);
      sendBase("resourceResponseGet", args);
    }

    public void recv_resourceResponseGet() throws org.apache.thrift.TException
    {
      resourceResponseGet_result result = new resourceResponseGet_result();
      receiveBase(result, "resourceResponseGet");
      return;
    }

    public List<String> resourcePoolGetAll() throws org.apache.thrift.TException
    {
      send_resourcePoolGetAll();
      return recv_resourcePoolGetAll();
    }

    public void send_resourcePoolGetAll() throws org.apache.thrift.TException
    {
      resourcePoolGetAll_args args = new resourcePoolGetAll_args();
      sendBase("resourcePoolGetAll", args);
    }

    public List<String> recv_resourcePoolGetAll() throws org.apache.thrift.TException
    {
      resourcePoolGetAll_result result = new resourcePoolGetAll_result();
      receiveBase(result, "resourcePoolGetAll");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "resourcePoolGetAll failed: unknown result");
    }

    public ByteBuffer resourceGet(String noteId, String paragraphId, String resourceName) throws org.apache.thrift.TException
    {
      send_resourceGet(noteId, paragraphId, resourceName);
      return recv_resourceGet();
    }

    public void send_resourceGet(String noteId, String paragraphId, String resourceName) throws org.apache.thrift.TException
    {
      resourceGet_args args = new resourceGet_args();
      args.setNoteId(noteId);
      args.setParagraphId(paragraphId);
      args.setResourceName(resourceName);
      sendBase("resourceGet", args);
    }

    public ByteBuffer recv_resourceGet() throws org.apache.thrift.TException
    {
      resourceGet_result result = new resourceGet_result();
      receiveBase(result, "resourceGet");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "resourceGet failed: unknown result");
    }

    public boolean resourceRemove(String noteId, String paragraphId, String resourceName) throws org.apache.thrift.TException
    {
      send_resourceRemove(noteId, paragraphId, resourceName);
      return recv_resourceRemove();
    }

    public void send_resourceRemove(String noteId, String paragraphId, String resourceName) throws org.apache.thrift.TException
    {
      resourceRemove_args args = new resourceRemove_args();
      args.setNoteId(noteId);
      args.setParagraphId(paragraphId);
      args.setResourceName(resourceName);
      sendBase("resourceRemove", args);
    }

    public boolean recv_resourceRemove() throws org.apache.thrift.TException
    {
      resourceRemove_result result = new resourceRemove_result();
      receiveBase(result, "resourceRemove");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "resourceRemove failed: unknown result");
    }

    public void angularObjectUpdate(String name, String noteId, String paragraphId, String object) throws org.apache.thrift.TException
    {
      send_angularObjectUpdate(name, noteId, paragraphId, object);
      recv_angularObjectUpdate();
    }

    public void send_angularObjectUpdate(String name, String noteId, String paragraphId, String object) throws org.apache.thrift.TException
    {
      angularObjectUpdate_args args = new angularObjectUpdate_args();
      args.setName(name);
      args.setNoteId(noteId);
      args.setParagraphId(paragraphId);
      args.setObject(object);
      sendBase("angularObjectUpdate", args);
    }

    public void recv_angularObjectUpdate() throws org.apache.thrift.TException
    {
      angularObjectUpdate_result result = new angularObjectUpdate_result();
      receiveBase(result, "angularObjectUpdate");
      return;
    }

    public void angularObjectAdd(String name, String noteId, String paragraphId, String object) throws org.apache.thrift.TException
    {
      send_angularObjectAdd(name, noteId, paragraphId, object);
      recv_angularObjectAdd();
    }

    public void send_angularObjectAdd(String name, String noteId, String paragraphId, String object) throws org.apache.thrift.TException
    {
      angularObjectAdd_args args = new angularObjectAdd_args();
      args.setName(name);
      args.setNoteId(noteId);
      args.setParagraphId(paragraphId);
      args.setObject(object);
      sendBase("angularObjectAdd", args);
    }

    public void recv_angularObjectAdd() throws org.apache.thrift.TException
    {
      angularObjectAdd_result result = new angularObjectAdd_result();
      receiveBase(result, "angularObjectAdd");
      return;
    }

    public void angularObjectRemove(String name, String noteId, String paragraphId) throws org.apache.thrift.TException
    {
      send_angularObjectRemove(name, noteId, paragraphId);
      recv_angularObjectRemove();
    }

    public void send_angularObjectRemove(String name, String noteId, String paragraphId) throws org.apache.thrift.TException
    {
      angularObjectRemove_args args = new angularObjectRemove_args();
      args.setName(name);
      args.setNoteId(noteId);
      args.setParagraphId(paragraphId);
      sendBase("angularObjectRemove", args);
    }

    public void recv_angularObjectRemove() throws org.apache.thrift.TException
    {
      angularObjectRemove_result result = new angularObjectRemove_result();
      receiveBase(result, "angularObjectRemove");
      return;
    }

    public void angularRegistryPush(String registry) throws org.apache.thrift.TException
    {
      send_angularRegistryPush(registry);
      recv_angularRegistryPush();
    }

    public void send_angularRegistryPush(String registry) throws org.apache.thrift.TException
    {
      angularRegistryPush_args args = new angularRegistryPush_args();
      args.setRegistry(registry);
      sendBase("angularRegistryPush", args);
    }

    public void recv_angularRegistryPush() throws org.apache.thrift.TException
    {
      angularRegistryPush_result result = new angularRegistryPush_result();
      receiveBase(result, "angularRegistryPush");
      return;
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void createInterpreter(String intpGroupId, String noteId, String className, Map<String,String> properties, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createInterpreter_call method_call = new createInterpreter_call(intpGroupId, noteId, className, properties, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createInterpreter_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String intpGroupId;
      private String noteId;
      private String className;
      private Map<String,String> properties;
      public createInterpreter_call(String intpGroupId, String noteId, String className, Map<String,String> properties, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.intpGroupId = intpGroupId;
        this.noteId = noteId;
        this.className = className;
        this.properties = properties;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createInterpreter", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createInterpreter_args args = new createInterpreter_args();
        args.setIntpGroupId(intpGroupId);
        args.setNoteId(noteId);
        args.setClassName(className);
        args.setProperties(properties);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_createInterpreter();
      }
    }

    public void open(String noteId, String className, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      open_call method_call = new open_call(noteId, className, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class open_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String noteId;
      private String className;
      public open_call(String noteId, String className, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.noteId = noteId;
        this.className = className;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("open", org.apache.thrift.protocol.TMessageType.CALL, 0));
        open_args args = new open_args();
        args.setNoteId(noteId);
        args.setClassName(className);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_open();
      }
    }

    public void close(String noteId, String className, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      close_call method_call = new close_call(noteId, className, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class close_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String noteId;
      private String className;
      public close_call(String noteId, String className, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.noteId = noteId;
        this.className = className;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("close", org.apache.thrift.protocol.TMessageType.CALL, 0));
        close_args args = new close_args();
        args.setNoteId(noteId);
        args.setClassName(className);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_close();
      }
    }

    public void interpret(String noteId, String className, String st, RemoteInterpreterContext interpreterContext, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      interpret_call method_call = new interpret_call(noteId, className, st, interpreterContext, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class interpret_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String noteId;
      private String className;
      private String st;
      private RemoteInterpreterContext interpreterContext;
      public interpret_call(String noteId, String className, String st, RemoteInterpreterContext interpreterContext, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.noteId = noteId;
        this.className = className;
        this.st = st;
        this.interpreterContext = interpreterContext;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("interpret", org.apache.thrift.protocol.TMessageType.CALL, 0));
        interpret_args args = new interpret_args();
        args.setNoteId(noteId);
        args.setClassName(className);
        args.setSt(st);
        args.setInterpreterContext(interpreterContext);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public RemoteInterpreterResult getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_interpret();
      }
    }

    public void cancel(String noteId, String className, RemoteInterpreterContext interpreterContext, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      cancel_call method_call = new cancel_call(noteId, className, interpreterContext, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class cancel_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String noteId;
      private String className;
      private RemoteInterpreterContext interpreterContext;
      public cancel_call(String noteId, String className, RemoteInterpreterContext interpreterContext, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.noteId = noteId;
        this.className = className;
        this.interpreterContext = interpreterContext;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("cancel", org.apache.thrift.protocol.TMessageType.CALL, 0));
        cancel_args args = new cancel_args();
        args.setNoteId(noteId);
        args.setClassName(className);
        args.setInterpreterContext(interpreterContext);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_cancel();
      }
    }

    public void getProgress(String noteId, String className, RemoteInterpreterContext interpreterContext, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getProgress_call method_call = new getProgress_call(noteId, className, interpreterContext, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getProgress_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String noteId;
      private String className;
      private RemoteInterpreterContext interpreterContext;
      public getProgress_call(String noteId, String className, RemoteInterpreterContext interpreterContext, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.noteId = noteId;
        this.className = className;
        this.interpreterContext = interpreterContext;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getProgress", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getProgress_args args = new getProgress_args();
        args.setNoteId(noteId);
        args.setClassName(className);
        args.setInterpreterContext(interpreterContext);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getProgress();
      }
    }

    public void getFormType(String noteId, String className, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getFormType_call method_call = new getFormType_call(noteId, className, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getFormType_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String noteId;
      private String className;
      public getFormType_call(String noteId, String className, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.noteId = noteId;
        this.className = className;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getFormType", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getFormType_args args = new getFormType_args();
        args.setNoteId(noteId);
        args.setClassName(className);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getFormType();
      }
    }

    public void completion(String noteId, String className, String buf, int cursor, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      completion_call method_call = new completion_call(noteId, className, buf, cursor, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class completion_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String noteId;
      private String className;
      private String buf;
      private int cursor;
      public completion_call(String noteId, String className, String buf, int cursor, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.noteId = noteId;
        this.className = className;
        this.buf = buf;
        this.cursor = cursor;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("completion", org.apache.thrift.protocol.TMessageType.CALL, 0));
        completion_args args = new completion_args();
        args.setNoteId(noteId);
        args.setClassName(className);
        args.setBuf(buf);
        args.setCursor(cursor);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<InterpreterCompletion> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_completion();
      }
    }

    public void shutdown(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      shutdown_call method_call = new shutdown_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class shutdown_call extends org.apache.thrift.async.TAsyncMethodCall {
      public shutdown_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("shutdown", org.apache.thrift.protocol.TMessageType.CALL, 0));
        shutdown_args args = new shutdown_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_shutdown();
      }
    }

    public void getStatus(String noteId, String jobId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getStatus_call method_call = new getStatus_call(noteId, jobId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getStatus_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String noteId;
      private String jobId;
      public getStatus_call(String noteId, String jobId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.noteId = noteId;
        this.jobId = jobId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getStatus", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getStatus_args args = new getStatus_args();
        args.setNoteId(noteId);
        args.setJobId(jobId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getStatus();
      }
    }

    public void getEvent(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getEvent_call method_call = new getEvent_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getEvent_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getEvent_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getEvent", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getEvent_args args = new getEvent_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public RemoteInterpreterEvent getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getEvent();
      }
    }

    public void resourcePoolResponseGetAll(List<String> resources, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      resourcePoolResponseGetAll_call method_call = new resourcePoolResponseGetAll_call(resources, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class resourcePoolResponseGetAll_call extends org.apache.thrift.async.TAsyncMethodCall {
      private List<String> resources;
      public resourcePoolResponseGetAll_call(List<String> resources, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.resources = resources;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("resourcePoolResponseGetAll", org.apache.thrift.protocol.TMessageType.CALL, 0));
        resourcePoolResponseGetAll_args args = new resourcePoolResponseGetAll_args();
        args.setResources(resources);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_resourcePoolResponseGetAll();
      }
    }

    public void resourceResponseGet(String resourceId, ByteBuffer object, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      resourceResponseGet_call method_call = new resourceResponseGet_call(resourceId, object, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class resourceResponseGet_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String resourceId;
      private ByteBuffer object;
      public resourceResponseGet_call(String resourceId, ByteBuffer object, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.resourceId = resourceId;
        this.object = object;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("resourceResponseGet", org.apache.thrift.protocol.TMessageType.CALL, 0));
        resourceResponseGet_args args = new resourceResponseGet_args();
        args.setResourceId(resourceId);
        args.setObject(object);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_resourceResponseGet();
      }
    }

    public void resourcePoolGetAll(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      resourcePoolGetAll_call method_call = new resourcePoolGetAll_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class resourcePoolGetAll_call extends org.apache.thrift.async.TAsyncMethodCall {
      public resourcePoolGetAll_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("resourcePoolGetAll", org.apache.thrift.protocol.TMessageType.CALL, 0));
        resourcePoolGetAll_args args = new resourcePoolGetAll_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<String> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_resourcePoolGetAll();
      }
    }

    public void resourceGet(String noteId, String paragraphId, String resourceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      resourceGet_call method_call = new resourceGet_call(noteId, paragraphId, resourceName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class resourceGet_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String noteId;
      private String paragraphId;
      private String resourceName;
      public resourceGet_call(String noteId, String paragraphId, String resourceName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.noteId = noteId;
        this.paragraphId = paragraphId;
        this.resourceName = resourceName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("resourceGet", org.apache.thrift.protocol.TMessageType.CALL, 0));
        resourceGet_args args = new resourceGet_args();
        args.setNoteId(noteId);
        args.setParagraphId(paragraphId);
        args.setResourceName(resourceName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ByteBuffer getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_resourceGet();
      }
    }

    public void resourceRemove(String noteId, String paragraphId, String resourceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      resourceRemove_call method_call = new resourceRemove_call(noteId, paragraphId, resourceName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class resourceRemove_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String noteId;
      private String paragraphId;
      private String resourceName;
      public resourceRemove_call(String noteId, String paragraphId, String resourceName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.noteId = noteId;
        this.paragraphId = paragraphId;
        this.resourceName = resourceName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("resourceRemove", org.apache.thrift.protocol.TMessageType.CALL, 0));
        resourceRemove_args args = new resourceRemove_args();
        args.setNoteId(noteId);
        args.setParagraphId(paragraphId);
        args.setResourceName(resourceName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_resourceRemove();
      }
    }

    public void angularObjectUpdate(String name, String noteId, String paragraphId, String object, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      angularObjectUpdate_call method_call = new angularObjectUpdate_call(name, noteId, paragraphId, object, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class angularObjectUpdate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      private String noteId;
      private String paragraphId;
      private String object;
      public angularObjectUpdate_call(String name, String noteId, String paragraphId, String object, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
        this.noteId = noteId;
        this.paragraphId = paragraphId;
        this.object = object;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("angularObjectUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        angularObjectUpdate_args args = new angularObjectUpdate_args();
        args.setName(name);
        args.setNoteId(noteId);
        args.setParagraphId(paragraphId);
        args.setObject(object);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_angularObjectUpdate();
      }
    }

    public void angularObjectAdd(String name, String noteId, String paragraphId, String object, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      angularObjectAdd_call method_call = new angularObjectAdd_call(name, noteId, paragraphId, object, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class angularObjectAdd_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      private String noteId;
      private String paragraphId;
      private String object;
      public angularObjectAdd_call(String name, String noteId, String paragraphId, String object, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
        this.noteId = noteId;
        this.paragraphId = paragraphId;
        this.object = object;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("angularObjectAdd", org.apache.thrift.protocol.TMessageType.CALL, 0));
        angularObjectAdd_args args = new angularObjectAdd_args();
        args.setName(name);
        args.setNoteId(noteId);
        args.setParagraphId(paragraphId);
        args.setObject(object);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_angularObjectAdd();
      }
    }

    public void angularObjectRemove(String name, String noteId, String paragraphId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      angularObjectRemove_call method_call = new angularObjectRemove_call(name, noteId, paragraphId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class angularObjectRemove_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      private String noteId;
      private String paragraphId;
      public angularObjectRemove_call(String name, String noteId, String paragraphId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
        this.noteId = noteId;
        this.paragraphId = paragraphId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("angularObjectRemove", org.apache.thrift.protocol.TMessageType.CALL, 0));
        angularObjectRemove_args args = new angularObjectRemove_args();
        args.setName(name);
        args.setNoteId(noteId);
        args.setParagraphId(paragraphId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_angularObjectRemove();
      }
    }

    public void angularRegistryPush(String registry, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      angularRegistryPush_call method_call = new angularRegistryPush_call(registry, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class angularRegistryPush_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String registry;
      public angularRegistryPush_call(String registry, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.registry = registry;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("angularRegistryPush", org.apache.thrift.protocol.TMessageType.CALL, 0));
        angularRegistryPush_args args = new angularRegistryPush_args();
        args.setRegistry(registry);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_angularRegistryPush();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("createInterpreter", new createInterpreter());
      processMap.put("open", new open());
      processMap.put("close", new close());
      processMap.put("interpret", new interpret());
      processMap.put("cancel", new cancel());
      processMap.put("getProgress", new getProgress());
      processMap.put("getFormType", new getFormType());
      processMap.put("completion", new completion());
      processMap.put("shutdown", new shutdown());
      processMap.put("getStatus", new getStatus());
      processMap.put("getEvent", new getEvent());
      processMap.put("resourcePoolResponseGetAll", new resourcePoolResponseGetAll());
      processMap.put("resourceResponseGet", new resourceResponseGet());
      processMap.put("resourcePoolGetAll", new resourcePoolGetAll());
      processMap.put("resourceGet", new resourceGet());
      processMap.put("resourceRemove", new resourceRemove());
      processMap.put("angularObjectUpdate", new angularObjectUpdate());
      processMap.put("angularObjectAdd", new angularObjectAdd());
      processMap.put("angularObjectRemove", new angularObjectRemove());
      processMap.put("angularRegistryPush", new angularRegistryPush());
      return processMap;
    }

    public static class createInterpreter<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createInterpreter_args> {
      public createInterpreter() {
        super("createInterpreter");
      }

      public createInterpreter_args getEmptyArgsInstance() {
        return new createInterpreter_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createInterpreter_result getResult(I iface, createInterpreter_args args) throws org.apache.thrift.TException {
        createInterpreter_result result = new createInterpreter_result();
        iface.createInterpreter(args.intpGroupId, args.noteId, args.className, args.properties);
        return result;
      }
    }

    public static class open<I extends Iface> extends org.apache.thrift.ProcessFunction<I, open_args> {
      public open() {
        super("open");
      }

      public open_args getEmptyArgsInstance() {
        return new open_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public open_result getResult(I iface, open_args args) throws org.apache.thrift.TException {
        open_result result = new open_result();
        iface.open(args.noteId, args.className);
        return result;
      }
    }

    public static class close<I extends Iface> extends org.apache.thrift.ProcessFunction<I, close_args> {
      public close() {
        super("close");
      }

      public close_args getEmptyArgsInstance() {
        return new close_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public close_result getResult(I iface, close_args args) throws org.apache.thrift.TException {
        close_result result = new close_result();
        iface.close(args.noteId, args.className);
        return result;
      }
    }

    public static class interpret<I extends Iface> extends org.apache.thrift.ProcessFunction<I, interpret_args> {
      public interpret() {
        super("interpret");
      }

      public interpret_args getEmptyArgsInstance() {
        return new interpret_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public interpret_result getResult(I iface, interpret_args args) throws org.apache.thrift.TException {
        interpret_result result = new interpret_result();
        result.success = iface.interpret(args.noteId, args.className, args.st, args.interpreterContext);
        return result;
      }
    }

    public static class cancel<I extends Iface> extends org.apache.thrift.ProcessFunction<I, cancel_args> {
      public cancel() {
        super("cancel");
      }

      public cancel_args getEmptyArgsInstance() {
        return new cancel_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public cancel_result getResult(I iface, cancel_args args) throws org.apache.thrift.TException {
        cancel_result result = new cancel_result();
        iface.cancel(args.noteId, args.className, args.interpreterContext);
        return result;
      }
    }

    public static class getProgress<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getProgress_args> {
      public getProgress() {
        super("getProgress");
      }

      public getProgress_args getEmptyArgsInstance() {
        return new getProgress_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getProgress_result getResult(I iface, getProgress_args args) throws org.apache.thrift.TException {
        getProgress_result result = new getProgress_result();
        result.success = iface.getProgress(args.noteId, args.className, args.interpreterContext);
        result.setSuccessIsSet(true);
        return result;
      }
    }

    public static class getFormType<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getFormType_args> {
      public getFormType() {
        super("getFormType");
      }

      public getFormType_args getEmptyArgsInstance() {
        return new getFormType_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getFormType_result getResult(I iface, getFormType_args args) throws org.apache.thrift.TException {
        getFormType_result result = new getFormType_result();
        result.success = iface.getFormType(args.noteId, args.className);
        return result;
      }
    }

    public static class completion<I extends Iface> extends org.apache.thrift.ProcessFunction<I, completion_args> {
      public completion() {
        super("completion");
      }

      public completion_args getEmptyArgsInstance() {
        return new completion_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public completion_result getResult(I iface, completion_args args) throws org.apache.thrift.TException {
        completion_result result = new completion_result();
        result.success = iface.completion(args.noteId, args.className, args.buf, args.cursor);
        return result;
      }
    }

    public static class shutdown<I extends Iface> extends org.apache.thrift.ProcessFunction<I, shutdown_args> {
      public shutdown() {
        super("shutdown");
      }

      public shutdown_args getEmptyArgsInstance() {
        return new shutdown_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public shutdown_result getResult(I iface, shutdown_args args) throws org.apache.thrift.TException {
        shutdown_result result = new shutdown_result();
        iface.shutdown();
        return result;
      }
    }

    public static class getStatus<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getStatus_args> {
      public getStatus() {
        super("getStatus");
      }

      public getStatus_args getEmptyArgsInstance() {
        return new getStatus_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getStatus_result getResult(I iface, getStatus_args args) throws org.apache.thrift.TException {
        getStatus_result result = new getStatus_result();
        result.success = iface.getStatus(args.noteId, args.jobId);
        return result;
      }
    }

    public static class getEvent<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getEvent_args> {
      public getEvent() {
        super("getEvent");
      }

      public getEvent_args getEmptyArgsInstance() {
        return new getEvent_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getEvent_result getResult(I iface, getEvent_args args) throws org.apache.thrift.TException {
        getEvent_result result = new getEvent_result();
        result.success = iface.getEvent();
        return result;
      }
    }

    public static class resourcePoolResponseGetAll<I extends Iface> extends org.apache.thrift.ProcessFunction<I, resourcePoolResponseGetAll_args> {
      public resourcePoolResponseGetAll() {
        super("resourcePoolResponseGetAll");
      }

      public resourcePoolResponseGetAll_args getEmptyArgsInstance() {
        return new resourcePoolResponseGetAll_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public resourcePoolResponseGetAll_result getResult(I iface, resourcePoolResponseGetAll_args args) throws org.apache.thrift.TException {
        resourcePoolResponseGetAll_result result = new resourcePoolResponseGetAll_result();
        iface.resourcePoolResponseGetAll(args.resources);
        return result;
      }
    }

    public static class resourceResponseGet<I extends Iface> extends org.apache.thrift.ProcessFunction<I, resourceResponseGet_args> {
      public resourceResponseGet() {
        super("resourceResponseGet");
      }

      public resourceResponseGet_args getEmptyArgsInstance() {
        return new resourceResponseGet_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public resourceResponseGet_result getResult(I iface, resourceResponseGet_args args) throws org.apache.thrift.TException {
        resourceResponseGet_result result = new resourceResponseGet_result();
        iface.resourceResponseGet(args.resourceId, args.object);
        return result;
      }
    }

    public static class resourcePoolGetAll<I extends Iface> extends org.apache.thrift.ProcessFunction<I, resourcePoolGetAll_args> {
      public resourcePoolGetAll() {
        super("resourcePoolGetAll");
      }

      public resourcePoolGetAll_args getEmptyArgsInstance() {
        return new resourcePoolGetAll_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public resourcePoolGetAll_result getResult(I iface, resourcePoolGetAll_args args) throws org.apache.thrift.TException {
        resourcePoolGetAll_result result = new resourcePoolGetAll_result();
        result.success = iface.resourcePoolGetAll();
        return result;
      }
    }

    public static class resourceGet<I extends Iface> extends org.apache.thrift.ProcessFunction<I, resourceGet_args> {
      public resourceGet() {
        super("resourceGet");
      }

      public resourceGet_args getEmptyArgsInstance() {
        return new resourceGet_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public resourceGet_result getResult(I iface, resourceGet_args args) throws org.apache.thrift.TException {
        resourceGet_result result = new resourceGet_result();
        result.success = iface.resourceGet(args.noteId, args.paragraphId, args.resourceName);
        return result;
      }
    }

    public static class resourceRemove<I extends Iface> extends org.apache.thrift.ProcessFunction<I, resourceRemove_args> {
      public resourceRemove() {
        super("resourceRemove");
      }

      public resourceRemove_args getEmptyArgsInstance() {
        return new resourceRemove_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public resourceRemove_result getResult(I iface, resourceRemove_args args) throws org.apache.thrift.TException {
        resourceRemove_result result = new resourceRemove_result();
        result.success = iface.resourceRemove(args.noteId, args.paragraphId, args.resourceName);
        result.setSuccessIsSet(true);
        return result;
      }
    }

    public static class angularObjectUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, angularObjectUpdate_args> {
      public angularObjectUpdate() {
        super("angularObjectUpdate");
      }

      public angularObjectUpdate_args getEmptyArgsInstance() {
        return new angularObjectUpdate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public angularObjectUpdate_result getResult(I iface, angularObjectUpdate_args args) throws org.apache.thrift.TException {
        angularObjectUpdate_result result = new angularObjectUpdate_result();
        iface.angularObjectUpdate(args.name, args.noteId, args.paragraphId, args.object);
        return result;
      }
    }

    public static class angularObjectAdd<I extends Iface> extends org.apache.thrift.ProcessFunction<I, angularObjectAdd_args> {
      public angularObjectAdd() {
        super("angularObjectAdd");
      }

      public angularObjectAdd_args getEmptyArgsInstance() {
        return new angularObjectAdd_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public angularObjectAdd_result getResult(I iface, angularObjectAdd_args args) throws org.apache.thrift.TException {
        angularObjectAdd_result result = new angularObjectAdd_result();
        iface.angularObjectAdd(args.name, args.noteId, args.paragraphId, args.object);
        return result;
      }
    }

    public static class angularObjectRemove<I extends Iface> extends org.apache.thrift.ProcessFunction<I, angularObjectRemove_args> {
      public angularObjectRemove() {
        super("angularObjectRemove");
      }

      public angularObjectRemove_args getEmptyArgsInstance() {
        return new angularObjectRemove_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public angularObjectRemove_result getResult(I iface, angularObjectRemove_args args) throws org.apache.thrift.TException {
        angularObjectRemove_result result = new angularObjectRemove_result();
        iface.angularObjectRemove(args.name, args.noteId, args.paragraphId);
        return result;
      }
    }

    public static class angularRegistryPush<I extends Iface> extends org.apache.thrift.ProcessFunction<I, angularRegistryPush_args> {
      public angularRegistryPush() {
        super("angularRegistryPush");
      }

      public angularRegistryPush_args getEmptyArgsInstance() {
        return new angularRegistryPush_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public angularRegistryPush_result getResult(I iface, angularRegistryPush_args args) throws org.apache.thrift.TException {
        angularRegistryPush_result result = new angularRegistryPush_result();
        iface.angularRegistryPush(args.registry);
        return result;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("createInterpreter", new createInterpreter());
      processMap.put("open", new open());
      processMap.put("close", new close());
      processMap.put("interpret", new interpret());
      processMap.put("cancel", new cancel());
      processMap.put("getProgress", new getProgress());
      processMap.put("getFormType", new getFormType());
      processMap.put("completion", new completion());
      processMap.put("shutdown", new shutdown());
      processMap.put("getStatus", new getStatus());
      processMap.put("getEvent", new getEvent());
      processMap.put("resourcePoolResponseGetAll", new resourcePoolResponseGetAll());
      processMap.put("resourceResponseGet", new resourceResponseGet());
      processMap.put("resourcePoolGetAll", new resourcePoolGetAll());
      processMap.put("resourceGet", new resourceGet());
      processMap.put("resourceRemove", new resourceRemove());
      processMap.put("angularObjectUpdate", new angularObjectUpdate());
      processMap.put("angularObjectAdd", new angularObjectAdd());
      processMap.put("angularObjectRemove", new angularObjectRemove());
      processMap.put("angularRegistryPush", new angularRegistryPush());
      return processMap;
    }

    public static class createInterpreter<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createInterpreter_args, Void> {
      public createInterpreter() {
        super("createInterpreter");
      }

      public createInterpreter_args getEmptyArgsInstance() {
        return new createInterpreter_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            createInterpreter_result result = new createInterpreter_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createInterpreter_result result = new createInterpreter_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createInterpreter_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.createInterpreter(args.intpGroupId, args.noteId, args.className, args.properties,resultHandler);
      }
    }

    public static class open<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, open_args, Void> {
      public open() {
        super("open");
      }

      public open_args getEmptyArgsInstance() {
        return new open_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            open_result result = new open_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            open_result result = new open_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, open_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.open(args.noteId, args.className,resultHandler);
      }
    }

    public static class close<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, close_args, Void> {
      public close() {
        super("close");
      }

      public close_args getEmptyArgsInstance() {
        return new close_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            close_result result = new close_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            close_result result = new close_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, close_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.close(args.noteId, args.className,resultHandler);
      }
    }

    public static class interpret<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, interpret_args, RemoteInterpreterResult> {
      public interpret() {
        super("interpret");
      }

      public interpret_args getEmptyArgsInstance() {
        return new interpret_args();
      }

      public AsyncMethodCallback<RemoteInterpreterResult> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<RemoteInterpreterResult>() { 
          public void onComplete(RemoteInterpreterResult o) {
            interpret_result result = new interpret_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            interpret_result result = new interpret_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, interpret_args args, org.apache.thrift.async.AsyncMethodCallback<RemoteInterpreterResult> resultHandler) throws TException {
        iface.interpret(args.noteId, args.className, args.st, args.interpreterContext,resultHandler);
      }
    }

    public static class cancel<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, cancel_args, Void> {
      public cancel() {
        super("cancel");
      }

      public cancel_args getEmptyArgsInstance() {
        return new cancel_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            cancel_result result = new cancel_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            cancel_result result = new cancel_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, cancel_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.cancel(args.noteId, args.className, args.interpreterContext,resultHandler);
      }
    }

    public static class getProgress<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getProgress_args, Integer> {
      public getProgress() {
        super("getProgress");
      }

      public getProgress_args getEmptyArgsInstance() {
        return new getProgress_args();
      }

      public AsyncMethodCallback<Integer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Integer>() { 
          public void onComplete(Integer o) {
            getProgress_result result = new getProgress_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getProgress_result result = new getProgress_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getProgress_args args, org.apache.thrift.async.AsyncMethodCallback<Integer> resultHandler) throws TException {
        iface.getProgress(args.noteId, args.className, args.interpreterContext,resultHandler);
      }
    }

    public static class getFormType<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getFormType_args, String> {
      public getFormType() {
        super("getFormType");
      }

      public getFormType_args getEmptyArgsInstance() {
        return new getFormType_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            getFormType_result result = new getFormType_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getFormType_result result = new getFormType_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getFormType_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.getFormType(args.noteId, args.className,resultHandler);
      }
    }

    public static class completion<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, completion_args, List<InterpreterCompletion>> {
      public completion() {
        super("completion");
      }

      public completion_args getEmptyArgsInstance() {
        return new completion_args();
      }

      public AsyncMethodCallback<List<InterpreterCompletion>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<InterpreterCompletion>>() { 
          public void onComplete(List<InterpreterCompletion> o) {
            completion_result result = new completion_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            completion_result result = new completion_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, completion_args args, org.apache.thrift.async.AsyncMethodCallback<List<InterpreterCompletion>> resultHandler) throws TException {
        iface.completion(args.noteId, args.className, args.buf, args.cursor,resultHandler);
      }
    }

    public static class shutdown<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, shutdown_args, Void> {
      public shutdown() {
        super("shutdown");
      }

      public shutdown_args getEmptyArgsInstance() {
        return new shutdown_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            shutdown_result result = new shutdown_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            shutdown_result result = new shutdown_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, shutdown_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.shutdown(resultHandler);
      }
    }

    public static class getStatus<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getStatus_args, String> {
      public getStatus() {
        super("getStatus");
      }

      public getStatus_args getEmptyArgsInstance() {
        return new getStatus_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            getStatus_result result = new getStatus_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getStatus_result result = new getStatus_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getStatus_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.getStatus(args.noteId, args.jobId,resultHandler);
      }
    }

    public static class getEvent<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getEvent_args, RemoteInterpreterEvent> {
      public getEvent() {
        super("getEvent");
      }

      public getEvent_args getEmptyArgsInstance() {
        return new getEvent_args();
      }

      public AsyncMethodCallback<RemoteInterpreterEvent> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<RemoteInterpreterEvent>() { 
          public void onComplete(RemoteInterpreterEvent o) {
            getEvent_result result = new getEvent_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getEvent_result result = new getEvent_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getEvent_args args, org.apache.thrift.async.AsyncMethodCallback<RemoteInterpreterEvent> resultHandler) throws TException {
        iface.getEvent(resultHandler);
      }
    }

    public static class resourcePoolResponseGetAll<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, resourcePoolResponseGetAll_args, Void> {
      public resourcePoolResponseGetAll() {
        super("resourcePoolResponseGetAll");
      }

      public resourcePoolResponseGetAll_args getEmptyArgsInstance() {
        return new resourcePoolResponseGetAll_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            resourcePoolResponseGetAll_result result = new resourcePoolResponseGetAll_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            resourcePoolResponseGetAll_result result = new resourcePoolResponseGetAll_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, resourcePoolResponseGetAll_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.resourcePoolResponseGetAll(args.resources,resultHandler);
      }
    }

    public static class resourceResponseGet<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, resourceResponseGet_args, Void> {
      public resourceResponseGet() {
        super("resourceResponseGet");
      }

      public resourceResponseGet_args getEmptyArgsInstance() {
        return new resourceResponseGet_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            resourceResponseGet_result result = new resourceResponseGet_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            resourceResponseGet_result result = new resourceResponseGet_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, resourceResponseGet_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.resourceResponseGet(args.resourceId, args.object,resultHandler);
      }
    }

    public static class resourcePoolGetAll<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, resourcePoolGetAll_args, List<String>> {
      public resourcePoolGetAll() {
        super("resourcePoolGetAll");
      }

      public resourcePoolGetAll_args getEmptyArgsInstance() {
        return new resourcePoolGetAll_args();
      }

      public AsyncMethodCallback<List<String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<String>>() { 
          public void onComplete(List<String> o) {
            resourcePoolGetAll_result result = new resourcePoolGetAll_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            resourcePoolGetAll_result result = new resourcePoolGetAll_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, resourcePoolGetAll_args args, org.apache.thrift.async.AsyncMethodCallback<List<String>> resultHandler) throws TException {
        iface.resourcePoolGetAll(resultHandler);
      }
    }

    public static class resourceGet<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, resourceGet_args, ByteBuffer> {
      public resourceGet() {
        super("resourceGet");
      }

      public resourceGet_args getEmptyArgsInstance() {
        return new resourceGet_args();
      }

      public AsyncMethodCallback<ByteBuffer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ByteBuffer>() { 
          public void onComplete(ByteBuffer o) {
            resourceGet_result result = new resourceGet_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            resourceGet_result result = new resourceGet_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, resourceGet_args args, org.apache.thrift.async.AsyncMethodCallback<ByteBuffer> resultHandler) throws TException {
        iface.resourceGet(args.noteId, args.paragraphId, args.resourceName,resultHandler);
      }
    }

    public static class resourceRemove<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, resourceRemove_args, Boolean> {
      public resourceRemove() {
        super("resourceRemove");
      }

      public resourceRemove_args getEmptyArgsInstance() {
        return new resourceRemove_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            resourceRemove_result result = new resourceRemove_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            resourceRemove_result result = new resourceRemove_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, resourceRemove_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.resourceRemove(args.noteId, args.paragraphId, args.resourceName,resultHandler);
      }
    }

    public static class angularObjectUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, angularObjectUpdate_args, Void> {
      public angularObjectUpdate() {
        super("angularObjectUpdate");
      }

      public angularObjectUpdate_args getEmptyArgsInstance() {
        return new angularObjectUpdate_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            angularObjectUpdate_result result = new angularObjectUpdate_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            angularObjectUpdate_result result = new angularObjectUpdate_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, angularObjectUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.angularObjectUpdate(args.name, args.noteId, args.paragraphId, args.object,resultHandler);
      }
    }

    public static class angularObjectAdd<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, angularObjectAdd_args, Void> {
      public angularObjectAdd() {
        super("angularObjectAdd");
      }

      public angularObjectAdd_args getEmptyArgsInstance() {
        return new angularObjectAdd_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            angularObjectAdd_result result = new angularObjectAdd_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            angularObjectAdd_result result = new angularObjectAdd_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, angularObjectAdd_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.angularObjectAdd(args.name, args.noteId, args.paragraphId, args.object,resultHandler);
      }
    }

    public static class angularObjectRemove<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, angularObjectRemove_args, Void> {
      public angularObjectRemove() {
        super("angularObjectRemove");
      }

      public angularObjectRemove_args getEmptyArgsInstance() {
        return new angularObjectRemove_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            angularObjectRemove_result result = new angularObjectRemove_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            angularObjectRemove_result result = new angularObjectRemove_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, angularObjectRemove_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.angularObjectRemove(args.name, args.noteId, args.paragraphId,resultHandler);
      }
    }

    public static class angularRegistryPush<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, angularRegistryPush_args, Void> {
      public angularRegistryPush() {
        super("angularRegistryPush");
      }

      public angularRegistryPush_args getEmptyArgsInstance() {
        return new angularRegistryPush_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            angularRegistryPush_result result = new angularRegistryPush_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            angularRegistryPush_result result = new angularRegistryPush_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, angularRegistryPush_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.angularRegistryPush(args.registry,resultHandler);
      }
    }

  }

  public static class createInterpreter_args implements org.apache.thrift.TBase<createInterpreter_args, createInterpreter_args._Fields>, java.io.Serializable, Cloneable, Comparable<createInterpreter_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createInterpreter_args");

    private static final org.apache.thrift.protocol.TField INTP_GROUP_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("intpGroupId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField CLASS_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("className", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField PROPERTIES_FIELD_DESC = new org.apache.thrift.protocol.TField("properties", org.apache.thrift.protocol.TType.MAP, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createInterpreter_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createInterpreter_argsTupleSchemeFactory());
    }

    public String intpGroupId; // required
    public String noteId; // required
    public String className; // required
    public Map<String,String> properties; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      INTP_GROUP_ID((short)1, "intpGroupId"),
      NOTE_ID((short)2, "noteId"),
      CLASS_NAME((short)3, "className"),
      PROPERTIES((short)4, "properties");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // INTP_GROUP_ID
            return INTP_GROUP_ID;
          case 2: // NOTE_ID
            return NOTE_ID;
          case 3: // CLASS_NAME
            return CLASS_NAME;
          case 4: // PROPERTIES
            return PROPERTIES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.INTP_GROUP_ID, new org.apache.thrift.meta_data.FieldMetaData("intpGroupId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.CLASS_NAME, new org.apache.thrift.meta_data.FieldMetaData("className", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PROPERTIES, new org.apache.thrift.meta_data.FieldMetaData("properties", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createInterpreter_args.class, metaDataMap);
    }

    public createInterpreter_args() {
    }

    public createInterpreter_args(
      String intpGroupId,
      String noteId,
      String className,
      Map<String,String> properties)
    {
      this();
      this.intpGroupId = intpGroupId;
      this.noteId = noteId;
      this.className = className;
      this.properties = properties;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createInterpreter_args(createInterpreter_args other) {
      if (other.isSetIntpGroupId()) {
        this.intpGroupId = other.intpGroupId;
      }
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetClassName()) {
        this.className = other.className;
      }
      if (other.isSetProperties()) {
        Map<String,String> __this__properties = new HashMap<String,String>(other.properties);
        this.properties = __this__properties;
      }
    }

    public createInterpreter_args deepCopy() {
      return new createInterpreter_args(this);
    }

    @Override
    public void clear() {
      this.intpGroupId = null;
      this.noteId = null;
      this.className = null;
      this.properties = null;
    }

    public String getIntpGroupId() {
      return this.intpGroupId;
    }

    public createInterpreter_args setIntpGroupId(String intpGroupId) {
      this.intpGroupId = intpGroupId;
      return this;
    }

    public void unsetIntpGroupId() {
      this.intpGroupId = null;
    }

    /** Returns true if field intpGroupId is set (has been assigned a value) and false otherwise */
    public boolean isSetIntpGroupId() {
      return this.intpGroupId != null;
    }

    public void setIntpGroupIdIsSet(boolean value) {
      if (!value) {
        this.intpGroupId = null;
      }
    }

    public String getNoteId() {
      return this.noteId;
    }

    public createInterpreter_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getClassName() {
      return this.className;
    }

    public createInterpreter_args setClassName(String className) {
      this.className = className;
      return this;
    }

    public void unsetClassName() {
      this.className = null;
    }

    /** Returns true if field className is set (has been assigned a value) and false otherwise */
    public boolean isSetClassName() {
      return this.className != null;
    }

    public void setClassNameIsSet(boolean value) {
      if (!value) {
        this.className = null;
      }
    }

    public int getPropertiesSize() {
      return (this.properties == null) ? 0 : this.properties.size();
    }

    public void putToProperties(String key, String val) {
      if (this.properties == null) {
        this.properties = new HashMap<String,String>();
      }
      this.properties.put(key, val);
    }

    public Map<String,String> getProperties() {
      return this.properties;
    }

    public createInterpreter_args setProperties(Map<String,String> properties) {
      this.properties = properties;
      return this;
    }

    public void unsetProperties() {
      this.properties = null;
    }

    /** Returns true if field properties is set (has been assigned a value) and false otherwise */
    public boolean isSetProperties() {
      return this.properties != null;
    }

    public void setPropertiesIsSet(boolean value) {
      if (!value) {
        this.properties = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case INTP_GROUP_ID:
        if (value == null) {
          unsetIntpGroupId();
        } else {
          setIntpGroupId((String)value);
        }
        break;

      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case CLASS_NAME:
        if (value == null) {
          unsetClassName();
        } else {
          setClassName((String)value);
        }
        break;

      case PROPERTIES:
        if (value == null) {
          unsetProperties();
        } else {
          setProperties((Map<String,String>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case INTP_GROUP_ID:
        return getIntpGroupId();

      case NOTE_ID:
        return getNoteId();

      case CLASS_NAME:
        return getClassName();

      case PROPERTIES:
        return getProperties();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case INTP_GROUP_ID:
        return isSetIntpGroupId();
      case NOTE_ID:
        return isSetNoteId();
      case CLASS_NAME:
        return isSetClassName();
      case PROPERTIES:
        return isSetProperties();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createInterpreter_args)
        return this.equals((createInterpreter_args)that);
      return false;
    }

    public boolean equals(createInterpreter_args that) {
      if (that == null)
        return false;

      boolean this_present_intpGroupId = true && this.isSetIntpGroupId();
      boolean that_present_intpGroupId = true && that.isSetIntpGroupId();
      if (this_present_intpGroupId || that_present_intpGroupId) {
        if (!(this_present_intpGroupId && that_present_intpGroupId))
          return false;
        if (!this.intpGroupId.equals(that.intpGroupId))
          return false;
      }

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_className = true && this.isSetClassName();
      boolean that_present_className = true && that.isSetClassName();
      if (this_present_className || that_present_className) {
        if (!(this_present_className && that_present_className))
          return false;
        if (!this.className.equals(that.className))
          return false;
      }

      boolean this_present_properties = true && this.isSetProperties();
      boolean that_present_properties = true && that.isSetProperties();
      if (this_present_properties || that_present_properties) {
        if (!(this_present_properties && that_present_properties))
          return false;
        if (!this.properties.equals(that.properties))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_intpGroupId = true && (isSetIntpGroupId());
      list.add(present_intpGroupId);
      if (present_intpGroupId)
        list.add(intpGroupId);

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_className = true && (isSetClassName());
      list.add(present_className);
      if (present_className)
        list.add(className);

      boolean present_properties = true && (isSetProperties());
      list.add(present_properties);
      if (present_properties)
        list.add(properties);

      return list.hashCode();
    }

    @Override
    public int compareTo(createInterpreter_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetIntpGroupId()).compareTo(other.isSetIntpGroupId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIntpGroupId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.intpGroupId, other.intpGroupId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetClassName()).compareTo(other.isSetClassName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClassName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.className, other.className);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetProperties()).compareTo(other.isSetProperties());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetProperties()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.properties, other.properties);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createInterpreter_args(");
      boolean first = true;

      sb.append("intpGroupId:");
      if (this.intpGroupId == null) {
        sb.append("null");
      } else {
        sb.append(this.intpGroupId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("className:");
      if (this.className == null) {
        sb.append("null");
      } else {
        sb.append(this.className);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("properties:");
      if (this.properties == null) {
        sb.append("null");
      } else {
        sb.append(this.properties);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createInterpreter_argsStandardSchemeFactory implements SchemeFactory {
      public createInterpreter_argsStandardScheme getScheme() {
        return new createInterpreter_argsStandardScheme();
      }
    }

    private static class createInterpreter_argsStandardScheme extends StandardScheme<createInterpreter_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createInterpreter_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // INTP_GROUP_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.intpGroupId = iprot.readString();
                struct.setIntpGroupIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // CLASS_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.className = iprot.readString();
                struct.setClassNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // PROPERTIES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map0 = iprot.readMapBegin();
                  struct.properties = new HashMap<String,String>(2*_map0.size);
                  String _key1;
                  String _val2;
                  for (int _i3 = 0; _i3 < _map0.size; ++_i3)
                  {
                    _key1 = iprot.readString();
                    _val2 = iprot.readString();
                    struct.properties.put(_key1, _val2);
                  }
                  iprot.readMapEnd();
                }
                struct.setPropertiesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createInterpreter_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.intpGroupId != null) {
          oprot.writeFieldBegin(INTP_GROUP_ID_FIELD_DESC);
          oprot.writeString(struct.intpGroupId);
          oprot.writeFieldEnd();
        }
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.className != null) {
          oprot.writeFieldBegin(CLASS_NAME_FIELD_DESC);
          oprot.writeString(struct.className);
          oprot.writeFieldEnd();
        }
        if (struct.properties != null) {
          oprot.writeFieldBegin(PROPERTIES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.properties.size()));
            for (Map.Entry<String, String> _iter4 : struct.properties.entrySet())
            {
              oprot.writeString(_iter4.getKey());
              oprot.writeString(_iter4.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createInterpreter_argsTupleSchemeFactory implements SchemeFactory {
      public createInterpreter_argsTupleScheme getScheme() {
        return new createInterpreter_argsTupleScheme();
      }
    }

    private static class createInterpreter_argsTupleScheme extends TupleScheme<createInterpreter_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createInterpreter_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetIntpGroupId()) {
          optionals.set(0);
        }
        if (struct.isSetNoteId()) {
          optionals.set(1);
        }
        if (struct.isSetClassName()) {
          optionals.set(2);
        }
        if (struct.isSetProperties()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetIntpGroupId()) {
          oprot.writeString(struct.intpGroupId);
        }
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetClassName()) {
          oprot.writeString(struct.className);
        }
        if (struct.isSetProperties()) {
          {
            oprot.writeI32(struct.properties.size());
            for (Map.Entry<String, String> _iter5 : struct.properties.entrySet())
            {
              oprot.writeString(_iter5.getKey());
              oprot.writeString(_iter5.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createInterpreter_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.intpGroupId = iprot.readString();
          struct.setIntpGroupIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(2)) {
          struct.className = iprot.readString();
          struct.setClassNameIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TMap _map6 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.properties = new HashMap<String,String>(2*_map6.size);
            String _key7;
            String _val8;
            for (int _i9 = 0; _i9 < _map6.size; ++_i9)
            {
              _key7 = iprot.readString();
              _val8 = iprot.readString();
              struct.properties.put(_key7, _val8);
            }
          }
          struct.setPropertiesIsSet(true);
        }
      }
    }

  }

  public static class createInterpreter_result implements org.apache.thrift.TBase<createInterpreter_result, createInterpreter_result._Fields>, java.io.Serializable, Cloneable, Comparable<createInterpreter_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createInterpreter_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createInterpreter_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createInterpreter_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createInterpreter_result.class, metaDataMap);
    }

    public createInterpreter_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createInterpreter_result(createInterpreter_result other) {
    }

    public createInterpreter_result deepCopy() {
      return new createInterpreter_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createInterpreter_result)
        return this.equals((createInterpreter_result)that);
      return false;
    }

    public boolean equals(createInterpreter_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(createInterpreter_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createInterpreter_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createInterpreter_resultStandardSchemeFactory implements SchemeFactory {
      public createInterpreter_resultStandardScheme getScheme() {
        return new createInterpreter_resultStandardScheme();
      }
    }

    private static class createInterpreter_resultStandardScheme extends StandardScheme<createInterpreter_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createInterpreter_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createInterpreter_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createInterpreter_resultTupleSchemeFactory implements SchemeFactory {
      public createInterpreter_resultTupleScheme getScheme() {
        return new createInterpreter_resultTupleScheme();
      }
    }

    private static class createInterpreter_resultTupleScheme extends TupleScheme<createInterpreter_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createInterpreter_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createInterpreter_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class open_args implements org.apache.thrift.TBase<open_args, open_args._Fields>, java.io.Serializable, Cloneable, Comparable<open_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("open_args");

    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField CLASS_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("className", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new open_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new open_argsTupleSchemeFactory());
    }

    public String noteId; // required
    public String className; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NOTE_ID((short)1, "noteId"),
      CLASS_NAME((short)2, "className");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NOTE_ID
            return NOTE_ID;
          case 2: // CLASS_NAME
            return CLASS_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.CLASS_NAME, new org.apache.thrift.meta_data.FieldMetaData("className", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(open_args.class, metaDataMap);
    }

    public open_args() {
    }

    public open_args(
      String noteId,
      String className)
    {
      this();
      this.noteId = noteId;
      this.className = className;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public open_args(open_args other) {
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetClassName()) {
        this.className = other.className;
      }
    }

    public open_args deepCopy() {
      return new open_args(this);
    }

    @Override
    public void clear() {
      this.noteId = null;
      this.className = null;
    }

    public String getNoteId() {
      return this.noteId;
    }

    public open_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getClassName() {
      return this.className;
    }

    public open_args setClassName(String className) {
      this.className = className;
      return this;
    }

    public void unsetClassName() {
      this.className = null;
    }

    /** Returns true if field className is set (has been assigned a value) and false otherwise */
    public boolean isSetClassName() {
      return this.className != null;
    }

    public void setClassNameIsSet(boolean value) {
      if (!value) {
        this.className = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case CLASS_NAME:
        if (value == null) {
          unsetClassName();
        } else {
          setClassName((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NOTE_ID:
        return getNoteId();

      case CLASS_NAME:
        return getClassName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NOTE_ID:
        return isSetNoteId();
      case CLASS_NAME:
        return isSetClassName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof open_args)
        return this.equals((open_args)that);
      return false;
    }

    public boolean equals(open_args that) {
      if (that == null)
        return false;

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_className = true && this.isSetClassName();
      boolean that_present_className = true && that.isSetClassName();
      if (this_present_className || that_present_className) {
        if (!(this_present_className && that_present_className))
          return false;
        if (!this.className.equals(that.className))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_className = true && (isSetClassName());
      list.add(present_className);
      if (present_className)
        list.add(className);

      return list.hashCode();
    }

    @Override
    public int compareTo(open_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetClassName()).compareTo(other.isSetClassName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClassName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.className, other.className);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("open_args(");
      boolean first = true;

      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("className:");
      if (this.className == null) {
        sb.append("null");
      } else {
        sb.append(this.className);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class open_argsStandardSchemeFactory implements SchemeFactory {
      public open_argsStandardScheme getScheme() {
        return new open_argsStandardScheme();
      }
    }

    private static class open_argsStandardScheme extends StandardScheme<open_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, open_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CLASS_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.className = iprot.readString();
                struct.setClassNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, open_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.className != null) {
          oprot.writeFieldBegin(CLASS_NAME_FIELD_DESC);
          oprot.writeString(struct.className);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class open_argsTupleSchemeFactory implements SchemeFactory {
      public open_argsTupleScheme getScheme() {
        return new open_argsTupleScheme();
      }
    }

    private static class open_argsTupleScheme extends TupleScheme<open_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, open_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetNoteId()) {
          optionals.set(0);
        }
        if (struct.isSetClassName()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetClassName()) {
          oprot.writeString(struct.className);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, open_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.className = iprot.readString();
          struct.setClassNameIsSet(true);
        }
      }
    }

  }

  public static class open_result implements org.apache.thrift.TBase<open_result, open_result._Fields>, java.io.Serializable, Cloneable, Comparable<open_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("open_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new open_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new open_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(open_result.class, metaDataMap);
    }

    public open_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public open_result(open_result other) {
    }

    public open_result deepCopy() {
      return new open_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof open_result)
        return this.equals((open_result)that);
      return false;
    }

    public boolean equals(open_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(open_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("open_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class open_resultStandardSchemeFactory implements SchemeFactory {
      public open_resultStandardScheme getScheme() {
        return new open_resultStandardScheme();
      }
    }

    private static class open_resultStandardScheme extends StandardScheme<open_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, open_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, open_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class open_resultTupleSchemeFactory implements SchemeFactory {
      public open_resultTupleScheme getScheme() {
        return new open_resultTupleScheme();
      }
    }

    private static class open_resultTupleScheme extends TupleScheme<open_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, open_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, open_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class close_args implements org.apache.thrift.TBase<close_args, close_args._Fields>, java.io.Serializable, Cloneable, Comparable<close_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("close_args");

    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField CLASS_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("className", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new close_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new close_argsTupleSchemeFactory());
    }

    public String noteId; // required
    public String className; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NOTE_ID((short)1, "noteId"),
      CLASS_NAME((short)2, "className");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NOTE_ID
            return NOTE_ID;
          case 2: // CLASS_NAME
            return CLASS_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.CLASS_NAME, new org.apache.thrift.meta_data.FieldMetaData("className", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(close_args.class, metaDataMap);
    }

    public close_args() {
    }

    public close_args(
      String noteId,
      String className)
    {
      this();
      this.noteId = noteId;
      this.className = className;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public close_args(close_args other) {
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetClassName()) {
        this.className = other.className;
      }
    }

    public close_args deepCopy() {
      return new close_args(this);
    }

    @Override
    public void clear() {
      this.noteId = null;
      this.className = null;
    }

    public String getNoteId() {
      return this.noteId;
    }

    public close_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getClassName() {
      return this.className;
    }

    public close_args setClassName(String className) {
      this.className = className;
      return this;
    }

    public void unsetClassName() {
      this.className = null;
    }

    /** Returns true if field className is set (has been assigned a value) and false otherwise */
    public boolean isSetClassName() {
      return this.className != null;
    }

    public void setClassNameIsSet(boolean value) {
      if (!value) {
        this.className = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case CLASS_NAME:
        if (value == null) {
          unsetClassName();
        } else {
          setClassName((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NOTE_ID:
        return getNoteId();

      case CLASS_NAME:
        return getClassName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NOTE_ID:
        return isSetNoteId();
      case CLASS_NAME:
        return isSetClassName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof close_args)
        return this.equals((close_args)that);
      return false;
    }

    public boolean equals(close_args that) {
      if (that == null)
        return false;

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_className = true && this.isSetClassName();
      boolean that_present_className = true && that.isSetClassName();
      if (this_present_className || that_present_className) {
        if (!(this_present_className && that_present_className))
          return false;
        if (!this.className.equals(that.className))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_className = true && (isSetClassName());
      list.add(present_className);
      if (present_className)
        list.add(className);

      return list.hashCode();
    }

    @Override
    public int compareTo(close_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetClassName()).compareTo(other.isSetClassName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClassName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.className, other.className);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("close_args(");
      boolean first = true;

      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("className:");
      if (this.className == null) {
        sb.append("null");
      } else {
        sb.append(this.className);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class close_argsStandardSchemeFactory implements SchemeFactory {
      public close_argsStandardScheme getScheme() {
        return new close_argsStandardScheme();
      }
    }

    private static class close_argsStandardScheme extends StandardScheme<close_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, close_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CLASS_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.className = iprot.readString();
                struct.setClassNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, close_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.className != null) {
          oprot.writeFieldBegin(CLASS_NAME_FIELD_DESC);
          oprot.writeString(struct.className);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class close_argsTupleSchemeFactory implements SchemeFactory {
      public close_argsTupleScheme getScheme() {
        return new close_argsTupleScheme();
      }
    }

    private static class close_argsTupleScheme extends TupleScheme<close_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, close_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetNoteId()) {
          optionals.set(0);
        }
        if (struct.isSetClassName()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetClassName()) {
          oprot.writeString(struct.className);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, close_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.className = iprot.readString();
          struct.setClassNameIsSet(true);
        }
      }
    }

  }

  public static class close_result implements org.apache.thrift.TBase<close_result, close_result._Fields>, java.io.Serializable, Cloneable, Comparable<close_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("close_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new close_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new close_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(close_result.class, metaDataMap);
    }

    public close_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public close_result(close_result other) {
    }

    public close_result deepCopy() {
      return new close_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof close_result)
        return this.equals((close_result)that);
      return false;
    }

    public boolean equals(close_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(close_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("close_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class close_resultStandardSchemeFactory implements SchemeFactory {
      public close_resultStandardScheme getScheme() {
        return new close_resultStandardScheme();
      }
    }

    private static class close_resultStandardScheme extends StandardScheme<close_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, close_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, close_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class close_resultTupleSchemeFactory implements SchemeFactory {
      public close_resultTupleScheme getScheme() {
        return new close_resultTupleScheme();
      }
    }

    private static class close_resultTupleScheme extends TupleScheme<close_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, close_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, close_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class interpret_args implements org.apache.thrift.TBase<interpret_args, interpret_args._Fields>, java.io.Serializable, Cloneable, Comparable<interpret_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("interpret_args");

    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField CLASS_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("className", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField ST_FIELD_DESC = new org.apache.thrift.protocol.TField("st", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField INTERPRETER_CONTEXT_FIELD_DESC = new org.apache.thrift.protocol.TField("interpreterContext", org.apache.thrift.protocol.TType.STRUCT, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new interpret_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new interpret_argsTupleSchemeFactory());
    }

    public String noteId; // required
    public String className; // required
    public String st; // required
    public RemoteInterpreterContext interpreterContext; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NOTE_ID((short)1, "noteId"),
      CLASS_NAME((short)2, "className"),
      ST((short)3, "st"),
      INTERPRETER_CONTEXT((short)4, "interpreterContext");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NOTE_ID
            return NOTE_ID;
          case 2: // CLASS_NAME
            return CLASS_NAME;
          case 3: // ST
            return ST;
          case 4: // INTERPRETER_CONTEXT
            return INTERPRETER_CONTEXT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.CLASS_NAME, new org.apache.thrift.meta_data.FieldMetaData("className", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.ST, new org.apache.thrift.meta_data.FieldMetaData("st", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.INTERPRETER_CONTEXT, new org.apache.thrift.meta_data.FieldMetaData("interpreterContext", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, RemoteInterpreterContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(interpret_args.class, metaDataMap);
    }

    public interpret_args() {
    }

    public interpret_args(
      String noteId,
      String className,
      String st,
      RemoteInterpreterContext interpreterContext)
    {
      this();
      this.noteId = noteId;
      this.className = className;
      this.st = st;
      this.interpreterContext = interpreterContext;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public interpret_args(interpret_args other) {
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetClassName()) {
        this.className = other.className;
      }
      if (other.isSetSt()) {
        this.st = other.st;
      }
      if (other.isSetInterpreterContext()) {
        this.interpreterContext = new RemoteInterpreterContext(other.interpreterContext);
      }
    }

    public interpret_args deepCopy() {
      return new interpret_args(this);
    }

    @Override
    public void clear() {
      this.noteId = null;
      this.className = null;
      this.st = null;
      this.interpreterContext = null;
    }

    public String getNoteId() {
      return this.noteId;
    }

    public interpret_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getClassName() {
      return this.className;
    }

    public interpret_args setClassName(String className) {
      this.className = className;
      return this;
    }

    public void unsetClassName() {
      this.className = null;
    }

    /** Returns true if field className is set (has been assigned a value) and false otherwise */
    public boolean isSetClassName() {
      return this.className != null;
    }

    public void setClassNameIsSet(boolean value) {
      if (!value) {
        this.className = null;
      }
    }

    public String getSt() {
      return this.st;
    }

    public interpret_args setSt(String st) {
      this.st = st;
      return this;
    }

    public void unsetSt() {
      this.st = null;
    }

    /** Returns true if field st is set (has been assigned a value) and false otherwise */
    public boolean isSetSt() {
      return this.st != null;
    }

    public void setStIsSet(boolean value) {
      if (!value) {
        this.st = null;
      }
    }

    public RemoteInterpreterContext getInterpreterContext() {
      return this.interpreterContext;
    }

    public interpret_args setInterpreterContext(RemoteInterpreterContext interpreterContext) {
      this.interpreterContext = interpreterContext;
      return this;
    }

    public void unsetInterpreterContext() {
      this.interpreterContext = null;
    }

    /** Returns true if field interpreterContext is set (has been assigned a value) and false otherwise */
    public boolean isSetInterpreterContext() {
      return this.interpreterContext != null;
    }

    public void setInterpreterContextIsSet(boolean value) {
      if (!value) {
        this.interpreterContext = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case CLASS_NAME:
        if (value == null) {
          unsetClassName();
        } else {
          setClassName((String)value);
        }
        break;

      case ST:
        if (value == null) {
          unsetSt();
        } else {
          setSt((String)value);
        }
        break;

      case INTERPRETER_CONTEXT:
        if (value == null) {
          unsetInterpreterContext();
        } else {
          setInterpreterContext((RemoteInterpreterContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NOTE_ID:
        return getNoteId();

      case CLASS_NAME:
        return getClassName();

      case ST:
        return getSt();

      case INTERPRETER_CONTEXT:
        return getInterpreterContext();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NOTE_ID:
        return isSetNoteId();
      case CLASS_NAME:
        return isSetClassName();
      case ST:
        return isSetSt();
      case INTERPRETER_CONTEXT:
        return isSetInterpreterContext();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof interpret_args)
        return this.equals((interpret_args)that);
      return false;
    }

    public boolean equals(interpret_args that) {
      if (that == null)
        return false;

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_className = true && this.isSetClassName();
      boolean that_present_className = true && that.isSetClassName();
      if (this_present_className || that_present_className) {
        if (!(this_present_className && that_present_className))
          return false;
        if (!this.className.equals(that.className))
          return false;
      }

      boolean this_present_st = true && this.isSetSt();
      boolean that_present_st = true && that.isSetSt();
      if (this_present_st || that_present_st) {
        if (!(this_present_st && that_present_st))
          return false;
        if (!this.st.equals(that.st))
          return false;
      }

      boolean this_present_interpreterContext = true && this.isSetInterpreterContext();
      boolean that_present_interpreterContext = true && that.isSetInterpreterContext();
      if (this_present_interpreterContext || that_present_interpreterContext) {
        if (!(this_present_interpreterContext && that_present_interpreterContext))
          return false;
        if (!this.interpreterContext.equals(that.interpreterContext))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_className = true && (isSetClassName());
      list.add(present_className);
      if (present_className)
        list.add(className);

      boolean present_st = true && (isSetSt());
      list.add(present_st);
      if (present_st)
        list.add(st);

      boolean present_interpreterContext = true && (isSetInterpreterContext());
      list.add(present_interpreterContext);
      if (present_interpreterContext)
        list.add(interpreterContext);

      return list.hashCode();
    }

    @Override
    public int compareTo(interpret_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetClassName()).compareTo(other.isSetClassName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClassName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.className, other.className);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSt()).compareTo(other.isSetSt());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSt()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.st, other.st);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetInterpreterContext()).compareTo(other.isSetInterpreterContext());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetInterpreterContext()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.interpreterContext, other.interpreterContext);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("interpret_args(");
      boolean first = true;

      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("className:");
      if (this.className == null) {
        sb.append("null");
      } else {
        sb.append(this.className);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("st:");
      if (this.st == null) {
        sb.append("null");
      } else {
        sb.append(this.st);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("interpreterContext:");
      if (this.interpreterContext == null) {
        sb.append("null");
      } else {
        sb.append(this.interpreterContext);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (interpreterContext != null) {
        interpreterContext.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class interpret_argsStandardSchemeFactory implements SchemeFactory {
      public interpret_argsStandardScheme getScheme() {
        return new interpret_argsStandardScheme();
      }
    }

    private static class interpret_argsStandardScheme extends StandardScheme<interpret_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, interpret_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CLASS_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.className = iprot.readString();
                struct.setClassNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // ST
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.st = iprot.readString();
                struct.setStIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // INTERPRETER_CONTEXT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.interpreterContext = new RemoteInterpreterContext();
                struct.interpreterContext.read(iprot);
                struct.setInterpreterContextIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, interpret_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.className != null) {
          oprot.writeFieldBegin(CLASS_NAME_FIELD_DESC);
          oprot.writeString(struct.className);
          oprot.writeFieldEnd();
        }
        if (struct.st != null) {
          oprot.writeFieldBegin(ST_FIELD_DESC);
          oprot.writeString(struct.st);
          oprot.writeFieldEnd();
        }
        if (struct.interpreterContext != null) {
          oprot.writeFieldBegin(INTERPRETER_CONTEXT_FIELD_DESC);
          struct.interpreterContext.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class interpret_argsTupleSchemeFactory implements SchemeFactory {
      public interpret_argsTupleScheme getScheme() {
        return new interpret_argsTupleScheme();
      }
    }

    private static class interpret_argsTupleScheme extends TupleScheme<interpret_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, interpret_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetNoteId()) {
          optionals.set(0);
        }
        if (struct.isSetClassName()) {
          optionals.set(1);
        }
        if (struct.isSetSt()) {
          optionals.set(2);
        }
        if (struct.isSetInterpreterContext()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetClassName()) {
          oprot.writeString(struct.className);
        }
        if (struct.isSetSt()) {
          oprot.writeString(struct.st);
        }
        if (struct.isSetInterpreterContext()) {
          struct.interpreterContext.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, interpret_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.className = iprot.readString();
          struct.setClassNameIsSet(true);
        }
        if (incoming.get(2)) {
          struct.st = iprot.readString();
          struct.setStIsSet(true);
        }
        if (incoming.get(3)) {
          struct.interpreterContext = new RemoteInterpreterContext();
          struct.interpreterContext.read(iprot);
          struct.setInterpreterContextIsSet(true);
        }
      }
    }

  }

  public static class interpret_result implements org.apache.thrift.TBase<interpret_result, interpret_result._Fields>, java.io.Serializable, Cloneable, Comparable<interpret_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("interpret_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new interpret_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new interpret_resultTupleSchemeFactory());
    }

    public RemoteInterpreterResult success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, RemoteInterpreterResult.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(interpret_result.class, metaDataMap);
    }

    public interpret_result() {
    }

    public interpret_result(
      RemoteInterpreterResult success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public interpret_result(interpret_result other) {
      if (other.isSetSuccess()) {
        this.success = new RemoteInterpreterResult(other.success);
      }
    }

    public interpret_result deepCopy() {
      return new interpret_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public RemoteInterpreterResult getSuccess() {
      return this.success;
    }

    public interpret_result setSuccess(RemoteInterpreterResult success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((RemoteInterpreterResult)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof interpret_result)
        return this.equals((interpret_result)that);
      return false;
    }

    public boolean equals(interpret_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(interpret_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("interpret_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class interpret_resultStandardSchemeFactory implements SchemeFactory {
      public interpret_resultStandardScheme getScheme() {
        return new interpret_resultStandardScheme();
      }
    }

    private static class interpret_resultStandardScheme extends StandardScheme<interpret_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, interpret_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new RemoteInterpreterResult();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, interpret_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class interpret_resultTupleSchemeFactory implements SchemeFactory {
      public interpret_resultTupleScheme getScheme() {
        return new interpret_resultTupleScheme();
      }
    }

    private static class interpret_resultTupleScheme extends TupleScheme<interpret_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, interpret_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, interpret_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new RemoteInterpreterResult();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class cancel_args implements org.apache.thrift.TBase<cancel_args, cancel_args._Fields>, java.io.Serializable, Cloneable, Comparable<cancel_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cancel_args");

    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField CLASS_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("className", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField INTERPRETER_CONTEXT_FIELD_DESC = new org.apache.thrift.protocol.TField("interpreterContext", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new cancel_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new cancel_argsTupleSchemeFactory());
    }

    public String noteId; // required
    public String className; // required
    public RemoteInterpreterContext interpreterContext; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NOTE_ID((short)1, "noteId"),
      CLASS_NAME((short)2, "className"),
      INTERPRETER_CONTEXT((short)3, "interpreterContext");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NOTE_ID
            return NOTE_ID;
          case 2: // CLASS_NAME
            return CLASS_NAME;
          case 3: // INTERPRETER_CONTEXT
            return INTERPRETER_CONTEXT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.CLASS_NAME, new org.apache.thrift.meta_data.FieldMetaData("className", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.INTERPRETER_CONTEXT, new org.apache.thrift.meta_data.FieldMetaData("interpreterContext", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, RemoteInterpreterContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cancel_args.class, metaDataMap);
    }

    public cancel_args() {
    }

    public cancel_args(
      String noteId,
      String className,
      RemoteInterpreterContext interpreterContext)
    {
      this();
      this.noteId = noteId;
      this.className = className;
      this.interpreterContext = interpreterContext;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public cancel_args(cancel_args other) {
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetClassName()) {
        this.className = other.className;
      }
      if (other.isSetInterpreterContext()) {
        this.interpreterContext = new RemoteInterpreterContext(other.interpreterContext);
      }
    }

    public cancel_args deepCopy() {
      return new cancel_args(this);
    }

    @Override
    public void clear() {
      this.noteId = null;
      this.className = null;
      this.interpreterContext = null;
    }

    public String getNoteId() {
      return this.noteId;
    }

    public cancel_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getClassName() {
      return this.className;
    }

    public cancel_args setClassName(String className) {
      this.className = className;
      return this;
    }

    public void unsetClassName() {
      this.className = null;
    }

    /** Returns true if field className is set (has been assigned a value) and false otherwise */
    public boolean isSetClassName() {
      return this.className != null;
    }

    public void setClassNameIsSet(boolean value) {
      if (!value) {
        this.className = null;
      }
    }

    public RemoteInterpreterContext getInterpreterContext() {
      return this.interpreterContext;
    }

    public cancel_args setInterpreterContext(RemoteInterpreterContext interpreterContext) {
      this.interpreterContext = interpreterContext;
      return this;
    }

    public void unsetInterpreterContext() {
      this.interpreterContext = null;
    }

    /** Returns true if field interpreterContext is set (has been assigned a value) and false otherwise */
    public boolean isSetInterpreterContext() {
      return this.interpreterContext != null;
    }

    public void setInterpreterContextIsSet(boolean value) {
      if (!value) {
        this.interpreterContext = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case CLASS_NAME:
        if (value == null) {
          unsetClassName();
        } else {
          setClassName((String)value);
        }
        break;

      case INTERPRETER_CONTEXT:
        if (value == null) {
          unsetInterpreterContext();
        } else {
          setInterpreterContext((RemoteInterpreterContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NOTE_ID:
        return getNoteId();

      case CLASS_NAME:
        return getClassName();

      case INTERPRETER_CONTEXT:
        return getInterpreterContext();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NOTE_ID:
        return isSetNoteId();
      case CLASS_NAME:
        return isSetClassName();
      case INTERPRETER_CONTEXT:
        return isSetInterpreterContext();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof cancel_args)
        return this.equals((cancel_args)that);
      return false;
    }

    public boolean equals(cancel_args that) {
      if (that == null)
        return false;

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_className = true && this.isSetClassName();
      boolean that_present_className = true && that.isSetClassName();
      if (this_present_className || that_present_className) {
        if (!(this_present_className && that_present_className))
          return false;
        if (!this.className.equals(that.className))
          return false;
      }

      boolean this_present_interpreterContext = true && this.isSetInterpreterContext();
      boolean that_present_interpreterContext = true && that.isSetInterpreterContext();
      if (this_present_interpreterContext || that_present_interpreterContext) {
        if (!(this_present_interpreterContext && that_present_interpreterContext))
          return false;
        if (!this.interpreterContext.equals(that.interpreterContext))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_className = true && (isSetClassName());
      list.add(present_className);
      if (present_className)
        list.add(className);

      boolean present_interpreterContext = true && (isSetInterpreterContext());
      list.add(present_interpreterContext);
      if (present_interpreterContext)
        list.add(interpreterContext);

      return list.hashCode();
    }

    @Override
    public int compareTo(cancel_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetClassName()).compareTo(other.isSetClassName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClassName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.className, other.className);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetInterpreterContext()).compareTo(other.isSetInterpreterContext());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetInterpreterContext()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.interpreterContext, other.interpreterContext);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("cancel_args(");
      boolean first = true;

      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("className:");
      if (this.className == null) {
        sb.append("null");
      } else {
        sb.append(this.className);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("interpreterContext:");
      if (this.interpreterContext == null) {
        sb.append("null");
      } else {
        sb.append(this.interpreterContext);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (interpreterContext != null) {
        interpreterContext.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class cancel_argsStandardSchemeFactory implements SchemeFactory {
      public cancel_argsStandardScheme getScheme() {
        return new cancel_argsStandardScheme();
      }
    }

    private static class cancel_argsStandardScheme extends StandardScheme<cancel_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, cancel_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CLASS_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.className = iprot.readString();
                struct.setClassNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // INTERPRETER_CONTEXT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.interpreterContext = new RemoteInterpreterContext();
                struct.interpreterContext.read(iprot);
                struct.setInterpreterContextIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, cancel_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.className != null) {
          oprot.writeFieldBegin(CLASS_NAME_FIELD_DESC);
          oprot.writeString(struct.className);
          oprot.writeFieldEnd();
        }
        if (struct.interpreterContext != null) {
          oprot.writeFieldBegin(INTERPRETER_CONTEXT_FIELD_DESC);
          struct.interpreterContext.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class cancel_argsTupleSchemeFactory implements SchemeFactory {
      public cancel_argsTupleScheme getScheme() {
        return new cancel_argsTupleScheme();
      }
    }

    private static class cancel_argsTupleScheme extends TupleScheme<cancel_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, cancel_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetNoteId()) {
          optionals.set(0);
        }
        if (struct.isSetClassName()) {
          optionals.set(1);
        }
        if (struct.isSetInterpreterContext()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetClassName()) {
          oprot.writeString(struct.className);
        }
        if (struct.isSetInterpreterContext()) {
          struct.interpreterContext.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, cancel_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.className = iprot.readString();
          struct.setClassNameIsSet(true);
        }
        if (incoming.get(2)) {
          struct.interpreterContext = new RemoteInterpreterContext();
          struct.interpreterContext.read(iprot);
          struct.setInterpreterContextIsSet(true);
        }
      }
    }

  }

  public static class cancel_result implements org.apache.thrift.TBase<cancel_result, cancel_result._Fields>, java.io.Serializable, Cloneable, Comparable<cancel_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cancel_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new cancel_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new cancel_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cancel_result.class, metaDataMap);
    }

    public cancel_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public cancel_result(cancel_result other) {
    }

    public cancel_result deepCopy() {
      return new cancel_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof cancel_result)
        return this.equals((cancel_result)that);
      return false;
    }

    public boolean equals(cancel_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(cancel_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("cancel_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class cancel_resultStandardSchemeFactory implements SchemeFactory {
      public cancel_resultStandardScheme getScheme() {
        return new cancel_resultStandardScheme();
      }
    }

    private static class cancel_resultStandardScheme extends StandardScheme<cancel_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, cancel_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, cancel_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class cancel_resultTupleSchemeFactory implements SchemeFactory {
      public cancel_resultTupleScheme getScheme() {
        return new cancel_resultTupleScheme();
      }
    }

    private static class cancel_resultTupleScheme extends TupleScheme<cancel_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, cancel_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, cancel_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class getProgress_args implements org.apache.thrift.TBase<getProgress_args, getProgress_args._Fields>, java.io.Serializable, Cloneable, Comparable<getProgress_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getProgress_args");

    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField CLASS_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("className", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField INTERPRETER_CONTEXT_FIELD_DESC = new org.apache.thrift.protocol.TField("interpreterContext", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getProgress_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getProgress_argsTupleSchemeFactory());
    }

    public String noteId; // required
    public String className; // required
    public RemoteInterpreterContext interpreterContext; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NOTE_ID((short)1, "noteId"),
      CLASS_NAME((short)2, "className"),
      INTERPRETER_CONTEXT((short)3, "interpreterContext");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NOTE_ID
            return NOTE_ID;
          case 2: // CLASS_NAME
            return CLASS_NAME;
          case 3: // INTERPRETER_CONTEXT
            return INTERPRETER_CONTEXT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.CLASS_NAME, new org.apache.thrift.meta_data.FieldMetaData("className", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.INTERPRETER_CONTEXT, new org.apache.thrift.meta_data.FieldMetaData("interpreterContext", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, RemoteInterpreterContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getProgress_args.class, metaDataMap);
    }

    public getProgress_args() {
    }

    public getProgress_args(
      String noteId,
      String className,
      RemoteInterpreterContext interpreterContext)
    {
      this();
      this.noteId = noteId;
      this.className = className;
      this.interpreterContext = interpreterContext;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getProgress_args(getProgress_args other) {
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetClassName()) {
        this.className = other.className;
      }
      if (other.isSetInterpreterContext()) {
        this.interpreterContext = new RemoteInterpreterContext(other.interpreterContext);
      }
    }

    public getProgress_args deepCopy() {
      return new getProgress_args(this);
    }

    @Override
    public void clear() {
      this.noteId = null;
      this.className = null;
      this.interpreterContext = null;
    }

    public String getNoteId() {
      return this.noteId;
    }

    public getProgress_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getClassName() {
      return this.className;
    }

    public getProgress_args setClassName(String className) {
      this.className = className;
      return this;
    }

    public void unsetClassName() {
      this.className = null;
    }

    /** Returns true if field className is set (has been assigned a value) and false otherwise */
    public boolean isSetClassName() {
      return this.className != null;
    }

    public void setClassNameIsSet(boolean value) {
      if (!value) {
        this.className = null;
      }
    }

    public RemoteInterpreterContext getInterpreterContext() {
      return this.interpreterContext;
    }

    public getProgress_args setInterpreterContext(RemoteInterpreterContext interpreterContext) {
      this.interpreterContext = interpreterContext;
      return this;
    }

    public void unsetInterpreterContext() {
      this.interpreterContext = null;
    }

    /** Returns true if field interpreterContext is set (has been assigned a value) and false otherwise */
    public boolean isSetInterpreterContext() {
      return this.interpreterContext != null;
    }

    public void setInterpreterContextIsSet(boolean value) {
      if (!value) {
        this.interpreterContext = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case CLASS_NAME:
        if (value == null) {
          unsetClassName();
        } else {
          setClassName((String)value);
        }
        break;

      case INTERPRETER_CONTEXT:
        if (value == null) {
          unsetInterpreterContext();
        } else {
          setInterpreterContext((RemoteInterpreterContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NOTE_ID:
        return getNoteId();

      case CLASS_NAME:
        return getClassName();

      case INTERPRETER_CONTEXT:
        return getInterpreterContext();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NOTE_ID:
        return isSetNoteId();
      case CLASS_NAME:
        return isSetClassName();
      case INTERPRETER_CONTEXT:
        return isSetInterpreterContext();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getProgress_args)
        return this.equals((getProgress_args)that);
      return false;
    }

    public boolean equals(getProgress_args that) {
      if (that == null)
        return false;

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_className = true && this.isSetClassName();
      boolean that_present_className = true && that.isSetClassName();
      if (this_present_className || that_present_className) {
        if (!(this_present_className && that_present_className))
          return false;
        if (!this.className.equals(that.className))
          return false;
      }

      boolean this_present_interpreterContext = true && this.isSetInterpreterContext();
      boolean that_present_interpreterContext = true && that.isSetInterpreterContext();
      if (this_present_interpreterContext || that_present_interpreterContext) {
        if (!(this_present_interpreterContext && that_present_interpreterContext))
          return false;
        if (!this.interpreterContext.equals(that.interpreterContext))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_className = true && (isSetClassName());
      list.add(present_className);
      if (present_className)
        list.add(className);

      boolean present_interpreterContext = true && (isSetInterpreterContext());
      list.add(present_interpreterContext);
      if (present_interpreterContext)
        list.add(interpreterContext);

      return list.hashCode();
    }

    @Override
    public int compareTo(getProgress_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetClassName()).compareTo(other.isSetClassName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClassName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.className, other.className);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetInterpreterContext()).compareTo(other.isSetInterpreterContext());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetInterpreterContext()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.interpreterContext, other.interpreterContext);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getProgress_args(");
      boolean first = true;

      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("className:");
      if (this.className == null) {
        sb.append("null");
      } else {
        sb.append(this.className);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("interpreterContext:");
      if (this.interpreterContext == null) {
        sb.append("null");
      } else {
        sb.append(this.interpreterContext);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (interpreterContext != null) {
        interpreterContext.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getProgress_argsStandardSchemeFactory implements SchemeFactory {
      public getProgress_argsStandardScheme getScheme() {
        return new getProgress_argsStandardScheme();
      }
    }

    private static class getProgress_argsStandardScheme extends StandardScheme<getProgress_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getProgress_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CLASS_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.className = iprot.readString();
                struct.setClassNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // INTERPRETER_CONTEXT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.interpreterContext = new RemoteInterpreterContext();
                struct.interpreterContext.read(iprot);
                struct.setInterpreterContextIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getProgress_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.className != null) {
          oprot.writeFieldBegin(CLASS_NAME_FIELD_DESC);
          oprot.writeString(struct.className);
          oprot.writeFieldEnd();
        }
        if (struct.interpreterContext != null) {
          oprot.writeFieldBegin(INTERPRETER_CONTEXT_FIELD_DESC);
          struct.interpreterContext.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getProgress_argsTupleSchemeFactory implements SchemeFactory {
      public getProgress_argsTupleScheme getScheme() {
        return new getProgress_argsTupleScheme();
      }
    }

    private static class getProgress_argsTupleScheme extends TupleScheme<getProgress_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getProgress_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetNoteId()) {
          optionals.set(0);
        }
        if (struct.isSetClassName()) {
          optionals.set(1);
        }
        if (struct.isSetInterpreterContext()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetClassName()) {
          oprot.writeString(struct.className);
        }
        if (struct.isSetInterpreterContext()) {
          struct.interpreterContext.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getProgress_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.className = iprot.readString();
          struct.setClassNameIsSet(true);
        }
        if (incoming.get(2)) {
          struct.interpreterContext = new RemoteInterpreterContext();
          struct.interpreterContext.read(iprot);
          struct.setInterpreterContextIsSet(true);
        }
      }
    }

  }

  public static class getProgress_result implements org.apache.thrift.TBase<getProgress_result, getProgress_result._Fields>, java.io.Serializable, Cloneable, Comparable<getProgress_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getProgress_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I32, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getProgress_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getProgress_resultTupleSchemeFactory());
    }

    public int success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getProgress_result.class, metaDataMap);
    }

    public getProgress_result() {
    }

    public getProgress_result(
      int success)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getProgress_result(getProgress_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
    }

    public getProgress_result deepCopy() {
      return new getProgress_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
    }

    public int getSuccess() {
      return this.success;
    }

    public getProgress_result setSuccess(int success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Integer.valueOf(getSuccess());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getProgress_result)
        return this.equals((getProgress_result)that);
      return false;
    }

    public boolean equals(getProgress_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(getProgress_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getProgress_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getProgress_resultStandardSchemeFactory implements SchemeFactory {
      public getProgress_resultStandardScheme getScheme() {
        return new getProgress_resultStandardScheme();
      }
    }

    private static class getProgress_resultStandardScheme extends StandardScheme<getProgress_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getProgress_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.success = iprot.readI32();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getProgress_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI32(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getProgress_resultTupleSchemeFactory implements SchemeFactory {
      public getProgress_resultTupleScheme getScheme() {
        return new getProgress_resultTupleScheme();
      }
    }

    private static class getProgress_resultTupleScheme extends TupleScheme<getProgress_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getProgress_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeI32(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getProgress_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readI32();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getFormType_args implements org.apache.thrift.TBase<getFormType_args, getFormType_args._Fields>, java.io.Serializable, Cloneable, Comparable<getFormType_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getFormType_args");

    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField CLASS_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("className", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getFormType_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getFormType_argsTupleSchemeFactory());
    }

    public String noteId; // required
    public String className; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NOTE_ID((short)1, "noteId"),
      CLASS_NAME((short)2, "className");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NOTE_ID
            return NOTE_ID;
          case 2: // CLASS_NAME
            return CLASS_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.CLASS_NAME, new org.apache.thrift.meta_data.FieldMetaData("className", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getFormType_args.class, metaDataMap);
    }

    public getFormType_args() {
    }

    public getFormType_args(
      String noteId,
      String className)
    {
      this();
      this.noteId = noteId;
      this.className = className;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getFormType_args(getFormType_args other) {
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetClassName()) {
        this.className = other.className;
      }
    }

    public getFormType_args deepCopy() {
      return new getFormType_args(this);
    }

    @Override
    public void clear() {
      this.noteId = null;
      this.className = null;
    }

    public String getNoteId() {
      return this.noteId;
    }

    public getFormType_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getClassName() {
      return this.className;
    }

    public getFormType_args setClassName(String className) {
      this.className = className;
      return this;
    }

    public void unsetClassName() {
      this.className = null;
    }

    /** Returns true if field className is set (has been assigned a value) and false otherwise */
    public boolean isSetClassName() {
      return this.className != null;
    }

    public void setClassNameIsSet(boolean value) {
      if (!value) {
        this.className = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case CLASS_NAME:
        if (value == null) {
          unsetClassName();
        } else {
          setClassName((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NOTE_ID:
        return getNoteId();

      case CLASS_NAME:
        return getClassName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NOTE_ID:
        return isSetNoteId();
      case CLASS_NAME:
        return isSetClassName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getFormType_args)
        return this.equals((getFormType_args)that);
      return false;
    }

    public boolean equals(getFormType_args that) {
      if (that == null)
        return false;

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_className = true && this.isSetClassName();
      boolean that_present_className = true && that.isSetClassName();
      if (this_present_className || that_present_className) {
        if (!(this_present_className && that_present_className))
          return false;
        if (!this.className.equals(that.className))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_className = true && (isSetClassName());
      list.add(present_className);
      if (present_className)
        list.add(className);

      return list.hashCode();
    }

    @Override
    public int compareTo(getFormType_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetClassName()).compareTo(other.isSetClassName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClassName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.className, other.className);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getFormType_args(");
      boolean first = true;

      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("className:");
      if (this.className == null) {
        sb.append("null");
      } else {
        sb.append(this.className);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getFormType_argsStandardSchemeFactory implements SchemeFactory {
      public getFormType_argsStandardScheme getScheme() {
        return new getFormType_argsStandardScheme();
      }
    }

    private static class getFormType_argsStandardScheme extends StandardScheme<getFormType_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getFormType_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CLASS_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.className = iprot.readString();
                struct.setClassNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getFormType_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.className != null) {
          oprot.writeFieldBegin(CLASS_NAME_FIELD_DESC);
          oprot.writeString(struct.className);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getFormType_argsTupleSchemeFactory implements SchemeFactory {
      public getFormType_argsTupleScheme getScheme() {
        return new getFormType_argsTupleScheme();
      }
    }

    private static class getFormType_argsTupleScheme extends TupleScheme<getFormType_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getFormType_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetNoteId()) {
          optionals.set(0);
        }
        if (struct.isSetClassName()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetClassName()) {
          oprot.writeString(struct.className);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getFormType_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.className = iprot.readString();
          struct.setClassNameIsSet(true);
        }
      }
    }

  }

  public static class getFormType_result implements org.apache.thrift.TBase<getFormType_result, getFormType_result._Fields>, java.io.Serializable, Cloneable, Comparable<getFormType_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getFormType_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getFormType_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getFormType_resultTupleSchemeFactory());
    }

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getFormType_result.class, metaDataMap);
    }

    public getFormType_result() {
    }

    public getFormType_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getFormType_result(getFormType_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public getFormType_result deepCopy() {
      return new getFormType_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public getFormType_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getFormType_result)
        return this.equals((getFormType_result)that);
      return false;
    }

    public boolean equals(getFormType_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(getFormType_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getFormType_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getFormType_resultStandardSchemeFactory implements SchemeFactory {
      public getFormType_resultStandardScheme getScheme() {
        return new getFormType_resultStandardScheme();
      }
    }

    private static class getFormType_resultStandardScheme extends StandardScheme<getFormType_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getFormType_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getFormType_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getFormType_resultTupleSchemeFactory implements SchemeFactory {
      public getFormType_resultTupleScheme getScheme() {
        return new getFormType_resultTupleScheme();
      }
    }

    private static class getFormType_resultTupleScheme extends TupleScheme<getFormType_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getFormType_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getFormType_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class completion_args implements org.apache.thrift.TBase<completion_args, completion_args._Fields>, java.io.Serializable, Cloneable, Comparable<completion_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("completion_args");

    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField CLASS_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("className", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField BUF_FIELD_DESC = new org.apache.thrift.protocol.TField("buf", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField CURSOR_FIELD_DESC = new org.apache.thrift.protocol.TField("cursor", org.apache.thrift.protocol.TType.I32, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new completion_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new completion_argsTupleSchemeFactory());
    }

    public String noteId; // required
    public String className; // required
    public String buf; // required
    public int cursor; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NOTE_ID((short)1, "noteId"),
      CLASS_NAME((short)2, "className"),
      BUF((short)3, "buf"),
      CURSOR((short)4, "cursor");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NOTE_ID
            return NOTE_ID;
          case 2: // CLASS_NAME
            return CLASS_NAME;
          case 3: // BUF
            return BUF;
          case 4: // CURSOR
            return CURSOR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __CURSOR_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.CLASS_NAME, new org.apache.thrift.meta_data.FieldMetaData("className", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.BUF, new org.apache.thrift.meta_data.FieldMetaData("buf", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.CURSOR, new org.apache.thrift.meta_data.FieldMetaData("cursor", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(completion_args.class, metaDataMap);
    }

    public completion_args() {
    }

    public completion_args(
      String noteId,
      String className,
      String buf,
      int cursor)
    {
      this();
      this.noteId = noteId;
      this.className = className;
      this.buf = buf;
      this.cursor = cursor;
      setCursorIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public completion_args(completion_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetClassName()) {
        this.className = other.className;
      }
      if (other.isSetBuf()) {
        this.buf = other.buf;
      }
      this.cursor = other.cursor;
    }

    public completion_args deepCopy() {
      return new completion_args(this);
    }

    @Override
    public void clear() {
      this.noteId = null;
      this.className = null;
      this.buf = null;
      setCursorIsSet(false);
      this.cursor = 0;
    }

    public String getNoteId() {
      return this.noteId;
    }

    public completion_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getClassName() {
      return this.className;
    }

    public completion_args setClassName(String className) {
      this.className = className;
      return this;
    }

    public void unsetClassName() {
      this.className = null;
    }

    /** Returns true if field className is set (has been assigned a value) and false otherwise */
    public boolean isSetClassName() {
      return this.className != null;
    }

    public void setClassNameIsSet(boolean value) {
      if (!value) {
        this.className = null;
      }
    }

    public String getBuf() {
      return this.buf;
    }

    public completion_args setBuf(String buf) {
      this.buf = buf;
      return this;
    }

    public void unsetBuf() {
      this.buf = null;
    }

    /** Returns true if field buf is set (has been assigned a value) and false otherwise */
    public boolean isSetBuf() {
      return this.buf != null;
    }

    public void setBufIsSet(boolean value) {
      if (!value) {
        this.buf = null;
      }
    }

    public int getCursor() {
      return this.cursor;
    }

    public completion_args setCursor(int cursor) {
      this.cursor = cursor;
      setCursorIsSet(true);
      return this;
    }

    public void unsetCursor() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __CURSOR_ISSET_ID);
    }

    /** Returns true if field cursor is set (has been assigned a value) and false otherwise */
    public boolean isSetCursor() {
      return EncodingUtils.testBit(__isset_bitfield, __CURSOR_ISSET_ID);
    }

    public void setCursorIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __CURSOR_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case CLASS_NAME:
        if (value == null) {
          unsetClassName();
        } else {
          setClassName((String)value);
        }
        break;

      case BUF:
        if (value == null) {
          unsetBuf();
        } else {
          setBuf((String)value);
        }
        break;

      case CURSOR:
        if (value == null) {
          unsetCursor();
        } else {
          setCursor((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NOTE_ID:
        return getNoteId();

      case CLASS_NAME:
        return getClassName();

      case BUF:
        return getBuf();

      case CURSOR:
        return Integer.valueOf(getCursor());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NOTE_ID:
        return isSetNoteId();
      case CLASS_NAME:
        return isSetClassName();
      case BUF:
        return isSetBuf();
      case CURSOR:
        return isSetCursor();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof completion_args)
        return this.equals((completion_args)that);
      return false;
    }

    public boolean equals(completion_args that) {
      if (that == null)
        return false;

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_className = true && this.isSetClassName();
      boolean that_present_className = true && that.isSetClassName();
      if (this_present_className || that_present_className) {
        if (!(this_present_className && that_present_className))
          return false;
        if (!this.className.equals(that.className))
          return false;
      }

      boolean this_present_buf = true && this.isSetBuf();
      boolean that_present_buf = true && that.isSetBuf();
      if (this_present_buf || that_present_buf) {
        if (!(this_present_buf && that_present_buf))
          return false;
        if (!this.buf.equals(that.buf))
          return false;
      }

      boolean this_present_cursor = true;
      boolean that_present_cursor = true;
      if (this_present_cursor || that_present_cursor) {
        if (!(this_present_cursor && that_present_cursor))
          return false;
        if (this.cursor != that.cursor)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_className = true && (isSetClassName());
      list.add(present_className);
      if (present_className)
        list.add(className);

      boolean present_buf = true && (isSetBuf());
      list.add(present_buf);
      if (present_buf)
        list.add(buf);

      boolean present_cursor = true;
      list.add(present_cursor);
      if (present_cursor)
        list.add(cursor);

      return list.hashCode();
    }

    @Override
    public int compareTo(completion_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetClassName()).compareTo(other.isSetClassName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClassName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.className, other.className);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetBuf()).compareTo(other.isSetBuf());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBuf()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.buf, other.buf);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCursor()).compareTo(other.isSetCursor());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCursor()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.cursor, other.cursor);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("completion_args(");
      boolean first = true;

      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("className:");
      if (this.className == null) {
        sb.append("null");
      } else {
        sb.append(this.className);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("buf:");
      if (this.buf == null) {
        sb.append("null");
      } else {
        sb.append(this.buf);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("cursor:");
      sb.append(this.cursor);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class completion_argsStandardSchemeFactory implements SchemeFactory {
      public completion_argsStandardScheme getScheme() {
        return new completion_argsStandardScheme();
      }
    }

    private static class completion_argsStandardScheme extends StandardScheme<completion_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, completion_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CLASS_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.className = iprot.readString();
                struct.setClassNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // BUF
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.buf = iprot.readString();
                struct.setBufIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // CURSOR
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.cursor = iprot.readI32();
                struct.setCursorIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, completion_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.className != null) {
          oprot.writeFieldBegin(CLASS_NAME_FIELD_DESC);
          oprot.writeString(struct.className);
          oprot.writeFieldEnd();
        }
        if (struct.buf != null) {
          oprot.writeFieldBegin(BUF_FIELD_DESC);
          oprot.writeString(struct.buf);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(CURSOR_FIELD_DESC);
        oprot.writeI32(struct.cursor);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class completion_argsTupleSchemeFactory implements SchemeFactory {
      public completion_argsTupleScheme getScheme() {
        return new completion_argsTupleScheme();
      }
    }

    private static class completion_argsTupleScheme extends TupleScheme<completion_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, completion_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetNoteId()) {
          optionals.set(0);
        }
        if (struct.isSetClassName()) {
          optionals.set(1);
        }
        if (struct.isSetBuf()) {
          optionals.set(2);
        }
        if (struct.isSetCursor()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetClassName()) {
          oprot.writeString(struct.className);
        }
        if (struct.isSetBuf()) {
          oprot.writeString(struct.buf);
        }
        if (struct.isSetCursor()) {
          oprot.writeI32(struct.cursor);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, completion_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.className = iprot.readString();
          struct.setClassNameIsSet(true);
        }
        if (incoming.get(2)) {
          struct.buf = iprot.readString();
          struct.setBufIsSet(true);
        }
        if (incoming.get(3)) {
          struct.cursor = iprot.readI32();
          struct.setCursorIsSet(true);
        }
      }
    }

  }

  public static class completion_result implements org.apache.thrift.TBase<completion_result, completion_result._Fields>, java.io.Serializable, Cloneable, Comparable<completion_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("completion_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new completion_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new completion_resultTupleSchemeFactory());
    }

    public List<InterpreterCompletion> success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, InterpreterCompletion.class))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(completion_result.class, metaDataMap);
    }

    public completion_result() {
    }

    public completion_result(
      List<InterpreterCompletion> success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public completion_result(completion_result other) {
      if (other.isSetSuccess()) {
        List<InterpreterCompletion> __this__success = new ArrayList<InterpreterCompletion>(other.success.size());
        for (InterpreterCompletion other_element : other.success) {
          __this__success.add(new InterpreterCompletion(other_element));
        }
        this.success = __this__success;
      }
    }

    public completion_result deepCopy() {
      return new completion_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<InterpreterCompletion> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(InterpreterCompletion elem) {
      if (this.success == null) {
        this.success = new ArrayList<InterpreterCompletion>();
      }
      this.success.add(elem);
    }

    public List<InterpreterCompletion> getSuccess() {
      return this.success;
    }

    public completion_result setSuccess(List<InterpreterCompletion> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<InterpreterCompletion>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof completion_result)
        return this.equals((completion_result)that);
      return false;
    }

    public boolean equals(completion_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(completion_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("completion_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class completion_resultStandardSchemeFactory implements SchemeFactory {
      public completion_resultStandardScheme getScheme() {
        return new completion_resultStandardScheme();
      }
    }

    private static class completion_resultStandardScheme extends StandardScheme<completion_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, completion_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list10 = iprot.readListBegin();
                  struct.success = new ArrayList<InterpreterCompletion>(_list10.size);
                  InterpreterCompletion _elem11;
                  for (int _i12 = 0; _i12 < _list10.size; ++_i12)
                  {
                    _elem11 = new InterpreterCompletion();
                    _elem11.read(iprot);
                    struct.success.add(_elem11);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, completion_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (InterpreterCompletion _iter13 : struct.success)
            {
              _iter13.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class completion_resultTupleSchemeFactory implements SchemeFactory {
      public completion_resultTupleScheme getScheme() {
        return new completion_resultTupleScheme();
      }
    }

    private static class completion_resultTupleScheme extends TupleScheme<completion_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, completion_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (InterpreterCompletion _iter14 : struct.success)
            {
              _iter14.write(oprot);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, completion_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list15 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<InterpreterCompletion>(_list15.size);
            InterpreterCompletion _elem16;
            for (int _i17 = 0; _i17 < _list15.size; ++_i17)
            {
              _elem16 = new InterpreterCompletion();
              _elem16.read(iprot);
              struct.success.add(_elem16);
            }
          }
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class shutdown_args implements org.apache.thrift.TBase<shutdown_args, shutdown_args._Fields>, java.io.Serializable, Cloneable, Comparable<shutdown_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("shutdown_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new shutdown_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new shutdown_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(shutdown_args.class, metaDataMap);
    }

    public shutdown_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public shutdown_args(shutdown_args other) {
    }

    public shutdown_args deepCopy() {
      return new shutdown_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof shutdown_args)
        return this.equals((shutdown_args)that);
      return false;
    }

    public boolean equals(shutdown_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(shutdown_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("shutdown_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class shutdown_argsStandardSchemeFactory implements SchemeFactory {
      public shutdown_argsStandardScheme getScheme() {
        return new shutdown_argsStandardScheme();
      }
    }

    private static class shutdown_argsStandardScheme extends StandardScheme<shutdown_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, shutdown_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, shutdown_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class shutdown_argsTupleSchemeFactory implements SchemeFactory {
      public shutdown_argsTupleScheme getScheme() {
        return new shutdown_argsTupleScheme();
      }
    }

    private static class shutdown_argsTupleScheme extends TupleScheme<shutdown_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, shutdown_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, shutdown_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class shutdown_result implements org.apache.thrift.TBase<shutdown_result, shutdown_result._Fields>, java.io.Serializable, Cloneable, Comparable<shutdown_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("shutdown_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new shutdown_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new shutdown_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(shutdown_result.class, metaDataMap);
    }

    public shutdown_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public shutdown_result(shutdown_result other) {
    }

    public shutdown_result deepCopy() {
      return new shutdown_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof shutdown_result)
        return this.equals((shutdown_result)that);
      return false;
    }

    public boolean equals(shutdown_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(shutdown_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("shutdown_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class shutdown_resultStandardSchemeFactory implements SchemeFactory {
      public shutdown_resultStandardScheme getScheme() {
        return new shutdown_resultStandardScheme();
      }
    }

    private static class shutdown_resultStandardScheme extends StandardScheme<shutdown_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, shutdown_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, shutdown_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class shutdown_resultTupleSchemeFactory implements SchemeFactory {
      public shutdown_resultTupleScheme getScheme() {
        return new shutdown_resultTupleScheme();
      }
    }

    private static class shutdown_resultTupleScheme extends TupleScheme<shutdown_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, shutdown_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, shutdown_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class getStatus_args implements org.apache.thrift.TBase<getStatus_args, getStatus_args._Fields>, java.io.Serializable, Cloneable, Comparable<getStatus_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getStatus_args");

    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField JOB_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("jobId", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getStatus_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getStatus_argsTupleSchemeFactory());
    }

    public String noteId; // required
    public String jobId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NOTE_ID((short)1, "noteId"),
      JOB_ID((short)2, "jobId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NOTE_ID
            return NOTE_ID;
          case 2: // JOB_ID
            return JOB_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.JOB_ID, new org.apache.thrift.meta_data.FieldMetaData("jobId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getStatus_args.class, metaDataMap);
    }

    public getStatus_args() {
    }

    public getStatus_args(
      String noteId,
      String jobId)
    {
      this();
      this.noteId = noteId;
      this.jobId = jobId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getStatus_args(getStatus_args other) {
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetJobId()) {
        this.jobId = other.jobId;
      }
    }

    public getStatus_args deepCopy() {
      return new getStatus_args(this);
    }

    @Override
    public void clear() {
      this.noteId = null;
      this.jobId = null;
    }

    public String getNoteId() {
      return this.noteId;
    }

    public getStatus_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getJobId() {
      return this.jobId;
    }

    public getStatus_args setJobId(String jobId) {
      this.jobId = jobId;
      return this;
    }

    public void unsetJobId() {
      this.jobId = null;
    }

    /** Returns true if field jobId is set (has been assigned a value) and false otherwise */
    public boolean isSetJobId() {
      return this.jobId != null;
    }

    public void setJobIdIsSet(boolean value) {
      if (!value) {
        this.jobId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case JOB_ID:
        if (value == null) {
          unsetJobId();
        } else {
          setJobId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NOTE_ID:
        return getNoteId();

      case JOB_ID:
        return getJobId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NOTE_ID:
        return isSetNoteId();
      case JOB_ID:
        return isSetJobId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getStatus_args)
        return this.equals((getStatus_args)that);
      return false;
    }

    public boolean equals(getStatus_args that) {
      if (that == null)
        return false;

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_jobId = true && this.isSetJobId();
      boolean that_present_jobId = true && that.isSetJobId();
      if (this_present_jobId || that_present_jobId) {
        if (!(this_present_jobId && that_present_jobId))
          return false;
        if (!this.jobId.equals(that.jobId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_jobId = true && (isSetJobId());
      list.add(present_jobId);
      if (present_jobId)
        list.add(jobId);

      return list.hashCode();
    }

    @Override
    public int compareTo(getStatus_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetJobId()).compareTo(other.isSetJobId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJobId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jobId, other.jobId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getStatus_args(");
      boolean first = true;

      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jobId:");
      if (this.jobId == null) {
        sb.append("null");
      } else {
        sb.append(this.jobId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getStatus_argsStandardSchemeFactory implements SchemeFactory {
      public getStatus_argsStandardScheme getScheme() {
        return new getStatus_argsStandardScheme();
      }
    }

    private static class getStatus_argsStandardScheme extends StandardScheme<getStatus_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getStatus_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // JOB_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.jobId = iprot.readString();
                struct.setJobIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getStatus_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.jobId != null) {
          oprot.writeFieldBegin(JOB_ID_FIELD_DESC);
          oprot.writeString(struct.jobId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getStatus_argsTupleSchemeFactory implements SchemeFactory {
      public getStatus_argsTupleScheme getScheme() {
        return new getStatus_argsTupleScheme();
      }
    }

    private static class getStatus_argsTupleScheme extends TupleScheme<getStatus_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getStatus_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetNoteId()) {
          optionals.set(0);
        }
        if (struct.isSetJobId()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetJobId()) {
          oprot.writeString(struct.jobId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getStatus_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.jobId = iprot.readString();
          struct.setJobIdIsSet(true);
        }
      }
    }

  }

  public static class getStatus_result implements org.apache.thrift.TBase<getStatus_result, getStatus_result._Fields>, java.io.Serializable, Cloneable, Comparable<getStatus_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getStatus_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getStatus_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getStatus_resultTupleSchemeFactory());
    }

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getStatus_result.class, metaDataMap);
    }

    public getStatus_result() {
    }

    public getStatus_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getStatus_result(getStatus_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public getStatus_result deepCopy() {
      return new getStatus_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public getStatus_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getStatus_result)
        return this.equals((getStatus_result)that);
      return false;
    }

    public boolean equals(getStatus_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(getStatus_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getStatus_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getStatus_resultStandardSchemeFactory implements SchemeFactory {
      public getStatus_resultStandardScheme getScheme() {
        return new getStatus_resultStandardScheme();
      }
    }

    private static class getStatus_resultStandardScheme extends StandardScheme<getStatus_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getStatus_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getStatus_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getStatus_resultTupleSchemeFactory implements SchemeFactory {
      public getStatus_resultTupleScheme getScheme() {
        return new getStatus_resultTupleScheme();
      }
    }

    private static class getStatus_resultTupleScheme extends TupleScheme<getStatus_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getStatus_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getStatus_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getEvent_args implements org.apache.thrift.TBase<getEvent_args, getEvent_args._Fields>, java.io.Serializable, Cloneable, Comparable<getEvent_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getEvent_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getEvent_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getEvent_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getEvent_args.class, metaDataMap);
    }

    public getEvent_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getEvent_args(getEvent_args other) {
    }

    public getEvent_args deepCopy() {
      return new getEvent_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getEvent_args)
        return this.equals((getEvent_args)that);
      return false;
    }

    public boolean equals(getEvent_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(getEvent_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getEvent_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getEvent_argsStandardSchemeFactory implements SchemeFactory {
      public getEvent_argsStandardScheme getScheme() {
        return new getEvent_argsStandardScheme();
      }
    }

    private static class getEvent_argsStandardScheme extends StandardScheme<getEvent_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getEvent_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getEvent_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getEvent_argsTupleSchemeFactory implements SchemeFactory {
      public getEvent_argsTupleScheme getScheme() {
        return new getEvent_argsTupleScheme();
      }
    }

    private static class getEvent_argsTupleScheme extends TupleScheme<getEvent_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getEvent_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getEvent_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class getEvent_result implements org.apache.thrift.TBase<getEvent_result, getEvent_result._Fields>, java.io.Serializable, Cloneable, Comparable<getEvent_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getEvent_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getEvent_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getEvent_resultTupleSchemeFactory());
    }

    public RemoteInterpreterEvent success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, RemoteInterpreterEvent.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getEvent_result.class, metaDataMap);
    }

    public getEvent_result() {
    }

    public getEvent_result(
      RemoteInterpreterEvent success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getEvent_result(getEvent_result other) {
      if (other.isSetSuccess()) {
        this.success = new RemoteInterpreterEvent(other.success);
      }
    }

    public getEvent_result deepCopy() {
      return new getEvent_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public RemoteInterpreterEvent getSuccess() {
      return this.success;
    }

    public getEvent_result setSuccess(RemoteInterpreterEvent success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((RemoteInterpreterEvent)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getEvent_result)
        return this.equals((getEvent_result)that);
      return false;
    }

    public boolean equals(getEvent_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(getEvent_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getEvent_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getEvent_resultStandardSchemeFactory implements SchemeFactory {
      public getEvent_resultStandardScheme getScheme() {
        return new getEvent_resultStandardScheme();
      }
    }

    private static class getEvent_resultStandardScheme extends StandardScheme<getEvent_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getEvent_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new RemoteInterpreterEvent();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getEvent_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getEvent_resultTupleSchemeFactory implements SchemeFactory {
      public getEvent_resultTupleScheme getScheme() {
        return new getEvent_resultTupleScheme();
      }
    }

    private static class getEvent_resultTupleScheme extends TupleScheme<getEvent_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getEvent_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getEvent_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new RemoteInterpreterEvent();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class resourcePoolResponseGetAll_args implements org.apache.thrift.TBase<resourcePoolResponseGetAll_args, resourcePoolResponseGetAll_args._Fields>, java.io.Serializable, Cloneable, Comparable<resourcePoolResponseGetAll_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resourcePoolResponseGetAll_args");

    private static final org.apache.thrift.protocol.TField RESOURCES_FIELD_DESC = new org.apache.thrift.protocol.TField("resources", org.apache.thrift.protocol.TType.LIST, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resourcePoolResponseGetAll_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resourcePoolResponseGetAll_argsTupleSchemeFactory());
    }

    public List<String> resources; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      RESOURCES((short)1, "resources");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // RESOURCES
            return RESOURCES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.RESOURCES, new org.apache.thrift.meta_data.FieldMetaData("resources", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resourcePoolResponseGetAll_args.class, metaDataMap);
    }

    public resourcePoolResponseGetAll_args() {
    }

    public resourcePoolResponseGetAll_args(
      List<String> resources)
    {
      this();
      this.resources = resources;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resourcePoolResponseGetAll_args(resourcePoolResponseGetAll_args other) {
      if (other.isSetResources()) {
        List<String> __this__resources = new ArrayList<String>(other.resources);
        this.resources = __this__resources;
      }
    }

    public resourcePoolResponseGetAll_args deepCopy() {
      return new resourcePoolResponseGetAll_args(this);
    }

    @Override
    public void clear() {
      this.resources = null;
    }

    public int getResourcesSize() {
      return (this.resources == null) ? 0 : this.resources.size();
    }

    public java.util.Iterator<String> getResourcesIterator() {
      return (this.resources == null) ? null : this.resources.iterator();
    }

    public void addToResources(String elem) {
      if (this.resources == null) {
        this.resources = new ArrayList<String>();
      }
      this.resources.add(elem);
    }

    public List<String> getResources() {
      return this.resources;
    }

    public resourcePoolResponseGetAll_args setResources(List<String> resources) {
      this.resources = resources;
      return this;
    }

    public void unsetResources() {
      this.resources = null;
    }

    /** Returns true if field resources is set (has been assigned a value) and false otherwise */
    public boolean isSetResources() {
      return this.resources != null;
    }

    public void setResourcesIsSet(boolean value) {
      if (!value) {
        this.resources = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case RESOURCES:
        if (value == null) {
          unsetResources();
        } else {
          setResources((List<String>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case RESOURCES:
        return getResources();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case RESOURCES:
        return isSetResources();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resourcePoolResponseGetAll_args)
        return this.equals((resourcePoolResponseGetAll_args)that);
      return false;
    }

    public boolean equals(resourcePoolResponseGetAll_args that) {
      if (that == null)
        return false;

      boolean this_present_resources = true && this.isSetResources();
      boolean that_present_resources = true && that.isSetResources();
      if (this_present_resources || that_present_resources) {
        if (!(this_present_resources && that_present_resources))
          return false;
        if (!this.resources.equals(that.resources))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_resources = true && (isSetResources());
      list.add(present_resources);
      if (present_resources)
        list.add(resources);

      return list.hashCode();
    }

    @Override
    public int compareTo(resourcePoolResponseGetAll_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetResources()).compareTo(other.isSetResources());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetResources()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.resources, other.resources);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resourcePoolResponseGetAll_args(");
      boolean first = true;

      sb.append("resources:");
      if (this.resources == null) {
        sb.append("null");
      } else {
        sb.append(this.resources);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resourcePoolResponseGetAll_argsStandardSchemeFactory implements SchemeFactory {
      public resourcePoolResponseGetAll_argsStandardScheme getScheme() {
        return new resourcePoolResponseGetAll_argsStandardScheme();
      }
    }

    private static class resourcePoolResponseGetAll_argsStandardScheme extends StandardScheme<resourcePoolResponseGetAll_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resourcePoolResponseGetAll_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // RESOURCES
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list18 = iprot.readListBegin();
                  struct.resources = new ArrayList<String>(_list18.size);
                  String _elem19;
                  for (int _i20 = 0; _i20 < _list18.size; ++_i20)
                  {
                    _elem19 = iprot.readString();
                    struct.resources.add(_elem19);
                  }
                  iprot.readListEnd();
                }
                struct.setResourcesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resourcePoolResponseGetAll_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.resources != null) {
          oprot.writeFieldBegin(RESOURCES_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.resources.size()));
            for (String _iter21 : struct.resources)
            {
              oprot.writeString(_iter21);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resourcePoolResponseGetAll_argsTupleSchemeFactory implements SchemeFactory {
      public resourcePoolResponseGetAll_argsTupleScheme getScheme() {
        return new resourcePoolResponseGetAll_argsTupleScheme();
      }
    }

    private static class resourcePoolResponseGetAll_argsTupleScheme extends TupleScheme<resourcePoolResponseGetAll_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resourcePoolResponseGetAll_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetResources()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetResources()) {
          {
            oprot.writeI32(struct.resources.size());
            for (String _iter22 : struct.resources)
            {
              oprot.writeString(_iter22);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resourcePoolResponseGetAll_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list23 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.resources = new ArrayList<String>(_list23.size);
            String _elem24;
            for (int _i25 = 0; _i25 < _list23.size; ++_i25)
            {
              _elem24 = iprot.readString();
              struct.resources.add(_elem24);
            }
          }
          struct.setResourcesIsSet(true);
        }
      }
    }

  }

  public static class resourcePoolResponseGetAll_result implements org.apache.thrift.TBase<resourcePoolResponseGetAll_result, resourcePoolResponseGetAll_result._Fields>, java.io.Serializable, Cloneable, Comparable<resourcePoolResponseGetAll_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resourcePoolResponseGetAll_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resourcePoolResponseGetAll_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resourcePoolResponseGetAll_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resourcePoolResponseGetAll_result.class, metaDataMap);
    }

    public resourcePoolResponseGetAll_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resourcePoolResponseGetAll_result(resourcePoolResponseGetAll_result other) {
    }

    public resourcePoolResponseGetAll_result deepCopy() {
      return new resourcePoolResponseGetAll_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resourcePoolResponseGetAll_result)
        return this.equals((resourcePoolResponseGetAll_result)that);
      return false;
    }

    public boolean equals(resourcePoolResponseGetAll_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(resourcePoolResponseGetAll_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resourcePoolResponseGetAll_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resourcePoolResponseGetAll_resultStandardSchemeFactory implements SchemeFactory {
      public resourcePoolResponseGetAll_resultStandardScheme getScheme() {
        return new resourcePoolResponseGetAll_resultStandardScheme();
      }
    }

    private static class resourcePoolResponseGetAll_resultStandardScheme extends StandardScheme<resourcePoolResponseGetAll_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resourcePoolResponseGetAll_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resourcePoolResponseGetAll_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resourcePoolResponseGetAll_resultTupleSchemeFactory implements SchemeFactory {
      public resourcePoolResponseGetAll_resultTupleScheme getScheme() {
        return new resourcePoolResponseGetAll_resultTupleScheme();
      }
    }

    private static class resourcePoolResponseGetAll_resultTupleScheme extends TupleScheme<resourcePoolResponseGetAll_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resourcePoolResponseGetAll_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resourcePoolResponseGetAll_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class resourceResponseGet_args implements org.apache.thrift.TBase<resourceResponseGet_args, resourceResponseGet_args._Fields>, java.io.Serializable, Cloneable, Comparable<resourceResponseGet_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resourceResponseGet_args");

    private static final org.apache.thrift.protocol.TField RESOURCE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("resourceId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField OBJECT_FIELD_DESC = new org.apache.thrift.protocol.TField("object", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resourceResponseGet_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resourceResponseGet_argsTupleSchemeFactory());
    }

    public String resourceId; // required
    public ByteBuffer object; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      RESOURCE_ID((short)1, "resourceId"),
      OBJECT((short)2, "object");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // RESOURCE_ID
            return RESOURCE_ID;
          case 2: // OBJECT
            return OBJECT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.RESOURCE_ID, new org.apache.thrift.meta_data.FieldMetaData("resourceId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.OBJECT, new org.apache.thrift.meta_data.FieldMetaData("object", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resourceResponseGet_args.class, metaDataMap);
    }

    public resourceResponseGet_args() {
    }

    public resourceResponseGet_args(
      String resourceId,
      ByteBuffer object)
    {
      this();
      this.resourceId = resourceId;
      this.object = org.apache.thrift.TBaseHelper.copyBinary(object);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resourceResponseGet_args(resourceResponseGet_args other) {
      if (other.isSetResourceId()) {
        this.resourceId = other.resourceId;
      }
      if (other.isSetObject()) {
        this.object = org.apache.thrift.TBaseHelper.copyBinary(other.object);
      }
    }

    public resourceResponseGet_args deepCopy() {
      return new resourceResponseGet_args(this);
    }

    @Override
    public void clear() {
      this.resourceId = null;
      this.object = null;
    }

    public String getResourceId() {
      return this.resourceId;
    }

    public resourceResponseGet_args setResourceId(String resourceId) {
      this.resourceId = resourceId;
      return this;
    }

    public void unsetResourceId() {
      this.resourceId = null;
    }

    /** Returns true if field resourceId is set (has been assigned a value) and false otherwise */
    public boolean isSetResourceId() {
      return this.resourceId != null;
    }

    public void setResourceIdIsSet(boolean value) {
      if (!value) {
        this.resourceId = null;
      }
    }

    public byte[] getObject() {
      setObject(org.apache.thrift.TBaseHelper.rightSize(object));
      return object == null ? null : object.array();
    }

    public ByteBuffer bufferForObject() {
      return org.apache.thrift.TBaseHelper.copyBinary(object);
    }

    public resourceResponseGet_args setObject(byte[] object) {
      this.object = object == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(object, object.length));
      return this;
    }

    public resourceResponseGet_args setObject(ByteBuffer object) {
      this.object = org.apache.thrift.TBaseHelper.copyBinary(object);
      return this;
    }

    public void unsetObject() {
      this.object = null;
    }

    /** Returns true if field object is set (has been assigned a value) and false otherwise */
    public boolean isSetObject() {
      return this.object != null;
    }

    public void setObjectIsSet(boolean value) {
      if (!value) {
        this.object = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case RESOURCE_ID:
        if (value == null) {
          unsetResourceId();
        } else {
          setResourceId((String)value);
        }
        break;

      case OBJECT:
        if (value == null) {
          unsetObject();
        } else {
          setObject((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case RESOURCE_ID:
        return getResourceId();

      case OBJECT:
        return getObject();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case RESOURCE_ID:
        return isSetResourceId();
      case OBJECT:
        return isSetObject();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resourceResponseGet_args)
        return this.equals((resourceResponseGet_args)that);
      return false;
    }

    public boolean equals(resourceResponseGet_args that) {
      if (that == null)
        return false;

      boolean this_present_resourceId = true && this.isSetResourceId();
      boolean that_present_resourceId = true && that.isSetResourceId();
      if (this_present_resourceId || that_present_resourceId) {
        if (!(this_present_resourceId && that_present_resourceId))
          return false;
        if (!this.resourceId.equals(that.resourceId))
          return false;
      }

      boolean this_present_object = true && this.isSetObject();
      boolean that_present_object = true && that.isSetObject();
      if (this_present_object || that_present_object) {
        if (!(this_present_object && that_present_object))
          return false;
        if (!this.object.equals(that.object))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_resourceId = true && (isSetResourceId());
      list.add(present_resourceId);
      if (present_resourceId)
        list.add(resourceId);

      boolean present_object = true && (isSetObject());
      list.add(present_object);
      if (present_object)
        list.add(object);

      return list.hashCode();
    }

    @Override
    public int compareTo(resourceResponseGet_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetResourceId()).compareTo(other.isSetResourceId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetResourceId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.resourceId, other.resourceId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetObject()).compareTo(other.isSetObject());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetObject()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.object, other.object);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resourceResponseGet_args(");
      boolean first = true;

      sb.append("resourceId:");
      if (this.resourceId == null) {
        sb.append("null");
      } else {
        sb.append(this.resourceId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("object:");
      if (this.object == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.object, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resourceResponseGet_argsStandardSchemeFactory implements SchemeFactory {
      public resourceResponseGet_argsStandardScheme getScheme() {
        return new resourceResponseGet_argsStandardScheme();
      }
    }

    private static class resourceResponseGet_argsStandardScheme extends StandardScheme<resourceResponseGet_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resourceResponseGet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // RESOURCE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.resourceId = iprot.readString();
                struct.setResourceIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // OBJECT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.object = iprot.readBinary();
                struct.setObjectIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resourceResponseGet_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.resourceId != null) {
          oprot.writeFieldBegin(RESOURCE_ID_FIELD_DESC);
          oprot.writeString(struct.resourceId);
          oprot.writeFieldEnd();
        }
        if (struct.object != null) {
          oprot.writeFieldBegin(OBJECT_FIELD_DESC);
          oprot.writeBinary(struct.object);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resourceResponseGet_argsTupleSchemeFactory implements SchemeFactory {
      public resourceResponseGet_argsTupleScheme getScheme() {
        return new resourceResponseGet_argsTupleScheme();
      }
    }

    private static class resourceResponseGet_argsTupleScheme extends TupleScheme<resourceResponseGet_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resourceResponseGet_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetResourceId()) {
          optionals.set(0);
        }
        if (struct.isSetObject()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetResourceId()) {
          oprot.writeString(struct.resourceId);
        }
        if (struct.isSetObject()) {
          oprot.writeBinary(struct.object);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resourceResponseGet_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.resourceId = iprot.readString();
          struct.setResourceIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.object = iprot.readBinary();
          struct.setObjectIsSet(true);
        }
      }
    }

  }

  public static class resourceResponseGet_result implements org.apache.thrift.TBase<resourceResponseGet_result, resourceResponseGet_result._Fields>, java.io.Serializable, Cloneable, Comparable<resourceResponseGet_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resourceResponseGet_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resourceResponseGet_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resourceResponseGet_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resourceResponseGet_result.class, metaDataMap);
    }

    public resourceResponseGet_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resourceResponseGet_result(resourceResponseGet_result other) {
    }

    public resourceResponseGet_result deepCopy() {
      return new resourceResponseGet_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resourceResponseGet_result)
        return this.equals((resourceResponseGet_result)that);
      return false;
    }

    public boolean equals(resourceResponseGet_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(resourceResponseGet_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resourceResponseGet_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resourceResponseGet_resultStandardSchemeFactory implements SchemeFactory {
      public resourceResponseGet_resultStandardScheme getScheme() {
        return new resourceResponseGet_resultStandardScheme();
      }
    }

    private static class resourceResponseGet_resultStandardScheme extends StandardScheme<resourceResponseGet_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resourceResponseGet_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resourceResponseGet_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resourceResponseGet_resultTupleSchemeFactory implements SchemeFactory {
      public resourceResponseGet_resultTupleScheme getScheme() {
        return new resourceResponseGet_resultTupleScheme();
      }
    }

    private static class resourceResponseGet_resultTupleScheme extends TupleScheme<resourceResponseGet_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resourceResponseGet_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resourceResponseGet_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class resourcePoolGetAll_args implements org.apache.thrift.TBase<resourcePoolGetAll_args, resourcePoolGetAll_args._Fields>, java.io.Serializable, Cloneable, Comparable<resourcePoolGetAll_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resourcePoolGetAll_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resourcePoolGetAll_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resourcePoolGetAll_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resourcePoolGetAll_args.class, metaDataMap);
    }

    public resourcePoolGetAll_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resourcePoolGetAll_args(resourcePoolGetAll_args other) {
    }

    public resourcePoolGetAll_args deepCopy() {
      return new resourcePoolGetAll_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resourcePoolGetAll_args)
        return this.equals((resourcePoolGetAll_args)that);
      return false;
    }

    public boolean equals(resourcePoolGetAll_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(resourcePoolGetAll_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resourcePoolGetAll_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resourcePoolGetAll_argsStandardSchemeFactory implements SchemeFactory {
      public resourcePoolGetAll_argsStandardScheme getScheme() {
        return new resourcePoolGetAll_argsStandardScheme();
      }
    }

    private static class resourcePoolGetAll_argsStandardScheme extends StandardScheme<resourcePoolGetAll_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resourcePoolGetAll_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resourcePoolGetAll_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resourcePoolGetAll_argsTupleSchemeFactory implements SchemeFactory {
      public resourcePoolGetAll_argsTupleScheme getScheme() {
        return new resourcePoolGetAll_argsTupleScheme();
      }
    }

    private static class resourcePoolGetAll_argsTupleScheme extends TupleScheme<resourcePoolGetAll_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resourcePoolGetAll_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resourcePoolGetAll_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class resourcePoolGetAll_result implements org.apache.thrift.TBase<resourcePoolGetAll_result, resourcePoolGetAll_result._Fields>, java.io.Serializable, Cloneable, Comparable<resourcePoolGetAll_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resourcePoolGetAll_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resourcePoolGetAll_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resourcePoolGetAll_resultTupleSchemeFactory());
    }

    public List<String> success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resourcePoolGetAll_result.class, metaDataMap);
    }

    public resourcePoolGetAll_result() {
    }

    public resourcePoolGetAll_result(
      List<String> success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resourcePoolGetAll_result(resourcePoolGetAll_result other) {
      if (other.isSetSuccess()) {
        List<String> __this__success = new ArrayList<String>(other.success);
        this.success = __this__success;
      }
    }

    public resourcePoolGetAll_result deepCopy() {
      return new resourcePoolGetAll_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<String> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(String elem) {
      if (this.success == null) {
        this.success = new ArrayList<String>();
      }
      this.success.add(elem);
    }

    public List<String> getSuccess() {
      return this.success;
    }

    public resourcePoolGetAll_result setSuccess(List<String> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<String>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resourcePoolGetAll_result)
        return this.equals((resourcePoolGetAll_result)that);
      return false;
    }

    public boolean equals(resourcePoolGetAll_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(resourcePoolGetAll_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resourcePoolGetAll_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resourcePoolGetAll_resultStandardSchemeFactory implements SchemeFactory {
      public resourcePoolGetAll_resultStandardScheme getScheme() {
        return new resourcePoolGetAll_resultStandardScheme();
      }
    }

    private static class resourcePoolGetAll_resultStandardScheme extends StandardScheme<resourcePoolGetAll_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resourcePoolGetAll_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list26 = iprot.readListBegin();
                  struct.success = new ArrayList<String>(_list26.size);
                  String _elem27;
                  for (int _i28 = 0; _i28 < _list26.size; ++_i28)
                  {
                    _elem27 = iprot.readString();
                    struct.success.add(_elem27);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resourcePoolGetAll_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.success.size()));
            for (String _iter29 : struct.success)
            {
              oprot.writeString(_iter29);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resourcePoolGetAll_resultTupleSchemeFactory implements SchemeFactory {
      public resourcePoolGetAll_resultTupleScheme getScheme() {
        return new resourcePoolGetAll_resultTupleScheme();
      }
    }

    private static class resourcePoolGetAll_resultTupleScheme extends TupleScheme<resourcePoolGetAll_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resourcePoolGetAll_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (String _iter30 : struct.success)
            {
              oprot.writeString(_iter30);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resourcePoolGetAll_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list31 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.success = new ArrayList<String>(_list31.size);
            String _elem32;
            for (int _i33 = 0; _i33 < _list31.size; ++_i33)
            {
              _elem32 = iprot.readString();
              struct.success.add(_elem32);
            }
          }
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class resourceGet_args implements org.apache.thrift.TBase<resourceGet_args, resourceGet_args._Fields>, java.io.Serializable, Cloneable, Comparable<resourceGet_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resourceGet_args");

    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField PARAGRAPH_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("paragraphId", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField RESOURCE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("resourceName", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resourceGet_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resourceGet_argsTupleSchemeFactory());
    }

    public String noteId; // required
    public String paragraphId; // required
    public String resourceName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NOTE_ID((short)1, "noteId"),
      PARAGRAPH_ID((short)2, "paragraphId"),
      RESOURCE_NAME((short)3, "resourceName");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NOTE_ID
            return NOTE_ID;
          case 2: // PARAGRAPH_ID
            return PARAGRAPH_ID;
          case 3: // RESOURCE_NAME
            return RESOURCE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PARAGRAPH_ID, new org.apache.thrift.meta_data.FieldMetaData("paragraphId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.RESOURCE_NAME, new org.apache.thrift.meta_data.FieldMetaData("resourceName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resourceGet_args.class, metaDataMap);
    }

    public resourceGet_args() {
    }

    public resourceGet_args(
      String noteId,
      String paragraphId,
      String resourceName)
    {
      this();
      this.noteId = noteId;
      this.paragraphId = paragraphId;
      this.resourceName = resourceName;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resourceGet_args(resourceGet_args other) {
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetParagraphId()) {
        this.paragraphId = other.paragraphId;
      }
      if (other.isSetResourceName()) {
        this.resourceName = other.resourceName;
      }
    }

    public resourceGet_args deepCopy() {
      return new resourceGet_args(this);
    }

    @Override
    public void clear() {
      this.noteId = null;
      this.paragraphId = null;
      this.resourceName = null;
    }

    public String getNoteId() {
      return this.noteId;
    }

    public resourceGet_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getParagraphId() {
      return this.paragraphId;
    }

    public resourceGet_args setParagraphId(String paragraphId) {
      this.paragraphId = paragraphId;
      return this;
    }

    public void unsetParagraphId() {
      this.paragraphId = null;
    }

    /** Returns true if field paragraphId is set (has been assigned a value) and false otherwise */
    public boolean isSetParagraphId() {
      return this.paragraphId != null;
    }

    public void setParagraphIdIsSet(boolean value) {
      if (!value) {
        this.paragraphId = null;
      }
    }

    public String getResourceName() {
      return this.resourceName;
    }

    public resourceGet_args setResourceName(String resourceName) {
      this.resourceName = resourceName;
      return this;
    }

    public void unsetResourceName() {
      this.resourceName = null;
    }

    /** Returns true if field resourceName is set (has been assigned a value) and false otherwise */
    public boolean isSetResourceName() {
      return this.resourceName != null;
    }

    public void setResourceNameIsSet(boolean value) {
      if (!value) {
        this.resourceName = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case PARAGRAPH_ID:
        if (value == null) {
          unsetParagraphId();
        } else {
          setParagraphId((String)value);
        }
        break;

      case RESOURCE_NAME:
        if (value == null) {
          unsetResourceName();
        } else {
          setResourceName((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NOTE_ID:
        return getNoteId();

      case PARAGRAPH_ID:
        return getParagraphId();

      case RESOURCE_NAME:
        return getResourceName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NOTE_ID:
        return isSetNoteId();
      case PARAGRAPH_ID:
        return isSetParagraphId();
      case RESOURCE_NAME:
        return isSetResourceName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resourceGet_args)
        return this.equals((resourceGet_args)that);
      return false;
    }

    public boolean equals(resourceGet_args that) {
      if (that == null)
        return false;

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_paragraphId = true && this.isSetParagraphId();
      boolean that_present_paragraphId = true && that.isSetParagraphId();
      if (this_present_paragraphId || that_present_paragraphId) {
        if (!(this_present_paragraphId && that_present_paragraphId))
          return false;
        if (!this.paragraphId.equals(that.paragraphId))
          return false;
      }

      boolean this_present_resourceName = true && this.isSetResourceName();
      boolean that_present_resourceName = true && that.isSetResourceName();
      if (this_present_resourceName || that_present_resourceName) {
        if (!(this_present_resourceName && that_present_resourceName))
          return false;
        if (!this.resourceName.equals(that.resourceName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_paragraphId = true && (isSetParagraphId());
      list.add(present_paragraphId);
      if (present_paragraphId)
        list.add(paragraphId);

      boolean present_resourceName = true && (isSetResourceName());
      list.add(present_resourceName);
      if (present_resourceName)
        list.add(resourceName);

      return list.hashCode();
    }

    @Override
    public int compareTo(resourceGet_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetParagraphId()).compareTo(other.isSetParagraphId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetParagraphId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.paragraphId, other.paragraphId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetResourceName()).compareTo(other.isSetResourceName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetResourceName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.resourceName, other.resourceName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resourceGet_args(");
      boolean first = true;

      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("paragraphId:");
      if (this.paragraphId == null) {
        sb.append("null");
      } else {
        sb.append(this.paragraphId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("resourceName:");
      if (this.resourceName == null) {
        sb.append("null");
      } else {
        sb.append(this.resourceName);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resourceGet_argsStandardSchemeFactory implements SchemeFactory {
      public resourceGet_argsStandardScheme getScheme() {
        return new resourceGet_argsStandardScheme();
      }
    }

    private static class resourceGet_argsStandardScheme extends StandardScheme<resourceGet_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resourceGet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PARAGRAPH_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.paragraphId = iprot.readString();
                struct.setParagraphIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // RESOURCE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.resourceName = iprot.readString();
                struct.setResourceNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resourceGet_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.paragraphId != null) {
          oprot.writeFieldBegin(PARAGRAPH_ID_FIELD_DESC);
          oprot.writeString(struct.paragraphId);
          oprot.writeFieldEnd();
        }
        if (struct.resourceName != null) {
          oprot.writeFieldBegin(RESOURCE_NAME_FIELD_DESC);
          oprot.writeString(struct.resourceName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resourceGet_argsTupleSchemeFactory implements SchemeFactory {
      public resourceGet_argsTupleScheme getScheme() {
        return new resourceGet_argsTupleScheme();
      }
    }

    private static class resourceGet_argsTupleScheme extends TupleScheme<resourceGet_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resourceGet_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetNoteId()) {
          optionals.set(0);
        }
        if (struct.isSetParagraphId()) {
          optionals.set(1);
        }
        if (struct.isSetResourceName()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetParagraphId()) {
          oprot.writeString(struct.paragraphId);
        }
        if (struct.isSetResourceName()) {
          oprot.writeString(struct.resourceName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resourceGet_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.paragraphId = iprot.readString();
          struct.setParagraphIdIsSet(true);
        }
        if (incoming.get(2)) {
          struct.resourceName = iprot.readString();
          struct.setResourceNameIsSet(true);
        }
      }
    }

  }

  public static class resourceGet_result implements org.apache.thrift.TBase<resourceGet_result, resourceGet_result._Fields>, java.io.Serializable, Cloneable, Comparable<resourceGet_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resourceGet_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resourceGet_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resourceGet_resultTupleSchemeFactory());
    }

    public ByteBuffer success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resourceGet_result.class, metaDataMap);
    }

    public resourceGet_result() {
    }

    public resourceGet_result(
      ByteBuffer success)
    {
      this();
      this.success = org.apache.thrift.TBaseHelper.copyBinary(success);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resourceGet_result(resourceGet_result other) {
      if (other.isSetSuccess()) {
        this.success = org.apache.thrift.TBaseHelper.copyBinary(other.success);
      }
    }

    public resourceGet_result deepCopy() {
      return new resourceGet_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public byte[] getSuccess() {
      setSuccess(org.apache.thrift.TBaseHelper.rightSize(success));
      return success == null ? null : success.array();
    }

    public ByteBuffer bufferForSuccess() {
      return org.apache.thrift.TBaseHelper.copyBinary(success);
    }

    public resourceGet_result setSuccess(byte[] success) {
      this.success = success == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(success, success.length));
      return this;
    }

    public resourceGet_result setSuccess(ByteBuffer success) {
      this.success = org.apache.thrift.TBaseHelper.copyBinary(success);
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resourceGet_result)
        return this.equals((resourceGet_result)that);
      return false;
    }

    public boolean equals(resourceGet_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(resourceGet_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resourceGet_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.success, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resourceGet_resultStandardSchemeFactory implements SchemeFactory {
      public resourceGet_resultStandardScheme getScheme() {
        return new resourceGet_resultStandardScheme();
      }
    }

    private static class resourceGet_resultStandardScheme extends StandardScheme<resourceGet_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resourceGet_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readBinary();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resourceGet_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBinary(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resourceGet_resultTupleSchemeFactory implements SchemeFactory {
      public resourceGet_resultTupleScheme getScheme() {
        return new resourceGet_resultTupleScheme();
      }
    }

    private static class resourceGet_resultTupleScheme extends TupleScheme<resourceGet_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resourceGet_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeBinary(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resourceGet_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readBinary();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class resourceRemove_args implements org.apache.thrift.TBase<resourceRemove_args, resourceRemove_args._Fields>, java.io.Serializable, Cloneable, Comparable<resourceRemove_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resourceRemove_args");

    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField PARAGRAPH_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("paragraphId", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField RESOURCE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("resourceName", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resourceRemove_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resourceRemove_argsTupleSchemeFactory());
    }

    public String noteId; // required
    public String paragraphId; // required
    public String resourceName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NOTE_ID((short)1, "noteId"),
      PARAGRAPH_ID((short)2, "paragraphId"),
      RESOURCE_NAME((short)3, "resourceName");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NOTE_ID
            return NOTE_ID;
          case 2: // PARAGRAPH_ID
            return PARAGRAPH_ID;
          case 3: // RESOURCE_NAME
            return RESOURCE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PARAGRAPH_ID, new org.apache.thrift.meta_data.FieldMetaData("paragraphId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.RESOURCE_NAME, new org.apache.thrift.meta_data.FieldMetaData("resourceName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resourceRemove_args.class, metaDataMap);
    }

    public resourceRemove_args() {
    }

    public resourceRemove_args(
      String noteId,
      String paragraphId,
      String resourceName)
    {
      this();
      this.noteId = noteId;
      this.paragraphId = paragraphId;
      this.resourceName = resourceName;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resourceRemove_args(resourceRemove_args other) {
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetParagraphId()) {
        this.paragraphId = other.paragraphId;
      }
      if (other.isSetResourceName()) {
        this.resourceName = other.resourceName;
      }
    }

    public resourceRemove_args deepCopy() {
      return new resourceRemove_args(this);
    }

    @Override
    public void clear() {
      this.noteId = null;
      this.paragraphId = null;
      this.resourceName = null;
    }

    public String getNoteId() {
      return this.noteId;
    }

    public resourceRemove_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getParagraphId() {
      return this.paragraphId;
    }

    public resourceRemove_args setParagraphId(String paragraphId) {
      this.paragraphId = paragraphId;
      return this;
    }

    public void unsetParagraphId() {
      this.paragraphId = null;
    }

    /** Returns true if field paragraphId is set (has been assigned a value) and false otherwise */
    public boolean isSetParagraphId() {
      return this.paragraphId != null;
    }

    public void setParagraphIdIsSet(boolean value) {
      if (!value) {
        this.paragraphId = null;
      }
    }

    public String getResourceName() {
      return this.resourceName;
    }

    public resourceRemove_args setResourceName(String resourceName) {
      this.resourceName = resourceName;
      return this;
    }

    public void unsetResourceName() {
      this.resourceName = null;
    }

    /** Returns true if field resourceName is set (has been assigned a value) and false otherwise */
    public boolean isSetResourceName() {
      return this.resourceName != null;
    }

    public void setResourceNameIsSet(boolean value) {
      if (!value) {
        this.resourceName = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case PARAGRAPH_ID:
        if (value == null) {
          unsetParagraphId();
        } else {
          setParagraphId((String)value);
        }
        break;

      case RESOURCE_NAME:
        if (value == null) {
          unsetResourceName();
        } else {
          setResourceName((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NOTE_ID:
        return getNoteId();

      case PARAGRAPH_ID:
        return getParagraphId();

      case RESOURCE_NAME:
        return getResourceName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NOTE_ID:
        return isSetNoteId();
      case PARAGRAPH_ID:
        return isSetParagraphId();
      case RESOURCE_NAME:
        return isSetResourceName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resourceRemove_args)
        return this.equals((resourceRemove_args)that);
      return false;
    }

    public boolean equals(resourceRemove_args that) {
      if (that == null)
        return false;

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_paragraphId = true && this.isSetParagraphId();
      boolean that_present_paragraphId = true && that.isSetParagraphId();
      if (this_present_paragraphId || that_present_paragraphId) {
        if (!(this_present_paragraphId && that_present_paragraphId))
          return false;
        if (!this.paragraphId.equals(that.paragraphId))
          return false;
      }

      boolean this_present_resourceName = true && this.isSetResourceName();
      boolean that_present_resourceName = true && that.isSetResourceName();
      if (this_present_resourceName || that_present_resourceName) {
        if (!(this_present_resourceName && that_present_resourceName))
          return false;
        if (!this.resourceName.equals(that.resourceName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_paragraphId = true && (isSetParagraphId());
      list.add(present_paragraphId);
      if (present_paragraphId)
        list.add(paragraphId);

      boolean present_resourceName = true && (isSetResourceName());
      list.add(present_resourceName);
      if (present_resourceName)
        list.add(resourceName);

      return list.hashCode();
    }

    @Override
    public int compareTo(resourceRemove_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetParagraphId()).compareTo(other.isSetParagraphId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetParagraphId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.paragraphId, other.paragraphId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetResourceName()).compareTo(other.isSetResourceName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetResourceName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.resourceName, other.resourceName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resourceRemove_args(");
      boolean first = true;

      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("paragraphId:");
      if (this.paragraphId == null) {
        sb.append("null");
      } else {
        sb.append(this.paragraphId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("resourceName:");
      if (this.resourceName == null) {
        sb.append("null");
      } else {
        sb.append(this.resourceName);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resourceRemove_argsStandardSchemeFactory implements SchemeFactory {
      public resourceRemove_argsStandardScheme getScheme() {
        return new resourceRemove_argsStandardScheme();
      }
    }

    private static class resourceRemove_argsStandardScheme extends StandardScheme<resourceRemove_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resourceRemove_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PARAGRAPH_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.paragraphId = iprot.readString();
                struct.setParagraphIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // RESOURCE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.resourceName = iprot.readString();
                struct.setResourceNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resourceRemove_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.paragraphId != null) {
          oprot.writeFieldBegin(PARAGRAPH_ID_FIELD_DESC);
          oprot.writeString(struct.paragraphId);
          oprot.writeFieldEnd();
        }
        if (struct.resourceName != null) {
          oprot.writeFieldBegin(RESOURCE_NAME_FIELD_DESC);
          oprot.writeString(struct.resourceName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resourceRemove_argsTupleSchemeFactory implements SchemeFactory {
      public resourceRemove_argsTupleScheme getScheme() {
        return new resourceRemove_argsTupleScheme();
      }
    }

    private static class resourceRemove_argsTupleScheme extends TupleScheme<resourceRemove_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resourceRemove_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetNoteId()) {
          optionals.set(0);
        }
        if (struct.isSetParagraphId()) {
          optionals.set(1);
        }
        if (struct.isSetResourceName()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetParagraphId()) {
          oprot.writeString(struct.paragraphId);
        }
        if (struct.isSetResourceName()) {
          oprot.writeString(struct.resourceName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resourceRemove_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.paragraphId = iprot.readString();
          struct.setParagraphIdIsSet(true);
        }
        if (incoming.get(2)) {
          struct.resourceName = iprot.readString();
          struct.setResourceNameIsSet(true);
        }
      }
    }

  }

  public static class resourceRemove_result implements org.apache.thrift.TBase<resourceRemove_result, resourceRemove_result._Fields>, java.io.Serializable, Cloneable, Comparable<resourceRemove_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resourceRemove_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resourceRemove_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resourceRemove_resultTupleSchemeFactory());
    }

    public boolean success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resourceRemove_result.class, metaDataMap);
    }

    public resourceRemove_result() {
    }

    public resourceRemove_result(
      boolean success)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resourceRemove_result(resourceRemove_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
    }

    public resourceRemove_result deepCopy() {
      return new resourceRemove_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public resourceRemove_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resourceRemove_result)
        return this.equals((resourceRemove_result)that);
      return false;
    }

    public boolean equals(resourceRemove_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(resourceRemove_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resourceRemove_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resourceRemove_resultStandardSchemeFactory implements SchemeFactory {
      public resourceRemove_resultStandardScheme getScheme() {
        return new resourceRemove_resultStandardScheme();
      }
    }

    private static class resourceRemove_resultStandardScheme extends StandardScheme<resourceRemove_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resourceRemove_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resourceRemove_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resourceRemove_resultTupleSchemeFactory implements SchemeFactory {
      public resourceRemove_resultTupleScheme getScheme() {
        return new resourceRemove_resultTupleScheme();
      }
    }

    private static class resourceRemove_resultTupleScheme extends TupleScheme<resourceRemove_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resourceRemove_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resourceRemove_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class angularObjectUpdate_args implements org.apache.thrift.TBase<angularObjectUpdate_args, angularObjectUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<angularObjectUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("angularObjectUpdate_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField PARAGRAPH_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("paragraphId", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField OBJECT_FIELD_DESC = new org.apache.thrift.protocol.TField("object", org.apache.thrift.protocol.TType.STRING, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new angularObjectUpdate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new angularObjectUpdate_argsTupleSchemeFactory());
    }

    public String name; // required
    public String noteId; // required
    public String paragraphId; // required
    public String object; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name"),
      NOTE_ID((short)2, "noteId"),
      PARAGRAPH_ID((short)3, "paragraphId"),
      OBJECT((short)4, "object");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          case 2: // NOTE_ID
            return NOTE_ID;
          case 3: // PARAGRAPH_ID
            return PARAGRAPH_ID;
          case 4: // OBJECT
            return OBJECT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PARAGRAPH_ID, new org.apache.thrift.meta_data.FieldMetaData("paragraphId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.OBJECT, new org.apache.thrift.meta_data.FieldMetaData("object", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(angularObjectUpdate_args.class, metaDataMap);
    }

    public angularObjectUpdate_args() {
    }

    public angularObjectUpdate_args(
      String name,
      String noteId,
      String paragraphId,
      String object)
    {
      this();
      this.name = name;
      this.noteId = noteId;
      this.paragraphId = paragraphId;
      this.object = object;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public angularObjectUpdate_args(angularObjectUpdate_args other) {
      if (other.isSetName()) {
        this.name = other.name;
      }
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetParagraphId()) {
        this.paragraphId = other.paragraphId;
      }
      if (other.isSetObject()) {
        this.object = other.object;
      }
    }

    public angularObjectUpdate_args deepCopy() {
      return new angularObjectUpdate_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
      this.noteId = null;
      this.paragraphId = null;
      this.object = null;
    }

    public String getName() {
      return this.name;
    }

    public angularObjectUpdate_args setName(String name) {
      this.name = name;
      return this;
    }

    public void unsetName() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean isSetName() {
      return this.name != null;
    }

    public void setNameIsSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public String getNoteId() {
      return this.noteId;
    }

    public angularObjectUpdate_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getParagraphId() {
      return this.paragraphId;
    }

    public angularObjectUpdate_args setParagraphId(String paragraphId) {
      this.paragraphId = paragraphId;
      return this;
    }

    public void unsetParagraphId() {
      this.paragraphId = null;
    }

    /** Returns true if field paragraphId is set (has been assigned a value) and false otherwise */
    public boolean isSetParagraphId() {
      return this.paragraphId != null;
    }

    public void setParagraphIdIsSet(boolean value) {
      if (!value) {
        this.paragraphId = null;
      }
    }

    public String getObject() {
      return this.object;
    }

    public angularObjectUpdate_args setObject(String object) {
      this.object = object;
      return this;
    }

    public void unsetObject() {
      this.object = null;
    }

    /** Returns true if field object is set (has been assigned a value) and false otherwise */
    public boolean isSetObject() {
      return this.object != null;
    }

    public void setObjectIsSet(boolean value) {
      if (!value) {
        this.object = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unsetName();
        } else {
          setName((String)value);
        }
        break;

      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case PARAGRAPH_ID:
        if (value == null) {
          unsetParagraphId();
        } else {
          setParagraphId((String)value);
        }
        break;

      case OBJECT:
        if (value == null) {
          unsetObject();
        } else {
          setObject((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return getName();

      case NOTE_ID:
        return getNoteId();

      case PARAGRAPH_ID:
        return getParagraphId();

      case OBJECT:
        return getObject();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return isSetName();
      case NOTE_ID:
        return isSetNoteId();
      case PARAGRAPH_ID:
        return isSetParagraphId();
      case OBJECT:
        return isSetObject();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof angularObjectUpdate_args)
        return this.equals((angularObjectUpdate_args)that);
      return false;
    }

    public boolean equals(angularObjectUpdate_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.isSetName();
      boolean that_present_name = true && that.isSetName();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_paragraphId = true && this.isSetParagraphId();
      boolean that_present_paragraphId = true && that.isSetParagraphId();
      if (this_present_paragraphId || that_present_paragraphId) {
        if (!(this_present_paragraphId && that_present_paragraphId))
          return false;
        if (!this.paragraphId.equals(that.paragraphId))
          return false;
      }

      boolean this_present_object = true && this.isSetObject();
      boolean that_present_object = true && that.isSetObject();
      if (this_present_object || that_present_object) {
        if (!(this_present_object && that_present_object))
          return false;
        if (!this.object.equals(that.object))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (isSetName());
      list.add(present_name);
      if (present_name)
        list.add(name);

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_paragraphId = true && (isSetParagraphId());
      list.add(present_paragraphId);
      if (present_paragraphId)
        list.add(paragraphId);

      boolean present_object = true && (isSetObject());
      list.add(present_object);
      if (present_object)
        list.add(object);

      return list.hashCode();
    }

    @Override
    public int compareTo(angularObjectUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetName()).compareTo(other.isSetName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetParagraphId()).compareTo(other.isSetParagraphId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetParagraphId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.paragraphId, other.paragraphId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetObject()).compareTo(other.isSetObject());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetObject()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.object, other.object);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("angularObjectUpdate_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("paragraphId:");
      if (this.paragraphId == null) {
        sb.append("null");
      } else {
        sb.append(this.paragraphId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("object:");
      if (this.object == null) {
        sb.append("null");
      } else {
        sb.append(this.object);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class angularObjectUpdate_argsStandardSchemeFactory implements SchemeFactory {
      public angularObjectUpdate_argsStandardScheme getScheme() {
        return new angularObjectUpdate_argsStandardScheme();
      }
    }

    private static class angularObjectUpdate_argsStandardScheme extends StandardScheme<angularObjectUpdate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, angularObjectUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.setNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // PARAGRAPH_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.paragraphId = iprot.readString();
                struct.setParagraphIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // OBJECT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.object = iprot.readString();
                struct.setObjectIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, angularObjectUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.paragraphId != null) {
          oprot.writeFieldBegin(PARAGRAPH_ID_FIELD_DESC);
          oprot.writeString(struct.paragraphId);
          oprot.writeFieldEnd();
        }
        if (struct.object != null) {
          oprot.writeFieldBegin(OBJECT_FIELD_DESC);
          oprot.writeString(struct.object);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class angularObjectUpdate_argsTupleSchemeFactory implements SchemeFactory {
      public angularObjectUpdate_argsTupleScheme getScheme() {
        return new angularObjectUpdate_argsTupleScheme();
      }
    }

    private static class angularObjectUpdate_argsTupleScheme extends TupleScheme<angularObjectUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, angularObjectUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetName()) {
          optionals.set(0);
        }
        if (struct.isSetNoteId()) {
          optionals.set(1);
        }
        if (struct.isSetParagraphId()) {
          optionals.set(2);
        }
        if (struct.isSetObject()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetName()) {
          oprot.writeString(struct.name);
        }
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetParagraphId()) {
          oprot.writeString(struct.paragraphId);
        }
        if (struct.isSetObject()) {
          oprot.writeString(struct.object);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, angularObjectUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.setNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(2)) {
          struct.paragraphId = iprot.readString();
          struct.setParagraphIdIsSet(true);
        }
        if (incoming.get(3)) {
          struct.object = iprot.readString();
          struct.setObjectIsSet(true);
        }
      }
    }

  }

  public static class angularObjectUpdate_result implements org.apache.thrift.TBase<angularObjectUpdate_result, angularObjectUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<angularObjectUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("angularObjectUpdate_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new angularObjectUpdate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new angularObjectUpdate_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(angularObjectUpdate_result.class, metaDataMap);
    }

    public angularObjectUpdate_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public angularObjectUpdate_result(angularObjectUpdate_result other) {
    }

    public angularObjectUpdate_result deepCopy() {
      return new angularObjectUpdate_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof angularObjectUpdate_result)
        return this.equals((angularObjectUpdate_result)that);
      return false;
    }

    public boolean equals(angularObjectUpdate_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(angularObjectUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("angularObjectUpdate_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class angularObjectUpdate_resultStandardSchemeFactory implements SchemeFactory {
      public angularObjectUpdate_resultStandardScheme getScheme() {
        return new angularObjectUpdate_resultStandardScheme();
      }
    }

    private static class angularObjectUpdate_resultStandardScheme extends StandardScheme<angularObjectUpdate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, angularObjectUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, angularObjectUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class angularObjectUpdate_resultTupleSchemeFactory implements SchemeFactory {
      public angularObjectUpdate_resultTupleScheme getScheme() {
        return new angularObjectUpdate_resultTupleScheme();
      }
    }

    private static class angularObjectUpdate_resultTupleScheme extends TupleScheme<angularObjectUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, angularObjectUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, angularObjectUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class angularObjectAdd_args implements org.apache.thrift.TBase<angularObjectAdd_args, angularObjectAdd_args._Fields>, java.io.Serializable, Cloneable, Comparable<angularObjectAdd_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("angularObjectAdd_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField PARAGRAPH_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("paragraphId", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField OBJECT_FIELD_DESC = new org.apache.thrift.protocol.TField("object", org.apache.thrift.protocol.TType.STRING, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new angularObjectAdd_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new angularObjectAdd_argsTupleSchemeFactory());
    }

    public String name; // required
    public String noteId; // required
    public String paragraphId; // required
    public String object; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name"),
      NOTE_ID((short)2, "noteId"),
      PARAGRAPH_ID((short)3, "paragraphId"),
      OBJECT((short)4, "object");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          case 2: // NOTE_ID
            return NOTE_ID;
          case 3: // PARAGRAPH_ID
            return PARAGRAPH_ID;
          case 4: // OBJECT
            return OBJECT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PARAGRAPH_ID, new org.apache.thrift.meta_data.FieldMetaData("paragraphId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.OBJECT, new org.apache.thrift.meta_data.FieldMetaData("object", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(angularObjectAdd_args.class, metaDataMap);
    }

    public angularObjectAdd_args() {
    }

    public angularObjectAdd_args(
      String name,
      String noteId,
      String paragraphId,
      String object)
    {
      this();
      this.name = name;
      this.noteId = noteId;
      this.paragraphId = paragraphId;
      this.object = object;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public angularObjectAdd_args(angularObjectAdd_args other) {
      if (other.isSetName()) {
        this.name = other.name;
      }
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetParagraphId()) {
        this.paragraphId = other.paragraphId;
      }
      if (other.isSetObject()) {
        this.object = other.object;
      }
    }

    public angularObjectAdd_args deepCopy() {
      return new angularObjectAdd_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
      this.noteId = null;
      this.paragraphId = null;
      this.object = null;
    }

    public String getName() {
      return this.name;
    }

    public angularObjectAdd_args setName(String name) {
      this.name = name;
      return this;
    }

    public void unsetName() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean isSetName() {
      return this.name != null;
    }

    public void setNameIsSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public String getNoteId() {
      return this.noteId;
    }

    public angularObjectAdd_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getParagraphId() {
      return this.paragraphId;
    }

    public angularObjectAdd_args setParagraphId(String paragraphId) {
      this.paragraphId = paragraphId;
      return this;
    }

    public void unsetParagraphId() {
      this.paragraphId = null;
    }

    /** Returns true if field paragraphId is set (has been assigned a value) and false otherwise */
    public boolean isSetParagraphId() {
      return this.paragraphId != null;
    }

    public void setParagraphIdIsSet(boolean value) {
      if (!value) {
        this.paragraphId = null;
      }
    }

    public String getObject() {
      return this.object;
    }

    public angularObjectAdd_args setObject(String object) {
      this.object = object;
      return this;
    }

    public void unsetObject() {
      this.object = null;
    }

    /** Returns true if field object is set (has been assigned a value) and false otherwise */
    public boolean isSetObject() {
      return this.object != null;
    }

    public void setObjectIsSet(boolean value) {
      if (!value) {
        this.object = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unsetName();
        } else {
          setName((String)value);
        }
        break;

      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case PARAGRAPH_ID:
        if (value == null) {
          unsetParagraphId();
        } else {
          setParagraphId((String)value);
        }
        break;

      case OBJECT:
        if (value == null) {
          unsetObject();
        } else {
          setObject((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return getName();

      case NOTE_ID:
        return getNoteId();

      case PARAGRAPH_ID:
        return getParagraphId();

      case OBJECT:
        return getObject();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return isSetName();
      case NOTE_ID:
        return isSetNoteId();
      case PARAGRAPH_ID:
        return isSetParagraphId();
      case OBJECT:
        return isSetObject();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof angularObjectAdd_args)
        return this.equals((angularObjectAdd_args)that);
      return false;
    }

    public boolean equals(angularObjectAdd_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.isSetName();
      boolean that_present_name = true && that.isSetName();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_paragraphId = true && this.isSetParagraphId();
      boolean that_present_paragraphId = true && that.isSetParagraphId();
      if (this_present_paragraphId || that_present_paragraphId) {
        if (!(this_present_paragraphId && that_present_paragraphId))
          return false;
        if (!this.paragraphId.equals(that.paragraphId))
          return false;
      }

      boolean this_present_object = true && this.isSetObject();
      boolean that_present_object = true && that.isSetObject();
      if (this_present_object || that_present_object) {
        if (!(this_present_object && that_present_object))
          return false;
        if (!this.object.equals(that.object))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (isSetName());
      list.add(present_name);
      if (present_name)
        list.add(name);

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_paragraphId = true && (isSetParagraphId());
      list.add(present_paragraphId);
      if (present_paragraphId)
        list.add(paragraphId);

      boolean present_object = true && (isSetObject());
      list.add(present_object);
      if (present_object)
        list.add(object);

      return list.hashCode();
    }

    @Override
    public int compareTo(angularObjectAdd_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetName()).compareTo(other.isSetName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetParagraphId()).compareTo(other.isSetParagraphId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetParagraphId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.paragraphId, other.paragraphId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetObject()).compareTo(other.isSetObject());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetObject()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.object, other.object);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("angularObjectAdd_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("paragraphId:");
      if (this.paragraphId == null) {
        sb.append("null");
      } else {
        sb.append(this.paragraphId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("object:");
      if (this.object == null) {
        sb.append("null");
      } else {
        sb.append(this.object);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class angularObjectAdd_argsStandardSchemeFactory implements SchemeFactory {
      public angularObjectAdd_argsStandardScheme getScheme() {
        return new angularObjectAdd_argsStandardScheme();
      }
    }

    private static class angularObjectAdd_argsStandardScheme extends StandardScheme<angularObjectAdd_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, angularObjectAdd_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.setNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // PARAGRAPH_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.paragraphId = iprot.readString();
                struct.setParagraphIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // OBJECT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.object = iprot.readString();
                struct.setObjectIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, angularObjectAdd_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.paragraphId != null) {
          oprot.writeFieldBegin(PARAGRAPH_ID_FIELD_DESC);
          oprot.writeString(struct.paragraphId);
          oprot.writeFieldEnd();
        }
        if (struct.object != null) {
          oprot.writeFieldBegin(OBJECT_FIELD_DESC);
          oprot.writeString(struct.object);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class angularObjectAdd_argsTupleSchemeFactory implements SchemeFactory {
      public angularObjectAdd_argsTupleScheme getScheme() {
        return new angularObjectAdd_argsTupleScheme();
      }
    }

    private static class angularObjectAdd_argsTupleScheme extends TupleScheme<angularObjectAdd_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, angularObjectAdd_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetName()) {
          optionals.set(0);
        }
        if (struct.isSetNoteId()) {
          optionals.set(1);
        }
        if (struct.isSetParagraphId()) {
          optionals.set(2);
        }
        if (struct.isSetObject()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetName()) {
          oprot.writeString(struct.name);
        }
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetParagraphId()) {
          oprot.writeString(struct.paragraphId);
        }
        if (struct.isSetObject()) {
          oprot.writeString(struct.object);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, angularObjectAdd_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.setNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(2)) {
          struct.paragraphId = iprot.readString();
          struct.setParagraphIdIsSet(true);
        }
        if (incoming.get(3)) {
          struct.object = iprot.readString();
          struct.setObjectIsSet(true);
        }
      }
    }

  }

  public static class angularObjectAdd_result implements org.apache.thrift.TBase<angularObjectAdd_result, angularObjectAdd_result._Fields>, java.io.Serializable, Cloneable, Comparable<angularObjectAdd_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("angularObjectAdd_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new angularObjectAdd_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new angularObjectAdd_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(angularObjectAdd_result.class, metaDataMap);
    }

    public angularObjectAdd_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public angularObjectAdd_result(angularObjectAdd_result other) {
    }

    public angularObjectAdd_result deepCopy() {
      return new angularObjectAdd_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof angularObjectAdd_result)
        return this.equals((angularObjectAdd_result)that);
      return false;
    }

    public boolean equals(angularObjectAdd_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(angularObjectAdd_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("angularObjectAdd_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class angularObjectAdd_resultStandardSchemeFactory implements SchemeFactory {
      public angularObjectAdd_resultStandardScheme getScheme() {
        return new angularObjectAdd_resultStandardScheme();
      }
    }

    private static class angularObjectAdd_resultStandardScheme extends StandardScheme<angularObjectAdd_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, angularObjectAdd_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, angularObjectAdd_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class angularObjectAdd_resultTupleSchemeFactory implements SchemeFactory {
      public angularObjectAdd_resultTupleScheme getScheme() {
        return new angularObjectAdd_resultTupleScheme();
      }
    }

    private static class angularObjectAdd_resultTupleScheme extends TupleScheme<angularObjectAdd_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, angularObjectAdd_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, angularObjectAdd_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class angularObjectRemove_args implements org.apache.thrift.TBase<angularObjectRemove_args, angularObjectRemove_args._Fields>, java.io.Serializable, Cloneable, Comparable<angularObjectRemove_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("angularObjectRemove_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField NOTE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("noteId", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField PARAGRAPH_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("paragraphId", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new angularObjectRemove_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new angularObjectRemove_argsTupleSchemeFactory());
    }

    public String name; // required
    public String noteId; // required
    public String paragraphId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NAME((short)1, "name"),
      NOTE_ID((short)2, "noteId"),
      PARAGRAPH_ID((short)3, "paragraphId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          case 2: // NOTE_ID
            return NOTE_ID;
          case 3: // PARAGRAPH_ID
            return PARAGRAPH_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.NOTE_ID, new org.apache.thrift.meta_data.FieldMetaData("noteId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PARAGRAPH_ID, new org.apache.thrift.meta_data.FieldMetaData("paragraphId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(angularObjectRemove_args.class, metaDataMap);
    }

    public angularObjectRemove_args() {
    }

    public angularObjectRemove_args(
      String name,
      String noteId,
      String paragraphId)
    {
      this();
      this.name = name;
      this.noteId = noteId;
      this.paragraphId = paragraphId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public angularObjectRemove_args(angularObjectRemove_args other) {
      if (other.isSetName()) {
        this.name = other.name;
      }
      if (other.isSetNoteId()) {
        this.noteId = other.noteId;
      }
      if (other.isSetParagraphId()) {
        this.paragraphId = other.paragraphId;
      }
    }

    public angularObjectRemove_args deepCopy() {
      return new angularObjectRemove_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
      this.noteId = null;
      this.paragraphId = null;
    }

    public String getName() {
      return this.name;
    }

    public angularObjectRemove_args setName(String name) {
      this.name = name;
      return this;
    }

    public void unsetName() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean isSetName() {
      return this.name != null;
    }

    public void setNameIsSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public String getNoteId() {
      return this.noteId;
    }

    public angularObjectRemove_args setNoteId(String noteId) {
      this.noteId = noteId;
      return this;
    }

    public void unsetNoteId() {
      this.noteId = null;
    }

    /** Returns true if field noteId is set (has been assigned a value) and false otherwise */
    public boolean isSetNoteId() {
      return this.noteId != null;
    }

    public void setNoteIdIsSet(boolean value) {
      if (!value) {
        this.noteId = null;
      }
    }

    public String getParagraphId() {
      return this.paragraphId;
    }

    public angularObjectRemove_args setParagraphId(String paragraphId) {
      this.paragraphId = paragraphId;
      return this;
    }

    public void unsetParagraphId() {
      this.paragraphId = null;
    }

    /** Returns true if field paragraphId is set (has been assigned a value) and false otherwise */
    public boolean isSetParagraphId() {
      return this.paragraphId != null;
    }

    public void setParagraphIdIsSet(boolean value) {
      if (!value) {
        this.paragraphId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unsetName();
        } else {
          setName((String)value);
        }
        break;

      case NOTE_ID:
        if (value == null) {
          unsetNoteId();
        } else {
          setNoteId((String)value);
        }
        break;

      case PARAGRAPH_ID:
        if (value == null) {
          unsetParagraphId();
        } else {
          setParagraphId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return getName();

      case NOTE_ID:
        return getNoteId();

      case PARAGRAPH_ID:
        return getParagraphId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return isSetName();
      case NOTE_ID:
        return isSetNoteId();
      case PARAGRAPH_ID:
        return isSetParagraphId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof angularObjectRemove_args)
        return this.equals((angularObjectRemove_args)that);
      return false;
    }

    public boolean equals(angularObjectRemove_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.isSetName();
      boolean that_present_name = true && that.isSetName();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      boolean this_present_noteId = true && this.isSetNoteId();
      boolean that_present_noteId = true && that.isSetNoteId();
      if (this_present_noteId || that_present_noteId) {
        if (!(this_present_noteId && that_present_noteId))
          return false;
        if (!this.noteId.equals(that.noteId))
          return false;
      }

      boolean this_present_paragraphId = true && this.isSetParagraphId();
      boolean that_present_paragraphId = true && that.isSetParagraphId();
      if (this_present_paragraphId || that_present_paragraphId) {
        if (!(this_present_paragraphId && that_present_paragraphId))
          return false;
        if (!this.paragraphId.equals(that.paragraphId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_name = true && (isSetName());
      list.add(present_name);
      if (present_name)
        list.add(name);

      boolean present_noteId = true && (isSetNoteId());
      list.add(present_noteId);
      if (present_noteId)
        list.add(noteId);

      boolean present_paragraphId = true && (isSetParagraphId());
      list.add(present_paragraphId);
      if (present_paragraphId)
        list.add(paragraphId);

      return list.hashCode();
    }

    @Override
    public int compareTo(angularObjectRemove_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetName()).compareTo(other.isSetName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, other.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNoteId()).compareTo(other.isSetNoteId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNoteId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.noteId, other.noteId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetParagraphId()).compareTo(other.isSetParagraphId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetParagraphId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.paragraphId, other.paragraphId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("angularObjectRemove_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("noteId:");
      if (this.noteId == null) {
        sb.append("null");
      } else {
        sb.append(this.noteId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("paragraphId:");
      if (this.paragraphId == null) {
        sb.append("null");
      } else {
        sb.append(this.paragraphId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class angularObjectRemove_argsStandardSchemeFactory implements SchemeFactory {
      public angularObjectRemove_argsStandardScheme getScheme() {
        return new angularObjectRemove_argsStandardScheme();
      }
    }

    private static class angularObjectRemove_argsStandardScheme extends StandardScheme<angularObjectRemove_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, angularObjectRemove_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.setNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // NOTE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.noteId = iprot.readString();
                struct.setNoteIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // PARAGRAPH_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.paragraphId = iprot.readString();
                struct.setParagraphIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, angularObjectRemove_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        if (struct.noteId != null) {
          oprot.writeFieldBegin(NOTE_ID_FIELD_DESC);
          oprot.writeString(struct.noteId);
          oprot.writeFieldEnd();
        }
        if (struct.paragraphId != null) {
          oprot.writeFieldBegin(PARAGRAPH_ID_FIELD_DESC);
          oprot.writeString(struct.paragraphId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class angularObjectRemove_argsTupleSchemeFactory implements SchemeFactory {
      public angularObjectRemove_argsTupleScheme getScheme() {
        return new angularObjectRemove_argsTupleScheme();
      }
    }

    private static class angularObjectRemove_argsTupleScheme extends TupleScheme<angularObjectRemove_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, angularObjectRemove_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetName()) {
          optionals.set(0);
        }
        if (struct.isSetNoteId()) {
          optionals.set(1);
        }
        if (struct.isSetParagraphId()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetName()) {
          oprot.writeString(struct.name);
        }
        if (struct.isSetNoteId()) {
          oprot.writeString(struct.noteId);
        }
        if (struct.isSetParagraphId()) {
          oprot.writeString(struct.paragraphId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, angularObjectRemove_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.setNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.noteId = iprot.readString();
          struct.setNoteIdIsSet(true);
        }
        if (incoming.get(2)) {
          struct.paragraphId = iprot.readString();
          struct.setParagraphIdIsSet(true);
        }
      }
    }

  }

  public static class angularObjectRemove_result implements org.apache.thrift.TBase<angularObjectRemove_result, angularObjectRemove_result._Fields>, java.io.Serializable, Cloneable, Comparable<angularObjectRemove_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("angularObjectRemove_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new angularObjectRemove_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new angularObjectRemove_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(angularObjectRemove_result.class, metaDataMap);
    }

    public angularObjectRemove_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public angularObjectRemove_result(angularObjectRemove_result other) {
    }

    public angularObjectRemove_result deepCopy() {
      return new angularObjectRemove_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof angularObjectRemove_result)
        return this.equals((angularObjectRemove_result)that);
      return false;
    }

    public boolean equals(angularObjectRemove_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(angularObjectRemove_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("angularObjectRemove_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class angularObjectRemove_resultStandardSchemeFactory implements SchemeFactory {
      public angularObjectRemove_resultStandardScheme getScheme() {
        return new angularObjectRemove_resultStandardScheme();
      }
    }

    private static class angularObjectRemove_resultStandardScheme extends StandardScheme<angularObjectRemove_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, angularObjectRemove_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, angularObjectRemove_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class angularObjectRemove_resultTupleSchemeFactory implements SchemeFactory {
      public angularObjectRemove_resultTupleScheme getScheme() {
        return new angularObjectRemove_resultTupleScheme();
      }
    }

    private static class angularObjectRemove_resultTupleScheme extends TupleScheme<angularObjectRemove_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, angularObjectRemove_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, angularObjectRemove_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class angularRegistryPush_args implements org.apache.thrift.TBase<angularRegistryPush_args, angularRegistryPush_args._Fields>, java.io.Serializable, Cloneable, Comparable<angularRegistryPush_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("angularRegistryPush_args");

    private static final org.apache.thrift.protocol.TField REGISTRY_FIELD_DESC = new org.apache.thrift.protocol.TField("registry", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new angularRegistryPush_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new angularRegistryPush_argsTupleSchemeFactory());
    }

    public String registry; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      REGISTRY((short)1, "registry");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // REGISTRY
            return REGISTRY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.REGISTRY, new org.apache.thrift.meta_data.FieldMetaData("registry", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(angularRegistryPush_args.class, metaDataMap);
    }

    public angularRegistryPush_args() {
    }

    public angularRegistryPush_args(
      String registry)
    {
      this();
      this.registry = registry;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public angularRegistryPush_args(angularRegistryPush_args other) {
      if (other.isSetRegistry()) {
        this.registry = other.registry;
      }
    }

    public angularRegistryPush_args deepCopy() {
      return new angularRegistryPush_args(this);
    }

    @Override
    public void clear() {
      this.registry = null;
    }

    public String getRegistry() {
      return this.registry;
    }

    public angularRegistryPush_args setRegistry(String registry) {
      this.registry = registry;
      return this;
    }

    public void unsetRegistry() {
      this.registry = null;
    }

    /** Returns true if field registry is set (has been assigned a value) and false otherwise */
    public boolean isSetRegistry() {
      return this.registry != null;
    }

    public void setRegistryIsSet(boolean value) {
      if (!value) {
        this.registry = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case REGISTRY:
        if (value == null) {
          unsetRegistry();
        } else {
          setRegistry((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case REGISTRY:
        return getRegistry();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case REGISTRY:
        return isSetRegistry();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof angularRegistryPush_args)
        return this.equals((angularRegistryPush_args)that);
      return false;
    }

    public boolean equals(angularRegistryPush_args that) {
      if (that == null)
        return false;

      boolean this_present_registry = true && this.isSetRegistry();
      boolean that_present_registry = true && that.isSetRegistry();
      if (this_present_registry || that_present_registry) {
        if (!(this_present_registry && that_present_registry))
          return false;
        if (!this.registry.equals(that.registry))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_registry = true && (isSetRegistry());
      list.add(present_registry);
      if (present_registry)
        list.add(registry);

      return list.hashCode();
    }

    @Override
    public int compareTo(angularRegistryPush_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetRegistry()).compareTo(other.isSetRegistry());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRegistry()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.registry, other.registry);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("angularRegistryPush_args(");
      boolean first = true;

      sb.append("registry:");
      if (this.registry == null) {
        sb.append("null");
      } else {
        sb.append(this.registry);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class angularRegistryPush_argsStandardSchemeFactory implements SchemeFactory {
      public angularRegistryPush_argsStandardScheme getScheme() {
        return new angularRegistryPush_argsStandardScheme();
      }
    }

    private static class angularRegistryPush_argsStandardScheme extends StandardScheme<angularRegistryPush_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, angularRegistryPush_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // REGISTRY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.registry = iprot.readString();
                struct.setRegistryIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, angularRegistryPush_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.registry != null) {
          oprot.writeFieldBegin(REGISTRY_FIELD_DESC);
          oprot.writeString(struct.registry);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class angularRegistryPush_argsTupleSchemeFactory implements SchemeFactory {
      public angularRegistryPush_argsTupleScheme getScheme() {
        return new angularRegistryPush_argsTupleScheme();
      }
    }

    private static class angularRegistryPush_argsTupleScheme extends TupleScheme<angularRegistryPush_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, angularRegistryPush_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetRegistry()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetRegistry()) {
          oprot.writeString(struct.registry);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, angularRegistryPush_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.registry = iprot.readString();
          struct.setRegistryIsSet(true);
        }
      }
    }

  }

  public static class angularRegistryPush_result implements org.apache.thrift.TBase<angularRegistryPush_result, angularRegistryPush_result._Fields>, java.io.Serializable, Cloneable, Comparable<angularRegistryPush_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("angularRegistryPush_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new angularRegistryPush_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new angularRegistryPush_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(angularRegistryPush_result.class, metaDataMap);
    }

    public angularRegistryPush_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public angularRegistryPush_result(angularRegistryPush_result other) {
    }

    public angularRegistryPush_result deepCopy() {
      return new angularRegistryPush_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof angularRegistryPush_result)
        return this.equals((angularRegistryPush_result)that);
      return false;
    }

    public boolean equals(angularRegistryPush_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(angularRegistryPush_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("angularRegistryPush_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class angularRegistryPush_resultStandardSchemeFactory implements SchemeFactory {
      public angularRegistryPush_resultStandardScheme getScheme() {
        return new angularRegistryPush_resultStandardScheme();
      }
    }

    private static class angularRegistryPush_resultStandardScheme extends StandardScheme<angularRegistryPush_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, angularRegistryPush_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, angularRegistryPush_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class angularRegistryPush_resultTupleSchemeFactory implements SchemeFactory {
      public angularRegistryPush_resultTupleScheme getScheme() {
        return new angularRegistryPush_resultTupleScheme();
      }
    }

    private static class angularRegistryPush_resultTupleScheme extends TupleScheme<angularRegistryPush_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, angularRegistryPush_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, angularRegistryPush_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

}
