---
layout: page
title: "How to contribute"
description: "How to contribute"
group: development
---

# Contributing to Apache Zeppelin ( Code )

<div id="toc"></div>

> **NOTE :** Apache Zeppelin is an [Apache2 License](http://www.apache.org/licenses/LICENSE-2.0.html) Software.
Any contributions to Zeppelin (Source code, Documents, Image, Website) means you agree with license all your contributions as Apache2 License.

## Setting up
Here are some tools you will need to build and test Zeppelin.

#### Software Configuration Management ( SCM )

Since Zeppelin uses Git for it's SCM system, you need git client installed in your development machine.

#### Integrated Development Environment ( IDE )

You are free to use whatever IDE you prefer, or your favorite command line editor.

#### Build Tools

To build the code, install

  * Oracle Java 7
  * Apache Maven

## Getting the source code
First of all, you need Zeppelin source code. The official location of Zeppelin is [http://git.apache.org/zeppelin.git](http://git.apache.org/zeppelin.git).

### git access

Get the source code on your development machine using git.

```
git clone git://git.apache.org/zeppelin.git zeppelin
```

You may also want to develop against a specific branch. For example, for branch-0.5.6

```
git clone -b branch-0.5.6 git://git.apache.org/zeppelin.git zeppelin
```

Apache Zeppelin follows [Fork & Pull](https://github.com/sevntu-checkstyle/sevntu.checkstyle/wiki/Development-workflow-with-Git:-Fork,-Branching,-Commits,-and-Pull-Request) as a source control workflow.
If you want to not only build Zeppelin but also make any changes, then you need to fork [Zeppelin github mirror repository](https://github.com/apache/zeppelin) and make a pull request.

### Build

```
mvn install
```

To skip test

```
mvn install -DskipTests
```

To build with specific spark / hadoop version

```
mvn install -Dspark.version=x.x.x -Dhadoop.version=x.x.x
```

For the further 

### Run Zeppelin server in development mode

```
cd zeppelin-server
HADOOP_HOME=YOUR_HADOOP_HOME JAVA_HOME=YOUR_JAVA_HOME mvn exec:java -Dexec.mainClass="org.apache.zeppelin.server.ZeppelinServer" -Dexec.args=""
```

> **Note:** Make sure you first run ```mvn clean install -DskipTests``` on your zeppelin root directory, otherwise your server build will fail to find the required dependencies in the local repro.

or use daemon script

```
bin/zeppelin-daemon start
```

Server will be run on [http://localhost:8080](http://localhost:8080).

### Generating Thrift Code

Some portions of the Zeppelin code are generated by [Thrift](http://thrift.apache.org). For most Zeppelin changes, you don't need to worry about this. But if you modify any of the Thrift IDL files (e.g. zeppelin-interpreter/src/main/thrift/*.thrift), then you also need to regenerate these files and submit their updated version as part of your patch.

To regenerate the code, install **thrift-0.9.2** and change directory into Zeppelin source directory. and then run following command


```
thrift -out zeppelin-interpreter/src/main/java/ --gen java zeppelin-interpreter/src/main/thrift/RemoteInterpreterService.thrift
```

## Where to Start
You can find issues for <a href="https://issues.apache.org/jira/browse/ZEPPELIN-981?jql=project%20%3D%20ZEPPELIN%20AND%20labels%20in%20(beginner%2C%20newbie)">beginner & newbie</a>

## Stay involved
Contributors should join the Zeppelin mailing lists.

* [dev@zeppelin.apache.org](http://mail-archives.apache.org/mod_mbox/zeppelin-dev/) is for people who want to contribute code to Zeppelin. [subscribe](mailto:dev-subscribe@zeppelin.apache.org?subject=send this email to subscribe), [unsubscribe](mailto:dev-unsubscribe@zeppelin.apache.org?subject=send this email to unsubscribe), [archives](http://mail-archives.apache.org/mod_mbox/zeppelin-dev/)

If you have any issues, create a ticket in [JIRA](https://issues.apache.org/jira/browse/ZEPPELIN).
