/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.tika.example;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Collections;
import java.util.Set;

import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;

import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EncryptedPrescriptionParser extends AbstractParser {

	private static final long serialVersionUID = -7816987249611278541L;

	public void parse(InputStream stream, ContentHandler handler,
			Metadata metadata, ParseContext context) throws IOException,
			SAXException, TikaException {
		try {
			Key key = Pharmacy.getKey();
			Cipher cipher = Cipher.getInstance("RSA");
			cipher.init(Cipher.DECRYPT_MODE, key);
			InputStream decrypted = new CipherInputStream(stream, cipher);

			new PrescriptionParser().parse(decrypted, handler, metadata,
					context);
		} catch (GeneralSecurityException e) {
			throw new TikaException("Unable to decrypt a digital prescription",
					e);
		}
	}

	public Set<MediaType> getSupportedTypes(ParseContext context) {
		return Collections.singleton(MediaType.application("x-prescription"));
	}

}
