# Internationalize your plugin

GitBook has built-in support for internationalization. Plugins can register new languages and provide the right messages for different languages.

### Register locale and messages

The first step is to register messages for a language:

```js
module.exports = GitBook.createPlugin({
    init: (dispatch, getState, { I18n }) => {
        dispatch(I18n.registerLocale('en-US', {
            MY_PLUGIN_MESSAGE: 'Hello World'
        }));
    }
});
```

### Render a message in a component

`GitBook.connect` adds a `i18n` prop to access the internationalization:

```js
const GitBook = require('gitbook-core');
const { React } = GitBook;

const MyButton = React.createClass({
    propTypes: {
        i18n: GitBook.Shapes.i18n
    },

    render() {
        const { i18n } = this.props;

        return (
            <GitBook.Button>
                {i18.t('MY_PLUGIN_MESSAGE')}
            </GitBook.Button>
        );
    }
});

module.exports = GitBook.connect(MyButton);
```
