---
description: tasks.mdで定義されたすべてのタスクを処理・実行して実装計画を実行します
scripts:
  sh: scripts/bash/check-prerequisites.sh --json --require-tasks --include-tasks
  ps: scripts/powershell/check-prerequisites.ps1 -Json -RequireTasks -IncludeTasks
---

ユーザー入力は、エージェントから直接提供されるか、コマンド引数として提供される場合があります - プロンプトに進む前に、必ずこれを考慮してください（空でない場合）。

ユーザー入力:

$ARGUMENTS

1. リポジトリのルートから`{SCRIPT}`を実行し、FEATURE_DIRとAVAILABLE_DOCSリストを解析します。すべてのパスは絶対パスである必要があります。

2. 実装コンテキストを読み込み、分析します:
   - **必須**: tasks.mdから完全なタスクリストと実行計画を読み込む
   - **必須**: plan.mdから技術スタック、アーキテクチャ、ファイル構造を読み込む
   - **存在する場合**: data-model.mdからエンティティと関係を読み込む
   - **存在する場合**: contracts/からAPI仕様とテスト要件を読み込む
   - **存在する場合**: research.mdから技術的決定と制約を読み込む
   - **存在する場合**: quickstart.mdから統合シナリオを読み込む

3. tasks.mdの構造を解析し、以下を抽出します:
   - **タスクフェーズ**: Setup、Tests、Core、Integration、Polish
   - **タスク依存関係**: 順次実行と並列実行のルール
   - **タスク詳細**: ID、説明、ファイルパス、並列マーカー[P]
   - **実行フロー**: 順序と依存関係の要件

4. タスク計画に従って実装を実行します:
   - **フェーズごとの実行**: 次のフェーズに移る前に各フェーズを完了する
   - **依存関係の尊重**: 順次タスクは順番に実行し、並列タスク[P]は同時に実行可能
   - **TDDアプローチに従う**: 対応する実装タスクの前にテストタスクを実行
   - **ファイルベースの協調**: 同じファイルに影響するタスクは順次実行する必要がある
   - **検証チェックポイント**: 次に進む前に各フェーズの完了を確認

5. 実装実行ルール:
   - **セットアップを最初に**: プロジェクト構造、依存関係、設定を初期化
   - **コードの前にテスト**: コントラクト、エンティティ、統合シナリオのテストを記述する必要がある場合
   - **コア開発**: モデル、サービス、CLIコマンド、エンドポイントを実装
   - **統合作業**: データベース接続、ミドルウェア、ログ、外部サービス
   - **仕上げと検証**: ユニットテスト、パフォーマンス最適化、ドキュメント

6. 進捗追跡とエラー処理:
   - 完了したタスクごとに進捗を報告
   - 並列でないタスクが失敗した場合は実行を停止
   - 並列タスク[P]の場合、成功したタスクを継続し、失敗したものを報告
   - デバッグのためのコンテキストを含む明確なエラーメッセージを提供
   - 実装が続行できない場合の次のステップを提案
   - **重要**: 完了したタスクについては、tasksファイルで[X]としてタスクにマークを付けてください

7. 完了の検証:
   - 必要なすべてのタスクが完了していることを確認
   - 実装された機能が元の仕様と一致することを確認
   - テストが通り、カバレッジが要件を満たしていることを検証
   - 実装が技術計画に従っていることを確認
   - 完了した作業の概要とともに最終ステータスを報告

注意: このコマンドは、tasks.mdに完全なタスク分解が存在することを前提としています。タスクが不完全または欠落している場合は、まず`/tasks`を実行してタスクリストを再生成することを提案してください。