# クイックスタートガイド

このガイドでは、Spec Kitを使用したSpec-Driven Development（仕様駆動開発）を始める方法をご紹介します。

> 新機能: すべての自動化スクリプトはBash（`.sh`）とPowerShell（`.ps1`）の両方のバリアントを提供します。`specify` CLIは`--script sh|ps`オプションを指定しない限り、OSに基づいて自動選択します。

## 4ステップのプロセス

### 1. Specifyのインストール

使用するコーディングエージェントに応じてプロジェクトを初期化します：

```bash
uvx --from git+https://github.com/mosugi/spec-kit-ja.git specify init <PROJECT_NAME>
```

スクリプトタイプを明示的に指定する場合（オプション）：
```bash
uvx --from git+https://github.com/mosugi/spec-kit-ja.git specify init <PROJECT_NAME> --script ps  # PowerShellを強制
uvx --from git+https://github.com/mosugi/spec-kit-ja.git specify init <PROJECT_NAME> --script sh  # POSIXシェルを強制
```

### 2. 仕様の作成

`/specify`コマンドを使用して、構築したいものを説明します。技術スタックではなく、**何を**、**なぜ**構築するかに焦点を当ててください。

```bash
/specify 写真を別々のフォトアルバムで整理できるアプリケーションを構築します。アルバムは日付でグループ化され、メインページでドラッグアンドドロップで再整理できます。アルバムは他のネストしたアルバムには含まれません。各アルバム内では、写真はタイル状のインターフェースでプレビューされます。
```

### 3. 技術実装プランの作成

`/plan`コマンドを使用して、技術スタックとアーキテクチャの選択肢を提供します。

```bash
/plan アプリケーションは最小限のライブラリ数でViteを使用します。可能な限りバニラのHTML、CSS、JavaScriptを使用してください。画像はどこにもアップロードされず、メタデータはローカルのSQLiteデータベースに保存されます。
```

### 4. タスクの分割と実装

`/tasks`を使用して実行可能なタスクリストを作成し、エージェントに機能の実装を依頼します。

## 詳細な例：Taskifyの構築

チーム生産性プラットフォームを構築する完全な例をご紹介します：

### ステップ1：`/specify`で要件を定義

```text
チーム生産性プラットフォームであるTaskifyを開発します。ユーザーがプロジェクトを作成し、チームメンバーを追加し、
タスクを割り当て、コメントを付け、Kanban形式でボード間でタスクを移動できるようにします。この機能の初期段階では、
「Create Taskify」と呼びましょう。複数のユーザーがいますが、ユーザーは事前に宣言され、事前定義されています。
2つの異なるカテゴリで5人のユーザーが必要です。1人のプロダクトマネージャーと4人のエンジニアです。3つの
異なるサンプルプロジェクトを作成しましょう。各タスクのステータス用に、「To Do」、
「In Progress」、「In Review」、「Done」などの標準的なKanban列を用意します。これは基本機能が
設定されていることを確認するための最初のテストなので、このアプリケーションにはログインがありません。UI内の各タスクカードについて、
Kanbanワークボード内の異なる列間でタスクの現在のステータスを変更できるようにします。
特定のカードに無制限の数のコメントを残すことができるようにします。そのタスク
カードから、有効なユーザーの1人を割り当てることができるようにします。Taskifyを最初に起動すると、選択する5人のユーザーのリストが
表示されます。パスワードは不要です。ユーザーをクリックすると、プロジェクトのリストを表示するメインビューに移動します。
プロジェクトをクリックすると、そのプロジェクトのKanbanボードが開きます。列が表示されます。
異なる列間でカードをドラッグアンドドロップできます。現在ログインしているユーザーに割り当てられたカードは、
他のすべてのカードとは異なる色で表示され、自分のものを素早く確認できます。自分が作成したコメントは編集できますが、
他の人が作成したコメントは編集できません。自分が作成したコメントは削除できますが、
他の人が作成したコメントは削除できません。
```

### ステップ2：仕様の改善

初期仕様が作成された後、不足している要件を明確にします：

```text
作成する各サンプルプロジェクトまたはプロジェクトには、完了の異なる状態にランダムに配布された
5〜15個のタスクの可変数があるべきです。各完了段階に少なくとも
1つのタスクがあることを確認してください。
```

また、仕様チェックリストを検証します：

```text
レビューと承認のチェックリストを読み、機能仕様が基準を満たしている場合はチェックリストの各項目をチェックしてください。満たしていない場合は空のままにしてください。
```

### ステップ3：`/plan`で技術プランを生成

技術スタックと技術要件について具体的に記述します：

```text
これを.NET Aspireを使用して生成し、データベースとしてPostgresを使用します。フロントエンドは
ドラッグアンドドロップタスクボード、リアルタイム更新を備えたBlazor serverを使用する必要があります。プロジェクトAPI、
タスクAPI、通知APIを使用してREST APIを作成する必要があります。
```

### ステップ4：検証と実装

AIエージェントに実装プランを監査してもらいます：

```text
実装プランと実装詳細ファイルを監査してください。
これを読むことから明らかな、実行する必要のあるタスクのシーケンスがあるかどうかを判断することに重点を置いて
読み通してください。ここに十分な情報があるかわからないためです。
```

最後に、ソリューションを実装します：

```text
implement specs/002-create-taskify/plan.md
```

## 重要な原則

- 何を構築するか、なぜ構築するかを**明確に**する
- 仕様段階では**技術スタックに焦点を当てない**
- 実装前に仕様を**繰り返し改善**する
- コーディング開始前にプランを**検証**する
- 実装の詳細は**AIエージェントに任せる**

## 次のステップ

- 詳細なガイダンスについては、完全な方法論をお読みください
- リポジトリで他の例をご確認ください
- GitHubでソースコードを探索してください
