# タスク: [FEATURE NAME]

**入力**: `/specs/[###-feature-name]/`からの設計文書
**前提条件**: plan.md (必須), research.md, data-model.md, contracts/

## 実行フロー (main)
```
1. 機能ディレクトリからplan.mdを読み込む
   → 見つからない場合: ERROR "実装計画が見つかりません"
   → 抽出: 技術スタック、ライブラリ、構造
2. オプションの設計文書を読み込む:
   → data-model.md: エンティティを抽出 → モデルタスク
   → contracts/: 各ファイル → コントラクトテストタスク
   → research.md: 決定事項を抽出 → セットアップタスク
3. カテゴリ別にタスクを生成:
   → セットアップ: プロジェクト初期化、依存関係、リンティング
   → テスト: コントラクトテスト、統合テスト
   → コア: モデル、サービス、CLIコマンド
   → 統合: DB、ミドルウェア、ログ
   → 仕上げ: ユニットテスト、パフォーマンス、ドキュメント
4. タスクルールを適用:
   → 異なるファイル = 並列用に[P]をマーク
   → 同じファイル = 順次実行 ([P]なし)
   → 実装前にテスト (TDD)
5. タスクを順次番号付け (T001, T002...)
6. 依存関係グラフを生成
7. 並列実行例を作成
8. タスクの完全性を検証:
   → すべてのコントラクトにテストがあるか？
   → すべてのエンティティにモデルがあるか？
   → すべてのエンドポイントが実装されているか？
9. 戻り値: SUCCESS (タスクは実行準備完了)
```

## フォーマット: `[ID] [P?] Description`
- **[P]**: 並列実行可能（異なるファイル、依存関係なし）
- 説明に正確なファイルパスを含める

## パス規約
- **単一プロジェクト**: リポジトリルートに `src/`, `tests/`
- **Webアプリ**: `backend/src/`, `frontend/src/`
- **モバイル**: `api/src/`, `ios/src/` または `android/src/`
- 下記のパスは単一プロジェクトを想定 - plan.mdの構造に応じて調整

## フェーズ3.1: セットアップ
- [ ] T001 実装計画に従ってプロジェクト構造を作成
- [ ] T002 [framework]依存関係で[language]プロジェクトを初期化
- [ ] T003 [P] リンティングとフォーマットツールを設定

## フェーズ3.2: テストファースト (TDD) ⚠️ 3.3前に必ず完了
**重要: これらのテストは、いかなる実装よりも前に作成され、必ず失敗しなければならない**
- [ ] T004 [P] tests/contract/test_users_post.pyでPOST /api/usersのコントラクトテスト
- [ ] T005 [P] tests/contract/test_users_get.pyでGET /api/users/{id}のコントラクトテスト
- [ ] T006 [P] tests/integration/test_registration.pyでユーザー登録の統合テスト
- [ ] T007 [P] tests/integration/test_auth.pyで認証フローの統合テスト

## フェーズ3.3: コア実装（テストが失敗した後のみ）
- [ ] T008 [P] src/models/user.pyのUserモデル
- [ ] T009 [P] src/services/user_service.pyのUserService CRUD
- [ ] T010 [P] src/cli/user_commands.pyのCLI --create-user
- [ ] T011 POST /api/usersエンドポイント
- [ ] T012 GET /api/users/{id}エンドポイント
- [ ] T013 入力検証
- [ ] T014 エラーハンドリングとログ

## フェーズ3.4: 統合
- [ ] T015 UserServiceをDBに接続
- [ ] T016 認証ミドルウェア
- [ ] T017 リクエスト/レスポンスログ
- [ ] T018 CORSとセキュリティヘッダー

## フェーズ3.5: 仕上げ
- [ ] T019 [P] tests/unit/test_validation.pyで検証用ユニットテスト
- [ ] T020 パフォーマンステスト (<200ms)
- [ ] T021 [P] docs/api.mdを更新
- [ ] T022 重複を削除
- [ ] T023 manual-testing.mdを実行

## 依存関係
- 実装 (T008-T014) 前にテスト (T004-T007)
- T008がT009, T015をブロック
- T016がT018をブロック
- 仕上げ (T019-T023) 前に実装

## 並列実行例
```
# T004-T007を同時に起動:
Task: "tests/contract/test_users_post.pyでPOST /api/usersのコントラクトテスト"
Task: "tests/contract/test_users_get.pyでGET /api/users/{id}のコントラクトテスト"
Task: "tests/integration/test_registration.pyで登録の統合テスト"
Task: "tests/integration/test_auth.pyで認証の統合テスト"
```

## 注意点
- [P]タスク = 異なるファイル、依存関係なし
- 実装前にテストが失敗することを確認
- 各タスク後にコミット
- 避けるべき: 曖昧なタスク、同一ファイルの競合

## タスク生成ルール
*main()実行中に適用される*

1. **コントラクトから**:
   - 各コントラクトファイル → コントラクトテストタスク [P]
   - 各エンドポイント → 実装タスク

2. **データモデルから**:
   - 各エンティティ → モデル作成タスク [P]
   - 関係 → サービスレイヤータスク

3. **ユーザーストーリーから**:
   - 各ストーリー → 統合テスト [P]
   - クイックスタートシナリオ → 検証タスク

4. **順序**:
   - セットアップ → テスト → モデル → サービス → エンドポイント → 仕上げ
   - 依存関係が並列実行をブロック

## 検証チェックリスト
*GATE: 戻り値前にmain()でチェックされる*

- [ ] すべてのコントラクトに対応するテストがある
- [ ] すべてのエンティティにモデルタスクがある
- [ ] すべてのテストが実装よりも前に来る
- [ ] 並列タスクが真に独立している
- [ ] 各タスクが正確なファイルパスを指定している
- [ ] 他の[P]タスクと同じファイルを変更するタスクがない