---
description: タスク生成後にspec.md、plan.md、tasks.mdの3つのコア成果物間で非破壊的な一貫性と品質分析を実行します。
scripts:
  sh: scripts/bash/check-prerequisites.sh --json --require-tasks --include-tasks
  ps: scripts/powershell/check-prerequisites.ps1 -Json -RequireTasks -IncludeTasks
---

ユーザーの入力は、エージェントから直接提供される場合もコマンド引数として提供される場合もあります。プロンプトを進める前に**必ず**それを考慮してください（空でない場合）。

ユーザー入力：

$ARGUMENTS

目標：実装前に3つのコア成果物（`spec.md`、`plan.md`、`tasks.md`）間の不整合、重複、曖昧さ、仕様不足項目を特定します。このコマンドは`/tasks`が完全な`tasks.md`を正常に生成した後にのみ実行する必要があります。

厳格に読み取り専用：ファイルを**変更しない**でください。構造化された分析レポートを出力してください。任意の修正計画を提案してください（ユーザーが明示的に承認してから、手動でフォローアップ編集コマンドを呼び出すことになります）。

憲法の権威：プロジェクト憲法（`/memory/constitution.md`）はこの分析スコープ内で**交渉不可能**です。憲法との衝突は自動的にCRITICALとなり、仕様、計画、またはタスクの調整が必要です—原則の希釈、再解釈、または黙認は行いません。原則そのものが変更を必要とする場合、それは`/analyze`の外で別個の明示的な憲法更新で行わなければなりません。

実行手順：

1. リポジトリルートから`{SCRIPT}`を一度実行し、FEATURE_DIRとAVAILABLE_DOCSのJSONを解析します。絶対パスを導出してください：
   - SPEC = FEATURE_DIR/spec.md
   - PLAN = FEATURE_DIR/plan.md
   - TASKS = FEATURE_DIR/tasks.md
   必要なファイルが不足している場合は、エラーメッセージを表示して中止してください（不足している前提条件コマンドを実行するようユーザーに指示してください）。

2. 成果物を読み込みます：
   - spec.mdのセクションを解析：概要/コンテキスト、機能要件、非機能要件、ユーザーストーリー、エッジケース（存在する場合）。
   - plan.mdを解析：アーキテクチャ/スタック選択、データモデル参照、フェーズ、技術的制約。
   - tasks.mdを解析：タスクID、説明、フェーズグループ化、並列マーカー[P]、参照ファイルパス。
   - 原則検証のために憲法`/memory/constitution.md`を読み込みます。

3. 内部セマンティックモデルを構築します：
   - 要件インベントリ：各機能要件・非機能要件に安定したキー（命令句に基づくスラグを導出。例：「ユーザーはファイルをアップロードできる」→`user-can-upload-file`）。
   - ユーザーストーリー/アクション インベントリ。
   - タスクカバレッジマッピング：各タスクを1つ以上の要件またはストーリーにマッピング（キーワード/IDまたはキーフレーズなどの明示的参照パターンによる推論）。
   - 憲法ルールセット：原則名と任意のMUST/SHOULD規範的記述を抽出。

4. 検出パス：
   A. 重複検出：
      - ほぼ重複する要件を特定します。統合対象として品質の低い表現にマークを付けます。
   B. 曖昧さ検出：
      - 測定可能な基準を欠く曖昧な形容詞（高速、スケーラブル、セキュア、直感的、堅牢）にフラグを立てます。
      - 未解決のプレースホルダー（TODO、TKTK、???、<placeholder>など）にフラグを立てます。
   C. 仕様不足：
      - 動詞はあるが目的語や測定可能な結果が不足している要件。
      - 受入基準の整合性が欠如したユーザーストーリー。
      - 仕様/計画で定義されていないファイルやコンポーネントを参照するタスク。
   D. 憲法との整合性：
      - MUST原則と衝突する任意の要件または計画要素。
      - 憲法で義務付けられたセクションや品質ゲートの不足。
   E. カバレッジギャップ：
      - 関連するタスクがゼロの要件。
      - マッピングされた要件/ストーリーがないタスク。
      - タスクに反映されていない非機能要件（パフォーマンス、セキュリティなど）。
   F. 不整合：
      - 用語の漂流（同じ概念がファイル間で異なる名前で呼ばれている）。
      - 計画では参照されているが仕様では不在のデータエンティティ（またはその逆）。
      - タスク順序の矛盾（依存関係の注記なしに、基礎セットアップタスクより前に統合タスクが配置されているなど）。
      - 衝突する要件（一つはNext.jsの使用を要求し、別のものはフレームワークとしてVueの使用を指定しているなど）。

5. 重要度割り当てヒューリスティック：
   - CRITICAL：憲法のMUSTに違反、コア仕様成果物の不足、またはベースライン機能をブロックするカバレッジゼロの要件。
   - HIGH：重複または競合する要件、曖昧なセキュリティ/パフォーマンス属性、テスト不可能な受入基準。
   - MEDIUM：用語の漂流、非機能タスクカバレッジの不足、仕様不足のエッジケース。
   - LOW：スタイル/文言改善、実行順序に影響しない軽微な冗長性。

6. セクション付きのMarkdownレポートを生成します（ファイル書き込みなし）：

   ### 仕様分析レポート
   | ID | カテゴリ | 重要度 | 場所 | 概要 | 推奨事項 |
   |----|----------|----------|-------------|---------|----------------|
   | A1 | 重複 | HIGH | spec.md:L120-134 | 2つの類似した要件... | 表現を統合、より明確なバージョンを保持 |
   （発見ごとに1行追加、カテゴリの頭文字をプレフィックスとした安定したIDを生成。）

   追加サブセクション：
   - カバレッジ概要テーブル：
     | 要件キー | タスクあり？ | タスクID | 備考 |
   - 憲法整合性問題（存在する場合）
   - マッピングされていないタスク（存在する場合）
   - メトリクス：
     * 要件総数
     * タスク総数
     * カバレッジ率（>=1タスクがある要件）
     * 曖昧さ数
     * 重複数
     * クリティカル問題数

7. レポートの最後に、簡潔な次のアクションブロックを出力します：
   - CRITICAL問題が存在する場合：`/implement`の前に解決することを推奨。
   - LOW/MEDIUMのみの場合：ユーザーは進めることができますが、改善提案を提供。
   - 明示的なコマンド提案を提供：例：「改良を加えて/specifyを実行」、「アーキテクチャ調整のため/planを実行」、「'performance-metrics'のカバレッジを追加するためtasks.mdを手動編集」。

8. ユーザーに質問します：「上位N個の問題について具体的な修正編集を提案しますか？」（自動的には適用しないでください。）

動作ルール：
- ファイルを変更しないでください。
- 存在しないセクションを捏造しないでください—不在の場合はそれを報告してください。
- 発見を決定論的に保持：変更なしに再実行した場合、一貫したIDと数を生成します。
- メインテーブルの総発見数を50に制限、残りは要約されたオーバーフロー注記に集約。
- ゼロ問題が発見された場合、カバレッジ統計と進行推奨を含む成功レポートを出力。

コンテキスト：{ARGS}
