---
description: 利用可能な設計成果物に基づいて、機能のための実行可能で依存関係が整理されたtasks.mdを生成します。
scripts:
  sh: scripts/bash/check-prerequisites.sh --json
  ps: scripts/powershell/check-prerequisites.ps1 -Json
---

ユーザー入力は、エージェントから直接または コマンド引数として提供される場合があります - プロンプトに進む前に（空でない場合）**必ず**考慮してください。

ユーザー入力:

$ARGUMENTS

1. リポジトリルートから`{SCRIPT}`を実行し、FEATURE_DIRとAVAILABLE_DOCSリストを解析します。すべてのパスは絶対パスである必要があります。
2. 利用可能な設計ドキュメントを読み込んで分析します:
   - 技術スタックとライブラリについて必ずplan.mdを読む
   - 存在する場合: エンティティについてdata-model.mdを読む
   - 存在する場合: APIエンドポイントについてcontracts/を読む
   - 存在する場合: 技術的決定についてresearch.mdを読む
   - 存在する場合: テストシナリオについてquickstart.mdを読む

   注意: すべてのプロジェクトにすべてのドキュメントがあるわけではありません。例：
   - CLIツールにはcontracts/がない場合があります
   - シンプルなライブラリにはdata-model.mdが不要な場合があります
   - 利用可能なものに基づいてタスクを生成してください

3. テンプレートに従ってタスクを生成します:
   - `/templates/tasks-template.md`をベースとして使用
   - 例のタスクを以下に基づく実際のタスクに置き換える:
     * **セットアップタスク**: プロジェクト初期化、依存関係、リンティング
     * **テストタスク [P]**: 契約ごとに1つ、統合シナリオごとに1つ
     * **コアタスク**: エンティティ、サービス、CLIコマンド、エンドポイントごとに1つ
     * **統合タスク**: DB接続、ミドルウェア、ログ
     * **ポリッシュタスク [P]**: 単体テスト、パフォーマンス、ドキュメント

4. タスク生成ルール:
   - 各契約ファイル → [P]マークの契約テストタスク
   - data-model内の各エンティティ → [P]マークのモデル作成タスク
   - 各エンドポイント → 実装タスク（共有ファイルの場合は並列不可）
   - 各ユーザーストーリー → [P]マークの統合テスト
   - 異なるファイル = 並列可能 [P]
   - 同じファイル = 順次実行 ([P]なし)

5. 依存関係順でタスクを並べます:
   - セットアップがすべてより前
   - テストが実装より前 (TDD)
   - モデルがサービスより前
   - サービスがエンドポイントより前
   - コアが統合より前
   - すべてがポリッシュより前

6. 並列実行例を含める:
   - 一緒に実行できる[P]タスクをグループ化
   - 実際のTaskエージェントコマンドを表示

7. 以下を含むFEATURE_DIR/tasks.mdを作成:
   - 実装計画からの正しい機能名
   - 番号付きタスク (T001, T002など)
   - 各タスクの明確なファイルパス
   - 依存関係の注記
   - 並列実行ガイダンス

タスク生成のコンテキスト: {ARGS}

tasks.mdは即座に実行可能である必要があります - 各タスクはLLMが追加のコンテキストなしに完了できるほど具体的である必要があります。
