# 機能仕様書: [FEATURE NAME]

**機能ブランチ**: `[###-feature-name]`
**作成日**: [DATE]
**ステータス**: ドラフト
**入力**: ユーザー記述: "$ARGUMENTS"

## 実行フロー (main)
```
1. 入力からユーザー記述をパースする
   → 空の場合: ERROR "機能説明が提供されていません"
2. 記述から主要概念を抽出する
   → 識別項目: アクター、アクション、データ、制約
3. 不明確な側面ごとに:
   → [NEEDS CLARIFICATION: 具体的な質問] でマークする
4. ユーザーシナリオとテストセクションを記入する
   → ユーザーフローが不明確な場合: ERROR "ユーザーシナリオを決定できません"
5. 機能要件を生成する
   → 各要件はテスト可能でなければならない
   → 曖昧な要件をマークする
6. 主要エンティティを識別する（データが関与する場合）
7. レビューチェックリストを実行する
   → [NEEDS CLARIFICATION]がある場合: WARN "仕様に不明確な部分があります"
   → 実装詳細が見つかった場合: ERROR "技術詳細を削除してください"
8. 戻り値: SUCCESS（仕様は計画段階の準備完了）
```

---

## ⚡ クイックガイドライン
- ✅ ユーザーが何を必要とし、なぜ必要かに焦点を当てる
- ❌ 実装方法を避ける（技術スタック、API、コード構造なし）
- 👥 開発者ではなく、ビジネス関係者向けに記述する

### セクション要件
- **必須セクション**: すべての機能で完成させる必要がある
- **オプションセクション**: 機能に関連する場合のみ含める
- セクションが該当しない場合は、完全に削除する（"N/A"として残さない）

### AI生成用
ユーザープロンプトからこの仕様を作成する際は:
1. **すべての曖昧さをマーク**: 推測が必要な場合は [NEEDS CLARIFICATION: 具体的な質問] を使用する
2. **推測しない**: プロンプトで指定されていないもの（例：認証方法が指定されていない「ログインシステム」）があれば、マークする
3. **テスターのように考える**: 曖昧な要件は「テスト可能で明確」チェックリスト項目に失格となるべき
4. **一般的に不足している仕様領域**:
   - ユーザータイプと権限
   - データ保持/削除ポリシー
   - パフォーマンス目標と規模
   - エラーハンドリング動作
   - 統合要件
   - セキュリティ/コンプライアンスニーズ

---

## ユーザーシナリオとテスト *(必須)*

### 主要ユーザーストーリー
[メインのユーザージャーニーを平易な言葉で記述する]

### 受け入れシナリオ
1. **前提** [初期状態], **実行** [アクション], **結果** [期待される結果]
2. **前提** [初期状態], **実行** [アクション], **結果** [期待される結果]

### エッジケース
- [境界条件]の場合、何が起こるか？
- システムは[エラーシナリオ]をどのように処理するか？

## 要件 *(必須)*

### 機能要件
- **FR-001**: システムは[具体的な機能、例：「ユーザーがアカウントを作成できること」]を実現しなければならない
- **FR-002**: システムは[具体的な機能、例：「メールアドレスを検証すること」]を実現しなければならない
- **FR-003**: ユーザーは[重要なインタラクション、例：「パスワードをリセットできること」]を実行できなければならない
- **FR-004**: システムは[データ要件、例：「ユーザー設定を保持すること」]を実現しなければならない
- **FR-005**: システムは[動作、例：「すべてのセキュリティイベントをログに記録すること」]を実現しなければならない

*不明確な要件をマークする例:*
- **FR-006**: システムは[NEEDS CLARIFICATION: 認証方法が指定されていない - メール/パスワード、SSO、OAuth？]によってユーザーを認証しなければならない
- **FR-007**: システムは[NEEDS CLARIFICATION: 保持期間が指定されていない]の間、ユーザーデータを保持しなければならない

### 主要エンティティ *(機能にデータが関わる場合に含める)*
- **[エンティティ1]**: [何を表すか、実装を除く主要な属性]
- **[エンティティ2]**: [何を表すか、他のエンティティとの関係]

---

## レビューと受け入れチェックリスト
*GATE: main()実行中に自動チェックが実行される*

### コンテンツ品質
- [ ] 実装詳細なし（言語、フレームワーク、API）
- [ ] ユーザー価値とビジネスニーズに焦点を当てている
- [ ] 非技術系の関係者向けに記述されている
- [ ] すべての必須セクションが完了している

### 要件の完全性
- [ ] [NEEDS CLARIFICATION]マーカーが残っていない
- [ ] 要件がテスト可能で明確である
- [ ] 成功基準が測定可能である
- [ ] 範囲が明確に境界づけられている
- [ ] 依存関係と前提条件が特定されている

---

## 実行ステータス
*処理中にmain()によって更新される*

- [ ] ユーザー記述がパースされた
- [ ] 主要概念が抽出された
- [ ] 曖昧さがマークされた
- [ ] ユーザーシナリオが定義された
- [ ] 要件が生成された
- [ ] エンティティが特定された
- [ ] レビューチェックリストが通過した

---
