---
description: 現在の機能仕様書内の不十分に定義された領域を特定し、最大5つの高度にターゲット化された明確化質問を行い、回答を仕様書に記録します。
scripts:
   sh: scripts/bash/check-prerequisites.sh --json --paths-only
   ps: scripts/powershell/check-prerequisites.ps1 -Json -PathsOnly
---

ユーザー入力は、エージェントから直接提供されるか、コマンド引数として提供される場合があります - プロンプトを進める前に（空でない場合は）**必ず**考慮してください。

ユーザー入力：

$ARGUMENTS

目標：アクティブな機能仕様における曖昧性や不足している決定点を検出・削減し、明確化を仕様ファイルに直接記録します。

注記：この明確化ワークフローは `/plan` を実行する前に実行され（完了される）ることが期待されています。ユーザーが明確化をスキップすると明示的に述べている場合（例：探索的スパイク）、進めることができますが、下流での再作業リスクが増加することを警告する必要があります。

実行ステップ：

1. リポジトリのルートから `{SCRIPT}` を**一度**実行します（`--json --paths-only` モード / `-Json -PathsOnly` を組み合わせ）。最小限のJSONペイロードフィールドをパースします：
   - `FEATURE_DIR`
   - `FEATURE_SPEC`
   - （将来の連鎖フローのために、オプションで `IMPL_PLAN`、`TASKS` をキャプチャ）
   - JSONパースが失敗した場合は、中止してユーザーに `/specify` を再実行するか、機能ブランチ環境を確認するよう指示します。

2. 現在の仕様ファイルを読み込みます。この分類法を使用して構造化された曖昧性とカバレッジスキャンを実行します。各カテゴリについて、ステータスをマークします：明確 / 部分的 / 欠落。優先順位付けに使用される内部カバレッジマップを作成します（質問がない場合を除き、生のマップを出力しません）。

   機能スコープと動作：
   - コアユーザーゴールと成功基準
   - 明示的なスコープ外宣言
   - ユーザーロール/ペルソナの区別

   ドメインとデータモデル：
   - エンティティ、属性、関係
   - 識別と一意性のルール
   - ライフサイクル/状態遷移
   - データ量/スケール前提条件

   インタラクションとUXフロー：
   - 重要なユーザージャーニー/シーケンス
   - エラー/空/ローディング状態
   - アクセシビリティまたはローカライゼーション注記

   非機能的品質属性：
   - パフォーマンス（レイテンシー、スループット目標）
   - スケーラビリティ（水平/垂直、制限）
   - 信頼性と可用性（稼働時間、復旧期待値）
   - 観測可能性（ログ、メトリクス、トレーシング信号）
   - セキュリティとプライバシー（認証/認可、データ保護、脅威前提条件）
   - コンプライアンス/規制制約（該当する場合）

   統合と外部依存関係：
   - 外部サービス/APIと故障モード
   - データインポート/エクスポート形式
   - プロトコル/バージョニング前提条件

   エッジケースと故障処理：
   - ネガティブシナリオ
   - レート制限/スロットリング
   - 競合解決（例：同時編集）

   制約とトレードオフ：
   - 技術的制約（言語、ストレージ、ホスティング）
   - 明示的なトレードオフや却下された代替案

   用語と一貫性：
   - 正規用語集用語
   - 避けるべき同義語/非推奨用語

   完了シグナル：
   - 受入基準のテスト可能性
   - 測定可能なDefinition of Doneスタイル指標

   その他/プレースホルダー：
   - TODOマーカー/未解決の決定
   - 定量化が不足している曖昧な形容詞（「堅牢」、「直感的」）

   部分的または欠落ステータスの各カテゴリについて、候補質問機会を追加します。ただし以下の場合は除きます：
   - 明確化が実装や検証戦略に実質的な変更をもたらさない場合
   - 情報が計画フェーズに延期される方が良い場合（内部的にメモ）

3. （内部的に）候補明確化質問の優先順位付けキューを生成します（最大5つ）。一度にすべてを出力しないでください。これらの制約を適用します：
    - セッション全体で最大5つの質問まで。
    - 各質問は以下のいずれかで回答可能である必要があります：
       * 短い多択選択（2-5の明確で相互排他的なオプション）、または
       * 一語/短いフレーズ回答（明示的に制約：「5語以内で回答」）。
   - アーキテクチャ、データモデリング、タスク分解、テスト設計、UX動作、運用準備、またはコンプライアンス検証に実質的な影響を与える回答のみの質問を含めます。
   - カテゴリカバレッジバランスを確保：最初に最も影響の大きい未解決カテゴリをカバーすることを試み、単一の高影響領域（例：セキュリティ姿勢）が未解決の時に2つの低影響質問を避けます。
   - すでに回答済みの質問、些細なスタイル的好み、または計画レベルの実行詳細を除外します（正確性を阻害する場合を除く）。
   - 下流での再作業リスクを軽減するか、整合性のない受入テストを防ぐ明確化を優先します。
   - 5つ以上のカテゴリが未解決のままの場合、（影響 * 不確実性）ヒューリスティックで上位5つを選択します。

4. 順次質問ループ（インタラクティブ）：
    - 一度に正確に1つの質問を提示します。
    - 多択質問の場合、オプションをMarkdownテーブルとしてレンダリングします：

       | オプション | 説明 |
       |-----------|------|
       | A | <オプションAの説明> |
       | B | <オプションBの説明> |
       | C | <オプションCの説明> | （必要に応じて最大5つまでD/Eを追加）
       | 短い回答 | 異なる短い回答を提供（5語以内） | （自由形式の代替が適切な場合のみ含める）

    - 短い回答スタイルの場合（意味のある離散オプションなし）、質問の後に単一行を出力：`形式：短い回答（5語以内）`。
    - ユーザーが回答した後：
       * 回答が一つのオプションにマッピングされるか、5語以内制約に適合するかを検証。
       * 曖昧な場合、迅速な明確化を求める（カウントは同じ質問に属し、進めない）。
       * 満足のいくものになったら、作業メモリに記録し（まだディスクに書き込まない）、次のキューされた質問に移動。
    - 以下の場合、さらなる質問を停止：
       * すべての重要な曖昧性が早期に解決（残りのキューされた項目が不要になる）、または
       * ユーザーが完了を合図（「完了」、「良い」、「もうない」）、または
       * 5つの質問に到達。
    - 将来のキューされた質問を事前に明かさない。
    - 開始時に有効な質問が存在しない場合、即座に重要な曖昧性がないことを報告。

5. 受諾された各回答後の統合（増分更新アプローチ）：
    - 仕様のインメモリ表現（開始時に一度読み込み）と生ファイル内容を維持。
    - このセッションでの最初の統合回答について：
       * `## 明確化` セクションが存在することを確認（欠落している場合、仕様テンプレートに従って最高レベルの文脈/概要セクションの直後に作成）。
       * その下に、今日の `### セッション YYYY-MM-DD` サブヘッディングを作成（存在しない場合）。
    - 受諾直後にバレット行を追加：`- Q: <質問> → A: <最終回答>`。
    - その後、即座に最も適切なセクションに明確化を適用：
       * 機能的曖昧性 → 機能要件のバレットを更新または追加。
       * ユーザーインタラクション/アクター区別 → ユーザーストーリーまたはアクターサブセクション（存在する場合）を明確化されたロール、制約、またはシナリオで更新。
       * データ形状/エンティティ → データモデルを更新（フィールド、タイプ、関係を追加）し順序を保持；追加制約を簡潔にメモ。
       * 非機能制約 → 非機能/品質属性セクションで測定可能な基準を追加/修正（曖昧な形容詞をメトリクスや明示的ターゲットに変換）。
       * エッジケース/ネガティブフロー → エッジケース/エラーハンドリング下に新しいバレットを追加（テンプレートがプレースホルダーを提供する場合、そのようなサブセクションを作成）。
       * 用語の競合 → 仕様全体で用語を正規化；必要な場合のみ `（以前は「X」と呼ばれていた）` を一度追加して元の用語を保持。
    - 明確化が以前の曖昧な記述を無効化する場合、重複ではなくその記述を置換；時代遅れの矛盾するテキストを残さない。
    - 各統合後に仕様ファイルを保存し、コンテキスト喪失リスクを最小化（アトミック上書き）。
    - フォーマット保持：無関係なセクションを並び替えない；ヘッディング階層を保持。
    - 挿入された各明確化を最小限でテスト可能に保つ（物語の漂流を避ける）。

6. 検証（各書き込み後と最終パスで実行）：
   - 明確化セッションには受諾された回答ごとに正確に1つのバレット（重複なし）。
   - 質問総数（受諾済み）≤ 5。
   - 更新されたセクションには、新しい回答が解決するはずだった曖昧なプレースホルダーが残っていない。
   - 矛盾する以前の記述が残っていない（今無効になった代替選択肢が除去されたかスキャン）。
   - Markdown構造が有効；許可された新しいヘッディングのみ：`## 明確化`、`### セッション YYYY-MM-DD`。
   - 用語の一貫性：すべての更新されたセクションで同じ正規用語を使用。

7. 更新された仕様を `FEATURE_SPEC` に書き戻します。

8. 完了レポート（質問ループ終了または早期終了後）：
   - 質問された数と回答された数。
   - 更新された仕様へのパス。
   - 触れられたセクション（名前のリスト）。
   - 各分類法カテゴリのステータス付きカバレッジサマリーテーブル：解決済み（部分的/欠落状態から対処済み）、延期（質問枠を超過または計画により適している）、明確（すでに十分）、未解決（依然として部分的/欠落だが影響は低い）。
   - 未解決または延期が残っている場合、`/plan` に進むか、計画後に `/clarify` を再実行するかを推奨。
   - 推奨される次のコマンド。

動作ルール：
- 意味のある曖昧性が見つからない場合（またはすべての潜在的質問が低影響の場合）、「正式な明確化に値する重要な曖昧性は検出されませんでした。」と応答し、進行を提案。
- 仕様ファイルが欠落している場合、最初に `/specify` を実行するようユーザーに指示（ここで新しい仕様を作成しない）。
- 質問総数5つを絶対に超えない（単一質問の明確化再試行は新しい質問としてカウントしない）。
- 機能的明確性を阻害しない限り、推測的な技術スタック質問を避ける。
- ユーザーの早期終了信号（「停止」、「完了」、「進行」）を尊重。
 - 完全カバレッジのために質問がない場合、コンパクトなカバレッジサマリー（すべてのカテゴリが明確）を出力してから進歩を提案。
 - 高影響未解決カテゴリが残った状態で枠に到達した場合、延期下に根拠とともに明示的にフラグを立てる。

優先順位付けのコンテキスト：{ARGS}
