# Spec Kit

*高品質なソフトウェアをより速く構築。*

**Spec-Driven Development の力を借りて、組織が差別化されていないコードの作成ではなく、プロダクトシナリオに集中できるようにする取り組み。**

## Spec-Driven Development とは？

Spec-Driven Development は従来のソフトウェア開発の**常識を覆します**。何十年もの間、コードが王様でした。仕様書は、コーディングという「本当の仕事」が始まると構築し、その後破棄される足場にすぎませんでした。Spec-Driven Development はこれを変えます：**仕様書が実行可能になり**、単にガイドするだけでなく、動作する実装を直接生成します。

## はじめに

- [インストールガイド](installation.md)
- [クイックスタートガイド](quickstart.md)
- [ローカル開発](local-development.md)

## 基本理念

Spec-Driven Development は以下を重視する構造化されたプロセスです：

- **意図駆動開発** - 仕様書が「_どうやって_」よりも先に「_何を_」を定義する
- **豊富な仕様作成** - ガードレールと組織原則を使用
- **多段階の改良** - プロンプトからの一発コード生成ではない
- **高い依存度** - 仕様解釈のための高度なAIモデル機能への依存

## 開発フェーズ

| フェーズ | 焦点 | 主な活動 |
|-------|-------|----------------|
| **0-to-1 開発** ("Greenfield") | ゼロから生成 | <ul><li>高レベル要件から開始</li><li>仕様書を生成</li><li>実装手順を計画</li><li>本番対応アプリケーションを構築</li></ul> |
| **創造的探索** | 並行実装 | <ul><li>多様なソリューションを探索</li><li>複数の技術スタックとアーキテクチャをサポート</li><li>UXパターンを実験</li></ul> |
| **反復的改善** ("Brownfield") | Brownfield 近代化 | <ul><li>機能を反復的に追加</li><li>レガシーシステムを近代化</li><li>プロセスを適応</li></ul> |

## 実験目標

私たちの研究と実験は以下に焦点を当てています：

### 技術非依存性
- 多様な技術スタックを使用してアプリケーションを作成
- Spec-Driven Development が特定の技術、プログラミング言語、フレームワークに依存しないプロセスであるという仮説を検証

### エンタープライズ制約
- ミッションクリティカルなアプリケーション開発を実証
- 組織制約（クラウドプロバイダー、技術スタック、エンジニアリング慣行）を組み込む
- エンタープライズデザインシステムとコンプライアンス要件をサポート

### ユーザー中心開発
- 異なるユーザーコホートと好みのためのアプリケーションを構築
- さまざまな開発アプローチをサポート（vibe-coding から AI ネイティブ開発まで）

### 創造的・反復的プロセス
- 並行実装探索のコンセプトを検証
- 堅牢な反復的機能開発ワークフローを提供
- アップグレードと近代化タスクを処理するプロセスを拡張

## 貢献

このプロジェクトへの貢献方法については、[貢献ガイド](CONTRIBUTING.md) をご覧ください。

## サポート

サポートについては、[サポートガイド](SUPPORT.md) をご確認いただくか、GitHub で issue を作成してください。
