// Copyright (c) 2016, the Dart project authors.
// Please see the AUTHORS file
// for details. All rights reserved. Use of this source
// code is governed by a
// BSD-style license that can be found in the LICENSE file.

/// Test data for compact number formatting.
// DO NOT EDIT. This file is autogenerated by script.  See
// i18n/tools:dart_compact_number_test_data
// File generated from CLDR ver. 44.1
//
// WARNING: These tests are NOT consistent with ICU. Compact number formatting
// has changed, needing some more involved Dart code changes to determine
// significant digits and decimal digits.
library;

// MANUAL EDIT TO SUPPRESS WARNINGS IN GENERATED CODE
// ignore_for_file: prefer_single_quotes

/// The test data. A map, keyed by locale name, whose values
/// are a list of [basic, shortform, longform] formatted data
/// for different numbers.
Map<String, List<List<String>>> compactNumberTestData = {
  "af": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 k", "4,3 duisend"],
    ["54321", "54 k", "54 duisend"],
    ["654321", "654 k", "654 duisend"],
    ["7654321", "7,7 m", "7,7 miljoen"],
    ["87654321", "88 m", "88 miljoen"],
    ["987654321", "988 m", "988 miljoen"],
    ["1087654321", "1,1 mjd", "1,1 miljard"],
    ["11987654321", "12 mjd", "12 miljard"],
    ["129987654321", "130 mjd", "130 miljard"],
    ["1398987654321", "1,4 bn", "1,4 biljoen"],
    ["14987987654321", "15 bn", "15 biljoen"],
    ["159876987654321", "160 bn", "160 biljoen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 duisend"],
    ["99999", "100 k", "100 duisend"],
    ["999999", "1 m", "1 miljoen"],
    ["9999999", "10 m", "10 miljoen"],
    ["99999999", "100 m", "100 miljoen"],
    ["9994", "10 k", "10 duisend"],
    ["99944", "100 k", "100 duisend"],
    ["999444", "999 k", "999 duisend"],
    ["9994444", "10 m", "10 miljoen"],
    ["999444444", "999 m", "999 miljoen"],
    ["9994444444", "10 mjd", "10 miljard"],
    ["1000000000000000", "1000 bn", "1000 biljoen"],
    ["10000000000000000", "10000 bn", "10000 biljoen"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 k", "-1 duisend"],
    ["-1001", "-1 k", "-1 duisend"],
    ["-1010", "-1 k", "-1 duisend"],
    ["-1100", "-1,1 k", "-1,1 duisend"],
    ["-2000", "-2 k", "-2 duisend"],
    ["-2001", "-2 k", "-2 duisend"],
    ["-2010", "-2 k", "-2 duisend"],
    ["-2100", "-2,1 k", "-2,1 duisend"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 k", "-10 duisend"],
    ["-99999", "-100 k", "-100 duisend"],
    ["-999999", "-1 m", "-1 miljoen"],
    ["-9999999", "-10 m", "-10 miljoen"],
    ["-9999999999999999", "-10000 bn", "-10000 biljoen"],
    ["1000", "1 k", "1 duisend"],
    ["1001", "1 k", "1 duisend"],
    ["1010", "1 k", "1 duisend"],
    ["1100", "1,1 k", "1,1 duisend"],
    ["2000", "2 k", "2 duisend"],
    ["2001", "2 k", "2 duisend"],
    ["2010", "2 k", "2 duisend"],
    ["2100", "2,1 k", "2,1 duisend"],
    ["3000", "3 k", "3 duisend"],
    ["3001", "3 k", "3 duisend"],
    ["3010", "3 k", "3 duisend"],
    ["3100", "3,1 k", "3,1 duisend"],
    ["4000", "4 k", "4 duisend"],
    ["4001", "4 k", "4 duisend"],
    ["4010", "4 k", "4 duisend"],
    ["4100", "4,1 k", "4,1 duisend"],
    ["5000", "5 k", "5 duisend"],
    ["5001", "5 k", "5 duisend"],
    ["5010", "5 k", "5 duisend"],
    ["5100", "5,1 k", "5,1 duisend"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 k", "1 duisend"],
    ["9999.12", "10 k", "10 duisend"],
    ["9999.99", "10 k", "10 duisend"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 k", "-1 duisend"],
    ["-9999.12", "-10 k", "-10 duisend"],
    ["-9999.99", "-10 k", "-10 duisend"],
  ],
  "am": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 ሺ", "4.3 ሺ"],
    ["54321", "54 ሺ", "54 ሺ"],
    ["654321", "654 ሺ", "654 ሺ"],
    ["7654321", "7.7 ሚ", "7.7 ሚሊዮን"],
    ["87654321", "88 ሚ", "88 ሚሊዮን"],
    ["987654321", "988 ሚ", "988 ሚሊዮን"],
    ["1087654321", "1.1 ቢ", "1.1 ቢሊዮን"],
    ["11987654321", "12 ቢ", "12 ቢሊዮን"],
    ["129987654321", "130 ቢ", "130 ቢሊዮን"],
    ["1398987654321", "1.4 ት", "1.4 ትሪሊዮን"],
    ["14987987654321", "15 ት", "15 ትሪሊዮን"],
    ["159876987654321", "160 ት", "160 ትሪሊዮን"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ሺ", "10 ሺ"],
    ["99999", "100 ሺ", "100 ሺ"],
    ["999999", "1 ሚ", "1 ሚሊዮን"],
    ["9999999", "10 ሚ", "10 ሚሊዮን"],
    ["99999999", "100 ሚ", "100 ሚሊዮን"],
    ["9994", "10 ሺ", "10 ሺ"],
    ["99944", "100 ሺ", "100 ሺ"],
    ["999444", "999 ሺ", "999 ሺ"],
    ["9994444", "10 ሚ", "10 ሚሊዮን"],
    ["999444444", "999 ሚ", "999 ሚሊዮን"],
    ["9994444444", "10 ቢ", "10 ቢሊዮን"],
    ["1000000000000000", "1000 ት", "1000 ትሪሊዮን"],
    ["10000000000000000", "10000 ት", "10000 ትሪሊዮን"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 ሺ", "-1 ሺ"],
    ["-1001", "-1 ሺ", "-1 ሺ"],
    ["-1010", "-1 ሺ", "-1 ሺ"],
    ["-1100", "-1.1 ሺ", "-1.1 ሺ"],
    ["-2000", "-2 ሺ", "-2 ሺ"],
    ["-2001", "-2 ሺ", "-2 ሺ"],
    ["-2010", "-2 ሺ", "-2 ሺ"],
    ["-2100", "-2.1 ሺ", "-2.1 ሺ"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 ሺ", "-10 ሺ"],
    ["-99999", "-100 ሺ", "-100 ሺ"],
    ["-999999", "-1 ሚ", "-1 ሚሊዮን"],
    ["-9999999", "-10 ሚ", "-10 ሚሊዮን"],
    ["-9999999999999999", "-10000 ት", "-10000 ትሪሊዮን"],
    ["1000", "1 ሺ", "1 ሺ"],
    ["1001", "1 ሺ", "1 ሺ"],
    ["1010", "1 ሺ", "1 ሺ"],
    ["1100", "1.1 ሺ", "1.1 ሺ"],
    ["2000", "2 ሺ", "2 ሺ"],
    ["2001", "2 ሺ", "2 ሺ"],
    ["2010", "2 ሺ", "2 ሺ"],
    ["2100", "2.1 ሺ", "2.1 ሺ"],
    ["3000", "3 ሺ", "3 ሺ"],
    ["3001", "3 ሺ", "3 ሺ"],
    ["3010", "3 ሺ", "3 ሺ"],
    ["3100", "3.1 ሺ", "3.1 ሺ"],
    ["4000", "4 ሺ", "4 ሺ"],
    ["4001", "4 ሺ", "4 ሺ"],
    ["4010", "4 ሺ", "4 ሺ"],
    ["4100", "4.1 ሺ", "4.1 ሺ"],
    ["5000", "5 ሺ", "5 ሺ"],
    ["5001", "5 ሺ", "5 ሺ"],
    ["5010", "5 ሺ", "5 ሺ"],
    ["5100", "5.1 ሺ", "5.1 ሺ"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 ሺ", "1 ሺ"],
    ["9999.12", "10 ሺ", "10 ሺ"],
    ["9999.99", "10 ሺ", "10 ሺ"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 ሺ", "-1 ሺ"],
    ["-9999.12", "-10 ሺ", "-10 ሺ"],
    ["-9999.99", "-10 ሺ", "-10 ሺ"],
  ],
  "ar": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 ألف", "4.3 ألف"],
    ["54321", "54 ألف", "54 ألف"],
    ["654321", "654 ألف", "654 ألف"],
    ["7654321", "7.7 مليون", "7.7 مليون"],
    ["87654321", "88 مليون", "88 مليون"],
    ["987654321", "988 مليون", "988 مليون"],
    ["1087654321", "1.1 مليار", "1.1 مليار"],
    ["11987654321", "12 مليار", "12 مليار"],
    ["129987654321", "130 مليار", "130 مليار"],
    ["1398987654321", "1.4 ترليون", "1.4 ترليون"],
    ["14987987654321", "15 ترليون", "15 ترليون"],
    ["159876987654321", "160 ترليون", "160 ترليون"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ألف", "10 ألف"],
    ["99999", "100 ألف", "100 ألف"],
    ["999999", "1 مليون", "1 مليون"],
    ["9999999", "10 مليون", "10 ملايين"],
    ["99999999", "100 مليون", "100 مليون"],
    ["9994", "10 ألف", "10 ألف"],
    ["99944", "100 ألف", "100 ألف"],
    ["999444", "999 ألف", "999 ألف"],
    ["9994444", "10 مليون", "10 ملايين"],
    ["999444444", "999 مليون", "999 مليون"],
    ["9994444444", "10 مليار", "10 مليار"],
    ["1000000000000000", "1000 ترليون", "1000 ترليون"],
    ["10000000000000000", "10000 ترليون", "10000 ترليون"],
    ["0", "0", "0"],
    ["-1", "‎-1", "‎-1"],
    ["-2", "‎-2", "‎-2"],
    ["-3", "‎-3", "‎-3"],
    ["-1000", "‎-1 ألف", "‎-1 ألف"],
    ["-1001", "‎-1 ألف", "‎-1 ألف"],
    ["-1010", "‎-1 ألف", "‎-1 ألف"],
    ["-1100", "‎-1.1 ألف", "‎-1.1 ألف"],
    ["-2000", "‎-2 ألف", "‎-2 ألف"],
    ["-2001", "‎-2 ألف", "‎-2 ألف"],
    ["-2010", "‎-2 ألف", "‎-2 ألف"],
    ["-2100", "‎-2.1 ألف", "‎-2.1 ألف"],
    ["-9", "‎-9", "‎-9"],
    ["-99", "‎-99", "‎-99"],
    ["-999", "‎-999", "‎-999"],
    ["-9999", "‎-10 ألف", "‎-10 ألف"],
    ["-99999", "‎-100 ألف", "‎-100 ألف"],
    ["-999999", "‎-1 مليون", "‎-1 مليون"],
    ["-9999999", "‎-10 مليون", "‎-10 ملايين"],
    ["-9999999999999999", "‎-10000 ترليون", "‎-10000 ترليون"],
    ["1000", "1 ألف", "1 ألف"],
    ["1001", "1 ألف", "1 ألف"],
    ["1010", "1 ألف", "1 ألف"],
    ["1100", "1.1 ألف", "1.1 ألف"],
    ["2000", "2 ألف", "2 ألف"],
    ["2001", "2 ألف", "2 ألف"],
    ["2010", "2 ألف", "2 ألف"],
    ["2100", "2.1 ألف", "2.1 ألف"],
    ["3000", "3 آلاف", "3 آلاف"],
    ["3001", "3 آلاف", "3 آلاف"],
    ["3010", "3 آلاف", "3 آلاف"],
    ["3100", "3.1 ألف", "3.1 ألف"],
    ["4000", "4 آلاف", "4 آلاف"],
    ["4001", "4 آلاف", "4 آلاف"],
    ["4010", "4 آلاف", "4 آلاف"],
    ["4100", "4.1 ألف", "4.1 ألف"],
    ["5000", "5 آلاف", "5 آلاف"],
    ["5001", "5 آلاف", "5 آلاف"],
    ["5010", "5 آلاف", "5 آلاف"],
    ["5100", "5.1 ألف", "5.1 ألف"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 ألف", "1 ألف"],
    ["9999.12", "10 ألف", "10 ألف"],
    ["9999.99", "10 ألف", "10 ألف"],
    ["-0.12", "‎-0.12", "‎-0.12"],
    ["-0.99", "‎-0.99", "‎-0.99"],
    ["-9.12", "‎-9.1", "‎-9.1"],
    ["-9.99", "‎-10", "‎-10"],
    ["-999.12", "‎-999", "‎-999"],
    ["-999.99", "‎-1 ألف", "‎-1 ألف"],
    ["-9999.12", "‎-10 ألف", "‎-10 ألف"],
    ["-9999.99", "‎-10 ألف", "‎-10 ألف"],
  ],
  "ar_DZ": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 ألف", "4,3 ألف"],
    ["54321", "54 ألف", "54 ألف"],
    ["654321", "654 ألف", "654 ألف"],
    ["7654321", "7,7 مليون", "7,7 مليون"],
    ["87654321", "88 مليون", "88 مليون"],
    ["987654321", "988 مليون", "988 مليون"],
    ["1087654321", "1,1 مليار", "1,1 مليار"],
    ["11987654321", "12 مليار", "12 مليار"],
    ["129987654321", "130 مليار", "130 مليار"],
    ["1398987654321", "1,4 ترليون", "1,4 ترليون"],
    ["14987987654321", "15 ترليون", "15 ترليون"],
    ["159876987654321", "160 ترليون", "160 ترليون"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ألف", "10 ألف"],
    ["99999", "100 ألف", "100 ألف"],
    ["999999", "1 مليون", "1 مليون"],
    ["9999999", "10 مليون", "10 ملايين"],
    ["99999999", "100 مليون", "100 مليون"],
    ["9994", "10 ألف", "10 ألف"],
    ["99944", "100 ألف", "100 ألف"],
    ["999444", "999 ألف", "999 ألف"],
    ["9994444", "10 مليون", "10 ملايين"],
    ["999444444", "999 مليون", "999 مليون"],
    ["9994444444", "10 مليار", "10 مليار"],
    ["1000000000000000", "1000 ترليون", "1000 ترليون"],
    ["10000000000000000", "10000 ترليون", "10000 ترليون"],
    ["0", "0", "0"],
    ["-1", "‎-1", "‎-1"],
    ["-2", "‎-2", "‎-2"],
    ["-3", "‎-3", "‎-3"],
    ["-1000", "‎-1 ألف", "‎-1 ألف"],
    ["-1001", "‎-1 ألف", "‎-1 ألف"],
    ["-1010", "‎-1 ألف", "‎-1 ألف"],
    ["-1100", "‎-1,1 ألف", "‎-1,1 ألف"],
    ["-2000", "‎-2 ألف", "‎-2 ألف"],
    ["-2001", "‎-2 ألف", "‎-2 ألف"],
    ["-2010", "‎-2 ألف", "‎-2 ألف"],
    ["-2100", "‎-2,1 ألف", "‎-2,1 ألف"],
    ["-9", "‎-9", "‎-9"],
    ["-99", "‎-99", "‎-99"],
    ["-999", "‎-999", "‎-999"],
    ["-9999", "‎-10 ألف", "‎-10 ألف"],
    ["-99999", "‎-100 ألف", "‎-100 ألف"],
    ["-999999", "‎-1 مليون", "‎-1 مليون"],
    ["-9999999", "‎-10 مليون", "‎-10 ملايين"],
    ["-9999999999999999", "‎-10000 ترليون", "‎-10000 ترليون"],
    ["1000", "1 ألف", "1 ألف"],
    ["1001", "1 ألف", "1 ألف"],
    ["1010", "1 ألف", "1 ألف"],
    ["1100", "1,1 ألف", "1,1 ألف"],
    ["2000", "2 ألف", "2 ألف"],
    ["2001", "2 ألف", "2 ألف"],
    ["2010", "2 ألف", "2 ألف"],
    ["2100", "2,1 ألف", "2,1 ألف"],
    ["3000", "3 آلاف", "3 آلاف"],
    ["3001", "3 آلاف", "3 آلاف"],
    ["3010", "3 آلاف", "3 آلاف"],
    ["3100", "3,1 ألف", "3,1 ألف"],
    ["4000", "4 آلاف", "4 آلاف"],
    ["4001", "4 آلاف", "4 آلاف"],
    ["4010", "4 آلاف", "4 آلاف"],
    ["4100", "4,1 ألف", "4,1 ألف"],
    ["5000", "5 آلاف", "5 آلاف"],
    ["5001", "5 آلاف", "5 آلاف"],
    ["5010", "5 آلاف", "5 آلاف"],
    ["5100", "5,1 ألف", "5,1 ألف"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 ألف", "1 ألف"],
    ["9999.12", "10 ألف", "10 ألف"],
    ["9999.99", "10 ألف", "10 ألف"],
    ["-0.12", "‎-0,12", "‎-0,12"],
    ["-0.99", "‎-0,99", "‎-0,99"],
    ["-9.12", "‎-9,1", "‎-9,1"],
    ["-9.99", "‎-10", "‎-10"],
    ["-999.12", "‎-999", "‎-999"],
    ["-999.99", "‎-1 ألف", "‎-1 ألف"],
    ["-9999.12", "‎-10 ألف", "‎-10 ألف"],
    ["-9999.99", "‎-10 ألف", "‎-10 ألف"],
  ],
  "ar_EG": [
    ["1", "١", "١"],
    ["21", "٢١", "٢١"],
    ["321", "٣٢١", "٣٢١"],
    ["4321", "٤٫٣ ألف", "٤٫٣ ألف"],
    ["54321", "٥٤ ألف", "٥٤ ألف"],
    ["654321", "٦٥٤ ألف", "٦٥٤ ألف"],
    ["7654321", "٧٫٧ مليون", "٧٫٧ مليون"],
    ["87654321", "٨٨ مليون", "٨٨ مليون"],
    ["987654321", "٩٨٨ مليون", "٩٨٨ مليون"],
    ["1087654321", "١٫١ مليار", "١٫١ مليار"],
    ["11987654321", "١٢ مليار", "١٢ مليار"],
    ["129987654321", "١٣٠ مليار", "١٣٠ مليار"],
    ["1398987654321", "١٫٤ ترليون", "١٫٤ ترليون"],
    ["14987987654321", "١٥ ترليون", "١٥ ترليون"],
    ["159876987654321", "١٦٠ ترليون", "١٦٠ ترليون"],
    ["9", "٩", "٩"],
    ["99", "٩٩", "٩٩"],
    ["999", "٩٩٩", "٩٩٩"],
    ["9999", "١٠ ألف", "١٠ ألف"],
    ["99999", "١٠٠ ألف", "١٠٠ ألف"],
    ["999999", "١ مليون", "١ مليون"],
    ["9999999", "١٠ مليون", "١٠ ملايين"],
    ["99999999", "١٠٠ مليون", "١٠٠ مليون"],
    ["9994", "١٠ ألف", "١٠ ألف"],
    ["99944", "١٠٠ ألف", "١٠٠ ألف"],
    ["999444", "٩٩٩ ألف", "٩٩٩ ألف"],
    ["9994444", "١٠ مليون", "١٠ ملايين"],
    ["999444444", "٩٩٩ مليون", "٩٩٩ مليون"],
    ["9994444444", "١٠ مليار", "١٠ مليار"],
    ["1000000000000000", "١٠٠٠ ترليون", "١٠٠٠ ترليون"],
    ["10000000000000000", "١٠٠٠٠ ترليون", "١٠٠٠٠ ترليون"],
    ["0", "٠", "٠"],
    ["-1", "؜-١", "؜-١"],
    ["-2", "؜-٢", "؜-٢"],
    ["-3", "؜-٣", "؜-٣"],
    ["-1000", "؜-١ ألف", "؜-١ ألف"],
    ["-1001", "؜-١ ألف", "؜-١ ألف"],
    ["-1010", "؜-١ ألف", "؜-١ ألف"],
    ["-1100", "؜-١٫١ ألف", "؜-١٫١ ألف"],
    ["-2000", "؜-٢ ألف", "؜-٢ ألف"],
    ["-2001", "؜-٢ ألف", "؜-٢ ألف"],
    ["-2010", "؜-٢ ألف", "؜-٢ ألف"],
    ["-2100", "؜-٢٫١ ألف", "؜-٢٫١ ألف"],
    ["-9", "؜-٩", "؜-٩"],
    ["-99", "؜-٩٩", "؜-٩٩"],
    ["-999", "؜-٩٩٩", "؜-٩٩٩"],
    ["-9999", "؜-١٠ ألف", "؜-١٠ ألف"],
    ["-99999", "؜-١٠٠ ألف", "؜-١٠٠ ألف"],
    ["-999999", "؜-١ مليون", "؜-١ مليون"],
    ["-9999999", "؜-١٠ مليون", "؜-١٠ ملايين"],
    ["-9999999999999999", "؜-١٠٠٠٠ ترليون", "؜-١٠٠٠٠ ترليون"],
    ["1000", "١ ألف", "١ ألف"],
    ["1001", "١ ألف", "١ ألف"],
    ["1010", "١ ألف", "١ ألف"],
    ["1100", "١٫١ ألف", "١٫١ ألف"],
    ["2000", "٢ ألف", "٢ ألف"],
    ["2001", "٢ ألف", "٢ ألف"],
    ["2010", "٢ ألف", "٢ ألف"],
    ["2100", "٢٫١ ألف", "٢٫١ ألف"],
    ["3000", "٣ آلاف", "٣ آلاف"],
    ["3001", "٣ آلاف", "٣ آلاف"],
    ["3010", "٣ آلاف", "٣ آلاف"],
    ["3100", "٣٫١ ألف", "٣٫١ ألف"],
    ["4000", "٤ آلاف", "٤ آلاف"],
    ["4001", "٤ آلاف", "٤ آلاف"],
    ["4010", "٤ آلاف", "٤ آلاف"],
    ["4100", "٤٫١ ألف", "٤٫١ ألف"],
    ["5000", "٥ آلاف", "٥ آلاف"],
    ["5001", "٥ آلاف", "٥ آلاف"],
    ["5010", "٥ آلاف", "٥ آلاف"],
    ["5100", "٥٫١ ألف", "٥٫١ ألف"],
    ["0.001234", "٠٫٠٠١٢", "٠٫٠٠١٢"],
    ["0.01234", "٠٫٠١٢", "٠٫٠١٢"],
    ["0.1234", "٠٫١٢", "٠٫١٢"],
    ["0.99", "٠٫٩٩", "٠٫٩٩"],
    ["0.999", "١", "١"],
    ["9.12", "٩٫١", "٩٫١"],
    ["9.99", "١٠", "١٠"],
    ["99.12", "٩٩", "٩٩"],
    ["99.99", "١٠٠", "١٠٠"],
    ["999.12", "٩٩٩", "٩٩٩"],
    ["999.99", "١ ألف", "١ ألف"],
    ["9999.12", "١٠ ألف", "١٠ ألف"],
    ["9999.99", "١٠ ألف", "١٠ ألف"],
    ["-0.12", "؜-٠٫١٢", "؜-٠٫١٢"],
    ["-0.99", "؜-٠٫٩٩", "؜-٠٫٩٩"],
    ["-9.12", "؜-٩٫١", "؜-٩٫١"],
    ["-9.99", "؜-١٠", "؜-١٠"],
    ["-999.12", "؜-٩٩٩", "؜-٩٩٩"],
    ["-999.99", "؜-١ ألف", "؜-١ ألف"],
    ["-9999.12", "؜-١٠ ألف", "؜-١٠ ألف"],
    ["-9999.99", "؜-١٠ ألف", "؜-١٠ ألف"],
  ],
  "as": [
    ["1", "১", "১"],
    ["21", "২১", "২১"],
    ["321", "৩২১", "৩২১"],
    ["4321", "৪.৩ হাজাৰ", "৪.৩ হাজাৰ"],
    ["54321", "৫৪ হাজাৰ", "৫৪ হাজাৰ"],
    ["654321", "৬.৫ লাখ", "৬.৫ লাখ"],
    ["7654321", "৭.৭ নিযুত", "৭.৭ নিযুত"],
    ["87654321", "৮৮ নিযুত", "৮৮ নিযুত"],
    ["987654321", "৯৮৮ নিঃ", "৯৮৮ নিযুত"],
    ["1087654321", "১.১ শঃ কোঃ", "১.১ শত কোটি"],
    ["11987654321", "১২ শঃ কোঃ", "১২ শত কোটি"],
    ["129987654321", "১৩০ শঃ কঃ", "১৩০ শত কোটি"],
    ["1398987654321", "১.৪ শঃ পঃ", "১.৪ শত পৰাৰ্দ্ধ"],
    ["14987987654321", "১৫ শঃ পঃ", "১৫ শত পৰাৰ্দ্ধ"],
    ["159876987654321", "১৬০ শঃ পঃ", "১৬০ শত পৰাৰ্দ্ধ"],
    ["9", "৯", "৯"],
    ["99", "৯৯", "৯৯"],
    ["999", "৯৯৯", "৯৯৯"],
    ["9999", "১০ হাজাৰ", "১০ হাজাৰ"],
    ["99999", "১ লাখ", "১ লাখ"],
    ["999999", "১ নিযুত", "১ নিযুত"],
    ["9999999", "১০ নিযুত", "১০ নিযুত"],
    ["99999999", "১০০ নিঃ", "১০০ নিযুত"],
    ["9994", "১০ হাজাৰ", "১০ হাজাৰ"],
    ["99944", "১ লাখ", "১ লাখ"],
    ["999444", "১ নিযুত", "১ নিযুত"],
    ["9994444", "১০ নিযুত", "১০ নিযুত"],
    ["999444444", "৯৯৯ নিঃ", "৯৯৯ নিযুত"],
    ["9994444444", "১০ শঃ কোঃ", "১০ শত কোটি"],
    ["1000000000000000", "১০০০ শঃ পঃ", "১০০০ শত পৰাৰ্দ্ধ"],
    ["10000000000000000", "১০০০০ শঃ পঃ", "১০০০০ শত পৰাৰ্দ্ধ"],
    ["0", "০", "০"],
    ["-1", "-১", "-১"],
    ["-2", "-২", "-২"],
    ["-3", "-৩", "-৩"],
    ["-1000", "-১ হাজাৰ", "-১ হাজাৰ"],
    ["-1001", "-১ হাজাৰ", "-১ হাজাৰ"],
    ["-1010", "-১ হাজাৰ", "-১ হাজাৰ"],
    ["-1100", "-১.১ হাজাৰ", "-১.১ হাজাৰ"],
    ["-2000", "-২ হাজাৰ", "-২ হাজাৰ"],
    ["-2001", "-২ হাজাৰ", "-২ হাজাৰ"],
    ["-2010", "-২ হাজাৰ", "-২ হাজাৰ"],
    ["-2100", "-২.১ হাজাৰ", "-২.১ হাজাৰ"],
    ["-9", "-৯", "-৯"],
    ["-99", "-৯৯", "-৯৯"],
    ["-999", "-৯৯৯", "-৯৯৯"],
    ["-9999", "-১০ হাজাৰ", "-১০ হাজাৰ"],
    ["-99999", "-১ লাখ", "-১ লাখ"],
    ["-999999", "-১ নিযুত", "-১ নিযুত"],
    ["-9999999", "-১০ নিযুত", "-১০ নিযুত"],
    ["-9999999999999999", "-১০০০০ শঃ পঃ", "-১০০০০ শত পৰাৰ্দ্ধ"],
    ["1000", "১ হাজাৰ", "১ হাজাৰ"],
    ["1001", "১ হাজাৰ", "১ হাজাৰ"],
    ["1010", "১ হাজাৰ", "১ হাজাৰ"],
    ["1100", "১.১ হাজাৰ", "১.১ হাজাৰ"],
    ["2000", "২ হাজাৰ", "২ হাজাৰ"],
    ["2001", "২ হাজাৰ", "২ হাজাৰ"],
    ["2010", "২ হাজাৰ", "২ হাজাৰ"],
    ["2100", "২.১ হাজাৰ", "২.১ হাজাৰ"],
    ["3000", "৩ হাজাৰ", "৩ হাজাৰ"],
    ["3001", "৩ হাজাৰ", "৩ হাজাৰ"],
    ["3010", "৩ হাজাৰ", "৩ হাজাৰ"],
    ["3100", "৩.১ হাজাৰ", "৩.১ হাজাৰ"],
    ["4000", "৪ হাজাৰ", "৪ হাজাৰ"],
    ["4001", "৪ হাজাৰ", "৪ হাজাৰ"],
    ["4010", "৪ হাজাৰ", "৪ হাজাৰ"],
    ["4100", "৪.১ হাজাৰ", "৪.১ হাজাৰ"],
    ["5000", "৫ হাজাৰ", "৫ হাজাৰ"],
    ["5001", "৫ হাজাৰ", "৫ হাজাৰ"],
    ["5010", "৫ হাজাৰ", "৫ হাজাৰ"],
    ["5100", "৫.১ হাজাৰ", "৫.১ হাজাৰ"],
    ["0.001234", "০.০০১২", "০.০০১২"],
    ["0.01234", "০.০১২", "০.০১২"],
    ["0.1234", "০.১২", "০.১২"],
    ["0.99", "০.৯৯", "০.৯৯"],
    ["0.999", "১", "১"],
    ["9.12", "৯.১", "৯.১"],
    ["9.99", "১০", "১০"],
    ["99.12", "৯৯", "৯৯"],
    ["99.99", "১০০", "১০০"],
    ["999.12", "৯৯৯", "৯৯৯"],
    ["999.99", "১ হাজাৰ", "১ হাজাৰ"],
    ["9999.12", "১০ হাজাৰ", "১০ হাজাৰ"],
    ["9999.99", "১০ হাজাৰ", "১০ হাজাৰ"],
    ["-0.12", "-০.১২", "-০.১২"],
    ["-0.99", "-০.৯৯", "-০.৯৯"],
    ["-9.12", "-৯.১", "-৯.১"],
    ["-9.99", "-১০", "-১০"],
    ["-999.12", "-৯৯৯", "-৯৯৯"],
    ["-999.99", "-১ হাজাৰ", "-১ হাজাৰ"],
    ["-9999.12", "-১০ হাজাৰ", "-১০ হাজাৰ"],
    ["-9999.99", "-১০ হাজাৰ", "-১০ হাজাৰ"],
  ],
  "az": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3K", "4,3 min"],
    ["54321", "54K", "54 min"],
    ["654321", "654K", "654 min"],
    ["7654321", "7,7 mln", "7,7 milyon"],
    ["87654321", "88 mln", "88 milyon"],
    ["987654321", "988 mln", "988 milyon"],
    ["1087654321", "1,1 mlrd", "1,1 milyard"],
    ["11987654321", "12 mlrd", "12 milyard"],
    ["129987654321", "130 mlrd", "130 milyard"],
    ["1398987654321", "1,4 trln", "1,4 trilyon"],
    ["14987987654321", "15 trln", "15 trilyon"],
    ["159876987654321", "160 trln", "160 trilyon"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 min"],
    ["99999", "100K", "100 min"],
    ["999999", "1 mln", "1 milyon"],
    ["9999999", "10 mln", "10 milyon"],
    ["99999999", "100 mln", "100 milyon"],
    ["9994", "10K", "10 min"],
    ["99944", "100K", "100 min"],
    ["999444", "999K", "999 min"],
    ["9994444", "10 mln", "10 milyon"],
    ["999444444", "999 mln", "999 milyon"],
    ["9994444444", "10 mlrd", "10 milyard"],
    ["1000000000000000", "1000 trln", "1000 trilyon"],
    ["10000000000000000", "10000 trln", "10000 trilyon"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 min"],
    ["-1001", "-1K", "-1 min"],
    ["-1010", "-1K", "-1 min"],
    ["-1100", "-1,1K", "-1,1 min"],
    ["-2000", "-2K", "-2 min"],
    ["-2001", "-2K", "-2 min"],
    ["-2010", "-2K", "-2 min"],
    ["-2100", "-2,1K", "-2,1 min"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 min"],
    ["-99999", "-100K", "-100 min"],
    ["-999999", "-1 mln", "-1 milyon"],
    ["-9999999", "-10 mln", "-10 milyon"],
    ["-9999999999999999", "-10000 trln", "-10000 trilyon"],
    ["1000", "1K", "1 min"],
    ["1001", "1K", "1 min"],
    ["1010", "1K", "1 min"],
    ["1100", "1,1K", "1,1 min"],
    ["2000", "2K", "2 min"],
    ["2001", "2K", "2 min"],
    ["2010", "2K", "2 min"],
    ["2100", "2,1K", "2,1 min"],
    ["3000", "3K", "3 min"],
    ["3001", "3K", "3 min"],
    ["3010", "3K", "3 min"],
    ["3100", "3,1K", "3,1 min"],
    ["4000", "4K", "4 min"],
    ["4001", "4K", "4 min"],
    ["4010", "4K", "4 min"],
    ["4100", "4,1K", "4,1 min"],
    ["5000", "5K", "5 min"],
    ["5001", "5K", "5 min"],
    ["5010", "5K", "5 min"],
    ["5100", "5,1K", "5,1 min"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 min"],
    ["9999.12", "10K", "10 min"],
    ["9999.99", "10K", "10 min"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 min"],
    ["-9999.12", "-10K", "-10 min"],
    ["-9999.99", "-10K", "-10 min"],
  ],
  "be": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 тыс.", "4,3 тысячы"],
    ["54321", "54 тыс.", "54 тысячы"],
    ["654321", "654 тыс.", "654 тысячы"],
    ["7654321", "7,7 млн", "7,7 мільёна"],
    ["87654321", "88 млн", "88 мільёнаў"],
    ["987654321", "988 млн", "988 мільёнаў"],
    ["1087654321", "1,1 млрд", "1,1 мільярда"],
    ["11987654321", "12 млрд", "12 мільярдаў"],
    ["129987654321", "130 млрд", "130 мільярдаў"],
    ["1398987654321", "1,4 трлн", "1,4 трыльёна"],
    ["14987987654321", "15 трлн", "15 трыльёнаў"],
    ["159876987654321", "160 трлн", "160 трыльёнаў"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 тыс.", "10 тысяч"],
    ["99999", "100 тыс.", "100 тысяч"],
    ["999999", "1 млн", "1 мільён"],
    ["9999999", "10 млн", "10 мільёнаў"],
    ["99999999", "100 млн", "100 мільёнаў"],
    ["9994", "10 тыс.", "10 тысяч"],
    ["99944", "100 тыс.", "100 тысяч"],
    ["999444", "999 тыс.", "999 тысяч"],
    ["9994444", "10 млн", "10 мільёнаў"],
    ["999444444", "999 млн", "999 мільёнаў"],
    ["9994444444", "10 млрд", "10 мільярдаў"],
    ["1000000000000000", "1000 трлн", "1000 трыльёнаў"],
    ["10000000000000000", "10000 трлн", "10000 трыльёнаў"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 тыс.", "-1 тысяча"],
    ["-1001", "-1 тыс.", "-1 тысяча"],
    ["-1010", "-1 тыс.", "-1 тысяча"],
    ["-1100", "-1,1 тыс.", "-1,1 тысячы"],
    ["-2000", "-2 тыс.", "-2 тысячы"],
    ["-2001", "-2 тыс.", "-2 тысячы"],
    ["-2010", "-2 тыс.", "-2 тысячы"],
    ["-2100", "-2,1 тыс.", "-2,1 тысячы"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 тыс.", "-10 тысяч"],
    ["-99999", "-100 тыс.", "-100 тысяч"],
    ["-999999", "-1 млн", "-1 мільён"],
    ["-9999999", "-10 млн", "-10 мільёнаў"],
    ["-9999999999999999", "-10000 трлн", "-10000 трыльёнаў"],
    ["1000", "1 тыс.", "1 тысяча"],
    ["1001", "1 тыс.", "1 тысяча"],
    ["1010", "1 тыс.", "1 тысяча"],
    ["1100", "1,1 тыс.", "1,1 тысячы"],
    ["2000", "2 тыс.", "2 тысячы"],
    ["2001", "2 тыс.", "2 тысячы"],
    ["2010", "2 тыс.", "2 тысячы"],
    ["2100", "2,1 тыс.", "2,1 тысячы"],
    ["3000", "3 тыс.", "3 тысячы"],
    ["3001", "3 тыс.", "3 тысячы"],
    ["3010", "3 тыс.", "3 тысячы"],
    ["3100", "3,1 тыс.", "3,1 тысячы"],
    ["4000", "4 тыс.", "4 тысячы"],
    ["4001", "4 тыс.", "4 тысячы"],
    ["4010", "4 тыс.", "4 тысячы"],
    ["4100", "4,1 тыс.", "4,1 тысячы"],
    ["5000", "5 тыс.", "5 тысяч"],
    ["5001", "5 тыс.", "5 тысяч"],
    ["5010", "5 тыс.", "5 тысяч"],
    ["5100", "5,1 тыс.", "5,1 тысячы"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 тыс.", "1 тысяча"],
    ["9999.12", "10 тыс.", "10 тысяч"],
    ["9999.99", "10 тыс.", "10 тысяч"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 тыс.", "-1 тысяча"],
    ["-9999.12", "-10 тыс.", "-10 тысяч"],
    ["-9999.99", "-10 тыс.", "-10 тысяч"],
  ],
  "bg": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 хил.", "4,3 хиляди"],
    ["54321", "54 хил.", "54 хиляди"],
    ["654321", "654 хил.", "654 хиляди"],
    ["7654321", "7,7 млн.", "7,7 милиона"],
    ["87654321", "88 млн.", "88 милиона"],
    ["987654321", "988 млн.", "988 милиона"],
    ["1087654321", "1,1 млрд.", "1,1 милиарда"],
    ["11987654321", "12 млрд.", "12 милиарда"],
    ["129987654321", "130 млрд.", "130 милиарда"],
    ["1398987654321", "1,4 трлн.", "1,4 трилиона"],
    ["14987987654321", "15 трлн.", "15 трилиона"],
    ["159876987654321", "160 трлн.", "160 трилиона"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 хил.", "10 хиляди"],
    ["99999", "100 хил.", "100 хиляди"],
    ["999999", "1 млн.", "1 милион"],
    ["9999999", "10 млн.", "10 милиона"],
    ["99999999", "100 млн.", "100 милиона"],
    ["9994", "10 хил.", "10 хиляди"],
    ["99944", "100 хил.", "100 хиляди"],
    ["999444", "999 хил.", "999 хиляди"],
    ["9994444", "10 млн.", "10 милиона"],
    ["999444444", "999 млн.", "999 милиона"],
    ["9994444444", "10 млрд.", "10 милиарда"],
    ["1000000000000000", "1000 трлн.", "1000 трилиона"],
    ["10000000000000000", "10000 трлн.", "10000 трилиона"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 хил.", "-1 хил."],
    ["-1001", "-1 хил.", "-1 хил."],
    ["-1010", "-1 хил.", "-1 хил."],
    ["-1100", "-1,1 хил.", "-1,1 хиляди"],
    ["-2000", "-2 хил.", "-2 хиляди"],
    ["-2001", "-2 хил.", "-2 хиляди"],
    ["-2010", "-2 хил.", "-2 хиляди"],
    ["-2100", "-2,1 хил.", "-2,1 хиляди"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 хил.", "-10 хиляди"],
    ["-99999", "-100 хил.", "-100 хиляди"],
    ["-999999", "-1 млн.", "-1 милион"],
    ["-9999999", "-10 млн.", "-10 милиона"],
    ["-9999999999999999", "-10000 трлн.", "-10000 трилиона"],
    ["1000", "1 хил.", "1 хил."],
    ["1001", "1 хил.", "1 хил."],
    ["1010", "1 хил.", "1 хил."],
    ["1100", "1,1 хил.", "1,1 хиляди"],
    ["2000", "2 хил.", "2 хиляди"],
    ["2001", "2 хил.", "2 хиляди"],
    ["2010", "2 хил.", "2 хиляди"],
    ["2100", "2,1 хил.", "2,1 хиляди"],
    ["3000", "3 хил.", "3 хиляди"],
    ["3001", "3 хил.", "3 хиляди"],
    ["3010", "3 хил.", "3 хиляди"],
    ["3100", "3,1 хил.", "3,1 хиляди"],
    ["4000", "4 хил.", "4 хиляди"],
    ["4001", "4 хил.", "4 хиляди"],
    ["4010", "4 хил.", "4 хиляди"],
    ["4100", "4,1 хил.", "4,1 хиляди"],
    ["5000", "5 хил.", "5 хиляди"],
    ["5001", "5 хил.", "5 хиляди"],
    ["5010", "5 хил.", "5 хиляди"],
    ["5100", "5,1 хил.", "5,1 хиляди"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 хил.", "1 хил."],
    ["9999.12", "10 хил.", "10 хиляди"],
    ["9999.99", "10 хил.", "10 хиляди"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 хил.", "-1 хил."],
    ["-9999.12", "-10 хил.", "-10 хиляди"],
    ["-9999.99", "-10 хил.", "-10 хиляди"],
  ],
  "bm": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3K"],
    ["54321", "54K", "54K"],
    ["654321", "654K", "654K"],
    ["7654321", "7.7M", "7.7M"],
    ["87654321", "88M", "88M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1.1G", "1.1G"],
    ["11987654321", "12G", "12G"],
    ["129987654321", "130G", "130G"],
    ["1398987654321", "1.4T", "1.4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "10K", "10K"],
    ["99944", "100K", "100K"],
    ["999444", "999K", "999K"],
    ["9994444", "10M", "10M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "10G", "10G"],
    ["1000000000000000", "1000T", "1000T"],
    ["10000000000000000", "10000T", "10000T"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1K"],
    ["-1001", "-1K", "-1K"],
    ["-1010", "-1K", "-1K"],
    ["-1100", "-1.1K", "-1.1K"],
    ["-2000", "-2K", "-2K"],
    ["-2001", "-2K", "-2K"],
    ["-2010", "-2K", "-2K"],
    ["-2100", "-2.1K", "-2.1K"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10K"],
    ["-99999", "-100K", "-100K"],
    ["-999999", "-1M", "-1M"],
    ["-9999999", "-10M", "-10M"],
    ["-9999999999999999", "-10000T", "-10000T"],
    ["1000", "1K", "1K"],
    ["1001", "1K", "1K"],
    ["1010", "1K", "1K"],
    ["1100", "1.1K", "1.1K"],
    ["2000", "2K", "2K"],
    ["2001", "2K", "2K"],
    ["2010", "2K", "2K"],
    ["2100", "2.1K", "2.1K"],
    ["3000", "3K", "3K"],
    ["3001", "3K", "3K"],
    ["3010", "3K", "3K"],
    ["3100", "3.1K", "3.1K"],
    ["4000", "4K", "4K"],
    ["4001", "4K", "4K"],
    ["4010", "4K", "4K"],
    ["4100", "4.1K", "4.1K"],
    ["5000", "5K", "5K"],
    ["5001", "5K", "5K"],
    ["5010", "5K", "5K"],
    ["5100", "5.1K", "5.1K"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1K"],
    ["9999.12", "10K", "10K"],
    ["9999.99", "10K", "10K"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1K"],
    ["-9999.12", "-10K", "-10K"],
    ["-9999.99", "-10K", "-10K"],
  ],
  "bn": [
    ["1", "১", "১"],
    ["21", "২১", "২১"],
    ["321", "৩২১", "৩২১"],
    ["4321", "৪.৩ হা", "৪.৩ হাজার"],
    ["54321", "৫৪ হা", "৫৪ হাজার"],
    ["654321", "৬.৫ লা", "৬.৫ লাখ"],
    ["7654321", "৭৭ লা", "৭৭ লাখ"],
    ["87654321", "৮.৮ কো", "৮.৮ কোটি"],
    ["987654321", "৯৯ কো", "৯৯ কোটি"],
    ["1087654321", "১০৯ কো", "১০৯ কোটি"],
    ["11987654321", "১২শত কো", "১১৯৯ কোটি"],
    ["129987654321", "১৩০কো", "১২৯৯৯ কোটি"],
    ["1398987654321", "১.৪ লা.কো.", "১.৪ লাখ কোটি"],
    ["14987987654321", "১৫ লা.কো.", "১৫ লাখ কোটি"],
    ["159876987654321", "১৬০ লা.কো.", "১৬০ লাখ কোটি"],
    ["9", "৯", "৯"],
    ["99", "৯৯", "৯৯"],
    ["999", "৯৯৯", "৯৯৯"],
    ["9999", "১০ হা", "১০ হাজার"],
    ["99999", "১ লা", "১ লাখ"],
    ["999999", "১০ লা", "১০ লাখ"],
    ["9999999", "১ কো", "১ কোটি"],
    ["99999999", "১০ কো", "১০ কোটি"],
    ["9994", "১০ হা", "১০ হাজার"],
    ["99944", "১ লা", "১ লাখ"],
    ["999444", "১০ লা", "১০ লাখ"],
    ["9994444", "১ কো", "১ কোটি"],
    ["999444444", "১০০ কো", "১০০ কোটি"],
    ["9994444444", "৯৯৯ কো", "৯৯৯ কোটি"],
    ["1000000000000000", "১০০০ লা.কো.", "১০০০ লাখ কোটি"],
    ["10000000000000000", "১০০০০ লা.কো.", "১০০০০ লাখ কোটি"],
    ["0", "০", "০"],
    ["-1", "-১", "-১"],
    ["-2", "-২", "-২"],
    ["-3", "-৩", "-৩"],
    ["-1000", "-১ হা", "-১ হাজার"],
    ["-1001", "-১ হা", "-১ হাজার"],
    ["-1010", "-১ হা", "-১ হাজার"],
    ["-1100", "-১.১ হা", "-১.১ হাজার"],
    ["-2000", "-২ হা", "-২ হাজার"],
    ["-2001", "-২ হা", "-২ হাজার"],
    ["-2010", "-২ হা", "-২ হাজার"],
    ["-2100", "-২.১ হা", "-২.১ হাজার"],
    ["-9", "-৯", "-৯"],
    ["-99", "-৯৯", "-৯৯"],
    ["-999", "-৯৯৯", "-৯৯৯"],
    ["-9999", "-১০ হা", "-১০ হাজার"],
    ["-99999", "-১ লা", "-১ লাখ"],
    ["-999999", "-১০ লা", "-১০ লাখ"],
    ["-9999999", "-১ কো", "-১ কোটি"],
    ["-9999999999999999", "-১০০০০ লা.কো.", "-১০০০০ লাখ কোটি"],
    ["1000", "১ হা", "১ হাজার"],
    ["1001", "১ হা", "১ হাজার"],
    ["1010", "১ হা", "১ হাজার"],
    ["1100", "১.১ হা", "১.১ হাজার"],
    ["2000", "২ হা", "২ হাজার"],
    ["2001", "২ হা", "২ হাজার"],
    ["2010", "২ হা", "২ হাজার"],
    ["2100", "২.১ হা", "২.১ হাজার"],
    ["3000", "৩ হা", "৩ হাজার"],
    ["3001", "৩ হা", "৩ হাজার"],
    ["3010", "৩ হা", "৩ হাজার"],
    ["3100", "৩.১ হা", "৩.১ হাজার"],
    ["4000", "৪ হা", "৪ হাজার"],
    ["4001", "৪ হা", "৪ হাজার"],
    ["4010", "৪ হা", "৪ হাজার"],
    ["4100", "৪.১ হা", "৪.১ হাজার"],
    ["5000", "৫ হা", "৫ হাজার"],
    ["5001", "৫ হা", "৫ হাজার"],
    ["5010", "৫ হা", "৫ হাজার"],
    ["5100", "৫.১ হা", "৫.১ হাজার"],
    ["0.001234", "০.০০১২", "০.০০১২"],
    ["0.01234", "০.০১২", "০.০১২"],
    ["0.1234", "০.১২", "০.১২"],
    ["0.99", "০.৯৯", "০.৯৯"],
    ["0.999", "১", "১"],
    ["9.12", "৯.১", "৯.১"],
    ["9.99", "১০", "১০"],
    ["99.12", "৯৯", "৯৯"],
    ["99.99", "১০০", "১০০"],
    ["999.12", "৯৯৯", "৯৯৯"],
    ["999.99", "১ হা", "১ হাজার"],
    ["9999.12", "১০ হা", "১০ হাজার"],
    ["9999.99", "১০ হা", "১০ হাজার"],
    ["-0.12", "-০.১২", "-০.১২"],
    ["-0.99", "-০.৯৯", "-০.৯৯"],
    ["-9.12", "-৯.১", "-৯.১"],
    ["-9.99", "-১০", "-১০"],
    ["-999.12", "-৯৯৯", "-৯৯৯"],
    ["-999.99", "-১ হা", "-১ হাজার"],
    ["-9999.12", "-১০ হা", "-১০ হাজার"],
    ["-9999.99", "-১০ হা", "-১০ হাজার"],
  ],
  "br": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3k", "4,3 miliad"],
    ["54321", "54k", "54 miliad"],
    ["654321", "654k", "654 miliad"],
    ["7654321", "7,7M", "7,7 milion"],
    ["87654321", "88M", "88 milion"],
    ["987654321", "988M", "988 milion"],
    ["1087654321", "1,1G", "1,1 miliard"],
    ["11987654321", "12G", "12 miliard"],
    ["129987654321", "130G", "130 miliard"],
    ["1398987654321", "1,4T", "1,4 bilion"],
    ["14987987654321", "15T", "15 bilion"],
    ["159876987654321", "160T", "160 bilion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 miliad"],
    ["99999", "100k", "100 miliad"],
    ["999999", "1M", "1 milion"],
    ["9999999", "10M", "10 milion"],
    ["99999999", "100M", "100 milion"],
    ["9994", "10k", "10 miliad"],
    ["99944", "100k", "100 miliad"],
    ["999444", "999k", "999 miliad"],
    ["9994444", "10M", "10 milion"],
    ["999444444", "999M", "999 milion"],
    ["9994444444", "10G", "10 miliard"],
    ["1000000000000000", "1000T", "1000 bilion"],
    ["10000000000000000", "10000T", "10000 bilion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1k", "-1 miliad"],
    ["-1001", "-1k", "-1 miliad"],
    ["-1010", "-1k", "-1 miliad"],
    ["-1100", "-1,1k", "-1,1 miliad"],
    ["-2000", "-2k", "-2 viliad"],
    ["-2001", "-2k", "-2 viliad"],
    ["-2010", "-2k", "-2 viliad"],
    ["-2100", "-2,1k", "-2,1 miliad"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10k", "-10 miliad"],
    ["-99999", "-100k", "-100 miliad"],
    ["-999999", "-1M", "-1 milion"],
    ["-9999999", "-10M", "-10 milion"],
    ["-9999999999999999", "-10000T", "-10000 bilion"],
    ["1000", "1k", "1 miliad"],
    ["1001", "1k", "1 miliad"],
    ["1010", "1k", "1 miliad"],
    ["1100", "1,1k", "1,1 miliad"],
    ["2000", "2k", "2 viliad"],
    ["2001", "2k", "2 viliad"],
    ["2010", "2k", "2 viliad"],
    ["2100", "2,1k", "2,1 miliad"],
    ["3000", "3k", "3 miliad"],
    ["3001", "3k", "3 miliad"],
    ["3010", "3k", "3 miliad"],
    ["3100", "3,1k", "3,1 miliad"],
    ["4000", "4k", "4 miliad"],
    ["4001", "4k", "4 miliad"],
    ["4010", "4k", "4 miliad"],
    ["4100", "4,1k", "4,1 miliad"],
    ["5000", "5k", "5 miliad"],
    ["5001", "5k", "5 miliad"],
    ["5010", "5k", "5 miliad"],
    ["5100", "5,1k", "5,1 miliad"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1k", "1 miliad"],
    ["9999.12", "10k", "10 miliad"],
    ["9999.99", "10k", "10 miliad"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1k", "-1 miliad"],
    ["-9999.12", "-10k", "-10 miliad"],
    ["-9999.99", "-10k", "-10 miliad"],
  ],
  "bs": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 hilj.", "4,3 hiljade"],
    ["54321", "54 hilj.", "54 hiljade"],
    ["654321", "654 hilj.", "654 hiljade"],
    ["7654321", "7,7 mil.", "7,7 miliona"],
    ["87654321", "88 mil.", "88 miliona"],
    ["987654321", "988 mil.", "988 miliona"],
    ["1087654321", "1,1 mlrd.", "1,1 milijarda"],
    ["11987654321", "12 mlrd.", "12 milijardi"],
    ["129987654321", "130 mlrd.", "130 milijardi"],
    ["1398987654321", "1,4 bil.", "1,4 biliona"],
    ["14987987654321", "15 bil.", "15 biliona"],
    ["159876987654321", "160 bil.", "160 biliona"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 hilj.", "10 hiljada"],
    ["99999", "100 hilj.", "100 hiljada"],
    ["999999", "1 mil.", "1 milion"],
    ["9999999", "10 mil.", "10 miliona"],
    ["99999999", "100 mil.", "100 miliona"],
    ["9994", "10 hilj.", "10 hiljada"],
    ["99944", "100 hilj.", "100 hiljada"],
    ["999444", "999 hilj.", "999 hiljada"],
    ["9994444", "10 mil.", "10 miliona"],
    ["999444444", "999 mil.", "999 miliona"],
    ["9994444444", "10 mlrd.", "10 milijardi"],
    ["1000000000000000", "1000 bil.", "1000 biliona"],
    ["10000000000000000", "10000 bil.", "10000 biliona"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 hilj.", "-1 hiljada"],
    ["-1001", "-1 hilj.", "-1 hiljada"],
    ["-1010", "-1 hilj.", "-1 hiljada"],
    ["-1100", "-1,1 hilj.", "-1,1 hiljada"],
    ["-2000", "-2 hilj.", "-2 hiljade"],
    ["-2001", "-2 hilj.", "-2 hiljade"],
    ["-2010", "-2 hilj.", "-2 hiljade"],
    ["-2100", "-2,1 hilj.", "-2,1 hiljada"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 hilj.", "-10 hiljada"],
    ["-99999", "-100 hilj.", "-100 hiljada"],
    ["-999999", "-1 mil.", "-1 milion"],
    ["-9999999", "-10 mil.", "-10 miliona"],
    ["-9999999999999999", "-10000 bil.", "-10000 biliona"],
    ["1000", "1 hilj.", "1 hiljada"],
    ["1001", "1 hilj.", "1 hiljada"],
    ["1010", "1 hilj.", "1 hiljada"],
    ["1100", "1,1 hilj.", "1,1 hiljada"],
    ["2000", "2 hilj.", "2 hiljade"],
    ["2001", "2 hilj.", "2 hiljade"],
    ["2010", "2 hilj.", "2 hiljade"],
    ["2100", "2,1 hilj.", "2,1 hiljada"],
    ["3000", "3 hilj.", "3 hiljade"],
    ["3001", "3 hilj.", "3 hiljade"],
    ["3010", "3 hilj.", "3 hiljade"],
    ["3100", "3,1 hilj.", "3,1 hiljada"],
    ["4000", "4 hilj.", "4 hiljade"],
    ["4001", "4 hilj.", "4 hiljade"],
    ["4010", "4 hilj.", "4 hiljade"],
    ["4100", "4,1 hilj.", "4,1 hiljada"],
    ["5000", "5 hilj.", "5 hiljada"],
    ["5001", "5 hilj.", "5 hiljada"],
    ["5010", "5 hilj.", "5 hiljada"],
    ["5100", "5,1 hilj.", "5,1 hiljada"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 hilj.", "1 hiljada"],
    ["9999.12", "10 hilj.", "10 hiljada"],
    ["9999.99", "10 hilj.", "10 hiljada"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 hilj.", "-1 hiljada"],
    ["-9999.12", "-10 hilj.", "-10 hiljada"],
    ["-9999.99", "-10 hilj.", "-10 hiljada"],
  ],
  "ca": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 k", "4,3 milers"],
    ["54321", "54 k", "54 milers"],
    ["654321", "654 k", "654 milers"],
    ["7654321", "7,7 M", "7,7 milions"],
    ["87654321", "88 M", "88 milions"],
    ["987654321", "988 M", "988 milions"],
    ["1087654321", "1088 M", "1,1 milers de milions"],
    ["11987654321", "12 kM", "12 milers de milions"],
    ["129987654321", "130 kM", "130 milers de milions"],
    ["1398987654321", "1,4 B", "1,4 bilions"],
    ["14987987654321", "15 B", "15 bilions"],
    ["159876987654321", "160 B", "160 bilions"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 milers"],
    ["99999", "100 k", "100 milers"],
    ["999999", "1 M", "1 milió"],
    ["9999999", "10 M", "10 milions"],
    ["99999999", "100 M", "100 milions"],
    ["9994", "10 k", "10 milers"],
    ["99944", "100 k", "100 milers"],
    ["999444", "999 k", "999 milers"],
    ["9994444", "10 M", "10 milions"],
    ["999444444", "999 M", "999 milions"],
    ["9994444444", "9994 M", "10 milers de milions"],
    ["1000000000000000", "1000 B", "1000 bilions"],
    ["10000000000000000", "10000 B", "10000 bilions"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 k", "-1 miler"],
    ["-1001", "-1 k", "-1 miler"],
    ["-1010", "-1 k", "-1 miler"],
    ["-1100", "-1,1 k", "-1,1 milers"],
    ["-2000", "-2 k", "-2 milers"],
    ["-2001", "-2 k", "-2 milers"],
    ["-2010", "-2 k", "-2 milers"],
    ["-2100", "-2,1 k", "-2,1 milers"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 k", "-10 milers"],
    ["-99999", "-100 k", "-100 milers"],
    ["-999999", "-1 M", "-1 milió"],
    ["-9999999", "-10 M", "-10 milions"],
    ["-9999999999999999", "-10000 B", "-10000 bilions"],
    ["1000", "1 k", "1 miler"],
    ["1001", "1 k", "1 miler"],
    ["1010", "1 k", "1 miler"],
    ["1100", "1,1 k", "1,1 milers"],
    ["2000", "2 k", "2 milers"],
    ["2001", "2 k", "2 milers"],
    ["2010", "2 k", "2 milers"],
    ["2100", "2,1 k", "2,1 milers"],
    ["3000", "3 k", "3 milers"],
    ["3001", "3 k", "3 milers"],
    ["3010", "3 k", "3 milers"],
    ["3100", "3,1 k", "3,1 milers"],
    ["4000", "4 k", "4 milers"],
    ["4001", "4 k", "4 milers"],
    ["4010", "4 k", "4 milers"],
    ["4100", "4,1 k", "4,1 milers"],
    ["5000", "5 k", "5 milers"],
    ["5001", "5 k", "5 milers"],
    ["5010", "5 k", "5 milers"],
    ["5100", "5,1 k", "5,1 milers"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 k", "1 miler"],
    ["9999.12", "10 k", "10 milers"],
    ["9999.99", "10 k", "10 milers"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 k", "-1 miler"],
    ["-9999.12", "-10 k", "-10 milers"],
    ["-9999.99", "-10 k", "-10 milers"],
  ],
  "chr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 ᎢᏯᎦᏴᎵ"],
    ["54321", "54K", "54 ᎢᏯᎦᏴᎵ"],
    ["654321", "654K", "654 ᎢᏯᎦᏴᎵ"],
    ["7654321", "7.7M", "7.7 ᎢᏳᏆᏗᏅᏛ"],
    ["87654321", "88M", "88 ᎢᏳᏆᏗᏅᏛ"],
    ["987654321", "988M", "988 ᎢᏳᏆᏗᏅᏛ"],
    ["1087654321", "1.1B", "1.1 ᎢᏯᏔᎳᏗᏅᏛ"],
    ["11987654321", "12B", "12 ᎢᏯᏔᎳᏗᏅᏛ"],
    ["129987654321", "130B", "130 ᎢᏯᏔᎳᏗᏅᏛ"],
    ["1398987654321", "1.4T", "1.4 ᎢᏯᏦᎠᏗᏅᏛ"],
    ["14987987654321", "15T", "15 ᎢᏯᏦᎠᏗᏅᏛ"],
    ["159876987654321", "160T", "160 ᎢᏯᏦᎠᏗᏅᏛ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 ᎢᏯᎦᏴᎵ"],
    ["99999", "100K", "100 ᎢᏯᎦᏴᎵ"],
    ["999999", "1M", "1 ᎢᏳᏆᏗᏅᏛ"],
    ["9999999", "10M", "10 ᎢᏳᏆᏗᏅᏛ"],
    ["99999999", "100M", "100 ᎢᏳᏆᏗᏅᏛ"],
    ["9994", "10K", "10 ᎢᏯᎦᏴᎵ"],
    ["99944", "100K", "100 ᎢᏯᎦᏴᎵ"],
    ["999444", "999K", "999 ᎢᏯᎦᏴᎵ"],
    ["9994444", "10M", "10 ᎢᏳᏆᏗᏅᏛ"],
    ["999444444", "999M", "999 ᎢᏳᏆᏗᏅᏛ"],
    ["9994444444", "10B", "10 ᎢᏯᏔᎳᏗᏅᏛ"],
    ["1000000000000000", "1000T", "1000 ᎢᏯᏦᎠᏗᏅᏛ"],
    ["10000000000000000", "10000T", "10000 ᎢᏯᏦᎠᏗᏅᏛ"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 ᎢᏯᎦᏴᎵ"],
    ["-1001", "-1K", "-1 ᎢᏯᎦᏴᎵ"],
    ["-1010", "-1K", "-1 ᎢᏯᎦᏴᎵ"],
    ["-1100", "-1.1K", "-1.1 ᎢᏯᎦᏴᎵ"],
    ["-2000", "-2K", "-2 ᎢᏯᎦᏴᎵ"],
    ["-2001", "-2K", "-2 ᎢᏯᎦᏴᎵ"],
    ["-2010", "-2K", "-2 ᎢᏯᎦᏴᎵ"],
    ["-2100", "-2.1K", "-2.1 ᎢᏯᎦᏴᎵ"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 ᎢᏯᎦᏴᎵ"],
    ["-99999", "-100K", "-100 ᎢᏯᎦᏴᎵ"],
    ["-999999", "-1M", "-1 ᎢᏳᏆᏗᏅᏛ"],
    ["-9999999", "-10M", "-10 ᎢᏳᏆᏗᏅᏛ"],
    ["-9999999999999999", "-10000T", "-10000 ᎢᏯᏦᎠᏗᏅᏛ"],
    ["1000", "1K", "1 ᎢᏯᎦᏴᎵ"],
    ["1001", "1K", "1 ᎢᏯᎦᏴᎵ"],
    ["1010", "1K", "1 ᎢᏯᎦᏴᎵ"],
    ["1100", "1.1K", "1.1 ᎢᏯᎦᏴᎵ"],
    ["2000", "2K", "2 ᎢᏯᎦᏴᎵ"],
    ["2001", "2K", "2 ᎢᏯᎦᏴᎵ"],
    ["2010", "2K", "2 ᎢᏯᎦᏴᎵ"],
    ["2100", "2.1K", "2.1 ᎢᏯᎦᏴᎵ"],
    ["3000", "3K", "3 ᎢᏯᎦᏴᎵ"],
    ["3001", "3K", "3 ᎢᏯᎦᏴᎵ"],
    ["3010", "3K", "3 ᎢᏯᎦᏴᎵ"],
    ["3100", "3.1K", "3.1 ᎢᏯᎦᏴᎵ"],
    ["4000", "4K", "4 ᎢᏯᎦᏴᎵ"],
    ["4001", "4K", "4 ᎢᏯᎦᏴᎵ"],
    ["4010", "4K", "4 ᎢᏯᎦᏴᎵ"],
    ["4100", "4.1K", "4.1 ᎢᏯᎦᏴᎵ"],
    ["5000", "5K", "5 ᎢᏯᎦᏴᎵ"],
    ["5001", "5K", "5 ᎢᏯᎦᏴᎵ"],
    ["5010", "5K", "5 ᎢᏯᎦᏴᎵ"],
    ["5100", "5.1K", "5.1 ᎢᏯᎦᏴᎵ"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 ᎢᏯᎦᏴᎵ"],
    ["9999.12", "10K", "10 ᎢᏯᎦᏴᎵ"],
    ["9999.99", "10K", "10 ᎢᏯᎦᏴᎵ"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 ᎢᏯᎦᏴᎵ"],
    ["-9999.12", "-10K", "-10 ᎢᏯᎦᏴᎵ"],
    ["-9999.99", "-10K", "-10 ᎢᏯᎦᏴᎵ"],
  ],
  "cs": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tis.", "4,3 tisíce"],
    ["54321", "54 tis.", "54 tisíc"],
    ["654321", "654 tis.", "654 tisíc"],
    ["7654321", "7,7 mil.", "7,7 milionu"],
    ["87654321", "88 mil.", "88 milionů"],
    ["987654321", "988 mil.", "988 milionů"],
    ["1087654321", "1,1 mld.", "1,1 miliardy"],
    ["11987654321", "12 mld.", "12 miliard"],
    ["129987654321", "130 mld.", "130 miliard"],
    ["1398987654321", "1,4 bil.", "1,4 bilionu"],
    ["14987987654321", "15 bil.", "15 bilionů"],
    ["159876987654321", "160 bil.", "160 bilionů"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tis.", "10 tisíc"],
    ["99999", "100 tis.", "100 tisíc"],
    ["999999", "1 mil.", "1 milion"],
    ["9999999", "10 mil.", "10 milionů"],
    ["99999999", "100 mil.", "100 milionů"],
    ["9994", "10 tis.", "10 tisíc"],
    ["99944", "100 tis.", "100 tisíc"],
    ["999444", "999 tis.", "999 tisíc"],
    ["9994444", "10 mil.", "10 milionů"],
    ["999444444", "999 mil.", "999 milionů"],
    ["9994444444", "10 mld.", "10 miliard"],
    ["1000000000000000", "1000 bil.", "1000 bilionů"],
    ["10000000000000000", "10000 bil.", "10000 bilionů"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 tis.", "-1 tisíc"],
    ["-1001", "-1 tis.", "-1 tisíc"],
    ["-1010", "-1 tis.", "-1 tisíc"],
    ["-1100", "-1,1 tis.", "-1,1 tisíce"],
    ["-2000", "-2 tis.", "-2 tisíce"],
    ["-2001", "-2 tis.", "-2 tisíce"],
    ["-2010", "-2 tis.", "-2 tisíce"],
    ["-2100", "-2,1 tis.", "-2,1 tisíce"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 tis.", "-10 tisíc"],
    ["-99999", "-100 tis.", "-100 tisíc"],
    ["-999999", "-1 mil.", "-1 milion"],
    ["-9999999", "-10 mil.", "-10 milionů"],
    ["-9999999999999999", "-10000 bil.", "-10000 bilionů"],
    ["1000", "1 tis.", "1 tisíc"],
    ["1001", "1 tis.", "1 tisíc"],
    ["1010", "1 tis.", "1 tisíc"],
    ["1100", "1,1 tis.", "1,1 tisíce"],
    ["2000", "2 tis.", "2 tisíce"],
    ["2001", "2 tis.", "2 tisíce"],
    ["2010", "2 tis.", "2 tisíce"],
    ["2100", "2,1 tis.", "2,1 tisíce"],
    ["3000", "3 tis.", "3 tisíce"],
    ["3001", "3 tis.", "3 tisíce"],
    ["3010", "3 tis.", "3 tisíce"],
    ["3100", "3,1 tis.", "3,1 tisíce"],
    ["4000", "4 tis.", "4 tisíce"],
    ["4001", "4 tis.", "4 tisíce"],
    ["4010", "4 tis.", "4 tisíce"],
    ["4100", "4,1 tis.", "4,1 tisíce"],
    ["5000", "5 tis.", "5 tisíc"],
    ["5001", "5 tis.", "5 tisíc"],
    ["5010", "5 tis.", "5 tisíc"],
    ["5100", "5,1 tis.", "5,1 tisíce"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 tis.", "1 tisíc"],
    ["9999.12", "10 tis.", "10 tisíc"],
    ["9999.99", "10 tis.", "10 tisíc"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 tis.", "-1 tisíc"],
    ["-9999.12", "-10 tis.", "-10 tisíc"],
    ["-9999.99", "-10 tis.", "-10 tisíc"],
  ],
  "cy": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 mil"],
    ["54321", "54K", "54 mil"],
    ["654321", "654K", "654 mil"],
    ["7654321", "7.7M", "7.7 miliwn"],
    ["87654321", "88M", "88 miliwn"],
    ["987654321", "988M", "988 miliwn"],
    ["1087654321", "1.1B", "1.1 biliwn"],
    ["11987654321", "12B", "12 biliwn"],
    ["129987654321", "130B", "130 biliwn"],
    ["1398987654321", "1.4T", "1.4 triliwn"],
    ["14987987654321", "15T", "15 triliwn"],
    ["159876987654321", "160T", "160 triliwn"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 mil"],
    ["99999", "100K", "100 mil"],
    ["999999", "1M", "1 miliwn"],
    ["9999999", "10M", "10 miliwn"],
    ["99999999", "100M", "100 miliwn"],
    ["9994", "10K", "10 mil"],
    ["99944", "100K", "100 mil"],
    ["999444", "999K", "999 mil"],
    ["9994444", "10M", "10 miliwn"],
    ["999444444", "999M", "999 miliwn"],
    ["9994444444", "10B", "10 biliwn"],
    ["1000000000000000", "1000T", "1000 triliwn"],
    ["10000000000000000", "10000T", "10000 triliwn"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 mil"],
    ["-1001", "-1K", "-1 mil"],
    ["-1010", "-1K", "-1 mil"],
    ["-1100", "-1.1K", "-1.1 mil"],
    ["-2000", "-2K", "-2K"],
    ["-2001", "-2K", "-2K"],
    ["-2010", "-2K", "-2K"],
    ["-2100", "-2.1K", "-2.1 mil"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 mil"],
    ["-99999", "-100K", "-100 mil"],
    ["-999999", "-1M", "-1 miliwn"],
    ["-9999999", "-10M", "-10 miliwn"],
    ["-9999999999999999", "-10000T", "-10000 triliwn"],
    ["1000", "1K", "1 mil"],
    ["1001", "1K", "1 mil"],
    ["1010", "1K", "1 mil"],
    ["1100", "1.1K", "1.1 mil"],
    ["2000", "2K", "2K"],
    ["2001", "2K", "2K"],
    ["2010", "2K", "2K"],
    ["2100", "2.1K", "2.1 mil"],
    ["3000", "3K", "3K"],
    ["3001", "3K", "3K"],
    ["3010", "3K", "3K"],
    ["3100", "3.1K", "3.1 mil"],
    ["4000", "4K", "4 mil"],
    ["4001", "4K", "4 mil"],
    ["4010", "4K", "4 mil"],
    ["4100", "4.1K", "4.1 mil"],
    ["5000", "5K", "5 mil"],
    ["5001", "5K", "5 mil"],
    ["5010", "5K", "5 mil"],
    ["5100", "5.1K", "5.1 mil"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 mil"],
    ["9999.12", "10K", "10 mil"],
    ["9999.99", "10K", "10 mil"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 mil"],
    ["-9999.12", "-10K", "-10 mil"],
    ["-9999.99", "-10K", "-10 mil"],
  ],
  "da": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 t", "4,3 tusind"],
    ["54321", "54 t", "54 tusind"],
    ["654321", "654 t", "654 tusind"],
    ["7654321", "7,7 mio.", "7,7 millioner"],
    ["87654321", "88 mio.", "88 millioner"],
    ["987654321", "988 mio.", "988 millioner"],
    ["1087654321", "1,1 mia.", "1,1 milliard"],
    ["11987654321", "12 mia.", "12 milliarder"],
    ["129987654321", "130 mia.", "130 milliarder"],
    ["1398987654321", "1,4 bio.", "1,4 billion"],
    ["14987987654321", "15 bio.", "15 billioner"],
    ["159876987654321", "160 bio.", "160 billioner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 t", "10 tusind"],
    ["99999", "100 t", "100 tusind"],
    ["999999", "1 mio.", "1 million"],
    ["9999999", "10 mio.", "10 millioner"],
    ["99999999", "100 mio.", "100 millioner"],
    ["9994", "10 t", "10 tusind"],
    ["99944", "100 t", "100 tusind"],
    ["999444", "999 t", "999 tusind"],
    ["9994444", "10 mio.", "10 millioner"],
    ["999444444", "999 mio.", "999 millioner"],
    ["9994444444", "10 mia.", "10 milliarder"],
    ["1000000000000000", "1000 bio.", "1000 billioner"],
    ["10000000000000000", "10000 bio.", "10000 billioner"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 t", "-1 tusind"],
    ["-1001", "-1 t", "-1 tusind"],
    ["-1010", "-1 t", "-1 tusind"],
    ["-1100", "-1,1 t", "-1,1 tusind"],
    ["-2000", "-2 t", "-2 tusind"],
    ["-2001", "-2 t", "-2 tusind"],
    ["-2010", "-2 t", "-2 tusind"],
    ["-2100", "-2,1 t", "-2,1 tusind"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 t", "-10 tusind"],
    ["-99999", "-100 t", "-100 tusind"],
    ["-999999", "-1 mio.", "-1 million"],
    ["-9999999", "-10 mio.", "-10 millioner"],
    ["-9999999999999999", "-10000 bio.", "-10000 billioner"],
    ["1000", "1 t", "1 tusind"],
    ["1001", "1 t", "1 tusind"],
    ["1010", "1 t", "1 tusind"],
    ["1100", "1,1 t", "1,1 tusind"],
    ["2000", "2 t", "2 tusind"],
    ["2001", "2 t", "2 tusind"],
    ["2010", "2 t", "2 tusind"],
    ["2100", "2,1 t", "2,1 tusind"],
    ["3000", "3 t", "3 tusind"],
    ["3001", "3 t", "3 tusind"],
    ["3010", "3 t", "3 tusind"],
    ["3100", "3,1 t", "3,1 tusind"],
    ["4000", "4 t", "4 tusind"],
    ["4001", "4 t", "4 tusind"],
    ["4010", "4 t", "4 tusind"],
    ["4100", "4,1 t", "4,1 tusind"],
    ["5000", "5 t", "5 tusind"],
    ["5001", "5 t", "5 tusind"],
    ["5010", "5 t", "5 tusind"],
    ["5100", "5,1 t", "5,1 tusind"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 t", "1 tusind"],
    ["9999.12", "10 t", "10 tusind"],
    ["9999.99", "10 t", "10 tusind"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 t", "-1 tusind"],
    ["-9999.12", "-10 t", "-10 tusind"],
    ["-9999.99", "-10 t", "-10 tusind"],
  ],
  "de": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4,3 Tausend"],
    ["54321", "54321", "54 Tausend"],
    ["654321", "654321", "654 Tausend"],
    ["7654321", "7,7 Mio.", "7,7 Millionen"],
    ["87654321", "88 Mio.", "88 Millionen"],
    ["987654321", "988 Mio.", "988 Millionen"],
    ["1087654321", "1,1 Mrd.", "1,1 Milliarden"],
    ["11987654321", "12 Mrd.", "12 Milliarden"],
    ["129987654321", "130 Mrd.", "130 Milliarden"],
    ["1398987654321", "1,4 Bio.", "1,4 Billionen"],
    ["14987987654321", "15 Bio.", "15 Billionen"],
    ["159876987654321", "160 Bio.", "160 Billionen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "10 Tausend"],
    ["99999", "99999", "100 Tausend"],
    ["999999", "999999", "1 Million"],
    ["9999999", "10 Mio.", "10 Millionen"],
    ["99999999", "100 Mio.", "100 Millionen"],
    ["9994", "9994", "10 Tausend"],
    ["99944", "99944", "100 Tausend"],
    ["999444", "999444", "999 Tausend"],
    ["9994444", "10 Mio.", "10 Millionen"],
    ["999444444", "999 Mio.", "999 Millionen"],
    ["9994444444", "10 Mrd.", "10 Milliarden"],
    ["1000000000000000", "1000 Bio.", "1000 Billionen"],
    ["10000000000000000", "10000 Bio.", "10000 Billionen"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1000", "-1 Tausend"],
    ["-1001", "-1001", "-1 Tausend"],
    ["-1010", "-1010", "-1 Tausend"],
    ["-1100", "-1100", "-1,1 Tausend"],
    ["-2000", "-2000", "-2 Tausend"],
    ["-2001", "-2001", "-2 Tausend"],
    ["-2010", "-2010", "-2 Tausend"],
    ["-2100", "-2100", "-2,1 Tausend"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-9999", "-10 Tausend"],
    ["-99999", "-99999", "-100 Tausend"],
    ["-999999", "-999999", "-1 Million"],
    ["-9999999", "-10 Mio.", "-10 Millionen"],
    ["-9999999999999999", "-10000 Bio.", "-10000 Billionen"],
    ["1000", "1000", "1 Tausend"],
    ["1001", "1001", "1 Tausend"],
    ["1010", "1010", "1 Tausend"],
    ["1100", "1100", "1,1 Tausend"],
    ["2000", "2000", "2 Tausend"],
    ["2001", "2001", "2 Tausend"],
    ["2010", "2010", "2 Tausend"],
    ["2100", "2100", "2,1 Tausend"],
    ["3000", "3000", "3 Tausend"],
    ["3001", "3001", "3 Tausend"],
    ["3010", "3010", "3 Tausend"],
    ["3100", "3100", "3,1 Tausend"],
    ["4000", "4000", "4 Tausend"],
    ["4001", "4001", "4 Tausend"],
    ["4010", "4010", "4 Tausend"],
    ["4100", "4100", "4,1 Tausend"],
    ["5000", "5000", "5 Tausend"],
    ["5001", "5001", "5 Tausend"],
    ["5010", "5010", "5 Tausend"],
    ["5100", "5100", "5,1 Tausend"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1000", "1 Tausend"],
    ["9999.12", "9999", "10 Tausend"],
    ["9999.99", "10000", "10 Tausend"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1000", "-1 Tausend"],
    ["-9999.12", "-9999", "-10 Tausend"],
    ["-9999.99", "-10000", "-10 Tausend"],
  ],
  "de_AT": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4,3 Tausend"],
    ["54321", "54321", "54 Tausend"],
    ["654321", "654321", "654 Tausend"],
    ["7654321", "7,7 Mio.", "7,7 Millionen"],
    ["87654321", "88 Mio.", "88 Millionen"],
    ["987654321", "988 Mio.", "988 Millionen"],
    ["1087654321", "1,1 Mrd.", "1,1 Milliarden"],
    ["11987654321", "12 Mrd.", "12 Milliarden"],
    ["129987654321", "130 Mrd.", "130 Milliarden"],
    ["1398987654321", "1,4 Bio.", "1,4 Billionen"],
    ["14987987654321", "15 Bio.", "15 Billionen"],
    ["159876987654321", "160 Bio.", "160 Billionen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "10 Tausend"],
    ["99999", "99999", "100 Tausend"],
    ["999999", "999999", "1 Million"],
    ["9999999", "10 Mio.", "10 Millionen"],
    ["99999999", "100 Mio.", "100 Millionen"],
    ["9994", "9994", "10 Tausend"],
    ["99944", "99944", "100 Tausend"],
    ["999444", "999444", "999 Tausend"],
    ["9994444", "10 Mio.", "10 Millionen"],
    ["999444444", "999 Mio.", "999 Millionen"],
    ["9994444444", "10 Mrd.", "10 Milliarden"],
    ["1000000000000000", "1000 Bio.", "1000 Billionen"],
    ["10000000000000000", "10000 Bio.", "10000 Billionen"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1000", "-1 Tausend"],
    ["-1001", "-1001", "-1 Tausend"],
    ["-1010", "-1010", "-1 Tausend"],
    ["-1100", "-1100", "-1,1 Tausend"],
    ["-2000", "-2000", "-2 Tausend"],
    ["-2001", "-2001", "-2 Tausend"],
    ["-2010", "-2010", "-2 Tausend"],
    ["-2100", "-2100", "-2,1 Tausend"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-9999", "-10 Tausend"],
    ["-99999", "-99999", "-100 Tausend"],
    ["-999999", "-999999", "-1 Million"],
    ["-9999999", "-10 Mio.", "-10 Millionen"],
    ["-9999999999999999", "-10000 Bio.", "-10000 Billionen"],
    ["1000", "1000", "1 Tausend"],
    ["1001", "1001", "1 Tausend"],
    ["1010", "1010", "1 Tausend"],
    ["1100", "1100", "1,1 Tausend"],
    ["2000", "2000", "2 Tausend"],
    ["2001", "2001", "2 Tausend"],
    ["2010", "2010", "2 Tausend"],
    ["2100", "2100", "2,1 Tausend"],
    ["3000", "3000", "3 Tausend"],
    ["3001", "3001", "3 Tausend"],
    ["3010", "3010", "3 Tausend"],
    ["3100", "3100", "3,1 Tausend"],
    ["4000", "4000", "4 Tausend"],
    ["4001", "4001", "4 Tausend"],
    ["4010", "4010", "4 Tausend"],
    ["4100", "4100", "4,1 Tausend"],
    ["5000", "5000", "5 Tausend"],
    ["5001", "5001", "5 Tausend"],
    ["5010", "5010", "5 Tausend"],
    ["5100", "5100", "5,1 Tausend"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1000", "1 Tausend"],
    ["9999.12", "9999", "10 Tausend"],
    ["9999.99", "10000", "10 Tausend"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1000", "-1 Tausend"],
    ["-9999.12", "-9999", "-10 Tausend"],
    ["-9999.99", "-10000", "-10 Tausend"],
  ],
  "de_CH": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4.3 Tausend"],
    ["54321", "54321", "54 Tausend"],
    ["654321", "654321", "654 Tausend"],
    ["7654321", "7.7 Mio.", "7.7 Millionen"],
    ["87654321", "88 Mio.", "88 Millionen"],
    ["987654321", "988 Mio.", "988 Millionen"],
    ["1087654321", "1.1 Mrd.", "1.1 Milliarden"],
    ["11987654321", "12 Mrd.", "12 Milliarden"],
    ["129987654321", "130 Mrd.", "130 Milliarden"],
    ["1398987654321", "1.4 Bio.", "1.4 Billionen"],
    ["14987987654321", "15 Bio.", "15 Billionen"],
    ["159876987654321", "160 Bio.", "160 Billionen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "10 Tausend"],
    ["99999", "99999", "100 Tausend"],
    ["999999", "999999", "1 Million"],
    ["9999999", "10 Mio.", "10 Millionen"],
    ["99999999", "100 Mio.", "100 Millionen"],
    ["9994", "9994", "10 Tausend"],
    ["99944", "99944", "100 Tausend"],
    ["999444", "999444", "999 Tausend"],
    ["9994444", "10 Mio.", "10 Millionen"],
    ["999444444", "999 Mio.", "999 Millionen"],
    ["9994444444", "10 Mrd.", "10 Milliarden"],
    ["1000000000000000", "1000 Bio.", "1000 Billionen"],
    ["10000000000000000", "10000 Bio.", "10000 Billionen"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1000", "-1 Tausend"],
    ["-1001", "-1001", "-1 Tausend"],
    ["-1010", "-1010", "-1 Tausend"],
    ["-1100", "-1100", "-1.1 Tausend"],
    ["-2000", "-2000", "-2 Tausend"],
    ["-2001", "-2001", "-2 Tausend"],
    ["-2010", "-2010", "-2 Tausend"],
    ["-2100", "-2100", "-2.1 Tausend"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-9999", "-10 Tausend"],
    ["-99999", "-99999", "-100 Tausend"],
    ["-999999", "-999999", "-1 Million"],
    ["-9999999", "-10 Mio.", "-10 Millionen"],
    ["-9999999999999999", "-10000 Bio.", "-10000 Billionen"],
    ["1000", "1000", "1 Tausend"],
    ["1001", "1001", "1 Tausend"],
    ["1010", "1010", "1 Tausend"],
    ["1100", "1100", "1.1 Tausend"],
    ["2000", "2000", "2 Tausend"],
    ["2001", "2001", "2 Tausend"],
    ["2010", "2010", "2 Tausend"],
    ["2100", "2100", "2.1 Tausend"],
    ["3000", "3000", "3 Tausend"],
    ["3001", "3001", "3 Tausend"],
    ["3010", "3010", "3 Tausend"],
    ["3100", "3100", "3.1 Tausend"],
    ["4000", "4000", "4 Tausend"],
    ["4001", "4001", "4 Tausend"],
    ["4010", "4010", "4 Tausend"],
    ["4100", "4100", "4.1 Tausend"],
    ["5000", "5000", "5 Tausend"],
    ["5001", "5001", "5 Tausend"],
    ["5010", "5010", "5 Tausend"],
    ["5100", "5100", "5.1 Tausend"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1000", "1 Tausend"],
    ["9999.12", "9999", "10 Tausend"],
    ["9999.99", "10000", "10 Tausend"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1000", "-1 Tausend"],
    ["-9999.12", "-9999", "-10 Tausend"],
    ["-9999.99", "-10000", "-10 Tausend"],
  ],
  "el": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 χιλ.", "4,3 χιλιάδες"],
    ["54321", "54 χιλ.", "54 χιλιάδες"],
    ["654321", "654 χιλ.", "654 χιλιάδες"],
    ["7654321", "7,7 εκ.", "7,7 εκατομμύρια"],
    ["87654321", "88 εκ.", "88 εκατομμύρια"],
    ["987654321", "988 εκ.", "988 εκατομμύρια"],
    ["1087654321", "1,1 δισ.", "1,1 δισεκατομμύρια"],
    ["11987654321", "12 δισ.", "12 δισεκατομμύρια"],
    ["129987654321", "130 δισ.", "130 δισεκατομμύρια"],
    ["1398987654321", "1,4 τρισ.", "1,4 τρισεκατομμύρια"],
    ["14987987654321", "15 τρισ.", "15 τρισεκατομμύρια"],
    ["159876987654321", "160 τρισ.", "160 τρισεκατομμύρια"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 χιλ.", "10 χιλιάδες"],
    ["99999", "100 χιλ.", "100 χιλιάδες"],
    ["999999", "1 εκ.", "1 εκατομμύριο"],
    ["9999999", "10 εκ.", "10 εκατομμύρια"],
    ["99999999", "100 εκ.", "100 εκατομμύρια"],
    ["9994", "10 χιλ.", "10 χιλιάδες"],
    ["99944", "100 χιλ.", "100 χιλιάδες"],
    ["999444", "999 χιλ.", "999 χιλιάδες"],
    ["9994444", "10 εκ.", "10 εκατομμύρια"],
    ["999444444", "999 εκ.", "999 εκατομμύρια"],
    ["9994444444", "10 δισ.", "10 δισεκατομμύρια"],
    ["1000000000000000", "1000 τρισ.", "1000 τρισεκατομμύρια"],
    ["10000000000000000", "10000 τρισ.", "10000 τρισεκατομμύρια"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 χιλ.", "-1 χιλιάδα"],
    ["-1001", "-1 χιλ.", "-1 χιλιάδα"],
    ["-1010", "-1 χιλ.", "-1 χιλιάδα"],
    ["-1100", "-1,1 χιλ.", "-1,1 χιλιάδες"],
    ["-2000", "-2 χιλ.", "-2 χιλιάδες"],
    ["-2001", "-2 χιλ.", "-2 χιλιάδες"],
    ["-2010", "-2 χιλ.", "-2 χιλιάδες"],
    ["-2100", "-2,1 χιλ.", "-2,1 χιλιάδες"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 χιλ.", "-10 χιλιάδες"],
    ["-99999", "-100 χιλ.", "-100 χιλιάδες"],
    ["-999999", "-1 εκ.", "-1 εκατομμύριο"],
    ["-9999999", "-10 εκ.", "-10 εκατομμύρια"],
    ["-9999999999999999", "-10000 τρισ.", "-10000 τρισεκατομμύρια"],
    ["1000", "1 χιλ.", "1 χιλιάδα"],
    ["1001", "1 χιλ.", "1 χιλιάδα"],
    ["1010", "1 χιλ.", "1 χιλιάδα"],
    ["1100", "1,1 χιλ.", "1,1 χιλιάδες"],
    ["2000", "2 χιλ.", "2 χιλιάδες"],
    ["2001", "2 χιλ.", "2 χιλιάδες"],
    ["2010", "2 χιλ.", "2 χιλιάδες"],
    ["2100", "2,1 χιλ.", "2,1 χιλιάδες"],
    ["3000", "3 χιλ.", "3 χιλιάδες"],
    ["3001", "3 χιλ.", "3 χιλιάδες"],
    ["3010", "3 χιλ.", "3 χιλιάδες"],
    ["3100", "3,1 χιλ.", "3,1 χιλιάδες"],
    ["4000", "4 χιλ.", "4 χιλιάδες"],
    ["4001", "4 χιλ.", "4 χιλιάδες"],
    ["4010", "4 χιλ.", "4 χιλιάδες"],
    ["4100", "4,1 χιλ.", "4,1 χιλιάδες"],
    ["5000", "5 χιλ.", "5 χιλιάδες"],
    ["5001", "5 χιλ.", "5 χιλιάδες"],
    ["5010", "5 χιλ.", "5 χιλιάδες"],
    ["5100", "5,1 χιλ.", "5,1 χιλιάδες"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 χιλ.", "1 χιλιάδα"],
    ["9999.12", "10 χιλ.", "10 χιλιάδες"],
    ["9999.99", "10 χιλ.", "10 χιλιάδες"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 χιλ.", "-1 χιλιάδα"],
    ["-9999.12", "-10 χιλ.", "-10 χιλιάδες"],
    ["-9999.99", "-10 χιλ.", "-10 χιλιάδες"],
  ],
  "en": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
    ["1000000000000000", "1000T", "1000 trillion"],
    ["10000000000000000", "10000T", "10000 trillion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 thousand"],
    ["-1001", "-1K", "-1 thousand"],
    ["-1010", "-1K", "-1 thousand"],
    ["-1100", "-1.1K", "-1.1 thousand"],
    ["-2000", "-2K", "-2 thousand"],
    ["-2001", "-2K", "-2 thousand"],
    ["-2010", "-2K", "-2 thousand"],
    ["-2100", "-2.1K", "-2.1 thousand"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 thousand"],
    ["-99999", "-100K", "-100 thousand"],
    ["-999999", "-1M", "-1 million"],
    ["-9999999", "-10M", "-10 million"],
    ["-9999999999999999", "-10000T", "-10000 trillion"],
    ["1000", "1K", "1 thousand"],
    ["1001", "1K", "1 thousand"],
    ["1010", "1K", "1 thousand"],
    ["1100", "1.1K", "1.1 thousand"],
    ["2000", "2K", "2 thousand"],
    ["2001", "2K", "2 thousand"],
    ["2010", "2K", "2 thousand"],
    ["2100", "2.1K", "2.1 thousand"],
    ["3000", "3K", "3 thousand"],
    ["3001", "3K", "3 thousand"],
    ["3010", "3K", "3 thousand"],
    ["3100", "3.1K", "3.1 thousand"],
    ["4000", "4K", "4 thousand"],
    ["4001", "4K", "4 thousand"],
    ["4010", "4K", "4 thousand"],
    ["4100", "4.1K", "4.1 thousand"],
    ["5000", "5K", "5 thousand"],
    ["5001", "5K", "5 thousand"],
    ["5010", "5K", "5 thousand"],
    ["5100", "5.1K", "5.1 thousand"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 thousand"],
    ["9999.12", "10K", "10 thousand"],
    ["9999.99", "10K", "10 thousand"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 thousand"],
    ["-9999.12", "-10K", "-10 thousand"],
    ["-9999.99", "-10K", "-10 thousand"],
  ],
  "en_AU": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
    ["1000000000000000", "1000T", "1000 trillion"],
    ["10000000000000000", "10000T", "10000 trillion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 thousand"],
    ["-1001", "-1K", "-1 thousand"],
    ["-1010", "-1K", "-1 thousand"],
    ["-1100", "-1.1K", "-1.1 thousand"],
    ["-2000", "-2K", "-2 thousand"],
    ["-2001", "-2K", "-2 thousand"],
    ["-2010", "-2K", "-2 thousand"],
    ["-2100", "-2.1K", "-2.1 thousand"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 thousand"],
    ["-99999", "-100K", "-100 thousand"],
    ["-999999", "-1M", "-1 million"],
    ["-9999999", "-10M", "-10 million"],
    ["-9999999999999999", "-10000T", "-10000 trillion"],
    ["1000", "1K", "1 thousand"],
    ["1001", "1K", "1 thousand"],
    ["1010", "1K", "1 thousand"],
    ["1100", "1.1K", "1.1 thousand"],
    ["2000", "2K", "2 thousand"],
    ["2001", "2K", "2 thousand"],
    ["2010", "2K", "2 thousand"],
    ["2100", "2.1K", "2.1 thousand"],
    ["3000", "3K", "3 thousand"],
    ["3001", "3K", "3 thousand"],
    ["3010", "3K", "3 thousand"],
    ["3100", "3.1K", "3.1 thousand"],
    ["4000", "4K", "4 thousand"],
    ["4001", "4K", "4 thousand"],
    ["4010", "4K", "4 thousand"],
    ["4100", "4.1K", "4.1 thousand"],
    ["5000", "5K", "5 thousand"],
    ["5001", "5K", "5 thousand"],
    ["5010", "5K", "5 thousand"],
    ["5100", "5.1K", "5.1 thousand"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 thousand"],
    ["9999.12", "10K", "10 thousand"],
    ["9999.99", "10K", "10 thousand"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 thousand"],
    ["-9999.12", "-10K", "-10 thousand"],
    ["-9999.99", "-10K", "-10 thousand"],
  ],
  "en_CA": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
    ["1000000000000000", "1000T", "1000 trillion"],
    ["10000000000000000", "10000T", "10000 trillion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 thousand"],
    ["-1001", "-1K", "-1 thousand"],
    ["-1010", "-1K", "-1 thousand"],
    ["-1100", "-1.1K", "-1.1 thousand"],
    ["-2000", "-2K", "-2 thousand"],
    ["-2001", "-2K", "-2 thousand"],
    ["-2010", "-2K", "-2 thousand"],
    ["-2100", "-2.1K", "-2.1 thousand"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 thousand"],
    ["-99999", "-100K", "-100 thousand"],
    ["-999999", "-1M", "-1 million"],
    ["-9999999", "-10M", "-10 million"],
    ["-9999999999999999", "-10000T", "-10000 trillion"],
    ["1000", "1K", "1 thousand"],
    ["1001", "1K", "1 thousand"],
    ["1010", "1K", "1 thousand"],
    ["1100", "1.1K", "1.1 thousand"],
    ["2000", "2K", "2 thousand"],
    ["2001", "2K", "2 thousand"],
    ["2010", "2K", "2 thousand"],
    ["2100", "2.1K", "2.1 thousand"],
    ["3000", "3K", "3 thousand"],
    ["3001", "3K", "3 thousand"],
    ["3010", "3K", "3 thousand"],
    ["3100", "3.1K", "3.1 thousand"],
    ["4000", "4K", "4 thousand"],
    ["4001", "4K", "4 thousand"],
    ["4010", "4K", "4 thousand"],
    ["4100", "4.1K", "4.1 thousand"],
    ["5000", "5K", "5 thousand"],
    ["5001", "5K", "5 thousand"],
    ["5010", "5K", "5 thousand"],
    ["5100", "5.1K", "5.1 thousand"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 thousand"],
    ["9999.12", "10K", "10 thousand"],
    ["9999.99", "10K", "10 thousand"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 thousand"],
    ["-9999.12", "-10K", "-10 thousand"],
    ["-9999.99", "-10K", "-10 thousand"],
  ],
  "en_GB": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
    ["1000000000000000", "1000T", "1000 trillion"],
    ["10000000000000000", "10000T", "10000 trillion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 thousand"],
    ["-1001", "-1K", "-1 thousand"],
    ["-1010", "-1K", "-1 thousand"],
    ["-1100", "-1.1K", "-1.1 thousand"],
    ["-2000", "-2K", "-2 thousand"],
    ["-2001", "-2K", "-2 thousand"],
    ["-2010", "-2K", "-2 thousand"],
    ["-2100", "-2.1K", "-2.1 thousand"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 thousand"],
    ["-99999", "-100K", "-100 thousand"],
    ["-999999", "-1M", "-1 million"],
    ["-9999999", "-10M", "-10 million"],
    ["-9999999999999999", "-10000T", "-10000 trillion"],
    ["1000", "1K", "1 thousand"],
    ["1001", "1K", "1 thousand"],
    ["1010", "1K", "1 thousand"],
    ["1100", "1.1K", "1.1 thousand"],
    ["2000", "2K", "2 thousand"],
    ["2001", "2K", "2 thousand"],
    ["2010", "2K", "2 thousand"],
    ["2100", "2.1K", "2.1 thousand"],
    ["3000", "3K", "3 thousand"],
    ["3001", "3K", "3 thousand"],
    ["3010", "3K", "3 thousand"],
    ["3100", "3.1K", "3.1 thousand"],
    ["4000", "4K", "4 thousand"],
    ["4001", "4K", "4 thousand"],
    ["4010", "4K", "4 thousand"],
    ["4100", "4.1K", "4.1 thousand"],
    ["5000", "5K", "5 thousand"],
    ["5001", "5K", "5 thousand"],
    ["5010", "5K", "5 thousand"],
    ["5100", "5.1K", "5.1 thousand"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 thousand"],
    ["9999.12", "10K", "10 thousand"],
    ["9999.99", "10K", "10 thousand"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 thousand"],
    ["-9999.12", "-10K", "-10 thousand"],
    ["-9999.99", "-10K", "-10 thousand"],
  ],
  "en_IE": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
    ["1000000000000000", "1000T", "1000 trillion"],
    ["10000000000000000", "10000T", "10000 trillion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 thousand"],
    ["-1001", "-1K", "-1 thousand"],
    ["-1010", "-1K", "-1 thousand"],
    ["-1100", "-1.1K", "-1.1 thousand"],
    ["-2000", "-2K", "-2 thousand"],
    ["-2001", "-2K", "-2 thousand"],
    ["-2010", "-2K", "-2 thousand"],
    ["-2100", "-2.1K", "-2.1 thousand"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 thousand"],
    ["-99999", "-100K", "-100 thousand"],
    ["-999999", "-1M", "-1 million"],
    ["-9999999", "-10M", "-10 million"],
    ["-9999999999999999", "-10000T", "-10000 trillion"],
    ["1000", "1K", "1 thousand"],
    ["1001", "1K", "1 thousand"],
    ["1010", "1K", "1 thousand"],
    ["1100", "1.1K", "1.1 thousand"],
    ["2000", "2K", "2 thousand"],
    ["2001", "2K", "2 thousand"],
    ["2010", "2K", "2 thousand"],
    ["2100", "2.1K", "2.1 thousand"],
    ["3000", "3K", "3 thousand"],
    ["3001", "3K", "3 thousand"],
    ["3010", "3K", "3 thousand"],
    ["3100", "3.1K", "3.1 thousand"],
    ["4000", "4K", "4 thousand"],
    ["4001", "4K", "4 thousand"],
    ["4010", "4K", "4 thousand"],
    ["4100", "4.1K", "4.1 thousand"],
    ["5000", "5K", "5 thousand"],
    ["5001", "5K", "5 thousand"],
    ["5010", "5K", "5 thousand"],
    ["5100", "5.1K", "5.1 thousand"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 thousand"],
    ["9999.12", "10K", "10 thousand"],
    ["9999.99", "10K", "10 thousand"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 thousand"],
    ["-9999.12", "-10K", "-10 thousand"],
    ["-9999.99", "-10K", "-10 thousand"],
  ],
  "en_IN": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3T", "4.3 thousand"],
    ["54321", "54T", "54 thousand"],
    ["654321", "6.5L", "654 thousand"],
    ["7654321", "77L", "7.7 million"],
    ["87654321", "8.8Cr", "88 million"],
    ["987654321", "99Cr", "988 million"],
    ["1087654321", "109Cr", "1.1 billion"],
    ["11987654321", "1.2TCr", "12 billion"],
    ["129987654321", "13TCr", "130 billion"],
    ["1398987654321", "1.4LCr", "1.4 trillion"],
    ["14987987654321", "15LCr", "15 trillion"],
    ["159876987654321", "160LCr", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10T", "10 thousand"],
    ["99999", "1L", "100 thousand"],
    ["999999", "10L", "1 million"],
    ["9999999", "1Cr", "10 million"],
    ["99999999", "10Cr", "100 million"],
    ["9994", "10T", "10 thousand"],
    ["99944", "1L", "100 thousand"],
    ["999444", "10L", "999 thousand"],
    ["9994444", "1Cr", "10 million"],
    ["999444444", "100Cr", "999 million"],
    ["9994444444", "999Cr", "10 billion"],
    ["1000000000000000", "1000LCr", "1000 trillion"],
    ["10000000000000000", "10000LCr", "10000 trillion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1T", "-1 thousand"],
    ["-1001", "-1T", "-1 thousand"],
    ["-1010", "-1T", "-1 thousand"],
    ["-1100", "-1.1T", "-1.1 thousand"],
    ["-2000", "-2T", "-2 thousand"],
    ["-2001", "-2T", "-2 thousand"],
    ["-2010", "-2T", "-2 thousand"],
    ["-2100", "-2.1T", "-2.1 thousand"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10T", "-10 thousand"],
    ["-99999", "-1L", "-100 thousand"],
    ["-999999", "-10L", "-1 million"],
    ["-9999999", "-1Cr", "-10 million"],
    ["-9999999999999999", "-10000LCr", "-10000 trillion"],
    ["1000", "1T", "1 thousand"],
    ["1001", "1T", "1 thousand"],
    ["1010", "1T", "1 thousand"],
    ["1100", "1.1T", "1.1 thousand"],
    ["2000", "2T", "2 thousand"],
    ["2001", "2T", "2 thousand"],
    ["2010", "2T", "2 thousand"],
    ["2100", "2.1T", "2.1 thousand"],
    ["3000", "3T", "3 thousand"],
    ["3001", "3T", "3 thousand"],
    ["3010", "3T", "3 thousand"],
    ["3100", "3.1T", "3.1 thousand"],
    ["4000", "4T", "4 thousand"],
    ["4001", "4T", "4 thousand"],
    ["4010", "4T", "4 thousand"],
    ["4100", "4.1T", "4.1 thousand"],
    ["5000", "5T", "5 thousand"],
    ["5001", "5T", "5 thousand"],
    ["5010", "5T", "5 thousand"],
    ["5100", "5.1T", "5.1 thousand"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1T", "1 thousand"],
    ["9999.12", "10T", "10 thousand"],
    ["9999.99", "10T", "10 thousand"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1T", "-1 thousand"],
    ["-9999.12", "-10T", "-10 thousand"],
    ["-9999.99", "-10T", "-10 thousand"],
  ],
  "en_MY": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
    ["1000000000000000", "1000T", "1000 trillion"],
    ["10000000000000000", "10000T", "10000 trillion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 thousand"],
    ["-1001", "-1K", "-1 thousand"],
    ["-1010", "-1K", "-1 thousand"],
    ["-1100", "-1.1K", "-1.1 thousand"],
    ["-2000", "-2K", "-2 thousand"],
    ["-2001", "-2K", "-2 thousand"],
    ["-2010", "-2K", "-2 thousand"],
    ["-2100", "-2.1K", "-2.1 thousand"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 thousand"],
    ["-99999", "-100K", "-100 thousand"],
    ["-999999", "-1M", "-1 million"],
    ["-9999999", "-10M", "-10 million"],
    ["-9999999999999999", "-10000T", "-10000 trillion"],
    ["1000", "1K", "1 thousand"],
    ["1001", "1K", "1 thousand"],
    ["1010", "1K", "1 thousand"],
    ["1100", "1.1K", "1.1 thousand"],
    ["2000", "2K", "2 thousand"],
    ["2001", "2K", "2 thousand"],
    ["2010", "2K", "2 thousand"],
    ["2100", "2.1K", "2.1 thousand"],
    ["3000", "3K", "3 thousand"],
    ["3001", "3K", "3 thousand"],
    ["3010", "3K", "3 thousand"],
    ["3100", "3.1K", "3.1 thousand"],
    ["4000", "4K", "4 thousand"],
    ["4001", "4K", "4 thousand"],
    ["4010", "4K", "4 thousand"],
    ["4100", "4.1K", "4.1 thousand"],
    ["5000", "5K", "5 thousand"],
    ["5001", "5K", "5 thousand"],
    ["5010", "5K", "5 thousand"],
    ["5100", "5.1K", "5.1 thousand"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 thousand"],
    ["9999.12", "10K", "10 thousand"],
    ["9999.99", "10K", "10 thousand"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 thousand"],
    ["-9999.12", "-10K", "-10 thousand"],
    ["-9999.99", "-10K", "-10 thousand"],
  ],
  "en_NZ": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
    ["1000000000000000", "1000T", "1000 trillion"],
    ["10000000000000000", "10000T", "10000 trillion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 thousand"],
    ["-1001", "-1K", "-1 thousand"],
    ["-1010", "-1K", "-1 thousand"],
    ["-1100", "-1.1K", "-1.1 thousand"],
    ["-2000", "-2K", "-2 thousand"],
    ["-2001", "-2K", "-2 thousand"],
    ["-2010", "-2K", "-2 thousand"],
    ["-2100", "-2.1K", "-2.1 thousand"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 thousand"],
    ["-99999", "-100K", "-100 thousand"],
    ["-999999", "-1M", "-1 million"],
    ["-9999999", "-10M", "-10 million"],
    ["-9999999999999999", "-10000T", "-10000 trillion"],
    ["1000", "1K", "1 thousand"],
    ["1001", "1K", "1 thousand"],
    ["1010", "1K", "1 thousand"],
    ["1100", "1.1K", "1.1 thousand"],
    ["2000", "2K", "2 thousand"],
    ["2001", "2K", "2 thousand"],
    ["2010", "2K", "2 thousand"],
    ["2100", "2.1K", "2.1 thousand"],
    ["3000", "3K", "3 thousand"],
    ["3001", "3K", "3 thousand"],
    ["3010", "3K", "3 thousand"],
    ["3100", "3.1K", "3.1 thousand"],
    ["4000", "4K", "4 thousand"],
    ["4001", "4K", "4 thousand"],
    ["4010", "4K", "4 thousand"],
    ["4100", "4.1K", "4.1 thousand"],
    ["5000", "5K", "5 thousand"],
    ["5001", "5K", "5 thousand"],
    ["5010", "5K", "5 thousand"],
    ["5100", "5.1K", "5.1 thousand"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 thousand"],
    ["9999.12", "10K", "10 thousand"],
    ["9999.99", "10K", "10 thousand"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 thousand"],
    ["-9999.12", "-10K", "-10 thousand"],
    ["-9999.99", "-10K", "-10 thousand"],
  ],
  "en_SG": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
    ["1000000000000000", "1000T", "1000 trillion"],
    ["10000000000000000", "10000T", "10000 trillion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 thousand"],
    ["-1001", "-1K", "-1 thousand"],
    ["-1010", "-1K", "-1 thousand"],
    ["-1100", "-1.1K", "-1.1 thousand"],
    ["-2000", "-2K", "-2 thousand"],
    ["-2001", "-2K", "-2 thousand"],
    ["-2010", "-2K", "-2 thousand"],
    ["-2100", "-2.1K", "-2.1 thousand"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 thousand"],
    ["-99999", "-100K", "-100 thousand"],
    ["-999999", "-1M", "-1 million"],
    ["-9999999", "-10M", "-10 million"],
    ["-9999999999999999", "-10000T", "-10000 trillion"],
    ["1000", "1K", "1 thousand"],
    ["1001", "1K", "1 thousand"],
    ["1010", "1K", "1 thousand"],
    ["1100", "1.1K", "1.1 thousand"],
    ["2000", "2K", "2 thousand"],
    ["2001", "2K", "2 thousand"],
    ["2010", "2K", "2 thousand"],
    ["2100", "2.1K", "2.1 thousand"],
    ["3000", "3K", "3 thousand"],
    ["3001", "3K", "3 thousand"],
    ["3010", "3K", "3 thousand"],
    ["3100", "3.1K", "3.1 thousand"],
    ["4000", "4K", "4 thousand"],
    ["4001", "4K", "4 thousand"],
    ["4010", "4K", "4 thousand"],
    ["4100", "4.1K", "4.1 thousand"],
    ["5000", "5K", "5 thousand"],
    ["5001", "5K", "5 thousand"],
    ["5010", "5K", "5 thousand"],
    ["5100", "5.1K", "5.1 thousand"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 thousand"],
    ["9999.12", "10K", "10 thousand"],
    ["9999.99", "10K", "10 thousand"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 thousand"],
    ["-9999.12", "-10K", "-10 thousand"],
    ["-9999.99", "-10K", "-10 thousand"],
  ],
  "en_US": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
    ["1000000000000000", "1000T", "1000 trillion"],
    ["10000000000000000", "10000T", "10000 trillion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 thousand"],
    ["-1001", "-1K", "-1 thousand"],
    ["-1010", "-1K", "-1 thousand"],
    ["-1100", "-1.1K", "-1.1 thousand"],
    ["-2000", "-2K", "-2 thousand"],
    ["-2001", "-2K", "-2 thousand"],
    ["-2010", "-2K", "-2 thousand"],
    ["-2100", "-2.1K", "-2.1 thousand"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 thousand"],
    ["-99999", "-100K", "-100 thousand"],
    ["-999999", "-1M", "-1 million"],
    ["-9999999", "-10M", "-10 million"],
    ["-9999999999999999", "-10000T", "-10000 trillion"],
    ["1000", "1K", "1 thousand"],
    ["1001", "1K", "1 thousand"],
    ["1010", "1K", "1 thousand"],
    ["1100", "1.1K", "1.1 thousand"],
    ["2000", "2K", "2 thousand"],
    ["2001", "2K", "2 thousand"],
    ["2010", "2K", "2 thousand"],
    ["2100", "2.1K", "2.1 thousand"],
    ["3000", "3K", "3 thousand"],
    ["3001", "3K", "3 thousand"],
    ["3010", "3K", "3 thousand"],
    ["3100", "3.1K", "3.1 thousand"],
    ["4000", "4K", "4 thousand"],
    ["4001", "4K", "4 thousand"],
    ["4010", "4K", "4 thousand"],
    ["4100", "4.1K", "4.1 thousand"],
    ["5000", "5K", "5 thousand"],
    ["5001", "5K", "5 thousand"],
    ["5010", "5K", "5 thousand"],
    ["5100", "5.1K", "5.1 thousand"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 thousand"],
    ["9999.12", "10K", "10 thousand"],
    ["9999.99", "10K", "10 thousand"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 thousand"],
    ["-9999.12", "-10K", "-10 thousand"],
    ["-9999.99", "-10K", "-10 thousand"],
  ],
  "en_ZA": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
    ["1000000000000000", "1000T", "1000 trillion"],
    ["10000000000000000", "10000T", "10000 trillion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 thousand"],
    ["-1001", "-1K", "-1 thousand"],
    ["-1010", "-1K", "-1 thousand"],
    ["-1100", "-1.1K", "-1.1 thousand"],
    ["-2000", "-2K", "-2 thousand"],
    ["-2001", "-2K", "-2 thousand"],
    ["-2010", "-2K", "-2 thousand"],
    ["-2100", "-2.1K", "-2.1 thousand"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 thousand"],
    ["-99999", "-100K", "-100 thousand"],
    ["-999999", "-1M", "-1 million"],
    ["-9999999", "-10M", "-10 million"],
    ["-9999999999999999", "-10000T", "-10000 trillion"],
    ["1000", "1K", "1 thousand"],
    ["1001", "1K", "1 thousand"],
    ["1010", "1K", "1 thousand"],
    ["1100", "1.1K", "1.1 thousand"],
    ["2000", "2K", "2 thousand"],
    ["2001", "2K", "2 thousand"],
    ["2010", "2K", "2 thousand"],
    ["2100", "2.1K", "2.1 thousand"],
    ["3000", "3K", "3 thousand"],
    ["3001", "3K", "3 thousand"],
    ["3010", "3K", "3 thousand"],
    ["3100", "3.1K", "3.1 thousand"],
    ["4000", "4K", "4 thousand"],
    ["4001", "4K", "4 thousand"],
    ["4010", "4K", "4 thousand"],
    ["4100", "4.1K", "4.1 thousand"],
    ["5000", "5K", "5 thousand"],
    ["5001", "5K", "5 thousand"],
    ["5010", "5K", "5 thousand"],
    ["5100", "5.1K", "5.1 thousand"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 thousand"],
    ["9999.12", "10K", "10 thousand"],
    ["9999.99", "10K", "10 thousand"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 thousand"],
    ["-9999.12", "-10K", "-10 thousand"],
    ["-9999.99", "-10K", "-10 thousand"],
  ],
  "es": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 mil", "4,3 mil"],
    ["54321", "54 mil", "54 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,7 M", "7,7 millones"],
    ["87654321", "88 M", "88 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1088 M", "1,1 mil millones"],
    ["11987654321", "12 mil M", "12 mil millones"],
    ["129987654321", "130 mil M", "130 mil millones"],
    ["1398987654321", "1,4 B", "1,4 billones"],
    ["14987987654321", "15 B", "15 billones"],
    ["159876987654321", "160 B", "160 billones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "10 mil", "10 mil"],
    ["99944", "100 mil", "100 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "10 M", "10 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "9994 M", "10 mil millones"],
    ["1000000000000000", "1000 B", "1000 billones"],
    ["10000000000000000", "10000 B", "10000 billones"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 mil", "-1 mil"],
    ["-1001", "-1 mil", "-1 mil"],
    ["-1010", "-1 mil", "-1 mil"],
    ["-1100", "-1,1 mil", "-1,1 mil"],
    ["-2000", "-2 mil", "-2 mil"],
    ["-2001", "-2 mil", "-2 mil"],
    ["-2010", "-2 mil", "-2 mil"],
    ["-2100", "-2,1 mil", "-2,1 mil"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 mil", "-10 mil"],
    ["-99999", "-100 mil", "-100 mil"],
    ["-999999", "-1 M", "-1 millón"],
    ["-9999999", "-10 M", "-10 millones"],
    ["-9999999999999999", "-10000 B", "-10000 billones"],
    ["1000", "1 mil", "1 mil"],
    ["1001", "1 mil", "1 mil"],
    ["1010", "1 mil", "1 mil"],
    ["1100", "1,1 mil", "1,1 mil"],
    ["2000", "2 mil", "2 mil"],
    ["2001", "2 mil", "2 mil"],
    ["2010", "2 mil", "2 mil"],
    ["2100", "2,1 mil", "2,1 mil"],
    ["3000", "3 mil", "3 mil"],
    ["3001", "3 mil", "3 mil"],
    ["3010", "3 mil", "3 mil"],
    ["3100", "3,1 mil", "3,1 mil"],
    ["4000", "4 mil", "4 mil"],
    ["4001", "4 mil", "4 mil"],
    ["4010", "4 mil", "4 mil"],
    ["4100", "4,1 mil", "4,1 mil"],
    ["5000", "5 mil", "5 mil"],
    ["5001", "5 mil", "5 mil"],
    ["5010", "5 mil", "5 mil"],
    ["5100", "5,1 mil", "5,1 mil"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 mil", "1 mil"],
    ["9999.12", "10 mil", "10 mil"],
    ["9999.99", "10 mil", "10 mil"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 mil", "-1 mil"],
    ["-9999.12", "-10 mil", "-10 mil"],
    ["-9999.99", "-10 mil", "-10 mil"],
  ],
  "es_419": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 K", "4.3 mil"],
    ["54321", "54 k", "54 mil"],
    ["654321", "654 k", "654 mil"],
    ["7654321", "7.7 M", "7.7 millones"],
    ["87654321", "88 M", "88 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1088 M", "1.1 mil millones"],
    ["11987654321", "12 mil M", "12 mil millones"],
    ["129987654321", "130 mil M", "130 mil millones"],
    ["1398987654321", "1.4 B", "1.4 billón"],
    ["14987987654321", "15 B", "15 billones"],
    ["159876987654321", "160 B", "160 billones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mil"],
    ["99999", "100 k", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "10 k", "10 mil"],
    ["99944", "100 k", "100 mil"],
    ["999444", "999 k", "999 mil"],
    ["9994444", "10 M", "10 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "9994 M", "10 mil millones"],
    ["1000000000000000", "1000 B", "1000 billones"],
    ["10000000000000000", "10000 B", "10000 billones"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 K", "-1 mil"],
    ["-1001", "-1 K", "-1 mil"],
    ["-1010", "-1 K", "-1 mil"],
    ["-1100", "-1.1 K", "-1.1 mil"],
    ["-2000", "-2 K", "-2 mil"],
    ["-2001", "-2 K", "-2 mil"],
    ["-2010", "-2 K", "-2 mil"],
    ["-2100", "-2.1 K", "-2.1 mil"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 k", "-10 mil"],
    ["-99999", "-100 k", "-100 mil"],
    ["-999999", "-1 M", "-1 millón"],
    ["-9999999", "-10 M", "-10 millones"],
    ["-9999999999999999", "-10000 B", "-10000 billones"],
    ["1000", "1 K", "1 mil"],
    ["1001", "1 K", "1 mil"],
    ["1010", "1 K", "1 mil"],
    ["1100", "1.1 K", "1.1 mil"],
    ["2000", "2 K", "2 mil"],
    ["2001", "2 K", "2 mil"],
    ["2010", "2 K", "2 mil"],
    ["2100", "2.1 K", "2.1 mil"],
    ["3000", "3 K", "3 mil"],
    ["3001", "3 K", "3 mil"],
    ["3010", "3 K", "3 mil"],
    ["3100", "3.1 K", "3.1 mil"],
    ["4000", "4 K", "4 mil"],
    ["4001", "4 K", "4 mil"],
    ["4010", "4 K", "4 mil"],
    ["4100", "4.1 K", "4.1 mil"],
    ["5000", "5 K", "5 mil"],
    ["5001", "5 K", "5 mil"],
    ["5010", "5 K", "5 mil"],
    ["5100", "5.1 K", "5.1 mil"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 K", "1 mil"],
    ["9999.12", "10 k", "10 mil"],
    ["9999.99", "10 k", "10 mil"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 K", "-1 mil"],
    ["-9999.12", "-10 k", "-10 mil"],
    ["-9999.99", "-10 k", "-10 mil"],
  ],
  "es_ES": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 mil", "4,3 mil"],
    ["54321", "54 mil", "54 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,7 M", "7,7 millones"],
    ["87654321", "88 M", "88 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1088 M", "1,1 mil millones"],
    ["11987654321", "12 mil M", "12 mil millones"],
    ["129987654321", "130 mil M", "130 mil millones"],
    ["1398987654321", "1,4 B", "1,4 billones"],
    ["14987987654321", "15 B", "15 billones"],
    ["159876987654321", "160 B", "160 billones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "10 mil", "10 mil"],
    ["99944", "100 mil", "100 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "10 M", "10 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "9994 M", "10 mil millones"],
    ["1000000000000000", "1000 B", "1000 billones"],
    ["10000000000000000", "10000 B", "10000 billones"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 mil", "-1 mil"],
    ["-1001", "-1 mil", "-1 mil"],
    ["-1010", "-1 mil", "-1 mil"],
    ["-1100", "-1,1 mil", "-1,1 mil"],
    ["-2000", "-2 mil", "-2 mil"],
    ["-2001", "-2 mil", "-2 mil"],
    ["-2010", "-2 mil", "-2 mil"],
    ["-2100", "-2,1 mil", "-2,1 mil"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 mil", "-10 mil"],
    ["-99999", "-100 mil", "-100 mil"],
    ["-999999", "-1 M", "-1 millón"],
    ["-9999999", "-10 M", "-10 millones"],
    ["-9999999999999999", "-10000 B", "-10000 billones"],
    ["1000", "1 mil", "1 mil"],
    ["1001", "1 mil", "1 mil"],
    ["1010", "1 mil", "1 mil"],
    ["1100", "1,1 mil", "1,1 mil"],
    ["2000", "2 mil", "2 mil"],
    ["2001", "2 mil", "2 mil"],
    ["2010", "2 mil", "2 mil"],
    ["2100", "2,1 mil", "2,1 mil"],
    ["3000", "3 mil", "3 mil"],
    ["3001", "3 mil", "3 mil"],
    ["3010", "3 mil", "3 mil"],
    ["3100", "3,1 mil", "3,1 mil"],
    ["4000", "4 mil", "4 mil"],
    ["4001", "4 mil", "4 mil"],
    ["4010", "4 mil", "4 mil"],
    ["4100", "4,1 mil", "4,1 mil"],
    ["5000", "5 mil", "5 mil"],
    ["5001", "5 mil", "5 mil"],
    ["5010", "5 mil", "5 mil"],
    ["5100", "5,1 mil", "5,1 mil"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 mil", "1 mil"],
    ["9999.12", "10 mil", "10 mil"],
    ["9999.99", "10 mil", "10 mil"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 mil", "-1 mil"],
    ["-9999.12", "-10 mil", "-10 mil"],
    ["-9999.99", "-10 mil", "-10 mil"],
  ],
  "es_MX": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 k", "4.3 mil"],
    ["54321", "54 k", "54 mil"],
    ["654321", "654 k", "654 mil"],
    ["7654321", "7.7 M", "7.7 millones"],
    ["87654321", "88 M", "88 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1088 M", "1.1 mil millones"],
    ["11987654321", "12 mil M", "12 mil millones"],
    ["129987654321", "130 mil M", "130 mil millones"],
    ["1398987654321", "1.4 B", "1.4 billones"],
    ["14987987654321", "15 B", "15 billones"],
    ["159876987654321", "160 B", "160 billones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mil"],
    ["99999", "100 k", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "10 k", "10 mil"],
    ["99944", "100 k", "100 mil"],
    ["999444", "999 k", "999 mil"],
    ["9994444", "10 M", "10 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "9994 M", "10 mil millones"],
    ["1000000000000000", "1000 B", "1000 billones"],
    ["10000000000000000", "10000 B", "10000 billones"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 k", "-1 mil"],
    ["-1001", "-1 k", "-1 mil"],
    ["-1010", "-1 k", "-1 mil"],
    ["-1100", "-1.1 k", "-1.1 mil"],
    ["-2000", "-2 k", "-2 mil"],
    ["-2001", "-2 k", "-2 mil"],
    ["-2010", "-2 k", "-2 mil"],
    ["-2100", "-2.1 k", "-2.1 mil"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 k", "-10 mil"],
    ["-99999", "-100 k", "-100 mil"],
    ["-999999", "-1 M", "-1 millón"],
    ["-9999999", "-10 M", "-10 millones"],
    ["-9999999999999999", "-10000 B", "-10000 billones"],
    ["1000", "1 k", "1 mil"],
    ["1001", "1 k", "1 mil"],
    ["1010", "1 k", "1 mil"],
    ["1100", "1.1 k", "1.1 mil"],
    ["2000", "2 k", "2 mil"],
    ["2001", "2 k", "2 mil"],
    ["2010", "2 k", "2 mil"],
    ["2100", "2.1 k", "2.1 mil"],
    ["3000", "3 k", "3 mil"],
    ["3001", "3 k", "3 mil"],
    ["3010", "3 k", "3 mil"],
    ["3100", "3.1 k", "3.1 mil"],
    ["4000", "4 k", "4 mil"],
    ["4001", "4 k", "4 mil"],
    ["4010", "4 k", "4 mil"],
    ["4100", "4.1 k", "4.1 mil"],
    ["5000", "5 k", "5 mil"],
    ["5001", "5 k", "5 mil"],
    ["5010", "5 k", "5 mil"],
    ["5100", "5.1 k", "5.1 mil"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 k", "1 mil"],
    ["9999.12", "10 k", "10 mil"],
    ["9999.99", "10 k", "10 mil"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 k", "-1 mil"],
    ["-9999.12", "-10 k", "-10 mil"],
    ["-9999.99", "-10 k", "-10 mil"],
  ],
  "es_US": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 K", "4.3 mil"],
    ["54321", "54 K", "54 mil"],
    ["654321", "654 K", "654 mil"],
    ["7654321", "7.7 M", "7.7 millones"],
    ["87654321", "88 M", "88 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1088 M", "1.1 mil millones"],
    ["11987654321", "12 mil M", "12 mil millones"],
    ["129987654321", "130 mil M", "130 mil millones"],
    ["1398987654321", "1.4 B", "1.4 billón"],
    ["14987987654321", "15 B", "15 billones"],
    ["159876987654321", "160 B", "160 billones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 K", "10 mil"],
    ["99999", "100 K", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "10 K", "10 mil"],
    ["99944", "100 K", "100 mil"],
    ["999444", "999 K", "999 mil"],
    ["9994444", "10 M", "10 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "9994 M", "10 mil millones"],
    ["1000000000000000", "1000 B", "1000 billones"],
    ["10000000000000000", "10000 B", "10000 billones"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 K", "-1 mil"],
    ["-1001", "-1 K", "-1 mil"],
    ["-1010", "-1 K", "-1 mil"],
    ["-1100", "-1.1 K", "-1.1 mil"],
    ["-2000", "-2 K", "-2 mil"],
    ["-2001", "-2 K", "-2 mil"],
    ["-2010", "-2 K", "-2 mil"],
    ["-2100", "-2.1 K", "-2.1 mil"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 K", "-10 mil"],
    ["-99999", "-100 K", "-100 mil"],
    ["-999999", "-1 M", "-1 millón"],
    ["-9999999", "-10 M", "-10 millones"],
    ["-9999999999999999", "-10000 B", "-10000 billones"],
    ["1000", "1 K", "1 mil"],
    ["1001", "1 K", "1 mil"],
    ["1010", "1 K", "1 mil"],
    ["1100", "1.1 K", "1.1 mil"],
    ["2000", "2 K", "2 mil"],
    ["2001", "2 K", "2 mil"],
    ["2010", "2 K", "2 mil"],
    ["2100", "2.1 K", "2.1 mil"],
    ["3000", "3 K", "3 mil"],
    ["3001", "3 K", "3 mil"],
    ["3010", "3 K", "3 mil"],
    ["3100", "3.1 K", "3.1 mil"],
    ["4000", "4 K", "4 mil"],
    ["4001", "4 K", "4 mil"],
    ["4010", "4 K", "4 mil"],
    ["4100", "4.1 K", "4.1 mil"],
    ["5000", "5 K", "5 mil"],
    ["5001", "5 K", "5 mil"],
    ["5010", "5 K", "5 mil"],
    ["5100", "5.1 K", "5.1 mil"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 K", "1 mil"],
    ["9999.12", "10 K", "10 mil"],
    ["9999.99", "10 K", "10 mil"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 K", "-1 mil"],
    ["-9999.12", "-10 K", "-10 mil"],
    ["-9999.99", "-10 K", "-10 mil"],
  ],
  "et": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tuh", "4,3 tuhat"],
    ["54321", "54 tuh", "54 tuhat"],
    ["654321", "654 tuh", "654 tuhat"],
    ["7654321", "7,7 mln", "7,7 miljonit"],
    ["87654321", "88 mln", "88 miljonit"],
    ["987654321", "988 mln", "988 miljonit"],
    ["1087654321", "1,1 mld", "1,1 miljardit"],
    ["11987654321", "12 mld", "12 miljardit"],
    ["129987654321", "130 mld", "130 miljardit"],
    ["1398987654321", "1,4 trln", "1,4 triljonit"],
    ["14987987654321", "15 trln", "15 triljonit"],
    ["159876987654321", "160 trln", "160 triljonit"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tuh", "10 tuhat"],
    ["99999", "100 tuh", "100 tuhat"],
    ["999999", "1 mln", "1 miljon"],
    ["9999999", "10 mln", "10 miljonit"],
    ["99999999", "100 mln", "100 miljonit"],
    ["9994", "10 tuh", "10 tuhat"],
    ["99944", "100 tuh", "100 tuhat"],
    ["999444", "999 tuh", "999 tuhat"],
    ["9994444", "10 mln", "10 miljonit"],
    ["999444444", "999 mln", "999 miljonit"],
    ["9994444444", "10 mld", "10 miljardit"],
    ["1000000000000000", "1000 trln", "1000 triljonit"],
    ["10000000000000000", "10000 trln", "10000 triljonit"],
    ["0", "0", "0"],
    ["-1", "−1", "−1"],
    ["-2", "−2", "−2"],
    ["-3", "−3", "−3"],
    ["-1000", "−1 tuh", "−1 tuhat"],
    ["-1001", "−1 tuh", "−1 tuhat"],
    ["-1010", "−1 tuh", "−1 tuhat"],
    ["-1100", "−1,1 tuh", "−1,1 tuhat"],
    ["-2000", "−2 tuh", "−2 tuhat"],
    ["-2001", "−2 tuh", "−2 tuhat"],
    ["-2010", "−2 tuh", "−2 tuhat"],
    ["-2100", "−2,1 tuh", "−2,1 tuhat"],
    ["-9", "−9", "−9"],
    ["-99", "−99", "−99"],
    ["-999", "−999", "−999"],
    ["-9999", "−10 tuh", "−10 tuhat"],
    ["-99999", "−100 tuh", "−100 tuhat"],
    ["-999999", "−1 mln", "−1 miljon"],
    ["-9999999", "−10 mln", "−10 miljonit"],
    ["-9999999999999999", "−10000 trln", "−10000 triljonit"],
    ["1000", "1 tuh", "1 tuhat"],
    ["1001", "1 tuh", "1 tuhat"],
    ["1010", "1 tuh", "1 tuhat"],
    ["1100", "1,1 tuh", "1,1 tuhat"],
    ["2000", "2 tuh", "2 tuhat"],
    ["2001", "2 tuh", "2 tuhat"],
    ["2010", "2 tuh", "2 tuhat"],
    ["2100", "2,1 tuh", "2,1 tuhat"],
    ["3000", "3 tuh", "3 tuhat"],
    ["3001", "3 tuh", "3 tuhat"],
    ["3010", "3 tuh", "3 tuhat"],
    ["3100", "3,1 tuh", "3,1 tuhat"],
    ["4000", "4 tuh", "4 tuhat"],
    ["4001", "4 tuh", "4 tuhat"],
    ["4010", "4 tuh", "4 tuhat"],
    ["4100", "4,1 tuh", "4,1 tuhat"],
    ["5000", "5 tuh", "5 tuhat"],
    ["5001", "5 tuh", "5 tuhat"],
    ["5010", "5 tuh", "5 tuhat"],
    ["5100", "5,1 tuh", "5,1 tuhat"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 tuh", "1 tuhat"],
    ["9999.12", "10 tuh", "10 tuhat"],
    ["9999.99", "10 tuh", "10 tuhat"],
    ["-0.12", "−0,12", "−0,12"],
    ["-0.99", "−0,99", "−0,99"],
    ["-9.12", "−9,1", "−9,1"],
    ["-9.99", "−10", "−10"],
    ["-999.12", "−999", "−999"],
    ["-999.99", "−1 tuh", "−1 tuhat"],
    ["-9999.12", "−10 tuh", "−10 tuhat"],
    ["-9999.99", "−10 tuh", "−10 tuhat"],
  ],
  "eu": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4321"],
    ["54321", "54321", "54321"],
    ["654321", "654321", "654321"],
    ["7654321", "7,7 M", "7,7 milioi"],
    ["87654321", "88 M", "88 milioi"],
    ["987654321", "988 M", "988 milioi"],
    ["1087654321", "1088 M", "1088 milioi"],
    ["11987654321", "11988 M", "11988 milioi"],
    ["129987654321", "129988 M", "129988 milioi"],
    ["1398987654321", "1,4 B", "1,4 bilioi"],
    ["14987987654321", "15 B", "15 bilioi"],
    ["159876987654321", "160 B", "160 bilioi"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "9999"],
    ["99999", "99999", "99999"],
    ["999999", "999999", "999999"],
    ["9999999", "10 M", "10 milioi"],
    ["99999999", "100 M", "100 milioi"],
    ["9994", "9994", "9994"],
    ["99944", "99944", "99944"],
    ["999444", "999444", "999444"],
    ["9994444", "10 M", "10 milioi"],
    ["999444444", "999 M", "999 milioi"],
    ["9994444444", "9994 M", "9994 milioi"],
    ["1000000000000000", "1000 B", "1000 bilioi"],
    ["10000000000000000", "10000 B", "10000 bilioi"],
    ["0", "0", "0"],
    ["-1", "−1", "−1"],
    ["-2", "−2", "−2"],
    ["-3", "−3", "−3"],
    ["-1000", "−1000", "−1000"],
    ["-1001", "−1001", "−1001"],
    ["-1010", "−1010", "−1010"],
    ["-1100", "−1100", "−1100"],
    ["-2000", "−2000", "−2000"],
    ["-2001", "−2001", "−2001"],
    ["-2010", "−2010", "−2010"],
    ["-2100", "−2100", "−2100"],
    ["-9", "−9", "−9"],
    ["-99", "−99", "−99"],
    ["-999", "−999", "−999"],
    ["-9999", "−9999", "−9999"],
    ["-99999", "−99999", "−99999"],
    ["-999999", "−999999", "−999999"],
    ["-9999999", "−10 M", "−10 milioi"],
    ["-9999999999999999", "−10000 B", "−10000 bilioi"],
    ["1000", "1000", "1000"],
    ["1001", "1001", "1001"],
    ["1010", "1010", "1010"],
    ["1100", "1100", "1100"],
    ["2000", "2000", "2000"],
    ["2001", "2001", "2001"],
    ["2010", "2010", "2010"],
    ["2100", "2100", "2100"],
    ["3000", "3000", "3000"],
    ["3001", "3001", "3001"],
    ["3010", "3010", "3010"],
    ["3100", "3100", "3100"],
    ["4000", "4000", "4000"],
    ["4001", "4001", "4001"],
    ["4010", "4010", "4010"],
    ["4100", "4100", "4100"],
    ["5000", "5000", "5000"],
    ["5001", "5001", "5001"],
    ["5010", "5010", "5010"],
    ["5100", "5100", "5100"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1000", "1000"],
    ["9999.12", "9999", "9999"],
    ["9999.99", "10000", "10000"],
    ["-0.12", "−0,12", "−0,12"],
    ["-0.99", "−0,99", "−0,99"],
    ["-9.12", "−9,1", "−9,1"],
    ["-9.99", "−10", "−10"],
    ["-999.12", "−999", "−999"],
    ["-999.99", "−1000", "−1000"],
    ["-9999.12", "−9999", "−9999"],
    ["-9999.99", "−10000", "−10000"],
  ],
  "fa": [
    ["1", "۱", "۱"],
    ["21", "۲۱", "۲۱"],
    ["321", "۳۲۱", "۳۲۱"],
    ["4321", "۴٫۳ هزار", "۴٫۳ هزار"],
    ["54321", "۵۴ هزار", "۵۴ هزار"],
    ["654321", "۶۵۴ هزار", "۶۵۴ هزار"],
    ["7654321", "۷٫۷ میلیون", "۷٫۷ میلیون"],
    ["87654321", "۸۸ میلیون", "۸۸ میلیون"],
    ["987654321", "۹۸۸ میلیون", "۹۸۸ میلیون"],
    ["1087654321", "۱٫۱ میلیارد", "۱٫۱ میلیارد"],
    ["11987654321", "۱۲ میلیارد", "۱۲ میلیارد"],
    ["129987654321", "۱۳۰ میلیارد", "۱۳۰ میلیارد"],
    ["1398987654321", "۱٫۴ تریلیون", "۱٫۴ هزارمیلیارد"],
    ["14987987654321", "۱۵ تریلیون", "۱۵ هزارمیلیارد"],
    ["159876987654321", "۱۶۰ تریلیون", "۱۶۰ هزارمیلیارد"],
    ["9", "۹", "۹"],
    ["99", "۹۹", "۹۹"],
    ["999", "۹۹۹", "۹۹۹"],
    ["9999", "۱۰ هزار", "۱۰ هزار"],
    ["99999", "۱۰۰ هزار", "۱۰۰ هزار"],
    ["999999", "۱ میلیون", "۱ میلیون"],
    ["9999999", "۱۰ میلیون", "۱۰ میلیون"],
    ["99999999", "۱۰۰ میلیون", "۱۰۰ میلیون"],
    ["9994", "۱۰ هزار", "۱۰ هزار"],
    ["99944", "۱۰۰ هزار", "۱۰۰ هزار"],
    ["999444", "۹۹۹ هزار", "۹۹۹ هزار"],
    ["9994444", "۱۰ میلیون", "۱۰ میلیون"],
    ["999444444", "۹۹۹ میلیون", "۹۹۹ میلیون"],
    ["9994444444", "۱۰ میلیارد", "۱۰ میلیارد"],
    ["1000000000000000", "۱۰۰۰ تریلیون", "۱۰۰۰ هزارمیلیارد"],
    ["10000000000000000", "۱۰۰۰۰ تریلیون", "۱۰۰۰۰ هزارمیلیارد"],
    ["0", "۰", "۰"],
    ["-1", "‎−۱", "‎−۱"],
    ["-2", "‎−۲", "‎−۲"],
    ["-3", "‎−۳", "‎−۳"],
    ["-1000", "‎−۱ هزار", "‎−۱ هزار"],
    ["-1001", "‎−۱ هزار", "‎−۱ هزار"],
    ["-1010", "‎−۱ هزار", "‎−۱ هزار"],
    ["-1100", "‎−۱٫۱ هزار", "‎−۱٫۱ هزار"],
    ["-2000", "‎−۲ هزار", "‎−۲ هزار"],
    ["-2001", "‎−۲ هزار", "‎−۲ هزار"],
    ["-2010", "‎−۲ هزار", "‎−۲ هزار"],
    ["-2100", "‎−۲٫۱ هزار", "‎−۲٫۱ هزار"],
    ["-9", "‎−۹", "‎−۹"],
    ["-99", "‎−۹۹", "‎−۹۹"],
    ["-999", "‎−۹۹۹", "‎−۹۹۹"],
    ["-9999", "‎−۱۰ هزار", "‎−۱۰ هزار"],
    ["-99999", "‎−۱۰۰ هزار", "‎−۱۰۰ هزار"],
    ["-999999", "‎−۱ میلیون", "‎−۱ میلیون"],
    ["-9999999", "‎−۱۰ میلیون", "‎−۱۰ میلیون"],
    ["-9999999999999999", "‎−۱۰۰۰۰ تریلیون", "‎−۱۰۰۰۰ هزارمیلیارد"],
    ["1000", "۱ هزار", "۱ هزار"],
    ["1001", "۱ هزار", "۱ هزار"],
    ["1010", "۱ هزار", "۱ هزار"],
    ["1100", "۱٫۱ هزار", "۱٫۱ هزار"],
    ["2000", "۲ هزار", "۲ هزار"],
    ["2001", "۲ هزار", "۲ هزار"],
    ["2010", "۲ هزار", "۲ هزار"],
    ["2100", "۲٫۱ هزار", "۲٫۱ هزار"],
    ["3000", "۳ هزار", "۳ هزار"],
    ["3001", "۳ هزار", "۳ هزار"],
    ["3010", "۳ هزار", "۳ هزار"],
    ["3100", "۳٫۱ هزار", "۳٫۱ هزار"],
    ["4000", "۴ هزار", "۴ هزار"],
    ["4001", "۴ هزار", "۴ هزار"],
    ["4010", "۴ هزار", "۴ هزار"],
    ["4100", "۴٫۱ هزار", "۴٫۱ هزار"],
    ["5000", "۵ هزار", "۵ هزار"],
    ["5001", "۵ هزار", "۵ هزار"],
    ["5010", "۵ هزار", "۵ هزار"],
    ["5100", "۵٫۱ هزار", "۵٫۱ هزار"],
    ["0.001234", "۰٫۰۰۱۲", "۰٫۰۰۱۲"],
    ["0.01234", "۰٫۰۱۲", "۰٫۰۱۲"],
    ["0.1234", "۰٫۱۲", "۰٫۱۲"],
    ["0.99", "۰٫۹۹", "۰٫۹۹"],
    ["0.999", "۱", "۱"],
    ["9.12", "۹٫۱", "۹٫۱"],
    ["9.99", "۱۰", "۱۰"],
    ["99.12", "۹۹", "۹۹"],
    ["99.99", "۱۰۰", "۱۰۰"],
    ["999.12", "۹۹۹", "۹۹۹"],
    ["999.99", "۱ هزار", "۱ هزار"],
    ["9999.12", "۱۰ هزار", "۱۰ هزار"],
    ["9999.99", "۱۰ هزار", "۱۰ هزار"],
    ["-0.12", "‎−۰٫۱۲", "‎−۰٫۱۲"],
    ["-0.99", "‎−۰٫۹۹", "‎−۰٫۹۹"],
    ["-9.12", "‎−۹٫۱", "‎−۹٫۱"],
    ["-9.99", "‎−۱۰", "‎−۱۰"],
    ["-999.12", "‎−۹۹۹", "‎−۹۹۹"],
    ["-999.99", "‎−۱ هزار", "‎−۱ هزار"],
    ["-9999.12", "‎−۱۰ هزار", "‎−۱۰ هزار"],
    ["-9999.99", "‎−۱۰ هزار", "‎−۱۰ هزار"],
  ],
  "fi": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 t.", "4,3 tuhatta"],
    ["54321", "54 t.", "54 tuhatta"],
    ["654321", "654 t.", "654 tuhatta"],
    ["7654321", "7,7 milj.", "7,7 miljoonaa"],
    ["87654321", "88 milj.", "88 miljoonaa"],
    ["987654321", "988 milj.", "988 miljoonaa"],
    ["1087654321", "1,1 mrd.", "1,1 miljardia"],
    ["11987654321", "12 mrd.", "12 miljardia"],
    ["129987654321", "130 mrd.", "130 miljardia"],
    ["1398987654321", "1,4 bilj.", "1,4 biljoonaa"],
    ["14987987654321", "15 bilj.", "15 biljoonaa"],
    ["159876987654321", "160 bilj.", "160 biljoonaa"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 t.", "10 tuhatta"],
    ["99999", "100 t.", "100 tuhatta"],
    ["999999", "1 milj.", "1 miljoona"],
    ["9999999", "10 milj.", "10 miljoonaa"],
    ["99999999", "100 milj.", "100 miljoonaa"],
    ["9994", "10 t.", "10 tuhatta"],
    ["99944", "100 t.", "100 tuhatta"],
    ["999444", "999 t.", "999 tuhatta"],
    ["9994444", "10 milj.", "10 miljoonaa"],
    ["999444444", "999 milj.", "999 miljoonaa"],
    ["9994444444", "10 mrd.", "10 miljardia"],
    ["1000000000000000", "1000 bilj.", "1000 biljoonaa"],
    ["10000000000000000", "10000 bilj.", "10000 biljoonaa"],
    ["0", "0", "0"],
    ["-1", "−1", "−1"],
    ["-2", "−2", "−2"],
    ["-3", "−3", "−3"],
    ["-1000", "−1 t.", "−1 tuhat"],
    ["-1001", "−1 t.", "−1 tuhat"],
    ["-1010", "−1 t.", "−1 tuhat"],
    ["-1100", "−1,1 t.", "−1,1 tuhatta"],
    ["-2000", "−2 t.", "−2 tuhatta"],
    ["-2001", "−2 t.", "−2 tuhatta"],
    ["-2010", "−2 t.", "−2 tuhatta"],
    ["-2100", "−2,1 t.", "−2,1 tuhatta"],
    ["-9", "−9", "−9"],
    ["-99", "−99", "−99"],
    ["-999", "−999", "−999"],
    ["-9999", "−10 t.", "−10 tuhatta"],
    ["-99999", "−100 t.", "−100 tuhatta"],
    ["-999999", "−1 milj.", "−1 miljoona"],
    ["-9999999", "−10 milj.", "−10 miljoonaa"],
    ["-9999999999999999", "−10000 bilj.", "−10000 biljoonaa"],
    ["1000", "1 t.", "1 tuhat"],
    ["1001", "1 t.", "1 tuhat"],
    ["1010", "1 t.", "1 tuhat"],
    ["1100", "1,1 t.", "1,1 tuhatta"],
    ["2000", "2 t.", "2 tuhatta"],
    ["2001", "2 t.", "2 tuhatta"],
    ["2010", "2 t.", "2 tuhatta"],
    ["2100", "2,1 t.", "2,1 tuhatta"],
    ["3000", "3 t.", "3 tuhatta"],
    ["3001", "3 t.", "3 tuhatta"],
    ["3010", "3 t.", "3 tuhatta"],
    ["3100", "3,1 t.", "3,1 tuhatta"],
    ["4000", "4 t.", "4 tuhatta"],
    ["4001", "4 t.", "4 tuhatta"],
    ["4010", "4 t.", "4 tuhatta"],
    ["4100", "4,1 t.", "4,1 tuhatta"],
    ["5000", "5 t.", "5 tuhatta"],
    ["5001", "5 t.", "5 tuhatta"],
    ["5010", "5 t.", "5 tuhatta"],
    ["5100", "5,1 t.", "5,1 tuhatta"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 t.", "1 tuhat"],
    ["9999.12", "10 t.", "10 tuhatta"],
    ["9999.99", "10 t.", "10 tuhatta"],
    ["-0.12", "−0,12", "−0,12"],
    ["-0.99", "−0,99", "−0,99"],
    ["-9.12", "−9,1", "−9,1"],
    ["-9.99", "−10", "−10"],
    ["-999.12", "−999", "−999"],
    ["-999.99", "−1 t.", "−1 tuhat"],
    ["-9999.12", "−10 t.", "−10 tuhatta"],
    ["-9999.99", "−10 t.", "−10 tuhatta"],
  ],
  "fil": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 libo"],
    ["54321", "54K", "54 na libo"],
    ["654321", "654K", "654 na libo"],
    ["7654321", "7.7M", "7.7 milyon"],
    ["87654321", "88M", "88 milyon"],
    ["987654321", "988M", "988 milyon"],
    ["1087654321", "1.1B", "1.1 bilyon"],
    ["11987654321", "12B", "12 bilyon"],
    ["129987654321", "130B", "130 bilyon"],
    ["1398987654321", "1.4T", "1.4 na trilyon"],
    ["14987987654321", "15T", "15 trilyon"],
    ["159876987654321", "160T", "160 trilyon"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 libo"],
    ["99999", "100K", "100 libo"],
    ["999999", "1M", "1 milyon"],
    ["9999999", "10M", "10 milyon"],
    ["99999999", "100M", "100 milyon"],
    ["9994", "10K", "10 libo"],
    ["99944", "100K", "100 libo"],
    ["999444", "999K", "999 na libo"],
    ["9994444", "10M", "10 milyon"],
    ["999444444", "999M", "999 na milyon"],
    ["9994444444", "10B", "10 bilyon"],
    ["1000000000000000", "1000T", "1000 trilyon"],
    ["10000000000000000", "10000T", "10000 trilyon"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 libo"],
    ["-1001", "-1K", "-1 libo"],
    ["-1010", "-1K", "-1 libo"],
    ["-1100", "-1.1K", "-1.1 libo"],
    ["-2000", "-2K", "-2 libo"],
    ["-2001", "-2K", "-2 libo"],
    ["-2010", "-2K", "-2 libo"],
    ["-2100", "-2.1K", "-2.1 libo"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 libo"],
    ["-99999", "-100K", "-100 libo"],
    ["-999999", "-1M", "-1 milyon"],
    ["-9999999", "-10M", "-10 milyon"],
    ["-9999999999999999", "-10000T", "-10000 trilyon"],
    ["1000", "1K", "1 libo"],
    ["1001", "1K", "1 libo"],
    ["1010", "1K", "1 libo"],
    ["1100", "1.1K", "1.1 libo"],
    ["2000", "2K", "2 libo"],
    ["2001", "2K", "2 libo"],
    ["2010", "2K", "2 libo"],
    ["2100", "2.1K", "2.1 libo"],
    ["3000", "3K", "3 libo"],
    ["3001", "3K", "3 libo"],
    ["3010", "3K", "3 libo"],
    ["3100", "3.1K", "3.1 libo"],
    ["4000", "4K", "4 na libo"],
    ["4001", "4K", "4 na libo"],
    ["4010", "4K", "4 na libo"],
    ["4100", "4.1K", "4.1 libo"],
    ["5000", "5K", "5 libo"],
    ["5001", "5K", "5 libo"],
    ["5010", "5K", "5 libo"],
    ["5100", "5.1K", "5.1 libo"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 libo"],
    ["9999.12", "10K", "10 libo"],
    ["9999.99", "10K", "10 libo"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 libo"],
    ["-9999.12", "-10K", "-10 libo"],
    ["-9999.99", "-10K", "-10 libo"],
  ],
  "fr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 k", "4,3 mille"],
    ["54321", "54 k", "54 mille"],
    ["654321", "654 k", "654 mille"],
    ["7654321", "7,7 M", "7,7 millions"],
    ["87654321", "88 M", "88 millions"],
    ["987654321", "988 M", "988 millions"],
    ["1087654321", "1,1 Md", "1,1 milliard"],
    ["11987654321", "12 Md", "12 milliards"],
    ["129987654321", "130 Md", "130 milliards"],
    ["1398987654321", "1,4 Bn", "1,4 billion"],
    ["14987987654321", "15 Bn", "15 billions"],
    ["159876987654321", "160 Bn", "160 billions"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mille"],
    ["99999", "100 k", "100 mille"],
    ["999999", "1 M", "1 million"],
    ["9999999", "10 M", "10 millions"],
    ["99999999", "100 M", "100 millions"],
    ["9994", "10 k", "10 mille"],
    ["99944", "100 k", "100 mille"],
    ["999444", "999 k", "999 mille"],
    ["9994444", "10 M", "10 millions"],
    ["999444444", "999 M", "999 millions"],
    ["9994444444", "10 Md", "10 milliards"],
    ["1000000000000000", "1000 Bn", "1000 billions"],
    ["10000000000000000", "10000 Bn", "10000 billions"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 k", "-1 millier"],
    ["-1001", "-1 k", "-1 millier"],
    ["-1010", "-1 k", "-1 millier"],
    ["-1100", "-1,1 k", "-1,1 millier"],
    ["-2000", "-2 k", "-2 mille"],
    ["-2001", "-2 k", "-2 mille"],
    ["-2010", "-2 k", "-2 mille"],
    ["-2100", "-2,1 k", "-2,1 mille"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 k", "-10 mille"],
    ["-99999", "-100 k", "-100 mille"],
    ["-999999", "-1 M", "-1 million"],
    ["-9999999", "-10 M", "-10 millions"],
    ["-9999999999999999", "-10000 Bn", "-10000 billions"],
    ["1000", "1 k", "mille"],
    ["1001", "1 k", "mille"],
    ["1010", "1 k", "mille"],
    ["1100", "1,1 k", "1,1 millier"],
    ["2000", "2 k", "2 mille"],
    ["2001", "2 k", "2 mille"],
    ["2010", "2 k", "2 mille"],
    ["2100", "2,1 k", "2,1 mille"],
    ["3000", "3 k", "3 mille"],
    ["3001", "3 k", "3 mille"],
    ["3010", "3 k", "3 mille"],
    ["3100", "3,1 k", "3,1 mille"],
    ["4000", "4 k", "4 mille"],
    ["4001", "4 k", "4 mille"],
    ["4010", "4 k", "4 mille"],
    ["4100", "4,1 k", "4,1 mille"],
    ["5000", "5 k", "5 mille"],
    ["5001", "5 k", "5 mille"],
    ["5010", "5 k", "5 mille"],
    ["5100", "5,1 k", "5,1 mille"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 k", "mille"],
    ["9999.12", "10 k", "10 mille"],
    ["9999.99", "10 k", "10 mille"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 k", "-1 millier"],
    ["-9999.12", "-10 k", "-10 mille"],
    ["-9999.99", "-10 k", "-10 mille"],
  ],
  "fr_CA": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 k", "4,3 mille"],
    ["54321", "54 k", "54 mille"],
    ["654321", "654 k", "654 mille"],
    ["7654321", "7,7 M", "7,7 millions"],
    ["87654321", "88 M", "88 millions"],
    ["987654321", "988 M", "988 millions"],
    ["1087654321", "1,1 G", "1,1 milliard"],
    ["11987654321", "12 G", "12 milliards"],
    ["129987654321", "130 G", "130 milliards"],
    ["1398987654321", "1,4 T", "1,4 billion"],
    ["14987987654321", "15 T", "15 billions"],
    ["159876987654321", "160 T", "160 billions"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mille"],
    ["99999", "100 k", "100 mille"],
    ["999999", "1 M", "1 million"],
    ["9999999", "10 M", "10 millions"],
    ["99999999", "100 M", "100 millions"],
    ["9994", "10 k", "10 mille"],
    ["99944", "100 k", "100 mille"],
    ["999444", "999 k", "999 mille"],
    ["9994444", "10 M", "10 millions"],
    ["999444444", "999 M", "999 millions"],
    ["9994444444", "10 G", "10 milliards"],
    ["1000000000000000", "1000 T", "1000 billions"],
    ["10000000000000000", "10000 T", "10000 billions"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 k", "-1 mille"],
    ["-1001", "-1 k", "-1 mille"],
    ["-1010", "-1 k", "-1 mille"],
    ["-1100", "-1,1 k", "-1,1 mille"],
    ["-2000", "-2 k", "-2 mille"],
    ["-2001", "-2 k", "-2 mille"],
    ["-2010", "-2 k", "-2 mille"],
    ["-2100", "-2,1 k", "-2,1 mille"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 k", "-10 mille"],
    ["-99999", "-100 k", "-100 mille"],
    ["-999999", "-1 M", "-1 million"],
    ["-9999999", "-10 M", "-10 millions"],
    ["-9999999999999999", "-10000 T", "-10000 billions"],
    ["1000", "1 k", "1 mille"],
    ["1001", "1 k", "1 mille"],
    ["1010", "1 k", "1 mille"],
    ["1100", "1,1 k", "1,1 mille"],
    ["2000", "2 k", "2 mille"],
    ["2001", "2 k", "2 mille"],
    ["2010", "2 k", "2 mille"],
    ["2100", "2,1 k", "2,1 mille"],
    ["3000", "3 k", "3 mille"],
    ["3001", "3 k", "3 mille"],
    ["3010", "3 k", "3 mille"],
    ["3100", "3,1 k", "3,1 mille"],
    ["4000", "4 k", "4 mille"],
    ["4001", "4 k", "4 mille"],
    ["4010", "4 k", "4 mille"],
    ["4100", "4,1 k", "4,1 mille"],
    ["5000", "5 k", "5 mille"],
    ["5001", "5 k", "5 mille"],
    ["5010", "5 k", "5 mille"],
    ["5100", "5,1 k", "5,1 mille"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 k", "1 mille"],
    ["9999.12", "10 k", "10 mille"],
    ["9999.99", "10 k", "10 mille"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 k", "-1 mille"],
    ["-9999.12", "-10 k", "-10 mille"],
    ["-9999.99", "-10 k", "-10 mille"],
  ],
  "fr_CH": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 k", "4,3 mille"],
    ["54321", "54 k", "54 mille"],
    ["654321", "654 k", "654 mille"],
    ["7654321", "7,7 M", "7,7 millions"],
    ["87654321", "88 M", "88 millions"],
    ["987654321", "988 M", "988 millions"],
    ["1087654321", "1,1 Md", "1,1 milliard"],
    ["11987654321", "12 Md", "12 milliards"],
    ["129987654321", "130 Md", "130 milliards"],
    ["1398987654321", "1,4 Bn", "1,4 billion"],
    ["14987987654321", "15 Bn", "15 billions"],
    ["159876987654321", "160 Bn", "160 billions"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mille"],
    ["99999", "100 k", "100 mille"],
    ["999999", "1 M", "1 million"],
    ["9999999", "10 M", "10 millions"],
    ["99999999", "100 M", "100 millions"],
    ["9994", "10 k", "10 mille"],
    ["99944", "100 k", "100 mille"],
    ["999444", "999 k", "999 mille"],
    ["9994444", "10 M", "10 millions"],
    ["999444444", "999 M", "999 millions"],
    ["9994444444", "10 Md", "10 milliards"],
    ["1000000000000000", "1000 Bn", "1000 billions"],
    ["10000000000000000", "10000 Bn", "10000 billions"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 k", "-1 millier"],
    ["-1001", "-1 k", "-1 millier"],
    ["-1010", "-1 k", "-1 millier"],
    ["-1100", "-1,1 k", "-1,1 millier"],
    ["-2000", "-2 k", "-2 mille"],
    ["-2001", "-2 k", "-2 mille"],
    ["-2010", "-2 k", "-2 mille"],
    ["-2100", "-2,1 k", "-2,1 mille"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 k", "-10 mille"],
    ["-99999", "-100 k", "-100 mille"],
    ["-999999", "-1 M", "-1 million"],
    ["-9999999", "-10 M", "-10 millions"],
    ["-9999999999999999", "-10000 Bn", "-10000 billions"],
    ["1000", "1 k", "mille"],
    ["1001", "1 k", "mille"],
    ["1010", "1 k", "mille"],
    ["1100", "1,1 k", "1,1 millier"],
    ["2000", "2 k", "2 mille"],
    ["2001", "2 k", "2 mille"],
    ["2010", "2 k", "2 mille"],
    ["2100", "2,1 k", "2,1 mille"],
    ["3000", "3 k", "3 mille"],
    ["3001", "3 k", "3 mille"],
    ["3010", "3 k", "3 mille"],
    ["3100", "3,1 k", "3,1 mille"],
    ["4000", "4 k", "4 mille"],
    ["4001", "4 k", "4 mille"],
    ["4010", "4 k", "4 mille"],
    ["4100", "4,1 k", "4,1 mille"],
    ["5000", "5 k", "5 mille"],
    ["5001", "5 k", "5 mille"],
    ["5010", "5 k", "5 mille"],
    ["5100", "5,1 k", "5,1 mille"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 k", "mille"],
    ["9999.12", "10 k", "10 mille"],
    ["9999.99", "10 k", "10 mille"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 k", "-1 millier"],
    ["-9999.12", "-10 k", "-10 mille"],
    ["-9999.99", "-10 k", "-10 mille"],
  ],
  "fur": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3K", "4,3K"],
    ["54321", "54K", "54K"],
    ["654321", "654K", "654K"],
    ["7654321", "7,7M", "7,7M"],
    ["87654321", "88M", "88M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1,1G", "1,1G"],
    ["11987654321", "12G", "12G"],
    ["129987654321", "130G", "130G"],
    ["1398987654321", "1,4T", "1,4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "10K", "10K"],
    ["99944", "100K", "100K"],
    ["999444", "999K", "999K"],
    ["9994444", "10M", "10M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "10G", "10G"],
    ["1000000000000000", "1000T", "1000T"],
    ["10000000000000000", "10000T", "10000T"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1K"],
    ["-1001", "-1K", "-1K"],
    ["-1010", "-1K", "-1K"],
    ["-1100", "-1,1K", "-1,1K"],
    ["-2000", "-2K", "-2K"],
    ["-2001", "-2K", "-2K"],
    ["-2010", "-2K", "-2K"],
    ["-2100", "-2,1K", "-2,1K"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10K"],
    ["-99999", "-100K", "-100K"],
    ["-999999", "-1M", "-1M"],
    ["-9999999", "-10M", "-10M"],
    ["-9999999999999999", "-10000T", "-10000T"],
    ["1000", "1K", "1K"],
    ["1001", "1K", "1K"],
    ["1010", "1K", "1K"],
    ["1100", "1,1K", "1,1K"],
    ["2000", "2K", "2K"],
    ["2001", "2K", "2K"],
    ["2010", "2K", "2K"],
    ["2100", "2,1K", "2,1K"],
    ["3000", "3K", "3K"],
    ["3001", "3K", "3K"],
    ["3010", "3K", "3K"],
    ["3100", "3,1K", "3,1K"],
    ["4000", "4K", "4K"],
    ["4001", "4K", "4K"],
    ["4010", "4K", "4K"],
    ["4100", "4,1K", "4,1K"],
    ["5000", "5K", "5K"],
    ["5001", "5K", "5K"],
    ["5010", "5K", "5K"],
    ["5100", "5,1K", "5,1K"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1K"],
    ["9999.12", "10K", "10K"],
    ["9999.99", "10K", "10K"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1K"],
    ["-9999.12", "-10K", "-10K"],
    ["-9999.99", "-10K", "-10K"],
  ],
  "ga": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3k", "4.3 míle"],
    ["54321", "54k", "54 míle"],
    ["654321", "654k", "654 míle"],
    ["7654321", "7.7M", "7.7 milliún"],
    ["87654321", "88M", "88 milliún"],
    ["987654321", "988M", "988 milliún"],
    ["1087654321", "1.1B", "1.1 billiún"],
    ["11987654321", "12B", "12 billiún"],
    ["129987654321", "130B", "130 billiún"],
    ["1398987654321", "1.4T", "1.4 trilliún"],
    ["14987987654321", "15T", "15 trilliún"],
    ["159876987654321", "160T", "160 trilliún"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 míle"],
    ["99999", "100k", "100 míle"],
    ["999999", "1M", "1 mhilliún"],
    ["9999999", "10M", "10 milliún"],
    ["99999999", "100M", "100 milliún"],
    ["9994", "10k", "10 míle"],
    ["99944", "100k", "100 míle"],
    ["999444", "999k", "999 míle"],
    ["9994444", "10M", "10 milliún"],
    ["999444444", "999M", "999 milliún"],
    ["9994444444", "10B", "10 mbilliún"],
    ["1000000000000000", "1000T", "1000 trilliún"],
    ["10000000000000000", "10000T", "10000 trilliún"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1k", "-1 mhíle"],
    ["-1001", "-1k", "-1 mhíle"],
    ["-1010", "-1k", "-1 mhíle"],
    ["-1100", "-1.1k", "-1.1 míle"],
    ["-2000", "-2k", "-2 mhíle"],
    ["-2001", "-2k", "-2 mhíle"],
    ["-2010", "-2k", "-2 mhíle"],
    ["-2100", "-2.1k", "-2.1 míle"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10k", "-10 míle"],
    ["-99999", "-100k", "-100 míle"],
    ["-999999", "-1M", "-1 mhilliún"],
    ["-9999999", "-10M", "-10 milliún"],
    ["-9999999999999999", "-10000T", "-10000 trilliún"],
    ["1000", "1k", "1 mhíle"],
    ["1001", "1k", "1 mhíle"],
    ["1010", "1k", "1 mhíle"],
    ["1100", "1.1k", "1.1 míle"],
    ["2000", "2k", "2 mhíle"],
    ["2001", "2k", "2 mhíle"],
    ["2010", "2k", "2 mhíle"],
    ["2100", "2.1k", "2.1 míle"],
    ["3000", "3k", "3 mhíle"],
    ["3001", "3k", "3 mhíle"],
    ["3010", "3k", "3 mhíle"],
    ["3100", "3.1k", "3.1 míle"],
    ["4000", "4k", "4 mhíle"],
    ["4001", "4k", "4 mhíle"],
    ["4010", "4k", "4 mhíle"],
    ["4100", "4.1k", "4.1 míle"],
    ["5000", "5k", "5 mhíle"],
    ["5001", "5k", "5 mhíle"],
    ["5010", "5k", "5 mhíle"],
    ["5100", "5.1k", "5.1 míle"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1k", "1 mhíle"],
    ["9999.12", "10k", "10 míle"],
    ["9999.99", "10k", "10 míle"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1k", "-1 mhíle"],
    ["-9999.12", "-10k", "-10 míle"],
    ["-9999.99", "-10k", "-10 míle"],
  ],
  "gl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4321"],
    ["54321", "54321", "54321"],
    ["654321", "654321", "654321"],
    ["7654321", "7,7 M", "7,7 millóns"],
    ["87654321", "88 M", "88 millóns"],
    ["987654321", "988 M", "988 millóns"],
    ["1087654321", "1088 M", "1088 millóns"],
    ["11987654321", "11988 M", "11988 millóns"],
    ["129987654321", "129988 M", "129988 millóns"],
    ["1398987654321", "1,4 B", "1,4 billóns"],
    ["14987987654321", "15 B", "15 billóns"],
    ["159876987654321", "160 B", "160 billóns"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "9999"],
    ["99999", "99999", "99999"],
    ["999999", "999999", "999999"],
    ["9999999", "10 M", "10 millóns"],
    ["99999999", "100 M", "100 millóns"],
    ["9994", "9994", "9994"],
    ["99944", "99944", "99944"],
    ["999444", "999444", "999444"],
    ["9994444", "10 M", "10 millóns"],
    ["999444444", "999 M", "999 millóns"],
    ["9994444444", "9994 M", "9994 millóns"],
    ["1000000000000000", "1000 B", "1000 billóns"],
    ["10000000000000000", "10000 B", "10000 billóns"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1000", "-1000"],
    ["-1001", "-1001", "-1001"],
    ["-1010", "-1010", "-1010"],
    ["-1100", "-1100", "-1100"],
    ["-2000", "-2000", "-2000"],
    ["-2001", "-2001", "-2001"],
    ["-2010", "-2010", "-2010"],
    ["-2100", "-2100", "-2100"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-9999", "-9999"],
    ["-99999", "-99999", "-99999"],
    ["-999999", "-999999", "-999999"],
    ["-9999999", "-10 M", "-10 millóns"],
    ["-9999999999999999", "-10000 B", "-10000 billóns"],
    ["1000", "1000", "1000"],
    ["1001", "1001", "1001"],
    ["1010", "1010", "1010"],
    ["1100", "1100", "1100"],
    ["2000", "2000", "2000"],
    ["2001", "2001", "2001"],
    ["2010", "2010", "2010"],
    ["2100", "2100", "2100"],
    ["3000", "3000", "3000"],
    ["3001", "3001", "3001"],
    ["3010", "3010", "3010"],
    ["3100", "3100", "3100"],
    ["4000", "4000", "4000"],
    ["4001", "4001", "4001"],
    ["4010", "4010", "4010"],
    ["4100", "4100", "4100"],
    ["5000", "5000", "5000"],
    ["5001", "5001", "5001"],
    ["5010", "5010", "5010"],
    ["5100", "5100", "5100"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1000", "1000"],
    ["9999.12", "9999", "9999"],
    ["9999.99", "10000", "10000"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1000", "-1000"],
    ["-9999.12", "-9999", "-9999"],
    ["-9999.99", "-10000", "-10000"],
  ],
  "gsw": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 Tsg.", "4.3 Tuusig"],
    ["54321", "54 Tsg.", "54 Tuusig"],
    ["654321", "654 Tsg.", "654 Tuusig"],
    ["7654321", "7.7 Mio.", "7.7 Millioone"],
    ["87654321", "88 Mio.", "88 Millioone"],
    ["987654321", "988 Mio.", "988 Millioone"],
    ["1087654321", "1.1 Mrd.", "1.1 Milliarde"],
    ["11987654321", "12 Mrd.", "12 Milliarde"],
    ["129987654321", "130 Mrd.", "130 Milliarde"],
    ["1398987654321", "1.4 Bio.", "1.4 Billioone"],
    ["14987987654321", "15 Bio.", "15 Billioone"],
    ["159876987654321", "160 Bio.", "160 Billioone"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 Tsg.", "10 Tuusig"],
    ["99999", "100 Tsg.", "100 Tuusig"],
    ["999999", "1 Mio.", "1 Millioon"],
    ["9999999", "10 Mio.", "10 Millioone"],
    ["99999999", "100 Mio.", "100 Millioone"],
    ["9994", "10 Tsg.", "10 Tuusig"],
    ["99944", "100 Tsg.", "100 Tuusig"],
    ["999444", "999 Tsg.", "999 Tuusig"],
    ["9994444", "10 Mio.", "10 Millioone"],
    ["999444444", "999 Mio.", "999 Millioone"],
    ["9994444444", "10 Mrd.", "10 Milliarde"],
    ["1000000000000000", "1000 Bio.", "1000 Billioone"],
    ["10000000000000000", "10000 Bio.", "10000 Billioone"],
    ["0", "0", "0"],
    ["-1", "−1", "−1"],
    ["-2", "−2", "−2"],
    ["-3", "−3", "−3"],
    ["-1000", "−1 Tsg.", "−1 Tuusig"],
    ["-1001", "−1 Tsg.", "−1 Tuusig"],
    ["-1010", "−1 Tsg.", "−1 Tuusig"],
    ["-1100", "−1.1 Tsg.", "−1.1 Tuusig"],
    ["-2000", "−2 Tsg.", "−2 Tuusig"],
    ["-2001", "−2 Tsg.", "−2 Tuusig"],
    ["-2010", "−2 Tsg.", "−2 Tuusig"],
    ["-2100", "−2.1 Tsg.", "−2.1 Tuusig"],
    ["-9", "−9", "−9"],
    ["-99", "−99", "−99"],
    ["-999", "−999", "−999"],
    ["-9999", "−10 Tsg.", "−10 Tuusig"],
    ["-99999", "−100 Tsg.", "−100 Tuusig"],
    ["-999999", "−1 Mio.", "−1 Millioon"],
    ["-9999999", "−10 Mio.", "−10 Millioone"],
    ["-9999999999999999", "−10000 Bio.", "−10000 Billioone"],
    ["1000", "1 Tsg.", "1 Tuusig"],
    ["1001", "1 Tsg.", "1 Tuusig"],
    ["1010", "1 Tsg.", "1 Tuusig"],
    ["1100", "1.1 Tsg.", "1.1 Tuusig"],
    ["2000", "2 Tsg.", "2 Tuusig"],
    ["2001", "2 Tsg.", "2 Tuusig"],
    ["2010", "2 Tsg.", "2 Tuusig"],
    ["2100", "2.1 Tsg.", "2.1 Tuusig"],
    ["3000", "3 Tsg.", "3 Tuusig"],
    ["3001", "3 Tsg.", "3 Tuusig"],
    ["3010", "3 Tsg.", "3 Tuusig"],
    ["3100", "3.1 Tsg.", "3.1 Tuusig"],
    ["4000", "4 Tsg.", "4 Tuusig"],
    ["4001", "4 Tsg.", "4 Tuusig"],
    ["4010", "4 Tsg.", "4 Tuusig"],
    ["4100", "4.1 Tsg.", "4.1 Tuusig"],
    ["5000", "5 Tsg.", "5 Tuusig"],
    ["5001", "5 Tsg.", "5 Tuusig"],
    ["5010", "5 Tsg.", "5 Tuusig"],
    ["5100", "5.1 Tsg.", "5.1 Tuusig"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 Tsg.", "1 Tuusig"],
    ["9999.12", "10 Tsg.", "10 Tuusig"],
    ["9999.99", "10 Tsg.", "10 Tuusig"],
    ["-0.12", "−0.12", "−0.12"],
    ["-0.99", "−0.99", "−0.99"],
    ["-9.12", "−9.1", "−9.1"],
    ["-9.99", "−10", "−10"],
    ["-999.12", "−999", "−999"],
    ["-999.99", "−1 Tsg.", "−1 Tuusig"],
    ["-9999.12", "−10 Tsg.", "−10 Tuusig"],
    ["-9999.99", "−10 Tsg.", "−10 Tuusig"],
  ],
  "gu": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 હજાર", "4.3 હજાર"],
    ["54321", "54 હજાર", "54 હજાર"],
    ["654321", "6.5 લાખ", "6.5 લાખ"],
    ["7654321", "77 લાખ", "77 લાખ"],
    ["87654321", "8.8 કરોડ", "8.8 કરોડ"],
    ["987654321", "99 કરોડ", "99 કરોડ"],
    ["1087654321", "1.1 અબજ", "1.1 અબજ"],
    ["11987654321", "12 અબજ", "12 અબજ"],
    ["129987654321", "1.3 નિખર્વ", "1.3 નિખર્વ"],
    ["1398987654321", "1.4 મહાપદ્મ", "1.4 મહાપદ્મ"],
    ["14987987654321", "1.5 શંકુ", "1.5 શંકુ"],
    ["159876987654321", "1.6 જલધિ", "1.6 જલધિ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 હજાર", "10 હજાર"],
    ["99999", "1 લાખ", "1 લાખ"],
    ["999999", "10 લાખ", "10 લાખ"],
    ["9999999", "1 કરોડ", "1 કરોડ"],
    ["99999999", "10 કરોડ", "10 કરોડ"],
    ["9994", "10 હજાર", "10 હજાર"],
    ["99944", "1 લાખ", "1 લાખ"],
    ["999444", "10 લાખ", "10 લાખ"],
    ["9994444", "1 કરોડ", "1 કરોડ"],
    ["999444444", "1 અબજ", "1 અબજ"],
    ["9994444444", "10 અબજ", "10 અબજ"],
    ["1000000000000000", "10 જલધિ", "10 જલધિ"],
    ["10000000000000000", "100 જલધિ", "100 જલધિ"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 હજાર", "-1 હજાર"],
    ["-1001", "-1 હજાર", "-1 હજાર"],
    ["-1010", "-1 હજાર", "-1 હજાર"],
    ["-1100", "-1.1 હજાર", "-1.1 હજાર"],
    ["-2000", "-2 હજાર", "-2 હજાર"],
    ["-2001", "-2 હજાર", "-2 હજાર"],
    ["-2010", "-2 હજાર", "-2 હજાર"],
    ["-2100", "-2.1 હજાર", "-2.1 હજાર"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 હજાર", "-10 હજાર"],
    ["-99999", "-1 લાખ", "-1 લાખ"],
    ["-999999", "-10 લાખ", "-10 લાખ"],
    ["-9999999", "-1 કરોડ", "-1 કરોડ"],
    ["-9999999999999999", "-100 જલધિ", "-100 જલધિ"],
    ["1000", "1 હજાર", "1 હજાર"],
    ["1001", "1 હજાર", "1 હજાર"],
    ["1010", "1 હજાર", "1 હજાર"],
    ["1100", "1.1 હજાર", "1.1 હજાર"],
    ["2000", "2 હજાર", "2 હજાર"],
    ["2001", "2 હજાર", "2 હજાર"],
    ["2010", "2 હજાર", "2 હજાર"],
    ["2100", "2.1 હજાર", "2.1 હજાર"],
    ["3000", "3 હજાર", "3 હજાર"],
    ["3001", "3 હજાર", "3 હજાર"],
    ["3010", "3 હજાર", "3 હજાર"],
    ["3100", "3.1 હજાર", "3.1 હજાર"],
    ["4000", "4 હજાર", "4 હજાર"],
    ["4001", "4 હજાર", "4 હજાર"],
    ["4010", "4 હજાર", "4 હજાર"],
    ["4100", "4.1 હજાર", "4.1 હજાર"],
    ["5000", "5 હજાર", "5 હજાર"],
    ["5001", "5 હજાર", "5 હજાર"],
    ["5010", "5 હજાર", "5 હજાર"],
    ["5100", "5.1 હજાર", "5.1 હજાર"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 હજાર", "1 હજાર"],
    ["9999.12", "10 હજાર", "10 હજાર"],
    ["9999.99", "10 હજાર", "10 હજાર"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 હજાર", "-1 હજાર"],
    ["-9999.12", "-10 હજાર", "-10 હજાર"],
    ["-9999.99", "-10 હજાર", "-10 હજાર"],
  ],
  "haw": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3K"],
    ["54321", "54K", "54K"],
    ["654321", "654K", "654K"],
    ["7654321", "7.7M", "7.7M"],
    ["87654321", "88M", "88M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1.1G", "1.1G"],
    ["11987654321", "12G", "12G"],
    ["129987654321", "130G", "130G"],
    ["1398987654321", "1.4T", "1.4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "10K", "10K"],
    ["99944", "100K", "100K"],
    ["999444", "999K", "999K"],
    ["9994444", "10M", "10M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "10G", "10G"],
    ["1000000000000000", "1000T", "1000T"],
    ["10000000000000000", "10000T", "10000T"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1K"],
    ["-1001", "-1K", "-1K"],
    ["-1010", "-1K", "-1K"],
    ["-1100", "-1.1K", "-1.1K"],
    ["-2000", "-2K", "-2K"],
    ["-2001", "-2K", "-2K"],
    ["-2010", "-2K", "-2K"],
    ["-2100", "-2.1K", "-2.1K"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10K"],
    ["-99999", "-100K", "-100K"],
    ["-999999", "-1M", "-1M"],
    ["-9999999", "-10M", "-10M"],
    ["-9999999999999999", "-10000T", "-10000T"],
    ["1000", "1K", "1K"],
    ["1001", "1K", "1K"],
    ["1010", "1K", "1K"],
    ["1100", "1.1K", "1.1K"],
    ["2000", "2K", "2K"],
    ["2001", "2K", "2K"],
    ["2010", "2K", "2K"],
    ["2100", "2.1K", "2.1K"],
    ["3000", "3K", "3K"],
    ["3001", "3K", "3K"],
    ["3010", "3K", "3K"],
    ["3100", "3.1K", "3.1K"],
    ["4000", "4K", "4K"],
    ["4001", "4K", "4K"],
    ["4010", "4K", "4K"],
    ["4100", "4.1K", "4.1K"],
    ["5000", "5K", "5K"],
    ["5001", "5K", "5K"],
    ["5010", "5K", "5K"],
    ["5100", "5.1K", "5.1K"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1K"],
    ["9999.12", "10K", "10K"],
    ["9999.99", "10K", "10K"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1K"],
    ["-9999.12", "-10K", "-10K"],
    ["-9999.99", "-10K", "-10K"],
  ],
  "he": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K‏", "‏4.3 אלף"],
    ["54321", "54K‏", "‏54 אלף"],
    ["654321", "654K‏", "‏654 אלף"],
    ["7654321", "7.7M‏", "‏7.7 מיליון"],
    ["87654321", "88M‏", "‏88 מיליון"],
    ["987654321", "988M‏", "‏988 מיליון"],
    ["1087654321", "1.1B‏", "‏1.1 מיליארד"],
    ["11987654321", "12B‏", "‏12 מיליארד"],
    ["129987654321", "130B‏", "‏130 מיליארד"],
    ["1398987654321", "1.4T‏", "‏1.4 טריליון"],
    ["14987987654321", "15T‏", "‏15 טריליון"],
    ["159876987654321", "160T‏", "‏160 טריליון"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K‏", "‏10 אלף"],
    ["99999", "100K‏", "‏100 אלף"],
    ["999999", "1M‏", "‏1 מיליון"],
    ["9999999", "10M‏", "‏10 מיליון"],
    ["99999999", "100M‏", "‏100 מיליון"],
    ["9994", "10K‏", "‏10 אלף"],
    ["99944", "100K‏", "‏100 אלף"],
    ["999444", "999K‏", "‏999 אלף"],
    ["9994444", "10M‏", "‏10 מיליון"],
    ["999444444", "999M‏", "‏999 מיליון"],
    ["9994444444", "10B‏", "‏10 מיליארד"],
    ["1000000000000000", "1000T‏", "‏1000 טריליון"],
    ["10000000000000000", "10000T‏", "‏10000 טריליון"],
    ["0", "0", "0"],
    ["-1", "‎-1", "‎-1"],
    ["-2", "‎-2", "‎-2"],
    ["-3", "‎-3", "‎-3"],
    ["-1000", "‎-1K‏", "‎-‏1 אלף"],
    ["-1001", "‎-1K‏", "‎-‏1 אלף"],
    ["-1010", "‎-1K‏", "‎-‏1 אלף"],
    ["-1100", "‎-1.1K‏", "‎-‏1.1 אלף"],
    ["-2000", "‎-2K‏", "‎-‏2 אלף"],
    ["-2001", "‎-2K‏", "‎-‏2 אלף"],
    ["-2010", "‎-2K‏", "‎-‏2 אלף"],
    ["-2100", "‎-2.1K‏", "‎-‏2.1 אלף"],
    ["-9", "‎-9", "‎-9"],
    ["-99", "‎-99", "‎-99"],
    ["-999", "‎-999", "‎-999"],
    ["-9999", "‎-10K‏", "‎-‏10 אלף"],
    ["-99999", "‎-100K‏", "‎-‏100 אלף"],
    ["-999999", "‎-1M‏", "‎-‏1 מיליון"],
    ["-9999999", "‎-10M‏", "‎-‏10 מיליון"],
    ["-9999999999999999", "‎-10000T‏", "‎-‏10000 טריליון"],
    ["1000", "1K‏", "‏1 אלף"],
    ["1001", "1K‏", "‏1 אלף"],
    ["1010", "1K‏", "‏1 אלף"],
    ["1100", "1.1K‏", "‏1.1 אלף"],
    ["2000", "2K‏", "‏2 אלף"],
    ["2001", "2K‏", "‏2 אלף"],
    ["2010", "2K‏", "‏2 אלף"],
    ["2100", "2.1K‏", "‏2.1 אלף"],
    ["3000", "3K‏", "‏3 אלף"],
    ["3001", "3K‏", "‏3 אלף"],
    ["3010", "3K‏", "‏3 אלף"],
    ["3100", "3.1K‏", "‏3.1 אלף"],
    ["4000", "4K‏", "‏4 אלף"],
    ["4001", "4K‏", "‏4 אלף"],
    ["4010", "4K‏", "‏4 אלף"],
    ["4100", "4.1K‏", "‏4.1 אלף"],
    ["5000", "5K‏", "‏5 אלף"],
    ["5001", "5K‏", "‏5 אלף"],
    ["5010", "5K‏", "‏5 אלף"],
    ["5100", "5.1K‏", "‏5.1 אלף"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K‏", "‏1 אלף"],
    ["9999.12", "10K‏", "‏10 אלף"],
    ["9999.99", "10K‏", "‏10 אלף"],
    ["-0.12", "‎-0.12", "‎-0.12"],
    ["-0.99", "‎-0.99", "‎-0.99"],
    ["-9.12", "‎-9.1", "‎-9.1"],
    ["-9.99", "‎-10", "‎-10"],
    ["-999.12", "‎-999", "‎-999"],
    ["-999.99", "‎-1K‏", "‎-‏1 אלף"],
    ["-9999.12", "‎-10K‏", "‎-‏10 אלף"],
    ["-9999.99", "‎-10K‏", "‎-‏10 אלף"],
  ],
  "hi": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 हज़ार", "4.3 हज़ार"],
    ["54321", "54 हज़ार", "54 हज़ार"],
    ["654321", "6.5 लाख", "6.5 लाख"],
    ["7654321", "77 लाख", "77 लाख"],
    ["87654321", "8.8 क॰", "8.8 करोड़"],
    ["987654321", "99 क॰", "99 करोड़"],
    ["1087654321", "1.1 अ॰", "1.1 अरब"],
    ["11987654321", "12 अ॰", "12 अरब"],
    ["129987654321", "1.3 ख॰", "1.3 खरब"],
    ["1398987654321", "14 ख॰", "14 खरब"],
    ["14987987654321", "1.5 नील", "150 खरब"],
    ["159876987654321", "16 नील", "1599 खरब"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 हज़ार", "10 हज़ार"],
    ["99999", "1 लाख", "1 लाख"],
    ["999999", "10 लाख", "10 लाख"],
    ["9999999", "1 क॰", "1 करोड़"],
    ["99999999", "10 क॰", "10 करोड़"],
    ["9994", "10 हज़ार", "10 हज़ार"],
    ["99944", "1 लाख", "1 लाख"],
    ["999444", "10 लाख", "10 लाख"],
    ["9994444", "1 क॰", "1 करोड़"],
    ["999444444", "1 अ॰", "1 अरब"],
    ["9994444444", "10 अ॰", "10 अरब"],
    ["1000000000000000", "100 नील", "10000 खरब"],
    ["10000000000000000", "1000 नील", "100000 खरब"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 हज़ार", "-1 हज़ार"],
    ["-1001", "-1 हज़ार", "-1 हज़ार"],
    ["-1010", "-1 हज़ार", "-1 हज़ार"],
    ["-1100", "-1.1 हज़ार", "-1.1 हज़ार"],
    ["-2000", "-2 हज़ार", "-2 हज़ार"],
    ["-2001", "-2 हज़ार", "-2 हज़ार"],
    ["-2010", "-2 हज़ार", "-2 हज़ार"],
    ["-2100", "-2.1 हज़ार", "-2.1 हज़ार"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 हज़ार", "-10 हज़ार"],
    ["-99999", "-1 लाख", "-1 लाख"],
    ["-999999", "-10 लाख", "-10 लाख"],
    ["-9999999", "-1 क॰", "-1 करोड़"],
    ["-9999999999999999", "-1000 नील", "-100000 खरब"],
    ["1000", "1 हज़ार", "1 हज़ार"],
    ["1001", "1 हज़ार", "1 हज़ार"],
    ["1010", "1 हज़ार", "1 हज़ार"],
    ["1100", "1.1 हज़ार", "1.1 हज़ार"],
    ["2000", "2 हज़ार", "2 हज़ार"],
    ["2001", "2 हज़ार", "2 हज़ार"],
    ["2010", "2 हज़ार", "2 हज़ार"],
    ["2100", "2.1 हज़ार", "2.1 हज़ार"],
    ["3000", "3 हज़ार", "3 हज़ार"],
    ["3001", "3 हज़ार", "3 हज़ार"],
    ["3010", "3 हज़ार", "3 हज़ार"],
    ["3100", "3.1 हज़ार", "3.1 हज़ार"],
    ["4000", "4 हज़ार", "4 हज़ार"],
    ["4001", "4 हज़ार", "4 हज़ार"],
    ["4010", "4 हज़ार", "4 हज़ार"],
    ["4100", "4.1 हज़ार", "4.1 हज़ार"],
    ["5000", "5 हज़ार", "5 हज़ार"],
    ["5001", "5 हज़ार", "5 हज़ार"],
    ["5010", "5 हज़ार", "5 हज़ार"],
    ["5100", "5.1 हज़ार", "5.1 हज़ार"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 हज़ार", "1 हज़ार"],
    ["9999.12", "10 हज़ार", "10 हज़ार"],
    ["9999.99", "10 हज़ार", "10 हज़ार"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 हज़ार", "-1 हज़ार"],
    ["-9999.12", "-10 हज़ार", "-10 हज़ार"],
    ["-9999.99", "-10 हज़ार", "-10 हज़ार"],
  ],
  "hr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tis.", "4,3 tisuće"],
    ["54321", "54 tis.", "54 tisuće"],
    ["654321", "654 tis.", "654 tisuće"],
    ["7654321", "7,7 mil.", "7,7 milijuna"],
    ["87654321", "88 mil.", "88 milijuna"],
    ["987654321", "988 mil.", "988 milijuna"],
    ["1087654321", "1,1 mlr.", "1,1 milijarda"],
    ["11987654321", "12 mlr.", "12 milijardi"],
    ["129987654321", "130 mlr.", "130 milijardi"],
    ["1398987654321", "1,4 bil.", "1,4 bilijuna"],
    ["14987987654321", "15 bil.", "15 bilijuna"],
    ["159876987654321", "160 bil.", "160 bilijuna"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tis.", "10 tisuća"],
    ["99999", "100 tis.", "100 tisuća"],
    ["999999", "1 mil.", "1 milijun"],
    ["9999999", "10 mil.", "10 milijuna"],
    ["99999999", "100 mil.", "100 milijuna"],
    ["9994", "10 tis.", "10 tisuća"],
    ["99944", "100 tis.", "100 tisuća"],
    ["999444", "999 tis.", "999 tisuća"],
    ["9994444", "10 mil.", "10 milijuna"],
    ["999444444", "999 mil.", "999 milijuna"],
    ["9994444444", "10 mlr.", "10 milijardi"],
    ["1000000000000000", "1000 bil.", "1000 bilijuna"],
    ["10000000000000000", "10000 bil.", "10000 bilijuna"],
    ["0", "0", "0"],
    ["-1", "−1", "−1"],
    ["-2", "−2", "−2"],
    ["-3", "−3", "−3"],
    ["-1000", "−1 tis.", "−1 tisuća"],
    ["-1001", "−1 tis.", "−1 tisuća"],
    ["-1010", "−1 tis.", "−1 tisuća"],
    ["-1100", "−1,1 tis.", "−1,1 tisuća"],
    ["-2000", "−2 tis.", "−2 tisuće"],
    ["-2001", "−2 tis.", "−2 tisuće"],
    ["-2010", "−2 tis.", "−2 tisuće"],
    ["-2100", "−2,1 tis.", "−2,1 tisuća"],
    ["-9", "−9", "−9"],
    ["-99", "−99", "−99"],
    ["-999", "−999", "−999"],
    ["-9999", "−10 tis.", "−10 tisuća"],
    ["-99999", "−100 tis.", "−100 tisuća"],
    ["-999999", "−1 mil.", "−1 milijun"],
    ["-9999999", "−10 mil.", "−10 milijuna"],
    ["-9999999999999999", "−10000 bil.", "−10000 bilijuna"],
    ["1000", "1 tis.", "1 tisuća"],
    ["1001", "1 tis.", "1 tisuća"],
    ["1010", "1 tis.", "1 tisuća"],
    ["1100", "1,1 tis.", "1,1 tisuća"],
    ["2000", "2 tis.", "2 tisuće"],
    ["2001", "2 tis.", "2 tisuće"],
    ["2010", "2 tis.", "2 tisuće"],
    ["2100", "2,1 tis.", "2,1 tisuća"],
    ["3000", "3 tis.", "3 tisuće"],
    ["3001", "3 tis.", "3 tisuće"],
    ["3010", "3 tis.", "3 tisuće"],
    ["3100", "3,1 tis.", "3,1 tisuća"],
    ["4000", "4 tis.", "4 tisuće"],
    ["4001", "4 tis.", "4 tisuće"],
    ["4010", "4 tis.", "4 tisuće"],
    ["4100", "4,1 tis.", "4,1 tisuća"],
    ["5000", "5 tis.", "5 tisuća"],
    ["5001", "5 tis.", "5 tisuća"],
    ["5010", "5 tis.", "5 tisuća"],
    ["5100", "5,1 tis.", "5,1 tisuća"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 tis.", "1 tisuća"],
    ["9999.12", "10 tis.", "10 tisuća"],
    ["9999.99", "10 tis.", "10 tisuća"],
    ["-0.12", "−0,12", "−0,12"],
    ["-0.99", "−0,99", "−0,99"],
    ["-9.12", "−9,1", "−9,1"],
    ["-9.99", "−10", "−10"],
    ["-999.12", "−999", "−999"],
    ["-999.99", "−1 tis.", "−1 tisuća"],
    ["-9999.12", "−10 tis.", "−10 tisuća"],
    ["-9999.99", "−10 tis.", "−10 tisuća"],
  ],
  "hu": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 E", "4,3 ezer"],
    ["54321", "54 E", "54 ezer"],
    ["654321", "654 E", "654 ezer"],
    ["7654321", "7,7 M", "7,7 millió"],
    ["87654321", "88 M", "88 millió"],
    ["987654321", "988 M", "988 millió"],
    ["1087654321", "1,1 Mrd", "1,1 milliárd"],
    ["11987654321", "12 Mrd", "12 milliárd"],
    ["129987654321", "130 Mrd", "130 milliárd"],
    ["1398987654321", "1,4 B", "1,4 billió"],
    ["14987987654321", "15 B", "15 billió"],
    ["159876987654321", "160 B", "160 billió"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 E", "10 ezer"],
    ["99999", "100 E", "100 ezer"],
    ["999999", "1 M", "1 millió"],
    ["9999999", "10 M", "10 millió"],
    ["99999999", "100 M", "100 millió"],
    ["9994", "10 E", "10 ezer"],
    ["99944", "100 E", "100 ezer"],
    ["999444", "999 E", "999 ezer"],
    ["9994444", "10 M", "10 millió"],
    ["999444444", "999 M", "999 millió"],
    ["9994444444", "10 Mrd", "10 milliárd"],
    ["1000000000000000", "1000 B", "1000 billió"],
    ["10000000000000000", "10000 B", "10000 billió"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 E", "-1 ezer"],
    ["-1001", "-1 E", "-1 ezer"],
    ["-1010", "-1 E", "-1 ezer"],
    ["-1100", "-1,1 E", "-1,1 ezer"],
    ["-2000", "-2 E", "-2 ezer"],
    ["-2001", "-2 E", "-2 ezer"],
    ["-2010", "-2 E", "-2 ezer"],
    ["-2100", "-2,1 E", "-2,1 ezer"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 E", "-10 ezer"],
    ["-99999", "-100 E", "-100 ezer"],
    ["-999999", "-1 M", "-1 millió"],
    ["-9999999", "-10 M", "-10 millió"],
    ["-9999999999999999", "-10000 B", "-10000 billió"],
    ["1000", "1 E", "1 ezer"],
    ["1001", "1 E", "1 ezer"],
    ["1010", "1 E", "1 ezer"],
    ["1100", "1,1 E", "1,1 ezer"],
    ["2000", "2 E", "2 ezer"],
    ["2001", "2 E", "2 ezer"],
    ["2010", "2 E", "2 ezer"],
    ["2100", "2,1 E", "2,1 ezer"],
    ["3000", "3 E", "3 ezer"],
    ["3001", "3 E", "3 ezer"],
    ["3010", "3 E", "3 ezer"],
    ["3100", "3,1 E", "3,1 ezer"],
    ["4000", "4 E", "4 ezer"],
    ["4001", "4 E", "4 ezer"],
    ["4010", "4 E", "4 ezer"],
    ["4100", "4,1 E", "4,1 ezer"],
    ["5000", "5 E", "5 ezer"],
    ["5001", "5 E", "5 ezer"],
    ["5010", "5 E", "5 ezer"],
    ["5100", "5,1 E", "5,1 ezer"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 E", "1 ezer"],
    ["9999.12", "10 E", "10 ezer"],
    ["9999.99", "10 E", "10 ezer"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 E", "-1 ezer"],
    ["-9999.12", "-10 E", "-10 ezer"],
    ["-9999.99", "-10 E", "-10 ezer"],
  ],
  "hy": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 հզր", "4,3 հազար"],
    ["54321", "54 հզր", "54 հազար"],
    ["654321", "654 հզր", "654 հազար"],
    ["7654321", "7,7 մլն", "7,7 միլիոն"],
    ["87654321", "88 մլն", "88 միլիոն"],
    ["987654321", "988 մլն", "988 միլիոն"],
    ["1087654321", "1,1 մլրդ", "1,1 միլիարդ"],
    ["11987654321", "12 մլրդ", "12 միլիարդ"],
    ["129987654321", "130 մլրդ", "130 միլիարդ"],
    ["1398987654321", "1,4 տրլն", "1,4 տրիլիոն"],
    ["14987987654321", "15 տրլն", "15 տրիլիոն"],
    ["159876987654321", "160 տրլն", "160 տրիլիոն"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 հզր", "10 հազար"],
    ["99999", "100 հզր", "100 հազար"],
    ["999999", "1 մլն", "1 միլիոն"],
    ["9999999", "10 մլն", "10 միլիոն"],
    ["99999999", "100 մլն", "100 միլիոն"],
    ["9994", "10 հզր", "10 հազար"],
    ["99944", "100 հզր", "100 հազար"],
    ["999444", "999 հզր", "999 հազար"],
    ["9994444", "10 մլն", "10 միլիոն"],
    ["999444444", "999 մլն", "999 միլիոն"],
    ["9994444444", "10 մլրդ", "10 միլիարդ"],
    ["1000000000000000", "1000 տրլն", "1000 տրիլիոն"],
    ["10000000000000000", "10000 տրլն", "10000 տրիլիոն"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 հզր", "-1 հազար"],
    ["-1001", "-1 հզր", "-1 հազար"],
    ["-1010", "-1 հզր", "-1 հազար"],
    ["-1100", "-1,1 հզր", "-1,1 հազար"],
    ["-2000", "-2 հզր", "-2 հազար"],
    ["-2001", "-2 հզր", "-2 հազար"],
    ["-2010", "-2 հզր", "-2 հազար"],
    ["-2100", "-2,1 հզր", "-2,1 հազար"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 հզր", "-10 հազար"],
    ["-99999", "-100 հզր", "-100 հազար"],
    ["-999999", "-1 մլն", "-1 միլիոն"],
    ["-9999999", "-10 մլն", "-10 միլիոն"],
    ["-9999999999999999", "-10000 տրլն", "-10000 տրիլիոն"],
    ["1000", "1 հզր", "1 հազար"],
    ["1001", "1 հզր", "1 հազար"],
    ["1010", "1 հզր", "1 հազար"],
    ["1100", "1,1 հզր", "1,1 հազար"],
    ["2000", "2 հզր", "2 հազար"],
    ["2001", "2 հզր", "2 հազար"],
    ["2010", "2 հզր", "2 հազար"],
    ["2100", "2,1 հզր", "2,1 հազար"],
    ["3000", "3 հզր", "3 հազար"],
    ["3001", "3 հզր", "3 հազար"],
    ["3010", "3 հզր", "3 հազար"],
    ["3100", "3,1 հզր", "3,1 հազար"],
    ["4000", "4 հզր", "4 հազար"],
    ["4001", "4 հզր", "4 հազար"],
    ["4010", "4 հզր", "4 հազար"],
    ["4100", "4,1 հզր", "4,1 հազար"],
    ["5000", "5 հզր", "5 հազար"],
    ["5001", "5 հզր", "5 հազար"],
    ["5010", "5 հզր", "5 հազար"],
    ["5100", "5,1 հզր", "5,1 հազար"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 հզր", "1 հազար"],
    ["9999.12", "10 հզր", "10 հազար"],
    ["9999.99", "10 հզր", "10 հազար"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 հզր", "-1 հազար"],
    ["-9999.12", "-10 հզր", "-10 հազար"],
    ["-9999.99", "-10 հզր", "-10 հազար"],
  ],
  "id": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 rb", "4,3 ribu"],
    ["54321", "54 rb", "54 ribu"],
    ["654321", "654 rb", "654 ribu"],
    ["7654321", "7,7 jt", "7,7 juta"],
    ["87654321", "88 jt", "88 juta"],
    ["987654321", "988 jt", "988 juta"],
    ["1087654321", "1,1 M", "1,1 miliar"],
    ["11987654321", "12 M", "12 miliar"],
    ["129987654321", "130 M", "130 miliar"],
    ["1398987654321", "1,4 T", "1,4 triliun"],
    ["14987987654321", "15 T", "15 triliun"],
    ["159876987654321", "160 T", "160 triliun"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 rb", "10 ribu"],
    ["99999", "100 rb", "100 ribu"],
    ["999999", "1 jt", "1 juta"],
    ["9999999", "10 jt", "10 juta"],
    ["99999999", "100 jt", "100 juta"],
    ["9994", "10 rb", "10 ribu"],
    ["99944", "100 rb", "100 ribu"],
    ["999444", "999 rb", "999 ribu"],
    ["9994444", "10 jt", "10 juta"],
    ["999444444", "999 jt", "999 juta"],
    ["9994444444", "10 M", "10 miliar"],
    ["1000000000000000", "1000 T", "1000 triliun"],
    ["10000000000000000", "10000 T", "10000 triliun"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 rb", "-1 ribu"],
    ["-1001", "-1 rb", "-1 ribu"],
    ["-1010", "-1 rb", "-1 ribu"],
    ["-1100", "-1,1 rb", "-1,1 ribu"],
    ["-2000", "-2 rb", "-2 ribu"],
    ["-2001", "-2 rb", "-2 ribu"],
    ["-2010", "-2 rb", "-2 ribu"],
    ["-2100", "-2,1 rb", "-2,1 ribu"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 rb", "-10 ribu"],
    ["-99999", "-100 rb", "-100 ribu"],
    ["-999999", "-1 jt", "-1 juta"],
    ["-9999999", "-10 jt", "-10 juta"],
    ["-9999999999999999", "-10000 T", "-10000 triliun"],
    ["1000", "1 rb", "1 ribu"],
    ["1001", "1 rb", "1 ribu"],
    ["1010", "1 rb", "1 ribu"],
    ["1100", "1,1 rb", "1,1 ribu"],
    ["2000", "2 rb", "2 ribu"],
    ["2001", "2 rb", "2 ribu"],
    ["2010", "2 rb", "2 ribu"],
    ["2100", "2,1 rb", "2,1 ribu"],
    ["3000", "3 rb", "3 ribu"],
    ["3001", "3 rb", "3 ribu"],
    ["3010", "3 rb", "3 ribu"],
    ["3100", "3,1 rb", "3,1 ribu"],
    ["4000", "4 rb", "4 ribu"],
    ["4001", "4 rb", "4 ribu"],
    ["4010", "4 rb", "4 ribu"],
    ["4100", "4,1 rb", "4,1 ribu"],
    ["5000", "5 rb", "5 ribu"],
    ["5001", "5 rb", "5 ribu"],
    ["5010", "5 rb", "5 ribu"],
    ["5100", "5,1 rb", "5,1 ribu"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 rb", "1 ribu"],
    ["9999.12", "10 rb", "10 ribu"],
    ["9999.99", "10 rb", "10 ribu"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 rb", "-1 ribu"],
    ["-9999.12", "-10 rb", "-10 ribu"],
    ["-9999.99", "-10 rb", "-10 ribu"],
  ],
  "in": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 rb", "4,3 ribu"],
    ["54321", "54 rb", "54 ribu"],
    ["654321", "654 rb", "654 ribu"],
    ["7654321", "7,7 jt", "7,7 juta"],
    ["87654321", "88 jt", "88 juta"],
    ["987654321", "988 jt", "988 juta"],
    ["1087654321", "1,1 M", "1,1 miliar"],
    ["11987654321", "12 M", "12 miliar"],
    ["129987654321", "130 M", "130 miliar"],
    ["1398987654321", "1,4 T", "1,4 triliun"],
    ["14987987654321", "15 T", "15 triliun"],
    ["159876987654321", "160 T", "160 triliun"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 rb", "10 ribu"],
    ["99999", "100 rb", "100 ribu"],
    ["999999", "1 jt", "1 juta"],
    ["9999999", "10 jt", "10 juta"],
    ["99999999", "100 jt", "100 juta"],
    ["9994", "10 rb", "10 ribu"],
    ["99944", "100 rb", "100 ribu"],
    ["999444", "999 rb", "999 ribu"],
    ["9994444", "10 jt", "10 juta"],
    ["999444444", "999 jt", "999 juta"],
    ["9994444444", "10 M", "10 miliar"],
    ["1000000000000000", "1000 T", "1000 triliun"],
    ["10000000000000000", "10000 T", "10000 triliun"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 rb", "-1 ribu"],
    ["-1001", "-1 rb", "-1 ribu"],
    ["-1010", "-1 rb", "-1 ribu"],
    ["-1100", "-1,1 rb", "-1,1 ribu"],
    ["-2000", "-2 rb", "-2 ribu"],
    ["-2001", "-2 rb", "-2 ribu"],
    ["-2010", "-2 rb", "-2 ribu"],
    ["-2100", "-2,1 rb", "-2,1 ribu"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 rb", "-10 ribu"],
    ["-99999", "-100 rb", "-100 ribu"],
    ["-999999", "-1 jt", "-1 juta"],
    ["-9999999", "-10 jt", "-10 juta"],
    ["-9999999999999999", "-10000 T", "-10000 triliun"],
    ["1000", "1 rb", "1 ribu"],
    ["1001", "1 rb", "1 ribu"],
    ["1010", "1 rb", "1 ribu"],
    ["1100", "1,1 rb", "1,1 ribu"],
    ["2000", "2 rb", "2 ribu"],
    ["2001", "2 rb", "2 ribu"],
    ["2010", "2 rb", "2 ribu"],
    ["2100", "2,1 rb", "2,1 ribu"],
    ["3000", "3 rb", "3 ribu"],
    ["3001", "3 rb", "3 ribu"],
    ["3010", "3 rb", "3 ribu"],
    ["3100", "3,1 rb", "3,1 ribu"],
    ["4000", "4 rb", "4 ribu"],
    ["4001", "4 rb", "4 ribu"],
    ["4010", "4 rb", "4 ribu"],
    ["4100", "4,1 rb", "4,1 ribu"],
    ["5000", "5 rb", "5 ribu"],
    ["5001", "5 rb", "5 ribu"],
    ["5010", "5 rb", "5 ribu"],
    ["5100", "5,1 rb", "5,1 ribu"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 rb", "1 ribu"],
    ["9999.12", "10 rb", "10 ribu"],
    ["9999.99", "10 rb", "10 ribu"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 rb", "-1 ribu"],
    ["-9999.12", "-10 rb", "-10 ribu"],
    ["-9999.99", "-10 rb", "-10 ribu"],
  ],
  "is": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 þ.", "4,3 þúsund"],
    ["54321", "54 þ.", "54 þúsund"],
    ["654321", "654 þ.", "654 þúsund"],
    ["7654321", "7,7 m.", "7,7 milljónir"],
    ["87654321", "88 m.", "88 milljónir"],
    ["987654321", "988 m.", "988 milljónir"],
    ["1087654321", "1,1 ma.", "1,1 milljarður"],
    ["11987654321", "12 ma.", "12 milljarðar"],
    ["129987654321", "130 ma.", "130 milljarðar"],
    ["1398987654321", "1,4 bn", "1,4 billjónir"],
    ["14987987654321", "15 bn", "15 billjónir"],
    ["159876987654321", "160 bn", "160 billjónir"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 þ.", "10 þúsund"],
    ["99999", "100 þ.", "100 þúsund"],
    ["999999", "1 m.", "1 milljón"],
    ["9999999", "10 m.", "10 milljónir"],
    ["99999999", "100 m.", "100 milljónir"],
    ["9994", "10 þ.", "10 þúsund"],
    ["99944", "100 þ.", "100 þúsund"],
    ["999444", "999 þ.", "999 þúsund"],
    ["9994444", "10 m.", "10 milljónir"],
    ["999444444", "999 m.", "999 milljónir"],
    ["9994444444", "10 ma.", "10 milljarðar"],
    ["1000000000000000", "1000 bn", "1000 billjónir"],
    ["10000000000000000", "10000 bn", "10000 billjónir"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 þ.", "-1 þúsund"],
    ["-1001", "-1 þ.", "-1 þúsund"],
    ["-1010", "-1 þ.", "-1 þúsund"],
    ["-1100", "-1,1 þ.", "-1,1 þúsund"],
    ["-2000", "-2 þ.", "-2 þúsund"],
    ["-2001", "-2 þ.", "-2 þúsund"],
    ["-2010", "-2 þ.", "-2 þúsund"],
    ["-2100", "-2,1 þ.", "-2,1 þúsund"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 þ.", "-10 þúsund"],
    ["-99999", "-100 þ.", "-100 þúsund"],
    ["-999999", "-1 m.", "-1 milljón"],
    ["-9999999", "-10 m.", "-10 milljónir"],
    ["-9999999999999999", "-10000 bn", "-10000 billjónir"],
    ["1000", "1 þ.", "1 þúsund"],
    ["1001", "1 þ.", "1 þúsund"],
    ["1010", "1 þ.", "1 þúsund"],
    ["1100", "1,1 þ.", "1,1 þúsund"],
    ["2000", "2 þ.", "2 þúsund"],
    ["2001", "2 þ.", "2 þúsund"],
    ["2010", "2 þ.", "2 þúsund"],
    ["2100", "2,1 þ.", "2,1 þúsund"],
    ["3000", "3 þ.", "3 þúsund"],
    ["3001", "3 þ.", "3 þúsund"],
    ["3010", "3 þ.", "3 þúsund"],
    ["3100", "3,1 þ.", "3,1 þúsund"],
    ["4000", "4 þ.", "4 þúsund"],
    ["4001", "4 þ.", "4 þúsund"],
    ["4010", "4 þ.", "4 þúsund"],
    ["4100", "4,1 þ.", "4,1 þúsund"],
    ["5000", "5 þ.", "5 þúsund"],
    ["5001", "5 þ.", "5 þúsund"],
    ["5010", "5 þ.", "5 þúsund"],
    ["5100", "5,1 þ.", "5,1 þúsund"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 þ.", "1 þúsund"],
    ["9999.12", "10 þ.", "10 þúsund"],
    ["9999.99", "10 þ.", "10 þúsund"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 þ.", "-1 þúsund"],
    ["-9999.12", "-10 þ.", "-10 þúsund"],
    ["-9999.99", "-10 þ.", "-10 þúsund"],
  ],
  "it": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4,3 mila"],
    ["54321", "54321", "54 mila"],
    ["654321", "654321", "654 mila"],
    ["7654321", "7,7 Mio", "7,7 milioni"],
    ["87654321", "88 Mio", "88 milioni"],
    ["987654321", "988 Mio", "988 milioni"],
    ["1087654321", "1,1 Mrd", "1,1 miliardi"],
    ["11987654321", "12 Mrd", "12 miliardi"],
    ["129987654321", "130 Mrd", "130 miliardi"],
    ["1398987654321", "1,4 Bln", "1,4 mila miliardi"],
    ["14987987654321", "15 Bln", "15 mila miliardi"],
    ["159876987654321", "160 Bln", "160 mila miliardi"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "10 mila"],
    ["99999", "99999", "100 mila"],
    ["999999", "999999", "1 milione"],
    ["9999999", "10 Mio", "10 milioni"],
    ["99999999", "100 Mio", "100 milioni"],
    ["9994", "9994", "10 mila"],
    ["99944", "99944", "100 mila"],
    ["999444", "999444", "999 mila"],
    ["9994444", "10 Mio", "10 milioni"],
    ["999444444", "999 Mio", "999 milioni"],
    ["9994444444", "10 Mrd", "10 miliardi"],
    ["1000000000000000", "1000 Bln", "1000 mila miliardi"],
    ["10000000000000000", "10000 Bln", "10000 mila miliardi"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1000", "-mille"],
    ["-1001", "-1001", "-mille"],
    ["-1010", "-1010", "-mille"],
    ["-1100", "-1100", "-1,1 mila"],
    ["-2000", "-2000", "-2 mila"],
    ["-2001", "-2001", "-2 mila"],
    ["-2010", "-2010", "-2 mila"],
    ["-2100", "-2100", "-2,1 mila"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-9999", "-10 mila"],
    ["-99999", "-99999", "-100 mila"],
    ["-999999", "-999999", "-1 milione"],
    ["-9999999", "-10 Mio", "-10 milioni"],
    ["-9999999999999999", "-10000 Bln", "-10000 mila miliardi"],
    ["1000", "1000", "mille"],
    ["1001", "1001", "mille"],
    ["1010", "1010", "mille"],
    ["1100", "1100", "1,1 mila"],
    ["2000", "2000", "2 mila"],
    ["2001", "2001", "2 mila"],
    ["2010", "2010", "2 mila"],
    ["2100", "2100", "2,1 mila"],
    ["3000", "3000", "3 mila"],
    ["3001", "3001", "3 mila"],
    ["3010", "3010", "3 mila"],
    ["3100", "3100", "3,1 mila"],
    ["4000", "4000", "4 mila"],
    ["4001", "4001", "4 mila"],
    ["4010", "4010", "4 mila"],
    ["4100", "4100", "4,1 mila"],
    ["5000", "5000", "5 mila"],
    ["5001", "5001", "5 mila"],
    ["5010", "5010", "5 mila"],
    ["5100", "5100", "5,1 mila"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1000", "mille"],
    ["9999.12", "9999", "10 mila"],
    ["9999.99", "10000", "10 mila"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1000", "-mille"],
    ["-9999.12", "-9999", "-10 mila"],
    ["-9999.99", "-10000", "-10 mila"],
  ],
  "it_CH": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4.3 mila"],
    ["54321", "54321", "54 mila"],
    ["654321", "654321", "654 mila"],
    ["7654321", "7.7 Mio", "7.7 milioni"],
    ["87654321", "88 Mio", "88 milioni"],
    ["987654321", "988 Mio", "988 milioni"],
    ["1087654321", "1.1 Mrd", "1.1 miliardi"],
    ["11987654321", "12 Mrd", "12 miliardi"],
    ["129987654321", "130 Mrd", "130 miliardi"],
    ["1398987654321", "1.4 Bln", "1.4 mila miliardi"],
    ["14987987654321", "15 Bln", "15 mila miliardi"],
    ["159876987654321", "160 Bln", "160 mila miliardi"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "10 mila"],
    ["99999", "99999", "100 mila"],
    ["999999", "999999", "1 milione"],
    ["9999999", "10 Mio", "10 milioni"],
    ["99999999", "100 Mio", "100 milioni"],
    ["9994", "9994", "10 mila"],
    ["99944", "99944", "100 mila"],
    ["999444", "999444", "999 mila"],
    ["9994444", "10 Mio", "10 milioni"],
    ["999444444", "999 Mio", "999 milioni"],
    ["9994444444", "10 Mrd", "10 miliardi"],
    ["1000000000000000", "1000 Bln", "1000 mila miliardi"],
    ["10000000000000000", "10000 Bln", "10000 mila miliardi"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1000", "-mille"],
    ["-1001", "-1001", "-mille"],
    ["-1010", "-1010", "-mille"],
    ["-1100", "-1100", "-1.1 mila"],
    ["-2000", "-2000", "-2 mila"],
    ["-2001", "-2001", "-2 mila"],
    ["-2010", "-2010", "-2 mila"],
    ["-2100", "-2100", "-2.1 mila"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-9999", "-10 mila"],
    ["-99999", "-99999", "-100 mila"],
    ["-999999", "-999999", "-1 milione"],
    ["-9999999", "-10 Mio", "-10 milioni"],
    ["-9999999999999999", "-10000 Bln", "-10000 mila miliardi"],
    ["1000", "1000", "mille"],
    ["1001", "1001", "mille"],
    ["1010", "1010", "mille"],
    ["1100", "1100", "1.1 mila"],
    ["2000", "2000", "2 mila"],
    ["2001", "2001", "2 mila"],
    ["2010", "2010", "2 mila"],
    ["2100", "2100", "2.1 mila"],
    ["3000", "3000", "3 mila"],
    ["3001", "3001", "3 mila"],
    ["3010", "3010", "3 mila"],
    ["3100", "3100", "3.1 mila"],
    ["4000", "4000", "4 mila"],
    ["4001", "4001", "4 mila"],
    ["4010", "4010", "4 mila"],
    ["4100", "4100", "4.1 mila"],
    ["5000", "5000", "5 mila"],
    ["5001", "5001", "5 mila"],
    ["5010", "5010", "5 mila"],
    ["5100", "5100", "5.1 mila"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1000", "mille"],
    ["9999.12", "9999", "10 mila"],
    ["9999.99", "10000", "10 mila"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1000", "-mille"],
    ["-9999.12", "-9999", "-10 mila"],
    ["-9999.99", "-10000", "-10 mila"],
  ],
  "iw": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K‏", "‏4.3 אלף"],
    ["54321", "54K‏", "‏54 אלף"],
    ["654321", "654K‏", "‏654 אלף"],
    ["7654321", "7.7M‏", "‏7.7 מיליון"],
    ["87654321", "88M‏", "‏88 מיליון"],
    ["987654321", "988M‏", "‏988 מיליון"],
    ["1087654321", "1.1B‏", "‏1.1 מיליארד"],
    ["11987654321", "12B‏", "‏12 מיליארד"],
    ["129987654321", "130B‏", "‏130 מיליארד"],
    ["1398987654321", "1.4T‏", "‏1.4 טריליון"],
    ["14987987654321", "15T‏", "‏15 טריליון"],
    ["159876987654321", "160T‏", "‏160 טריליון"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K‏", "‏10 אלף"],
    ["99999", "100K‏", "‏100 אלף"],
    ["999999", "1M‏", "‏1 מיליון"],
    ["9999999", "10M‏", "‏10 מיליון"],
    ["99999999", "100M‏", "‏100 מיליון"],
    ["9994", "10K‏", "‏10 אלף"],
    ["99944", "100K‏", "‏100 אלף"],
    ["999444", "999K‏", "‏999 אלף"],
    ["9994444", "10M‏", "‏10 מיליון"],
    ["999444444", "999M‏", "‏999 מיליון"],
    ["9994444444", "10B‏", "‏10 מיליארד"],
    ["1000000000000000", "1000T‏", "‏1000 טריליון"],
    ["10000000000000000", "10000T‏", "‏10000 טריליון"],
    ["0", "0", "0"],
    ["-1", "‎-1", "‎-1"],
    ["-2", "‎-2", "‎-2"],
    ["-3", "‎-3", "‎-3"],
    ["-1000", "‎-1K‏", "‎-‏1 אלף"],
    ["-1001", "‎-1K‏", "‎-‏1 אלף"],
    ["-1010", "‎-1K‏", "‎-‏1 אלף"],
    ["-1100", "‎-1.1K‏", "‎-‏1.1 אלף"],
    ["-2000", "‎-2K‏", "‎-‏2 אלף"],
    ["-2001", "‎-2K‏", "‎-‏2 אלף"],
    ["-2010", "‎-2K‏", "‎-‏2 אלף"],
    ["-2100", "‎-2.1K‏", "‎-‏2.1 אלף"],
    ["-9", "‎-9", "‎-9"],
    ["-99", "‎-99", "‎-99"],
    ["-999", "‎-999", "‎-999"],
    ["-9999", "‎-10K‏", "‎-‏10 אלף"],
    ["-99999", "‎-100K‏", "‎-‏100 אלף"],
    ["-999999", "‎-1M‏", "‎-‏1 מיליון"],
    ["-9999999", "‎-10M‏", "‎-‏10 מיליון"],
    ["-9999999999999999", "‎-10000T‏", "‎-‏10000 טריליון"],
    ["1000", "1K‏", "‏1 אלף"],
    ["1001", "1K‏", "‏1 אלף"],
    ["1010", "1K‏", "‏1 אלף"],
    ["1100", "1.1K‏", "‏1.1 אלף"],
    ["2000", "2K‏", "‏2 אלף"],
    ["2001", "2K‏", "‏2 אלף"],
    ["2010", "2K‏", "‏2 אלף"],
    ["2100", "2.1K‏", "‏2.1 אלף"],
    ["3000", "3K‏", "‏3 אלף"],
    ["3001", "3K‏", "‏3 אלף"],
    ["3010", "3K‏", "‏3 אלף"],
    ["3100", "3.1K‏", "‏3.1 אלף"],
    ["4000", "4K‏", "‏4 אלף"],
    ["4001", "4K‏", "‏4 אלף"],
    ["4010", "4K‏", "‏4 אלף"],
    ["4100", "4.1K‏", "‏4.1 אלף"],
    ["5000", "5K‏", "‏5 אלף"],
    ["5001", "5K‏", "‏5 אלף"],
    ["5010", "5K‏", "‏5 אלף"],
    ["5100", "5.1K‏", "‏5.1 אלף"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K‏", "‏1 אלף"],
    ["9999.12", "10K‏", "‏10 אלף"],
    ["9999.99", "10K‏", "‏10 אלף"],
    ["-0.12", "‎-0.12", "‎-0.12"],
    ["-0.99", "‎-0.99", "‎-0.99"],
    ["-9.12", "‎-9.1", "‎-9.1"],
    ["-9.99", "‎-10", "‎-10"],
    ["-999.12", "‎-999", "‎-999"],
    ["-999.99", "‎-1K‏", "‎-‏1 אלף"],
    ["-9999.12", "‎-10K‏", "‎-‏10 אלף"],
    ["-9999.99", "‎-10K‏", "‎-‏10 אלף"],
  ],
  "ja": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4321"],
    ["54321", "5.4万", "5.4万"],
    ["654321", "65万", "65万"],
    ["7654321", "765万", "765万"],
    ["87654321", "8765万", "8765万"],
    ["987654321", "9.9億", "9.9億"],
    ["1087654321", "11億", "11億"],
    ["11987654321", "120億", "120億"],
    ["129987654321", "1300億", "1300億"],
    ["1398987654321", "1.4兆", "1.4兆"],
    ["14987987654321", "15兆", "15兆"],
    ["159876987654321", "160兆", "160兆"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "9999"],
    ["99999", "10万", "10万"],
    ["999999", "100万", "100万"],
    ["9999999", "1000万", "1000万"],
    ["99999999", "1億", "1億"],
    ["9994", "9994", "9994"],
    ["99944", "10万", "10万"],
    ["999444", "100万", "100万"],
    ["9994444", "999万", "999万"],
    ["999444444", "10億", "10億"],
    ["9994444444", "100億", "100億"],
    ["1000000000000000", "1000兆", "1000兆"],
    ["10000000000000000", "1京", "1京"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1000", "-1000"],
    ["-1001", "-1001", "-1001"],
    ["-1010", "-1010", "-1010"],
    ["-1100", "-1100", "-1100"],
    ["-2000", "-2000", "-2000"],
    ["-2001", "-2001", "-2001"],
    ["-2010", "-2010", "-2010"],
    ["-2100", "-2100", "-2100"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-9999", "-9999"],
    ["-99999", "-10万", "-10万"],
    ["-999999", "-100万", "-100万"],
    ["-9999999", "-1000万", "-1000万"],
    ["-9999999999999999", "-1京", "-1京"],
    ["1000", "1000", "1000"],
    ["1001", "1001", "1001"],
    ["1010", "1010", "1010"],
    ["1100", "1100", "1100"],
    ["2000", "2000", "2000"],
    ["2001", "2001", "2001"],
    ["2010", "2010", "2010"],
    ["2100", "2100", "2100"],
    ["3000", "3000", "3000"],
    ["3001", "3001", "3001"],
    ["3010", "3010", "3010"],
    ["3100", "3100", "3100"],
    ["4000", "4000", "4000"],
    ["4001", "4001", "4001"],
    ["4010", "4010", "4010"],
    ["4100", "4100", "4100"],
    ["5000", "5000", "5000"],
    ["5001", "5001", "5001"],
    ["5010", "5010", "5010"],
    ["5100", "5100", "5100"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1000", "1000"],
    ["9999.12", "9999", "9999"],
    ["9999.99", "1万", "1万"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1000", "-1000"],
    ["-9999.12", "-9999", "-9999"],
    ["-9999.99", "-1万", "-1万"],
  ],
  "ka": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 ათ.", "4,3 ათასი"],
    ["54321", "54 ათ.", "54 ათასი"],
    ["654321", "654 ათ.", "654 ათასი"],
    ["7654321", "7,7 მლნ.", "7,7 მილიონი"],
    ["87654321", "88 მლნ.", "88 მილიონი"],
    ["987654321", "988 მლნ.", "988 მილიონი"],
    ["1087654321", "1,1 მლრდ.", "1,1 მილიარდი"],
    ["11987654321", "12 მლრდ.", "12 მილიარდი"],
    ["129987654321", "130 მლრ.", "130 მილიარდი"],
    ["1398987654321", "1,4 ტრლ.", "1,4 ტრილიონი"],
    ["14987987654321", "15 ტრლ.", "15 ტრილიონი"],
    ["159876987654321", "160 ტრლ.", "160 ტრილიონი"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ათ.", "10 ათასი"],
    ["99999", "100 ათ.", "100 ათასი"],
    ["999999", "1 მლნ.", "1 მილიონი"],
    ["9999999", "10 მლნ.", "10 მილიონი"],
    ["99999999", "100 მლნ.", "100 მილიონი"],
    ["9994", "10 ათ.", "10 ათასი"],
    ["99944", "100 ათ.", "100 ათასი"],
    ["999444", "999 ათ.", "999 ათასი"],
    ["9994444", "10 მლნ.", "10 მილიონი"],
    ["999444444", "999 მლნ.", "999 მილიონი"],
    ["9994444444", "10 მლრდ.", "10 მილიარდი"],
    ["1000000000000000", "1000 ტრლ.", "1000 ტრილიონი"],
    ["10000000000000000", "10000 ტრლ.", "10000 ტრილიონი"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 ათ.", "-1 ათასი"],
    ["-1001", "-1 ათ.", "-1 ათასი"],
    ["-1010", "-1 ათ.", "-1 ათასი"],
    ["-1100", "-1,1 ათ.", "-1,1 ათასი"],
    ["-2000", "-2 ათ.", "-2 ათასი"],
    ["-2001", "-2 ათ.", "-2 ათასი"],
    ["-2010", "-2 ათ.", "-2 ათასი"],
    ["-2100", "-2,1 ათ.", "-2,1 ათასი"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 ათ.", "-10 ათასი"],
    ["-99999", "-100 ათ.", "-100 ათასი"],
    ["-999999", "-1 მლნ.", "-1 მილიონი"],
    ["-9999999", "-10 მლნ.", "-10 მილიონი"],
    ["-9999999999999999", "-10000 ტრლ.", "-10000 ტრილიონი"],
    ["1000", "1 ათ.", "1 ათასი"],
    ["1001", "1 ათ.", "1 ათასი"],
    ["1010", "1 ათ.", "1 ათასი"],
    ["1100", "1,1 ათ.", "1,1 ათასი"],
    ["2000", "2 ათ.", "2 ათასი"],
    ["2001", "2 ათ.", "2 ათასი"],
    ["2010", "2 ათ.", "2 ათასი"],
    ["2100", "2,1 ათ.", "2,1 ათასი"],
    ["3000", "3 ათ.", "3 ათასი"],
    ["3001", "3 ათ.", "3 ათასი"],
    ["3010", "3 ათ.", "3 ათასი"],
    ["3100", "3,1 ათ.", "3,1 ათასი"],
    ["4000", "4 ათ.", "4 ათასი"],
    ["4001", "4 ათ.", "4 ათასი"],
    ["4010", "4 ათ.", "4 ათასი"],
    ["4100", "4,1 ათ.", "4,1 ათასი"],
    ["5000", "5 ათ.", "5 ათასი"],
    ["5001", "5 ათ.", "5 ათასი"],
    ["5010", "5 ათ.", "5 ათასი"],
    ["5100", "5,1 ათ.", "5,1 ათასი"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 ათ.", "1 ათასი"],
    ["9999.12", "10 ათ.", "10 ათასი"],
    ["9999.99", "10 ათ.", "10 ათასი"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 ათ.", "-1 ათასი"],
    ["-9999.12", "-10 ათ.", "-10 ათასი"],
    ["-9999.99", "-10 ათ.", "-10 ათასი"],
  ],
  "kk": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 мың", "4,3 мың"],
    ["54321", "54 мың", "54 мың"],
    ["654321", "654 м.", "654 мың"],
    ["7654321", "7,7 млн", "7,7 миллион"],
    ["87654321", "88 млн", "88 миллион"],
    ["987654321", "988 млн", "988 миллион"],
    ["1087654321", "1,1 млрд", "1,1 миллиард"],
    ["11987654321", "12 млрд", "12 миллиард"],
    ["129987654321", "130 млрд", "130 миллиард"],
    ["1398987654321", "1,4 трлн", "1,4 триллион"],
    ["14987987654321", "15 трлн", "15 триллион"],
    ["159876987654321", "160 трлн", "160 триллион"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 мың", "10 мың"],
    ["99999", "100 м.", "100 мың"],
    ["999999", "1 млн", "1 миллион"],
    ["9999999", "10 млн", "10 миллион"],
    ["99999999", "100 млн", "100 миллион"],
    ["9994", "10 мың", "10 мың"],
    ["99944", "100 м.", "100 мың"],
    ["999444", "999 м.", "999 мың"],
    ["9994444", "10 млн", "10 миллион"],
    ["999444444", "999 млн", "999 миллион"],
    ["9994444444", "10 млрд", "10 миллиард"],
    ["1000000000000000", "1000 трлн", "1000 триллион"],
    ["10000000000000000", "10000 трлн", "10000 триллион"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 мың", "-1 мың"],
    ["-1001", "-1 мың", "-1 мың"],
    ["-1010", "-1 мың", "-1 мың"],
    ["-1100", "-1,1 мың", "-1,1 мың"],
    ["-2000", "-2 мың", "-2 мың"],
    ["-2001", "-2 мың", "-2 мың"],
    ["-2010", "-2 мың", "-2 мың"],
    ["-2100", "-2,1 мың", "-2,1 мың"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 мың", "-10 мың"],
    ["-99999", "-100 м.", "-100 мың"],
    ["-999999", "-1 млн", "-1 миллион"],
    ["-9999999", "-10 млн", "-10 миллион"],
    ["-9999999999999999", "-10000 трлн", "-10000 триллион"],
    ["1000", "1 мың", "1 мың"],
    ["1001", "1 мың", "1 мың"],
    ["1010", "1 мың", "1 мың"],
    ["1100", "1,1 мың", "1,1 мың"],
    ["2000", "2 мың", "2 мың"],
    ["2001", "2 мың", "2 мың"],
    ["2010", "2 мың", "2 мың"],
    ["2100", "2,1 мың", "2,1 мың"],
    ["3000", "3 мың", "3 мың"],
    ["3001", "3 мың", "3 мың"],
    ["3010", "3 мың", "3 мың"],
    ["3100", "3,1 мың", "3,1 мың"],
    ["4000", "4 мың", "4 мың"],
    ["4001", "4 мың", "4 мың"],
    ["4010", "4 мың", "4 мың"],
    ["4100", "4,1 мың", "4,1 мың"],
    ["5000", "5 мың", "5 мың"],
    ["5001", "5 мың", "5 мың"],
    ["5010", "5 мың", "5 мың"],
    ["5100", "5,1 мың", "5,1 мың"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 мың", "1 мың"],
    ["9999.12", "10 мың", "10 мың"],
    ["9999.99", "10 мың", "10 мың"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 мың", "-1 мың"],
    ["-9999.12", "-10 мың", "-10 мың"],
    ["-9999.99", "-10 мың", "-10 мың"],
  ],
  "km": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3ពាន់", "4.3 ពាន់"],
    ["54321", "54 ពាន់", "54 ពាន់"],
    ["654321", "654 ពាន់", "654ពាន់"],
    ["7654321", "7.7 លាន", "7.7 លាន"],
    ["87654321", "88 លាន", "88 លាន"],
    ["987654321", "988 លាន", "988 លាន"],
    ["1087654321", "1.1 ប៊ីលាន", "1.1 ប៊ីលាន"],
    ["11987654321", "12 ប៊ីលាន", "12 ប៊ីលាន"],
    ["129987654321", "130 ប៊ីលាន", "130 ប៊ីលាន"],
    ["1398987654321", "1.4 ទ្រីលាន", "1.4 ទ្រីលាន"],
    ["14987987654321", "15 ទ្រីលាន", "15 ទ្រីលាន"],
    ["159876987654321", "160 ទ្រីលាន", "160 ទ្រីលាន"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ពាន់", "10 ពាន់"],
    ["99999", "100 ពាន់", "100ពាន់"],
    ["999999", "1 លាន", "1 លាន"],
    ["9999999", "10 លាន", "10 លាន"],
    ["99999999", "100 លាន", "100 លាន"],
    ["9994", "10 ពាន់", "10 ពាន់"],
    ["99944", "100 ពាន់", "100ពាន់"],
    ["999444", "999 ពាន់", "999ពាន់"],
    ["9994444", "10 លាន", "10 លាន"],
    ["999444444", "999 លាន", "999 លាន"],
    ["9994444444", "10 ប៊ីលាន", "10 ប៊ីលាន"],
    ["1000000000000000", "1000 ទ្រីលាន", "1000 ទ្រីលាន"],
    ["10000000000000000", "10000 ទ្រីលាន", "10000 ទ្រីលាន"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1ពាន់", "-1 ពាន់"],
    ["-1001", "-1ពាន់", "-1 ពាន់"],
    ["-1010", "-1ពាន់", "-1 ពាន់"],
    ["-1100", "-1.1ពាន់", "-1.1 ពាន់"],
    ["-2000", "-2ពាន់", "-2 ពាន់"],
    ["-2001", "-2ពាន់", "-2 ពាន់"],
    ["-2010", "-2ពាន់", "-2 ពាន់"],
    ["-2100", "-2.1ពាន់", "-2.1 ពាន់"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 ពាន់", "-10 ពាន់"],
    ["-99999", "-100 ពាន់", "-100ពាន់"],
    ["-999999", "-1 លាន", "-1 លាន"],
    ["-9999999", "-10 លាន", "-10 លាន"],
    ["-9999999999999999", "-10000 ទ្រីលាន", "-10000 ទ្រីលាន"],
    ["1000", "1ពាន់", "1 ពាន់"],
    ["1001", "1ពាន់", "1 ពាន់"],
    ["1010", "1ពាន់", "1 ពាន់"],
    ["1100", "1.1ពាន់", "1.1 ពាន់"],
    ["2000", "2ពាន់", "2 ពាន់"],
    ["2001", "2ពាន់", "2 ពាន់"],
    ["2010", "2ពាន់", "2 ពាន់"],
    ["2100", "2.1ពាន់", "2.1 ពាន់"],
    ["3000", "3ពាន់", "3 ពាន់"],
    ["3001", "3ពាន់", "3 ពាន់"],
    ["3010", "3ពាន់", "3 ពាន់"],
    ["3100", "3.1ពាន់", "3.1 ពាន់"],
    ["4000", "4ពាន់", "4 ពាន់"],
    ["4001", "4ពាន់", "4 ពាន់"],
    ["4010", "4ពាន់", "4 ពាន់"],
    ["4100", "4.1ពាន់", "4.1 ពាន់"],
    ["5000", "5ពាន់", "5 ពាន់"],
    ["5001", "5ពាន់", "5 ពាន់"],
    ["5010", "5ពាន់", "5 ពាន់"],
    ["5100", "5.1ពាន់", "5.1 ពាន់"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1ពាន់", "1 ពាន់"],
    ["9999.12", "10 ពាន់", "10 ពាន់"],
    ["9999.99", "10 ពាន់", "10 ពាន់"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1ពាន់", "-1 ពាន់"],
    ["-9999.12", "-10 ពាន់", "-10 ពាន់"],
    ["-9999.99", "-10 ពាន់", "-10 ពាន់"],
  ],
  "kn": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3ಸಾ", "4.3 ಸಾವಿರ"],
    ["54321", "54ಸಾ", "54 ಸಾವಿರ"],
    ["654321", "654ಸಾ", "654 ಸಾವಿರ"],
    ["7654321", "7.7ಮಿ", "7.7 ಮಿಲಿಯನ್"],
    ["87654321", "88ಮಿ", "88 ಮಿಲಿಯನ್"],
    ["987654321", "988ಮಿ", "988 ಮಿಲಿಯನ್"],
    ["1087654321", "1.1ಬಿ", "1.1 ಬಿಲಿಯನ್"],
    ["11987654321", "12ಬಿ", "12 ಬಿಲಿಯನ್"],
    ["129987654321", "130ಬಿ", "130 ಬಿಲಿಯನ್"],
    ["1398987654321", "1.4ಟ್ರಿ", "1.4 ಟ್ರಿಲಿಯನ್‌"],
    ["14987987654321", "15ಟ್ರಿ", "15 ಟ್ರಿಲಿಯನ್‌"],
    ["159876987654321", "160ಟ್ರಿ", "160 ಟ್ರಿಲಿಯನ್‌"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10ಸಾ", "10 ಸಾವಿರ"],
    ["99999", "100ಸಾ", "100 ಸಾವಿರ"],
    ["999999", "1ಮಿ", "1 ಮಿಲಿಯನ್"],
    ["9999999", "10ಮಿ", "10 ಮಿಲಿಯನ್"],
    ["99999999", "100ಮಿ", "100 ಮಿಲಿಯನ್"],
    ["9994", "10ಸಾ", "10 ಸಾವಿರ"],
    ["99944", "100ಸಾ", "100 ಸಾವಿರ"],
    ["999444", "999ಸಾ", "999 ಸಾವಿರ"],
    ["9994444", "10ಮಿ", "10 ಮಿಲಿಯನ್"],
    ["999444444", "999ಮಿ", "999 ಮಿಲಿಯನ್"],
    ["9994444444", "10ಬಿ", "10 ಬಿಲಿಯನ್"],
    ["1000000000000000", "1000ಟ್ರಿ", "1000 ಟ್ರಿಲಿಯನ್‌"],
    ["10000000000000000", "10000ಟ್ರಿ", "10000 ಟ್ರಿಲಿಯನ್‌"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1ಸಾ", "-1 ಸಾವಿರ"],
    ["-1001", "-1ಸಾ", "-1 ಸಾವಿರ"],
    ["-1010", "-1ಸಾ", "-1 ಸಾವಿರ"],
    ["-1100", "-1.1ಸಾ", "-1.1 ಸಾವಿರ"],
    ["-2000", "-2ಸಾ", "-2 ಸಾವಿರ"],
    ["-2001", "-2ಸಾ", "-2 ಸಾವಿರ"],
    ["-2010", "-2ಸಾ", "-2 ಸಾವಿರ"],
    ["-2100", "-2.1ಸಾ", "-2.1 ಸಾವಿರ"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10ಸಾ", "-10 ಸಾವಿರ"],
    ["-99999", "-100ಸಾ", "-100 ಸಾವಿರ"],
    ["-999999", "-1ಮಿ", "-1 ಮಿಲಿಯನ್"],
    ["-9999999", "-10ಮಿ", "-10 ಮಿಲಿಯನ್"],
    ["-9999999999999999", "-10000ಟ್ರಿ", "-10000 ಟ್ರಿಲಿಯನ್‌"],
    ["1000", "1ಸಾ", "1 ಸಾವಿರ"],
    ["1001", "1ಸಾ", "1 ಸಾವಿರ"],
    ["1010", "1ಸಾ", "1 ಸಾವಿರ"],
    ["1100", "1.1ಸಾ", "1.1 ಸಾವಿರ"],
    ["2000", "2ಸಾ", "2 ಸಾವಿರ"],
    ["2001", "2ಸಾ", "2 ಸಾವಿರ"],
    ["2010", "2ಸಾ", "2 ಸಾವಿರ"],
    ["2100", "2.1ಸಾ", "2.1 ಸಾವಿರ"],
    ["3000", "3ಸಾ", "3 ಸಾವಿರ"],
    ["3001", "3ಸಾ", "3 ಸಾವಿರ"],
    ["3010", "3ಸಾ", "3 ಸಾವಿರ"],
    ["3100", "3.1ಸಾ", "3.1 ಸಾವಿರ"],
    ["4000", "4ಸಾ", "4 ಸಾವಿರ"],
    ["4001", "4ಸಾ", "4 ಸಾವಿರ"],
    ["4010", "4ಸಾ", "4 ಸಾವಿರ"],
    ["4100", "4.1ಸಾ", "4.1 ಸಾವಿರ"],
    ["5000", "5ಸಾ", "5 ಸಾವಿರ"],
    ["5001", "5ಸಾ", "5 ಸಾವಿರ"],
    ["5010", "5ಸಾ", "5 ಸಾವಿರ"],
    ["5100", "5.1ಸಾ", "5.1 ಸಾವಿರ"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1ಸಾ", "1 ಸಾವಿರ"],
    ["9999.12", "10ಸಾ", "10 ಸಾವಿರ"],
    ["9999.99", "10ಸಾ", "10 ಸಾವಿರ"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1ಸಾ", "-1 ಸಾವಿರ"],
    ["-9999.12", "-10ಸಾ", "-10 ಸಾವಿರ"],
    ["-9999.99", "-10ಸಾ", "-10 ಸಾವಿರ"],
  ],
  "ko": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3천", "4.3천"],
    ["54321", "5.4만", "5.4만"],
    ["654321", "65만", "65만"],
    ["7654321", "765만", "765만"],
    ["87654321", "8765만", "8765만"],
    ["987654321", "9.9억", "9.9억"],
    ["1087654321", "11억", "11억"],
    ["11987654321", "120억", "120억"],
    ["129987654321", "1300억", "1300억"],
    ["1398987654321", "1.4조", "1.4조"],
    ["14987987654321", "15조", "15조"],
    ["159876987654321", "160조", "160조"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "1만", "1만"],
    ["99999", "10만", "10만"],
    ["999999", "100만", "100만"],
    ["9999999", "1000만", "1000만"],
    ["99999999", "1억", "1억"],
    ["9994", "1만", "1만"],
    ["99944", "10만", "10만"],
    ["999444", "100만", "100만"],
    ["9994444", "999만", "999만"],
    ["999444444", "10억", "10억"],
    ["9994444444", "100억", "100억"],
    ["1000000000000000", "1000조", "1000조"],
    ["10000000000000000", "10000조", "10000조"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1천", "-1천"],
    ["-1001", "-1천", "-1천"],
    ["-1010", "-1천", "-1천"],
    ["-1100", "-1.1천", "-1.1천"],
    ["-2000", "-2천", "-2천"],
    ["-2001", "-2천", "-2천"],
    ["-2010", "-2천", "-2천"],
    ["-2100", "-2.1천", "-2.1천"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-1만", "-1만"],
    ["-99999", "-10만", "-10만"],
    ["-999999", "-100만", "-100만"],
    ["-9999999", "-1000만", "-1000만"],
    ["-9999999999999999", "-10000조", "-10000조"],
    ["1000", "1천", "1천"],
    ["1001", "1천", "1천"],
    ["1010", "1천", "1천"],
    ["1100", "1.1천", "1.1천"],
    ["2000", "2천", "2천"],
    ["2001", "2천", "2천"],
    ["2010", "2천", "2천"],
    ["2100", "2.1천", "2.1천"],
    ["3000", "3천", "3천"],
    ["3001", "3천", "3천"],
    ["3010", "3천", "3천"],
    ["3100", "3.1천", "3.1천"],
    ["4000", "4천", "4천"],
    ["4001", "4천", "4천"],
    ["4010", "4천", "4천"],
    ["4100", "4.1천", "4.1천"],
    ["5000", "5천", "5천"],
    ["5001", "5천", "5천"],
    ["5010", "5천", "5천"],
    ["5100", "5.1천", "5.1천"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1천", "1천"],
    ["9999.12", "1만", "1만"],
    ["9999.99", "1만", "1만"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1천", "-1천"],
    ["-9999.12", "-1만", "-1만"],
    ["-9999.99", "-1만", "-1만"],
  ],
  "ky": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 миң", "4,3 миң"],
    ["54321", "54 миң", "54 миң"],
    ["654321", "654 миң", "654 миң"],
    ["7654321", "7,7 млн", "7,7 миллион"],
    ["87654321", "88 млн", "88 миллион"],
    ["987654321", "988 млн", "988 миллион"],
    ["1087654321", "1,1 млд", "1,1 миллиард"],
    ["11987654321", "12 млд", "12 миллиард"],
    ["129987654321", "130 млд", "130 миллиард"],
    ["1398987654321", "1,4 трлн", "1,4 триллион"],
    ["14987987654321", "15 трлн", "15 триллион"],
    ["159876987654321", "160 трлн", "160 триллион"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 миң", "10 миң"],
    ["99999", "100 миң", "100 миң"],
    ["999999", "1 млн", "1 миллион"],
    ["9999999", "10 млн", "10 миллион"],
    ["99999999", "100 млн", "100 миллион"],
    ["9994", "10 миң", "10 миң"],
    ["99944", "100 миң", "100 миң"],
    ["999444", "999 миң", "999 миң"],
    ["9994444", "10 млн", "10 миллион"],
    ["999444444", "999 млн", "999 миллион"],
    ["9994444444", "10 млд", "10 миллиард"],
    ["1000000000000000", "1000 трлн", "1000 триллион"],
    ["10000000000000000", "10000 трлн", "10000 триллион"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 миң", "-1 миң"],
    ["-1001", "-1 миң", "-1 миң"],
    ["-1010", "-1 миң", "-1 миң"],
    ["-1100", "-1,1 миң", "-1,1 миң"],
    ["-2000", "-2 миң", "-2 миң"],
    ["-2001", "-2 миң", "-2 миң"],
    ["-2010", "-2 миң", "-2 миң"],
    ["-2100", "-2,1 миң", "-2,1 миң"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 миң", "-10 миң"],
    ["-99999", "-100 миң", "-100 миң"],
    ["-999999", "-1 млн", "-1 миллион"],
    ["-9999999", "-10 млн", "-10 миллион"],
    ["-9999999999999999", "-10000 трлн", "-10000 триллион"],
    ["1000", "1 миң", "1 миң"],
    ["1001", "1 миң", "1 миң"],
    ["1010", "1 миң", "1 миң"],
    ["1100", "1,1 миң", "1,1 миң"],
    ["2000", "2 миң", "2 миң"],
    ["2001", "2 миң", "2 миң"],
    ["2010", "2 миң", "2 миң"],
    ["2100", "2,1 миң", "2,1 миң"],
    ["3000", "3 миң", "3 миң"],
    ["3001", "3 миң", "3 миң"],
    ["3010", "3 миң", "3 миң"],
    ["3100", "3,1 миң", "3,1 миң"],
    ["4000", "4 миң", "4 миң"],
    ["4001", "4 миң", "4 миң"],
    ["4010", "4 миң", "4 миң"],
    ["4100", "4,1 миң", "4,1 миң"],
    ["5000", "5 миң", "5 миң"],
    ["5001", "5 миң", "5 миң"],
    ["5010", "5 миң", "5 миң"],
    ["5100", "5,1 миң", "5,1 миң"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 миң", "1 миң"],
    ["9999.12", "10 миң", "10 миң"],
    ["9999.99", "10 миң", "10 миң"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 миң", "-1 миң"],
    ["-9999.12", "-10 миң", "-10 миң"],
    ["-9999.99", "-10 миң", "-10 миң"],
  ],
  "ln": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3K", "4,3K"],
    ["54321", "54K", "54K"],
    ["654321", "654K", "654K"],
    ["7654321", "7,7M", "7,7M"],
    ["87654321", "88M", "88M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1,1G", "1,1G"],
    ["11987654321", "12G", "12G"],
    ["129987654321", "130G", "130G"],
    ["1398987654321", "1,4T", "1,4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "10K", "10K"],
    ["99944", "100K", "100K"],
    ["999444", "999K", "999K"],
    ["9994444", "10M", "10M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "10G", "10G"],
    ["1000000000000000", "1000T", "1000T"],
    ["10000000000000000", "10000T", "10000T"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1K"],
    ["-1001", "-1K", "-1K"],
    ["-1010", "-1K", "-1K"],
    ["-1100", "-1,1K", "-1,1K"],
    ["-2000", "-2K", "-2K"],
    ["-2001", "-2K", "-2K"],
    ["-2010", "-2K", "-2K"],
    ["-2100", "-2,1K", "-2,1K"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10K"],
    ["-99999", "-100K", "-100K"],
    ["-999999", "-1M", "-1M"],
    ["-9999999", "-10M", "-10M"],
    ["-9999999999999999", "-10000T", "-10000T"],
    ["1000", "1K", "1K"],
    ["1001", "1K", "1K"],
    ["1010", "1K", "1K"],
    ["1100", "1,1K", "1,1K"],
    ["2000", "2K", "2K"],
    ["2001", "2K", "2K"],
    ["2010", "2K", "2K"],
    ["2100", "2,1K", "2,1K"],
    ["3000", "3K", "3K"],
    ["3001", "3K", "3K"],
    ["3010", "3K", "3K"],
    ["3100", "3,1K", "3,1K"],
    ["4000", "4K", "4K"],
    ["4001", "4K", "4K"],
    ["4010", "4K", "4K"],
    ["4100", "4,1K", "4,1K"],
    ["5000", "5K", "5K"],
    ["5001", "5K", "5K"],
    ["5010", "5K", "5K"],
    ["5100", "5,1K", "5,1K"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1K"],
    ["9999.12", "10K", "10K"],
    ["9999.99", "10K", "10K"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1K"],
    ["-9999.12", "-10K", "-10K"],
    ["-9999.99", "-10K", "-10K"],
  ],
  "lo": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 ພັນ", "4,3 ພັນ"],
    ["54321", "54 ພັນ", "54 ພັນ"],
    ["654321", "654 ກີບ", "6,5 ແສນ"],
    ["7654321", "7,7 ລ້ານ", "7,7 ລ້ານ"],
    ["87654321", "88 ລ້ານ", "88 ລ້ານ"],
    ["987654321", "988 ລ້ານ", "988 ລ້ານ"],
    ["1087654321", "1,1 ຕື້", "1,1 ຕື້"],
    ["11987654321", "12 ຕື້", "12 ຕື້"],
    ["129987654321", "130 ຕື້", "130 ຕື້"],
    ["1398987654321", "1,4 ລ້ານລ້ານ", "1,4 ລ້ານລ້ານ"],
    ["14987987654321", "15ລລ", "15 ລ້ານລ້ານ"],
    ["159876987654321", "160ລລ", "160 ລ້ານລ້ານ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ພັນ", "10 ພັນ"],
    ["99999", "100 ກີບ", "1 ແສນ"],
    ["999999", "1 ລ້ານ", "1 ລ້ານ"],
    ["9999999", "10 ລ້ານ", "10 ລ້ານ"],
    ["99999999", "100 ລ້ານ", "100 ລ້ານ"],
    ["9994", "10 ພັນ", "10 ພັນ"],
    ["99944", "100 ກີບ", "1 ແສນ"],
    ["999444", "999 ກີບ", "1 ລ້ານ"],
    ["9994444", "10 ລ້ານ", "10 ລ້ານ"],
    ["999444444", "999 ລ້ານ", "999 ລ້ານ"],
    ["9994444444", "10 ຕື້", "10 ຕື້"],
    ["1000000000000000", "1000ລລ", "1000 ລ້ານລ້ານ"],
    ["10000000000000000", "10000ລລ", "10000 ລ້ານລ້ານ"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 ພັນ", "-1 ພັນ"],
    ["-1001", "-1 ພັນ", "-1 ພັນ"],
    ["-1010", "-1 ພັນ", "-1 ພັນ"],
    ["-1100", "-1,1 ພັນ", "-1,1 ພັນ"],
    ["-2000", "-2 ພັນ", "-2 ພັນ"],
    ["-2001", "-2 ພັນ", "-2 ພັນ"],
    ["-2010", "-2 ພັນ", "-2 ພັນ"],
    ["-2100", "-2,1 ພັນ", "-2,1 ພັນ"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 ພັນ", "-10 ພັນ"],
    ["-99999", "-100 ກີບ", "-1 ແສນ"],
    ["-999999", "-1 ລ້ານ", "-1 ລ້ານ"],
    ["-9999999", "-10 ລ້ານ", "-10 ລ້ານ"],
    ["-9999999999999999", "-10000ລລ", "-10000 ລ້ານລ້ານ"],
    ["1000", "1 ພັນ", "1 ພັນ"],
    ["1001", "1 ພັນ", "1 ພັນ"],
    ["1010", "1 ພັນ", "1 ພັນ"],
    ["1100", "1,1 ພັນ", "1,1 ພັນ"],
    ["2000", "2 ພັນ", "2 ພັນ"],
    ["2001", "2 ພັນ", "2 ພັນ"],
    ["2010", "2 ພັນ", "2 ພັນ"],
    ["2100", "2,1 ພັນ", "2,1 ພັນ"],
    ["3000", "3 ພັນ", "3 ພັນ"],
    ["3001", "3 ພັນ", "3 ພັນ"],
    ["3010", "3 ພັນ", "3 ພັນ"],
    ["3100", "3,1 ພັນ", "3,1 ພັນ"],
    ["4000", "4 ພັນ", "4 ພັນ"],
    ["4001", "4 ພັນ", "4 ພັນ"],
    ["4010", "4 ພັນ", "4 ພັນ"],
    ["4100", "4,1 ພັນ", "4,1 ພັນ"],
    ["5000", "5 ພັນ", "5 ພັນ"],
    ["5001", "5 ພັນ", "5 ພັນ"],
    ["5010", "5 ພັນ", "5 ພັນ"],
    ["5100", "5,1 ພັນ", "5,1 ພັນ"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 ພັນ", "1 ພັນ"],
    ["9999.12", "10 ພັນ", "10 ພັນ"],
    ["9999.99", "10 ພັນ", "10 ພັນ"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 ພັນ", "-1 ພັນ"],
    ["-9999.12", "-10 ພັນ", "-10 ພັນ"],
    ["-9999.99", "-10 ພັນ", "-10 ພັນ"],
  ],
  "lt": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tūkst.", "4,3 tūkstančio"],
    ["54321", "54 tūkst.", "54 tūkstančiai"],
    ["654321", "654 tūkst.", "654 tūkstančiai"],
    ["7654321", "7,7 mln.", "7,7 milijono"],
    ["87654321", "88 mln.", "88 milijonai"],
    ["987654321", "988 mln.", "988 milijonai"],
    ["1087654321", "1,1 mlrd.", "1,1 milijardo"],
    ["11987654321", "12 mlrd.", "12 milijardų"],
    ["129987654321", "130 mlrd.", "130 milijardų"],
    ["1398987654321", "1,4 trln.", "1,4 trilijono"],
    ["14987987654321", "15 trln.", "15 trilijonų"],
    ["159876987654321", "160 trln.", "160 trilijonų"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tūkst.", "10 tūkstančių"],
    ["99999", "100 tūkst.", "100 tūkstančių"],
    ["999999", "1 mln.", "1 milijonas"],
    ["9999999", "10 mln.", "10 milijonų"],
    ["99999999", "100 mln.", "100 milijonų"],
    ["9994", "10 tūkst.", "10 tūkstančių"],
    ["99944", "100 tūkst.", "100 tūkstančių"],
    ["999444", "999 tūkst.", "999 tūkstančiai"],
    ["9994444", "10 mln.", "10 milijonų"],
    ["999444444", "999 mln.", "999 milijonai"],
    ["9994444444", "10 mlrd.", "10 milijardų"],
    ["1000000000000000", "1000 trln.", "1000 trilijonų"],
    ["10000000000000000", "10000 trln.", "10000 trilijonų"],
    ["0", "0", "0"],
    ["-1", "−1", "−1"],
    ["-2", "−2", "−2"],
    ["-3", "−3", "−3"],
    ["-1000", "−1 tūkst.", "−1 tūkstantis"],
    ["-1001", "−1 tūkst.", "−1 tūkstantis"],
    ["-1010", "−1 tūkst.", "−1 tūkstantis"],
    ["-1100", "−1,1 tūkst.", "−1,1 tūkstančio"],
    ["-2000", "−2 tūkst.", "−2 tūkstančiai"],
    ["-2001", "−2 tūkst.", "−2 tūkstančiai"],
    ["-2010", "−2 tūkst.", "−2 tūkstančiai"],
    ["-2100", "−2,1 tūkst.", "−2,1 tūkstančio"],
    ["-9", "−9", "−9"],
    ["-99", "−99", "−99"],
    ["-999", "−999", "−999"],
    ["-9999", "−10 tūkst.", "−10 tūkstančių"],
    ["-99999", "−100 tūkst.", "−100 tūkstančių"],
    ["-999999", "−1 mln.", "−1 milijonas"],
    ["-9999999", "−10 mln.", "−10 milijonų"],
    ["-9999999999999999", "−10000 trln.", "−10000 trilijonų"],
    ["1000", "1 tūkst.", "1 tūkstantis"],
    ["1001", "1 tūkst.", "1 tūkstantis"],
    ["1010", "1 tūkst.", "1 tūkstantis"],
    ["1100", "1,1 tūkst.", "1,1 tūkstančio"],
    ["2000", "2 tūkst.", "2 tūkstančiai"],
    ["2001", "2 tūkst.", "2 tūkstančiai"],
    ["2010", "2 tūkst.", "2 tūkstančiai"],
    ["2100", "2,1 tūkst.", "2,1 tūkstančio"],
    ["3000", "3 tūkst.", "3 tūkstančiai"],
    ["3001", "3 tūkst.", "3 tūkstančiai"],
    ["3010", "3 tūkst.", "3 tūkstančiai"],
    ["3100", "3,1 tūkst.", "3,1 tūkstančio"],
    ["4000", "4 tūkst.", "4 tūkstančiai"],
    ["4001", "4 tūkst.", "4 tūkstančiai"],
    ["4010", "4 tūkst.", "4 tūkstančiai"],
    ["4100", "4,1 tūkst.", "4,1 tūkstančio"],
    ["5000", "5 tūkst.", "5 tūkstančiai"],
    ["5001", "5 tūkst.", "5 tūkstančiai"],
    ["5010", "5 tūkst.", "5 tūkstančiai"],
    ["5100", "5,1 tūkst.", "5,1 tūkstančio"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 tūkst.", "1 tūkstantis"],
    ["9999.12", "10 tūkst.", "10 tūkstančių"],
    ["9999.99", "10 tūkst.", "10 tūkstančių"],
    ["-0.12", "−0,12", "−0,12"],
    ["-0.99", "−0,99", "−0,99"],
    ["-9.12", "−9,1", "−9,1"],
    ["-9.99", "−10", "−10"],
    ["-999.12", "−999", "−999"],
    ["-999.99", "−1 tūkst.", "−1 tūkstantis"],
    ["-9999.12", "−10 tūkst.", "−10 tūkstančių"],
    ["-9999.99", "−10 tūkst.", "−10 tūkstančių"],
  ],
  "lv": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tūkst.", "4,3 tūkstoši"],
    ["54321", "54 tūkst.", "54 tūkstoši"],
    ["654321", "654 tūkst.", "654 tūkstoši"],
    ["7654321", "7,7 milj.", "7,7 miljoni"],
    ["87654321", "88 milj.", "88 miljoni"],
    ["987654321", "988 milj.", "988 miljoni"],
    ["1087654321", "1,1 mljrd.", "1,1 miljards"],
    ["11987654321", "12 mljrd.", "12 miljardi"],
    ["129987654321", "130 mljrd.", "130 miljardi"],
    ["1398987654321", "1,4 trilj.", "1,4 triljoni"],
    ["14987987654321", "15 trilj.", "15 triljoni"],
    ["159876987654321", "160 trilj.", "160 triljoni"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tūkst.", "10 tūkstoši"],
    ["99999", "100 tūkst.", "100 tūkstoši"],
    ["999999", "1 milj.", "1 miljons"],
    ["9999999", "10 milj.", "10 miljoni"],
    ["99999999", "100 milj.", "100 miljoni"],
    ["9994", "10 tūkst.", "10 tūkstoši"],
    ["99944", "100 tūkst.", "100 tūkstoši"],
    ["999444", "999 tūkst.", "999 tūkstoši"],
    ["9994444", "10 milj.", "10 miljoni"],
    ["999444444", "999 milj.", "999 miljoni"],
    ["9994444444", "10 mljrd.", "10 miljardi"],
    ["1000000000000000", "1000 trilj.", "1000 triljoni"],
    ["10000000000000000", "10000 trilj.", "10000 triljoni"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 tūkst.", "-1 tūkstotis"],
    ["-1001", "-1 tūkst.", "-1 tūkstotis"],
    ["-1010", "-1 tūkst.", "-1 tūkstotis"],
    ["-1100", "-1,1 tūkst.", "-1,1 tūkstotis"],
    ["-2000", "-2 tūkst.", "-2 tūkstoši"],
    ["-2001", "-2 tūkst.", "-2 tūkstoši"],
    ["-2010", "-2 tūkst.", "-2 tūkstoši"],
    ["-2100", "-2,1 tūkst.", "-2,1 tūkstotis"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 tūkst.", "-10 tūkstoši"],
    ["-99999", "-100 tūkst.", "-100 tūkstoši"],
    ["-999999", "-1 milj.", "-1 miljons"],
    ["-9999999", "-10 milj.", "-10 miljoni"],
    ["-9999999999999999", "-10000 trilj.", "-10000 triljoni"],
    ["1000", "1 tūkst.", "1 tūkstotis"],
    ["1001", "1 tūkst.", "1 tūkstotis"],
    ["1010", "1 tūkst.", "1 tūkstotis"],
    ["1100", "1,1 tūkst.", "1,1 tūkstotis"],
    ["2000", "2 tūkst.", "2 tūkstoši"],
    ["2001", "2 tūkst.", "2 tūkstoši"],
    ["2010", "2 tūkst.", "2 tūkstoši"],
    ["2100", "2,1 tūkst.", "2,1 tūkstotis"],
    ["3000", "3 tūkst.", "3 tūkstoši"],
    ["3001", "3 tūkst.", "3 tūkstoši"],
    ["3010", "3 tūkst.", "3 tūkstoši"],
    ["3100", "3,1 tūkst.", "3,1 tūkstotis"],
    ["4000", "4 tūkst.", "4 tūkstoši"],
    ["4001", "4 tūkst.", "4 tūkstoši"],
    ["4010", "4 tūkst.", "4 tūkstoši"],
    ["4100", "4,1 tūkst.", "4,1 tūkstotis"],
    ["5000", "5 tūkst.", "5 tūkstoši"],
    ["5001", "5 tūkst.", "5 tūkstoši"],
    ["5010", "5 tūkst.", "5 tūkstoši"],
    ["5100", "5,1 tūkst.", "5,1 tūkstotis"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 tūkst.", "1 tūkstotis"],
    ["9999.12", "10 tūkst.", "10 tūkstoši"],
    ["9999.99", "10 tūkst.", "10 tūkstoši"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 tūkst.", "-1 tūkstotis"],
    ["-9999.12", "-10 tūkst.", "-10 tūkstoši"],
    ["-9999.99", "-10 tūkst.", "-10 tūkstoši"],
  ],
  "mg": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3K"],
    ["54321", "54K", "54K"],
    ["654321", "654K", "654K"],
    ["7654321", "7.7M", "7.7M"],
    ["87654321", "88M", "88M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1.1G", "1.1G"],
    ["11987654321", "12G", "12G"],
    ["129987654321", "130G", "130G"],
    ["1398987654321", "1.4T", "1.4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "10K", "10K"],
    ["99944", "100K", "100K"],
    ["999444", "999K", "999K"],
    ["9994444", "10M", "10M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "10G", "10G"],
    ["1000000000000000", "1000T", "1000T"],
    ["10000000000000000", "10000T", "10000T"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1K"],
    ["-1001", "-1K", "-1K"],
    ["-1010", "-1K", "-1K"],
    ["-1100", "-1.1K", "-1.1K"],
    ["-2000", "-2K", "-2K"],
    ["-2001", "-2K", "-2K"],
    ["-2010", "-2K", "-2K"],
    ["-2100", "-2.1K", "-2.1K"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10K"],
    ["-99999", "-100K", "-100K"],
    ["-999999", "-1M", "-1M"],
    ["-9999999", "-10M", "-10M"],
    ["-9999999999999999", "-10000T", "-10000T"],
    ["1000", "1K", "1K"],
    ["1001", "1K", "1K"],
    ["1010", "1K", "1K"],
    ["1100", "1.1K", "1.1K"],
    ["2000", "2K", "2K"],
    ["2001", "2K", "2K"],
    ["2010", "2K", "2K"],
    ["2100", "2.1K", "2.1K"],
    ["3000", "3K", "3K"],
    ["3001", "3K", "3K"],
    ["3010", "3K", "3K"],
    ["3100", "3.1K", "3.1K"],
    ["4000", "4K", "4K"],
    ["4001", "4K", "4K"],
    ["4010", "4K", "4K"],
    ["4100", "4.1K", "4.1K"],
    ["5000", "5K", "5K"],
    ["5001", "5K", "5K"],
    ["5010", "5K", "5K"],
    ["5100", "5.1K", "5.1K"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1K"],
    ["9999.12", "10K", "10K"],
    ["9999.99", "10K", "10K"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1K"],
    ["-9999.12", "-10K", "-10K"],
    ["-9999.99", "-10K", "-10K"],
  ],
  "mk": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 илј.", "4,3 илјади"],
    ["54321", "54 илј.", "54 илјади"],
    ["654321", "654 илј.", "654 илјади"],
    ["7654321", "7,7 мил.", "7,7 милиони"],
    ["87654321", "88 мил.", "88 милиони"],
    ["987654321", "988 М", "988 милиони"],
    ["1087654321", "1,1 милј.", "1,1 милијарда"],
    ["11987654321", "12 милј.", "12 милијарди"],
    ["129987654321", "130 ми.", "130 милијарди"],
    ["1398987654321", "1,4 бил.", "1,4 билиони"],
    ["14987987654321", "15 бил.", "15 билиони"],
    ["159876987654321", "160 бил.", "160 билиони"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 илј.", "10 илјади"],
    ["99999", "100 илј.", "100 илјади"],
    ["999999", "1 мил.", "1 милион"],
    ["9999999", "10 мил.", "10 милиони"],
    ["99999999", "100 М", "100 милиони"],
    ["9994", "10 илј.", "10 илјади"],
    ["99944", "100 илј.", "100 илјади"],
    ["999444", "999 илј.", "999 илјади"],
    ["9994444", "10 мил.", "10 милиони"],
    ["999444444", "999 М", "999 милиони"],
    ["9994444444", "10 милј.", "10 милијарди"],
    ["1000000000000000", "1000 бил.", "1000 билиони"],
    ["10000000000000000", "10000 бил.", "10000 билиони"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 илј.", "-1 илјада"],
    ["-1001", "-1 илј.", "-1 илјада"],
    ["-1010", "-1 илј.", "-1 илјада"],
    ["-1100", "-1,1 илј.", "-1,1 илјада"],
    ["-2000", "-2 илј.", "-2 илјади"],
    ["-2001", "-2 илј.", "-2 илјади"],
    ["-2010", "-2 илј.", "-2 илјади"],
    ["-2100", "-2,1 илј.", "-2,1 илјада"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 илј.", "-10 илјади"],
    ["-99999", "-100 илј.", "-100 илјади"],
    ["-999999", "-1 мил.", "-1 милион"],
    ["-9999999", "-10 мил.", "-10 милиони"],
    ["-9999999999999999", "-10000 бил.", "-10000 билиони"],
    ["1000", "1 илј.", "1 илјада"],
    ["1001", "1 илј.", "1 илјада"],
    ["1010", "1 илј.", "1 илјада"],
    ["1100", "1,1 илј.", "1,1 илјада"],
    ["2000", "2 илј.", "2 илјади"],
    ["2001", "2 илј.", "2 илјади"],
    ["2010", "2 илј.", "2 илјади"],
    ["2100", "2,1 илј.", "2,1 илјада"],
    ["3000", "3 илј.", "3 илјади"],
    ["3001", "3 илј.", "3 илјади"],
    ["3010", "3 илј.", "3 илјади"],
    ["3100", "3,1 илј.", "3,1 илјада"],
    ["4000", "4 илј.", "4 илјади"],
    ["4001", "4 илј.", "4 илјади"],
    ["4010", "4 илј.", "4 илјади"],
    ["4100", "4,1 илј.", "4,1 илјада"],
    ["5000", "5 илј.", "5 илјади"],
    ["5001", "5 илј.", "5 илјади"],
    ["5010", "5 илј.", "5 илјади"],
    ["5100", "5,1 илј.", "5,1 илјада"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 илј.", "1 илјада"],
    ["9999.12", "10 илј.", "10 илјади"],
    ["9999.99", "10 илј.", "10 илјади"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 илј.", "-1 илјада"],
    ["-9999.12", "-10 илј.", "-10 илјади"],
    ["-9999.99", "-10 илј.", "-10 илјади"],
  ],
  "ml": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 ആയിരം"],
    ["54321", "54K", "54 ആയിരം"],
    ["654321", "654K", "654 ആയിരം"],
    ["7654321", "7.7M", "7.7 ദശലക്ഷം"],
    ["87654321", "88M", "88 ദശലക്ഷം"],
    ["987654321", "988M", "988 ദശലക്ഷം"],
    ["1087654321", "1.1B", "1.1 ലക്ഷം കോടി"],
    ["11987654321", "12B", "12 ലക്ഷം കോടി"],
    ["129987654321", "130B", "130 ലക്ഷം കോടി"],
    ["1398987654321", "1.4T", "1.4 ട്രില്യൺ"],
    ["14987987654321", "15T", "15 ട്രില്യൺ"],
    ["159876987654321", "160T", "160 ട്രില്യൺ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 ആയിരം"],
    ["99999", "100K", "100 ആയിരം"],
    ["999999", "1M", "1 ദശലക്ഷം"],
    ["9999999", "10M", "10 ദശലക്ഷം"],
    ["99999999", "100M", "100 ദശലക്ഷം"],
    ["9994", "10K", "10 ആയിരം"],
    ["99944", "100K", "100 ആയിരം"],
    ["999444", "999K", "999 ആയിരം"],
    ["9994444", "10M", "10 ദശലക്ഷം"],
    ["999444444", "999M", "999 ദശലക്ഷം"],
    ["9994444444", "10B", "10 ലക്ഷം കോടി"],
    ["1000000000000000", "1000T", "1000 ട്രില്യൺ"],
    ["10000000000000000", "10000T", "10000 ട്രില്യൺ"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 ആയിരം"],
    ["-1001", "-1K", "-1 ആയിരം"],
    ["-1010", "-1K", "-1 ആയിരം"],
    ["-1100", "-1.1K", "-1.1 ആയിരം"],
    ["-2000", "-2K", "-2 ആയിരം"],
    ["-2001", "-2K", "-2 ആയിരം"],
    ["-2010", "-2K", "-2 ആയിരം"],
    ["-2100", "-2.1K", "-2.1 ആയിരം"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 ആയിരം"],
    ["-99999", "-100K", "-100 ആയിരം"],
    ["-999999", "-1M", "-1 ദശലക്ഷം"],
    ["-9999999", "-10M", "-10 ദശലക്ഷം"],
    ["-9999999999999999", "-10000T", "-10000 ട്രില്യൺ"],
    ["1000", "1K", "1 ആയിരം"],
    ["1001", "1K", "1 ആയിരം"],
    ["1010", "1K", "1 ആയിരം"],
    ["1100", "1.1K", "1.1 ആയിരം"],
    ["2000", "2K", "2 ആയിരം"],
    ["2001", "2K", "2 ആയിരം"],
    ["2010", "2K", "2 ആയിരം"],
    ["2100", "2.1K", "2.1 ആയിരം"],
    ["3000", "3K", "3 ആയിരം"],
    ["3001", "3K", "3 ആയിരം"],
    ["3010", "3K", "3 ആയിരം"],
    ["3100", "3.1K", "3.1 ആയിരം"],
    ["4000", "4K", "4 ആയിരം"],
    ["4001", "4K", "4 ആയിരം"],
    ["4010", "4K", "4 ആയിരം"],
    ["4100", "4.1K", "4.1 ആയിരം"],
    ["5000", "5K", "5 ആയിരം"],
    ["5001", "5K", "5 ആയിരം"],
    ["5010", "5K", "5 ആയിരം"],
    ["5100", "5.1K", "5.1 ആയിരം"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 ആയിരം"],
    ["9999.12", "10K", "10 ആയിരം"],
    ["9999.99", "10K", "10 ആയിരം"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 ആയിരം"],
    ["-9999.12", "-10K", "-10 ആയിരം"],
    ["-9999.99", "-10K", "-10 ആയിരം"],
  ],
  "mn": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 мянга", "4.3 мянга"],
    ["54321", "54 мянга", "54 мянга"],
    ["654321", "654 мянга", "654 мянга"],
    ["7654321", "7.7 сая", "7.7 сая"],
    ["87654321", "88 сая", "88 сая"],
    ["987654321", "988 сая", "988 сая"],
    ["1087654321", "1.1 тэрбум", "1.1 тэрбум"],
    ["11987654321", "12 тэрбум", "12 тэрбум"],
    ["129987654321", "130Т", "130 тэрбум"],
    ["1398987654321", "1.4ИН", "1.4 их наяд"],
    ["14987987654321", "15ИН", "15 их наяд"],
    ["159876987654321", "160ИН", "160 их наяд"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 мянга", "10 мянга"],
    ["99999", "100 мянга", "100 мянга"],
    ["999999", "1 сая", "1 сая"],
    ["9999999", "10 сая", "10 сая"],
    ["99999999", "100 сая", "100 сая"],
    ["9994", "10 мянга", "10 мянга"],
    ["99944", "100 мянга", "100 мянга"],
    ["999444", "999 мянга", "999 мянга"],
    ["9994444", "10 сая", "10 сая"],
    ["999444444", "999 сая", "999 сая"],
    ["9994444444", "10 тэрбум", "10 тэрбум"],
    ["1000000000000000", "1000ИН", "1000 их наяд"],
    ["10000000000000000", "10000ИН", "10000 их наяд"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 мянга", "-1 мянга"],
    ["-1001", "-1 мянга", "-1 мянга"],
    ["-1010", "-1 мянга", "-1 мянга"],
    ["-1100", "-1.1 мянга", "-1.1 мянга"],
    ["-2000", "-2 мянга", "-2 мянга"],
    ["-2001", "-2 мянга", "-2 мянга"],
    ["-2010", "-2 мянга", "-2 мянга"],
    ["-2100", "-2.1 мянга", "-2.1 мянга"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 мянга", "-10 мянга"],
    ["-99999", "-100 мянга", "-100 мянга"],
    ["-999999", "-1 сая", "-1 сая"],
    ["-9999999", "-10 сая", "-10 сая"],
    ["-9999999999999999", "-10000ИН", "-10000 их наяд"],
    ["1000", "1 мянга", "1 мянга"],
    ["1001", "1 мянга", "1 мянга"],
    ["1010", "1 мянга", "1 мянга"],
    ["1100", "1.1 мянга", "1.1 мянга"],
    ["2000", "2 мянга", "2 мянга"],
    ["2001", "2 мянга", "2 мянга"],
    ["2010", "2 мянга", "2 мянга"],
    ["2100", "2.1 мянга", "2.1 мянга"],
    ["3000", "3 мянга", "3 мянга"],
    ["3001", "3 мянга", "3 мянга"],
    ["3010", "3 мянга", "3 мянга"],
    ["3100", "3.1 мянга", "3.1 мянга"],
    ["4000", "4 мянга", "4 мянга"],
    ["4001", "4 мянга", "4 мянга"],
    ["4010", "4 мянга", "4 мянга"],
    ["4100", "4.1 мянга", "4.1 мянга"],
    ["5000", "5 мянга", "5 мянга"],
    ["5001", "5 мянга", "5 мянга"],
    ["5010", "5 мянга", "5 мянга"],
    ["5100", "5.1 мянга", "5.1 мянга"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 мянга", "1 мянга"],
    ["9999.12", "10 мянга", "10 мянга"],
    ["9999.99", "10 мянга", "10 мянга"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 мянга", "-1 мянга"],
    ["-9999.12", "-10 мянга", "-10 мянга"],
    ["-9999.99", "-10 мянга", "-10 мянга"],
  ],
  "mr": [
    ["1", "१", "१"],
    ["21", "२१", "२१"],
    ["321", "३२१", "३२१"],
    ["4321", "४.३ ह", "४.३ हजार"],
    ["54321", "५४ ह", "५४ हजार"],
    ["654321", "६.५ लाख", "६.५ लाख"],
    ["7654321", "७७ लाख", "७७ लाख"],
    ["87654321", "८.८ कोटी", "८.८ कोटी"],
    ["987654321", "९९ कोटी", "९९ कोटी"],
    ["1087654321", "१.१ अब्ज", "१.१ अब्ज"],
    ["11987654321", "१२ अब्ज", "१२ अब्ज"],
    ["129987654321", "१.३ खर्व", "१.३ खर्व"],
    ["1398987654321", "१४ खर्व", "१४ खर्व"],
    ["14987987654321", "१.५ पद्म", "१.५ पद्म"],
    ["159876987654321", "१६ पद्म", "१६ पद्म"],
    ["9", "९", "९"],
    ["99", "९९", "९९"],
    ["999", "९९९", "९९९"],
    ["9999", "१० ह", "१० हजार"],
    ["99999", "१ लाख", "१ लाख"],
    ["999999", "१० लाख", "१० लाख"],
    ["9999999", "१ कोटी", "१ कोटी"],
    ["99999999", "१० कोटी", "१० कोटी"],
    ["9994", "१० ह", "१० हजार"],
    ["99944", "१ लाख", "१ लाख"],
    ["999444", "१० लाख", "१० लाख"],
    ["9994444", "१ कोटी", "१ कोटी"],
    ["999444444", "१ अब्ज", "१ अब्ज"],
    ["9994444444", "१० अब्ज", "१० अब्ज"],
    ["1000000000000000", "१०० पद्म", "१०० पद्म"],
    ["10000000000000000", "१००० पद्म", "१००० पद्म"],
    ["0", "०", "०"],
    ["-1", "-१", "-१"],
    ["-2", "-२", "-२"],
    ["-3", "-३", "-३"],
    ["-1000", "-१ ह", "-१ हजार"],
    ["-1001", "-१ ह", "-१ हजार"],
    ["-1010", "-१ ह", "-१ हजार"],
    ["-1100", "-१.१ ह", "-१.१ हजार"],
    ["-2000", "-२ ह", "-२ हजार"],
    ["-2001", "-२ ह", "-२ हजार"],
    ["-2010", "-२ ह", "-२ हजार"],
    ["-2100", "-२.१ ह", "-२.१ हजार"],
    ["-9", "-९", "-९"],
    ["-99", "-९९", "-९९"],
    ["-999", "-९९९", "-९९९"],
    ["-9999", "-१० ह", "-१० हजार"],
    ["-99999", "-१ लाख", "-१ लाख"],
    ["-999999", "-१० लाख", "-१० लाख"],
    ["-9999999", "-१ कोटी", "-१ कोटी"],
    ["-9999999999999999", "-१००० पद्म", "-१००० पद्म"],
    ["1000", "१ ह", "१ हजार"],
    ["1001", "१ ह", "१ हजार"],
    ["1010", "१ ह", "१ हजार"],
    ["1100", "१.१ ह", "१.१ हजार"],
    ["2000", "२ ह", "२ हजार"],
    ["2001", "२ ह", "२ हजार"],
    ["2010", "२ ह", "२ हजार"],
    ["2100", "२.१ ह", "२.१ हजार"],
    ["3000", "३ ह", "३ हजार"],
    ["3001", "३ ह", "३ हजार"],
    ["3010", "३ ह", "३ हजार"],
    ["3100", "३.१ ह", "३.१ हजार"],
    ["4000", "४ ह", "४ हजार"],
    ["4001", "४ ह", "४ हजार"],
    ["4010", "४ ह", "४ हजार"],
    ["4100", "४.१ ह", "४.१ हजार"],
    ["5000", "५ ह", "५ हजार"],
    ["5001", "५ ह", "५ हजार"],
    ["5010", "५ ह", "५ हजार"],
    ["5100", "५.१ ह", "५.१ हजार"],
    ["0.001234", "०.००१२", "०.००१२"],
    ["0.01234", "०.०१२", "०.०१२"],
    ["0.1234", "०.१२", "०.१२"],
    ["0.99", "०.९९", "०.९९"],
    ["0.999", "१", "१"],
    ["9.12", "९.१", "९.१"],
    ["9.99", "१०", "१०"],
    ["99.12", "९९", "९९"],
    ["99.99", "१००", "१००"],
    ["999.12", "९९९", "९९९"],
    ["999.99", "१ ह", "१ हजार"],
    ["9999.12", "१० ह", "१० हजार"],
    ["9999.99", "१० ह", "१० हजार"],
    ["-0.12", "-०.१२", "-०.१२"],
    ["-0.99", "-०.९९", "-०.९९"],
    ["-9.12", "-९.१", "-९.१"],
    ["-9.99", "-१०", "-१०"],
    ["-999.12", "-९९९", "-९९९"],
    ["-999.99", "-१ ह", "-१ हजार"],
    ["-9999.12", "-१० ह", "-१० हजार"],
    ["-9999.99", "-१० ह", "-१० हजार"],
  ],
  "ms": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 ribu"],
    ["54321", "54K", "54 ribu"],
    ["654321", "654K", "654 ribu"],
    ["7654321", "7.7J", "7.7 juta"],
    ["87654321", "88J", "88 juta"],
    ["987654321", "988J", "988 juta"],
    ["1087654321", "1.1B", "1.1 bilion"],
    ["11987654321", "12B", "12 bilion"],
    ["129987654321", "130B", "130 bilion"],
    ["1398987654321", "1.4T", "1.4 trilion"],
    ["14987987654321", "15T", "15 trilion"],
    ["159876987654321", "160T", "160 trilion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 ribu"],
    ["99999", "100K", "100 ribu"],
    ["999999", "1J", "1 juta"],
    ["9999999", "10J", "10 juta"],
    ["99999999", "100J", "100 juta"],
    ["9994", "10K", "10 ribu"],
    ["99944", "100K", "100 ribu"],
    ["999444", "999K", "999 ribu"],
    ["9994444", "10J", "10 juta"],
    ["999444444", "999J", "999 juta"],
    ["9994444444", "10B", "10 bilion"],
    ["1000000000000000", "1000T", "1000 trilion"],
    ["10000000000000000", "10000T", "10000 trilion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 ribu"],
    ["-1001", "-1K", "-1 ribu"],
    ["-1010", "-1K", "-1 ribu"],
    ["-1100", "-1.1K", "-1.1 ribu"],
    ["-2000", "-2K", "-2 ribu"],
    ["-2001", "-2K", "-2 ribu"],
    ["-2010", "-2K", "-2 ribu"],
    ["-2100", "-2.1K", "-2.1 ribu"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 ribu"],
    ["-99999", "-100K", "-100 ribu"],
    ["-999999", "-1J", "-1 juta"],
    ["-9999999", "-10J", "-10 juta"],
    ["-9999999999999999", "-10000T", "-10000 trilion"],
    ["1000", "1K", "1 ribu"],
    ["1001", "1K", "1 ribu"],
    ["1010", "1K", "1 ribu"],
    ["1100", "1.1K", "1.1 ribu"],
    ["2000", "2K", "2 ribu"],
    ["2001", "2K", "2 ribu"],
    ["2010", "2K", "2 ribu"],
    ["2100", "2.1K", "2.1 ribu"],
    ["3000", "3K", "3 ribu"],
    ["3001", "3K", "3 ribu"],
    ["3010", "3K", "3 ribu"],
    ["3100", "3.1K", "3.1 ribu"],
    ["4000", "4K", "4 ribu"],
    ["4001", "4K", "4 ribu"],
    ["4010", "4K", "4 ribu"],
    ["4100", "4.1K", "4.1 ribu"],
    ["5000", "5K", "5 ribu"],
    ["5001", "5K", "5 ribu"],
    ["5010", "5K", "5 ribu"],
    ["5100", "5.1K", "5.1 ribu"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 ribu"],
    ["9999.12", "10K", "10 ribu"],
    ["9999.99", "10K", "10 ribu"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 ribu"],
    ["-9999.12", "-10K", "-10 ribu"],
    ["-9999.99", "-10K", "-10 ribu"],
  ],
  "mt": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3K"],
    ["54321", "54K", "54K"],
    ["654321", "654K", "654K"],
    ["7654321", "7.7M", "7.7M"],
    ["87654321", "88M", "88M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1.1G", "1.1G"],
    ["11987654321", "12G", "12G"],
    ["129987654321", "130G", "130G"],
    ["1398987654321", "1.4T", "1.4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "10K", "10K"],
    ["99944", "100K", "100K"],
    ["999444", "999K", "999K"],
    ["9994444", "10M", "10M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "10G", "10G"],
    ["1000000000000000", "1000T", "1000T"],
    ["10000000000000000", "10000T", "10000T"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1K"],
    ["-1001", "-1K", "-1K"],
    ["-1010", "-1K", "-1K"],
    ["-1100", "-1.1K", "-1.1K"],
    ["-2000", "-2K", "-2K"],
    ["-2001", "-2K", "-2K"],
    ["-2010", "-2K", "-2K"],
    ["-2100", "-2.1K", "-2.1K"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10K"],
    ["-99999", "-100K", "-100K"],
    ["-999999", "-1M", "-1M"],
    ["-9999999", "-10M", "-10M"],
    ["-9999999999999999", "-10000T", "-10000T"],
    ["1000", "1K", "1K"],
    ["1001", "1K", "1K"],
    ["1010", "1K", "1K"],
    ["1100", "1.1K", "1.1K"],
    ["2000", "2K", "2K"],
    ["2001", "2K", "2K"],
    ["2010", "2K", "2K"],
    ["2100", "2.1K", "2.1K"],
    ["3000", "3K", "3K"],
    ["3001", "3K", "3K"],
    ["3010", "3K", "3K"],
    ["3100", "3.1K", "3.1K"],
    ["4000", "4K", "4K"],
    ["4001", "4K", "4K"],
    ["4010", "4K", "4K"],
    ["4100", "4.1K", "4.1K"],
    ["5000", "5K", "5K"],
    ["5001", "5K", "5K"],
    ["5010", "5K", "5K"],
    ["5100", "5.1K", "5.1K"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1K"],
    ["9999.12", "10K", "10K"],
    ["9999.99", "10K", "10K"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1K"],
    ["-9999.12", "-10K", "-10K"],
    ["-9999.99", "-10K", "-10K"],
  ],
  "my": [
    ["1", "၁", "၁"],
    ["21", "၂၁", "၂၁"],
    ["321", "၃၂၁", "၃၂၁"],
    ["4321", "၄.၃ ထောင်", "၄.၃ ထောင်"],
    ["54321", "၅.၄ သောင်း", "၅.၄ သောင်း"],
    ["654321", "၆.၅ သိန်း", "၆.၅ သိန်း"],
    ["7654321", "၇.၇ သန်း", "၇.၇ သန်း"],
    ["87654321", "၈.၈ ကုဋေ", "၈.၈ ကုဋေ"],
    ["987654321", "၉၉ ကုဋေ", "၉၉ ကုဋေ"],
    ["1087654321", "၁၀၉ ကုဋေ", "၁၀၉ ကုဋေ"],
    ["11987654321", "ကုဋေ ၁.၂ ထ", "၁၁၉၉ ကုဋေ"],
    ["129987654321", "ကုဋေ ၁.၃ သ", "ကုဋေ ၁.၃ သောင်း"],
    ["1398987654321", "ဋေ ၁.၄ သိန်း", "ကုဋေ ၁.၄ သိန်း"],
    ["14987987654321", "ဋေ ၁.၅ သန်း", "ကုဋေ ၁.၅ သန်း"],
    ["159876987654321", "၁.၆ ကောဋိ", "၁.၆ ကောဋိ"],
    ["9", "၉", "၉"],
    ["99", "၉၉", "၉၉"],
    ["999", "၉၉၉", "၉၉၉"],
    ["9999", "၁ သောင်း", "၁ သောင်း"],
    ["99999", "၁ သိန်း", "၁ သိန်း"],
    ["999999", "၁ သန်း", "၁ သန်း"],
    ["9999999", "၁ ကုဋေ", "၁ ကုဋေ"],
    ["99999999", "၁၀ ကုဋေ", "၁၀ ကုဋေ"],
    ["9994", "၁ သောင်း", "၁ သောင်း"],
    ["99944", "၁ သိန်း", "၁ သိန်း"],
    ["999444", "၁ သန်း", "၁ သန်း"],
    ["9994444", "၁ ကုဋေ", "၁ ကုဋေ"],
    ["999444444", "၁၀၀ ကုဋေ", "၁၀၀ ကုဋေ"],
    ["9994444444", "၉၉၉ ကုဋေ", "၉၉၉ ကုဋေ"],
    ["1000000000000000", "၁၀ ကောဋိ", "၁၀ ကောဋိ"],
    ["10000000000000000", "၁၀၀ ကောဋိ", "၁၀၀ ကောဋိ"],
    ["0", "၀", "၀"],
    ["-1", "-၁", "-၁"],
    ["-2", "-၂", "-၂"],
    ["-3", "-၃", "-၃"],
    ["-1000", "-၁ ထောင်", "-၁ ထောင်"],
    ["-1001", "-၁ ထောင်", "-၁ ထောင်"],
    ["-1010", "-၁ ထောင်", "-၁ ထောင်"],
    ["-1100", "-၁.၁ ထောင်", "-၁.၁ ထောင်"],
    ["-2000", "-၂ ထောင်", "-၂ ထောင်"],
    ["-2001", "-၂ ထောင်", "-၂ ထောင်"],
    ["-2010", "-၂ ထောင်", "-၂ ထောင်"],
    ["-2100", "-၂.၁ ထောင်", "-၂.၁ ထောင်"],
    ["-9", "-၉", "-၉"],
    ["-99", "-၉၉", "-၉၉"],
    ["-999", "-၉၉၉", "-၉၉၉"],
    ["-9999", "-၁ သောင်း", "-၁ သောင်း"],
    ["-99999", "-၁ သိန်း", "-၁ သိန်း"],
    ["-999999", "-၁ သန်း", "-၁ သန်း"],
    ["-9999999", "-၁ ကုဋေ", "-၁ ကုဋေ"],
    ["-9999999999999999", "-၁၀၀ ကောဋိ", "-၁၀၀ ကောဋိ"],
    ["1000", "၁ ထောင်", "၁ ထောင်"],
    ["1001", "၁ ထောင်", "၁ ထောင်"],
    ["1010", "၁ ထောင်", "၁ ထောင်"],
    ["1100", "၁.၁ ထောင်", "၁.၁ ထောင်"],
    ["2000", "၂ ထောင်", "၂ ထောင်"],
    ["2001", "၂ ထောင်", "၂ ထောင်"],
    ["2010", "၂ ထောင်", "၂ ထောင်"],
    ["2100", "၂.၁ ထောင်", "၂.၁ ထောင်"],
    ["3000", "၃ ထောင်", "၃ ထောင်"],
    ["3001", "၃ ထောင်", "၃ ထောင်"],
    ["3010", "၃ ထောင်", "၃ ထောင်"],
    ["3100", "၃.၁ ထောင်", "၃.၁ ထောင်"],
    ["4000", "၄ ထောင်", "၄ ထောင်"],
    ["4001", "၄ ထောင်", "၄ ထောင်"],
    ["4010", "၄ ထောင်", "၄ ထောင်"],
    ["4100", "၄.၁ ထောင်", "၄.၁ ထောင်"],
    ["5000", "၅ ထောင်", "၅ ထောင်"],
    ["5001", "၅ ထောင်", "၅ ထောင်"],
    ["5010", "၅ ထောင်", "၅ ထောင်"],
    ["5100", "၅.၁ ထောင်", "၅.၁ ထောင်"],
    ["0.001234", "၀.၀၀၁၂", "၀.၀၀၁၂"],
    ["0.01234", "၀.၀၁၂", "၀.၀၁၂"],
    ["0.1234", "၀.၁၂", "၀.၁၂"],
    ["0.99", "၀.၉၉", "၀.၉၉"],
    ["0.999", "၁", "၁"],
    ["9.12", "၉.၁", "၉.၁"],
    ["9.99", "၁၀", "၁၀"],
    ["99.12", "၉၉", "၉၉"],
    ["99.99", "၁၀၀", "၁၀၀"],
    ["999.12", "၉၉၉", "၉၉၉"],
    ["999.99", "၁ ထောင်", "၁ ထောင်"],
    ["9999.12", "၁ သောင်း", "၁ သောင်း"],
    ["9999.99", "၁ သောင်း", "၁ သောင်း"],
    ["-0.12", "-၀.၁၂", "-၀.၁၂"],
    ["-0.99", "-၀.၉၉", "-၀.၉၉"],
    ["-9.12", "-၉.၁", "-၉.၁"],
    ["-9.99", "-၁၀", "-၁၀"],
    ["-999.12", "-၉၉၉", "-၉၉၉"],
    ["-999.99", "-၁ ထောင်", "-၁ ထောင်"],
    ["-9999.12", "-၁ သောင်း", "-၁ သောင်း"],
    ["-9999.99", "-၁ သောင်း", "-၁ သောင်း"],
  ],
  "nb": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3k", "4,3 tusen"],
    ["54321", "54k", "54 tusen"],
    ["654321", "654k", "654 tusen"],
    ["7654321", "7,7 mill.", "7,7 millioner"],
    ["87654321", "88 mill.", "88 millioner"],
    ["987654321", "988 mill.", "988 millioner"],
    ["1087654321", "1,1 mrd.", "1,1 milliarder"],
    ["11987654321", "12 mrd.", "12 milliarder"],
    ["129987654321", "130 mrd.", "130 milliarder"],
    ["1398987654321", "1,4 bill.", "1,4 billioner"],
    ["14987987654321", "15 bill.", "15 billioner"],
    ["159876987654321", "160 bill.", "160 billioner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 tusen"],
    ["99999", "100k", "100 tusen"],
    ["999999", "1 mill.", "1 million"],
    ["9999999", "10 mill.", "10 millioner"],
    ["99999999", "100 mill.", "100 millioner"],
    ["9994", "10k", "10 tusen"],
    ["99944", "100k", "100 tusen"],
    ["999444", "999k", "999 tusen"],
    ["9994444", "10 mill.", "10 millioner"],
    ["999444444", "999 mill.", "999 millioner"],
    ["9994444444", "10 mrd.", "10 milliarder"],
    ["1000000000000000", "1000 bill.", "1000 billioner"],
    ["10000000000000000", "10000 bill.", "10000 billioner"],
    ["0", "0", "0"],
    ["-1", "−1", "−1"],
    ["-2", "−2", "−2"],
    ["-3", "−3", "−3"],
    ["-1000", "−1k", "−1 tusen"],
    ["-1001", "−1k", "−1 tusen"],
    ["-1010", "−1k", "−1 tusen"],
    ["-1100", "−1,1k", "−1,1 tusen"],
    ["-2000", "−2k", "−2 tusen"],
    ["-2001", "−2k", "−2 tusen"],
    ["-2010", "−2k", "−2 tusen"],
    ["-2100", "−2,1k", "−2,1 tusen"],
    ["-9", "−9", "−9"],
    ["-99", "−99", "−99"],
    ["-999", "−999", "−999"],
    ["-9999", "−10k", "−10 tusen"],
    ["-99999", "−100k", "−100 tusen"],
    ["-999999", "−1 mill.", "−1 million"],
    ["-9999999", "−10 mill.", "−10 millioner"],
    ["-9999999999999999", "−10000 bill.", "−10000 billioner"],
    ["1000", "1k", "1 tusen"],
    ["1001", "1k", "1 tusen"],
    ["1010", "1k", "1 tusen"],
    ["1100", "1,1k", "1,1 tusen"],
    ["2000", "2k", "2 tusen"],
    ["2001", "2k", "2 tusen"],
    ["2010", "2k", "2 tusen"],
    ["2100", "2,1k", "2,1 tusen"],
    ["3000", "3k", "3 tusen"],
    ["3001", "3k", "3 tusen"],
    ["3010", "3k", "3 tusen"],
    ["3100", "3,1k", "3,1 tusen"],
    ["4000", "4k", "4 tusen"],
    ["4001", "4k", "4 tusen"],
    ["4010", "4k", "4 tusen"],
    ["4100", "4,1k", "4,1 tusen"],
    ["5000", "5k", "5 tusen"],
    ["5001", "5k", "5 tusen"],
    ["5010", "5k", "5 tusen"],
    ["5100", "5,1k", "5,1 tusen"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1k", "1 tusen"],
    ["9999.12", "10k", "10 tusen"],
    ["9999.99", "10k", "10 tusen"],
    ["-0.12", "−0,12", "−0,12"],
    ["-0.99", "−0,99", "−0,99"],
    ["-9.12", "−9,1", "−9,1"],
    ["-9.99", "−10", "−10"],
    ["-999.12", "−999", "−999"],
    ["-999.99", "−1k", "−1 tusen"],
    ["-9999.12", "−10k", "−10 tusen"],
    ["-9999.99", "−10k", "−10 tusen"],
  ],
  "ne": [
    ["1", "१", "१"],
    ["21", "२१", "२१"],
    ["321", "३२१", "३२१"],
    ["4321", "४.३ हजार", "४.३ हजार"],
    ["54321", "५४ हजार", "५४ हजार"],
    ["654321", "६.५ लाख", "६.५ लाख"],
    ["7654321", "७७ लाख", "७.७ करोड"],
    ["87654321", "८.८ करोड", "८८ करोड"],
    ["987654321", "९९ करोड", "९८८ करोड"],
    ["1087654321", "१.१ अरब", "१.१ अरब"],
    ["11987654321", "१२ अरब", "१२ अरब"],
    ["129987654321", "१.३ खरब", "१३० अरब"],
    ["1398987654321", "१४ खरब", "१४ खरब"],
    ["14987987654321", "१.५ शंख", "१.५ शंख"],
    ["159876987654321", "१६ शंख", "१६ शंख"],
    ["9", "९", "९"],
    ["99", "९९", "९९"],
    ["999", "९९९", "९९९"],
    ["9999", "१० हजार", "१० हजार"],
    ["99999", "१ लाख", "१ लाख"],
    ["999999", "१० लाख", "१ करोड"],
    ["9999999", "१ करोड", "१० करोड"],
    ["99999999", "१० करोड", "१०० करोड"],
    ["9994", "१० हजार", "१० हजार"],
    ["99944", "१ लाख", "१ लाख"],
    ["999444", "१० लाख", "१ करोड"],
    ["9994444", "१ करोड", "१० करोड"],
    ["999444444", "१ अरब", "९९९ करोड"],
    ["9994444444", "१० अरब", "१० अरब"],
    ["1000000000000000", "१०० शंख", "१०० शंख"],
    ["10000000000000000", "१००० शंख", "१००० शंख"],
    ["0", "०", "०"],
    ["-1", "-१", "-१"],
    ["-2", "-२", "-२"],
    ["-3", "-३", "-३"],
    ["-1000", "-१ हजार", "-१ हजार"],
    ["-1001", "-१ हजार", "-१ हजार"],
    ["-1010", "-१ हजार", "-१ हजार"],
    ["-1100", "-१.१ हजार", "-१.१ हजार"],
    ["-2000", "-२ हजार", "-२ हजार"],
    ["-2001", "-२ हजार", "-२ हजार"],
    ["-2010", "-२ हजार", "-२ हजार"],
    ["-2100", "-२.१ हजार", "-२.१ हजार"],
    ["-9", "-९", "-९"],
    ["-99", "-९९", "-९९"],
    ["-999", "-९९९", "-९९९"],
    ["-9999", "-१० हजार", "-१० हजार"],
    ["-99999", "-१ लाख", "-१ लाख"],
    ["-999999", "-१० लाख", "-१ करोड"],
    ["-9999999", "-१ करोड", "-१० करोड"],
    ["-9999999999999999", "-१००० शंख", "-१००० शंख"],
    ["1000", "१ हजार", "१ हजार"],
    ["1001", "१ हजार", "१ हजार"],
    ["1010", "१ हजार", "१ हजार"],
    ["1100", "१.१ हजार", "१.१ हजार"],
    ["2000", "२ हजार", "२ हजार"],
    ["2001", "२ हजार", "२ हजार"],
    ["2010", "२ हजार", "२ हजार"],
    ["2100", "२.१ हजार", "२.१ हजार"],
    ["3000", "३ हजार", "३ हजार"],
    ["3001", "३ हजार", "३ हजार"],
    ["3010", "३ हजार", "३ हजार"],
    ["3100", "३.१ हजार", "३.१ हजार"],
    ["4000", "४ हजार", "४ हजार"],
    ["4001", "४ हजार", "४ हजार"],
    ["4010", "४ हजार", "४ हजार"],
    ["4100", "४.१ हजार", "४.१ हजार"],
    ["5000", "५ हजार", "५ हजार"],
    ["5001", "५ हजार", "५ हजार"],
    ["5010", "५ हजार", "५ हजार"],
    ["5100", "५.१ हजार", "५.१ हजार"],
    ["0.001234", "०.००१२", "०.००१२"],
    ["0.01234", "०.०१२", "०.०१२"],
    ["0.1234", "०.१२", "०.१२"],
    ["0.99", "०.९९", "०.९९"],
    ["0.999", "१", "१"],
    ["9.12", "९.१", "९.१"],
    ["9.99", "१०", "१०"],
    ["99.12", "९९", "९९"],
    ["99.99", "१००", "१००"],
    ["999.12", "९९९", "९९९"],
    ["999.99", "१ हजार", "१ हजार"],
    ["9999.12", "१० हजार", "१० हजार"],
    ["9999.99", "१० हजार", "१० हजार"],
    ["-0.12", "-०.१२", "-०.१२"],
    ["-0.99", "-०.९९", "-०.९९"],
    ["-9.12", "-९.१", "-९.१"],
    ["-9.99", "-१०", "-१०"],
    ["-999.12", "-९९९", "-९९९"],
    ["-999.99", "-१ हजार", "-१ हजार"],
    ["-9999.12", "-१० हजार", "-१० हजार"],
    ["-9999.99", "-१० हजार", "-१० हजार"],
  ],
  "nl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3K", "4,3 duizend"],
    ["54321", "54K", "54 duizend"],
    ["654321", "654K", "654 duizend"],
    ["7654321", "7,7 mln.", "7,7 miljoen"],
    ["87654321", "88 mln.", "88 miljoen"],
    ["987654321", "988 mln.", "988 miljoen"],
    ["1087654321", "1,1 mld.", "1,1 miljard"],
    ["11987654321", "12 mld.", "12 miljard"],
    ["129987654321", "130 mld.", "130 miljard"],
    ["1398987654321", "1,4 bln.", "1,4 biljoen"],
    ["14987987654321", "15 bln.", "15 biljoen"],
    ["159876987654321", "160 bln.", "160 biljoen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 duizend"],
    ["99999", "100K", "100 duizend"],
    ["999999", "1 mln.", "1 miljoen"],
    ["9999999", "10 mln.", "10 miljoen"],
    ["99999999", "100 mln.", "100 miljoen"],
    ["9994", "10K", "10 duizend"],
    ["99944", "100K", "100 duizend"],
    ["999444", "999K", "999 duizend"],
    ["9994444", "10 mln.", "10 miljoen"],
    ["999444444", "999 mln.", "999 miljoen"],
    ["9994444444", "10 mld.", "10 miljard"],
    ["1000000000000000", "1000 bln.", "1000 biljoen"],
    ["10000000000000000", "10000 bln.", "10000 biljoen"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 duizend"],
    ["-1001", "-1K", "-1 duizend"],
    ["-1010", "-1K", "-1 duizend"],
    ["-1100", "-1,1K", "-1,1 duizend"],
    ["-2000", "-2K", "-2 duizend"],
    ["-2001", "-2K", "-2 duizend"],
    ["-2010", "-2K", "-2 duizend"],
    ["-2100", "-2,1K", "-2,1 duizend"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 duizend"],
    ["-99999", "-100K", "-100 duizend"],
    ["-999999", "-1 mln.", "-1 miljoen"],
    ["-9999999", "-10 mln.", "-10 miljoen"],
    ["-9999999999999999", "-10000 bln.", "-10000 biljoen"],
    ["1000", "1K", "1 duizend"],
    ["1001", "1K", "1 duizend"],
    ["1010", "1K", "1 duizend"],
    ["1100", "1,1K", "1,1 duizend"],
    ["2000", "2K", "2 duizend"],
    ["2001", "2K", "2 duizend"],
    ["2010", "2K", "2 duizend"],
    ["2100", "2,1K", "2,1 duizend"],
    ["3000", "3K", "3 duizend"],
    ["3001", "3K", "3 duizend"],
    ["3010", "3K", "3 duizend"],
    ["3100", "3,1K", "3,1 duizend"],
    ["4000", "4K", "4 duizend"],
    ["4001", "4K", "4 duizend"],
    ["4010", "4K", "4 duizend"],
    ["4100", "4,1K", "4,1 duizend"],
    ["5000", "5K", "5 duizend"],
    ["5001", "5K", "5 duizend"],
    ["5010", "5K", "5 duizend"],
    ["5100", "5,1K", "5,1 duizend"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 duizend"],
    ["9999.12", "10K", "10 duizend"],
    ["9999.99", "10K", "10 duizend"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 duizend"],
    ["-9999.12", "-10K", "-10 duizend"],
    ["-9999.99", "-10K", "-10 duizend"],
  ],
  "no": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3k", "4,3 tusen"],
    ["54321", "54k", "54 tusen"],
    ["654321", "654k", "654 tusen"],
    ["7654321", "7,7 mill.", "7,7 millioner"],
    ["87654321", "88 mill.", "88 millioner"],
    ["987654321", "988 mill.", "988 millioner"],
    ["1087654321", "1,1 mrd.", "1,1 milliarder"],
    ["11987654321", "12 mrd.", "12 milliarder"],
    ["129987654321", "130 mrd.", "130 milliarder"],
    ["1398987654321", "1,4 bill.", "1,4 billioner"],
    ["14987987654321", "15 bill.", "15 billioner"],
    ["159876987654321", "160 bill.", "160 billioner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 tusen"],
    ["99999", "100k", "100 tusen"],
    ["999999", "1 mill.", "1 million"],
    ["9999999", "10 mill.", "10 millioner"],
    ["99999999", "100 mill.", "100 millioner"],
    ["9994", "10k", "10 tusen"],
    ["99944", "100k", "100 tusen"],
    ["999444", "999k", "999 tusen"],
    ["9994444", "10 mill.", "10 millioner"],
    ["999444444", "999 mill.", "999 millioner"],
    ["9994444444", "10 mrd.", "10 milliarder"],
    ["1000000000000000", "1000 bill.", "1000 billioner"],
    ["10000000000000000", "10000 bill.", "10000 billioner"],
    ["0", "0", "0"],
    ["-1", "−1", "−1"],
    ["-2", "−2", "−2"],
    ["-3", "−3", "−3"],
    ["-1000", "−1k", "−1 tusen"],
    ["-1001", "−1k", "−1 tusen"],
    ["-1010", "−1k", "−1 tusen"],
    ["-1100", "−1,1k", "−1,1 tusen"],
    ["-2000", "−2k", "−2 tusen"],
    ["-2001", "−2k", "−2 tusen"],
    ["-2010", "−2k", "−2 tusen"],
    ["-2100", "−2,1k", "−2,1 tusen"],
    ["-9", "−9", "−9"],
    ["-99", "−99", "−99"],
    ["-999", "−999", "−999"],
    ["-9999", "−10k", "−10 tusen"],
    ["-99999", "−100k", "−100 tusen"],
    ["-999999", "−1 mill.", "−1 million"],
    ["-9999999", "−10 mill.", "−10 millioner"],
    ["-9999999999999999", "−10000 bill.", "−10000 billioner"],
    ["1000", "1k", "1 tusen"],
    ["1001", "1k", "1 tusen"],
    ["1010", "1k", "1 tusen"],
    ["1100", "1,1k", "1,1 tusen"],
    ["2000", "2k", "2 tusen"],
    ["2001", "2k", "2 tusen"],
    ["2010", "2k", "2 tusen"],
    ["2100", "2,1k", "2,1 tusen"],
    ["3000", "3k", "3 tusen"],
    ["3001", "3k", "3 tusen"],
    ["3010", "3k", "3 tusen"],
    ["3100", "3,1k", "3,1 tusen"],
    ["4000", "4k", "4 tusen"],
    ["4001", "4k", "4 tusen"],
    ["4010", "4k", "4 tusen"],
    ["4100", "4,1k", "4,1 tusen"],
    ["5000", "5k", "5 tusen"],
    ["5001", "5k", "5 tusen"],
    ["5010", "5k", "5 tusen"],
    ["5100", "5,1k", "5,1 tusen"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1k", "1 tusen"],
    ["9999.12", "10k", "10 tusen"],
    ["9999.99", "10k", "10 tusen"],
    ["-0.12", "−0,12", "−0,12"],
    ["-0.99", "−0,99", "−0,99"],
    ["-9.12", "−9,1", "−9,1"],
    ["-9.99", "−10", "−10"],
    ["-999.12", "−999", "−999"],
    ["-999.99", "−1k", "−1 tusen"],
    ["-9999.12", "−10k", "−10 tusen"],
    ["-9999.99", "−10k", "−10 tusen"],
  ],
  "no_NO": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3k", "4,3 tusen"],
    ["54321", "54k", "54 tusen"],
    ["654321", "654k", "654 tusen"],
    ["7654321", "7,7 mill.", "7,7 millioner"],
    ["87654321", "88 mill.", "88 millioner"],
    ["987654321", "988 mill.", "988 millioner"],
    ["1087654321", "1,1 mrd.", "1,1 milliarder"],
    ["11987654321", "12 mrd.", "12 milliarder"],
    ["129987654321", "130 mrd.", "130 milliarder"],
    ["1398987654321", "1,4 bill.", "1,4 billioner"],
    ["14987987654321", "15 bill.", "15 billioner"],
    ["159876987654321", "160 bill.", "160 billioner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 tusen"],
    ["99999", "100k", "100 tusen"],
    ["999999", "1 mill.", "1 million"],
    ["9999999", "10 mill.", "10 millioner"],
    ["99999999", "100 mill.", "100 millioner"],
    ["9994", "10k", "10 tusen"],
    ["99944", "100k", "100 tusen"],
    ["999444", "999k", "999 tusen"],
    ["9994444", "10 mill.", "10 millioner"],
    ["999444444", "999 mill.", "999 millioner"],
    ["9994444444", "10 mrd.", "10 milliarder"],
    ["1000000000000000", "1000 bill.", "1000 billioner"],
    ["10000000000000000", "10000 bill.", "10000 billioner"],
    ["0", "0", "0"],
    ["-1", "−1", "−1"],
    ["-2", "−2", "−2"],
    ["-3", "−3", "−3"],
    ["-1000", "−1k", "−1 tusen"],
    ["-1001", "−1k", "−1 tusen"],
    ["-1010", "−1k", "−1 tusen"],
    ["-1100", "−1,1k", "−1,1 tusen"],
    ["-2000", "−2k", "−2 tusen"],
    ["-2001", "−2k", "−2 tusen"],
    ["-2010", "−2k", "−2 tusen"],
    ["-2100", "−2,1k", "−2,1 tusen"],
    ["-9", "−9", "−9"],
    ["-99", "−99", "−99"],
    ["-999", "−999", "−999"],
    ["-9999", "−10k", "−10 tusen"],
    ["-99999", "−100k", "−100 tusen"],
    ["-999999", "−1 mill.", "−1 million"],
    ["-9999999", "−10 mill.", "−10 millioner"],
    ["-9999999999999999", "−10000 bill.", "−10000 billioner"],
    ["1000", "1k", "1 tusen"],
    ["1001", "1k", "1 tusen"],
    ["1010", "1k", "1 tusen"],
    ["1100", "1,1k", "1,1 tusen"],
    ["2000", "2k", "2 tusen"],
    ["2001", "2k", "2 tusen"],
    ["2010", "2k", "2 tusen"],
    ["2100", "2,1k", "2,1 tusen"],
    ["3000", "3k", "3 tusen"],
    ["3001", "3k", "3 tusen"],
    ["3010", "3k", "3 tusen"],
    ["3100", "3,1k", "3,1 tusen"],
    ["4000", "4k", "4 tusen"],
    ["4001", "4k", "4 tusen"],
    ["4010", "4k", "4 tusen"],
    ["4100", "4,1k", "4,1 tusen"],
    ["5000", "5k", "5 tusen"],
    ["5001", "5k", "5 tusen"],
    ["5010", "5k", "5 tusen"],
    ["5100", "5,1k", "5,1 tusen"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1k", "1 tusen"],
    ["9999.12", "10k", "10 tusen"],
    ["9999.99", "10k", "10 tusen"],
    ["-0.12", "−0,12", "−0,12"],
    ["-0.99", "−0,99", "−0,99"],
    ["-9.12", "−9,1", "−9,1"],
    ["-9.99", "−10", "−10"],
    ["-999.12", "−999", "−999"],
    ["-999.99", "−1k", "−1 tusen"],
    ["-9999.12", "−10k", "−10 tusen"],
    ["-9999.99", "−10k", "−10 tusen"],
  ],
  "nyn": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3K"],
    ["54321", "54K", "54K"],
    ["654321", "654K", "654K"],
    ["7654321", "7.7M", "7.7M"],
    ["87654321", "88M", "88M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1.1G", "1.1G"],
    ["11987654321", "12G", "12G"],
    ["129987654321", "130G", "130G"],
    ["1398987654321", "1.4T", "1.4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "10K", "10K"],
    ["99944", "100K", "100K"],
    ["999444", "999K", "999K"],
    ["9994444", "10M", "10M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "10G", "10G"],
    ["1000000000000000", "1000T", "1000T"],
    ["10000000000000000", "10000T", "10000T"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1K"],
    ["-1001", "-1K", "-1K"],
    ["-1010", "-1K", "-1K"],
    ["-1100", "-1.1K", "-1.1K"],
    ["-2000", "-2K", "-2K"],
    ["-2001", "-2K", "-2K"],
    ["-2010", "-2K", "-2K"],
    ["-2100", "-2.1K", "-2.1K"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10K"],
    ["-99999", "-100K", "-100K"],
    ["-999999", "-1M", "-1M"],
    ["-9999999", "-10M", "-10M"],
    ["-9999999999999999", "-10000T", "-10000T"],
    ["1000", "1K", "1K"],
    ["1001", "1K", "1K"],
    ["1010", "1K", "1K"],
    ["1100", "1.1K", "1.1K"],
    ["2000", "2K", "2K"],
    ["2001", "2K", "2K"],
    ["2010", "2K", "2K"],
    ["2100", "2.1K", "2.1K"],
    ["3000", "3K", "3K"],
    ["3001", "3K", "3K"],
    ["3010", "3K", "3K"],
    ["3100", "3.1K", "3.1K"],
    ["4000", "4K", "4K"],
    ["4001", "4K", "4K"],
    ["4010", "4K", "4K"],
    ["4100", "4.1K", "4.1K"],
    ["5000", "5K", "5K"],
    ["5001", "5K", "5K"],
    ["5010", "5K", "5K"],
    ["5100", "5.1K", "5.1K"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1K"],
    ["9999.12", "10K", "10K"],
    ["9999.99", "10K", "10K"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1K"],
    ["-9999.12", "-10K", "-10K"],
    ["-9999.99", "-10K", "-10K"],
  ],
  "or": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3ହ", "4.3 ହଜାର"],
    ["54321", "54ହ", "54 ହଜାର"],
    ["654321", "654ହ", "654 ହଜାର"],
    ["7654321", "7.7ନି", "7.7 ନିୟୁତ"],
    ["87654321", "88ନି", "88 ନିୟୁତ"],
    ["987654321", "988ନି", "988 ନିୟୁତ"],
    ["1087654321", "1.1ବି", "1.1 ଶହକୋଟି"],
    ["11987654321", "12ବି", "12 ଶହକୋଟି"],
    ["129987654321", "130ବି", "130 ଶହକୋଟି"],
    ["1398987654321", "1.4ଟ୍ରି", "1.4 ଲକ୍ଷକୋଟି"],
    ["14987987654321", "15ଟ୍ରି", "15 ଲକ୍ଷକୋଟି"],
    ["159876987654321", "160ଟ୍ରି", "160 ଲକ୍ଷକୋଟି"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10ହ", "10 ହଜାର"],
    ["99999", "100ହ", "100 ହଜାର"],
    ["999999", "1ନି", "1 ନିୟୁତ"],
    ["9999999", "10ନି", "10 ନିୟୁତ"],
    ["99999999", "100ନି", "100 ନିୟୁତ"],
    ["9994", "10ହ", "10 ହଜାର"],
    ["99944", "100ହ", "100 ହଜାର"],
    ["999444", "999ହ", "999 ହଜାର"],
    ["9994444", "10ନି", "10 ନିୟୁତ"],
    ["999444444", "999ନି", "999 ନିୟୁତ"],
    ["9994444444", "10ବି", "10 ଶହକୋଟି"],
    ["1000000000000000", "1000ଟ୍ରି", "1000 ଲକ୍ଷକୋଟି"],
    ["10000000000000000", "10000ଟ୍ରି", "10000 ଲକ୍ଷକୋଟି"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1ହ", "-1 ହଜାର"],
    ["-1001", "-1ହ", "-1 ହଜାର"],
    ["-1010", "-1ହ", "-1 ହଜାର"],
    ["-1100", "-1.1ହ", "-1.1 ହଜାର"],
    ["-2000", "-2ହ", "-2 ହଜାର"],
    ["-2001", "-2ହ", "-2 ହଜାର"],
    ["-2010", "-2ହ", "-2 ହଜାର"],
    ["-2100", "-2.1ହ", "-2.1 ହଜାର"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10ହ", "-10 ହଜାର"],
    ["-99999", "-100ହ", "-100 ହଜାର"],
    ["-999999", "-1ନି", "-1 ନିୟୁତ"],
    ["-9999999", "-10ନି", "-10 ନିୟୁତ"],
    ["-9999999999999999", "-10000ଟ୍ରି", "-10000 ଲକ୍ଷକୋଟି"],
    ["1000", "1ହ", "1 ହଜାର"],
    ["1001", "1ହ", "1 ହଜାର"],
    ["1010", "1ହ", "1 ହଜାର"],
    ["1100", "1.1ହ", "1.1 ହଜାର"],
    ["2000", "2ହ", "2 ହଜାର"],
    ["2001", "2ହ", "2 ହଜାର"],
    ["2010", "2ହ", "2 ହଜାର"],
    ["2100", "2.1ହ", "2.1 ହଜାର"],
    ["3000", "3ହ", "3 ହଜାର"],
    ["3001", "3ହ", "3 ହଜାର"],
    ["3010", "3ହ", "3 ହଜାର"],
    ["3100", "3.1ହ", "3.1 ହଜାର"],
    ["4000", "4ହ", "4 ହଜାର"],
    ["4001", "4ହ", "4 ହଜାର"],
    ["4010", "4ହ", "4 ହଜାର"],
    ["4100", "4.1ହ", "4.1 ହଜାର"],
    ["5000", "5ହ", "5 ହଜାର"],
    ["5001", "5ହ", "5 ହଜାର"],
    ["5010", "5ହ", "5 ହଜାର"],
    ["5100", "5.1ହ", "5.1 ହଜାର"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1ହ", "1 ହଜାର"],
    ["9999.12", "10ହ", "10 ହଜାର"],
    ["9999.99", "10ହ", "10 ହଜାର"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1ହ", "-1 ହଜାର"],
    ["-9999.12", "-10ହ", "-10 ହଜାର"],
    ["-9999.99", "-10ହ", "-10 ହଜାର"],
  ],
  "pa": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 ਹਜ਼ਾਰ", "4.3 ਹਜ਼ਾਰ"],
    ["54321", "54 ਹਜ਼ਾਰ", "54 ਹਜ਼ਾਰ"],
    ["654321", "6.5 ਲੱਖ", "6.5 ਲੱਖ"],
    ["7654321", "77 ਲੱਖ", "77 ਲੱਖ"],
    ["87654321", "8.8 ਕਰੋੜ", "8.8 ਕਰੋੜ"],
    ["987654321", "99 ਕਰੋੜ", "99 ਕਰੋੜ"],
    ["1087654321", "1.1 ਅਰਬ", "1.1 ਅਰਬ"],
    ["11987654321", "12 ਅਰਬ", "12 ਅਰਬ"],
    ["129987654321", "1.3 ਖਰਬ", "1.3 ਖਰਬ"],
    ["1398987654321", "14 ਖਰਬ", "14 ਖਰਬ"],
    ["14987987654321", "1.5 ਨੀਲ", "1.5 ਨੀਲ"],
    ["159876987654321", "16 ਨੀਲ", "16 ਨੀਲ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ਹਜ਼ਾਰ", "10 ਹਜ਼ਾਰ"],
    ["99999", "1 ਲੱਖ", "1 ਲੱਖ"],
    ["999999", "10 ਲੱਖ", "10 ਲੱਖ"],
    ["9999999", "1 ਕਰੋੜ", "1 ਕਰੋੜ"],
    ["99999999", "10 ਕਰੋੜ", "10 ਕਰੋੜ"],
    ["9994", "10 ਹਜ਼ਾਰ", "10 ਹਜ਼ਾਰ"],
    ["99944", "1 ਲੱਖ", "1 ਲੱਖ"],
    ["999444", "10 ਲੱਖ", "10 ਲੱਖ"],
    ["9994444", "1 ਕਰੋੜ", "1 ਕਰੋੜ"],
    ["999444444", "1 ਅਰਬ", "1 ਅਰਬ"],
    ["9994444444", "10 ਅਰਬ", "10 ਅਰਬ"],
    ["1000000000000000", "100 ਨੀਲ", "100 ਨੀਲ"],
    ["10000000000000000", "1000 ਨੀਲ", "1000 ਨੀਲ"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 ਹਜ਼ਾਰ", "-1 ਹਜ਼ਾਰ"],
    ["-1001", "-1 ਹਜ਼ਾਰ", "-1 ਹਜ਼ਾਰ"],
    ["-1010", "-1 ਹਜ਼ਾਰ", "-1 ਹਜ਼ਾਰ"],
    ["-1100", "-1.1 ਹਜ਼ਾਰ", "-1.1 ਹਜ਼ਾਰ"],
    ["-2000", "-2 ਹਜ਼ਾਰ", "-2 ਹਜ਼ਾਰ"],
    ["-2001", "-2 ਹਜ਼ਾਰ", "-2 ਹਜ਼ਾਰ"],
    ["-2010", "-2 ਹਜ਼ਾਰ", "-2 ਹਜ਼ਾਰ"],
    ["-2100", "-2.1 ਹਜ਼ਾਰ", "-2.1 ਹਜ਼ਾਰ"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 ਹਜ਼ਾਰ", "-10 ਹਜ਼ਾਰ"],
    ["-99999", "-1 ਲੱਖ", "-1 ਲੱਖ"],
    ["-999999", "-10 ਲੱਖ", "-10 ਲੱਖ"],
    ["-9999999", "-1 ਕਰੋੜ", "-1 ਕਰੋੜ"],
    ["-9999999999999999", "-1000 ਨੀਲ", "-1000 ਨੀਲ"],
    ["1000", "1 ਹਜ਼ਾਰ", "1 ਹਜ਼ਾਰ"],
    ["1001", "1 ਹਜ਼ਾਰ", "1 ਹਜ਼ਾਰ"],
    ["1010", "1 ਹਜ਼ਾਰ", "1 ਹਜ਼ਾਰ"],
    ["1100", "1.1 ਹਜ਼ਾਰ", "1.1 ਹਜ਼ਾਰ"],
    ["2000", "2 ਹਜ਼ਾਰ", "2 ਹਜ਼ਾਰ"],
    ["2001", "2 ਹਜ਼ਾਰ", "2 ਹਜ਼ਾਰ"],
    ["2010", "2 ਹਜ਼ਾਰ", "2 ਹਜ਼ਾਰ"],
    ["2100", "2.1 ਹਜ਼ਾਰ", "2.1 ਹਜ਼ਾਰ"],
    ["3000", "3 ਹਜ਼ਾਰ", "3 ਹਜ਼ਾਰ"],
    ["3001", "3 ਹਜ਼ਾਰ", "3 ਹਜ਼ਾਰ"],
    ["3010", "3 ਹਜ਼ਾਰ", "3 ਹਜ਼ਾਰ"],
    ["3100", "3.1 ਹਜ਼ਾਰ", "3.1 ਹਜ਼ਾਰ"],
    ["4000", "4 ਹਜ਼ਾਰ", "4 ਹਜ਼ਾਰ"],
    ["4001", "4 ਹਜ਼ਾਰ", "4 ਹਜ਼ਾਰ"],
    ["4010", "4 ਹਜ਼ਾਰ", "4 ਹਜ਼ਾਰ"],
    ["4100", "4.1 ਹਜ਼ਾਰ", "4.1 ਹਜ਼ਾਰ"],
    ["5000", "5 ਹਜ਼ਾਰ", "5 ਹਜ਼ਾਰ"],
    ["5001", "5 ਹਜ਼ਾਰ", "5 ਹਜ਼ਾਰ"],
    ["5010", "5 ਹਜ਼ਾਰ", "5 ਹਜ਼ਾਰ"],
    ["5100", "5.1 ਹਜ਼ਾਰ", "5.1 ਹਜ਼ਾਰ"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 ਹਜ਼ਾਰ", "1 ਹਜ਼ਾਰ"],
    ["9999.12", "10 ਹਜ਼ਾਰ", "10 ਹਜ਼ਾਰ"],
    ["9999.99", "10 ਹਜ਼ਾਰ", "10 ਹਜ਼ਾਰ"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 ਹਜ਼ਾਰ", "-1 ਹਜ਼ਾਰ"],
    ["-9999.12", "-10 ਹਜ਼ਾਰ", "-10 ਹਜ਼ਾਰ"],
    ["-9999.99", "-10 ਹਜ਼ਾਰ", "-10 ਹਜ਼ਾਰ"],
  ],
  "pl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tys.", "4,3 tysiąca"],
    ["54321", "54 tys.", "54 tysiące"],
    ["654321", "654 tys.", "654 tysiące"],
    ["7654321", "7,7 mln", "7,7 miliona"],
    ["87654321", "88 mln", "88 milionów"],
    ["987654321", "988 mln", "988 milionów"],
    ["1087654321", "1,1 mld", "1,1 miliarda"],
    ["11987654321", "12 mld", "12 miliardów"],
    ["129987654321", "130 mld", "130 miliardów"],
    ["1398987654321", "1,4 bln", "1,4 biliona"],
    ["14987987654321", "15 bln", "15 bilionów"],
    ["159876987654321", "160 bln", "160 bilionów"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tys.", "10 tysięcy"],
    ["99999", "100 tys.", "100 tysięcy"],
    ["999999", "1 mln", "1 milion"],
    ["9999999", "10 mln", "10 milionów"],
    ["99999999", "100 mln", "100 milionów"],
    ["9994", "10 tys.", "10 tysięcy"],
    ["99944", "100 tys.", "100 tysięcy"],
    ["999444", "999 tys.", "999 tysięcy"],
    ["9994444", "10 mln", "10 milionów"],
    ["999444444", "999 mln", "999 milionów"],
    ["9994444444", "10 mld", "10 miliardów"],
    ["1000000000000000", "1000 bln", "1000 bilionów"],
    ["10000000000000000", "10000 bln", "10000 bilionów"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 tys.", "-1 tysiąc"],
    ["-1001", "-1 tys.", "-1 tysiąc"],
    ["-1010", "-1 tys.", "-1 tysiąc"],
    ["-1100", "-1,1 tys.", "-1,1 tysiąca"],
    ["-2000", "-2 tys.", "-2 tysiące"],
    ["-2001", "-2 tys.", "-2 tysiące"],
    ["-2010", "-2 tys.", "-2 tysiące"],
    ["-2100", "-2,1 tys.", "-2,1 tysiąca"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 tys.", "-10 tysięcy"],
    ["-99999", "-100 tys.", "-100 tysięcy"],
    ["-999999", "-1 mln", "-1 milion"],
    ["-9999999", "-10 mln", "-10 milionów"],
    ["-9999999999999999", "-10000 bln", "-10000 bilionów"],
    ["1000", "1 tys.", "1 tysiąc"],
    ["1001", "1 tys.", "1 tysiąc"],
    ["1010", "1 tys.", "1 tysiąc"],
    ["1100", "1,1 tys.", "1,1 tysiąca"],
    ["2000", "2 tys.", "2 tysiące"],
    ["2001", "2 tys.", "2 tysiące"],
    ["2010", "2 tys.", "2 tysiące"],
    ["2100", "2,1 tys.", "2,1 tysiąca"],
    ["3000", "3 tys.", "3 tysiące"],
    ["3001", "3 tys.", "3 tysiące"],
    ["3010", "3 tys.", "3 tysiące"],
    ["3100", "3,1 tys.", "3,1 tysiąca"],
    ["4000", "4 tys.", "4 tysiące"],
    ["4001", "4 tys.", "4 tysiące"],
    ["4010", "4 tys.", "4 tysiące"],
    ["4100", "4,1 tys.", "4,1 tysiąca"],
    ["5000", "5 tys.", "5 tysięcy"],
    ["5001", "5 tys.", "5 tysięcy"],
    ["5010", "5 tys.", "5 tysięcy"],
    ["5100", "5,1 tys.", "5,1 tysiąca"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 tys.", "1 tysiąc"],
    ["9999.12", "10 tys.", "10 tysięcy"],
    ["9999.99", "10 tys.", "10 tysięcy"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 tys.", "-1 tysiąc"],
    ["-9999.12", "-10 tys.", "-10 tysięcy"],
    ["-9999.99", "-10 tys.", "-10 tysięcy"],
  ],
  "ps": [
    ["1", "۱", "۱"],
    ["21", "۲۱", "۲۱"],
    ["321", "۳۲۱", "۳۲۱"],
    ["4321", "۴٫۳K", "۴۳۲۱"],
    ["54321", "۵۴K", "۵۴۳۲۱"],
    ["654321", "۶۵۴K", "۶۵۴۳۲۱"],
    ["7654321", "۷٫۷M", "۷۶۵۴۳۲۱"],
    ["87654321", "۸۸M", "۸۷۶۵۴۳۲۱"],
    ["987654321", "۹۸۸M", "۹۸۷۶۵۴۳۲۱"],
    ["1087654321", "۱٫۱B", "۱٫۱G"],
    ["11987654321", "۱۲B", "۱۲G"],
    ["129987654321", "۱۳۰B", "۱۳۰G"],
    ["1398987654321", "۱٫۴T", "۱۳۹۹G"],
    ["14987987654321", "۱۵T", "۱۴۹۸۸G"],
    ["159876987654321", "۱۶۰T", "۱۵۹۸۷۷G"],
    ["9", "۹", "۹"],
    ["99", "۹۹", "۹۹"],
    ["999", "۹۹۹", "۹۹۹"],
    ["9999", "۱۰K", "۹۹۹۹"],
    ["99999", "۱۰۰K", "۹۹۹۹۹"],
    ["999999", "۱M", "۹۹۹۹۹۹"],
    ["9999999", "۱۰M", "۹۹۹۹۹۹۹"],
    ["99999999", "۱۰۰M", "۹۹۹۹۹۹۹۹"],
    ["9994", "۱۰K", "۹۹۹۴"],
    ["99944", "۱۰۰K", "۹۹۹۴۴"],
    ["999444", "۹۹۹K", "۹۹۹۴۴۴"],
    ["9994444", "۱۰M", "۹۹۹۴۴۴۴"],
    ["999444444", "۹۹۹M", "۹۹۹۴۴۴۴۴۴"],
    ["9994444444", "۱۰B", "۱۰G"],
    ["1000000000000000", "۱۰۰۰T", "۱۰۰۰۰۰۰G"],
    ["10000000000000000", "۱۰۰۰۰T", "۱۰۰۰۰۰۰۰G"],
    ["0", "۰", "۰"],
    ["-1", "‎-‎۱", "‎-‎۱"],
    ["-2", "‎-‎۲", "‎-‎۲"],
    ["-3", "‎-‎۳", "‎-‎۳"],
    ["-1000", "‎-‎۱K", "‎-‎۱۰۰۰"],
    ["-1001", "‎-‎۱K", "‎-‎۱۰۰۱"],
    ["-1010", "‎-‎۱K", "‎-‎۱۰۱۰"],
    ["-1100", "‎-‎۱٫۱K", "‎-‎۱۱۰۰"],
    ["-2000", "‎-‎۲K", "‎-‎۲۰۰۰"],
    ["-2001", "‎-‎۲K", "‎-‎۲۰۰۱"],
    ["-2010", "‎-‎۲K", "‎-‎۲۰۱۰"],
    ["-2100", "‎-‎۲٫۱K", "‎-‎۲۱۰۰"],
    ["-9", "‎-‎۹", "‎-‎۹"],
    ["-99", "‎-‎۹۹", "‎-‎۹۹"],
    ["-999", "‎-‎۹۹۹", "‎-‎۹۹۹"],
    ["-9999", "‎-‎۱۰K", "‎-‎۹۹۹۹"],
    ["-99999", "‎-‎۱۰۰K", "‎-‎۹۹۹۹۹"],
    ["-999999", "‎-‎۱M", "‎-‎۹۹۹۹۹۹"],
    ["-9999999", "‎-‎۱۰M", "‎-‎۹۹۹۹۹۹۹"],
    ["-9999999999999999", "‎-‎۱۰۰۰۰T", "‎-‎۱۰۰۰۰۰۰۰G"],
    ["1000", "۱K", "۱۰۰۰"],
    ["1001", "۱K", "۱۰۰۱"],
    ["1010", "۱K", "۱۰۱۰"],
    ["1100", "۱٫۱K", "۱۱۰۰"],
    ["2000", "۲K", "۲۰۰۰"],
    ["2001", "۲K", "۲۰۰۱"],
    ["2010", "۲K", "۲۰۱۰"],
    ["2100", "۲٫۱K", "۲۱۰۰"],
    ["3000", "۳K", "۳۰۰۰"],
    ["3001", "۳K", "۳۰۰۱"],
    ["3010", "۳K", "۳۰۱۰"],
    ["3100", "۳٫۱K", "۳۱۰۰"],
    ["4000", "۴K", "۴۰۰۰"],
    ["4001", "۴K", "۴۰۰۱"],
    ["4010", "۴K", "۴۰۱۰"],
    ["4100", "۴٫۱K", "۴۱۰۰"],
    ["5000", "۵K", "۵۰۰۰"],
    ["5001", "۵K", "۵۰۰۱"],
    ["5010", "۵K", "۵۰۱۰"],
    ["5100", "۵٫۱K", "۵۱۰۰"],
    ["0.001234", "۰٫۰۰۱۲", "۰٫۰۰۱۲"],
    ["0.01234", "۰٫۰۱۲", "۰٫۰۱۲"],
    ["0.1234", "۰٫۱۲", "۰٫۱۲"],
    ["0.99", "۰٫۹۹", "۰٫۹۹"],
    ["0.999", "۱", "۱"],
    ["9.12", "۹٫۱", "۹٫۱"],
    ["9.99", "۱۰", "۱۰"],
    ["99.12", "۹۹", "۹۹"],
    ["99.99", "۱۰۰", "۱۰۰"],
    ["999.12", "۹۹۹", "۹۹۹"],
    ["999.99", "۱K", "۱۰۰۰"],
    ["9999.12", "۱۰K", "۹۹۹۹"],
    ["9999.99", "۱۰K", "۱۰۰۰۰"],
    ["-0.12", "‎-‎۰٫۱۲", "‎-‎۰٫۱۲"],
    ["-0.99", "‎-‎۰٫۹۹", "‎-‎۰٫۹۹"],
    ["-9.12", "‎-‎۹٫۱", "‎-‎۹٫۱"],
    ["-9.99", "‎-‎۱۰", "‎-‎۱۰"],
    ["-999.12", "‎-‎۹۹۹", "‎-‎۹۹۹"],
    ["-999.99", "‎-‎۱K", "‎-‎۱۰۰۰"],
    ["-9999.12", "‎-‎۱۰K", "‎-‎۹۹۹۹"],
    ["-9999.99", "‎-‎۱۰K", "‎-‎۱۰۰۰۰"],
  ],
  "pt": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 mil", "4,3 mil"],
    ["54321", "54 mil", "54 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,7 mi", "7,7 milhões"],
    ["87654321", "88 mi", "88 milhões"],
    ["987654321", "988 mi", "988 milhões"],
    ["1087654321", "1,1 bi", "1,1 bilhão"],
    ["11987654321", "12 bi", "12 bilhões"],
    ["129987654321", "130 bi", "130 bilhões"],
    ["1398987654321", "1,4 tri", "1,4 trilhão"],
    ["14987987654321", "15 tri", "15 trilhões"],
    ["159876987654321", "160 tri", "160 trilhões"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 mi", "1 milhão"],
    ["9999999", "10 mi", "10 milhões"],
    ["99999999", "100 mi", "100 milhões"],
    ["9994", "10 mil", "10 mil"],
    ["99944", "100 mil", "100 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "10 mi", "10 milhões"],
    ["999444444", "999 mi", "999 milhões"],
    ["9994444444", "10 bi", "10 bilhões"],
    ["1000000000000000", "1000 tri", "1000 trilhões"],
    ["10000000000000000", "10000 tri", "10000 trilhões"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 mil", "-1 mil"],
    ["-1001", "-1 mil", "-1 mil"],
    ["-1010", "-1 mil", "-1 mil"],
    ["-1100", "-1,1 mil", "-1,1 mil"],
    ["-2000", "-2 mil", "-2 mil"],
    ["-2001", "-2 mil", "-2 mil"],
    ["-2010", "-2 mil", "-2 mil"],
    ["-2100", "-2,1 mil", "-2,1 mil"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 mil", "-10 mil"],
    ["-99999", "-100 mil", "-100 mil"],
    ["-999999", "-1 mi", "-1 milhão"],
    ["-9999999", "-10 mi", "-10 milhões"],
    ["-9999999999999999", "-10000 tri", "-10000 trilhões"],
    ["1000", "1 mil", "1 mil"],
    ["1001", "1 mil", "1 mil"],
    ["1010", "1 mil", "1 mil"],
    ["1100", "1,1 mil", "1,1 mil"],
    ["2000", "2 mil", "2 mil"],
    ["2001", "2 mil", "2 mil"],
    ["2010", "2 mil", "2 mil"],
    ["2100", "2,1 mil", "2,1 mil"],
    ["3000", "3 mil", "3 mil"],
    ["3001", "3 mil", "3 mil"],
    ["3010", "3 mil", "3 mil"],
    ["3100", "3,1 mil", "3,1 mil"],
    ["4000", "4 mil", "4 mil"],
    ["4001", "4 mil", "4 mil"],
    ["4010", "4 mil", "4 mil"],
    ["4100", "4,1 mil", "4,1 mil"],
    ["5000", "5 mil", "5 mil"],
    ["5001", "5 mil", "5 mil"],
    ["5010", "5 mil", "5 mil"],
    ["5100", "5,1 mil", "5,1 mil"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 mil", "1 mil"],
    ["9999.12", "10 mil", "10 mil"],
    ["9999.99", "10 mil", "10 mil"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 mil", "-1 mil"],
    ["-9999.12", "-10 mil", "-10 mil"],
    ["-9999.99", "-10 mil", "-10 mil"],
  ],
  "pt_BR": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 mil", "4,3 mil"],
    ["54321", "54 mil", "54 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,7 mi", "7,7 milhões"],
    ["87654321", "88 mi", "88 milhões"],
    ["987654321", "988 mi", "988 milhões"],
    ["1087654321", "1,1 bi", "1,1 bilhão"],
    ["11987654321", "12 bi", "12 bilhões"],
    ["129987654321", "130 bi", "130 bilhões"],
    ["1398987654321", "1,4 tri", "1,4 trilhão"],
    ["14987987654321", "15 tri", "15 trilhões"],
    ["159876987654321", "160 tri", "160 trilhões"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 mi", "1 milhão"],
    ["9999999", "10 mi", "10 milhões"],
    ["99999999", "100 mi", "100 milhões"],
    ["9994", "10 mil", "10 mil"],
    ["99944", "100 mil", "100 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "10 mi", "10 milhões"],
    ["999444444", "999 mi", "999 milhões"],
    ["9994444444", "10 bi", "10 bilhões"],
    ["1000000000000000", "1000 tri", "1000 trilhões"],
    ["10000000000000000", "10000 tri", "10000 trilhões"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 mil", "-1 mil"],
    ["-1001", "-1 mil", "-1 mil"],
    ["-1010", "-1 mil", "-1 mil"],
    ["-1100", "-1,1 mil", "-1,1 mil"],
    ["-2000", "-2 mil", "-2 mil"],
    ["-2001", "-2 mil", "-2 mil"],
    ["-2010", "-2 mil", "-2 mil"],
    ["-2100", "-2,1 mil", "-2,1 mil"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 mil", "-10 mil"],
    ["-99999", "-100 mil", "-100 mil"],
    ["-999999", "-1 mi", "-1 milhão"],
    ["-9999999", "-10 mi", "-10 milhões"],
    ["-9999999999999999", "-10000 tri", "-10000 trilhões"],
    ["1000", "1 mil", "1 mil"],
    ["1001", "1 mil", "1 mil"],
    ["1010", "1 mil", "1 mil"],
    ["1100", "1,1 mil", "1,1 mil"],
    ["2000", "2 mil", "2 mil"],
    ["2001", "2 mil", "2 mil"],
    ["2010", "2 mil", "2 mil"],
    ["2100", "2,1 mil", "2,1 mil"],
    ["3000", "3 mil", "3 mil"],
    ["3001", "3 mil", "3 mil"],
    ["3010", "3 mil", "3 mil"],
    ["3100", "3,1 mil", "3,1 mil"],
    ["4000", "4 mil", "4 mil"],
    ["4001", "4 mil", "4 mil"],
    ["4010", "4 mil", "4 mil"],
    ["4100", "4,1 mil", "4,1 mil"],
    ["5000", "5 mil", "5 mil"],
    ["5001", "5 mil", "5 mil"],
    ["5010", "5 mil", "5 mil"],
    ["5100", "5,1 mil", "5,1 mil"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 mil", "1 mil"],
    ["9999.12", "10 mil", "10 mil"],
    ["9999.99", "10 mil", "10 mil"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 mil", "-1 mil"],
    ["-9999.12", "-10 mil", "-10 mil"],
    ["-9999.99", "-10 mil", "-10 mil"],
  ],
  "pt_PT": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 mil", "4,3 mil"],
    ["54321", "54 mil", "54 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,7 M", "7,7 milhões"],
    ["87654321", "88 M", "88 milhões"],
    ["987654321", "988 M", "988 milhões"],
    ["1087654321", "1,1 mM", "1,1 mil milhões"],
    ["11987654321", "12 mM", "12 mil milhões"],
    ["129987654321", "130 mM", "130 mil milhões"],
    ["1398987654321", "1,4 Bi", "1,4 biliões"],
    ["14987987654321", "15 Bi", "15 biliões"],
    ["159876987654321", "160 Bi", "160 biliões"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 M", "1 milhão"],
    ["9999999", "10 M", "10 milhões"],
    ["99999999", "100 M", "100 milhões"],
    ["9994", "10 mil", "10 mil"],
    ["99944", "100 mil", "100 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "10 M", "10 milhões"],
    ["999444444", "999 M", "999 milhões"],
    ["9994444444", "10 mM", "10 mil milhões"],
    ["1000000000000000", "1000 Bi", "1000 biliões"],
    ["10000000000000000", "10000 Bi", "10000 biliões"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 mil", "-1 mil"],
    ["-1001", "-1 mil", "-1 mil"],
    ["-1010", "-1 mil", "-1 mil"],
    ["-1100", "-1,1 mil", "-1,1 mil"],
    ["-2000", "-2 mil", "-2 mil"],
    ["-2001", "-2 mil", "-2 mil"],
    ["-2010", "-2 mil", "-2 mil"],
    ["-2100", "-2,1 mil", "-2,1 mil"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 mil", "-10 mil"],
    ["-99999", "-100 mil", "-100 mil"],
    ["-999999", "-1 M", "-1 milhão"],
    ["-9999999", "-10 M", "-10 milhões"],
    ["-9999999999999999", "-10000 Bi", "-10000 biliões"],
    ["1000", "1 mil", "1 mil"],
    ["1001", "1 mil", "1 mil"],
    ["1010", "1 mil", "1 mil"],
    ["1100", "1,1 mil", "1,1 mil"],
    ["2000", "2 mil", "2 mil"],
    ["2001", "2 mil", "2 mil"],
    ["2010", "2 mil", "2 mil"],
    ["2100", "2,1 mil", "2,1 mil"],
    ["3000", "3 mil", "3 mil"],
    ["3001", "3 mil", "3 mil"],
    ["3010", "3 mil", "3 mil"],
    ["3100", "3,1 mil", "3,1 mil"],
    ["4000", "4 mil", "4 mil"],
    ["4001", "4 mil", "4 mil"],
    ["4010", "4 mil", "4 mil"],
    ["4100", "4,1 mil", "4,1 mil"],
    ["5000", "5 mil", "5 mil"],
    ["5001", "5 mil", "5 mil"],
    ["5010", "5 mil", "5 mil"],
    ["5100", "5,1 mil", "5,1 mil"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 mil", "1 mil"],
    ["9999.12", "10 mil", "10 mil"],
    ["9999.99", "10 mil", "10 mil"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 mil", "-1 mil"],
    ["-9999.12", "-10 mil", "-10 mil"],
    ["-9999.99", "-10 mil", "-10 mil"],
  ],
  "ro": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 K", "4,3 mii"],
    ["54321", "54 K", "54 de mii"],
    ["654321", "654 K", "654 de mii"],
    ["7654321", "7,7 mil.", "7,7 milioane"],
    ["87654321", "88 mil.", "88 de milioane"],
    ["987654321", "988 mil.", "988 de milioane"],
    ["1087654321", "1,1 mld.", "1,1 miliarde"],
    ["11987654321", "12 mld.", "12 miliarde"],
    ["129987654321", "130 mld.", "130 de miliarde"],
    ["1398987654321", "1,4 tril.", "1,4 trilioane"],
    ["14987987654321", "15 tril.", "15 trilioane"],
    ["159876987654321", "160 tril.", "160 de trilioane"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 K", "10 mii"],
    ["99999", "100 K", "100 de mii"],
    ["999999", "1 mil.", "1 milion"],
    ["9999999", "10 mil.", "10 milioane"],
    ["99999999", "100 mil.", "100 de milioane"],
    ["9994", "10 K", "10 mii"],
    ["99944", "100 K", "100 de mii"],
    ["999444", "999 K", "999 de mii"],
    ["9994444", "10 mil.", "10 milioane"],
    ["999444444", "999 mil.", "999 de milioane"],
    ["9994444444", "10 mld.", "10 miliarde"],
    ["1000000000000000", "1000 tril.", "1000 de trilioane"],
    ["10000000000000000", "10000 tril.", "10000 de trilioane"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 K", "-1 mie"],
    ["-1001", "-1 K", "-1 mie"],
    ["-1010", "-1 K", "-1 mie"],
    ["-1100", "-1,1 K", "-1,1 mii"],
    ["-2000", "-2 K", "-2 mii"],
    ["-2001", "-2 K", "-2 mii"],
    ["-2010", "-2 K", "-2 mii"],
    ["-2100", "-2,1 K", "-2,1 mii"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 K", "-10 mii"],
    ["-99999", "-100 K", "-100 de mii"],
    ["-999999", "-1 mil.", "-1 milion"],
    ["-9999999", "-10 mil.", "-10 milioane"],
    ["-9999999999999999", "-10000 tril.", "-10000 de trilioane"],
    ["1000", "1 K", "1 mie"],
    ["1001", "1 K", "1 mie"],
    ["1010", "1 K", "1 mie"],
    ["1100", "1,1 K", "1,1 mii"],
    ["2000", "2 K", "2 mii"],
    ["2001", "2 K", "2 mii"],
    ["2010", "2 K", "2 mii"],
    ["2100", "2,1 K", "2,1 mii"],
    ["3000", "3 K", "3 mii"],
    ["3001", "3 K", "3 mii"],
    ["3010", "3 K", "3 mii"],
    ["3100", "3,1 K", "3,1 mii"],
    ["4000", "4 K", "4 mii"],
    ["4001", "4 K", "4 mii"],
    ["4010", "4 K", "4 mii"],
    ["4100", "4,1 K", "4,1 mii"],
    ["5000", "5 K", "5 mii"],
    ["5001", "5 K", "5 mii"],
    ["5010", "5 K", "5 mii"],
    ["5100", "5,1 K", "5,1 mii"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 K", "1 mie"],
    ["9999.12", "10 K", "10 mii"],
    ["9999.99", "10 K", "10 mii"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 K", "-1 mie"],
    ["-9999.12", "-10 K", "-10 mii"],
    ["-9999.99", "-10 K", "-10 mii"],
  ],
  "ru": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 тыс.", "4,3 тысячи"],
    ["54321", "54 тыс.", "54 тысячи"],
    ["654321", "654 тыс.", "654 тысячи"],
    ["7654321", "7,7 млн", "7,7 миллиона"],
    ["87654321", "88 млн", "88 миллионов"],
    ["987654321", "988 млн", "988 миллионов"],
    ["1087654321", "1,1 млрд", "1,1 миллиарда"],
    ["11987654321", "12 млрд", "12 миллиардов"],
    ["129987654321", "130 млрд", "130 миллиардов"],
    ["1398987654321", "1,4 трлн", "1,4 триллиона"],
    ["14987987654321", "15 трлн", "15 триллионов"],
    ["159876987654321", "160 трлн", "160 триллионов"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 тыс.", "10 тысяч"],
    ["99999", "100 тыс.", "100 тысяч"],
    ["999999", "1 млн", "1 миллион"],
    ["9999999", "10 млн", "10 миллионов"],
    ["99999999", "100 млн", "100 миллионов"],
    ["9994", "10 тыс.", "10 тысяч"],
    ["99944", "100 тыс.", "100 тысяч"],
    ["999444", "999 тыс.", "999 тысяч"],
    ["9994444", "10 млн", "10 миллионов"],
    ["999444444", "999 млн", "999 миллионов"],
    ["9994444444", "10 млрд", "10 миллиардов"],
    ["1000000000000000", "1000 трлн", "1000 триллионов"],
    ["10000000000000000", "10000 трлн", "10000 триллионов"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 тыс.", "-1 тысяча"],
    ["-1001", "-1 тыс.", "-1 тысяча"],
    ["-1010", "-1 тыс.", "-1 тысяча"],
    ["-1100", "-1,1 тыс.", "-1,1 тысячи"],
    ["-2000", "-2 тыс.", "-2 тысячи"],
    ["-2001", "-2 тыс.", "-2 тысячи"],
    ["-2010", "-2 тыс.", "-2 тысячи"],
    ["-2100", "-2,1 тыс.", "-2,1 тысячи"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 тыс.", "-10 тысяч"],
    ["-99999", "-100 тыс.", "-100 тысяч"],
    ["-999999", "-1 млн", "-1 миллион"],
    ["-9999999", "-10 млн", "-10 миллионов"],
    ["-9999999999999999", "-10000 трлн", "-10000 триллионов"],
    ["1000", "1 тыс.", "1 тысяча"],
    ["1001", "1 тыс.", "1 тысяча"],
    ["1010", "1 тыс.", "1 тысяча"],
    ["1100", "1,1 тыс.", "1,1 тысячи"],
    ["2000", "2 тыс.", "2 тысячи"],
    ["2001", "2 тыс.", "2 тысячи"],
    ["2010", "2 тыс.", "2 тысячи"],
    ["2100", "2,1 тыс.", "2,1 тысячи"],
    ["3000", "3 тыс.", "3 тысячи"],
    ["3001", "3 тыс.", "3 тысячи"],
    ["3010", "3 тыс.", "3 тысячи"],
    ["3100", "3,1 тыс.", "3,1 тысячи"],
    ["4000", "4 тыс.", "4 тысячи"],
    ["4001", "4 тыс.", "4 тысячи"],
    ["4010", "4 тыс.", "4 тысячи"],
    ["4100", "4,1 тыс.", "4,1 тысячи"],
    ["5000", "5 тыс.", "5 тысяч"],
    ["5001", "5 тыс.", "5 тысяч"],
    ["5010", "5 тыс.", "5 тысяч"],
    ["5100", "5,1 тыс.", "5,1 тысячи"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 тыс.", "1 тысяча"],
    ["9999.12", "10 тыс.", "10 тысяч"],
    ["9999.99", "10 тыс.", "10 тысяч"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 тыс.", "-1 тысяча"],
    ["-9999.12", "-10 тыс.", "-10 тысяч"],
    ["-9999.99", "-10 тыс.", "-10 тысяч"],
  ],
  "si": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "ද4.3", "දහස 4.3"],
    ["54321", "ද54", "දහස 54"],
    ["654321", "ද654", "දහස 654"],
    ["7654321", "මි7.7", "මිලියන 7.7"],
    ["87654321", "මි88", "මිලියන 88"],
    ["987654321", "මි988", "මිලියන 988"],
    ["1087654321", "බි1.1", "බිලියන 1.1"],
    ["11987654321", "බි12", "බිලියන 12"],
    ["129987654321", "බි130", "බිලියන 130"],
    ["1398987654321", "ට්‍රි1.4", "ට්‍රිලියන 1.4"],
    ["14987987654321", "ට්‍රි15", "ට්‍රිලියන 15"],
    ["159876987654321", "ට්‍රි160", "ට්‍රිලියන 160"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "ද10", "දහස 10"],
    ["99999", "ද100", "දහස 100"],
    ["999999", "මි1", "මිලියන 1"],
    ["9999999", "මි10", "මිලියන 10"],
    ["99999999", "මි100", "මිලියන 100"],
    ["9994", "ද10", "දහස 10"],
    ["99944", "ද100", "දහස 100"],
    ["999444", "ද999", "දහස 999"],
    ["9994444", "මි10", "මිලියන 10"],
    ["999444444", "මි999", "මිලියන 999"],
    ["9994444444", "බි10", "බිලියන 10"],
    ["1000000000000000", "ට්‍රි1000", "ට්‍රිලියන 1000"],
    ["10000000000000000", "ට්‍රි10000", "ට්‍රිලියන 10000"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-ද1", "-දහස 1"],
    ["-1001", "-ද1", "-දහස 1"],
    ["-1010", "-ද1", "-දහස 1"],
    ["-1100", "-ද1.1", "-දහස 1.1"],
    ["-2000", "-ද2", "-දහස 2"],
    ["-2001", "-ද2", "-දහස 2"],
    ["-2010", "-ද2", "-දහස 2"],
    ["-2100", "-ද2.1", "-දහස 2.1"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-ද10", "-දහස 10"],
    ["-99999", "-ද100", "-දහස 100"],
    ["-999999", "-මි1", "-මිලියන 1"],
    ["-9999999", "-මි10", "-මිලියන 10"],
    ["-9999999999999999", "-ට්‍රි10000", "-ට්‍රිලියන 10000"],
    ["1000", "ද1", "දහස 1"],
    ["1001", "ද1", "දහස 1"],
    ["1010", "ද1", "දහස 1"],
    ["1100", "ද1.1", "දහස 1.1"],
    ["2000", "ද2", "දහස 2"],
    ["2001", "ද2", "දහස 2"],
    ["2010", "ද2", "දහස 2"],
    ["2100", "ද2.1", "දහස 2.1"],
    ["3000", "ද3", "දහස 3"],
    ["3001", "ද3", "දහස 3"],
    ["3010", "ද3", "දහස 3"],
    ["3100", "ද3.1", "දහස 3.1"],
    ["4000", "ද4", "දහස 4"],
    ["4001", "ද4", "දහස 4"],
    ["4010", "ද4", "දහස 4"],
    ["4100", "ද4.1", "දහස 4.1"],
    ["5000", "ද5", "දහස 5"],
    ["5001", "ද5", "දහස 5"],
    ["5010", "ද5", "දහස 5"],
    ["5100", "ද5.1", "දහස 5.1"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "ද1", "දහස 1"],
    ["9999.12", "ද10", "දහස 10"],
    ["9999.99", "ද10", "දහස 10"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-ද1", "-දහස 1"],
    ["-9999.12", "-ද10", "-දහස 10"],
    ["-9999.99", "-ද10", "-දහස 10"],
  ],
  "sk": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tis.", "4,3 tisíca"],
    ["54321", "54 tis.", "54 tisíc"],
    ["654321", "654 tis.", "654 tisíc"],
    ["7654321", "7,7 mil.", "7,7 milióna"],
    ["87654321", "88 mil.", "88 miliónov"],
    ["987654321", "988 mil.", "988 miliónov"],
    ["1087654321", "1,1 mld.", "1,1 miliardy"],
    ["11987654321", "12 mld.", "12 miliárd"],
    ["129987654321", "130 mld.", "130 miliárd"],
    ["1398987654321", "1,4 bil.", "1,4 bilióna"],
    ["14987987654321", "15 bil.", "15 biliónov"],
    ["159876987654321", "160 bil.", "160 biliónov"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tis.", "10 tisíc"],
    ["99999", "100 tis.", "100 tisíc"],
    ["999999", "1 mil.", "1 milión"],
    ["9999999", "10 mil.", "10 miliónov"],
    ["99999999", "100 mil.", "100 miliónov"],
    ["9994", "10 tis.", "10 tisíc"],
    ["99944", "100 tis.", "100 tisíc"],
    ["999444", "999 tis.", "999 tisíc"],
    ["9994444", "10 mil.", "10 miliónov"],
    ["999444444", "999 mil.", "999 miliónov"],
    ["9994444444", "10 mld.", "10 miliárd"],
    ["1000000000000000", "1000 bil.", "1000 biliónov"],
    ["10000000000000000", "10000 bil.", "10000 biliónov"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 tis.", "-1 tisíc"],
    ["-1001", "-1 tis.", "-1 tisíc"],
    ["-1010", "-1 tis.", "-1 tisíc"],
    ["-1100", "-1,1 tis.", "-1,1 tisíca"],
    ["-2000", "-2 tis.", "-2 tisíce"],
    ["-2001", "-2 tis.", "-2 tisíce"],
    ["-2010", "-2 tis.", "-2 tisíce"],
    ["-2100", "-2,1 tis.", "-2,1 tisíca"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 tis.", "-10 tisíc"],
    ["-99999", "-100 tis.", "-100 tisíc"],
    ["-999999", "-1 mil.", "-1 milión"],
    ["-9999999", "-10 mil.", "-10 miliónov"],
    ["-9999999999999999", "-10000 bil.", "-10000 biliónov"],
    ["1000", "1 tis.", "1 tisíc"],
    ["1001", "1 tis.", "1 tisíc"],
    ["1010", "1 tis.", "1 tisíc"],
    ["1100", "1,1 tis.", "1,1 tisíca"],
    ["2000", "2 tis.", "2 tisíce"],
    ["2001", "2 tis.", "2 tisíce"],
    ["2010", "2 tis.", "2 tisíce"],
    ["2100", "2,1 tis.", "2,1 tisíca"],
    ["3000", "3 tis.", "3 tisíce"],
    ["3001", "3 tis.", "3 tisíce"],
    ["3010", "3 tis.", "3 tisíce"],
    ["3100", "3,1 tis.", "3,1 tisíca"],
    ["4000", "4 tis.", "4 tisíce"],
    ["4001", "4 tis.", "4 tisíce"],
    ["4010", "4 tis.", "4 tisíce"],
    ["4100", "4,1 tis.", "4,1 tisíca"],
    ["5000", "5 tis.", "5 tisíc"],
    ["5001", "5 tis.", "5 tisíc"],
    ["5010", "5 tis.", "5 tisíc"],
    ["5100", "5,1 tis.", "5,1 tisíca"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 tis.", "1 tisíc"],
    ["9999.12", "10 tis.", "10 tisíc"],
    ["9999.99", "10 tis.", "10 tisíc"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 tis.", "-1 tisíc"],
    ["-9999.12", "-10 tis.", "-10 tisíc"],
    ["-9999.99", "-10 tis.", "-10 tisíc"],
  ],
  "sl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tis.", "4,3 tisoč"],
    ["54321", "54 tis.", "54 tisoč"],
    ["654321", "654 tis.", "654 tisoč"],
    ["7654321", "7,7 mio.", "7,7 milijone"],
    ["87654321", "88 mio.", "88 milijonov"],
    ["987654321", "988 mio.", "988 milijonov"],
    ["1087654321", "1,1 mrd.", "1,1 milijarde"],
    ["11987654321", "12 mrd.", "12 milijard"],
    ["129987654321", "130 mrd.", "130 milijard"],
    ["1398987654321", "1,4 bil.", "1,4 bilijoni"],
    ["14987987654321", "15 bil.", "15 bilijonov"],
    ["159876987654321", "160 bil.", "160 bilijonov"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tis.", "10 tisoč"],
    ["99999", "100 tis.", "100 tisoč"],
    ["999999", "1 mio.", "1 milijon"],
    ["9999999", "10 mio.", "10 milijonov"],
    ["99999999", "100 mio.", "100 milijonov"],
    ["9994", "10 tis.", "10 tisoč"],
    ["99944", "100 tis.", "100 tisoč"],
    ["999444", "999 tis.", "999 tisoč"],
    ["9994444", "10 mio.", "10 milijonov"],
    ["999444444", "999 mio.", "999 milijonov"],
    ["9994444444", "10 mrd.", "10 milijard"],
    ["1000000000000000", "1000 bil.", "1000 bilijonov"],
    ["10000000000000000", "10000 bil.", "10000 bilijonov"],
    ["0", "0", "0"],
    ["-1", "−1", "−1"],
    ["-2", "−2", "−2"],
    ["-3", "−3", "−3"],
    ["-1000", "−1 tis.", "−1 tisoč"],
    ["-1001", "−1 tis.", "−1 tisoč"],
    ["-1010", "−1 tis.", "−1 tisoč"],
    ["-1100", "−1,1 tis.", "−1,1 tisoč"],
    ["-2000", "−2 tis.", "−2 tisoč"],
    ["-2001", "−2 tis.", "−2 tisoč"],
    ["-2010", "−2 tis.", "−2 tisoč"],
    ["-2100", "−2,1 tis.", "−2,1 tisoč"],
    ["-9", "−9", "−9"],
    ["-99", "−99", "−99"],
    ["-999", "−999", "−999"],
    ["-9999", "−10 tis.", "−10 tisoč"],
    ["-99999", "−100 tis.", "−100 tisoč"],
    ["-999999", "−1 mio.", "−1 milijon"],
    ["-9999999", "−10 mio.", "−10 milijonov"],
    ["-9999999999999999", "−10000 bil.", "−10000 bilijonov"],
    ["1000", "1 tis.", "1 tisoč"],
    ["1001", "1 tis.", "1 tisoč"],
    ["1010", "1 tis.", "1 tisoč"],
    ["1100", "1,1 tis.", "1,1 tisoč"],
    ["2000", "2 tis.", "2 tisoč"],
    ["2001", "2 tis.", "2 tisoč"],
    ["2010", "2 tis.", "2 tisoč"],
    ["2100", "2,1 tis.", "2,1 tisoč"],
    ["3000", "3 tis.", "3 tisoč"],
    ["3001", "3 tis.", "3 tisoč"],
    ["3010", "3 tis.", "3 tisoč"],
    ["3100", "3,1 tis.", "3,1 tisoč"],
    ["4000", "4 tis.", "4 tisoč"],
    ["4001", "4 tis.", "4 tisoč"],
    ["4010", "4 tis.", "4 tisoč"],
    ["4100", "4,1 tis.", "4,1 tisoč"],
    ["5000", "5 tis.", "5 tisoč"],
    ["5001", "5 tis.", "5 tisoč"],
    ["5010", "5 tis.", "5 tisoč"],
    ["5100", "5,1 tis.", "5,1 tisoč"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 tis.", "1 tisoč"],
    ["9999.12", "10 tis.", "10 tisoč"],
    ["9999.99", "10 tis.", "10 tisoč"],
    ["-0.12", "−0,12", "−0,12"],
    ["-0.99", "−0,99", "−0,99"],
    ["-9.12", "−9,1", "−9,1"],
    ["-9.99", "−10", "−10"],
    ["-999.12", "−999", "−999"],
    ["-999.99", "−1 tis.", "−1 tisoč"],
    ["-9999.12", "−10 tis.", "−10 tisoč"],
    ["-9999.99", "−10 tis.", "−10 tisoč"],
  ],
  "sq": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 mijë", "4,3 mijë"],
    ["54321", "54 mijë", "54 mijë"],
    ["654321", "654 mijë", "654 mijë"],
    ["7654321", "7,7 mln", "7,7 milion"],
    ["87654321", "88 mln", "88 milion"],
    ["987654321", "988 mln", "988 milion"],
    ["1087654321", "1,1 mld", "1,1 miliard"],
    ["11987654321", "12 mld", "12 miliard"],
    ["129987654321", "130 mld", "130 miliard"],
    ["1398987654321", "1,4 bln", "1,4 bilion"],
    ["14987987654321", "15 bln", "15 bilion"],
    ["159876987654321", "160 bln", "160 bilion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mijë", "10 mijë"],
    ["99999", "100 mijë", "100 mijë"],
    ["999999", "1 mln", "1 milion"],
    ["9999999", "10 mln", "10 milion"],
    ["99999999", "100 mln", "100 milion"],
    ["9994", "10 mijë", "10 mijë"],
    ["99944", "100 mijë", "100 mijë"],
    ["999444", "999 mijë", "999 mijë"],
    ["9994444", "10 mln", "10 milion"],
    ["999444444", "999 mln", "999 milion"],
    ["9994444444", "10 mld", "10 miliard"],
    ["1000000000000000", "1000 bln", "1000 bilion"],
    ["10000000000000000", "10000 bln", "10000 bilion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 mijë", "-1 mijë"],
    ["-1001", "-1 mijë", "-1 mijë"],
    ["-1010", "-1 mijë", "-1 mijë"],
    ["-1100", "-1,1 mijë", "-1,1 mijë"],
    ["-2000", "-2 mijë", "-2 mijë"],
    ["-2001", "-2 mijë", "-2 mijë"],
    ["-2010", "-2 mijë", "-2 mijë"],
    ["-2100", "-2,1 mijë", "-2,1 mijë"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 mijë", "-10 mijë"],
    ["-99999", "-100 mijë", "-100 mijë"],
    ["-999999", "-1 mln", "-1 milion"],
    ["-9999999", "-10 mln", "-10 milion"],
    ["-9999999999999999", "-10000 bln", "-10000 bilion"],
    ["1000", "1 mijë", "1 mijë"],
    ["1001", "1 mijë", "1 mijë"],
    ["1010", "1 mijë", "1 mijë"],
    ["1100", "1,1 mijë", "1,1 mijë"],
    ["2000", "2 mijë", "2 mijë"],
    ["2001", "2 mijë", "2 mijë"],
    ["2010", "2 mijë", "2 mijë"],
    ["2100", "2,1 mijë", "2,1 mijë"],
    ["3000", "3 mijë", "3 mijë"],
    ["3001", "3 mijë", "3 mijë"],
    ["3010", "3 mijë", "3 mijë"],
    ["3100", "3,1 mijë", "3,1 mijë"],
    ["4000", "4 mijë", "4 mijë"],
    ["4001", "4 mijë", "4 mijë"],
    ["4010", "4 mijë", "4 mijë"],
    ["4100", "4,1 mijë", "4,1 mijë"],
    ["5000", "5 mijë", "5 mijë"],
    ["5001", "5 mijë", "5 mijë"],
    ["5010", "5 mijë", "5 mijë"],
    ["5100", "5,1 mijë", "5,1 mijë"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 mijë", "1 mijë"],
    ["9999.12", "10 mijë", "10 mijë"],
    ["9999.99", "10 mijë", "10 mijë"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 mijë", "-1 mijë"],
    ["-9999.12", "-10 mijë", "-10 mijë"],
    ["-9999.99", "-10 mijë", "-10 mijë"],
  ],
  "sr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 хиљ.", "4,3 хиљаде"],
    ["54321", "54 хиљ.", "54 хиљаде"],
    ["654321", "654 хиљ.", "654 хиљаде"],
    ["7654321", "7,7 мил.", "7,7 милиона"],
    ["87654321", "88 мил.", "88 милиона"],
    ["987654321", "988 мил.", "988 милиона"],
    ["1087654321", "1,1 млрд.", "1,1 милијарда"],
    ["11987654321", "12 млрд.", "12 милијарди"],
    ["129987654321", "130 млрд.", "130 милијарди"],
    ["1398987654321", "1,4 бил.", "1,4 билиона"],
    ["14987987654321", "15 бил.", "15 билиона"],
    ["159876987654321", "160 бил.", "160 билиона"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 хиљ.", "10 хиљада"],
    ["99999", "100 хиљ.", "100 хиљада"],
    ["999999", "1 мил.", "1 милион"],
    ["9999999", "10 мил.", "10 милиона"],
    ["99999999", "100 мил.", "100 милиона"],
    ["9994", "10 хиљ.", "10 хиљада"],
    ["99944", "100 хиљ.", "100 хиљада"],
    ["999444", "999 хиљ.", "999 хиљада"],
    ["9994444", "10 мил.", "10 милиона"],
    ["999444444", "999 мил.", "999 милиона"],
    ["9994444444", "10 млрд.", "10 милијарди"],
    ["1000000000000000", "1000 бил.", "1000 билиона"],
    ["10000000000000000", "10000 бил.", "10000 билиона"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 хиљ.", "-1 хиљада"],
    ["-1001", "-1 хиљ.", "-1 хиљада"],
    ["-1010", "-1 хиљ.", "-1 хиљада"],
    ["-1100", "-1,1 хиљ.", "-1,1 хиљада"],
    ["-2000", "-2 хиљ.", "-2 хиљаде"],
    ["-2001", "-2 хиљ.", "-2 хиљаде"],
    ["-2010", "-2 хиљ.", "-2 хиљаде"],
    ["-2100", "-2,1 хиљ.", "-2,1 хиљада"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 хиљ.", "-10 хиљада"],
    ["-99999", "-100 хиљ.", "-100 хиљада"],
    ["-999999", "-1 мил.", "-1 милион"],
    ["-9999999", "-10 мил.", "-10 милиона"],
    ["-9999999999999999", "-10000 бил.", "-10000 билиона"],
    ["1000", "1 хиљ.", "1 хиљада"],
    ["1001", "1 хиљ.", "1 хиљада"],
    ["1010", "1 хиљ.", "1 хиљада"],
    ["1100", "1,1 хиљ.", "1,1 хиљада"],
    ["2000", "2 хиљ.", "2 хиљаде"],
    ["2001", "2 хиљ.", "2 хиљаде"],
    ["2010", "2 хиљ.", "2 хиљаде"],
    ["2100", "2,1 хиљ.", "2,1 хиљада"],
    ["3000", "3 хиљ.", "3 хиљаде"],
    ["3001", "3 хиљ.", "3 хиљаде"],
    ["3010", "3 хиљ.", "3 хиљаде"],
    ["3100", "3,1 хиљ.", "3,1 хиљада"],
    ["4000", "4 хиљ.", "4 хиљаде"],
    ["4001", "4 хиљ.", "4 хиљаде"],
    ["4010", "4 хиљ.", "4 хиљаде"],
    ["4100", "4,1 хиљ.", "4,1 хиљада"],
    ["5000", "5 хиљ.", "5 хиљада"],
    ["5001", "5 хиљ.", "5 хиљада"],
    ["5010", "5 хиљ.", "5 хиљада"],
    ["5100", "5,1 хиљ.", "5,1 хиљада"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 хиљ.", "1 хиљада"],
    ["9999.12", "10 хиљ.", "10 хиљада"],
    ["9999.99", "10 хиљ.", "10 хиљада"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 хиљ.", "-1 хиљада"],
    ["-9999.12", "-10 хиљ.", "-10 хиљада"],
    ["-9999.99", "-10 хиљ.", "-10 хиљада"],
  ],
  "sr_Latn": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 hilj.", "4,3 hiljade"],
    ["54321", "54 hilj.", "54 hiljade"],
    ["654321", "654 hilj.", "654 hiljade"],
    ["7654321", "7,7 mil.", "7,7 miliona"],
    ["87654321", "88 mil.", "88 miliona"],
    ["987654321", "988 mil.", "988 miliona"],
    ["1087654321", "1,1 mlrd.", "1,1 milijarda"],
    ["11987654321", "12 mlrd.", "12 milijardi"],
    ["129987654321", "130 mlrd.", "130 milijardi"],
    ["1398987654321", "1,4 bil.", "1,4 biliona"],
    ["14987987654321", "15 bil.", "15 biliona"],
    ["159876987654321", "160 bil.", "160 biliona"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 hilj.", "10 hiljada"],
    ["99999", "100 hilj.", "100 hiljada"],
    ["999999", "1 mil.", "1 milion"],
    ["9999999", "10 mil.", "10 miliona"],
    ["99999999", "100 mil.", "100 miliona"],
    ["9994", "10 hilj.", "10 hiljada"],
    ["99944", "100 hilj.", "100 hiljada"],
    ["999444", "999 hilj.", "999 hiljada"],
    ["9994444", "10 mil.", "10 miliona"],
    ["999444444", "999 mil.", "999 miliona"],
    ["9994444444", "10 mlrd.", "10 milijardi"],
    ["1000000000000000", "1000 bil.", "1000 biliona"],
    ["10000000000000000", "10000 bil.", "10000 biliona"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 hilj.", "-1 hiljada"],
    ["-1001", "-1 hilj.", "-1 hiljada"],
    ["-1010", "-1 hilj.", "-1 hiljada"],
    ["-1100", "-1,1 hilj.", "-1,1 hiljada"],
    ["-2000", "-2 hilj.", "-2 hiljade"],
    ["-2001", "-2 hilj.", "-2 hiljade"],
    ["-2010", "-2 hilj.", "-2 hiljade"],
    ["-2100", "-2,1 hilj.", "-2,1 hiljada"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 hilj.", "-10 hiljada"],
    ["-99999", "-100 hilj.", "-100 hiljada"],
    ["-999999", "-1 mil.", "-1 milion"],
    ["-9999999", "-10 mil.", "-10 miliona"],
    ["-9999999999999999", "-10000 bil.", "-10000 biliona"],
    ["1000", "1 hilj.", "1 hiljada"],
    ["1001", "1 hilj.", "1 hiljada"],
    ["1010", "1 hilj.", "1 hiljada"],
    ["1100", "1,1 hilj.", "1,1 hiljada"],
    ["2000", "2 hilj.", "2 hiljade"],
    ["2001", "2 hilj.", "2 hiljade"],
    ["2010", "2 hilj.", "2 hiljade"],
    ["2100", "2,1 hilj.", "2,1 hiljada"],
    ["3000", "3 hilj.", "3 hiljade"],
    ["3001", "3 hilj.", "3 hiljade"],
    ["3010", "3 hilj.", "3 hiljade"],
    ["3100", "3,1 hilj.", "3,1 hiljada"],
    ["4000", "4 hilj.", "4 hiljade"],
    ["4001", "4 hilj.", "4 hiljade"],
    ["4010", "4 hilj.", "4 hiljade"],
    ["4100", "4,1 hilj.", "4,1 hiljada"],
    ["5000", "5 hilj.", "5 hiljada"],
    ["5001", "5 hilj.", "5 hiljada"],
    ["5010", "5 hilj.", "5 hiljada"],
    ["5100", "5,1 hilj.", "5,1 hiljada"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 hilj.", "1 hiljada"],
    ["9999.12", "10 hilj.", "10 hiljada"],
    ["9999.99", "10 hilj.", "10 hiljada"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 hilj.", "-1 hiljada"],
    ["-9999.12", "-10 hilj.", "-10 hiljada"],
    ["-9999.99", "-10 hilj.", "-10 hiljada"],
  ],
  "sv": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tn", "4,3 tusen"],
    ["54321", "54 tn", "54 tusen"],
    ["654321", "654 tn", "654 tusen"],
    ["7654321", "7,7 mn", "7,7 miljoner"],
    ["87654321", "88 mn", "88 miljoner"],
    ["987654321", "988 mn", "988 miljoner"],
    ["1087654321", "1,1 md", "1,1 miljarder"],
    ["11987654321", "12 md", "12 miljarder"],
    ["129987654321", "130 md", "130 miljarder"],
    ["1398987654321", "1,4 bn", "1,4 biljoner"],
    ["14987987654321", "15 bn", "15 biljoner"],
    ["159876987654321", "160 bn", "160 biljoner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tn", "10 tusen"],
    ["99999", "100 tn", "100 tusen"],
    ["999999", "1 mn", "1 miljon"],
    ["9999999", "10 mn", "10 miljoner"],
    ["99999999", "100 mn", "100 miljoner"],
    ["9994", "10 tn", "10 tusen"],
    ["99944", "100 tn", "100 tusen"],
    ["999444", "999 tn", "999 tusen"],
    ["9994444", "10 mn", "10 miljoner"],
    ["999444444", "999 mn", "999 miljoner"],
    ["9994444444", "10 md", "10 miljarder"],
    ["1000000000000000", "1000 bn", "1000 biljoner"],
    ["10000000000000000", "10000 bn", "10000 biljoner"],
    ["0", "0", "0"],
    ["-1", "−1", "−1"],
    ["-2", "−2", "−2"],
    ["-3", "−3", "−3"],
    ["-1000", "−1 tn", "−1 tusen"],
    ["-1001", "−1 tn", "−1 tusen"],
    ["-1010", "−1 tn", "−1 tusen"],
    ["-1100", "−1,1 tn", "−1,1 tusen"],
    ["-2000", "−2 tn", "−2 tusen"],
    ["-2001", "−2 tn", "−2 tusen"],
    ["-2010", "−2 tn", "−2 tusen"],
    ["-2100", "−2,1 tn", "−2,1 tusen"],
    ["-9", "−9", "−9"],
    ["-99", "−99", "−99"],
    ["-999", "−999", "−999"],
    ["-9999", "−10 tn", "−10 tusen"],
    ["-99999", "−100 tn", "−100 tusen"],
    ["-999999", "−1 mn", "−1 miljon"],
    ["-9999999", "−10 mn", "−10 miljoner"],
    ["-9999999999999999", "−10000 bn", "−10000 biljoner"],
    ["1000", "1 tn", "1 tusen"],
    ["1001", "1 tn", "1 tusen"],
    ["1010", "1 tn", "1 tusen"],
    ["1100", "1,1 tn", "1,1 tusen"],
    ["2000", "2 tn", "2 tusen"],
    ["2001", "2 tn", "2 tusen"],
    ["2010", "2 tn", "2 tusen"],
    ["2100", "2,1 tn", "2,1 tusen"],
    ["3000", "3 tn", "3 tusen"],
    ["3001", "3 tn", "3 tusen"],
    ["3010", "3 tn", "3 tusen"],
    ["3100", "3,1 tn", "3,1 tusen"],
    ["4000", "4 tn", "4 tusen"],
    ["4001", "4 tn", "4 tusen"],
    ["4010", "4 tn", "4 tusen"],
    ["4100", "4,1 tn", "4,1 tusen"],
    ["5000", "5 tn", "5 tusen"],
    ["5001", "5 tn", "5 tusen"],
    ["5010", "5 tn", "5 tusen"],
    ["5100", "5,1 tn", "5,1 tusen"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 tn", "1 tusen"],
    ["9999.12", "10 tn", "10 tusen"],
    ["9999.99", "10 tn", "10 tusen"],
    ["-0.12", "−0,12", "−0,12"],
    ["-0.99", "−0,99", "−0,99"],
    ["-9.12", "−9,1", "−9,1"],
    ["-9.99", "−10", "−10"],
    ["-999.12", "−999", "−999"],
    ["-999.99", "−1 tn", "−1 tusen"],
    ["-9999.12", "−10 tn", "−10 tusen"],
    ["-9999.99", "−10 tn", "−10 tusen"],
  ],
  "sw": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "elfu 4.3", "elfu 4.3"],
    ["54321", "elfu 54", "elfu 54"],
    ["654321", "elfu 654", "elfu 654"],
    ["7654321", "7.7M", "milioni 7.7"],
    ["87654321", "88M", "milioni 88"],
    ["987654321", "988M", "milioni 988"],
    ["1087654321", "1.1B", "bilioni 1.1"],
    ["11987654321", "12B", "bilioni 12"],
    ["129987654321", "130B", "bilioni 130"],
    ["1398987654321", "1.4T", "trilioni 1.4"],
    ["14987987654321", "15T", "trilioni 15"],
    ["159876987654321", "160T", "trilioni 160"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "elfu 10", "elfu 10"],
    ["99999", "elfu 100", "elfu 100"],
    ["999999", "1M", "milioni 1"],
    ["9999999", "10M", "milioni 10"],
    ["99999999", "100M", "milioni 100"],
    ["9994", "elfu 10", "elfu 10"],
    ["99944", "elfu 100", "elfu 100"],
    ["999444", "elfu 999", "elfu 999"],
    ["9994444", "10M", "milioni 10"],
    ["999444444", "999M", "milioni 999"],
    ["9994444444", "10B", "bilioni 10"],
    ["1000000000000000", "1000T", "trilioni 1000"],
    ["10000000000000000", "10000T", "trilioni 10000"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "elfu -1", "elfu -1"],
    ["-1001", "elfu -1", "elfu -1"],
    ["-1010", "elfu -1", "elfu -1"],
    ["-1100", "elfu -1.1", "elfu -1.1"],
    ["-2000", "elfu -2", "elfu -2"],
    ["-2001", "elfu -2", "elfu -2"],
    ["-2010", "elfu -2", "elfu -2"],
    ["-2100", "elfu -2.1", "elfu -2.1"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "elfu -10", "elfu -10"],
    ["-99999", "elfu -100", "elfu -100"],
    ["-999999", "-1M", "milioni -1"],
    ["-9999999", "-10M", "milioni -10"],
    ["-9999999999999999", "-10000T", "trilioni -10000"],
    ["1000", "elfu 1", "elfu 1"],
    ["1001", "elfu 1", "elfu 1"],
    ["1010", "elfu 1", "elfu 1"],
    ["1100", "elfu 1.1", "elfu 1.1"],
    ["2000", "elfu 2", "elfu 2"],
    ["2001", "elfu 2", "elfu 2"],
    ["2010", "elfu 2", "elfu 2"],
    ["2100", "elfu 2.1", "elfu 2.1"],
    ["3000", "elfu 3", "elfu 3"],
    ["3001", "elfu 3", "elfu 3"],
    ["3010", "elfu 3", "elfu 3"],
    ["3100", "elfu 3.1", "elfu 3.1"],
    ["4000", "elfu 4", "elfu 4"],
    ["4001", "elfu 4", "elfu 4"],
    ["4010", "elfu 4", "elfu 4"],
    ["4100", "elfu 4.1", "elfu 4.1"],
    ["5000", "elfu 5", "elfu 5"],
    ["5001", "elfu 5", "elfu 5"],
    ["5010", "elfu 5", "elfu 5"],
    ["5100", "elfu 5.1", "elfu 5.1"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "elfu 1", "elfu 1"],
    ["9999.12", "elfu 10", "elfu 10"],
    ["9999.99", "elfu 10", "elfu 10"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "elfu -1", "elfu -1"],
    ["-9999.12", "elfu -10", "elfu -10"],
    ["-9999.99", "elfu -10", "elfu -10"],
  ],
  "ta": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3ஆ", "4.3 ஆயிரம்"],
    ["54321", "54ஆ", "54 ஆயிரம்"],
    ["654321", "654ஆ", "654 ஆயிரம்"],
    ["7654321", "7.7மி", "7.7 மில்லியன்"],
    ["87654321", "88மி", "88 மில்லியன்"],
    ["987654321", "988மி", "988 மில்லியன்"],
    ["1087654321", "1.1பி", "1.1 பில்லியன்"],
    ["11987654321", "12பி", "12 பில்லியன்"],
    ["129987654321", "130பி", "130 பில்லியன்"],
    ["1398987654321", "1.4டி", "1.4 டிரில்லியன்"],
    ["14987987654321", "15டி", "15 டிரில்லியன்"],
    ["159876987654321", "160டி", "160 டிரில்லியன்"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10ஆ", "10 ஆயிரம்"],
    ["99999", "100ஆ", "100 ஆயிரம்"],
    ["999999", "1மி", "1 மில்லியன்"],
    ["9999999", "10மி", "10 மில்லியன்"],
    ["99999999", "100மி", "100 மில்லியன்"],
    ["9994", "10ஆ", "10 ஆயிரம்"],
    ["99944", "100ஆ", "100 ஆயிரம்"],
    ["999444", "999ஆ", "999 ஆயிரம்"],
    ["9994444", "10மி", "10 மில்லியன்"],
    ["999444444", "999மி", "999 மில்லியன்"],
    ["9994444444", "10பி", "10 பில்லியன்"],
    ["1000000000000000", "1000டி", "1000 டிரில்லியன்"],
    ["10000000000000000", "10000டி", "10000 டிரில்லியன்"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1ஆ", "-1 ஆயிரம்"],
    ["-1001", "-1ஆ", "-1 ஆயிரம்"],
    ["-1010", "-1ஆ", "-1 ஆயிரம்"],
    ["-1100", "-1.1ஆ", "-1.1 ஆயிரம்"],
    ["-2000", "-2ஆ", "-2 ஆயிரம்"],
    ["-2001", "-2ஆ", "-2 ஆயிரம்"],
    ["-2010", "-2ஆ", "-2 ஆயிரம்"],
    ["-2100", "-2.1ஆ", "-2.1 ஆயிரம்"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10ஆ", "-10 ஆயிரம்"],
    ["-99999", "-100ஆ", "-100 ஆயிரம்"],
    ["-999999", "-1மி", "-1 மில்லியன்"],
    ["-9999999", "-10மி", "-10 மில்லியன்"],
    ["-9999999999999999", "-10000டி", "-10000 டிரில்லியன்"],
    ["1000", "1ஆ", "1 ஆயிரம்"],
    ["1001", "1ஆ", "1 ஆயிரம்"],
    ["1010", "1ஆ", "1 ஆயிரம்"],
    ["1100", "1.1ஆ", "1.1 ஆயிரம்"],
    ["2000", "2ஆ", "2 ஆயிரம்"],
    ["2001", "2ஆ", "2 ஆயிரம்"],
    ["2010", "2ஆ", "2 ஆயிரம்"],
    ["2100", "2.1ஆ", "2.1 ஆயிரம்"],
    ["3000", "3ஆ", "3 ஆயிரம்"],
    ["3001", "3ஆ", "3 ஆயிரம்"],
    ["3010", "3ஆ", "3 ஆயிரம்"],
    ["3100", "3.1ஆ", "3.1 ஆயிரம்"],
    ["4000", "4ஆ", "4 ஆயிரம்"],
    ["4001", "4ஆ", "4 ஆயிரம்"],
    ["4010", "4ஆ", "4 ஆயிரம்"],
    ["4100", "4.1ஆ", "4.1 ஆயிரம்"],
    ["5000", "5ஆ", "5 ஆயிரம்"],
    ["5001", "5ஆ", "5 ஆயிரம்"],
    ["5010", "5ஆ", "5 ஆயிரம்"],
    ["5100", "5.1ஆ", "5.1 ஆயிரம்"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1ஆ", "1 ஆயிரம்"],
    ["9999.12", "10ஆ", "10 ஆயிரம்"],
    ["9999.99", "10ஆ", "10 ஆயிரம்"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1ஆ", "-1 ஆயிரம்"],
    ["-9999.12", "-10ஆ", "-10 ஆயிரம்"],
    ["-9999.99", "-10ஆ", "-10 ஆயிரம்"],
  ],
  "te": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3వే", "4.3 వేలు"],
    ["54321", "54వే", "54 వేలు"],
    ["654321", "654వే", "654 వేలు"],
    ["7654321", "7.7మి", "7.7 మిలియన్లు"],
    ["87654321", "88మి", "88 మిలియన్లు"],
    ["987654321", "988మి", "988 మిలియన్లు"],
    ["1087654321", "1.1బి", "1.1 బిలియన్లు"],
    ["11987654321", "12బి", "12 బిలియన్లు"],
    ["129987654321", "130బి", "130 బిలియన్లు"],
    ["1398987654321", "1.4ట్రి", "1.4 ట్రిలియన్లు"],
    ["14987987654321", "15ట్రి", "15 ట్రిలియన్లు"],
    ["159876987654321", "160ట్రి", "160 ట్రిలియన్లు"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10వే", "10 వేలు"],
    ["99999", "100వే", "100 వేలు"],
    ["999999", "1మి", "1 మిలియన్"],
    ["9999999", "10మి", "10 మిలియన్లు"],
    ["99999999", "100మి", "100 మిలియన్లు"],
    ["9994", "10వే", "10 వేలు"],
    ["99944", "100వే", "100 వేలు"],
    ["999444", "999వే", "999 వేలు"],
    ["9994444", "10మి", "10 మిలియన్లు"],
    ["999444444", "999మి", "999 మిలియన్లు"],
    ["9994444444", "10బి", "10 బిలియన్లు"],
    ["1000000000000000", "1000ట్రి", "1000 ట్రిలియన్లు"],
    ["10000000000000000", "10000ట్రి", "10000 ట్రిలియన్లు"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1వే", "-1 వేయి"],
    ["-1001", "-1వే", "-1 వేయి"],
    ["-1010", "-1వే", "-1 వేయి"],
    ["-1100", "-1.1వే", "-1.1 వేలు"],
    ["-2000", "-2వే", "-2 వేలు"],
    ["-2001", "-2వే", "-2 వేలు"],
    ["-2010", "-2వే", "-2 వేలు"],
    ["-2100", "-2.1వే", "-2.1 వేలు"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10వే", "-10 వేలు"],
    ["-99999", "-100వే", "-100 వేలు"],
    ["-999999", "-1మి", "-1 మిలియన్"],
    ["-9999999", "-10మి", "-10 మిలియన్లు"],
    ["-9999999999999999", "-10000ట్రి", "-10000 ట్రిలియన్లు"],
    ["1000", "1వే", "1 వేయి"],
    ["1001", "1వే", "1 వేయి"],
    ["1010", "1వే", "1 వేయి"],
    ["1100", "1.1వే", "1.1 వేలు"],
    ["2000", "2వే", "2 వేలు"],
    ["2001", "2వే", "2 వేలు"],
    ["2010", "2వే", "2 వేలు"],
    ["2100", "2.1వే", "2.1 వేలు"],
    ["3000", "3వే", "3 వేలు"],
    ["3001", "3వే", "3 వేలు"],
    ["3010", "3వే", "3 వేలు"],
    ["3100", "3.1వే", "3.1 వేలు"],
    ["4000", "4వే", "4 వేలు"],
    ["4001", "4వే", "4 వేలు"],
    ["4010", "4వే", "4 వేలు"],
    ["4100", "4.1వే", "4.1 వేలు"],
    ["5000", "5వే", "5 వేలు"],
    ["5001", "5వే", "5 వేలు"],
    ["5010", "5వే", "5 వేలు"],
    ["5100", "5.1వే", "5.1 వేలు"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1వే", "1 వేయి"],
    ["9999.12", "10వే", "10 వేలు"],
    ["9999.99", "10వే", "10 వేలు"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1వే", "-1 వేయి"],
    ["-9999.12", "-10వే", "-10 వేలు"],
    ["-9999.99", "-10వే", "-10 వేలు"],
  ],
  "th": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 พัน"],
    ["54321", "54K", "5.4 หมื่น"],
    ["654321", "654K", "6.5 แสน"],
    ["7654321", "7.7M", "7.7 ล้าน"],
    ["87654321", "88M", "88 ล้าน"],
    ["987654321", "988M", "988 ล้าน"],
    ["1087654321", "1.1B", "1.1 พันล้าน"],
    ["11987654321", "12B", "1.2 หมื่นล้าน"],
    ["129987654321", "130B", "1.3 แสนล้าน"],
    ["1398987654321", "1.4T", "1.4 ล้านล้าน"],
    ["14987987654321", "15T", "15 ล้านล้าน"],
    ["159876987654321", "160T", "160 ล้านล้าน"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "1 หมื่น"],
    ["99999", "100K", "1 แสน"],
    ["999999", "1M", "1 ล้าน"],
    ["9999999", "10M", "10 ล้าน"],
    ["99999999", "100M", "100 ล้าน"],
    ["9994", "10K", "1 หมื่น"],
    ["99944", "100K", "1 แสน"],
    ["999444", "999K", "1 ล้าน"],
    ["9994444", "10M", "10 ล้าน"],
    ["999444444", "999M", "999 ล้าน"],
    ["9994444444", "10B", "1 หมื่นล้าน"],
    ["1000000000000000", "1000T", "1000 ล้านล้าน"],
    ["10000000000000000", "10000T", "10000 ล้านล้าน"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 พัน"],
    ["-1001", "-1K", "-1 พัน"],
    ["-1010", "-1K", "-1 พัน"],
    ["-1100", "-1.1K", "-1.1 พัน"],
    ["-2000", "-2K", "-2 พัน"],
    ["-2001", "-2K", "-2 พัน"],
    ["-2010", "-2K", "-2 พัน"],
    ["-2100", "-2.1K", "-2.1 พัน"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-1 หมื่น"],
    ["-99999", "-100K", "-1 แสน"],
    ["-999999", "-1M", "-1 ล้าน"],
    ["-9999999", "-10M", "-10 ล้าน"],
    ["-9999999999999999", "-10000T", "-10000 ล้านล้าน"],
    ["1000", "1K", "1 พัน"],
    ["1001", "1K", "1 พัน"],
    ["1010", "1K", "1 พัน"],
    ["1100", "1.1K", "1.1 พัน"],
    ["2000", "2K", "2 พัน"],
    ["2001", "2K", "2 พัน"],
    ["2010", "2K", "2 พัน"],
    ["2100", "2.1K", "2.1 พัน"],
    ["3000", "3K", "3 พัน"],
    ["3001", "3K", "3 พัน"],
    ["3010", "3K", "3 พัน"],
    ["3100", "3.1K", "3.1 พัน"],
    ["4000", "4K", "4 พัน"],
    ["4001", "4K", "4 พัน"],
    ["4010", "4K", "4 พัน"],
    ["4100", "4.1K", "4.1 พัน"],
    ["5000", "5K", "5 พัน"],
    ["5001", "5K", "5 พัน"],
    ["5010", "5K", "5 พัน"],
    ["5100", "5.1K", "5.1 พัน"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 พัน"],
    ["9999.12", "10K", "1 หมื่น"],
    ["9999.99", "10K", "1 หมื่น"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 พัน"],
    ["-9999.12", "-10K", "-1 หมื่น"],
    ["-9999.99", "-10K", "-1 หมื่น"],
  ],
  "tl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 libo"],
    ["54321", "54K", "54 na libo"],
    ["654321", "654K", "654 na libo"],
    ["7654321", "7.7M", "7.7 milyon"],
    ["87654321", "88M", "88 milyon"],
    ["987654321", "988M", "988 milyon"],
    ["1087654321", "1.1B", "1.1 bilyon"],
    ["11987654321", "12B", "12 bilyon"],
    ["129987654321", "130B", "130 bilyon"],
    ["1398987654321", "1.4T", "1.4 na trilyon"],
    ["14987987654321", "15T", "15 trilyon"],
    ["159876987654321", "160T", "160 trilyon"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 libo"],
    ["99999", "100K", "100 libo"],
    ["999999", "1M", "1 milyon"],
    ["9999999", "10M", "10 milyon"],
    ["99999999", "100M", "100 milyon"],
    ["9994", "10K", "10 libo"],
    ["99944", "100K", "100 libo"],
    ["999444", "999K", "999 na libo"],
    ["9994444", "10M", "10 milyon"],
    ["999444444", "999M", "999 na milyon"],
    ["9994444444", "10B", "10 bilyon"],
    ["1000000000000000", "1000T", "1000 trilyon"],
    ["10000000000000000", "10000T", "10000 trilyon"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 libo"],
    ["-1001", "-1K", "-1 libo"],
    ["-1010", "-1K", "-1 libo"],
    ["-1100", "-1.1K", "-1.1 libo"],
    ["-2000", "-2K", "-2 libo"],
    ["-2001", "-2K", "-2 libo"],
    ["-2010", "-2K", "-2 libo"],
    ["-2100", "-2.1K", "-2.1 libo"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 libo"],
    ["-99999", "-100K", "-100 libo"],
    ["-999999", "-1M", "-1 milyon"],
    ["-9999999", "-10M", "-10 milyon"],
    ["-9999999999999999", "-10000T", "-10000 trilyon"],
    ["1000", "1K", "1 libo"],
    ["1001", "1K", "1 libo"],
    ["1010", "1K", "1 libo"],
    ["1100", "1.1K", "1.1 libo"],
    ["2000", "2K", "2 libo"],
    ["2001", "2K", "2 libo"],
    ["2010", "2K", "2 libo"],
    ["2100", "2.1K", "2.1 libo"],
    ["3000", "3K", "3 libo"],
    ["3001", "3K", "3 libo"],
    ["3010", "3K", "3 libo"],
    ["3100", "3.1K", "3.1 libo"],
    ["4000", "4K", "4 na libo"],
    ["4001", "4K", "4 na libo"],
    ["4010", "4K", "4 na libo"],
    ["4100", "4.1K", "4.1 libo"],
    ["5000", "5K", "5 libo"],
    ["5001", "5K", "5 libo"],
    ["5010", "5K", "5 libo"],
    ["5100", "5.1K", "5.1 libo"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 libo"],
    ["9999.12", "10K", "10 libo"],
    ["9999.99", "10K", "10 libo"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 libo"],
    ["-9999.12", "-10K", "-10 libo"],
    ["-9999.99", "-10K", "-10 libo"],
  ],
  "tr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 B", "4,3 bin"],
    ["54321", "54 B", "54 bin"],
    ["654321", "654 B", "654 bin"],
    ["7654321", "7,7 Mn", "7,7 milyon"],
    ["87654321", "88 Mn", "88 milyon"],
    ["987654321", "988 Mn", "988 milyon"],
    ["1087654321", "1,1 Mr", "1,1 milyar"],
    ["11987654321", "12 Mr", "12 milyar"],
    ["129987654321", "130 Mr", "130 milyar"],
    ["1398987654321", "1,4 Tn", "1,4 trilyon"],
    ["14987987654321", "15 Tn", "15 trilyon"],
    ["159876987654321", "160 Tn", "160 trilyon"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 B", "10 bin"],
    ["99999", "100 B", "100 bin"],
    ["999999", "1 Mn", "1 milyon"],
    ["9999999", "10 Mn", "10 milyon"],
    ["99999999", "100 Mn", "100 milyon"],
    ["9994", "10 B", "10 bin"],
    ["99944", "100 B", "100 bin"],
    ["999444", "999 B", "999 bin"],
    ["9994444", "10 Mn", "10 milyon"],
    ["999444444", "999 Mn", "999 milyon"],
    ["9994444444", "10 Mr", "10 milyar"],
    ["1000000000000000", "1000 Tn", "1000 trilyon"],
    ["10000000000000000", "10000 Tn", "10000 trilyon"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 B", "-1 bin"],
    ["-1001", "-1 B", "-1 bin"],
    ["-1010", "-1 B", "-1 bin"],
    ["-1100", "-1,1 B", "-1,1 bin"],
    ["-2000", "-2 B", "-2 bin"],
    ["-2001", "-2 B", "-2 bin"],
    ["-2010", "-2 B", "-2 bin"],
    ["-2100", "-2,1 B", "-2,1 bin"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 B", "-10 bin"],
    ["-99999", "-100 B", "-100 bin"],
    ["-999999", "-1 Mn", "-1 milyon"],
    ["-9999999", "-10 Mn", "-10 milyon"],
    ["-9999999999999999", "-10000 Tn", "-10000 trilyon"],
    ["1000", "1 B", "1 bin"],
    ["1001", "1 B", "1 bin"],
    ["1010", "1 B", "1 bin"],
    ["1100", "1,1 B", "1,1 bin"],
    ["2000", "2 B", "2 bin"],
    ["2001", "2 B", "2 bin"],
    ["2010", "2 B", "2 bin"],
    ["2100", "2,1 B", "2,1 bin"],
    ["3000", "3 B", "3 bin"],
    ["3001", "3 B", "3 bin"],
    ["3010", "3 B", "3 bin"],
    ["3100", "3,1 B", "3,1 bin"],
    ["4000", "4 B", "4 bin"],
    ["4001", "4 B", "4 bin"],
    ["4010", "4 B", "4 bin"],
    ["4100", "4,1 B", "4,1 bin"],
    ["5000", "5 B", "5 bin"],
    ["5001", "5 B", "5 bin"],
    ["5010", "5 B", "5 bin"],
    ["5100", "5,1 B", "5,1 bin"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 B", "1 bin"],
    ["9999.12", "10 B", "10 bin"],
    ["9999.99", "10 B", "10 bin"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 B", "-1 bin"],
    ["-9999.12", "-10 B", "-10 bin"],
    ["-9999.99", "-10 B", "-10 bin"],
  ],
  "uk": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 тис.", "4,3 тисячі"],
    ["54321", "54 тис.", "54 тисячі"],
    ["654321", "654 тис.", "654 тисячі"],
    ["7654321", "7,7 млн", "7,7 мільйона"],
    ["87654321", "88 млн", "88 мільйонів"],
    ["987654321", "988 млн", "988 мільйонів"],
    ["1087654321", "1,1 млрд", "1,1 мільярда"],
    ["11987654321", "12 млрд", "12 мільярдів"],
    ["129987654321", "130 млрд", "130 мільярдів"],
    ["1398987654321", "1,4 трлн", "1,4 трильйона"],
    ["14987987654321", "15 трлн", "15 трильйонів"],
    ["159876987654321", "160 трлн", "160 трильйонів"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 тис.", "10 тисяч"],
    ["99999", "100 тис.", "100 тисяч"],
    ["999999", "1 млн", "1 мільйон"],
    ["9999999", "10 млн", "10 мільйонів"],
    ["99999999", "100 млн", "100 мільйонів"],
    ["9994", "10 тис.", "10 тисяч"],
    ["99944", "100 тис.", "100 тисяч"],
    ["999444", "999 тис.", "999 тисяч"],
    ["9994444", "10 млн", "10 мільйонів"],
    ["999444444", "999 млн", "999 мільйонів"],
    ["9994444444", "10 млрд", "10 мільярдів"],
    ["1000000000000000", "1000 трлн", "1000 трильйонів"],
    ["10000000000000000", "10000 трлн", "10000 трильйонів"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 тис.", "-1 тисяча"],
    ["-1001", "-1 тис.", "-1 тисяча"],
    ["-1010", "-1 тис.", "-1 тисяча"],
    ["-1100", "-1,1 тис.", "-1,1 тисячі"],
    ["-2000", "-2 тис.", "-2 тисячі"],
    ["-2001", "-2 тис.", "-2 тисячі"],
    ["-2010", "-2 тис.", "-2 тисячі"],
    ["-2100", "-2,1 тис.", "-2,1 тисячі"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 тис.", "-10 тисяч"],
    ["-99999", "-100 тис.", "-100 тисяч"],
    ["-999999", "-1 млн", "-1 мільйон"],
    ["-9999999", "-10 млн", "-10 мільйонів"],
    ["-9999999999999999", "-10000 трлн", "-10000 трильйонів"],
    ["1000", "1 тис.", "1 тисяча"],
    ["1001", "1 тис.", "1 тисяча"],
    ["1010", "1 тис.", "1 тисяча"],
    ["1100", "1,1 тис.", "1,1 тисячі"],
    ["2000", "2 тис.", "2 тисячі"],
    ["2001", "2 тис.", "2 тисячі"],
    ["2010", "2 тис.", "2 тисячі"],
    ["2100", "2,1 тис.", "2,1 тисячі"],
    ["3000", "3 тис.", "3 тисячі"],
    ["3001", "3 тис.", "3 тисячі"],
    ["3010", "3 тис.", "3 тисячі"],
    ["3100", "3,1 тис.", "3,1 тисячі"],
    ["4000", "4 тис.", "4 тисячі"],
    ["4001", "4 тис.", "4 тисячі"],
    ["4010", "4 тис.", "4 тисячі"],
    ["4100", "4,1 тис.", "4,1 тисячі"],
    ["5000", "5 тис.", "5 тисяч"],
    ["5001", "5 тис.", "5 тисяч"],
    ["5010", "5 тис.", "5 тисяч"],
    ["5100", "5,1 тис.", "5,1 тисячі"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 тис.", "1 тисяча"],
    ["9999.12", "10 тис.", "10 тисяч"],
    ["9999.99", "10 тис.", "10 тисяч"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 тис.", "-1 тисяча"],
    ["-9999.12", "-10 тис.", "-10 тисяч"],
    ["-9999.99", "-10 тис.", "-10 тисяч"],
  ],
  "ur": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 ہزار", "4.3 ہزار"],
    ["54321", "54 ہزار", "54 ہزار"],
    ["654321", "6.5 لاکھ", "6.5 لاکھ"],
    ["7654321", "77 لاکھ", "77 لاکھ"],
    ["87654321", "8.8 کروڑ", "8.8 کروڑ"],
    ["987654321", "99 کروڑ", "99 کروڑ"],
    ["1087654321", "1.1 ارب", "1.1 ارب"],
    ["11987654321", "12 ارب", "12 ارب"],
    ["129987654321", "1.3 کھرب", "1.3 کھرب"],
    ["1398987654321", "14 کھرب", "14 کھرب"],
    ["14987987654321", "15 ٹریلین", "15 ٹریلین"],
    ["159876987654321", "160 ٹریلین", "160 ٹریلین"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ہزار", "10 ہزار"],
    ["99999", "1 لاکھ", "1 لاکھ"],
    ["999999", "10 لاکھ", "10 لاکھ"],
    ["9999999", "1 کروڑ", "1 کروڑ"],
    ["99999999", "10 کروڑ", "10 کروڑ"],
    ["9994", "10 ہزار", "10 ہزار"],
    ["99944", "1 لاکھ", "1 لاکھ"],
    ["999444", "10 لاکھ", "10 لاکھ"],
    ["9994444", "1 کروڑ", "1 کروڑ"],
    ["999444444", "1 ارب", "1 ارب"],
    ["9994444444", "10 ارب", "10 ارب"],
    ["1000000000000000", "1000 ٹریلین", "1000 ٹریلین"],
    ["10000000000000000", "10000 ٹریلین", "10000 ٹریلین"],
    ["0", "0", "0"],
    ["-1", "‎-1", "‎-1"],
    ["-2", "‎-2", "‎-2"],
    ["-3", "‎-3", "‎-3"],
    ["-1000", "‎-1 ہزار", "‎-1 ہزار"],
    ["-1001", "‎-1 ہزار", "‎-1 ہزار"],
    ["-1010", "‎-1 ہزار", "‎-1 ہزار"],
    ["-1100", "‎-1.1 ہزار", "‎-1.1 ہزار"],
    ["-2000", "‎-2 ہزار", "‎-2 ہزار"],
    ["-2001", "‎-2 ہزار", "‎-2 ہزار"],
    ["-2010", "‎-2 ہزار", "‎-2 ہزار"],
    ["-2100", "‎-2.1 ہزار", "‎-2.1 ہزار"],
    ["-9", "‎-9", "‎-9"],
    ["-99", "‎-99", "‎-99"],
    ["-999", "‎-999", "‎-999"],
    ["-9999", "‎-10 ہزار", "‎-10 ہزار"],
    ["-99999", "‎-1 لاکھ", "‎-1 لاکھ"],
    ["-999999", "‎-10 لاکھ", "‎-10 لاکھ"],
    ["-9999999", "‎-1 کروڑ", "‎-1 کروڑ"],
    ["-9999999999999999", "‎-10000 ٹریلین", "‎-10000 ٹریلین"],
    ["1000", "1 ہزار", "1 ہزار"],
    ["1001", "1 ہزار", "1 ہزار"],
    ["1010", "1 ہزار", "1 ہزار"],
    ["1100", "1.1 ہزار", "1.1 ہزار"],
    ["2000", "2 ہزار", "2 ہزار"],
    ["2001", "2 ہزار", "2 ہزار"],
    ["2010", "2 ہزار", "2 ہزار"],
    ["2100", "2.1 ہزار", "2.1 ہزار"],
    ["3000", "3 ہزار", "3 ہزار"],
    ["3001", "3 ہزار", "3 ہزار"],
    ["3010", "3 ہزار", "3 ہزار"],
    ["3100", "3.1 ہزار", "3.1 ہزار"],
    ["4000", "4 ہزار", "4 ہزار"],
    ["4001", "4 ہزار", "4 ہزار"],
    ["4010", "4 ہزار", "4 ہزار"],
    ["4100", "4.1 ہزار", "4.1 ہزار"],
    ["5000", "5 ہزار", "5 ہزار"],
    ["5001", "5 ہزار", "5 ہزار"],
    ["5010", "5 ہزار", "5 ہزار"],
    ["5100", "5.1 ہزار", "5.1 ہزار"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 ہزار", "1 ہزار"],
    ["9999.12", "10 ہزار", "10 ہزار"],
    ["9999.99", "10 ہزار", "10 ہزار"],
    ["-0.12", "‎-0.12", "‎-0.12"],
    ["-0.99", "‎-0.99", "‎-0.99"],
    ["-9.12", "‎-9.1", "‎-9.1"],
    ["-9.99", "‎-10", "‎-10"],
    ["-999.12", "‎-999", "‎-999"],
    ["-999.99", "‎-1 ہزار", "‎-1 ہزار"],
    ["-9999.12", "‎-10 ہزار", "‎-10 ہزار"],
    ["-9999.99", "‎-10 ہزار", "‎-10 ہزار"],
  ],
  "uz": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 ming", "4,3 ming"],
    ["54321", "54 ming", "54 ming"],
    ["654321", "654 ming", "654 ming"],
    ["7654321", "7,7 mln", "7,7 million"],
    ["87654321", "88 mln", "88 million"],
    ["987654321", "988 mln", "988 million"],
    ["1087654321", "1,1 mlrd", "1,1 milliard"],
    ["11987654321", "12 mlrd", "12 milliard"],
    ["129987654321", "130 mlrd", "130 milliard"],
    ["1398987654321", "1,4 trln", "1,4 trillion"],
    ["14987987654321", "15 trln", "15 trillion"],
    ["159876987654321", "160 trln", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ming", "10 ming"],
    ["99999", "100 ming", "100 ming"],
    ["999999", "1 mln", "1 million"],
    ["9999999", "10 mln", "10 million"],
    ["99999999", "100 mln", "100 million"],
    ["9994", "10 ming", "10 ming"],
    ["99944", "100 ming", "100 ming"],
    ["999444", "999 ming", "999 ming"],
    ["9994444", "10 mln", "10 million"],
    ["999444444", "999 mln", "999 million"],
    ["9994444444", "10 mlrd", "10 milliard"],
    ["1000000000000000", "1000 trln", "1000 trillion"],
    ["10000000000000000", "10000 trln", "10000 trillion"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 ming", "-1 ming"],
    ["-1001", "-1 ming", "-1 ming"],
    ["-1010", "-1 ming", "-1 ming"],
    ["-1100", "-1,1 ming", "-1,1 ming"],
    ["-2000", "-2 ming", "-2 ming"],
    ["-2001", "-2 ming", "-2 ming"],
    ["-2010", "-2 ming", "-2 ming"],
    ["-2100", "-2,1 ming", "-2,1 ming"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 ming", "-10 ming"],
    ["-99999", "-100 ming", "-100 ming"],
    ["-999999", "-1 mln", "-1 million"],
    ["-9999999", "-10 mln", "-10 million"],
    ["-9999999999999999", "-10000 trln", "-10000 trillion"],
    ["1000", "1 ming", "1 ming"],
    ["1001", "1 ming", "1 ming"],
    ["1010", "1 ming", "1 ming"],
    ["1100", "1,1 ming", "1,1 ming"],
    ["2000", "2 ming", "2 ming"],
    ["2001", "2 ming", "2 ming"],
    ["2010", "2 ming", "2 ming"],
    ["2100", "2,1 ming", "2,1 ming"],
    ["3000", "3 ming", "3 ming"],
    ["3001", "3 ming", "3 ming"],
    ["3010", "3 ming", "3 ming"],
    ["3100", "3,1 ming", "3,1 ming"],
    ["4000", "4 ming", "4 ming"],
    ["4001", "4 ming", "4 ming"],
    ["4010", "4 ming", "4 ming"],
    ["4100", "4,1 ming", "4,1 ming"],
    ["5000", "5 ming", "5 ming"],
    ["5001", "5 ming", "5 ming"],
    ["5010", "5 ming", "5 ming"],
    ["5100", "5,1 ming", "5,1 ming"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 ming", "1 ming"],
    ["9999.12", "10 ming", "10 ming"],
    ["9999.99", "10 ming", "10 ming"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 ming", "-1 ming"],
    ["-9999.12", "-10 ming", "-10 ming"],
    ["-9999.99", "-10 ming", "-10 ming"],
  ],
  "vi": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 N", "4,3 nghìn"],
    ["54321", "54 N", "54 nghìn"],
    ["654321", "654 N", "654 nghìn"],
    ["7654321", "7,7 Tr", "7,7 triệu"],
    ["87654321", "88 Tr", "88 triệu"],
    ["987654321", "988 Tr", "988 triệu"],
    ["1087654321", "1,1 T", "1,1 tỷ"],
    ["11987654321", "12 T", "12 tỷ"],
    ["129987654321", "130 T", "130 tỷ"],
    ["1398987654321", "1,4 NT", "1,4 nghìn tỷ"],
    ["14987987654321", "15 NT", "15 nghìn tỷ"],
    ["159876987654321", "160 NT", "160 nghìn tỷ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 N", "10 nghìn"],
    ["99999", "100 N", "100 nghìn"],
    ["999999", "1 Tr", "1 triệu"],
    ["9999999", "10 Tr", "10 triệu"],
    ["99999999", "100 Tr", "100 triệu"],
    ["9994", "10 N", "10 nghìn"],
    ["99944", "100 N", "100 nghìn"],
    ["999444", "999 N", "999 nghìn"],
    ["9994444", "10 Tr", "10 triệu"],
    ["999444444", "999 Tr", "999 triệu"],
    ["9994444444", "10 T", "10 tỷ"],
    ["1000000000000000", "1000 NT", "1000 nghìn tỷ"],
    ["10000000000000000", "10000 NT", "10000 nghìn tỷ"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1 N", "-1 nghìn"],
    ["-1001", "-1 N", "-1 nghìn"],
    ["-1010", "-1 N", "-1 nghìn"],
    ["-1100", "-1,1 N", "-1,1 nghìn"],
    ["-2000", "-2 N", "-2 nghìn"],
    ["-2001", "-2 N", "-2 nghìn"],
    ["-2010", "-2 N", "-2 nghìn"],
    ["-2100", "-2,1 N", "-2,1 nghìn"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10 N", "-10 nghìn"],
    ["-99999", "-100 N", "-100 nghìn"],
    ["-999999", "-1 Tr", "-1 triệu"],
    ["-9999999", "-10 Tr", "-10 triệu"],
    ["-9999999999999999", "-10000 NT", "-10000 nghìn tỷ"],
    ["1000", "1 N", "1 nghìn"],
    ["1001", "1 N", "1 nghìn"],
    ["1010", "1 N", "1 nghìn"],
    ["1100", "1,1 N", "1,1 nghìn"],
    ["2000", "2 N", "2 nghìn"],
    ["2001", "2 N", "2 nghìn"],
    ["2010", "2 N", "2 nghìn"],
    ["2100", "2,1 N", "2,1 nghìn"],
    ["3000", "3 N", "3 nghìn"],
    ["3001", "3 N", "3 nghìn"],
    ["3010", "3 N", "3 nghìn"],
    ["3100", "3,1 N", "3,1 nghìn"],
    ["4000", "4 N", "4 nghìn"],
    ["4001", "4 N", "4 nghìn"],
    ["4010", "4 N", "4 nghìn"],
    ["4100", "4,1 N", "4,1 nghìn"],
    ["5000", "5 N", "5 nghìn"],
    ["5001", "5 N", "5 nghìn"],
    ["5010", "5 N", "5 nghìn"],
    ["5100", "5,1 N", "5,1 nghìn"],
    ["0.001234", "0,0012", "0,0012"],
    ["0.01234", "0,012", "0,012"],
    ["0.1234", "0,12", "0,12"],
    ["0.99", "0,99", "0,99"],
    ["0.999", "1", "1"],
    ["9.12", "9,1", "9,1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1 N", "1 nghìn"],
    ["9999.12", "10 N", "10 nghìn"],
    ["9999.99", "10 N", "10 nghìn"],
    ["-0.12", "-0,12", "-0,12"],
    ["-0.99", "-0,99", "-0,99"],
    ["-9.12", "-9,1", "-9,1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1 N", "-1 nghìn"],
    ["-9999.12", "-10 N", "-10 nghìn"],
    ["-9999.99", "-10 N", "-10 nghìn"],
  ],
  "zh": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4321"],
    ["54321", "5.4万", "5.4万"],
    ["654321", "65万", "65万"],
    ["7654321", "765万", "765万"],
    ["87654321", "8765万", "8765万"],
    ["987654321", "9.9亿", "9.9亿"],
    ["1087654321", "11亿", "11亿"],
    ["11987654321", "120亿", "120亿"],
    ["129987654321", "1300亿", "1300亿"],
    ["1398987654321", "1.4万亿", "1.4万亿"],
    ["14987987654321", "15万亿", "15万亿"],
    ["159876987654321", "160万亿", "160万亿"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "9999"],
    ["99999", "10万", "10万"],
    ["999999", "100万", "100万"],
    ["9999999", "1000万", "1000万"],
    ["99999999", "1亿", "1亿"],
    ["9994", "9994", "9994"],
    ["99944", "10万", "10万"],
    ["999444", "100万", "100万"],
    ["9994444", "999万", "999万"],
    ["999444444", "10亿", "10亿"],
    ["9994444444", "100亿", "100亿"],
    ["1000000000000000", "1000万亿", "1000万亿"],
    ["10000000000000000", "10000万亿", "10000万亿"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1000", "-1000"],
    ["-1001", "-1001", "-1001"],
    ["-1010", "-1010", "-1010"],
    ["-1100", "-1100", "-1100"],
    ["-2000", "-2000", "-2000"],
    ["-2001", "-2001", "-2001"],
    ["-2010", "-2010", "-2010"],
    ["-2100", "-2100", "-2100"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-9999", "-9999"],
    ["-99999", "-10万", "-10万"],
    ["-999999", "-100万", "-100万"],
    ["-9999999", "-1000万", "-1000万"],
    ["-9999999999999999", "-10000万亿", "-10000万亿"],
    ["1000", "1000", "1000"],
    ["1001", "1001", "1001"],
    ["1010", "1010", "1010"],
    ["1100", "1100", "1100"],
    ["2000", "2000", "2000"],
    ["2001", "2001", "2001"],
    ["2010", "2010", "2010"],
    ["2100", "2100", "2100"],
    ["3000", "3000", "3000"],
    ["3001", "3001", "3001"],
    ["3010", "3010", "3010"],
    ["3100", "3100", "3100"],
    ["4000", "4000", "4000"],
    ["4001", "4001", "4001"],
    ["4010", "4010", "4010"],
    ["4100", "4100", "4100"],
    ["5000", "5000", "5000"],
    ["5001", "5001", "5001"],
    ["5010", "5010", "5010"],
    ["5100", "5100", "5100"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1000", "1000"],
    ["9999.12", "9999", "9999"],
    ["9999.99", "1万", "1万"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1000", "-1000"],
    ["-9999.12", "-9999", "-9999"],
    ["-9999.99", "-1万", "-1万"],
  ],
  "zh_CN": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4321"],
    ["54321", "5.4万", "5.4万"],
    ["654321", "65万", "65万"],
    ["7654321", "765万", "765万"],
    ["87654321", "8765万", "8765万"],
    ["987654321", "9.9亿", "9.9亿"],
    ["1087654321", "11亿", "11亿"],
    ["11987654321", "120亿", "120亿"],
    ["129987654321", "1300亿", "1300亿"],
    ["1398987654321", "1.4万亿", "1.4万亿"],
    ["14987987654321", "15万亿", "15万亿"],
    ["159876987654321", "160万亿", "160万亿"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "9999"],
    ["99999", "10万", "10万"],
    ["999999", "100万", "100万"],
    ["9999999", "1000万", "1000万"],
    ["99999999", "1亿", "1亿"],
    ["9994", "9994", "9994"],
    ["99944", "10万", "10万"],
    ["999444", "100万", "100万"],
    ["9994444", "999万", "999万"],
    ["999444444", "10亿", "10亿"],
    ["9994444444", "100亿", "100亿"],
    ["1000000000000000", "1000万亿", "1000万亿"],
    ["10000000000000000", "10000万亿", "10000万亿"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1000", "-1000"],
    ["-1001", "-1001", "-1001"],
    ["-1010", "-1010", "-1010"],
    ["-1100", "-1100", "-1100"],
    ["-2000", "-2000", "-2000"],
    ["-2001", "-2001", "-2001"],
    ["-2010", "-2010", "-2010"],
    ["-2100", "-2100", "-2100"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-9999", "-9999"],
    ["-99999", "-10万", "-10万"],
    ["-999999", "-100万", "-100万"],
    ["-9999999", "-1000万", "-1000万"],
    ["-9999999999999999", "-10000万亿", "-10000万亿"],
    ["1000", "1000", "1000"],
    ["1001", "1001", "1001"],
    ["1010", "1010", "1010"],
    ["1100", "1100", "1100"],
    ["2000", "2000", "2000"],
    ["2001", "2001", "2001"],
    ["2010", "2010", "2010"],
    ["2100", "2100", "2100"],
    ["3000", "3000", "3000"],
    ["3001", "3001", "3001"],
    ["3010", "3010", "3010"],
    ["3100", "3100", "3100"],
    ["4000", "4000", "4000"],
    ["4001", "4001", "4001"],
    ["4010", "4010", "4010"],
    ["4100", "4100", "4100"],
    ["5000", "5000", "5000"],
    ["5001", "5001", "5001"],
    ["5010", "5010", "5010"],
    ["5100", "5100", "5100"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1000", "1000"],
    ["9999.12", "9999", "9999"],
    ["9999.99", "1万", "1万"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1000", "-1000"],
    ["-9999.12", "-9999", "-9999"],
    ["-9999.99", "-1万", "-1万"],
  ],
  "zh_HK": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3K"],
    ["54321", "54K", "54K"],
    ["654321", "654K", "654K"],
    ["7654321", "7.7M", "7.7M"],
    ["87654321", "88M", "88M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1.1B", "1.1B"],
    ["11987654321", "12B", "12B"],
    ["129987654321", "130B", "130B"],
    ["1398987654321", "1.4T", "1.4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "10K", "10K"],
    ["99944", "100K", "100K"],
    ["999444", "999K", "999K"],
    ["9994444", "10M", "10M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "10B", "10B"],
    ["1000000000000000", "1000T", "1000T"],
    ["10000000000000000", "10000T", "10000T"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1K"],
    ["-1001", "-1K", "-1K"],
    ["-1010", "-1K", "-1K"],
    ["-1100", "-1.1K", "-1.1K"],
    ["-2000", "-2K", "-2K"],
    ["-2001", "-2K", "-2K"],
    ["-2010", "-2K", "-2K"],
    ["-2100", "-2.1K", "-2.1K"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10K"],
    ["-99999", "-100K", "-100K"],
    ["-999999", "-1M", "-1M"],
    ["-9999999", "-10M", "-10M"],
    ["-9999999999999999", "-10000T", "-10000T"],
    ["1000", "1K", "1K"],
    ["1001", "1K", "1K"],
    ["1010", "1K", "1K"],
    ["1100", "1.1K", "1.1K"],
    ["2000", "2K", "2K"],
    ["2001", "2K", "2K"],
    ["2010", "2K", "2K"],
    ["2100", "2.1K", "2.1K"],
    ["3000", "3K", "3K"],
    ["3001", "3K", "3K"],
    ["3010", "3K", "3K"],
    ["3100", "3.1K", "3.1K"],
    ["4000", "4K", "4K"],
    ["4001", "4K", "4K"],
    ["4010", "4K", "4K"],
    ["4100", "4.1K", "4.1K"],
    ["5000", "5K", "5K"],
    ["5001", "5K", "5K"],
    ["5010", "5K", "5K"],
    ["5100", "5.1K", "5.1K"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1K"],
    ["9999.12", "10K", "10K"],
    ["9999.99", "10K", "10K"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1K"],
    ["-9999.12", "-10K", "-10K"],
    ["-9999.99", "-10K", "-10K"],
  ],
  "zh_TW": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4321"],
    ["54321", "5.4萬", "5.4萬"],
    ["654321", "65萬", "65萬"],
    ["7654321", "765萬", "765萬"],
    ["87654321", "8765萬", "8765萬"],
    ["987654321", "9.9億", "9.9億"],
    ["1087654321", "11億", "11億"],
    ["11987654321", "120億", "120億"],
    ["129987654321", "1300億", "1300億"],
    ["1398987654321", "1.4兆", "1.4兆"],
    ["14987987654321", "15兆", "15兆"],
    ["159876987654321", "160兆", "160兆"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "9999"],
    ["99999", "10萬", "10萬"],
    ["999999", "100萬", "100萬"],
    ["9999999", "1000萬", "1000萬"],
    ["99999999", "1億", "1億"],
    ["9994", "9994", "9994"],
    ["99944", "10萬", "10萬"],
    ["999444", "100萬", "100萬"],
    ["9994444", "999萬", "999萬"],
    ["999444444", "10億", "10億"],
    ["9994444444", "100億", "100億"],
    ["1000000000000000", "1000兆", "1000兆"],
    ["10000000000000000", "10000兆", "10000兆"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1000", "-1000"],
    ["-1001", "-1001", "-1001"],
    ["-1010", "-1010", "-1010"],
    ["-1100", "-1100", "-1100"],
    ["-2000", "-2000", "-2000"],
    ["-2001", "-2001", "-2001"],
    ["-2010", "-2010", "-2010"],
    ["-2100", "-2100", "-2100"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-9999", "-9999"],
    ["-99999", "-10萬", "-10萬"],
    ["-999999", "-100萬", "-100萬"],
    ["-9999999", "-1000萬", "-1000萬"],
    ["-9999999999999999", "-10000兆", "-10000兆"],
    ["1000", "1000", "1000"],
    ["1001", "1001", "1001"],
    ["1010", "1010", "1010"],
    ["1100", "1100", "1100"],
    ["2000", "2000", "2000"],
    ["2001", "2001", "2001"],
    ["2010", "2010", "2010"],
    ["2100", "2100", "2100"],
    ["3000", "3000", "3000"],
    ["3001", "3001", "3001"],
    ["3010", "3010", "3010"],
    ["3100", "3100", "3100"],
    ["4000", "4000", "4000"],
    ["4001", "4001", "4001"],
    ["4010", "4010", "4010"],
    ["4100", "4100", "4100"],
    ["5000", "5000", "5000"],
    ["5001", "5001", "5001"],
    ["5010", "5010", "5010"],
    ["5100", "5100", "5100"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1000", "1000"],
    ["9999.12", "9999", "9999"],
    ["9999.99", "1萬", "1萬"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1000", "-1000"],
    ["-9999.12", "-9999", "-9999"],
    ["-9999.99", "-1萬", "-1萬"],
  ],
  "zu": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 inkulungwane"],
    ["54321", "54K", "54 inkulungwane"],
    ["654321", "654K", "654 inkulungwane"],
    ["7654321", "7.7M", "7.7 isigidi"],
    ["87654321", "88M", "88 isigidi"],
    ["987654321", "988M", "988 isigidi"],
    ["1087654321", "1.1B", "1.1 isigidi sezigidi"],
    ["11987654321", "12B", "12 isigidi sezigidi"],
    ["129987654321", "130B", "130 isigidi sezigidi"],
    ["1398987654321", "1.4T", "1.4 isigidintathu"],
    ["14987987654321", "15T", "15 isigidintathu"],
    ["159876987654321", "160T", "160 isigidintathu"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 inkulungwane"],
    ["99999", "100K", "100 inkulungwane"],
    ["999999", "1M", "1 isigidi"],
    ["9999999", "10M", "10 isigidi"],
    ["99999999", "100M", "100 isigidi"],
    ["9994", "10K", "10 inkulungwane"],
    ["99944", "100K", "100 inkulungwane"],
    ["999444", "999K", "999 inkulungwane"],
    ["9994444", "10M", "10 isigidi"],
    ["999444444", "999M", "999 isigidi"],
    ["9994444444", "10B", "10 isigidi sezigidi"],
    ["1000000000000000", "1000T", "1000 isigidintathu"],
    ["10000000000000000", "10000T", "10000 isigidintathu"],
    ["0", "0", "0"],
    ["-1", "-1", "-1"],
    ["-2", "-2", "-2"],
    ["-3", "-3", "-3"],
    ["-1000", "-1K", "-1 inkulungwane"],
    ["-1001", "-1K", "-1 inkulungwane"],
    ["-1010", "-1K", "-1 inkulungwane"],
    ["-1100", "-1.1K", "-1.1 inkulungwane"],
    ["-2000", "-2K", "-2 inkulungwane"],
    ["-2001", "-2K", "-2 inkulungwane"],
    ["-2010", "-2K", "-2 inkulungwane"],
    ["-2100", "-2.1K", "-2.1 inkulungwane"],
    ["-9", "-9", "-9"],
    ["-99", "-99", "-99"],
    ["-999", "-999", "-999"],
    ["-9999", "-10K", "-10 inkulungwane"],
    ["-99999", "-100K", "-100 inkulungwane"],
    ["-999999", "-1M", "-1 isigidi"],
    ["-9999999", "-10M", "-10 isigidi"],
    ["-9999999999999999", "-10000T", "-10000 isigidintathu"],
    ["1000", "1K", "1 inkulungwane"],
    ["1001", "1K", "1 inkulungwane"],
    ["1010", "1K", "1 inkulungwane"],
    ["1100", "1.1K", "1.1 inkulungwane"],
    ["2000", "2K", "2 inkulungwane"],
    ["2001", "2K", "2 inkulungwane"],
    ["2010", "2K", "2 inkulungwane"],
    ["2100", "2.1K", "2.1 inkulungwane"],
    ["3000", "3K", "3 inkulungwane"],
    ["3001", "3K", "3 inkulungwane"],
    ["3010", "3K", "3 inkulungwane"],
    ["3100", "3.1K", "3.1 inkulungwane"],
    ["4000", "4K", "4 inkulungwane"],
    ["4001", "4K", "4 inkulungwane"],
    ["4010", "4K", "4 inkulungwane"],
    ["4100", "4.1K", "4.1 inkulungwane"],
    ["5000", "5K", "5 inkulungwane"],
    ["5001", "5K", "5 inkulungwane"],
    ["5010", "5K", "5 inkulungwane"],
    ["5100", "5.1K", "5.1 inkulungwane"],
    ["0.001234", "0.0012", "0.0012"],
    ["0.01234", "0.012", "0.012"],
    ["0.1234", "0.12", "0.12"],
    ["0.99", "0.99", "0.99"],
    ["0.999", "1", "1"],
    ["9.12", "9.1", "9.1"],
    ["9.99", "10", "10"],
    ["99.12", "99", "99"],
    ["99.99", "100", "100"],
    ["999.12", "999", "999"],
    ["999.99", "1K", "1 inkulungwane"],
    ["9999.12", "10K", "10 inkulungwane"],
    ["9999.99", "10K", "10 inkulungwane"],
    ["-0.12", "-0.12", "-0.12"],
    ["-0.99", "-0.99", "-0.99"],
    ["-9.12", "-9.1", "-9.1"],
    ["-9.99", "-10", "-10"],
    ["-999.12", "-999", "-999"],
    ["-999.99", "-1K", "-1 inkulungwane"],
    ["-9999.12", "-10K", "-10 inkulungwane"],
    ["-9999.99", "-10K", "-10 inkulungwane"],
  ],
};
