// Copyright (c) 2015, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

library http2.hpack.huffman_table;

import 'huffman.dart';

/// The huffman codec for encoding/decoding HTTP/2 header blocks.
final HuffmanCodec http2HuffmanCodec = new HuffmanCodec(
    new HuffmanEncoder(_codeWords),
    new HuffmanDecoder(generateHuffmanTree(_codeWords)));

/// This is the integer representing the End-of-String symbol
/// (it is not representable by a byte).
const int EOS_BYTE = 256;

/// This list of byte encodings via huffman encoding was generated from the
/// HPACK specification.
const List<EncodedHuffmanValue> _codeWords = const <EncodedHuffmanValue>[
  const EncodedHuffmanValue(0x1ff8, 13),
  const EncodedHuffmanValue(0x7fffd8, 23),
  const EncodedHuffmanValue(0xfffffe2, 28),
  const EncodedHuffmanValue(0xfffffe3, 28),
  const EncodedHuffmanValue(0xfffffe4, 28),
  const EncodedHuffmanValue(0xfffffe5, 28),
  const EncodedHuffmanValue(0xfffffe6, 28),
  const EncodedHuffmanValue(0xfffffe7, 28),
  const EncodedHuffmanValue(0xfffffe8, 28),
  const EncodedHuffmanValue(0xffffea, 24),
  const EncodedHuffmanValue(0x3ffffffc, 30),
  const EncodedHuffmanValue(0xfffffe9, 28),
  const EncodedHuffmanValue(0xfffffea, 28),
  const EncodedHuffmanValue(0x3ffffffd, 30),
  const EncodedHuffmanValue(0xfffffeb, 28),
  const EncodedHuffmanValue(0xfffffec, 28),
  const EncodedHuffmanValue(0xfffffed, 28),
  const EncodedHuffmanValue(0xfffffee, 28),
  const EncodedHuffmanValue(0xfffffef, 28),
  const EncodedHuffmanValue(0xffffff0, 28),
  const EncodedHuffmanValue(0xffffff1, 28),
  const EncodedHuffmanValue(0xffffff2, 28),
  const EncodedHuffmanValue(0x3ffffffe, 30),
  const EncodedHuffmanValue(0xffffff3, 28),
  const EncodedHuffmanValue(0xffffff4, 28),
  const EncodedHuffmanValue(0xffffff5, 28),
  const EncodedHuffmanValue(0xffffff6, 28),
  const EncodedHuffmanValue(0xffffff7, 28),
  const EncodedHuffmanValue(0xffffff8, 28),
  const EncodedHuffmanValue(0xffffff9, 28),
  const EncodedHuffmanValue(0xffffffa, 28),
  const EncodedHuffmanValue(0xffffffb, 28),
  const EncodedHuffmanValue(0x14, 6),
  const EncodedHuffmanValue(0x3f8, 10),
  const EncodedHuffmanValue(0x3f9, 10),
  const EncodedHuffmanValue(0xffa, 12),
  const EncodedHuffmanValue(0x1ff9, 13),
  const EncodedHuffmanValue(0x15, 6),
  const EncodedHuffmanValue(0xf8, 8),
  const EncodedHuffmanValue(0x7fa, 11),
  const EncodedHuffmanValue(0x3fa, 10),
  const EncodedHuffmanValue(0x3fb, 10),
  const EncodedHuffmanValue(0xf9, 8),
  const EncodedHuffmanValue(0x7fb, 11),
  const EncodedHuffmanValue(0xfa, 8),
  const EncodedHuffmanValue(0x16, 6),
  const EncodedHuffmanValue(0x17, 6),
  const EncodedHuffmanValue(0x18, 6),
  const EncodedHuffmanValue(0x0, 5),
  const EncodedHuffmanValue(0x1, 5),
  const EncodedHuffmanValue(0x2, 5),
  const EncodedHuffmanValue(0x19, 6),
  const EncodedHuffmanValue(0x1a, 6),
  const EncodedHuffmanValue(0x1b, 6),
  const EncodedHuffmanValue(0x1c, 6),
  const EncodedHuffmanValue(0x1d, 6),
  const EncodedHuffmanValue(0x1e, 6),
  const EncodedHuffmanValue(0x1f, 6),
  const EncodedHuffmanValue(0x5c, 7),
  const EncodedHuffmanValue(0xfb, 8),
  const EncodedHuffmanValue(0x7ffc, 15),
  const EncodedHuffmanValue(0x20, 6),
  const EncodedHuffmanValue(0xffb, 12),
  const EncodedHuffmanValue(0x3fc, 10),
  const EncodedHuffmanValue(0x1ffa, 13),
  const EncodedHuffmanValue(0x21, 6),
  const EncodedHuffmanValue(0x5d, 7),
  const EncodedHuffmanValue(0x5e, 7),
  const EncodedHuffmanValue(0x5f, 7),
  const EncodedHuffmanValue(0x60, 7),
  const EncodedHuffmanValue(0x61, 7),
  const EncodedHuffmanValue(0x62, 7),
  const EncodedHuffmanValue(0x63, 7),
  const EncodedHuffmanValue(0x64, 7),
  const EncodedHuffmanValue(0x65, 7),
  const EncodedHuffmanValue(0x66, 7),
  const EncodedHuffmanValue(0x67, 7),
  const EncodedHuffmanValue(0x68, 7),
  const EncodedHuffmanValue(0x69, 7),
  const EncodedHuffmanValue(0x6a, 7),
  const EncodedHuffmanValue(0x6b, 7),
  const EncodedHuffmanValue(0x6c, 7),
  const EncodedHuffmanValue(0x6d, 7),
  const EncodedHuffmanValue(0x6e, 7),
  const EncodedHuffmanValue(0x6f, 7),
  const EncodedHuffmanValue(0x70, 7),
  const EncodedHuffmanValue(0x71, 7),
  const EncodedHuffmanValue(0x72, 7),
  const EncodedHuffmanValue(0xfc, 8),
  const EncodedHuffmanValue(0x73, 7),
  const EncodedHuffmanValue(0xfd, 8),
  const EncodedHuffmanValue(0x1ffb, 13),
  const EncodedHuffmanValue(0x7fff0, 19),
  const EncodedHuffmanValue(0x1ffc, 13),
  const EncodedHuffmanValue(0x3ffc, 14),
  const EncodedHuffmanValue(0x22, 6),
  const EncodedHuffmanValue(0x7ffd, 15),
  const EncodedHuffmanValue(0x3, 5),
  const EncodedHuffmanValue(0x23, 6),
  const EncodedHuffmanValue(0x4, 5),
  const EncodedHuffmanValue(0x24, 6),
  const EncodedHuffmanValue(0x5, 5),
  const EncodedHuffmanValue(0x25, 6),
  const EncodedHuffmanValue(0x26, 6),
  const EncodedHuffmanValue(0x27, 6),
  const EncodedHuffmanValue(0x6, 5),
  const EncodedHuffmanValue(0x74, 7),
  const EncodedHuffmanValue(0x75, 7),
  const EncodedHuffmanValue(0x28, 6),
  const EncodedHuffmanValue(0x29, 6),
  const EncodedHuffmanValue(0x2a, 6),
  const EncodedHuffmanValue(0x7, 5),
  const EncodedHuffmanValue(0x2b, 6),
  const EncodedHuffmanValue(0x76, 7),
  const EncodedHuffmanValue(0x2c, 6),
  const EncodedHuffmanValue(0x8, 5),
  const EncodedHuffmanValue(0x9, 5),
  const EncodedHuffmanValue(0x2d, 6),
  const EncodedHuffmanValue(0x77, 7),
  const EncodedHuffmanValue(0x78, 7),
  const EncodedHuffmanValue(0x79, 7),
  const EncodedHuffmanValue(0x7a, 7),
  const EncodedHuffmanValue(0x7b, 7),
  const EncodedHuffmanValue(0x7ffe, 15),
  const EncodedHuffmanValue(0x7fc, 11),
  const EncodedHuffmanValue(0x3ffd, 14),
  const EncodedHuffmanValue(0x1ffd, 13),
  const EncodedHuffmanValue(0xffffffc, 28),
  const EncodedHuffmanValue(0xfffe6, 20),
  const EncodedHuffmanValue(0x3fffd2, 22),
  const EncodedHuffmanValue(0xfffe7, 20),
  const EncodedHuffmanValue(0xfffe8, 20),
  const EncodedHuffmanValue(0x3fffd3, 22),
  const EncodedHuffmanValue(0x3fffd4, 22),
  const EncodedHuffmanValue(0x3fffd5, 22),
  const EncodedHuffmanValue(0x7fffd9, 23),
  const EncodedHuffmanValue(0x3fffd6, 22),
  const EncodedHuffmanValue(0x7fffda, 23),
  const EncodedHuffmanValue(0x7fffdb, 23),
  const EncodedHuffmanValue(0x7fffdc, 23),
  const EncodedHuffmanValue(0x7fffdd, 23),
  const EncodedHuffmanValue(0x7fffde, 23),
  const EncodedHuffmanValue(0xffffeb, 24),
  const EncodedHuffmanValue(0x7fffdf, 23),
  const EncodedHuffmanValue(0xffffec, 24),
  const EncodedHuffmanValue(0xffffed, 24),
  const EncodedHuffmanValue(0x3fffd7, 22),
  const EncodedHuffmanValue(0x7fffe0, 23),
  const EncodedHuffmanValue(0xffffee, 24),
  const EncodedHuffmanValue(0x7fffe1, 23),
  const EncodedHuffmanValue(0x7fffe2, 23),
  const EncodedHuffmanValue(0x7fffe3, 23),
  const EncodedHuffmanValue(0x7fffe4, 23),
  const EncodedHuffmanValue(0x1fffdc, 21),
  const EncodedHuffmanValue(0x3fffd8, 22),
  const EncodedHuffmanValue(0x7fffe5, 23),
  const EncodedHuffmanValue(0x3fffd9, 22),
  const EncodedHuffmanValue(0x7fffe6, 23),
  const EncodedHuffmanValue(0x7fffe7, 23),
  const EncodedHuffmanValue(0xffffef, 24),
  const EncodedHuffmanValue(0x3fffda, 22),
  const EncodedHuffmanValue(0x1fffdd, 21),
  const EncodedHuffmanValue(0xfffe9, 20),
  const EncodedHuffmanValue(0x3fffdb, 22),
  const EncodedHuffmanValue(0x3fffdc, 22),
  const EncodedHuffmanValue(0x7fffe8, 23),
  const EncodedHuffmanValue(0x7fffe9, 23),
  const EncodedHuffmanValue(0x1fffde, 21),
  const EncodedHuffmanValue(0x7fffea, 23),
  const EncodedHuffmanValue(0x3fffdd, 22),
  const EncodedHuffmanValue(0x3fffde, 22),
  const EncodedHuffmanValue(0xfffff0, 24),
  const EncodedHuffmanValue(0x1fffdf, 21),
  const EncodedHuffmanValue(0x3fffdf, 22),
  const EncodedHuffmanValue(0x7fffeb, 23),
  const EncodedHuffmanValue(0x7fffec, 23),
  const EncodedHuffmanValue(0x1fffe0, 21),
  const EncodedHuffmanValue(0x1fffe1, 21),
  const EncodedHuffmanValue(0x3fffe0, 22),
  const EncodedHuffmanValue(0x1fffe2, 21),
  const EncodedHuffmanValue(0x7fffed, 23),
  const EncodedHuffmanValue(0x3fffe1, 22),
  const EncodedHuffmanValue(0x7fffee, 23),
  const EncodedHuffmanValue(0x7fffef, 23),
  const EncodedHuffmanValue(0xfffea, 20),
  const EncodedHuffmanValue(0x3fffe2, 22),
  const EncodedHuffmanValue(0x3fffe3, 22),
  const EncodedHuffmanValue(0x3fffe4, 22),
  const EncodedHuffmanValue(0x7ffff0, 23),
  const EncodedHuffmanValue(0x3fffe5, 22),
  const EncodedHuffmanValue(0x3fffe6, 22),
  const EncodedHuffmanValue(0x7ffff1, 23),
  const EncodedHuffmanValue(0x3ffffe0, 26),
  const EncodedHuffmanValue(0x3ffffe1, 26),
  const EncodedHuffmanValue(0xfffeb, 20),
  const EncodedHuffmanValue(0x7fff1, 19),
  const EncodedHuffmanValue(0x3fffe7, 22),
  const EncodedHuffmanValue(0x7ffff2, 23),
  const EncodedHuffmanValue(0x3fffe8, 22),
  const EncodedHuffmanValue(0x1ffffec, 25),
  const EncodedHuffmanValue(0x3ffffe2, 26),
  const EncodedHuffmanValue(0x3ffffe3, 26),
  const EncodedHuffmanValue(0x3ffffe4, 26),
  const EncodedHuffmanValue(0x7ffffde, 27),
  const EncodedHuffmanValue(0x7ffffdf, 27),
  const EncodedHuffmanValue(0x3ffffe5, 26),
  const EncodedHuffmanValue(0xfffff1, 24),
  const EncodedHuffmanValue(0x1ffffed, 25),
  const EncodedHuffmanValue(0x7fff2, 19),
  const EncodedHuffmanValue(0x1fffe3, 21),
  const EncodedHuffmanValue(0x3ffffe6, 26),
  const EncodedHuffmanValue(0x7ffffe0, 27),
  const EncodedHuffmanValue(0x7ffffe1, 27),
  const EncodedHuffmanValue(0x3ffffe7, 26),
  const EncodedHuffmanValue(0x7ffffe2, 27),
  const EncodedHuffmanValue(0xfffff2, 24),
  const EncodedHuffmanValue(0x1fffe4, 21),
  const EncodedHuffmanValue(0x1fffe5, 21),
  const EncodedHuffmanValue(0x3ffffe8, 26),
  const EncodedHuffmanValue(0x3ffffe9, 26),
  const EncodedHuffmanValue(0xffffffd, 28),
  const EncodedHuffmanValue(0x7ffffe3, 27),
  const EncodedHuffmanValue(0x7ffffe4, 27),
  const EncodedHuffmanValue(0x7ffffe5, 27),
  const EncodedHuffmanValue(0xfffec, 20),
  const EncodedHuffmanValue(0xfffff3, 24),
  const EncodedHuffmanValue(0xfffed, 20),
  const EncodedHuffmanValue(0x1fffe6, 21),
  const EncodedHuffmanValue(0x3fffe9, 22),
  const EncodedHuffmanValue(0x1fffe7, 21),
  const EncodedHuffmanValue(0x1fffe8, 21),
  const EncodedHuffmanValue(0x7ffff3, 23),
  const EncodedHuffmanValue(0x3fffea, 22),
  const EncodedHuffmanValue(0x3fffeb, 22),
  const EncodedHuffmanValue(0x1ffffee, 25),
  const EncodedHuffmanValue(0x1ffffef, 25),
  const EncodedHuffmanValue(0xfffff4, 24),
  const EncodedHuffmanValue(0xfffff5, 24),
  const EncodedHuffmanValue(0x3ffffea, 26),
  const EncodedHuffmanValue(0x7ffff4, 23),
  const EncodedHuffmanValue(0x3ffffeb, 26),
  const EncodedHuffmanValue(0x7ffffe6, 27),
  const EncodedHuffmanValue(0x3ffffec, 26),
  const EncodedHuffmanValue(0x3ffffed, 26),
  const EncodedHuffmanValue(0x7ffffe7, 27),
  const EncodedHuffmanValue(0x7ffffe8, 27),
  const EncodedHuffmanValue(0x7ffffe9, 27),
  const EncodedHuffmanValue(0x7ffffea, 27),
  const EncodedHuffmanValue(0x7ffffeb, 27),
  const EncodedHuffmanValue(0xffffffe, 28),
  const EncodedHuffmanValue(0x7ffffec, 27),
  const EncodedHuffmanValue(0x7ffffed, 27),
  const EncodedHuffmanValue(0x7ffffee, 27),
  const EncodedHuffmanValue(0x7ffffef, 27),
  const EncodedHuffmanValue(0x7fffff0, 27),
  const EncodedHuffmanValue(0x3ffffee, 26),
  const EncodedHuffmanValue(0x3fffffff, 30),
];
