// <auto-generated/> by Diplomat

#pragma warning disable 0105
using System;
using System.Runtime.InteropServices;

using DiplomatFeatures.Diplomat;
#pragma warning restore 0105

namespace DiplomatFeatures;

#nullable enable

public partial class Float64Vec: IDisposable
{
    private unsafe Raw.Float64Vec* _inner;

    /// <summary>
    /// Creates a managed <c>Float64Vec</c> from a raw handle.
    /// </summary>
    /// <remarks>
    /// Safety: you should not build two managed objects using the same raw handle (may causes use-after-free and double-free).
    /// <br/>
    /// This constructor assumes the raw struct is allocated on Rust side.
    /// If implemented, the custom Drop implementation on Rust side WILL run on destruction.
    /// </remarks>
    public unsafe Float64Vec(Raw.Float64Vec* handle)
    {
        _inner = handle;
    }

    /// <returns>
    /// A <c>Float64Vec</c> allocated on Rust side.
    /// </returns>
    public static Float64Vec New(double[] v)
    {
        unsafe
        {
            nuint vLength = (nuint)v.Length;
            fixed (double* vPtr = v)
            {
                Raw.Float64Vec* retVal = Raw.Float64Vec.New(vPtr, vLength);
                return new Float64Vec(retVal);
            }
        }
    }

    public void FillSlice(double[] v)
    {
        unsafe
        {
            if (_inner == null)
            {
                throw new ObjectDisposedException("Float64Vec");
            }
            nuint vLength = (nuint)v.Length;
            fixed (double* vPtr = v)
            {
                Raw.Float64Vec.FillSlice(_inner, vPtr, vLength);
            }
        }
    }

    public void SetValue(double[] newSlice)
    {
        unsafe
        {
            if (_inner == null)
            {
                throw new ObjectDisposedException("Float64Vec");
            }
            nuint newSliceLength = (nuint)newSlice.Length;
            fixed (double* newSlicePtr = newSlice)
            {
                Raw.Float64Vec.SetValue(_inner, newSlicePtr, newSliceLength);
            }
        }
    }

    /// <summary>
    /// Returns the underlying raw handle.
    /// </summary>
    public unsafe Raw.Float64Vec* AsFFI()
    {
        return _inner;
    }

    /// <summary>
    /// Destroys the underlying object immediately.
    /// </summary>
    public void Dispose()
    {
        unsafe
        {
            if (_inner == null)
            {
                return;
            }

            Raw.Float64Vec.Destroy(_inner);
            _inner = null;

            GC.SuppressFinalize(this);
        }
    }

    ~Float64Vec()
    {
        Dispose();
    }
}
