// swift-tools-version:5.0
// The swift-tools-version declares the minimum version of Swift required to build this package.

import PackageDescription

let package = Package(
  name: "BoringSSL-GRPC",
  products: [
    .library(
      name: "openssl_grpc",
      targets: ["openssl_grpc"]
    )
  ],

  targets: [
    .target(
      name: "openssl_grpc",
      path: ".",
      exclude: [
        ".build/",
        ".git/",
        ".github/",
        ".swiftpm/",
        "BUILD",
        "BUILD.generated.bzl",
        "BUILD.generated_tests.bzl",
        "CMakeLists.txt",
        "LICENSE",
        "Package.swift",
        "WORKSPACE",
        "crypto_test_data.cc",
        "ios-aarch64/",
        "ios-arm/",
        "linux-aarch64/",
        "linux-arm/",
        "linux-ppc64le/",
        "linux-x86/",
        "linux-x86_64/",
        "mac-x86/",
        "mac-x86_64/",
        "win-x86/",
        "win-x86_64/",
        "src/util/",
        "src/ssl/test/",
        "src/ssl/span_test.cc",
        "src/ssl/ssl_test.cc",
        "src/crypto/fipsmodule/bcm.c",
        "src/crypto/abi_self_test.cc",
        "src/crypto/compiler_test.cc",
        "src/crypto/constant_time_test.cc",
        "src/crypto/cpu-arm-linux_test.cc",
        "src/crypto/impl_dispatch_test.cc",
        "src/crypto/refcount_test.cc",
        "src/crypto/self_test.cc",
        "src/crypto/thread_test.cc",
        "src/crypto/asn1/asn1_test.cc",
        "src/crypto/base64/base64_test.cc",
        "src/crypto/bio/bio_test.cc",
        "src/crypto/buf/buf_test.cc",
        "src/crypto/bytestring/bytestring_test.cc",
        "src/crypto/chacha/chacha_test.cc",
        "src/crypto/cipher_extra/aead_test.cc",
        "src/crypto/cipher_extra/cipher_test.cc",
        "src/crypto/cmac/cmac_test.cc",
        "src/crypto/curve25519/ed25519_test.cc",
        "src/crypto/curve25519/spake25519_test.cc",
        "src/crypto/curve25519/x25519_test.cc",
        "src/crypto/dh/dh_test.cc",
        "src/crypto/digest_extra/digest_test.cc",
        "src/crypto/dsa/dsa_test.cc",
        "src/crypto/ecdh_extra/ecdh_test.cc",
        "src/crypto/err/err_test.cc",
        "src/crypto/evp/evp_extra_test.cc",
        "src/crypto/evp/evp_test.cc",
        "src/crypto/evp/pbkdf_test.cc",
        "src/crypto/evp/scrypt_test.cc",
        "src/crypto/hkdf/hkdf_test.cc",
        "src/crypto/hmac_extra/hmac_test.cc",
        "src/crypto/hrss/hrss_test.cc",
        "src/crypto/lhash/lhash_test.cc",
        "src/crypto/obj/obj_test.cc",
        "src/crypto/pem/pem_test.cc",
        "src/crypto/pkcs7/pkcs7_test.cc",
        "src/crypto/pkcs8/pkcs12_test.cc",
        "src/crypto/pkcs8/pkcs8_test.cc",
        "src/crypto/poly1305/poly1305_test.cc",
        "src/crypto/pool/pool_test.cc",
        "src/crypto/rand_extra/rand_test.cc",
        "src/crypto/rsa_extra/rsa_test.cc",
        "src/crypto/siphash/siphash_test.cc",
        "src/crypto/stack/stack_test.cc",
        "src/crypto/test/",
        "src/crypto/trust_token/trust_token_test.cc",
        "src/crypto/x509/x509_test.cc",
        "src/crypto/x509/x509_time_test.cc",
        "src/crypto/x509v3/tab_test.cc",
        "src/crypto/x509v3/v3name_test.cc",
        "src/ssl/test/test_config.cc",
        "src/ssl/test/test_state.cc",
        "src/crypto/fipsmodule/aes/aes_test.cc",
        "src/crypto/fipsmodule/bn/bn_test.cc",
        "src/crypto/fipsmodule/ec/ec_test.cc",
        "src/crypto/fipsmodule/ec/p256-x86_64_test.cc",
        "src/crypto/fipsmodule/ecdsa/ecdsa_test.cc",
        "src/crypto/fipsmodule/md5/md5_test.cc",
        "src/crypto/fipsmodule/modes/gcm_test.cc",
        "src/crypto/fipsmodule/rand/ctrdrbg_test.cc",
        "src/crypto/fipsmodule/rand/fork_detect_test.cc",
        "src/crypto/fipsmodule/rand/urandom_test.cc",
        "src/crypto/fipsmodule/sha/sha_test.cc",
      ],
      sources: [
        "err_data.c",
        "src/crypto/",
        "src/ssl/",
        "src/table/",
        "src/third_party/fiat/",
        "src/include/",
      ],
      publicHeadersPath: "src/include",
      cSettings: [
        .define("OPENSSL_NO_ASM", to: "1"),
        .headerSearchPath("./"),
        .headerSearchPath("include/"),
        // .define("a2i_GENERAL_NAME", to: "GRPC_SHADOW_a2i_GENERAL_NAME"),
        // .define("a2i_ipadd", to: "GRPC_SHADOW_a2i_ipadd"),
        // .define("a2i_IPADDRESS", to: "GRPC_SHADOW_a2i_IPADDRESS"),
        // .define("a2i_IPADDRESS_NC", to: "GRPC_SHADOW_a2i_IPADDRESS_NC"),
        // .define("abi_test_bad_unwind_temporary", to: "GRPC_SHADOW_abi_test_bad_unwind_temporary"),
        // .define("abi_test_bad_unwind_wrong_register", to: "GRPC_SHADOW_abi_test_bad_unwind_wrong_register"),
        // .define("abi_test_clobber_r10", to: "GRPC_SHADOW_abi_test_clobber_r10"),
        // .define("abi_test_clobber_r11", to: "GRPC_SHADOW_abi_test_clobber_r11"),
        // .define("abi_test_clobber_r12", to: "GRPC_SHADOW_abi_test_clobber_r12"),
        // .define("abi_test_clobber_r13", to: "GRPC_SHADOW_abi_test_clobber_r13"),
        // .define("abi_test_clobber_r14", to: "GRPC_SHADOW_abi_test_clobber_r14"),
        // .define("abi_test_clobber_r15", to: "GRPC_SHADOW_abi_test_clobber_r15"),
        // .define("abi_test_clobber_r8", to: "GRPC_SHADOW_abi_test_clobber_r8"),
        // .define("abi_test_clobber_r9", to: "GRPC_SHADOW_abi_test_clobber_r9"),
        // .define("abi_test_clobber_rax", to: "GRPC_SHADOW_abi_test_clobber_rax"),
        // .define("abi_test_clobber_rbp", to: "GRPC_SHADOW_abi_test_clobber_rbp"),
        // .define("abi_test_clobber_rbx", to: "GRPC_SHADOW_abi_test_clobber_rbx"),
        // .define("abi_test_clobber_rcx", to: "GRPC_SHADOW_abi_test_clobber_rcx"),
        // .define("abi_test_clobber_rdi", to: "GRPC_SHADOW_abi_test_clobber_rdi"),
        // .define("abi_test_clobber_rdx", to: "GRPC_SHADOW_abi_test_clobber_rdx"),
        // .define("abi_test_clobber_rsi", to: "GRPC_SHADOW_abi_test_clobber_rsi"),
        // .define("abi_test_clobber_xmm0", to: "GRPC_SHADOW_abi_test_clobber_xmm0"),
        // .define("abi_test_clobber_xmm1", to: "GRPC_SHADOW_abi_test_clobber_xmm1"),
        // .define("abi_test_clobber_xmm10", to: "GRPC_SHADOW_abi_test_clobber_xmm10"),
        // .define("abi_test_clobber_xmm11", to: "GRPC_SHADOW_abi_test_clobber_xmm11"),
        // .define("abi_test_clobber_xmm12", to: "GRPC_SHADOW_abi_test_clobber_xmm12"),
        // .define("abi_test_clobber_xmm13", to: "GRPC_SHADOW_abi_test_clobber_xmm13"),
        // .define("abi_test_clobber_xmm14", to: "GRPC_SHADOW_abi_test_clobber_xmm14"),
        // .define("abi_test_clobber_xmm15", to: "GRPC_SHADOW_abi_test_clobber_xmm15"),
        // .define("abi_test_clobber_xmm2", to: "GRPC_SHADOW_abi_test_clobber_xmm2"),
        // .define("abi_test_clobber_xmm3", to: "GRPC_SHADOW_abi_test_clobber_xmm3"),
        // .define("abi_test_clobber_xmm4", to: "GRPC_SHADOW_abi_test_clobber_xmm4"),
        // .define("abi_test_clobber_xmm5", to: "GRPC_SHADOW_abi_test_clobber_xmm5"),
        // .define("abi_test_clobber_xmm6", to: "GRPC_SHADOW_abi_test_clobber_xmm6"),
        // .define("abi_test_clobber_xmm7", to: "GRPC_SHADOW_abi_test_clobber_xmm7"),
        // .define("abi_test_clobber_xmm8", to: "GRPC_SHADOW_abi_test_clobber_xmm8"),
        // .define("abi_test_clobber_xmm9", to: "GRPC_SHADOW_abi_test_clobber_xmm9"),
        // .define("abi_test_get_and_clear_direction_flag", to: "GRPC_SHADOW_abi_test_get_and_clear_direction_flag"),
        // .define("abi_test_set_direction_flag", to: "GRPC_SHADOW_abi_test_set_direction_flag"),
        // .define("abi_test_trampoline", to: "GRPC_SHADOW_abi_test_trampoline"),
        // .define("abi_test_unwind_return", to: "GRPC_SHADOW_abi_test_unwind_return"),
        // .define("abi_test_unwind_start", to: "GRPC_SHADOW_abi_test_unwind_start"),
        // .define("abi_test_unwind_stop", to: "GRPC_SHADOW_abi_test_unwind_stop"),
        // .define("ACCESS_DESCRIPTION_free", to: "GRPC_SHADOW_ACCESS_DESCRIPTION_free"),
        // .define("ACCESS_DESCRIPTION_it", to: "GRPC_SHADOW_ACCESS_DESCRIPTION_it"),
        // .define("ACCESS_DESCRIPTION_new", to: "GRPC_SHADOW_ACCESS_DESCRIPTION_new"),
        // .define("aes128gcmsiv_aes_ks", to: "GRPC_SHADOW_aes128gcmsiv_aes_ks"),
        // .define("aes128gcmsiv_aes_ks_enc_x1", to: "GRPC_SHADOW_aes128gcmsiv_aes_ks_enc_x1"),
        // .define("aes128gcmsiv_dec", to: "GRPC_SHADOW_aes128gcmsiv_dec"),
        // .define("aes128gcmsiv_ecb_enc_block", to: "GRPC_SHADOW_aes128gcmsiv_ecb_enc_block"),
        // .define("aes128gcmsiv_enc_msg_x4", to: "GRPC_SHADOW_aes128gcmsiv_enc_msg_x4"),
        // .define("aes128gcmsiv_enc_msg_x8", to: "GRPC_SHADOW_aes128gcmsiv_enc_msg_x8"),
        // .define("aes128gcmsiv_kdf", to: "GRPC_SHADOW_aes128gcmsiv_kdf"),
        // .define("aes256gcmsiv_aes_ks", to: "GRPC_SHADOW_aes256gcmsiv_aes_ks"),
        // .define("aes256gcmsiv_aes_ks_enc_x1", to: "GRPC_SHADOW_aes256gcmsiv_aes_ks_enc_x1"),
        // .define("aes256gcmsiv_dec", to: "GRPC_SHADOW_aes256gcmsiv_dec"),
        // .define("aes256gcmsiv_ecb_enc_block", to: "GRPC_SHADOW_aes256gcmsiv_ecb_enc_block"),
        // .define("aes256gcmsiv_enc_msg_x4", to: "GRPC_SHADOW_aes256gcmsiv_enc_msg_x4"),
        // .define("aes256gcmsiv_enc_msg_x8", to: "GRPC_SHADOW_aes256gcmsiv_enc_msg_x8"),
        // .define("aes256gcmsiv_kdf", to: "GRPC_SHADOW_aes256gcmsiv_kdf"),
        // .define("AES_cbc_encrypt", to: "GRPC_SHADOW_AES_cbc_encrypt"),
        // .define("AES_cfb128_encrypt", to: "GRPC_SHADOW_AES_cfb128_encrypt"),
        // .define("AES_CMAC", to: "GRPC_SHADOW_AES_CMAC"),
        // .define("AES_ctr128_encrypt", to: "GRPC_SHADOW_AES_ctr128_encrypt"),
        // .define("aes_ctr_set_key", to: "GRPC_SHADOW_aes_ctr_set_key"),
        // .define("AES_decrypt", to: "GRPC_SHADOW_AES_decrypt"),
        // .define("AES_ecb_encrypt", to: "GRPC_SHADOW_AES_ecb_encrypt"),
        // .define("AES_encrypt", to: "GRPC_SHADOW_AES_encrypt"),
        // .define("aesgcmsiv_htable6_init", to: "GRPC_SHADOW_aesgcmsiv_htable6_init"),
        // .define("aesgcmsiv_htable_init", to: "GRPC_SHADOW_aesgcmsiv_htable_init"),
        // .define("aesgcmsiv_htable_polyval", to: "GRPC_SHADOW_aesgcmsiv_htable_polyval"),
        // .define("aesgcmsiv_polyval_horner", to: "GRPC_SHADOW_aesgcmsiv_polyval_horner"),
        // .define("aes_hw_cbc_encrypt", to: "GRPC_SHADOW_aes_hw_cbc_encrypt"),
        // .define("aes_hw_ctr32_encrypt_blocks", to: "GRPC_SHADOW_aes_hw_ctr32_encrypt_blocks"),
        // .define("aes_hw_decrypt", to: "GRPC_SHADOW_aes_hw_decrypt"),
        // .define("aes_hw_ecb_encrypt", to: "GRPC_SHADOW_aes_hw_ecb_encrypt"),
        // .define("aes_hw_encrypt", to: "GRPC_SHADOW_aes_hw_encrypt"),
        // .define("aes_hw_set_decrypt_key", to: "GRPC_SHADOW_aes_hw_set_decrypt_key"),
        // .define("aes_hw_set_encrypt_key", to: "GRPC_SHADOW_aes_hw_set_encrypt_key"),
        // .define("aesni_gcm_decrypt", to: "GRPC_SHADOW_aesni_gcm_decrypt"),
        // .define("aesni_gcm_encrypt", to: "GRPC_SHADOW_aesni_gcm_encrypt"),
        // .define("aes_nohw_cbc_encrypt", to: "GRPC_SHADOW_aes_nohw_cbc_encrypt"),
        // .define("aes_nohw_ctr32_encrypt_blocks", to: "GRPC_SHADOW_aes_nohw_ctr32_encrypt_blocks"),
        // .define("aes_nohw_decrypt", to: "GRPC_SHADOW_aes_nohw_decrypt"),
        // .define("aes_nohw_encrypt", to: "GRPC_SHADOW_aes_nohw_encrypt"),
        // .define("aes_nohw_set_decrypt_key", to: "GRPC_SHADOW_aes_nohw_set_decrypt_key"),
        // .define("aes_nohw_set_encrypt_key", to: "GRPC_SHADOW_aes_nohw_set_encrypt_key"),
        // .define("AES_ofb128_encrypt", to: "GRPC_SHADOW_AES_ofb128_encrypt"),
        // .define("AES_set_decrypt_key", to: "GRPC_SHADOW_AES_set_decrypt_key"),
        // .define("AES_set_encrypt_key", to: "GRPC_SHADOW_AES_set_encrypt_key"),
        // .define("AES_unwrap_key", to: "GRPC_SHADOW_AES_unwrap_key"),
        // .define("AES_unwrap_key_padded", to: "GRPC_SHADOW_AES_unwrap_key_padded"),
        // .define("AES_wrap_key", to: "GRPC_SHADOW_AES_wrap_key"),
        // .define("AES_wrap_key_padded", to: "GRPC_SHADOW_AES_wrap_key_padded"),
        // .define("ASN1_ANY_it", to: "GRPC_SHADOW_ASN1_ANY_it"),
        // .define("ASN1_BIT_STRING_check", to: "GRPC_SHADOW_ASN1_BIT_STRING_check"),
        // .define("ASN1_BIT_STRING_free", to: "GRPC_SHADOW_ASN1_BIT_STRING_free"),
        // .define("ASN1_BIT_STRING_get_bit", to: "GRPC_SHADOW_ASN1_BIT_STRING_get_bit"),
        // .define("ASN1_BIT_STRING_it", to: "GRPC_SHADOW_ASN1_BIT_STRING_it"),
        // .define("ASN1_BIT_STRING_new", to: "GRPC_SHADOW_ASN1_BIT_STRING_new"),
        // .define("ASN1_BIT_STRING_set", to: "GRPC_SHADOW_ASN1_BIT_STRING_set"),
        // .define("ASN1_BIT_STRING_set_bit", to: "GRPC_SHADOW_ASN1_BIT_STRING_set_bit"),
        // .define("ASN1_BMPSTRING_free", to: "GRPC_SHADOW_ASN1_BMPSTRING_free"),
        // .define("ASN1_BMPSTRING_it", to: "GRPC_SHADOW_ASN1_BMPSTRING_it"),
        // .define("ASN1_BMPSTRING_new", to: "GRPC_SHADOW_ASN1_BMPSTRING_new"),
        // .define("ASN1_BOOLEAN_it", to: "GRPC_SHADOW_ASN1_BOOLEAN_it"),
        // .define("ASN1_digest", to: "GRPC_SHADOW_ASN1_digest"),
        // .define("asn1_do_adb", to: "GRPC_SHADOW_asn1_do_adb"),
        // .define("asn1_enc_free", to: "GRPC_SHADOW_asn1_enc_free"),
        // .define("asn1_enc_init", to: "GRPC_SHADOW_asn1_enc_init"),
        // .define("asn1_enc_restore", to: "GRPC_SHADOW_asn1_enc_restore"),
        // .define("asn1_enc_save", to: "GRPC_SHADOW_asn1_enc_save"),
        // .define("ASN1_ENUMERATED_free", to: "GRPC_SHADOW_ASN1_ENUMERATED_free"),
        // .define("ASN1_ENUMERATED_get", to: "GRPC_SHADOW_ASN1_ENUMERATED_get"),
        // .define("ASN1_ENUMERATED_it", to: "GRPC_SHADOW_ASN1_ENUMERATED_it"),
        // .define("ASN1_ENUMERATED_new", to: "GRPC_SHADOW_ASN1_ENUMERATED_new"),
        // .define("ASN1_ENUMERATED_set", to: "GRPC_SHADOW_ASN1_ENUMERATED_set"),
        // .define("ASN1_ENUMERATED_to_BN", to: "GRPC_SHADOW_ASN1_ENUMERATED_to_BN"),
        // .define("asn1_ex_c2i", to: "GRPC_SHADOW_asn1_ex_c2i"),
        // .define("asn1_ex_i2c", to: "GRPC_SHADOW_asn1_ex_i2c"),
        // .define("ASN1_FBOOLEAN_it", to: "GRPC_SHADOW_ASN1_FBOOLEAN_it"),
        // .define("ASN1_GENERALIZEDTIME_adj", to: "GRPC_SHADOW_ASN1_GENERALIZEDTIME_adj"),
        // .define("ASN1_GENERALIZEDTIME_check", to: "GRPC_SHADOW_ASN1_GENERALIZEDTIME_check"),
        // .define("ASN1_GENERALIZEDTIME_free", to: "GRPC_SHADOW_ASN1_GENERALIZEDTIME_free"),
        // .define("ASN1_GENERALIZEDTIME_it", to: "GRPC_SHADOW_ASN1_GENERALIZEDTIME_it"),
        // .define("ASN1_GENERALIZEDTIME_new", to: "GRPC_SHADOW_ASN1_GENERALIZEDTIME_new"),
        // .define("ASN1_GENERALIZEDTIME_print", to: "GRPC_SHADOW_ASN1_GENERALIZEDTIME_print"),
        // .define("ASN1_GENERALIZEDTIME_set", to: "GRPC_SHADOW_ASN1_GENERALIZEDTIME_set"),
        // .define("ASN1_GENERALIZEDTIME_set_string", to: "GRPC_SHADOW_ASN1_GENERALIZEDTIME_set_string"),
        // .define("asn1_generalizedtime_to_tm", to: "GRPC_SHADOW_asn1_generalizedtime_to_tm"),
        // .define("ASN1_GENERALSTRING_free", to: "GRPC_SHADOW_ASN1_GENERALSTRING_free"),
        // .define("ASN1_GENERALSTRING_it", to: "GRPC_SHADOW_ASN1_GENERALSTRING_it"),
        // .define("ASN1_GENERALSTRING_new", to: "GRPC_SHADOW_ASN1_GENERALSTRING_new"),
        // .define("ASN1_generate_nconf", to: "GRPC_SHADOW_ASN1_generate_nconf"),
        // .define("ASN1_generate_v3", to: "GRPC_SHADOW_ASN1_generate_v3"),
        // .define("asn1_get_choice_selector", to: "GRPC_SHADOW_asn1_get_choice_selector"),
        // .define("asn1_get_field_ptr", to: "GRPC_SHADOW_asn1_get_field_ptr"),
        // .define("ASN1_get_object", to: "GRPC_SHADOW_ASN1_get_object"),
        // .define("ASN1_IA5STRING_free", to: "GRPC_SHADOW_ASN1_IA5STRING_free"),
        // .define("ASN1_IA5STRING_it", to: "GRPC_SHADOW_ASN1_IA5STRING_it"),
        // .define("ASN1_IA5STRING_new", to: "GRPC_SHADOW_ASN1_IA5STRING_new"),
        // .define("ASN1_INTEGER_cmp", to: "GRPC_SHADOW_ASN1_INTEGER_cmp"),
        // .define("ASN1_INTEGER_dup", to: "GRPC_SHADOW_ASN1_INTEGER_dup"),
        // .define("ASN1_INTEGER_free", to: "GRPC_SHADOW_ASN1_INTEGER_free"),
        // .define("ASN1_INTEGER_get", to: "GRPC_SHADOW_ASN1_INTEGER_get"),
        // .define("ASN1_INTEGER_it", to: "GRPC_SHADOW_ASN1_INTEGER_it"),
        // .define("ASN1_INTEGER_new", to: "GRPC_SHADOW_ASN1_INTEGER_new"),
        // .define("ASN1_INTEGER_set", to: "GRPC_SHADOW_ASN1_INTEGER_set"),
        // .define("ASN1_INTEGER_set_uint64", to: "GRPC_SHADOW_ASN1_INTEGER_set_uint64"),
        // .define("ASN1_INTEGER_to_BN", to: "GRPC_SHADOW_ASN1_INTEGER_to_BN"),
        // .define("asn1_item_combine_free", to: "GRPC_SHADOW_asn1_item_combine_free"),
        // .define("ASN1_item_d2i", to: "GRPC_SHADOW_ASN1_item_d2i"),
        // .define("ASN1_item_d2i_bio", to: "GRPC_SHADOW_ASN1_item_d2i_bio"),
        // .define("ASN1_item_d2i_fp", to: "GRPC_SHADOW_ASN1_item_d2i_fp"),
        // .define("ASN1_item_digest", to: "GRPC_SHADOW_ASN1_item_digest"),
        // .define("ASN1_item_dup", to: "GRPC_SHADOW_ASN1_item_dup"),
        // .define("ASN1_item_ex_d2i", to: "GRPC_SHADOW_ASN1_item_ex_d2i"),
        // .define("ASN1_item_ex_free", to: "GRPC_SHADOW_ASN1_item_ex_free"),
        // .define("ASN1_item_ex_i2d", to: "GRPC_SHADOW_ASN1_item_ex_i2d"),
        // .define("ASN1_item_ex_new", to: "GRPC_SHADOW_ASN1_item_ex_new"),
        // .define("ASN1_item_free", to: "GRPC_SHADOW_ASN1_item_free"),
        // .define("ASN1_item_i2d", to: "GRPC_SHADOW_ASN1_item_i2d"),
        // .define("ASN1_item_i2d_bio", to: "GRPC_SHADOW_ASN1_item_i2d_bio"),
        // .define("ASN1_item_i2d_fp", to: "GRPC_SHADOW_ASN1_item_i2d_fp"),
        // .define("ASN1_item_ndef_i2d", to: "GRPC_SHADOW_ASN1_item_ndef_i2d"),
        // .define("ASN1_item_new", to: "GRPC_SHADOW_ASN1_item_new"),
        // .define("ASN1_item_pack", to: "GRPC_SHADOW_ASN1_item_pack"),
        // .define("ASN1_item_sign", to: "GRPC_SHADOW_ASN1_item_sign"),
        // .define("ASN1_item_sign_ctx", to: "GRPC_SHADOW_ASN1_item_sign_ctx"),
        // .define("ASN1_item_unpack", to: "GRPC_SHADOW_ASN1_item_unpack"),
        // .define("ASN1_item_verify", to: "GRPC_SHADOW_ASN1_item_verify"),
        // .define("ASN1_mbstring_copy", to: "GRPC_SHADOW_ASN1_mbstring_copy"),
        // .define("ASN1_mbstring_ncopy", to: "GRPC_SHADOW_ASN1_mbstring_ncopy"),
        // .define("ASN1_NULL_free", to: "GRPC_SHADOW_ASN1_NULL_free"),
        // .define("ASN1_NULL_it", to: "GRPC_SHADOW_ASN1_NULL_it"),
        // .define("ASN1_NULL_new", to: "GRPC_SHADOW_ASN1_NULL_new"),
        // .define("ASN1_OBJECT_create", to: "GRPC_SHADOW_ASN1_OBJECT_create"),
        // .define("ASN1_OBJECT_free", to: "GRPC_SHADOW_ASN1_OBJECT_free"),
        // .define("ASN1_OBJECT_it", to: "GRPC_SHADOW_ASN1_OBJECT_it"),
        // .define("ASN1_OBJECT_new", to: "GRPC_SHADOW_ASN1_OBJECT_new"),
        // .define("ASN1_object_size", to: "GRPC_SHADOW_ASN1_object_size"),
        // .define("ASN1_OCTET_STRING_cmp", to: "GRPC_SHADOW_ASN1_OCTET_STRING_cmp"),
        // .define("ASN1_OCTET_STRING_dup", to: "GRPC_SHADOW_ASN1_OCTET_STRING_dup"),
        // .define("ASN1_OCTET_STRING_free", to: "GRPC_SHADOW_ASN1_OCTET_STRING_free"),
        // .define("ASN1_OCTET_STRING_it", to: "GRPC_SHADOW_ASN1_OCTET_STRING_it"),
        // .define("ASN1_OCTET_STRING_NDEF_it", to: "GRPC_SHADOW_ASN1_OCTET_STRING_NDEF_it"),
        // .define("ASN1_OCTET_STRING_new", to: "GRPC_SHADOW_ASN1_OCTET_STRING_new"),
        // .define("ASN1_OCTET_STRING_set", to: "GRPC_SHADOW_ASN1_OCTET_STRING_set"),
        // .define("ASN1_primitive_free", to: "GRPC_SHADOW_ASN1_primitive_free"),
        // .define("ASN1_primitive_new", to: "GRPC_SHADOW_ASN1_primitive_new"),
        // .define("ASN1_PRINTABLE_free", to: "GRPC_SHADOW_ASN1_PRINTABLE_free"),
        // .define("ASN1_PRINTABLE_it", to: "GRPC_SHADOW_ASN1_PRINTABLE_it"),
        // .define("ASN1_PRINTABLE_new", to: "GRPC_SHADOW_ASN1_PRINTABLE_new"),
        // .define("ASN1_PRINTABLESTRING_free", to: "GRPC_SHADOW_ASN1_PRINTABLESTRING_free"),
        // .define("ASN1_PRINTABLESTRING_it", to: "GRPC_SHADOW_ASN1_PRINTABLESTRING_it"),
        // .define("ASN1_PRINTABLESTRING_new", to: "GRPC_SHADOW_ASN1_PRINTABLESTRING_new"),
        // .define("ASN1_PRINTABLE_type", to: "GRPC_SHADOW_ASN1_PRINTABLE_type"),
        // .define("ASN1_put_eoc", to: "GRPC_SHADOW_ASN1_put_eoc"),
        // .define("ASN1_put_object", to: "GRPC_SHADOW_ASN1_put_object"),
        // .define("asn1_refcount_dec_and_test_zero", to: "GRPC_SHADOW_asn1_refcount_dec_and_test_zero"),
        // .define("asn1_refcount_set_one", to: "GRPC_SHADOW_asn1_refcount_set_one"),
        // .define("ASN1_SEQUENCE_ANY_it", to: "GRPC_SHADOW_ASN1_SEQUENCE_ANY_it"),
        // .define("ASN1_SEQUENCE_it", to: "GRPC_SHADOW_ASN1_SEQUENCE_it"),
        // .define("ASN1_SET_ANY_it", to: "GRPC_SHADOW_ASN1_SET_ANY_it"),
        // .define("asn1_set_choice_selector", to: "GRPC_SHADOW_asn1_set_choice_selector"),
        // .define("ASN1_STRING_cmp", to: "GRPC_SHADOW_ASN1_STRING_cmp"),
        // .define("ASN1_STRING_copy", to: "GRPC_SHADOW_ASN1_STRING_copy"),
        // .define("ASN1_STRING_data", to: "GRPC_SHADOW_ASN1_STRING_data"),
        // .define("ASN1_STRING_dup", to: "GRPC_SHADOW_ASN1_STRING_dup"),
        // .define("ASN1_STRING_free", to: "GRPC_SHADOW_ASN1_STRING_free"),
        // .define("ASN1_STRING_get0_data", to: "GRPC_SHADOW_ASN1_STRING_get0_data"),
        // .define("ASN1_STRING_get_default_mask", to: "GRPC_SHADOW_ASN1_STRING_get_default_mask"),
        // .define("ASN1_STRING_length", to: "GRPC_SHADOW_ASN1_STRING_length"),
        // .define("ASN1_STRING_length_set", to: "GRPC_SHADOW_ASN1_STRING_length_set"),
        // .define("ASN1_STRING_new", to: "GRPC_SHADOW_ASN1_STRING_new"),
        // .define("ASN1_STRING_print", to: "GRPC_SHADOW_ASN1_STRING_print"),
        // .define("ASN1_STRING_print_ex", to: "GRPC_SHADOW_ASN1_STRING_print_ex"),
        // .define("ASN1_STRING_print_ex_fp", to: "GRPC_SHADOW_ASN1_STRING_print_ex_fp"),
        // .define("ASN1_STRING_set", to: "GRPC_SHADOW_ASN1_STRING_set"),
        // .define("ASN1_STRING_set0", to: "GRPC_SHADOW_ASN1_STRING_set0"),
        // .define("ASN1_STRING_set_by_NID", to: "GRPC_SHADOW_ASN1_STRING_set_by_NID"),
        // .define("ASN1_STRING_set_default_mask", to: "GRPC_SHADOW_ASN1_STRING_set_default_mask"),
        // .define("ASN1_STRING_set_default_mask_asc", to: "GRPC_SHADOW_ASN1_STRING_set_default_mask_asc"),
        // .define("ASN1_STRING_TABLE_add", to: "GRPC_SHADOW_ASN1_STRING_TABLE_add"),
        // .define("ASN1_STRING_TABLE_cleanup", to: "GRPC_SHADOW_ASN1_STRING_TABLE_cleanup"),
        // .define("ASN1_STRING_TABLE_get", to: "GRPC_SHADOW_ASN1_STRING_TABLE_get"),
        // .define("ASN1_STRING_to_UTF8", to: "GRPC_SHADOW_ASN1_STRING_to_UTF8"),
        // .define("ASN1_STRING_type", to: "GRPC_SHADOW_ASN1_STRING_type"),
        // .define("ASN1_STRING_type_new", to: "GRPC_SHADOW_ASN1_STRING_type_new"),
        // .define("ASN1_T61STRING_free", to: "GRPC_SHADOW_ASN1_T61STRING_free"),
        // .define("ASN1_T61STRING_it", to: "GRPC_SHADOW_ASN1_T61STRING_it"),
        // .define("ASN1_T61STRING_new", to: "GRPC_SHADOW_ASN1_T61STRING_new"),
        // .define("ASN1_tag2bit", to: "GRPC_SHADOW_ASN1_tag2bit"),
        // .define("ASN1_tag2str", to: "GRPC_SHADOW_ASN1_tag2str"),
        // .define("ASN1_TBOOLEAN_it", to: "GRPC_SHADOW_ASN1_TBOOLEAN_it"),
        // .define("ASN1_template_free", to: "GRPC_SHADOW_ASN1_template_free"),
        // .define("ASN1_template_new", to: "GRPC_SHADOW_ASN1_template_new"),
        // .define("ASN1_TIME_adj", to: "GRPC_SHADOW_ASN1_TIME_adj"),
        // .define("ASN1_TIME_check", to: "GRPC_SHADOW_ASN1_TIME_check"),
        // .define("ASN1_TIME_diff", to: "GRPC_SHADOW_ASN1_TIME_diff"),
        // .define("ASN1_TIME_free", to: "GRPC_SHADOW_ASN1_TIME_free"),
        // .define("ASN1_TIME_it", to: "GRPC_SHADOW_ASN1_TIME_it"),
        // .define("ASN1_TIME_new", to: "GRPC_SHADOW_ASN1_TIME_new"),
        // .define("ASN1_TIME_print", to: "GRPC_SHADOW_ASN1_TIME_print"),
        // .define("ASN1_TIME_set", to: "GRPC_SHADOW_ASN1_TIME_set"),
        // .define("ASN1_TIME_set_string", to: "GRPC_SHADOW_ASN1_TIME_set_string"),
        // .define("ASN1_TIME_to_generalizedtime", to: "GRPC_SHADOW_ASN1_TIME_to_generalizedtime"),
        // .define("ASN1_TYPE_cmp", to: "GRPC_SHADOW_ASN1_TYPE_cmp"),
        // .define("ASN1_TYPE_free", to: "GRPC_SHADOW_ASN1_TYPE_free"),
        // .define("ASN1_TYPE_get", to: "GRPC_SHADOW_ASN1_TYPE_get"),
        // .define("ASN1_TYPE_new", to: "GRPC_SHADOW_ASN1_TYPE_new"),
        // .define("ASN1_TYPE_set", to: "GRPC_SHADOW_ASN1_TYPE_set"),
        // .define("ASN1_TYPE_set1", to: "GRPC_SHADOW_ASN1_TYPE_set1"),
        // .define("ASN1_UNIVERSALSTRING_free", to: "GRPC_SHADOW_ASN1_UNIVERSALSTRING_free"),
        // .define("ASN1_UNIVERSALSTRING_it", to: "GRPC_SHADOW_ASN1_UNIVERSALSTRING_it"),
        // .define("ASN1_UNIVERSALSTRING_new", to: "GRPC_SHADOW_ASN1_UNIVERSALSTRING_new"),
        // .define("ASN1_UTCTIME_adj", to: "GRPC_SHADOW_ASN1_UTCTIME_adj"),
        // .define("ASN1_UTCTIME_check", to: "GRPC_SHADOW_ASN1_UTCTIME_check"),
        // .define("ASN1_UTCTIME_cmp_time_t", to: "GRPC_SHADOW_ASN1_UTCTIME_cmp_time_t"),
        // .define("ASN1_UTCTIME_free", to: "GRPC_SHADOW_ASN1_UTCTIME_free"),
        // .define("ASN1_UTCTIME_it", to: "GRPC_SHADOW_ASN1_UTCTIME_it"),
        // .define("ASN1_UTCTIME_new", to: "GRPC_SHADOW_ASN1_UTCTIME_new"),
        // .define("ASN1_UTCTIME_print", to: "GRPC_SHADOW_ASN1_UTCTIME_print"),
        // .define("ASN1_UTCTIME_set", to: "GRPC_SHADOW_ASN1_UTCTIME_set"),
        // .define("ASN1_UTCTIME_set_string", to: "GRPC_SHADOW_ASN1_UTCTIME_set_string"),
        // .define("asn1_utctime_to_tm", to: "GRPC_SHADOW_asn1_utctime_to_tm"),
        // .define("ASN1_UTF8STRING_free", to: "GRPC_SHADOW_ASN1_UTF8STRING_free"),
        // .define("ASN1_UTF8STRING_it", to: "GRPC_SHADOW_ASN1_UTF8STRING_it"),
        // .define("ASN1_UTF8STRING_new", to: "GRPC_SHADOW_ASN1_UTF8STRING_new"),
        // .define("ASN1_VISIBLESTRING_free", to: "GRPC_SHADOW_ASN1_VISIBLESTRING_free"),
        // .define("ASN1_VISIBLESTRING_it", to: "GRPC_SHADOW_ASN1_VISIBLESTRING_it"),
        // .define("ASN1_VISIBLESTRING_new", to: "GRPC_SHADOW_ASN1_VISIBLESTRING_new"),
        // .define("AUTHORITY_INFO_ACCESS_free", to: "GRPC_SHADOW_AUTHORITY_INFO_ACCESS_free"),
        // .define("AUTHORITY_INFO_ACCESS_it", to: "GRPC_SHADOW_AUTHORITY_INFO_ACCESS_it"),
        // .define("AUTHORITY_INFO_ACCESS_new", to: "GRPC_SHADOW_AUTHORITY_INFO_ACCESS_new"),
        // .define("AUTHORITY_KEYID_free", to: "GRPC_SHADOW_AUTHORITY_KEYID_free"),
        // .define("AUTHORITY_KEYID_it", to: "GRPC_SHADOW_AUTHORITY_KEYID_it"),
        // .define("AUTHORITY_KEYID_new", to: "GRPC_SHADOW_AUTHORITY_KEYID_new"),
        // .define("BASIC_CONSTRAINTS_free", to: "GRPC_SHADOW_BASIC_CONSTRAINTS_free"),
        // .define("BASIC_CONSTRAINTS_it", to: "GRPC_SHADOW_BASIC_CONSTRAINTS_it"),
        // .define("BASIC_CONSTRAINTS_new", to: "GRPC_SHADOW_BASIC_CONSTRAINTS_new"),
        // .define("beeu_mod_inverse_vartime", to: "GRPC_SHADOW_beeu_mod_inverse_vartime"),
        // .define("BIO_append_filename", to: "GRPC_SHADOW_BIO_append_filename"),
        // .define("BIO_callback_ctrl", to: "GRPC_SHADOW_BIO_callback_ctrl"),
        // .define("BIO_clear_flags", to: "GRPC_SHADOW_BIO_clear_flags"),
        // .define("BIO_clear_retry_flags", to: "GRPC_SHADOW_BIO_clear_retry_flags"),
        // .define("bio_clear_socket_error", to: "GRPC_SHADOW_bio_clear_socket_error"),
        // .define("BIO_copy_next_retry", to: "GRPC_SHADOW_BIO_copy_next_retry"),
        // .define("BIO_ctrl", to: "GRPC_SHADOW_BIO_ctrl"),
        // .define("BIO_ctrl_get_read_request", to: "GRPC_SHADOW_BIO_ctrl_get_read_request"),
        // .define("BIO_ctrl_get_write_guarantee", to: "GRPC_SHADOW_BIO_ctrl_get_write_guarantee"),
        // .define("BIO_ctrl_pending", to: "GRPC_SHADOW_BIO_ctrl_pending"),
        // .define("BIO_do_connect", to: "GRPC_SHADOW_BIO_do_connect"),
        // .define("BIO_eof", to: "GRPC_SHADOW_BIO_eof"),
        // .define("bio_fd_should_retry", to: "GRPC_SHADOW_bio_fd_should_retry"),
        // .define("BIO_find_type", to: "GRPC_SHADOW_BIO_find_type"),
        // .define("BIO_flush", to: "GRPC_SHADOW_BIO_flush"),
        // .define("BIO_free", to: "GRPC_SHADOW_BIO_free"),
        // .define("BIO_free_all", to: "GRPC_SHADOW_BIO_free_all"),
        // .define("BIO_f_ssl", to: "GRPC_SHADOW_BIO_f_ssl"),
        // .define("BIO_get_data", to: "GRPC_SHADOW_BIO_get_data"),
        // .define("BIO_get_fd", to: "GRPC_SHADOW_BIO_get_fd"),
        // .define("BIO_get_fp", to: "GRPC_SHADOW_BIO_get_fp"),
        // .define("BIO_get_init", to: "GRPC_SHADOW_BIO_get_init"),
        // .define("BIO_get_mem_data", to: "GRPC_SHADOW_BIO_get_mem_data"),
        // .define("BIO_get_mem_ptr", to: "GRPC_SHADOW_BIO_get_mem_ptr"),
        // .define("BIO_get_new_index", to: "GRPC_SHADOW_BIO_get_new_index"),
        // .define("BIO_get_retry_flags", to: "GRPC_SHADOW_BIO_get_retry_flags"),
        // .define("BIO_get_retry_reason", to: "GRPC_SHADOW_BIO_get_retry_reason"),
        // .define("BIO_gets", to: "GRPC_SHADOW_BIO_gets"),
        // .define("BIO_get_shutdown", to: "GRPC_SHADOW_BIO_get_shutdown"),
        // .define("BIO_hexdump", to: "GRPC_SHADOW_BIO_hexdump"),
        // .define("BIO_indent", to: "GRPC_SHADOW_BIO_indent"),
        // .define("BIO_int_ctrl", to: "GRPC_SHADOW_BIO_int_ctrl"),
        // .define("bio_ip_and_port_to_socket_and_addr", to: "GRPC_SHADOW_bio_ip_and_port_to_socket_and_addr"),
        // .define("BIO_mem_contents", to: "GRPC_SHADOW_BIO_mem_contents"),
        // .define("BIO_meth_free", to: "GRPC_SHADOW_BIO_meth_free"),
        // .define("BIO_meth_new", to: "GRPC_SHADOW_BIO_meth_new"),
        // .define("BIO_method_type", to: "GRPC_SHADOW_BIO_method_type"),
        // .define("BIO_meth_set_create", to: "GRPC_SHADOW_BIO_meth_set_create"),
        // .define("BIO_meth_set_ctrl", to: "GRPC_SHADOW_BIO_meth_set_ctrl"),
        // .define("BIO_meth_set_destroy", to: "GRPC_SHADOW_BIO_meth_set_destroy"),
        // .define("BIO_meth_set_gets", to: "GRPC_SHADOW_BIO_meth_set_gets"),
        // .define("BIO_meth_set_puts", to: "GRPC_SHADOW_BIO_meth_set_puts"),
        // .define("BIO_meth_set_read", to: "GRPC_SHADOW_BIO_meth_set_read"),
        // .define("BIO_meth_set_write", to: "GRPC_SHADOW_BIO_meth_set_write"),
        // .define("BIO_new", to: "GRPC_SHADOW_BIO_new"),
        // .define("BIO_new_bio_pair", to: "GRPC_SHADOW_BIO_new_bio_pair"),
        // .define("BIO_new_connect", to: "GRPC_SHADOW_BIO_new_connect"),
        // .define("BIO_new_fd", to: "GRPC_SHADOW_BIO_new_fd"),
        // .define("BIO_new_file", to: "GRPC_SHADOW_BIO_new_file"),
        // .define("BIO_new_fp", to: "GRPC_SHADOW_BIO_new_fp"),
        // .define("BIO_new_mem_buf", to: "GRPC_SHADOW_BIO_new_mem_buf"),
        // .define("BIO_new_socket", to: "GRPC_SHADOW_BIO_new_socket"),
        // .define("BIO_next", to: "GRPC_SHADOW_BIO_next"),
        // .define("BIO_number_read", to: "GRPC_SHADOW_BIO_number_read"),
        // .define("BIO_number_written", to: "GRPC_SHADOW_BIO_number_written"),
        // .define("BIO_pending", to: "GRPC_SHADOW_BIO_pending"),
        // .define("BIO_pop", to: "GRPC_SHADOW_BIO_pop"),
        // .define("BIO_printf", to: "GRPC_SHADOW_BIO_printf"),
        // .define("BIO_ptr_ctrl", to: "GRPC_SHADOW_BIO_ptr_ctrl"),
        // .define("BIO_push", to: "GRPC_SHADOW_BIO_push"),
        // .define("BIO_puts", to: "GRPC_SHADOW_BIO_puts"),
        // .define("BIO_read", to: "GRPC_SHADOW_BIO_read"),
        // .define("BIO_read_asn1", to: "GRPC_SHADOW_BIO_read_asn1"),
        // .define("BIO_read_filename", to: "GRPC_SHADOW_BIO_read_filename"),
        // .define("BIO_reset", to: "GRPC_SHADOW_BIO_reset"),
        // .define("BIO_rw_filename", to: "GRPC_SHADOW_BIO_rw_filename"),
        // .define("BIO_s_connect", to: "GRPC_SHADOW_BIO_s_connect"),
        // .define("BIO_set_close", to: "GRPC_SHADOW_BIO_set_close"),
        // .define("BIO_set_conn_hostname", to: "GRPC_SHADOW_BIO_set_conn_hostname"),
        // .define("BIO_set_conn_int_port", to: "GRPC_SHADOW_BIO_set_conn_int_port"),
        // .define("BIO_set_conn_port", to: "GRPC_SHADOW_BIO_set_conn_port"),
        // .define("BIO_set_data", to: "GRPC_SHADOW_BIO_set_data"),
        // .define("BIO_set_fd", to: "GRPC_SHADOW_BIO_set_fd"),
        // .define("BIO_set_flags", to: "GRPC_SHADOW_BIO_set_flags"),
        // .define("BIO_set_fp", to: "GRPC_SHADOW_BIO_set_fp"),
        // .define("BIO_set_init", to: "GRPC_SHADOW_BIO_set_init"),
        // .define("BIO_set_mem_buf", to: "GRPC_SHADOW_BIO_set_mem_buf"),
        // .define("BIO_set_mem_eof_return", to: "GRPC_SHADOW_BIO_set_mem_eof_return"),
        // .define("BIO_set_nbio", to: "GRPC_SHADOW_BIO_set_nbio"),
        // .define("BIO_set_retry_read", to: "GRPC_SHADOW_BIO_set_retry_read"),
        // .define("BIO_set_retry_special", to: "GRPC_SHADOW_BIO_set_retry_special"),
        // .define("BIO_set_retry_write", to: "GRPC_SHADOW_BIO_set_retry_write"),
        // .define("BIO_set_shutdown", to: "GRPC_SHADOW_BIO_set_shutdown"),
        // .define("BIO_set_ssl", to: "GRPC_SHADOW_BIO_set_ssl"),
        // .define("BIO_set_write_buffer_size", to: "GRPC_SHADOW_BIO_set_write_buffer_size"),
        // .define("BIO_s_fd", to: "GRPC_SHADOW_BIO_s_fd"),
        // .define("BIO_s_file", to: "GRPC_SHADOW_BIO_s_file"),
        // .define("BIO_should_io_special", to: "GRPC_SHADOW_BIO_should_io_special"),
        // .define("BIO_should_read", to: "GRPC_SHADOW_BIO_should_read"),
        // .define("BIO_should_retry", to: "GRPC_SHADOW_BIO_should_retry"),
        // .define("BIO_should_write", to: "GRPC_SHADOW_BIO_should_write"),
        // .define("BIO_shutdown_wr", to: "GRPC_SHADOW_BIO_shutdown_wr"),
        // .define("BIO_s_mem", to: "GRPC_SHADOW_BIO_s_mem"),
        // .define("BIO_snprintf", to: "GRPC_SHADOW_BIO_snprintf"),
        // .define("bio_sock_error", to: "GRPC_SHADOW_bio_sock_error"),
        // .define("bio_socket_nbio", to: "GRPC_SHADOW_bio_socket_nbio"),
        // .define("BIO_s_socket", to: "GRPC_SHADOW_BIO_s_socket"),
        // .define("BIO_test_flags", to: "GRPC_SHADOW_BIO_test_flags"),
        // .define("BIO_up_ref", to: "GRPC_SHADOW_BIO_up_ref"),
        // .define("BIO_vfree", to: "GRPC_SHADOW_BIO_vfree"),
        // .define("BIO_vsnprintf", to: "GRPC_SHADOW_BIO_vsnprintf"),
        // .define("BIO_wpending", to: "GRPC_SHADOW_BIO_wpending"),
        // .define("BIO_write", to: "GRPC_SHADOW_BIO_write"),
        // .define("BIO_write_all", to: "GRPC_SHADOW_BIO_write_all"),
        // .define("BIO_write_filename", to: "GRPC_SHADOW_BIO_write_filename"),
        // .define("BN_abs_is_word", to: "GRPC_SHADOW_BN_abs_is_word"),
        // .define("bn_abs_sub_consttime", to: "GRPC_SHADOW_bn_abs_sub_consttime"),
        // .define("BN_add", to: "GRPC_SHADOW_BN_add"),
        // .define("BN_add_word", to: "GRPC_SHADOW_BN_add_word"),
        // .define("bn_add_words", to: "GRPC_SHADOW_bn_add_words"),
        // .define("BN_asc2bn", to: "GRPC_SHADOW_BN_asc2bn"),
        // .define("BN_bin2bn", to: "GRPC_SHADOW_BN_bin2bn"),
        // .define("BN_BLINDING_convert", to: "GRPC_SHADOW_BN_BLINDING_convert"),
        // .define("BN_BLINDING_free", to: "GRPC_SHADOW_BN_BLINDING_free"),
        // .define("BN_BLINDING_invert", to: "GRPC_SHADOW_BN_BLINDING_invert"),
        // .define("BN_BLINDING_new", to: "GRPC_SHADOW_BN_BLINDING_new"),
        // .define("BN_bn2bin", to: "GRPC_SHADOW_BN_bn2bin"),
        // .define("BN_bn2binpad", to: "GRPC_SHADOW_BN_bn2binpad"),
        // .define("BN_bn2bin_padded", to: "GRPC_SHADOW_BN_bn2bin_padded"),
        // .define("BN_bn2cbb_padded", to: "GRPC_SHADOW_BN_bn2cbb_padded"),
        // .define("BN_bn2dec", to: "GRPC_SHADOW_BN_bn2dec"),
        // .define("BN_bn2hex", to: "GRPC_SHADOW_BN_bn2hex"),
        // .define("BN_bn2le_padded", to: "GRPC_SHADOW_BN_bn2le_padded"),
        // .define("BN_bn2mpi", to: "GRPC_SHADOW_BN_bn2mpi"),
        // .define("BN_clear", to: "GRPC_SHADOW_BN_clear"),
        // .define("BN_clear_bit", to: "GRPC_SHADOW_BN_clear_bit"),
        // .define("BN_clear_free", to: "GRPC_SHADOW_BN_clear_free"),
        // .define("BN_cmp", to: "GRPC_SHADOW_BN_cmp"),
        // .define("BN_cmp_word", to: "GRPC_SHADOW_BN_cmp_word"),
        // .define("BN_copy", to: "GRPC_SHADOW_BN_copy"),
        // .define("bn_copy_words", to: "GRPC_SHADOW_bn_copy_words"),
        // .define("BN_count_low_zero_bits", to: "GRPC_SHADOW_BN_count_low_zero_bits"),
        // .define("BN_CTX_end", to: "GRPC_SHADOW_BN_CTX_end"),
        // .define("BN_CTX_free", to: "GRPC_SHADOW_BN_CTX_free"),
        // .define("BN_CTX_get", to: "GRPC_SHADOW_BN_CTX_get"),
        // .define("BN_CTX_new", to: "GRPC_SHADOW_BN_CTX_new"),
        // .define("BN_CTX_start", to: "GRPC_SHADOW_BN_CTX_start"),
        // .define("BN_dec2bn", to: "GRPC_SHADOW_BN_dec2bn"),
        // .define("BN_div", to: "GRPC_SHADOW_BN_div"),
        // .define("bn_div_consttime", to: "GRPC_SHADOW_bn_div_consttime"),
        // .define("BN_div_word", to: "GRPC_SHADOW_BN_div_word"),
        // .define("BN_dup", to: "GRPC_SHADOW_BN_dup"),
        // .define("BN_enhanced_miller_rabin_primality_test", to: "GRPC_SHADOW_BN_enhanced_miller_rabin_primality_test"),
        // .define("BN_equal_consttime", to: "GRPC_SHADOW_BN_equal_consttime"),
        // .define("BN_exp", to: "GRPC_SHADOW_BN_exp"),
        // .define("bn_expand", to: "GRPC_SHADOW_bn_expand"),
        // .define("bn_fits_in_words", to: "GRPC_SHADOW_bn_fits_in_words"),
        // .define("BN_free", to: "GRPC_SHADOW_BN_free"),
        // .define("bn_from_montgomery", to: "GRPC_SHADOW_bn_from_montgomery"),
        // .define("BN_from_montgomery", to: "GRPC_SHADOW_BN_from_montgomery"),
        // .define("bn_from_montgomery_small", to: "GRPC_SHADOW_bn_from_montgomery_small"),
        // .define("bn_gather5", to: "GRPC_SHADOW_bn_gather5"),
        // .define("BN_gcd", to: "GRPC_SHADOW_BN_gcd"),
        // .define("BN_GENCB_call", to: "GRPC_SHADOW_BN_GENCB_call"),
        // .define("BN_GENCB_set", to: "GRPC_SHADOW_BN_GENCB_set"),
        // .define("BN_generate_prime_ex", to: "GRPC_SHADOW_BN_generate_prime_ex"),
        // .define("BN_get_rfc3526_prime_1536", to: "GRPC_SHADOW_BN_get_rfc3526_prime_1536"),
        // .define("BN_get_u64", to: "GRPC_SHADOW_BN_get_u64"),
        // .define("BN_get_word", to: "GRPC_SHADOW_BN_get_word"),
        // .define("BN_hex2bn", to: "GRPC_SHADOW_BN_hex2bn"),
        // .define("BN_init", to: "GRPC_SHADOW_BN_init"),
        // .define("bn_in_range_words", to: "GRPC_SHADOW_bn_in_range_words"),
        // .define("BN_is_bit_set", to: "GRPC_SHADOW_BN_is_bit_set"),
        // .define("bn_is_bit_set_words", to: "GRPC_SHADOW_bn_is_bit_set_words"),
        // .define("BN_is_negative", to: "GRPC_SHADOW_BN_is_negative"),
        // .define("BN_is_odd", to: "GRPC_SHADOW_BN_is_odd"),
        // .define("BN_is_one", to: "GRPC_SHADOW_BN_is_one"),
        // .define("BN_is_pow2", to: "GRPC_SHADOW_BN_is_pow2"),
        // .define("BN_is_prime_ex", to: "GRPC_SHADOW_BN_is_prime_ex"),
        // .define("BN_is_prime_fasttest_ex", to: "GRPC_SHADOW_BN_is_prime_fasttest_ex"),
        // .define("bn_is_relatively_prime", to: "GRPC_SHADOW_bn_is_relatively_prime"),
        // .define("BN_is_word", to: "GRPC_SHADOW_BN_is_word"),
        // .define("BN_is_zero", to: "GRPC_SHADOW_BN_is_zero"),
        // .define("bn_jacobi", to: "GRPC_SHADOW_bn_jacobi"),
        // .define("bn_lcm_consttime", to: "GRPC_SHADOW_bn_lcm_consttime"),
        // .define("BN_le2bn", to: "GRPC_SHADOW_BN_le2bn"),
        // .define("bn_less_than_montgomery_R", to: "GRPC_SHADOW_bn_less_than_montgomery_R"),
        // .define("bn_less_than_words", to: "GRPC_SHADOW_bn_less_than_words"),
        // .define("BN_lshift", to: "GRPC_SHADOW_BN_lshift"),
        // .define("BN_lshift1", to: "GRPC_SHADOW_BN_lshift1"),
        // .define("BN_marshal_asn1", to: "GRPC_SHADOW_BN_marshal_asn1"),
        // .define("BN_mask_bits", to: "GRPC_SHADOW_BN_mask_bits"),
        // .define("bn_miller_rabin_init", to: "GRPC_SHADOW_bn_miller_rabin_init"),
        // .define("bn_miller_rabin_iteration", to: "GRPC_SHADOW_bn_miller_rabin_iteration"),
        // .define("bn_minimal_width", to: "GRPC_SHADOW_bn_minimal_width"),
        // .define("BN_mod_add", to: "GRPC_SHADOW_BN_mod_add"),
        // .define("bn_mod_add_consttime", to: "GRPC_SHADOW_bn_mod_add_consttime"),
        // .define("BN_mod_add_quick", to: "GRPC_SHADOW_BN_mod_add_quick"),
        // .define("bn_mod_add_words", to: "GRPC_SHADOW_bn_mod_add_words"),
        // .define("BN_mod_exp", to: "GRPC_SHADOW_BN_mod_exp"),
        // .define("BN_mod_exp2_mont", to: "GRPC_SHADOW_BN_mod_exp2_mont"),
        // .define("bn_mod_exp_base_2_consttime", to: "GRPC_SHADOW_bn_mod_exp_base_2_consttime"),
        // .define("BN_mod_exp_mont", to: "GRPC_SHADOW_BN_mod_exp_mont"),
        // .define("BN_mod_exp_mont_consttime", to: "GRPC_SHADOW_BN_mod_exp_mont_consttime"),
        // .define("bn_mod_exp_mont_small", to: "GRPC_SHADOW_bn_mod_exp_mont_small"),
        // .define("BN_mod_exp_mont_word", to: "GRPC_SHADOW_BN_mod_exp_mont_word"),
        // .define("BN_mod_inverse", to: "GRPC_SHADOW_BN_mod_inverse"),
        // .define("BN_mod_inverse_blinded", to: "GRPC_SHADOW_BN_mod_inverse_blinded"),
        // .define("bn_mod_inverse_consttime", to: "GRPC_SHADOW_bn_mod_inverse_consttime"),
        // .define("BN_mod_inverse_odd", to: "GRPC_SHADOW_BN_mod_inverse_odd"),
        // .define("bn_mod_inverse_prime", to: "GRPC_SHADOW_bn_mod_inverse_prime"),
        // .define("bn_mod_inverse_prime_mont_small", to: "GRPC_SHADOW_bn_mod_inverse_prime_mont_small"),
        // .define("bn_mod_inverse_secret_prime", to: "GRPC_SHADOW_bn_mod_inverse_secret_prime"),
        // .define("BN_mod_lshift", to: "GRPC_SHADOW_BN_mod_lshift"),
        // .define("BN_mod_lshift1", to: "GRPC_SHADOW_BN_mod_lshift1"),
        // .define("bn_mod_lshift1_consttime", to: "GRPC_SHADOW_bn_mod_lshift1_consttime"),
        // .define("BN_mod_lshift1_quick", to: "GRPC_SHADOW_BN_mod_lshift1_quick"),
        // .define("bn_mod_lshift_consttime", to: "GRPC_SHADOW_bn_mod_lshift_consttime"),
        // .define("BN_mod_lshift_quick", to: "GRPC_SHADOW_BN_mod_lshift_quick"),
        // .define("BN_mod_mul", to: "GRPC_SHADOW_BN_mod_mul"),
        // .define("BN_mod_mul_montgomery", to: "GRPC_SHADOW_BN_mod_mul_montgomery"),
        // .define("bn_mod_mul_montgomery_small", to: "GRPC_SHADOW_bn_mod_mul_montgomery_small"),
        // .define("BN_mod_pow2", to: "GRPC_SHADOW_BN_mod_pow2"),
        // .define("BN_mod_sqr", to: "GRPC_SHADOW_BN_mod_sqr"),
        // .define("BN_mod_sqrt", to: "GRPC_SHADOW_BN_mod_sqrt"),
        // .define("BN_mod_sub", to: "GRPC_SHADOW_BN_mod_sub"),
        // .define("bn_mod_sub_consttime", to: "GRPC_SHADOW_bn_mod_sub_consttime"),
        // .define("BN_mod_sub_quick", to: "GRPC_SHADOW_BN_mod_sub_quick"),
        // .define("bn_mod_sub_words", to: "GRPC_SHADOW_bn_mod_sub_words"),
        // .define("bn_mod_u16_consttime", to: "GRPC_SHADOW_bn_mod_u16_consttime"),
        // .define("BN_mod_word", to: "GRPC_SHADOW_BN_mod_word"),
        // .define("BN_MONT_CTX_copy", to: "GRPC_SHADOW_BN_MONT_CTX_copy"),
        // .define("BN_MONT_CTX_free", to: "GRPC_SHADOW_BN_MONT_CTX_free"),
        // .define("BN_MONT_CTX_new", to: "GRPC_SHADOW_BN_MONT_CTX_new"),
        // .define("BN_MONT_CTX_new_consttime", to: "GRPC_SHADOW_BN_MONT_CTX_new_consttime"),
        // .define("BN_MONT_CTX_new_for_modulus", to: "GRPC_SHADOW_BN_MONT_CTX_new_for_modulus"),
        // .define("BN_MONT_CTX_set", to: "GRPC_SHADOW_BN_MONT_CTX_set"),
        // .define("BN_MONT_CTX_set_locked", to: "GRPC_SHADOW_BN_MONT_CTX_set_locked"),
        // .define("bn_mont_n0", to: "GRPC_SHADOW_bn_mont_n0"),
        // .define("BN_mpi2bn", to: "GRPC_SHADOW_BN_mpi2bn"),
        // .define("BN_mul", to: "GRPC_SHADOW_BN_mul"),
        // .define("bn_mul_add_words", to: "GRPC_SHADOW_bn_mul_add_words"),
        // .define("bn_mul_comba4", to: "GRPC_SHADOW_bn_mul_comba4"),
        // .define("bn_mul_comba8", to: "GRPC_SHADOW_bn_mul_comba8"),
        // .define("bn_mul_consttime", to: "GRPC_SHADOW_bn_mul_consttime"),
        // .define("bn_mul_mont", to: "GRPC_SHADOW_bn_mul_mont"),
        // .define("bn_mul_mont_gather5", to: "GRPC_SHADOW_bn_mul_mont_gather5"),
        // .define("bn_mul_small", to: "GRPC_SHADOW_bn_mul_small"),
        // .define("BN_mul_word", to: "GRPC_SHADOW_BN_mul_word"),
        // .define("bn_mul_words", to: "GRPC_SHADOW_bn_mul_words"),
        // .define("BN_new", to: "GRPC_SHADOW_BN_new"),
        // .define("BN_nnmod", to: "GRPC_SHADOW_BN_nnmod"),
        // .define("BN_nnmod_pow2", to: "GRPC_SHADOW_BN_nnmod_pow2"),
        // .define("BN_num_bits", to: "GRPC_SHADOW_BN_num_bits"),
        // .define("BN_num_bits_word", to: "GRPC_SHADOW_BN_num_bits_word"),
        // .define("BN_num_bytes", to: "GRPC_SHADOW_BN_num_bytes"),
        // .define("bn_odd_number_is_obviously_composite", to: "GRPC_SHADOW_bn_odd_number_is_obviously_composite"),
        // .define("BN_one", to: "GRPC_SHADOW_BN_one"),
        // .define("bn_one_to_montgomery", to: "GRPC_SHADOW_bn_one_to_montgomery"),
        // .define("BN_parse_asn1_unsigned", to: "GRPC_SHADOW_BN_parse_asn1_unsigned"),
        // .define("bn_power5", to: "GRPC_SHADOW_bn_power5"),
        // .define("BN_primality_test", to: "GRPC_SHADOW_BN_primality_test"),
        // .define("BN_print", to: "GRPC_SHADOW_BN_print"),
        // .define("BN_print_fp", to: "GRPC_SHADOW_BN_print_fp"),
        // .define("BN_pseudo_rand", to: "GRPC_SHADOW_BN_pseudo_rand"),
        // .define("BN_pseudo_rand_range", to: "GRPC_SHADOW_BN_pseudo_rand_range"),
        // .define("BN_rand", to: "GRPC_SHADOW_BN_rand"),
        // .define("BN_rand_range", to: "GRPC_SHADOW_BN_rand_range"),
        // .define("BN_rand_range_ex", to: "GRPC_SHADOW_BN_rand_range_ex"),
        // .define("bn_rand_range_words", to: "GRPC_SHADOW_bn_rand_range_words"),
        // .define("bn_rand_secret_range", to: "GRPC_SHADOW_bn_rand_secret_range"),
        // .define("bn_reduce_once", to: "GRPC_SHADOW_bn_reduce_once"),
        // .define("bn_reduce_once_in_place", to: "GRPC_SHADOW_bn_reduce_once_in_place"),
        // .define("bn_resize_words", to: "GRPC_SHADOW_bn_resize_words"),
        // .define("BN_rshift", to: "GRPC_SHADOW_BN_rshift"),
        // .define("BN_rshift1", to: "GRPC_SHADOW_BN_rshift1"),
        // .define("bn_rshift1_words", to: "GRPC_SHADOW_bn_rshift1_words"),
        // .define("bn_rshift_secret_shift", to: "GRPC_SHADOW_bn_rshift_secret_shift"),
        // .define("bn_rshift_words", to: "GRPC_SHADOW_bn_rshift_words"),
        // .define("bn_scatter5", to: "GRPC_SHADOW_bn_scatter5"),
        // .define("bn_select_words", to: "GRPC_SHADOW_bn_select_words"),
        // .define("BN_set_bit", to: "GRPC_SHADOW_BN_set_bit"),
        // .define("bn_set_minimal_width", to: "GRPC_SHADOW_bn_set_minimal_width"),
        // .define("BN_set_negative", to: "GRPC_SHADOW_BN_set_negative"),
        // .define("BN_set_u64", to: "GRPC_SHADOW_BN_set_u64"),
        // .define("BN_set_word", to: "GRPC_SHADOW_BN_set_word"),
        // .define("bn_set_words", to: "GRPC_SHADOW_bn_set_words"),
        // .define("BN_sqr", to: "GRPC_SHADOW_BN_sqr"),
        // .define("bn_sqr8x_internal", to: "GRPC_SHADOW_bn_sqr8x_internal"),
        // .define("bn_sqr_comba4", to: "GRPC_SHADOW_bn_sqr_comba4"),
        // .define("bn_sqr_comba8", to: "GRPC_SHADOW_bn_sqr_comba8"),
        // .define("bn_sqr_consttime", to: "GRPC_SHADOW_bn_sqr_consttime"),
        // .define("bn_sqr_small", to: "GRPC_SHADOW_bn_sqr_small"),
        // .define("BN_sqrt", to: "GRPC_SHADOW_BN_sqrt"),
        // .define("bn_sqr_words", to: "GRPC_SHADOW_bn_sqr_words"),
        // .define("bn_sqrx8x_internal", to: "GRPC_SHADOW_bn_sqrx8x_internal"),
        // .define("BN_sub", to: "GRPC_SHADOW_BN_sub"),
        // .define("BN_sub_word", to: "GRPC_SHADOW_BN_sub_word"),
        // .define("bn_sub_words", to: "GRPC_SHADOW_bn_sub_words"),
        // .define("BN_to_ASN1_ENUMERATED", to: "GRPC_SHADOW_BN_to_ASN1_ENUMERATED"),
        // .define("BN_to_ASN1_INTEGER", to: "GRPC_SHADOW_BN_to_ASN1_INTEGER"),
        // .define("BN_to_montgomery", to: "GRPC_SHADOW_BN_to_montgomery"),
        // .define("bn_to_montgomery_small", to: "GRPC_SHADOW_bn_to_montgomery_small"),
        // .define("BN_uadd", to: "GRPC_SHADOW_BN_uadd"),
        // .define("bn_uadd_consttime", to: "GRPC_SHADOW_bn_uadd_consttime"),
        // .define("BN_ucmp", to: "GRPC_SHADOW_BN_ucmp"),
        // .define("BN_usub", to: "GRPC_SHADOW_BN_usub"),
        // .define("bn_usub_consttime", to: "GRPC_SHADOW_bn_usub_consttime"),
        // .define("BN_value_one", to: "GRPC_SHADOW_BN_value_one"),
        // .define("bn_wexpand", to: "GRPC_SHADOW_bn_wexpand"),
        // .define("BN_zero", to: "GRPC_SHADOW_BN_zero"),
        // .define("boringssl_fips_self_test", to: "GRPC_SHADOW_boringssl_fips_self_test"),
        // .define("BORINGSSL_self_test", to: "GRPC_SHADOW_BORINGSSL_self_test"),
        // .define("BUF_MEM_append", to: "GRPC_SHADOW_BUF_MEM_append"),
        // .define("BUF_memdup", to: "GRPC_SHADOW_BUF_memdup"),
        // .define("BUF_MEM_free", to: "GRPC_SHADOW_BUF_MEM_free"),
        // .define("BUF_MEM_grow", to: "GRPC_SHADOW_BUF_MEM_grow"),
        // .define("BUF_MEM_grow_clean", to: "GRPC_SHADOW_BUF_MEM_grow_clean"),
        // .define("BUF_MEM_new", to: "GRPC_SHADOW_BUF_MEM_new"),
        // .define("BUF_MEM_reserve", to: "GRPC_SHADOW_BUF_MEM_reserve"),
        // .define("BUF_strdup", to: "GRPC_SHADOW_BUF_strdup"),
        // .define("BUF_strlcat", to: "GRPC_SHADOW_BUF_strlcat"),
        // .define("BUF_strlcpy", to: "GRPC_SHADOW_BUF_strlcpy"),
        // .define("BUF_strndup", to: "GRPC_SHADOW_BUF_strndup"),
        // .define("BUF_strnlen", to: "GRPC_SHADOW_BUF_strnlen"),
        // .define("c2i_ASN1_BIT_STRING", to: "GRPC_SHADOW_c2i_ASN1_BIT_STRING"),
        // .define("c2i_ASN1_INTEGER", to: "GRPC_SHADOW_c2i_ASN1_INTEGER"),
        // .define("c2i_ASN1_OBJECT", to: "GRPC_SHADOW_c2i_ASN1_OBJECT"),
        // .define("CBB_add_asn1", to: "GRPC_SHADOW_CBB_add_asn1"),
        // .define("CBB_add_asn1_bool", to: "GRPC_SHADOW_CBB_add_asn1_bool"),
        // .define("CBB_add_asn1_int64", to: "GRPC_SHADOW_CBB_add_asn1_int64"),
        // .define("CBB_add_asn1_octet_string", to: "GRPC_SHADOW_CBB_add_asn1_octet_string"),
        // .define("CBB_add_asn1_oid_from_text", to: "GRPC_SHADOW_CBB_add_asn1_oid_from_text"),
        // .define("CBB_add_asn1_uint64", to: "GRPC_SHADOW_CBB_add_asn1_uint64"),
        // .define("CBB_add_bytes", to: "GRPC_SHADOW_CBB_add_bytes"),
        // .define("cbb_add_latin1", to: "GRPC_SHADOW_cbb_add_latin1"),
        // .define("CBB_add_space", to: "GRPC_SHADOW_CBB_add_space"),
        // .define("CBB_add_u16", to: "GRPC_SHADOW_CBB_add_u16"),
        // .define("CBB_add_u16le", to: "GRPC_SHADOW_CBB_add_u16le"),
        // .define("CBB_add_u16_length_prefixed", to: "GRPC_SHADOW_CBB_add_u16_length_prefixed"),
        // .define("CBB_add_u24", to: "GRPC_SHADOW_CBB_add_u24"),
        // .define("CBB_add_u24_length_prefixed", to: "GRPC_SHADOW_CBB_add_u24_length_prefixed"),
        // .define("CBB_add_u32", to: "GRPC_SHADOW_CBB_add_u32"),
        // .define("CBB_add_u32le", to: "GRPC_SHADOW_CBB_add_u32le"),
        // .define("CBB_add_u64", to: "GRPC_SHADOW_CBB_add_u64"),
        // .define("CBB_add_u64le", to: "GRPC_SHADOW_CBB_add_u64le"),
        // .define("CBB_add_u8", to: "GRPC_SHADOW_CBB_add_u8"),
        // .define("CBB_add_u8_length_prefixed", to: "GRPC_SHADOW_CBB_add_u8_length_prefixed"),
        // .define("cbb_add_ucs2_be", to: "GRPC_SHADOW_cbb_add_ucs2_be"),
        // .define("cbb_add_utf32_be", to: "GRPC_SHADOW_cbb_add_utf32_be"),
        // .define("cbb_add_utf8", to: "GRPC_SHADOW_cbb_add_utf8"),
        // .define("CBB_cleanup", to: "GRPC_SHADOW_CBB_cleanup"),
        // .define("CBB_data", to: "GRPC_SHADOW_CBB_data"),
        // .define("CBB_did_write", to: "GRPC_SHADOW_CBB_did_write"),
        // .define("CBB_discard_child", to: "GRPC_SHADOW_CBB_discard_child"),
        // .define("CBB_finish", to: "GRPC_SHADOW_CBB_finish"),
        // .define("CBB_finish_i2d", to: "GRPC_SHADOW_CBB_finish_i2d"),
        // .define("CBB_flush", to: "GRPC_SHADOW_CBB_flush"),
        // .define("CBB_flush_asn1_set_of", to: "GRPC_SHADOW_CBB_flush_asn1_set_of"),
        // .define("cbb_get_utf8_len", to: "GRPC_SHADOW_cbb_get_utf8_len"),
        // .define("CBB_init", to: "GRPC_SHADOW_CBB_init"),
        // .define("CBB_init_fixed", to: "GRPC_SHADOW_CBB_init_fixed"),
        // .define("CBB_len", to: "GRPC_SHADOW_CBB_len"),
        // .define("CBB_reserve", to: "GRPC_SHADOW_CBB_reserve"),
        // .define("CBB_zero", to: "GRPC_SHADOW_CBB_zero"),
        // .define("CBS_asn1_ber_to_der", to: "GRPC_SHADOW_CBS_asn1_ber_to_der"),
        // .define("CBS_asn1_bitstring_has_bit", to: "GRPC_SHADOW_CBS_asn1_bitstring_has_bit"),
        // .define("CBS_asn1_oid_to_text", to: "GRPC_SHADOW_CBS_asn1_oid_to_text"),
        // .define("CBS_contains_zero_byte", to: "GRPC_SHADOW_CBS_contains_zero_byte"),
        // .define("CBS_copy_bytes", to: "GRPC_SHADOW_CBS_copy_bytes"),
        // .define("CBS_data", to: "GRPC_SHADOW_CBS_data"),
        // .define("CBS_get_any_asn1", to: "GRPC_SHADOW_CBS_get_any_asn1"),
        // .define("CBS_get_any_asn1_element", to: "GRPC_SHADOW_CBS_get_any_asn1_element"),
        // .define("CBS_get_any_ber_asn1_element", to: "GRPC_SHADOW_CBS_get_any_ber_asn1_element"),
        // .define("CBS_get_asn1", to: "GRPC_SHADOW_CBS_get_asn1"),
        // .define("CBS_get_asn1_bool", to: "GRPC_SHADOW_CBS_get_asn1_bool"),
        // .define("CBS_get_asn1_element", to: "GRPC_SHADOW_CBS_get_asn1_element"),
        // .define("CBS_get_asn1_implicit_string", to: "GRPC_SHADOW_CBS_get_asn1_implicit_string"),
        // .define("CBS_get_asn1_int64", to: "GRPC_SHADOW_CBS_get_asn1_int64"),
        // .define("CBS_get_asn1_uint64", to: "GRPC_SHADOW_CBS_get_asn1_uint64"),
        // .define("CBS_get_bytes", to: "GRPC_SHADOW_CBS_get_bytes"),
        // .define("CBS_get_last_u8", to: "GRPC_SHADOW_CBS_get_last_u8"),
        // .define("cbs_get_latin1", to: "GRPC_SHADOW_cbs_get_latin1"),
        // .define("CBS_get_optional_asn1", to: "GRPC_SHADOW_CBS_get_optional_asn1"),
        // .define("CBS_get_optional_asn1_bool", to: "GRPC_SHADOW_CBS_get_optional_asn1_bool"),
        // .define("CBS_get_optional_asn1_octet_string", to: "GRPC_SHADOW_CBS_get_optional_asn1_octet_string"),
        // .define("CBS_get_optional_asn1_uint64", to: "GRPC_SHADOW_CBS_get_optional_asn1_uint64"),
        // .define("CBS_get_u16", to: "GRPC_SHADOW_CBS_get_u16"),
        // .define("CBS_get_u16le", to: "GRPC_SHADOW_CBS_get_u16le"),
        // .define("CBS_get_u16_length_prefixed", to: "GRPC_SHADOW_CBS_get_u16_length_prefixed"),
        // .define("CBS_get_u24", to: "GRPC_SHADOW_CBS_get_u24"),
        // .define("CBS_get_u24_length_prefixed", to: "GRPC_SHADOW_CBS_get_u24_length_prefixed"),
        // .define("CBS_get_u32", to: "GRPC_SHADOW_CBS_get_u32"),
        // .define("CBS_get_u32le", to: "GRPC_SHADOW_CBS_get_u32le"),
        // .define("CBS_get_u64", to: "GRPC_SHADOW_CBS_get_u64"),
        // .define("CBS_get_u64le", to: "GRPC_SHADOW_CBS_get_u64le"),
        // .define("CBS_get_u8", to: "GRPC_SHADOW_CBS_get_u8"),
        // .define("CBS_get_u8_length_prefixed", to: "GRPC_SHADOW_CBS_get_u8_length_prefixed"),
        // .define("cbs_get_ucs2_be", to: "GRPC_SHADOW_cbs_get_ucs2_be"),
        // .define("cbs_get_utf32_be", to: "GRPC_SHADOW_cbs_get_utf32_be"),
        // .define("cbs_get_utf8", to: "GRPC_SHADOW_cbs_get_utf8"),
        // .define("CBS_init", to: "GRPC_SHADOW_CBS_init"),
        // .define("CBS_is_valid_asn1_bitstring", to: "GRPC_SHADOW_CBS_is_valid_asn1_bitstring"),
        // .define("CBS_len", to: "GRPC_SHADOW_CBS_len"),
        // .define("CBS_mem_equal", to: "GRPC_SHADOW_CBS_mem_equal"),
        // .define("CBS_peek_asn1_tag", to: "GRPC_SHADOW_CBS_peek_asn1_tag"),
        // .define("CBS_skip", to: "GRPC_SHADOW_CBS_skip"),
        // .define("CBS_stow", to: "GRPC_SHADOW_CBS_stow"),
        // .define("CBS_strdup", to: "GRPC_SHADOW_CBS_strdup"),
        // .define("CERTIFICATEPOLICIES_free", to: "GRPC_SHADOW_CERTIFICATEPOLICIES_free"),
        // .define("CERTIFICATEPOLICIES_it", to: "GRPC_SHADOW_CERTIFICATEPOLICIES_it"),
        // .define("CERTIFICATEPOLICIES_new", to: "GRPC_SHADOW_CERTIFICATEPOLICIES_new"),
        // .define("ChaCha20_ctr32", to: "GRPC_SHADOW_ChaCha20_ctr32"),
        // .define("chacha20_poly1305_open", to: "GRPC_SHADOW_chacha20_poly1305_open"),
        // .define("chacha20_poly1305_seal", to: "GRPC_SHADOW_chacha20_poly1305_seal"),
        // .define("CMAC_CTX_copy", to: "GRPC_SHADOW_CMAC_CTX_copy"),
        // .define("CMAC_CTX_free", to: "GRPC_SHADOW_CMAC_CTX_free"),
        // .define("CMAC_CTX_new", to: "GRPC_SHADOW_CMAC_CTX_new"),
        // .define("CMAC_Final", to: "GRPC_SHADOW_CMAC_Final"),
        // .define("CMAC_Init", to: "GRPC_SHADOW_CMAC_Init"),
        // .define("CMAC_Reset", to: "GRPC_SHADOW_CMAC_Reset"),
        // .define("CMAC_Update", to: "GRPC_SHADOW_CMAC_Update"),
        // .define("CONF_modules_free", to: "GRPC_SHADOW_CONF_modules_free"),
        // .define("CONF_modules_load_file", to: "GRPC_SHADOW_CONF_modules_load_file"),
        // .define("CONF_parse_list", to: "GRPC_SHADOW_CONF_parse_list"),
        // .define("CONF_VALUE_new", to: "GRPC_SHADOW_CONF_VALUE_new"),
        // .define("CRL_DIST_POINTS_free", to: "GRPC_SHADOW_CRL_DIST_POINTS_free"),
        // .define("CRL_DIST_POINTS_it", to: "GRPC_SHADOW_CRL_DIST_POINTS_it"),
        // .define("CRL_DIST_POINTS_new", to: "GRPC_SHADOW_CRL_DIST_POINTS_new"),
        // .define("CRYPTO_BUFFER_alloc", to: "GRPC_SHADOW_CRYPTO_BUFFER_alloc"),
        // .define("CRYPTO_BUFFER_data", to: "GRPC_SHADOW_CRYPTO_BUFFER_data"),
        // .define("CRYPTO_BUFFER_free", to: "GRPC_SHADOW_CRYPTO_BUFFER_free"),
        // .define("CRYPTO_BUFFER_init_CBS", to: "GRPC_SHADOW_CRYPTO_BUFFER_init_CBS"),
        // .define("CRYPTO_BUFFER_len", to: "GRPC_SHADOW_CRYPTO_BUFFER_len"),
        // .define("CRYPTO_BUFFER_new", to: "GRPC_SHADOW_CRYPTO_BUFFER_new"),
        // .define("CRYPTO_BUFFER_new_from_CBS", to: "GRPC_SHADOW_CRYPTO_BUFFER_new_from_CBS"),
        // .define("CRYPTO_BUFFER_POOL_free", to: "GRPC_SHADOW_CRYPTO_BUFFER_POOL_free"),
        // .define("CRYPTO_BUFFER_POOL_new", to: "GRPC_SHADOW_CRYPTO_BUFFER_POOL_new"),
        // .define("CRYPTO_BUFFER_up_ref", to: "GRPC_SHADOW_CRYPTO_BUFFER_up_ref"),
        // .define("CRYPTO_cbc128_decrypt", to: "GRPC_SHADOW_CRYPTO_cbc128_decrypt"),
        // .define("CRYPTO_cbc128_encrypt", to: "GRPC_SHADOW_CRYPTO_cbc128_encrypt"),
        // .define("CRYPTO_cfb128_1_encrypt", to: "GRPC_SHADOW_CRYPTO_cfb128_1_encrypt"),
        // .define("CRYPTO_cfb128_8_encrypt", to: "GRPC_SHADOW_CRYPTO_cfb128_8_encrypt"),
        // .define("CRYPTO_cfb128_encrypt", to: "GRPC_SHADOW_CRYPTO_cfb128_encrypt"),
        // .define("CRYPTO_chacha_20", to: "GRPC_SHADOW_CRYPTO_chacha_20"),
        // .define("CRYPTO_cleanup_all_ex_data", to: "GRPC_SHADOW_CRYPTO_cleanup_all_ex_data"),
        // .define("CRYPTO_ctr128_encrypt", to: "GRPC_SHADOW_CRYPTO_ctr128_encrypt"),
        // .define("CRYPTO_ctr128_encrypt_ctr32", to: "GRPC_SHADOW_CRYPTO_ctr128_encrypt_ctr32"),
        // .define("CRYPTO_free_ex_data", to: "GRPC_SHADOW_CRYPTO_free_ex_data"),
        // .define("CRYPTO_gcm128_aad", to: "GRPC_SHADOW_CRYPTO_gcm128_aad"),
        // .define("CRYPTO_gcm128_decrypt", to: "GRPC_SHADOW_CRYPTO_gcm128_decrypt"),
        // .define("CRYPTO_gcm128_decrypt_ctr32", to: "GRPC_SHADOW_CRYPTO_gcm128_decrypt_ctr32"),
        // .define("CRYPTO_gcm128_encrypt", to: "GRPC_SHADOW_CRYPTO_gcm128_encrypt"),
        // .define("CRYPTO_gcm128_encrypt_ctr32", to: "GRPC_SHADOW_CRYPTO_gcm128_encrypt_ctr32"),
        // .define("CRYPTO_gcm128_finish", to: "GRPC_SHADOW_CRYPTO_gcm128_finish"),
        // .define("CRYPTO_gcm128_init_key", to: "GRPC_SHADOW_CRYPTO_gcm128_init_key"),
        // .define("CRYPTO_gcm128_setiv", to: "GRPC_SHADOW_CRYPTO_gcm128_setiv"),
        // .define("CRYPTO_gcm128_tag", to: "GRPC_SHADOW_CRYPTO_gcm128_tag"),
        // .define("crypto_gcm_clmul_enabled", to: "GRPC_SHADOW_crypto_gcm_clmul_enabled"),
        // .define("CRYPTO_get_dynlock_create_callback", to: "GRPC_SHADOW_CRYPTO_get_dynlock_create_callback"),
        // .define("CRYPTO_get_dynlock_destroy_callback", to: "GRPC_SHADOW_CRYPTO_get_dynlock_destroy_callback"),
        // .define("CRYPTO_get_dynlock_lock_callback", to: "GRPC_SHADOW_CRYPTO_get_dynlock_lock_callback"),
        // .define("CRYPTO_get_ex_data", to: "GRPC_SHADOW_CRYPTO_get_ex_data"),
        // .define("CRYPTO_get_ex_new_index", to: "GRPC_SHADOW_CRYPTO_get_ex_new_index"),
        // .define("CRYPTO_get_locking_callback", to: "GRPC_SHADOW_CRYPTO_get_locking_callback"),
        // .define("CRYPTO_get_lock_name", to: "GRPC_SHADOW_CRYPTO_get_lock_name"),
        // .define("CRYPTO_get_thread_local", to: "GRPC_SHADOW_CRYPTO_get_thread_local"),
        // .define("CRYPTO_ghash_init", to: "GRPC_SHADOW_CRYPTO_ghash_init"),
        // .define("CRYPTO_has_asm", to: "GRPC_SHADOW_CRYPTO_has_asm"),
        // .define("CRYPTO_hchacha20", to: "GRPC_SHADOW_CRYPTO_hchacha20"),
        // .define("CRYPTO_is_confidential_build", to: "GRPC_SHADOW_CRYPTO_is_confidential_build"),
        // .define("CRYPTO_library_init", to: "GRPC_SHADOW_CRYPTO_library_init"),
        // .define("CRYPTO_malloc_init", to: "GRPC_SHADOW_CRYPTO_malloc_init"),
        // .define("CRYPTO_memcmp", to: "GRPC_SHADOW_CRYPTO_memcmp"),
        // .define("CRYPTO_MUTEX_cleanup", to: "GRPC_SHADOW_CRYPTO_MUTEX_cleanup"),
        // .define("CRYPTO_MUTEX_init", to: "GRPC_SHADOW_CRYPTO_MUTEX_init"),
        // .define("CRYPTO_MUTEX_lock_read", to: "GRPC_SHADOW_CRYPTO_MUTEX_lock_read"),
        // .define("CRYPTO_MUTEX_lock_write", to: "GRPC_SHADOW_CRYPTO_MUTEX_lock_write"),
        // .define("CRYPTO_MUTEX_unlock_read", to: "GRPC_SHADOW_CRYPTO_MUTEX_unlock_read"),
        // .define("CRYPTO_MUTEX_unlock_write", to: "GRPC_SHADOW_CRYPTO_MUTEX_unlock_write"),
        // .define("CRYPTO_new_ex_data", to: "GRPC_SHADOW_CRYPTO_new_ex_data"),
        // .define("CRYPTO_num_locks", to: "GRPC_SHADOW_CRYPTO_num_locks"),
        // .define("CRYPTO_ofb128_encrypt", to: "GRPC_SHADOW_CRYPTO_ofb128_encrypt"),
        // .define("CRYPTO_once", to: "GRPC_SHADOW_CRYPTO_once"),
        // .define("CRYPTO_poly1305_finish", to: "GRPC_SHADOW_CRYPTO_poly1305_finish"),
        // .define("CRYPTO_poly1305_init", to: "GRPC_SHADOW_CRYPTO_poly1305_init"),
        // .define("CRYPTO_poly1305_update", to: "GRPC_SHADOW_CRYPTO_poly1305_update"),
        // .define("CRYPTO_POLYVAL_finish", to: "GRPC_SHADOW_CRYPTO_POLYVAL_finish"),
        // .define("CRYPTO_POLYVAL_init", to: "GRPC_SHADOW_CRYPTO_POLYVAL_init"),
        // .define("CRYPTO_POLYVAL_update_blocks", to: "GRPC_SHADOW_CRYPTO_POLYVAL_update_blocks"),
        // .define("CRYPTO_rdrand", to: "GRPC_SHADOW_CRYPTO_rdrand"),
        // .define("CRYPTO_rdrand_multiple8_buf", to: "GRPC_SHADOW_CRYPTO_rdrand_multiple8_buf"),
        // .define("CRYPTO_refcount_dec_and_test_zero", to: "GRPC_SHADOW_CRYPTO_refcount_dec_and_test_zero"),
        // .define("CRYPTO_refcount_inc", to: "GRPC_SHADOW_CRYPTO_refcount_inc"),
        // .define("CRYPTO_set_add_lock_callback", to: "GRPC_SHADOW_CRYPTO_set_add_lock_callback"),
        // .define("CRYPTO_set_dynlock_create_callback", to: "GRPC_SHADOW_CRYPTO_set_dynlock_create_callback"),
        // .define("CRYPTO_set_dynlock_destroy_callback", to: "GRPC_SHADOW_CRYPTO_set_dynlock_destroy_callback"),
        // .define("CRYPTO_set_dynlock_lock_callback", to: "GRPC_SHADOW_CRYPTO_set_dynlock_lock_callback"),
        // .define("CRYPTO_set_ex_data", to: "GRPC_SHADOW_CRYPTO_set_ex_data"),
        // .define("CRYPTO_set_id_callback", to: "GRPC_SHADOW_CRYPTO_set_id_callback"),
        // .define("CRYPTO_set_locking_callback", to: "GRPC_SHADOW_CRYPTO_set_locking_callback"),
        // .define("CRYPTO_set_thread_local", to: "GRPC_SHADOW_CRYPTO_set_thread_local"),
        // .define("CRYPTO_STATIC_MUTEX_lock_read", to: "GRPC_SHADOW_CRYPTO_STATIC_MUTEX_lock_read"),
        // .define("CRYPTO_STATIC_MUTEX_lock_write", to: "GRPC_SHADOW_CRYPTO_STATIC_MUTEX_lock_write"),
        // .define("CRYPTO_STATIC_MUTEX_unlock_read", to: "GRPC_SHADOW_CRYPTO_STATIC_MUTEX_unlock_read"),
        // .define("CRYPTO_STATIC_MUTEX_unlock_write", to: "GRPC_SHADOW_CRYPTO_STATIC_MUTEX_unlock_write"),
        // .define("CRYPTO_sysrand", to: "GRPC_SHADOW_CRYPTO_sysrand"),
        // .define("CRYPTO_THREADID_current", to: "GRPC_SHADOW_CRYPTO_THREADID_current"),
        // .define("CRYPTO_THREADID_set_callback", to: "GRPC_SHADOW_CRYPTO_THREADID_set_callback"),
        // .define("CRYPTO_THREADID_set_numeric", to: "GRPC_SHADOW_CRYPTO_THREADID_set_numeric"),
        // .define("CRYPTO_THREADID_set_pointer", to: "GRPC_SHADOW_CRYPTO_THREADID_set_pointer"),
        // .define("CRYPTO_tls1_prf", to: "GRPC_SHADOW_CRYPTO_tls1_prf"),
        // .define("CTR_DRBG_clear", to: "GRPC_SHADOW_CTR_DRBG_clear"),
        // .define("CTR_DRBG_generate", to: "GRPC_SHADOW_CTR_DRBG_generate"),
        // .define("CTR_DRBG_init", to: "GRPC_SHADOW_CTR_DRBG_init"),
        // .define("CTR_DRBG_reseed", to: "GRPC_SHADOW_CTR_DRBG_reseed"),
        // .define("d2i_ACCESS_DESCRIPTION", to: "GRPC_SHADOW_d2i_ACCESS_DESCRIPTION"),
        // .define("d2i_ASN1_BIT_STRING", to: "GRPC_SHADOW_d2i_ASN1_BIT_STRING"),
        // .define("d2i_ASN1_BMPSTRING", to: "GRPC_SHADOW_d2i_ASN1_BMPSTRING"),
        // .define("d2i_ASN1_BOOLEAN", to: "GRPC_SHADOW_d2i_ASN1_BOOLEAN"),
        // .define("d2i_ASN1_ENUMERATED", to: "GRPC_SHADOW_d2i_ASN1_ENUMERATED"),
        // .define("d2i_ASN1_GENERALIZEDTIME", to: "GRPC_SHADOW_d2i_ASN1_GENERALIZEDTIME"),
        // .define("d2i_ASN1_GENERALSTRING", to: "GRPC_SHADOW_d2i_ASN1_GENERALSTRING"),
        // .define("d2i_ASN1_IA5STRING", to: "GRPC_SHADOW_d2i_ASN1_IA5STRING"),
        // .define("d2i_ASN1_INTEGER", to: "GRPC_SHADOW_d2i_ASN1_INTEGER"),
        // .define("d2i_ASN1_NULL", to: "GRPC_SHADOW_d2i_ASN1_NULL"),
        // .define("d2i_ASN1_OBJECT", to: "GRPC_SHADOW_d2i_ASN1_OBJECT"),
        // .define("d2i_ASN1_OCTET_STRING", to: "GRPC_SHADOW_d2i_ASN1_OCTET_STRING"),
        // .define("d2i_ASN1_PRINTABLE", to: "GRPC_SHADOW_d2i_ASN1_PRINTABLE"),
        // .define("d2i_ASN1_PRINTABLESTRING", to: "GRPC_SHADOW_d2i_ASN1_PRINTABLESTRING"),
        // .define("d2i_ASN1_SEQUENCE_ANY", to: "GRPC_SHADOW_d2i_ASN1_SEQUENCE_ANY"),
        // .define("d2i_ASN1_SET_ANY", to: "GRPC_SHADOW_d2i_ASN1_SET_ANY"),
        // .define("d2i_ASN1_T61STRING", to: "GRPC_SHADOW_d2i_ASN1_T61STRING"),
        // .define("d2i_ASN1_TIME", to: "GRPC_SHADOW_d2i_ASN1_TIME"),
        // .define("d2i_ASN1_TYPE", to: "GRPC_SHADOW_d2i_ASN1_TYPE"),
        // .define("d2i_ASN1_UNIVERSALSTRING", to: "GRPC_SHADOW_d2i_ASN1_UNIVERSALSTRING"),
        // .define("d2i_ASN1_UTCTIME", to: "GRPC_SHADOW_d2i_ASN1_UTCTIME"),
        // .define("d2i_ASN1_UTF8STRING", to: "GRPC_SHADOW_d2i_ASN1_UTF8STRING"),
        // .define("d2i_ASN1_VISIBLESTRING", to: "GRPC_SHADOW_d2i_ASN1_VISIBLESTRING"),
        // .define("d2i_AUTHORITY_INFO_ACCESS", to: "GRPC_SHADOW_d2i_AUTHORITY_INFO_ACCESS"),
        // .define("d2i_AUTHORITY_KEYID", to: "GRPC_SHADOW_d2i_AUTHORITY_KEYID"),
        // .define("d2i_AutoPrivateKey", to: "GRPC_SHADOW_d2i_AutoPrivateKey"),
        // .define("d2i_BASIC_CONSTRAINTS", to: "GRPC_SHADOW_d2i_BASIC_CONSTRAINTS"),
        // .define("d2i_CERTIFICATEPOLICIES", to: "GRPC_SHADOW_d2i_CERTIFICATEPOLICIES"),
        // .define("d2i_CRL_DIST_POINTS", to: "GRPC_SHADOW_d2i_CRL_DIST_POINTS"),
        // .define("d2i_DHparams", to: "GRPC_SHADOW_d2i_DHparams"),
        // .define("d2i_DHparams_bio", to: "GRPC_SHADOW_d2i_DHparams_bio"),
        // .define("d2i_DIRECTORYSTRING", to: "GRPC_SHADOW_d2i_DIRECTORYSTRING"),
        // .define("d2i_DISPLAYTEXT", to: "GRPC_SHADOW_d2i_DISPLAYTEXT"),
        // .define("d2i_DIST_POINT", to: "GRPC_SHADOW_d2i_DIST_POINT"),
        // .define("d2i_DIST_POINT_NAME", to: "GRPC_SHADOW_d2i_DIST_POINT_NAME"),
        // .define("d2i_DSAparams", to: "GRPC_SHADOW_d2i_DSAparams"),
        // .define("d2i_DSAPrivateKey", to: "GRPC_SHADOW_d2i_DSAPrivateKey"),
        // .define("d2i_DSAPrivateKey_bio", to: "GRPC_SHADOW_d2i_DSAPrivateKey_bio"),
        // .define("d2i_DSAPrivateKey_fp", to: "GRPC_SHADOW_d2i_DSAPrivateKey_fp"),
        // .define("d2i_DSA_PUBKEY", to: "GRPC_SHADOW_d2i_DSA_PUBKEY"),
        // .define("d2i_DSA_PUBKEY_bio", to: "GRPC_SHADOW_d2i_DSA_PUBKEY_bio"),
        // .define("d2i_DSA_PUBKEY_fp", to: "GRPC_SHADOW_d2i_DSA_PUBKEY_fp"),
        // .define("d2i_DSAPublicKey", to: "GRPC_SHADOW_d2i_DSAPublicKey"),
        // .define("d2i_DSA_SIG", to: "GRPC_SHADOW_d2i_DSA_SIG"),
        // .define("d2i_ECDSA_SIG", to: "GRPC_SHADOW_d2i_ECDSA_SIG"),
        // .define("d2i_ECParameters", to: "GRPC_SHADOW_d2i_ECParameters"),
        // .define("d2i_ECPrivateKey", to: "GRPC_SHADOW_d2i_ECPrivateKey"),
        // .define("d2i_ECPrivateKey_bio", to: "GRPC_SHADOW_d2i_ECPrivateKey_bio"),
        // .define("d2i_ECPrivateKey_fp", to: "GRPC_SHADOW_d2i_ECPrivateKey_fp"),
        // .define("d2i_EC_PUBKEY", to: "GRPC_SHADOW_d2i_EC_PUBKEY"),
        // .define("d2i_EC_PUBKEY_bio", to: "GRPC_SHADOW_d2i_EC_PUBKEY_bio"),
        // .define("d2i_EC_PUBKEY_fp", to: "GRPC_SHADOW_d2i_EC_PUBKEY_fp"),
        // .define("d2i_EDIPARTYNAME", to: "GRPC_SHADOW_d2i_EDIPARTYNAME"),
        // .define("d2i_EXTENDED_KEY_USAGE", to: "GRPC_SHADOW_d2i_EXTENDED_KEY_USAGE"),
        // .define("d2i_GENERAL_NAME", to: "GRPC_SHADOW_d2i_GENERAL_NAME"),
        // .define("d2i_GENERAL_NAMES", to: "GRPC_SHADOW_d2i_GENERAL_NAMES"),
        // .define("d2i_ISSUING_DIST_POINT", to: "GRPC_SHADOW_d2i_ISSUING_DIST_POINT"),
        // .define("d2i_NETSCAPE_SPKAC", to: "GRPC_SHADOW_d2i_NETSCAPE_SPKAC"),
        // .define("d2i_NETSCAPE_SPKI", to: "GRPC_SHADOW_d2i_NETSCAPE_SPKI"),
        // .define("d2i_NOTICEREF", to: "GRPC_SHADOW_d2i_NOTICEREF"),
        // .define("d2i_OTHERNAME", to: "GRPC_SHADOW_d2i_OTHERNAME"),
        // .define("d2i_PKCS12", to: "GRPC_SHADOW_d2i_PKCS12"),
        // .define("d2i_PKCS12_bio", to: "GRPC_SHADOW_d2i_PKCS12_bio"),
        // .define("d2i_PKCS12_fp", to: "GRPC_SHADOW_d2i_PKCS12_fp"),
        // .define("d2i_PKCS7", to: "GRPC_SHADOW_d2i_PKCS7"),
        // .define("d2i_PKCS7_bio", to: "GRPC_SHADOW_d2i_PKCS7_bio"),
        // .define("d2i_PKCS8_bio", to: "GRPC_SHADOW_d2i_PKCS8_bio"),
        // .define("d2i_PKCS8_fp", to: "GRPC_SHADOW_d2i_PKCS8_fp"),
        // .define("d2i_PKCS8PrivateKey_bio", to: "GRPC_SHADOW_d2i_PKCS8PrivateKey_bio"),
        // .define("d2i_PKCS8PrivateKey_fp", to: "GRPC_SHADOW_d2i_PKCS8PrivateKey_fp"),
        // .define("d2i_PKCS8_PRIV_KEY_INFO", to: "GRPC_SHADOW_d2i_PKCS8_PRIV_KEY_INFO"),
        // .define("d2i_PKCS8_PRIV_KEY_INFO_bio", to: "GRPC_SHADOW_d2i_PKCS8_PRIV_KEY_INFO_bio"),
        // .define("d2i_PKCS8_PRIV_KEY_INFO_fp", to: "GRPC_SHADOW_d2i_PKCS8_PRIV_KEY_INFO_fp"),
        // .define("d2i_PKEY_USAGE_PERIOD", to: "GRPC_SHADOW_d2i_PKEY_USAGE_PERIOD"),
        // .define("d2i_POLICYINFO", to: "GRPC_SHADOW_d2i_POLICYINFO"),
        // .define("d2i_POLICYQUALINFO", to: "GRPC_SHADOW_d2i_POLICYQUALINFO"),
        // .define("d2i_PrivateKey", to: "GRPC_SHADOW_d2i_PrivateKey"),
        // .define("d2i_PrivateKey_bio", to: "GRPC_SHADOW_d2i_PrivateKey_bio"),
        // .define("d2i_PrivateKey_fp", to: "GRPC_SHADOW_d2i_PrivateKey_fp"),
        // .define("d2i_PROXY_CERT_INFO_EXTENSION", to: "GRPC_SHADOW_d2i_PROXY_CERT_INFO_EXTENSION"),
        // .define("d2i_PROXY_POLICY", to: "GRPC_SHADOW_d2i_PROXY_POLICY"),
        // .define("d2i_PUBKEY", to: "GRPC_SHADOW_d2i_PUBKEY"),
        // .define("d2i_PUBKEY_bio", to: "GRPC_SHADOW_d2i_PUBKEY_bio"),
        // .define("d2i_PUBKEY_fp", to: "GRPC_SHADOW_d2i_PUBKEY_fp"),
        // .define("d2i_PublicKey", to: "GRPC_SHADOW_d2i_PublicKey"),
        // .define("d2i_RSAPrivateKey", to: "GRPC_SHADOW_d2i_RSAPrivateKey"),
        // .define("d2i_RSAPrivateKey_bio", to: "GRPC_SHADOW_d2i_RSAPrivateKey_bio"),
        // .define("d2i_RSAPrivateKey_fp", to: "GRPC_SHADOW_d2i_RSAPrivateKey_fp"),
        // .define("d2i_RSA_PSS_PARAMS", to: "GRPC_SHADOW_d2i_RSA_PSS_PARAMS"),
        // .define("d2i_RSA_PUBKEY", to: "GRPC_SHADOW_d2i_RSA_PUBKEY"),
        // .define("d2i_RSA_PUBKEY_bio", to: "GRPC_SHADOW_d2i_RSA_PUBKEY_bio"),
        // .define("d2i_RSA_PUBKEY_fp", to: "GRPC_SHADOW_d2i_RSA_PUBKEY_fp"),
        // .define("d2i_RSAPublicKey", to: "GRPC_SHADOW_d2i_RSAPublicKey"),
        // .define("d2i_RSAPublicKey_bio", to: "GRPC_SHADOW_d2i_RSAPublicKey_bio"),
        // .define("d2i_RSAPublicKey_fp", to: "GRPC_SHADOW_d2i_RSAPublicKey_fp"),
        // .define("d2i_SSL_SESSION", to: "GRPC_SHADOW_d2i_SSL_SESSION"),
        // .define("d2i_SSL_SESSION_bio", to: "GRPC_SHADOW_d2i_SSL_SESSION_bio"),
        // .define("d2i_SXNET", to: "GRPC_SHADOW_d2i_SXNET"),
        // .define("d2i_SXNETID", to: "GRPC_SHADOW_d2i_SXNETID"),
        // .define("d2i_USERNOTICE", to: "GRPC_SHADOW_d2i_USERNOTICE"),
        // .define("d2i_X509", to: "GRPC_SHADOW_d2i_X509"),
        // .define("d2i_X509_ALGOR", to: "GRPC_SHADOW_d2i_X509_ALGOR"),
        // .define("d2i_X509_ALGORS", to: "GRPC_SHADOW_d2i_X509_ALGORS"),
        // .define("d2i_X509_ATTRIBUTE", to: "GRPC_SHADOW_d2i_X509_ATTRIBUTE"),
        // .define("d2i_X509_AUX", to: "GRPC_SHADOW_d2i_X509_AUX"),
        // .define("d2i_X509_bio", to: "GRPC_SHADOW_d2i_X509_bio"),
        // .define("d2i_X509_CERT_AUX", to: "GRPC_SHADOW_d2i_X509_CERT_AUX"),
        // .define("d2i_X509_CINF", to: "GRPC_SHADOW_d2i_X509_CINF"),
        // .define("d2i_X509_CRL", to: "GRPC_SHADOW_d2i_X509_CRL"),
        // .define("d2i_X509_CRL_bio", to: "GRPC_SHADOW_d2i_X509_CRL_bio"),
        // .define("d2i_X509_CRL_fp", to: "GRPC_SHADOW_d2i_X509_CRL_fp"),
        // .define("d2i_X509_CRL_INFO", to: "GRPC_SHADOW_d2i_X509_CRL_INFO"),
        // .define("d2i_X509_EXTENSION", to: "GRPC_SHADOW_d2i_X509_EXTENSION"),
        // .define("d2i_X509_EXTENSIONS", to: "GRPC_SHADOW_d2i_X509_EXTENSIONS"),
        // .define("d2i_X509_fp", to: "GRPC_SHADOW_d2i_X509_fp"),
        // .define("d2i_X509_NAME", to: "GRPC_SHADOW_d2i_X509_NAME"),
        // .define("d2i_X509_NAME_ENTRY", to: "GRPC_SHADOW_d2i_X509_NAME_ENTRY"),
        // .define("d2i_X509_PUBKEY", to: "GRPC_SHADOW_d2i_X509_PUBKEY"),
        // .define("d2i_X509_REQ", to: "GRPC_SHADOW_d2i_X509_REQ"),
        // .define("d2i_X509_REQ_bio", to: "GRPC_SHADOW_d2i_X509_REQ_bio"),
        // .define("d2i_X509_REQ_fp", to: "GRPC_SHADOW_d2i_X509_REQ_fp"),
        // .define("d2i_X509_REQ_INFO", to: "GRPC_SHADOW_d2i_X509_REQ_INFO"),
        // .define("d2i_X509_REVOKED", to: "GRPC_SHADOW_d2i_X509_REVOKED"),
        // .define("d2i_X509_SIG", to: "GRPC_SHADOW_d2i_X509_SIG"),
        // .define("d2i_X509_VAL", to: "GRPC_SHADOW_d2i_X509_VAL"),
        // .define("DES_decrypt3", to: "GRPC_SHADOW_DES_decrypt3"),
        // .define("DES_ecb3_encrypt", to: "GRPC_SHADOW_DES_ecb3_encrypt"),
        // .define("DES_ecb_encrypt", to: "GRPC_SHADOW_DES_ecb_encrypt"),
        // .define("DES_ede2_cbc_encrypt", to: "GRPC_SHADOW_DES_ede2_cbc_encrypt"),
        // .define("DES_ede3_cbc_encrypt", to: "GRPC_SHADOW_DES_ede3_cbc_encrypt"),
        // .define("DES_encrypt3", to: "GRPC_SHADOW_DES_encrypt3"),
        // .define("DES_ncbc_encrypt", to: "GRPC_SHADOW_DES_ncbc_encrypt"),
        // .define("DES_set_key", to: "GRPC_SHADOW_DES_set_key"),
        // .define("DES_set_key_unchecked", to: "GRPC_SHADOW_DES_set_key_unchecked"),
        // .define("DES_set_odd_parity", to: "GRPC_SHADOW_DES_set_odd_parity"),
        // .define("DH_check", to: "GRPC_SHADOW_DH_check"),
        // .define("DH_check_pub_key", to: "GRPC_SHADOW_DH_check_pub_key"),
        // .define("DH_compute_key", to: "GRPC_SHADOW_DH_compute_key"),
        // .define("DH_free", to: "GRPC_SHADOW_DH_free"),
        // .define("DH_generate_key", to: "GRPC_SHADOW_DH_generate_key"),
        // .define("DH_generate_parameters_ex", to: "GRPC_SHADOW_DH_generate_parameters_ex"),
        // .define("DH_get0_key", to: "GRPC_SHADOW_DH_get0_key"),
        // .define("DH_get0_pqg", to: "GRPC_SHADOW_DH_get0_pqg"),
        // .define("DH_get_ex_data", to: "GRPC_SHADOW_DH_get_ex_data"),
        // .define("DH_get_ex_new_index", to: "GRPC_SHADOW_DH_get_ex_new_index"),
        // .define("DH_marshal_parameters", to: "GRPC_SHADOW_DH_marshal_parameters"),
        // .define("DH_new", to: "GRPC_SHADOW_DH_new"),
        // .define("DH_num_bits", to: "GRPC_SHADOW_DH_num_bits"),
        // .define("DHparams_dup", to: "GRPC_SHADOW_DHparams_dup"),
        // .define("DH_parse_parameters", to: "GRPC_SHADOW_DH_parse_parameters"),
        // .define("DH_set0_key", to: "GRPC_SHADOW_DH_set0_key"),
        // .define("DH_set0_pqg", to: "GRPC_SHADOW_DH_set0_pqg"),
        // .define("DH_set_ex_data", to: "GRPC_SHADOW_DH_set_ex_data"),
        // .define("DH_size", to: "GRPC_SHADOW_DH_size"),
        // .define("DH_up_ref", to: "GRPC_SHADOW_DH_up_ref"),
        // .define("DIRECTORYSTRING_free", to: "GRPC_SHADOW_DIRECTORYSTRING_free"),
        // .define("DIRECTORYSTRING_it", to: "GRPC_SHADOW_DIRECTORYSTRING_it"),
        // .define("DIRECTORYSTRING_new", to: "GRPC_SHADOW_DIRECTORYSTRING_new"),
        // .define("DISPLAYTEXT_free", to: "GRPC_SHADOW_DISPLAYTEXT_free"),
        // .define("DISPLAYTEXT_it", to: "GRPC_SHADOW_DISPLAYTEXT_it"),
        // .define("DISPLAYTEXT_new", to: "GRPC_SHADOW_DISPLAYTEXT_new"),
        // .define("DIST_POINT_free", to: "GRPC_SHADOW_DIST_POINT_free"),
        // .define("DIST_POINT_it", to: "GRPC_SHADOW_DIST_POINT_it"),
        // .define("DIST_POINT_NAME_free", to: "GRPC_SHADOW_DIST_POINT_NAME_free"),
        // .define("DIST_POINT_NAME_it", to: "GRPC_SHADOW_DIST_POINT_NAME_it"),
        // .define("DIST_POINT_NAME_new", to: "GRPC_SHADOW_DIST_POINT_NAME_new"),
        // .define("DIST_POINT_new", to: "GRPC_SHADOW_DIST_POINT_new"),
        // .define("DIST_POINT_set_dpname", to: "GRPC_SHADOW_DIST_POINT_set_dpname"),
        // .define("dsa_asn1_meth", to: "GRPC_SHADOW_dsa_asn1_meth"),
        // .define("DSA_check_signature", to: "GRPC_SHADOW_DSA_check_signature"),
        // .define("DSA_do_check_signature", to: "GRPC_SHADOW_DSA_do_check_signature"),
        // .define("DSA_do_sign", to: "GRPC_SHADOW_DSA_do_sign"),
        // .define("DSA_do_verify", to: "GRPC_SHADOW_DSA_do_verify"),
        // .define("DSA_dup_DH", to: "GRPC_SHADOW_DSA_dup_DH"),
        // .define("DSA_free", to: "GRPC_SHADOW_DSA_free"),
        // .define("DSA_generate_key", to: "GRPC_SHADOW_DSA_generate_key"),
        // .define("DSA_generate_parameters_ex", to: "GRPC_SHADOW_DSA_generate_parameters_ex"),
        // .define("DSA_get0_key", to: "GRPC_SHADOW_DSA_get0_key"),
        // .define("DSA_get0_pqg", to: "GRPC_SHADOW_DSA_get0_pqg"),
        // .define("DSA_get_ex_data", to: "GRPC_SHADOW_DSA_get_ex_data"),
        // .define("DSA_get_ex_new_index", to: "GRPC_SHADOW_DSA_get_ex_new_index"),
        // .define("DSA_marshal_parameters", to: "GRPC_SHADOW_DSA_marshal_parameters"),
        // .define("DSA_marshal_private_key", to: "GRPC_SHADOW_DSA_marshal_private_key"),
        // .define("DSA_marshal_public_key", to: "GRPC_SHADOW_DSA_marshal_public_key"),
        // .define("DSA_new", to: "GRPC_SHADOW_DSA_new"),
        // .define("DSAparams_dup", to: "GRPC_SHADOW_DSAparams_dup"),
        // .define("DSA_parse_parameters", to: "GRPC_SHADOW_DSA_parse_parameters"),
        // .define("DSA_parse_private_key", to: "GRPC_SHADOW_DSA_parse_private_key"),
        // .define("DSA_parse_public_key", to: "GRPC_SHADOW_DSA_parse_public_key"),
        // .define("DSA_set0_key", to: "GRPC_SHADOW_DSA_set0_key"),
        // .define("DSA_set0_pqg", to: "GRPC_SHADOW_DSA_set0_pqg"),
        // .define("DSA_set_ex_data", to: "GRPC_SHADOW_DSA_set_ex_data"),
        // .define("DSA_SIG_free", to: "GRPC_SHADOW_DSA_SIG_free"),
        // .define("DSA_SIG_marshal", to: "GRPC_SHADOW_DSA_SIG_marshal"),
        // .define("DSA_sign", to: "GRPC_SHADOW_DSA_sign"),
        // .define("DSA_SIG_new", to: "GRPC_SHADOW_DSA_SIG_new"),
        // .define("DSA_SIG_parse", to: "GRPC_SHADOW_DSA_SIG_parse"),
        // .define("DSA_size", to: "GRPC_SHADOW_DSA_size"),
        // .define("DSA_up_ref", to: "GRPC_SHADOW_DSA_up_ref"),
        // .define("DSA_verify", to: "GRPC_SHADOW_DSA_verify"),
        // .define("DTLS_client_method", to: "GRPC_SHADOW_DTLS_client_method"),
        // .define("DTLS_method", to: "GRPC_SHADOW_DTLS_method"),
        // .define("DTLS_server_method", to: "GRPC_SHADOW_DTLS_server_method"),
        // .define("DTLSv1_2_client_method", to: "GRPC_SHADOW_DTLSv1_2_client_method"),
        // .define("DTLSv1_2_method", to: "GRPC_SHADOW_DTLSv1_2_method"),
        // .define("DTLSv1_2_server_method", to: "GRPC_SHADOW_DTLSv1_2_server_method"),
        // .define("DTLSv1_client_method", to: "GRPC_SHADOW_DTLSv1_client_method"),
        // .define("DTLSv1_get_timeout", to: "GRPC_SHADOW_DTLSv1_get_timeout"),
        // .define("DTLSv1_handle_timeout", to: "GRPC_SHADOW_DTLSv1_handle_timeout"),
        // .define("DTLSv1_method", to: "GRPC_SHADOW_DTLSv1_method"),
        // .define("DTLSv1_server_method", to: "GRPC_SHADOW_DTLSv1_server_method"),
        // .define("DTLSv1_set_initial_timeout_duration", to: "GRPC_SHADOW_DTLSv1_set_initial_timeout_duration"),
        // .define("DTLS_with_buffers_method", to: "GRPC_SHADOW_DTLS_with_buffers_method"),
        // .define("ec_asn1_meth", to: "GRPC_SHADOW_ec_asn1_meth"),
        // .define("ec_bignum_to_felem", to: "GRPC_SHADOW_ec_bignum_to_felem"),
        // .define("ec_bignum_to_scalar", to: "GRPC_SHADOW_ec_bignum_to_scalar"),
        // .define("ec_cmp_x_coordinate", to: "GRPC_SHADOW_ec_cmp_x_coordinate"),
        // .define("ec_compute_wNAF", to: "GRPC_SHADOW_ec_compute_wNAF"),
        // .define("EC_curve_nid2nist", to: "GRPC_SHADOW_EC_curve_nid2nist"),
        // .define("EC_curve_nist2nid", to: "GRPC_SHADOW_EC_curve_nist2nid"),
        // .define("ECDH_compute_key", to: "GRPC_SHADOW_ECDH_compute_key"),
        // .define("ECDH_compute_key_fips", to: "GRPC_SHADOW_ECDH_compute_key_fips"),
        // .define("ECDSA_do_sign", to: "GRPC_SHADOW_ECDSA_do_sign"),
        // .define("ECDSA_do_verify", to: "GRPC_SHADOW_ECDSA_do_verify"),
        // .define("ECDSA_SIG_free", to: "GRPC_SHADOW_ECDSA_SIG_free"),
        // .define("ECDSA_SIG_from_bytes", to: "GRPC_SHADOW_ECDSA_SIG_from_bytes"),
        // .define("ECDSA_SIG_get0", to: "GRPC_SHADOW_ECDSA_SIG_get0"),
        // .define("ECDSA_SIG_marshal", to: "GRPC_SHADOW_ECDSA_SIG_marshal"),
        // .define("ECDSA_SIG_max_len", to: "GRPC_SHADOW_ECDSA_SIG_max_len"),
        // .define("ECDSA_sign", to: "GRPC_SHADOW_ECDSA_sign"),
        // .define("ECDSA_SIG_new", to: "GRPC_SHADOW_ECDSA_SIG_new"),
        // .define("ECDSA_SIG_parse", to: "GRPC_SHADOW_ECDSA_SIG_parse"),
        // .define("ECDSA_SIG_set0", to: "GRPC_SHADOW_ECDSA_SIG_set0"),
        // .define("ECDSA_SIG_to_bytes", to: "GRPC_SHADOW_ECDSA_SIG_to_bytes"),
        // .define("ECDSA_size", to: "GRPC_SHADOW_ECDSA_size"),
        // .define("ECDSA_verify", to: "GRPC_SHADOW_ECDSA_verify"),
        // .define("ec_felem_add", to: "GRPC_SHADOW_ec_felem_add"),
        // .define("ec_felem_equal", to: "GRPC_SHADOW_ec_felem_equal"),
        // .define("ec_felem_neg", to: "GRPC_SHADOW_ec_felem_neg"),
        // .define("ec_felem_non_zero_mask", to: "GRPC_SHADOW_ec_felem_non_zero_mask"),
        // .define("ec_felem_select", to: "GRPC_SHADOW_ec_felem_select"),
        // .define("ec_felem_sub", to: "GRPC_SHADOW_ec_felem_sub"),
        // .define("ec_felem_to_bignum", to: "GRPC_SHADOW_ec_felem_to_bignum"),
        // .define("EC_get_builtin_curves", to: "GRPC_SHADOW_EC_get_builtin_curves"),
        // .define("ec_get_x_coordinate_as_scalar", to: "GRPC_SHADOW_ec_get_x_coordinate_as_scalar"),
        // .define("ec_GFp_mont_add", to: "GRPC_SHADOW_ec_GFp_mont_add"),
        // .define("ec_GFp_mont_bignum_to_felem", to: "GRPC_SHADOW_ec_GFp_mont_bignum_to_felem"),
        // .define("ec_GFp_mont_dbl", to: "GRPC_SHADOW_ec_GFp_mont_dbl"),
        // .define("ec_GFp_mont_felem_mul", to: "GRPC_SHADOW_ec_GFp_mont_felem_mul"),
        // .define("ec_GFp_mont_felem_sqr", to: "GRPC_SHADOW_ec_GFp_mont_felem_sqr"),
        // .define("ec_GFp_mont_felem_to_bignum", to: "GRPC_SHADOW_ec_GFp_mont_felem_to_bignum"),
        // .define("ec_GFp_mont_group_finish", to: "GRPC_SHADOW_ec_GFp_mont_group_finish"),
        // .define("ec_GFp_mont_group_init", to: "GRPC_SHADOW_ec_GFp_mont_group_init"),
        // .define("ec_GFp_mont_group_set_curve", to: "GRPC_SHADOW_ec_GFp_mont_group_set_curve"),
        // .define("EC_GFp_mont_method", to: "GRPC_SHADOW_EC_GFp_mont_method"),
        // .define("ec_GFp_mont_mul", to: "GRPC_SHADOW_ec_GFp_mont_mul"),
        // .define("ec_GFp_mont_mul_base", to: "GRPC_SHADOW_ec_GFp_mont_mul_base"),
        // .define("ec_GFp_mont_mul_public", to: "GRPC_SHADOW_ec_GFp_mont_mul_public"),
        // .define("EC_GFp_nistp224_method", to: "GRPC_SHADOW_EC_GFp_nistp224_method"),
        // .define("EC_GFp_nistp256_method", to: "GRPC_SHADOW_EC_GFp_nistp256_method"),
        // .define("ec_GFp_nistp_recode_scalar_bits", to: "GRPC_SHADOW_ec_GFp_nistp_recode_scalar_bits"),
        // .define("EC_GFp_nistz256_method", to: "GRPC_SHADOW_EC_GFp_nistz256_method"),
        // .define("ec_GFp_simple_cmp", to: "GRPC_SHADOW_ec_GFp_simple_cmp"),
        // .define("ec_GFp_simple_cmp_x_coordinate", to: "GRPC_SHADOW_ec_GFp_simple_cmp_x_coordinate"),
        // .define("ec_GFp_simple_group_finish", to: "GRPC_SHADOW_ec_GFp_simple_group_finish"),
        // .define("ec_GFp_simple_group_get_curve", to: "GRPC_SHADOW_ec_GFp_simple_group_get_curve"),
        // .define("ec_GFp_simple_group_init", to: "GRPC_SHADOW_ec_GFp_simple_group_init"),
        // .define("ec_GFp_simple_group_set_curve", to: "GRPC_SHADOW_ec_GFp_simple_group_set_curve"),
        // .define("ec_GFp_simple_invert", to: "GRPC_SHADOW_ec_GFp_simple_invert"),
        // .define("ec_GFp_simple_is_at_infinity", to: "GRPC_SHADOW_ec_GFp_simple_is_at_infinity"),
        // .define("ec_GFp_simple_is_on_curve", to: "GRPC_SHADOW_ec_GFp_simple_is_on_curve"),
        // .define("ec_GFp_simple_mont_inv_mod_ord_vartime", to: "GRPC_SHADOW_ec_GFp_simple_mont_inv_mod_ord_vartime"),
        // .define("ec_GFp_simple_point_copy", to: "GRPC_SHADOW_ec_GFp_simple_point_copy"),
        // .define("ec_GFp_simple_point_init", to: "GRPC_SHADOW_ec_GFp_simple_point_init"),
        // .define("ec_GFp_simple_point_set_affine_coordinates", to: "GRPC_SHADOW_ec_GFp_simple_point_set_affine_coordinates"),
        // .define("ec_GFp_simple_point_set_to_infinity", to: "GRPC_SHADOW_ec_GFp_simple_point_set_to_infinity"),
        // .define("EC_GROUP_cmp", to: "GRPC_SHADOW_EC_GROUP_cmp"),
        // .define("EC_GROUP_dup", to: "GRPC_SHADOW_EC_GROUP_dup"),
        // .define("EC_GROUP_free", to: "GRPC_SHADOW_EC_GROUP_free"),
        // .define("EC_GROUP_get0_generator", to: "GRPC_SHADOW_EC_GROUP_get0_generator"),
        // .define("EC_GROUP_get0_order", to: "GRPC_SHADOW_EC_GROUP_get0_order"),
        // .define("EC_GROUP_get_cofactor", to: "GRPC_SHADOW_EC_GROUP_get_cofactor"),
        // .define("EC_GROUP_get_curve_GFp", to: "GRPC_SHADOW_EC_GROUP_get_curve_GFp"),
        // .define("EC_GROUP_get_curve_name", to: "GRPC_SHADOW_EC_GROUP_get_curve_name"),
        // .define("EC_GROUP_get_degree", to: "GRPC_SHADOW_EC_GROUP_get_degree"),
        // .define("EC_GROUP_get_order", to: "GRPC_SHADOW_EC_GROUP_get_order"),
        // .define("EC_GROUP_method_of", to: "GRPC_SHADOW_EC_GROUP_method_of"),
        // .define("ec_group_new", to: "GRPC_SHADOW_ec_group_new"),
        // .define("EC_GROUP_new_by_curve_name", to: "GRPC_SHADOW_EC_GROUP_new_by_curve_name"),
        // .define("EC_GROUP_new_curve_GFp", to: "GRPC_SHADOW_EC_GROUP_new_curve_GFp"),
        // .define("EC_GROUP_order_bits", to: "GRPC_SHADOW_EC_GROUP_order_bits"),
        // .define("EC_GROUP_set_asn1_flag", to: "GRPC_SHADOW_EC_GROUP_set_asn1_flag"),
        // .define("EC_GROUP_set_generator", to: "GRPC_SHADOW_EC_GROUP_set_generator"),
        // .define("EC_GROUP_set_point_conversion_form", to: "GRPC_SHADOW_EC_GROUP_set_point_conversion_form"),
        // .define("EC_KEY_check_fips", to: "GRPC_SHADOW_EC_KEY_check_fips"),
        // .define("EC_KEY_check_key", to: "GRPC_SHADOW_EC_KEY_check_key"),
        // .define("EC_KEY_derive_from_secret", to: "GRPC_SHADOW_EC_KEY_derive_from_secret"),
        // .define("EC_KEY_dup", to: "GRPC_SHADOW_EC_KEY_dup"),
        // .define("EC_KEY_free", to: "GRPC_SHADOW_EC_KEY_free"),
        // .define("EC_KEY_generate_key", to: "GRPC_SHADOW_EC_KEY_generate_key"),
        // .define("EC_KEY_generate_key_fips", to: "GRPC_SHADOW_EC_KEY_generate_key_fips"),
        // .define("EC_KEY_get0_group", to: "GRPC_SHADOW_EC_KEY_get0_group"),
        // .define("EC_KEY_get0_private_key", to: "GRPC_SHADOW_EC_KEY_get0_private_key"),
        // .define("EC_KEY_get0_public_key", to: "GRPC_SHADOW_EC_KEY_get0_public_key"),
        // .define("EC_KEY_get_conv_form", to: "GRPC_SHADOW_EC_KEY_get_conv_form"),
        // .define("EC_KEY_get_enc_flags", to: "GRPC_SHADOW_EC_KEY_get_enc_flags"),
        // .define("EC_KEY_get_ex_data", to: "GRPC_SHADOW_EC_KEY_get_ex_data"),
        // .define("EC_KEY_get_ex_new_index", to: "GRPC_SHADOW_EC_KEY_get_ex_new_index"),
        // .define("EC_KEY_is_opaque", to: "GRPC_SHADOW_EC_KEY_is_opaque"),
        // .define("EC_KEY_key2buf", to: "GRPC_SHADOW_EC_KEY_key2buf"),
        // .define("EC_KEY_marshal_curve_name", to: "GRPC_SHADOW_EC_KEY_marshal_curve_name"),
        // .define("EC_KEY_marshal_private_key", to: "GRPC_SHADOW_EC_KEY_marshal_private_key"),
        // .define("EC_KEY_new", to: "GRPC_SHADOW_EC_KEY_new"),
        // .define("EC_KEY_new_by_curve_name", to: "GRPC_SHADOW_EC_KEY_new_by_curve_name"),
        // .define("EC_KEY_new_method", to: "GRPC_SHADOW_EC_KEY_new_method"),
        // .define("EC_KEY_parse_curve_name", to: "GRPC_SHADOW_EC_KEY_parse_curve_name"),
        // .define("EC_KEY_parse_parameters", to: "GRPC_SHADOW_EC_KEY_parse_parameters"),
        // .define("EC_KEY_parse_private_key", to: "GRPC_SHADOW_EC_KEY_parse_private_key"),
        // .define("EC_KEY_set_asn1_flag", to: "GRPC_SHADOW_EC_KEY_set_asn1_flag"),
        // .define("EC_KEY_set_conv_form", to: "GRPC_SHADOW_EC_KEY_set_conv_form"),
        // .define("EC_KEY_set_enc_flags", to: "GRPC_SHADOW_EC_KEY_set_enc_flags"),
        // .define("EC_KEY_set_ex_data", to: "GRPC_SHADOW_EC_KEY_set_ex_data"),
        // .define("EC_KEY_set_group", to: "GRPC_SHADOW_EC_KEY_set_group"),
        // .define("EC_KEY_set_private_key", to: "GRPC_SHADOW_EC_KEY_set_private_key"),
        // .define("EC_KEY_set_public_key", to: "GRPC_SHADOW_EC_KEY_set_public_key"),
        // .define("EC_KEY_set_public_key_affine_coordinates", to: "GRPC_SHADOW_EC_KEY_set_public_key_affine_coordinates"),
        // .define("EC_KEY_up_ref", to: "GRPC_SHADOW_EC_KEY_up_ref"),
        // .define("EC_METHOD_get_field_type", to: "GRPC_SHADOW_EC_METHOD_get_field_type"),
        // .define("ec_pkey_meth", to: "GRPC_SHADOW_ec_pkey_meth"),
        // .define("ecp_nistz256_avx2_select_w7", to: "GRPC_SHADOW_ecp_nistz256_avx2_select_w7"),
        // .define("ecp_nistz256_mul_mont", to: "GRPC_SHADOW_ecp_nistz256_mul_mont"),
        // .define("ecp_nistz256_neg", to: "GRPC_SHADOW_ecp_nistz256_neg"),
        // .define("ecp_nistz256_ord_mul_mont", to: "GRPC_SHADOW_ecp_nistz256_ord_mul_mont"),
        // .define("ecp_nistz256_ord_sqr_mont", to: "GRPC_SHADOW_ecp_nistz256_ord_sqr_mont"),
        // .define("ecp_nistz256_point_add", to: "GRPC_SHADOW_ecp_nistz256_point_add"),
        // .define("ecp_nistz256_point_add_affine", to: "GRPC_SHADOW_ecp_nistz256_point_add_affine"),
        // .define("ecp_nistz256_point_double", to: "GRPC_SHADOW_ecp_nistz256_point_double"),
        // .define("ecp_nistz256_select_w5", to: "GRPC_SHADOW_ecp_nistz256_select_w5"),
        // .define("ecp_nistz256_select_w7", to: "GRPC_SHADOW_ecp_nistz256_select_w7"),
        // .define("ecp_nistz256_sqr_mont", to: "GRPC_SHADOW_ecp_nistz256_sqr_mont"),
        // .define("EC_POINT_add", to: "GRPC_SHADOW_EC_POINT_add"),
        // .define("EC_POINT_clear_free", to: "GRPC_SHADOW_EC_POINT_clear_free"),
        // .define("EC_POINT_cmp", to: "GRPC_SHADOW_EC_POINT_cmp"),
        // .define("EC_POINT_copy", to: "GRPC_SHADOW_EC_POINT_copy"),
        // .define("EC_POINT_dbl", to: "GRPC_SHADOW_EC_POINT_dbl"),
        // .define("EC_POINT_dup", to: "GRPC_SHADOW_EC_POINT_dup"),
        // .define("EC_POINT_free", to: "GRPC_SHADOW_EC_POINT_free"),
        // .define("ec_point_get_affine_coordinate_bytes", to: "GRPC_SHADOW_ec_point_get_affine_coordinate_bytes"),
        // .define("EC_POINT_get_affine_coordinates_GFp", to: "GRPC_SHADOW_EC_POINT_get_affine_coordinates_GFp"),
        // .define("EC_POINT_invert", to: "GRPC_SHADOW_EC_POINT_invert"),
        // .define("EC_POINT_is_at_infinity", to: "GRPC_SHADOW_EC_POINT_is_at_infinity"),
        // .define("EC_POINT_is_on_curve", to: "GRPC_SHADOW_EC_POINT_is_on_curve"),
        // .define("EC_POINT_mul", to: "GRPC_SHADOW_EC_POINT_mul"),
        // .define("ec_point_mul_scalar", to: "GRPC_SHADOW_ec_point_mul_scalar"),
        // .define("ec_point_mul_scalar_base", to: "GRPC_SHADOW_ec_point_mul_scalar_base"),
        // .define("ec_point_mul_scalar_public", to: "GRPC_SHADOW_ec_point_mul_scalar_public"),
        // .define("EC_POINT_new", to: "GRPC_SHADOW_EC_POINT_new"),
        // .define("EC_POINT_oct2point", to: "GRPC_SHADOW_EC_POINT_oct2point"),
        // .define("EC_POINT_point2cbb", to: "GRPC_SHADOW_EC_POINT_point2cbb"),
        // .define("EC_POINT_point2oct", to: "GRPC_SHADOW_EC_POINT_point2oct"),
        // .define("EC_POINT_set_affine_coordinates_GFp", to: "GRPC_SHADOW_EC_POINT_set_affine_coordinates_GFp"),
        // .define("EC_POINT_set_compressed_coordinates_GFp", to: "GRPC_SHADOW_EC_POINT_set_compressed_coordinates_GFp"),
        // .define("EC_POINT_set_to_infinity", to: "GRPC_SHADOW_EC_POINT_set_to_infinity"),
        // .define("ec_random_nonzero_scalar", to: "GRPC_SHADOW_ec_random_nonzero_scalar"),
        // .define("ec_scalar_add", to: "GRPC_SHADOW_ec_scalar_add"),
        // .define("ec_scalar_equal_vartime", to: "GRPC_SHADOW_ec_scalar_equal_vartime"),
        // .define("ec_scalar_from_montgomery", to: "GRPC_SHADOW_ec_scalar_from_montgomery"),
        // .define("ec_scalar_inv_montgomery", to: "GRPC_SHADOW_ec_scalar_inv_montgomery"),
        // .define("ec_scalar_inv_montgomery_vartime", to: "GRPC_SHADOW_ec_scalar_inv_montgomery_vartime"),
        // .define("ec_scalar_is_zero", to: "GRPC_SHADOW_ec_scalar_is_zero"),
        // .define("ec_scalar_mul_montgomery", to: "GRPC_SHADOW_ec_scalar_mul_montgomery"),
        // .define("ec_scalar_to_montgomery", to: "GRPC_SHADOW_ec_scalar_to_montgomery"),
        // .define("ec_simple_scalar_inv_montgomery", to: "GRPC_SHADOW_ec_simple_scalar_inv_montgomery"),
        // .define("ed25519_asn1_meth", to: "GRPC_SHADOW_ed25519_asn1_meth"),
        // .define("ED25519_keypair", to: "GRPC_SHADOW_ED25519_keypair"),
        // .define("ED25519_keypair_from_seed", to: "GRPC_SHADOW_ED25519_keypair_from_seed"),
        // .define("ed25519_pkey_meth", to: "GRPC_SHADOW_ed25519_pkey_meth"),
        // .define("ED25519_sign", to: "GRPC_SHADOW_ED25519_sign"),
        // .define("ED25519_verify", to: "GRPC_SHADOW_ED25519_verify"),
        // .define("EDIPARTYNAME_free", to: "GRPC_SHADOW_EDIPARTYNAME_free"),
        // .define("EDIPARTYNAME_it", to: "GRPC_SHADOW_EDIPARTYNAME_it"),
        // .define("EDIPARTYNAME_new", to: "GRPC_SHADOW_EDIPARTYNAME_new"),
        // .define("ENGINE_free", to: "GRPC_SHADOW_ENGINE_free"),
        // .define("ENGINE_get_ECDSA_method", to: "GRPC_SHADOW_ENGINE_get_ECDSA_method"),
        // .define("ENGINE_get_RSA_method", to: "GRPC_SHADOW_ENGINE_get_RSA_method"),
        // .define("ENGINE_load_builtin_engines", to: "GRPC_SHADOW_ENGINE_load_builtin_engines"),
        // .define("ENGINE_new", to: "GRPC_SHADOW_ENGINE_new"),
        // .define("ENGINE_register_all_complete", to: "GRPC_SHADOW_ENGINE_register_all_complete"),
        // .define("ENGINE_set_ECDSA_method", to: "GRPC_SHADOW_ENGINE_set_ECDSA_method"),
        // .define("ENGINE_set_RSA_method", to: "GRPC_SHADOW_ENGINE_set_RSA_method"),
        // .define("ERR_add_error_data", to: "GRPC_SHADOW_ERR_add_error_data"),
        // .define("ERR_add_error_dataf", to: "GRPC_SHADOW_ERR_add_error_dataf"),
        // .define("ERR_clear_error", to: "GRPC_SHADOW_ERR_clear_error"),
        // .define("ERR_clear_system_error", to: "GRPC_SHADOW_ERR_clear_system_error"),
        // .define("ERR_error_string", to: "GRPC_SHADOW_ERR_error_string"),
        // .define("ERR_error_string_n", to: "GRPC_SHADOW_ERR_error_string_n"),
        // .define("ERR_free_strings", to: "GRPC_SHADOW_ERR_free_strings"),
        // .define("ERR_func_error_string", to: "GRPC_SHADOW_ERR_func_error_string"),
        // .define("ERR_get_error", to: "GRPC_SHADOW_ERR_get_error"),
        // .define("ERR_get_error_line", to: "GRPC_SHADOW_ERR_get_error_line"),
        // .define("ERR_get_error_line_data", to: "GRPC_SHADOW_ERR_get_error_line_data"),
        // .define("ERR_get_next_error_library", to: "GRPC_SHADOW_ERR_get_next_error_library"),
        // .define("ERR_lib_error_string", to: "GRPC_SHADOW_ERR_lib_error_string"),
        // .define("ERR_load_BIO_strings", to: "GRPC_SHADOW_ERR_load_BIO_strings"),
        // .define("ERR_load_crypto_strings", to: "GRPC_SHADOW_ERR_load_crypto_strings"),
        // .define("ERR_load_ERR_strings", to: "GRPC_SHADOW_ERR_load_ERR_strings"),
        // .define("ERR_load_RAND_strings", to: "GRPC_SHADOW_ERR_load_RAND_strings"),
        // .define("ERR_load_SSL_strings", to: "GRPC_SHADOW_ERR_load_SSL_strings"),
        // .define("ERR_peek_error", to: "GRPC_SHADOW_ERR_peek_error"),
        // .define("ERR_peek_error_line", to: "GRPC_SHADOW_ERR_peek_error_line"),
        // .define("ERR_peek_error_line_data", to: "GRPC_SHADOW_ERR_peek_error_line_data"),
        // .define("ERR_peek_last_error", to: "GRPC_SHADOW_ERR_peek_last_error"),
        // .define("ERR_peek_last_error_line", to: "GRPC_SHADOW_ERR_peek_last_error_line"),
        // .define("ERR_peek_last_error_line_data", to: "GRPC_SHADOW_ERR_peek_last_error_line_data"),
        // .define("ERR_pop_to_mark", to: "GRPC_SHADOW_ERR_pop_to_mark"),
        // .define("ERR_print_errors", to: "GRPC_SHADOW_ERR_print_errors"),
        // .define("ERR_print_errors_cb", to: "GRPC_SHADOW_ERR_print_errors_cb"),
        // .define("ERR_print_errors_fp", to: "GRPC_SHADOW_ERR_print_errors_fp"),
        // .define("ERR_put_error", to: "GRPC_SHADOW_ERR_put_error"),
        // .define("ERR_reason_error_string", to: "GRPC_SHADOW_ERR_reason_error_string"),
        // .define("ERR_remove_state", to: "GRPC_SHADOW_ERR_remove_state"),
        // .define("ERR_remove_thread_state", to: "GRPC_SHADOW_ERR_remove_thread_state"),
        // .define("ERR_restore_state", to: "GRPC_SHADOW_ERR_restore_state"),
        // .define("ERR_save_state", to: "GRPC_SHADOW_ERR_save_state"),
        // .define("ERR_SAVE_STATE_free", to: "GRPC_SHADOW_ERR_SAVE_STATE_free"),
        // .define("ERR_set_mark", to: "GRPC_SHADOW_ERR_set_mark"),
        // .define("EVP_add_cipher_alias", to: "GRPC_SHADOW_EVP_add_cipher_alias"),
        // .define("EVP_add_digest", to: "GRPC_SHADOW_EVP_add_digest"),
        // .define("EVP_aead_aes_128_cbc_sha1_tls", to: "GRPC_SHADOW_EVP_aead_aes_128_cbc_sha1_tls"),
        // .define("EVP_aead_aes_128_cbc_sha1_tls_implicit_iv", to: "GRPC_SHADOW_EVP_aead_aes_128_cbc_sha1_tls_implicit_iv"),
        // .define("EVP_aead_aes_128_cbc_sha256_tls", to: "GRPC_SHADOW_EVP_aead_aes_128_cbc_sha256_tls"),
        // .define("EVP_aead_aes_128_ccm_bluetooth", to: "GRPC_SHADOW_EVP_aead_aes_128_ccm_bluetooth"),
        // .define("EVP_aead_aes_128_ccm_bluetooth_8", to: "GRPC_SHADOW_EVP_aead_aes_128_ccm_bluetooth_8"),
        // .define("EVP_aead_aes_128_ctr_hmac_sha256", to: "GRPC_SHADOW_EVP_aead_aes_128_ctr_hmac_sha256"),
        // .define("EVP_aead_aes_128_gcm", to: "GRPC_SHADOW_EVP_aead_aes_128_gcm"),
        // .define("EVP_aead_aes_128_gcm_siv", to: "GRPC_SHADOW_EVP_aead_aes_128_gcm_siv"),
        // .define("EVP_aead_aes_128_gcm_tls12", to: "GRPC_SHADOW_EVP_aead_aes_128_gcm_tls12"),
        // .define("EVP_aead_aes_128_gcm_tls13", to: "GRPC_SHADOW_EVP_aead_aes_128_gcm_tls13"),
        // .define("EVP_aead_aes_192_gcm", to: "GRPC_SHADOW_EVP_aead_aes_192_gcm"),
        // .define("EVP_aead_aes_256_cbc_sha1_tls", to: "GRPC_SHADOW_EVP_aead_aes_256_cbc_sha1_tls"),
        // .define("EVP_aead_aes_256_cbc_sha1_tls_implicit_iv", to: "GRPC_SHADOW_EVP_aead_aes_256_cbc_sha1_tls_implicit_iv"),
        // .define("EVP_aead_aes_256_cbc_sha256_tls", to: "GRPC_SHADOW_EVP_aead_aes_256_cbc_sha256_tls"),
        // .define("EVP_aead_aes_256_cbc_sha384_tls", to: "GRPC_SHADOW_EVP_aead_aes_256_cbc_sha384_tls"),
        // .define("EVP_aead_aes_256_ctr_hmac_sha256", to: "GRPC_SHADOW_EVP_aead_aes_256_ctr_hmac_sha256"),
        // .define("EVP_aead_aes_256_gcm", to: "GRPC_SHADOW_EVP_aead_aes_256_gcm"),
        // .define("EVP_aead_aes_256_gcm_siv", to: "GRPC_SHADOW_EVP_aead_aes_256_gcm_siv"),
        // .define("EVP_aead_aes_256_gcm_tls12", to: "GRPC_SHADOW_EVP_aead_aes_256_gcm_tls12"),
        // .define("EVP_aead_aes_256_gcm_tls13", to: "GRPC_SHADOW_EVP_aead_aes_256_gcm_tls13"),
        // .define("EVP_aead_chacha20_poly1305", to: "GRPC_SHADOW_EVP_aead_chacha20_poly1305"),
        // .define("EVP_AEAD_CTX_aead", to: "GRPC_SHADOW_EVP_AEAD_CTX_aead"),
        // .define("EVP_AEAD_CTX_cleanup", to: "GRPC_SHADOW_EVP_AEAD_CTX_cleanup"),
        // .define("EVP_AEAD_CTX_free", to: "GRPC_SHADOW_EVP_AEAD_CTX_free"),
        // .define("EVP_AEAD_CTX_get_iv", to: "GRPC_SHADOW_EVP_AEAD_CTX_get_iv"),
        // .define("EVP_AEAD_CTX_init", to: "GRPC_SHADOW_EVP_AEAD_CTX_init"),
        // .define("EVP_AEAD_CTX_init_with_direction", to: "GRPC_SHADOW_EVP_AEAD_CTX_init_with_direction"),
        // .define("EVP_AEAD_CTX_new", to: "GRPC_SHADOW_EVP_AEAD_CTX_new"),
        // .define("EVP_AEAD_CTX_open", to: "GRPC_SHADOW_EVP_AEAD_CTX_open"),
        // .define("EVP_AEAD_CTX_open_gather", to: "GRPC_SHADOW_EVP_AEAD_CTX_open_gather"),
        // .define("EVP_AEAD_CTX_seal", to: "GRPC_SHADOW_EVP_AEAD_CTX_seal"),
        // .define("EVP_AEAD_CTX_seal_scatter", to: "GRPC_SHADOW_EVP_AEAD_CTX_seal_scatter"),
        // .define("EVP_AEAD_CTX_tag_len", to: "GRPC_SHADOW_EVP_AEAD_CTX_tag_len"),
        // .define("EVP_AEAD_CTX_zero", to: "GRPC_SHADOW_EVP_AEAD_CTX_zero"),
        // .define("EVP_aead_des_ede3_cbc_sha1_tls", to: "GRPC_SHADOW_EVP_aead_des_ede3_cbc_sha1_tls"),
        // .define("EVP_aead_des_ede3_cbc_sha1_tls_implicit_iv", to: "GRPC_SHADOW_EVP_aead_des_ede3_cbc_sha1_tls_implicit_iv"),
        // .define("EVP_AEAD_key_length", to: "GRPC_SHADOW_EVP_AEAD_key_length"),
        // .define("EVP_AEAD_max_overhead", to: "GRPC_SHADOW_EVP_AEAD_max_overhead"),
        // .define("EVP_AEAD_max_tag_len", to: "GRPC_SHADOW_EVP_AEAD_max_tag_len"),
        // .define("EVP_AEAD_nonce_length", to: "GRPC_SHADOW_EVP_AEAD_nonce_length"),
        // .define("EVP_aead_null_sha1_tls", to: "GRPC_SHADOW_EVP_aead_null_sha1_tls"),
        // .define("EVP_aead_xchacha20_poly1305", to: "GRPC_SHADOW_EVP_aead_xchacha20_poly1305"),
        // .define("EVP_aes_128_cbc", to: "GRPC_SHADOW_EVP_aes_128_cbc"),
        // .define("EVP_aes_128_ctr", to: "GRPC_SHADOW_EVP_aes_128_ctr"),
        // .define("EVP_aes_128_ecb", to: "GRPC_SHADOW_EVP_aes_128_ecb"),
        // .define("EVP_aes_128_gcm", to: "GRPC_SHADOW_EVP_aes_128_gcm"),
        // .define("EVP_aes_128_ofb", to: "GRPC_SHADOW_EVP_aes_128_ofb"),
        // .define("EVP_aes_192_cbc", to: "GRPC_SHADOW_EVP_aes_192_cbc"),
        // .define("EVP_aes_192_ctr", to: "GRPC_SHADOW_EVP_aes_192_ctr"),
        // .define("EVP_aes_192_ecb", to: "GRPC_SHADOW_EVP_aes_192_ecb"),
        // .define("EVP_aes_192_gcm", to: "GRPC_SHADOW_EVP_aes_192_gcm"),
        // .define("EVP_aes_192_ofb", to: "GRPC_SHADOW_EVP_aes_192_ofb"),
        // .define("EVP_aes_256_cbc", to: "GRPC_SHADOW_EVP_aes_256_cbc"),
        // .define("EVP_aes_256_ctr", to: "GRPC_SHADOW_EVP_aes_256_ctr"),
        // .define("EVP_aes_256_ecb", to: "GRPC_SHADOW_EVP_aes_256_ecb"),
        // .define("EVP_aes_256_gcm", to: "GRPC_SHADOW_EVP_aes_256_gcm"),
        // .define("EVP_aes_256_ofb", to: "GRPC_SHADOW_EVP_aes_256_ofb"),
        // .define("EVP_BytesToKey", to: "GRPC_SHADOW_EVP_BytesToKey"),
        // .define("EVP_Cipher", to: "GRPC_SHADOW_EVP_Cipher"),
        // .define("EVP_CIPHER_block_size", to: "GRPC_SHADOW_EVP_CIPHER_block_size"),
        // .define("EVP_CIPHER_CTX_block_size", to: "GRPC_SHADOW_EVP_CIPHER_CTX_block_size"),
        // .define("EVP_CIPHER_CTX_cipher", to: "GRPC_SHADOW_EVP_CIPHER_CTX_cipher"),
        // .define("EVP_CIPHER_CTX_cleanup", to: "GRPC_SHADOW_EVP_CIPHER_CTX_cleanup"),
        // .define("EVP_CIPHER_CTX_copy", to: "GRPC_SHADOW_EVP_CIPHER_CTX_copy"),
        // .define("EVP_CIPHER_CTX_ctrl", to: "GRPC_SHADOW_EVP_CIPHER_CTX_ctrl"),
        // .define("EVP_CIPHER_CTX_encrypting", to: "GRPC_SHADOW_EVP_CIPHER_CTX_encrypting"),
        // .define("EVP_CIPHER_CTX_flags", to: "GRPC_SHADOW_EVP_CIPHER_CTX_flags"),
        // .define("EVP_CIPHER_CTX_free", to: "GRPC_SHADOW_EVP_CIPHER_CTX_free"),
        // .define("EVP_CIPHER_CTX_get_app_data", to: "GRPC_SHADOW_EVP_CIPHER_CTX_get_app_data"),
        // .define("EVP_CIPHER_CTX_init", to: "GRPC_SHADOW_EVP_CIPHER_CTX_init"),
        // .define("EVP_CIPHER_CTX_iv_length", to: "GRPC_SHADOW_EVP_CIPHER_CTX_iv_length"),
        // .define("EVP_CIPHER_CTX_key_length", to: "GRPC_SHADOW_EVP_CIPHER_CTX_key_length"),
        // .define("EVP_CIPHER_CTX_mode", to: "GRPC_SHADOW_EVP_CIPHER_CTX_mode"),
        // .define("EVP_CIPHER_CTX_new", to: "GRPC_SHADOW_EVP_CIPHER_CTX_new"),
        // .define("EVP_CIPHER_CTX_nid", to: "GRPC_SHADOW_EVP_CIPHER_CTX_nid"),
        // .define("EVP_CIPHER_CTX_reset", to: "GRPC_SHADOW_EVP_CIPHER_CTX_reset"),
        // .define("EVP_CIPHER_CTX_set_app_data", to: "GRPC_SHADOW_EVP_CIPHER_CTX_set_app_data"),
        // .define("EVP_CIPHER_CTX_set_flags", to: "GRPC_SHADOW_EVP_CIPHER_CTX_set_flags"),
        // .define("EVP_CIPHER_CTX_set_key_length", to: "GRPC_SHADOW_EVP_CIPHER_CTX_set_key_length"),
        // .define("EVP_CIPHER_CTX_set_padding", to: "GRPC_SHADOW_EVP_CIPHER_CTX_set_padding"),
        // .define("EVP_CipherFinal_ex", to: "GRPC_SHADOW_EVP_CipherFinal_ex"),
        // .define("EVP_CIPHER_flags", to: "GRPC_SHADOW_EVP_CIPHER_flags"),
        // .define("EVP_CipherInit", to: "GRPC_SHADOW_EVP_CipherInit"),
        // .define("EVP_CipherInit_ex", to: "GRPC_SHADOW_EVP_CipherInit_ex"),
        // .define("EVP_CIPHER_iv_length", to: "GRPC_SHADOW_EVP_CIPHER_iv_length"),
        // .define("EVP_CIPHER_key_length", to: "GRPC_SHADOW_EVP_CIPHER_key_length"),
        // .define("EVP_CIPHER_mode", to: "GRPC_SHADOW_EVP_CIPHER_mode"),
        // .define("EVP_CIPHER_nid", to: "GRPC_SHADOW_EVP_CIPHER_nid"),
        // .define("EVP_CipherUpdate", to: "GRPC_SHADOW_EVP_CipherUpdate"),
        // .define("EVP_cleanup", to: "GRPC_SHADOW_EVP_cleanup"),
        // .define("EVP_DecodeBase64", to: "GRPC_SHADOW_EVP_DecodeBase64"),
        // .define("EVP_DecodeBlock", to: "GRPC_SHADOW_EVP_DecodeBlock"),
        // .define("EVP_DecodedLength", to: "GRPC_SHADOW_EVP_DecodedLength"),
        // .define("EVP_DecodeFinal", to: "GRPC_SHADOW_EVP_DecodeFinal"),
        // .define("EVP_DecodeInit", to: "GRPC_SHADOW_EVP_DecodeInit"),
        // .define("EVP_DecodeUpdate", to: "GRPC_SHADOW_EVP_DecodeUpdate"),
        // .define("EVP_DecryptFinal_ex", to: "GRPC_SHADOW_EVP_DecryptFinal_ex"),
        // .define("EVP_DecryptInit", to: "GRPC_SHADOW_EVP_DecryptInit"),
        // .define("EVP_DecryptInit_ex", to: "GRPC_SHADOW_EVP_DecryptInit_ex"),
        // .define("EVP_DecryptUpdate", to: "GRPC_SHADOW_EVP_DecryptUpdate"),
        // .define("EVP_des_cbc", to: "GRPC_SHADOW_EVP_des_cbc"),
        // .define("EVP_des_ecb", to: "GRPC_SHADOW_EVP_des_ecb"),
        // .define("EVP_des_ede", to: "GRPC_SHADOW_EVP_des_ede"),
        // .define("EVP_des_ede3", to: "GRPC_SHADOW_EVP_des_ede3"),
        // .define("EVP_des_ede3_cbc", to: "GRPC_SHADOW_EVP_des_ede3_cbc"),
        // .define("EVP_des_ede3_ecb", to: "GRPC_SHADOW_EVP_des_ede3_ecb"),
        // .define("EVP_des_ede_cbc", to: "GRPC_SHADOW_EVP_des_ede_cbc"),
        // .define("EVP_Digest", to: "GRPC_SHADOW_EVP_Digest"),
        // .define("EVP_DigestFinal", to: "GRPC_SHADOW_EVP_DigestFinal"),
        // .define("EVP_DigestFinal_ex", to: "GRPC_SHADOW_EVP_DigestFinal_ex"),
        // .define("EVP_DigestFinalXOF", to: "GRPC_SHADOW_EVP_DigestFinalXOF"),
        // .define("EVP_DigestInit", to: "GRPC_SHADOW_EVP_DigestInit"),
        // .define("EVP_DigestInit_ex", to: "GRPC_SHADOW_EVP_DigestInit_ex"),
        // .define("EVP_DigestSign", to: "GRPC_SHADOW_EVP_DigestSign"),
        // .define("EVP_DigestSignFinal", to: "GRPC_SHADOW_EVP_DigestSignFinal"),
        // .define("EVP_DigestSignInit", to: "GRPC_SHADOW_EVP_DigestSignInit"),
        // .define("EVP_DigestSignUpdate", to: "GRPC_SHADOW_EVP_DigestSignUpdate"),
        // .define("EVP_DigestUpdate", to: "GRPC_SHADOW_EVP_DigestUpdate"),
        // .define("EVP_DigestVerify", to: "GRPC_SHADOW_EVP_DigestVerify"),
        // .define("EVP_DigestVerifyFinal", to: "GRPC_SHADOW_EVP_DigestVerifyFinal"),
        // .define("EVP_DigestVerifyInit", to: "GRPC_SHADOW_EVP_DigestVerifyInit"),
        // .define("EVP_DigestVerifyUpdate", to: "GRPC_SHADOW_EVP_DigestVerifyUpdate"),
        // .define("EVP_enc_null", to: "GRPC_SHADOW_EVP_enc_null"),
        // .define("EVP_EncodeBlock", to: "GRPC_SHADOW_EVP_EncodeBlock"),
        // .define("EVP_EncodedLength", to: "GRPC_SHADOW_EVP_EncodedLength"),
        // .define("EVP_EncodeFinal", to: "GRPC_SHADOW_EVP_EncodeFinal"),
        // .define("EVP_EncodeInit", to: "GRPC_SHADOW_EVP_EncodeInit"),
        // .define("EVP_EncodeUpdate", to: "GRPC_SHADOW_EVP_EncodeUpdate"),
        // .define("EVP_EncryptFinal_ex", to: "GRPC_SHADOW_EVP_EncryptFinal_ex"),
        // .define("EVP_EncryptInit", to: "GRPC_SHADOW_EVP_EncryptInit"),
        // .define("EVP_EncryptInit_ex", to: "GRPC_SHADOW_EVP_EncryptInit_ex"),
        // .define("EVP_EncryptUpdate", to: "GRPC_SHADOW_EVP_EncryptUpdate"),
        // .define("EVP_get_cipherbyname", to: "GRPC_SHADOW_EVP_get_cipherbyname"),
        // .define("EVP_get_cipherbynid", to: "GRPC_SHADOW_EVP_get_cipherbynid"),
        // .define("EVP_get_digestbyname", to: "GRPC_SHADOW_EVP_get_digestbyname"),
        // .define("EVP_get_digestbynid", to: "GRPC_SHADOW_EVP_get_digestbynid"),
        // .define("EVP_get_digestbyobj", to: "GRPC_SHADOW_EVP_get_digestbyobj"),
        // .define("EVP_has_aes_hardware", to: "GRPC_SHADOW_EVP_has_aes_hardware"),
        // .define("EVP_marshal_digest_algorithm", to: "GRPC_SHADOW_EVP_marshal_digest_algorithm"),
        // .define("EVP_marshal_private_key", to: "GRPC_SHADOW_EVP_marshal_private_key"),
        // .define("EVP_marshal_public_key", to: "GRPC_SHADOW_EVP_marshal_public_key"),
        // .define("EVP_md4", to: "GRPC_SHADOW_EVP_md4"),
        // .define("EVP_md5", to: "GRPC_SHADOW_EVP_md5"),
        // .define("EVP_md5_sha1", to: "GRPC_SHADOW_EVP_md5_sha1"),
        // .define("EVP_MD_block_size", to: "GRPC_SHADOW_EVP_MD_block_size"),
        // .define("EVP_MD_CTX_block_size", to: "GRPC_SHADOW_EVP_MD_CTX_block_size"),
        // .define("EVP_MD_CTX_cleanup", to: "GRPC_SHADOW_EVP_MD_CTX_cleanup"),
        // .define("EVP_MD_CTX_copy", to: "GRPC_SHADOW_EVP_MD_CTX_copy"),
        // .define("EVP_MD_CTX_copy_ex", to: "GRPC_SHADOW_EVP_MD_CTX_copy_ex"),
        // .define("EVP_MD_CTX_create", to: "GRPC_SHADOW_EVP_MD_CTX_create"),
        // .define("EVP_MD_CTX_destroy", to: "GRPC_SHADOW_EVP_MD_CTX_destroy"),
        // .define("EVP_MD_CTX_free", to: "GRPC_SHADOW_EVP_MD_CTX_free"),
        // .define("EVP_MD_CTX_init", to: "GRPC_SHADOW_EVP_MD_CTX_init"),
        // .define("EVP_MD_CTX_md", to: "GRPC_SHADOW_EVP_MD_CTX_md"),
        // .define("EVP_MD_CTX_new", to: "GRPC_SHADOW_EVP_MD_CTX_new"),
        // .define("EVP_MD_CTX_reset", to: "GRPC_SHADOW_EVP_MD_CTX_reset"),
        // .define("EVP_MD_CTX_size", to: "GRPC_SHADOW_EVP_MD_CTX_size"),
        // .define("EVP_MD_CTX_type", to: "GRPC_SHADOW_EVP_MD_CTX_type"),
        // .define("EVP_MD_flags", to: "GRPC_SHADOW_EVP_MD_flags"),
        // .define("EVP_MD_meth_get_flags", to: "GRPC_SHADOW_EVP_MD_meth_get_flags"),
        // .define("EVP_MD_size", to: "GRPC_SHADOW_EVP_MD_size"),
        // .define("EVP_MD_type", to: "GRPC_SHADOW_EVP_MD_type"),
        // .define("EVP_parse_digest_algorithm", to: "GRPC_SHADOW_EVP_parse_digest_algorithm"),
        // .define("EVP_parse_private_key", to: "GRPC_SHADOW_EVP_parse_private_key"),
        // .define("EVP_parse_public_key", to: "GRPC_SHADOW_EVP_parse_public_key"),
        // .define("EVP_PBE_scrypt", to: "GRPC_SHADOW_EVP_PBE_scrypt"),
        // .define("EVP_PKCS82PKEY", to: "GRPC_SHADOW_EVP_PKCS82PKEY"),
        // .define("EVP_PKEY2PKCS8", to: "GRPC_SHADOW_EVP_PKEY2PKCS8"),
        // .define("EVP_PKEY_assign", to: "GRPC_SHADOW_EVP_PKEY_assign"),
        // .define("EVP_PKEY_assign_DSA", to: "GRPC_SHADOW_EVP_PKEY_assign_DSA"),
        // .define("EVP_PKEY_assign_EC_KEY", to: "GRPC_SHADOW_EVP_PKEY_assign_EC_KEY"),
        // .define("EVP_PKEY_assign_RSA", to: "GRPC_SHADOW_EVP_PKEY_assign_RSA"),
        // .define("EVP_PKEY_base_id", to: "GRPC_SHADOW_EVP_PKEY_base_id"),
        // .define("EVP_PKEY_bits", to: "GRPC_SHADOW_EVP_PKEY_bits"),
        // .define("EVP_PKEY_cmp", to: "GRPC_SHADOW_EVP_PKEY_cmp"),
        // .define("EVP_PKEY_cmp_parameters", to: "GRPC_SHADOW_EVP_PKEY_cmp_parameters"),
        // .define("EVP_PKEY_copy_parameters", to: "GRPC_SHADOW_EVP_PKEY_copy_parameters"),
        // .define("EVP_PKEY_CTX_ctrl", to: "GRPC_SHADOW_EVP_PKEY_CTX_ctrl"),
        // .define("EVP_PKEY_CTX_dup", to: "GRPC_SHADOW_EVP_PKEY_CTX_dup"),
        // .define("EVP_PKEY_CTX_free", to: "GRPC_SHADOW_EVP_PKEY_CTX_free"),
        // .define("EVP_PKEY_CTX_get0_pkey", to: "GRPC_SHADOW_EVP_PKEY_CTX_get0_pkey"),
        // .define("EVP_PKEY_CTX_get0_rsa_oaep_label", to: "GRPC_SHADOW_EVP_PKEY_CTX_get0_rsa_oaep_label"),
        // .define("EVP_PKEY_CTX_get_rsa_mgf1_md", to: "GRPC_SHADOW_EVP_PKEY_CTX_get_rsa_mgf1_md"),
        // .define("EVP_PKEY_CTX_get_rsa_oaep_md", to: "GRPC_SHADOW_EVP_PKEY_CTX_get_rsa_oaep_md"),
        // .define("EVP_PKEY_CTX_get_rsa_padding", to: "GRPC_SHADOW_EVP_PKEY_CTX_get_rsa_padding"),
        // .define("EVP_PKEY_CTX_get_rsa_pss_saltlen", to: "GRPC_SHADOW_EVP_PKEY_CTX_get_rsa_pss_saltlen"),
        // .define("EVP_PKEY_CTX_get_signature_md", to: "GRPC_SHADOW_EVP_PKEY_CTX_get_signature_md"),
        // .define("EVP_PKEY_CTX_new", to: "GRPC_SHADOW_EVP_PKEY_CTX_new"),
        // .define("EVP_PKEY_CTX_new_id", to: "GRPC_SHADOW_EVP_PKEY_CTX_new_id"),
        // .define("EVP_PKEY_CTX_set0_rsa_oaep_label", to: "GRPC_SHADOW_EVP_PKEY_CTX_set0_rsa_oaep_label"),
        // .define("EVP_PKEY_CTX_set_ec_param_enc", to: "GRPC_SHADOW_EVP_PKEY_CTX_set_ec_param_enc"),
        // .define("EVP_PKEY_CTX_set_ec_paramgen_curve_nid", to: "GRPC_SHADOW_EVP_PKEY_CTX_set_ec_paramgen_curve_nid"),
        // .define("EVP_PKEY_CTX_set_rsa_keygen_bits", to: "GRPC_SHADOW_EVP_PKEY_CTX_set_rsa_keygen_bits"),
        // .define("EVP_PKEY_CTX_set_rsa_keygen_pubexp", to: "GRPC_SHADOW_EVP_PKEY_CTX_set_rsa_keygen_pubexp"),
        // .define("EVP_PKEY_CTX_set_rsa_mgf1_md", to: "GRPC_SHADOW_EVP_PKEY_CTX_set_rsa_mgf1_md"),
        // .define("EVP_PKEY_CTX_set_rsa_oaep_md", to: "GRPC_SHADOW_EVP_PKEY_CTX_set_rsa_oaep_md"),
        // .define("EVP_PKEY_CTX_set_rsa_padding", to: "GRPC_SHADOW_EVP_PKEY_CTX_set_rsa_padding"),
        // .define("EVP_PKEY_CTX_set_rsa_pss_keygen_md", to: "GRPC_SHADOW_EVP_PKEY_CTX_set_rsa_pss_keygen_md"),
        // .define("EVP_PKEY_CTX_set_rsa_pss_keygen_mgf1_md", to: "GRPC_SHADOW_EVP_PKEY_CTX_set_rsa_pss_keygen_mgf1_md"),
        // .define("EVP_PKEY_CTX_set_rsa_pss_keygen_saltlen", to: "GRPC_SHADOW_EVP_PKEY_CTX_set_rsa_pss_keygen_saltlen"),
        // .define("EVP_PKEY_CTX_set_rsa_pss_saltlen", to: "GRPC_SHADOW_EVP_PKEY_CTX_set_rsa_pss_saltlen"),
        // .define("EVP_PKEY_CTX_set_signature_md", to: "GRPC_SHADOW_EVP_PKEY_CTX_set_signature_md"),
        // .define("EVP_PKEY_decrypt", to: "GRPC_SHADOW_EVP_PKEY_decrypt"),
        // .define("EVP_PKEY_decrypt_init", to: "GRPC_SHADOW_EVP_PKEY_decrypt_init"),
        // .define("EVP_PKEY_derive", to: "GRPC_SHADOW_EVP_PKEY_derive"),
        // .define("EVP_PKEY_derive_init", to: "GRPC_SHADOW_EVP_PKEY_derive_init"),
        // .define("EVP_PKEY_derive_set_peer", to: "GRPC_SHADOW_EVP_PKEY_derive_set_peer"),
        // .define("EVP_PKEY_encrypt", to: "GRPC_SHADOW_EVP_PKEY_encrypt"),
        // .define("EVP_PKEY_encrypt_init", to: "GRPC_SHADOW_EVP_PKEY_encrypt_init"),
        // .define("EVP_PKEY_free", to: "GRPC_SHADOW_EVP_PKEY_free"),
        // .define("EVP_PKEY_get0_DH", to: "GRPC_SHADOW_EVP_PKEY_get0_DH"),
        // .define("EVP_PKEY_get0_DSA", to: "GRPC_SHADOW_EVP_PKEY_get0_DSA"),
        // .define("EVP_PKEY_get0_EC_KEY", to: "GRPC_SHADOW_EVP_PKEY_get0_EC_KEY"),
        // .define("EVP_PKEY_get0_RSA", to: "GRPC_SHADOW_EVP_PKEY_get0_RSA"),
        // .define("EVP_PKEY_get1_DH", to: "GRPC_SHADOW_EVP_PKEY_get1_DH"),
        // .define("EVP_PKEY_get1_DSA", to: "GRPC_SHADOW_EVP_PKEY_get1_DSA"),
        // .define("EVP_PKEY_get1_EC_KEY", to: "GRPC_SHADOW_EVP_PKEY_get1_EC_KEY"),
        // .define("EVP_PKEY_get1_RSA", to: "GRPC_SHADOW_EVP_PKEY_get1_RSA"),
        // .define("EVP_PKEY_get1_tls_encodedpoint", to: "GRPC_SHADOW_EVP_PKEY_get1_tls_encodedpoint"),
        // .define("EVP_PKEY_get_raw_private_key", to: "GRPC_SHADOW_EVP_PKEY_get_raw_private_key"),
        // .define("EVP_PKEY_get_raw_public_key", to: "GRPC_SHADOW_EVP_PKEY_get_raw_public_key"),
        // .define("EVP_PKEY_id", to: "GRPC_SHADOW_EVP_PKEY_id"),
        // .define("EVP_PKEY_is_opaque", to: "GRPC_SHADOW_EVP_PKEY_is_opaque"),
        // .define("EVP_PKEY_keygen", to: "GRPC_SHADOW_EVP_PKEY_keygen"),
        // .define("EVP_PKEY_keygen_init", to: "GRPC_SHADOW_EVP_PKEY_keygen_init"),
        // .define("EVP_PKEY_missing_parameters", to: "GRPC_SHADOW_EVP_PKEY_missing_parameters"),
        // .define("EVP_PKEY_new", to: "GRPC_SHADOW_EVP_PKEY_new"),
        // .define("EVP_PKEY_new_raw_private_key", to: "GRPC_SHADOW_EVP_PKEY_new_raw_private_key"),
        // .define("EVP_PKEY_new_raw_public_key", to: "GRPC_SHADOW_EVP_PKEY_new_raw_public_key"),
        // .define("EVP_PKEY_paramgen", to: "GRPC_SHADOW_EVP_PKEY_paramgen"),
        // .define("EVP_PKEY_paramgen_init", to: "GRPC_SHADOW_EVP_PKEY_paramgen_init"),
        // .define("EVP_PKEY_print_params", to: "GRPC_SHADOW_EVP_PKEY_print_params"),
        // .define("EVP_PKEY_print_private", to: "GRPC_SHADOW_EVP_PKEY_print_private"),
        // .define("EVP_PKEY_print_public", to: "GRPC_SHADOW_EVP_PKEY_print_public"),
        // .define("EVP_PKEY_set1_DSA", to: "GRPC_SHADOW_EVP_PKEY_set1_DSA"),
        // .define("EVP_PKEY_set1_EC_KEY", to: "GRPC_SHADOW_EVP_PKEY_set1_EC_KEY"),
        // .define("EVP_PKEY_set1_RSA", to: "GRPC_SHADOW_EVP_PKEY_set1_RSA"),
        // .define("EVP_PKEY_set1_tls_encodedpoint", to: "GRPC_SHADOW_EVP_PKEY_set1_tls_encodedpoint"),
        // .define("EVP_PKEY_set_type", to: "GRPC_SHADOW_EVP_PKEY_set_type"),
        // .define("EVP_PKEY_sign", to: "GRPC_SHADOW_EVP_PKEY_sign"),
        // .define("EVP_PKEY_sign_init", to: "GRPC_SHADOW_EVP_PKEY_sign_init"),
        // .define("EVP_PKEY_size", to: "GRPC_SHADOW_EVP_PKEY_size"),
        // .define("EVP_PKEY_type", to: "GRPC_SHADOW_EVP_PKEY_type"),
        // .define("EVP_PKEY_up_ref", to: "GRPC_SHADOW_EVP_PKEY_up_ref"),
        // .define("EVP_PKEY_verify", to: "GRPC_SHADOW_EVP_PKEY_verify"),
        // .define("EVP_PKEY_verify_init", to: "GRPC_SHADOW_EVP_PKEY_verify_init"),
        // .define("EVP_PKEY_verify_recover", to: "GRPC_SHADOW_EVP_PKEY_verify_recover"),
        // .define("EVP_PKEY_verify_recover_init", to: "GRPC_SHADOW_EVP_PKEY_verify_recover_init"),
        // .define("EVP_rc2_40_cbc", to: "GRPC_SHADOW_EVP_rc2_40_cbc"),
        // .define("EVP_rc2_cbc", to: "GRPC_SHADOW_EVP_rc2_cbc"),
        // .define("EVP_rc4", to: "GRPC_SHADOW_EVP_rc4"),
        // .define("EVP_sha1", to: "GRPC_SHADOW_EVP_sha1"),
        // .define("EVP_sha224", to: "GRPC_SHADOW_EVP_sha224"),
        // .define("EVP_sha256", to: "GRPC_SHADOW_EVP_sha256"),
        // .define("EVP_sha384", to: "GRPC_SHADOW_EVP_sha384"),
        // .define("EVP_sha512", to: "GRPC_SHADOW_EVP_sha512"),
        // .define("EVP_SignFinal", to: "GRPC_SHADOW_EVP_SignFinal"),
        // .define("EVP_SignInit", to: "GRPC_SHADOW_EVP_SignInit"),
        // .define("EVP_SignInit_ex", to: "GRPC_SHADOW_EVP_SignInit_ex"),
        // .define("EVP_SignUpdate", to: "GRPC_SHADOW_EVP_SignUpdate"),
        // .define("EVP_tls_cbc_copy_mac", to: "GRPC_SHADOW_EVP_tls_cbc_copy_mac"),
        // .define("EVP_tls_cbc_digest_record", to: "GRPC_SHADOW_EVP_tls_cbc_digest_record"),
        // .define("EVP_tls_cbc_record_digest_supported", to: "GRPC_SHADOW_EVP_tls_cbc_record_digest_supported"),
        // .define("EVP_tls_cbc_remove_padding", to: "GRPC_SHADOW_EVP_tls_cbc_remove_padding"),
        // .define("EVP_VerifyFinal", to: "GRPC_SHADOW_EVP_VerifyFinal"),
        // .define("EVP_VerifyInit", to: "GRPC_SHADOW_EVP_VerifyInit"),
        // .define("EVP_VerifyInit_ex", to: "GRPC_SHADOW_EVP_VerifyInit_ex"),
        // .define("EVP_VerifyUpdate", to: "GRPC_SHADOW_EVP_VerifyUpdate"),
        // .define("EXTENDED_KEY_USAGE_free", to: "GRPC_SHADOW_EXTENDED_KEY_USAGE_free"),
        // .define("EXTENDED_KEY_USAGE_it", to: "GRPC_SHADOW_EXTENDED_KEY_USAGE_it"),
        // .define("EXTENDED_KEY_USAGE_new", to: "GRPC_SHADOW_EXTENDED_KEY_USAGE_new"),
        // .define("FIPS_mode", to: "GRPC_SHADOW_FIPS_mode"),
        // .define("FIPS_mode_set", to: "GRPC_SHADOW_FIPS_mode_set"),
        // .define("gcm_ghash_avx", to: "GRPC_SHADOW_gcm_ghash_avx"),
        // .define("gcm_ghash_clmul", to: "GRPC_SHADOW_gcm_ghash_clmul"),
        // .define("gcm_ghash_nohw", to: "GRPC_SHADOW_gcm_ghash_nohw"),
        // .define("gcm_ghash_ssse3", to: "GRPC_SHADOW_gcm_ghash_ssse3"),
        // .define("gcm_gmult_avx", to: "GRPC_SHADOW_gcm_gmult_avx"),
        // .define("gcm_gmult_clmul", to: "GRPC_SHADOW_gcm_gmult_clmul"),
        // .define("gcm_gmult_nohw", to: "GRPC_SHADOW_gcm_gmult_nohw"),
        // .define("gcm_gmult_ssse3", to: "GRPC_SHADOW_gcm_gmult_ssse3"),
        // .define("gcm_init_avx", to: "GRPC_SHADOW_gcm_init_avx"),
        // .define("gcm_init_clmul", to: "GRPC_SHADOW_gcm_init_clmul"),
        // .define("gcm_init_nohw", to: "GRPC_SHADOW_gcm_init_nohw"),
        // .define("gcm_init_ssse3", to: "GRPC_SHADOW_gcm_init_ssse3"),
        // .define("GENERAL_NAME_cmp", to: "GRPC_SHADOW_GENERAL_NAME_cmp"),
        // .define("GENERAL_NAME_dup", to: "GRPC_SHADOW_GENERAL_NAME_dup"),
        // .define("GENERAL_NAME_free", to: "GRPC_SHADOW_GENERAL_NAME_free"),
        // .define("GENERAL_NAME_get0_otherName", to: "GRPC_SHADOW_GENERAL_NAME_get0_otherName"),
        // .define("GENERAL_NAME_get0_value", to: "GRPC_SHADOW_GENERAL_NAME_get0_value"),
        // .define("GENERAL_NAME_it", to: "GRPC_SHADOW_GENERAL_NAME_it"),
        // .define("GENERAL_NAME_new", to: "GRPC_SHADOW_GENERAL_NAME_new"),
        // .define("GENERAL_NAME_print", to: "GRPC_SHADOW_GENERAL_NAME_print"),
        // .define("GENERAL_NAME_set0_othername", to: "GRPC_SHADOW_GENERAL_NAME_set0_othername"),
        // .define("GENERAL_NAME_set0_value", to: "GRPC_SHADOW_GENERAL_NAME_set0_value"),
        // .define("GENERAL_NAMES_free", to: "GRPC_SHADOW_GENERAL_NAMES_free"),
        // .define("GENERAL_NAMES_it", to: "GRPC_SHADOW_GENERAL_NAMES_it"),
        // .define("GENERAL_NAMES_new", to: "GRPC_SHADOW_GENERAL_NAMES_new"),
        // .define("GENERAL_SUBTREE_free", to: "GRPC_SHADOW_GENERAL_SUBTREE_free"),
        // .define("GENERAL_SUBTREE_it", to: "GRPC_SHADOW_GENERAL_SUBTREE_it"),
        // .define("GENERAL_SUBTREE_new", to: "GRPC_SHADOW_GENERAL_SUBTREE_new"),
        // .define("HKDF", to: "GRPC_SHADOW_HKDF"),
        // .define("HKDF_expand", to: "GRPC_SHADOW_HKDF_expand"),
        // .define("HKDF_extract", to: "GRPC_SHADOW_HKDF_extract"),
        // .define("HMAC", to: "GRPC_SHADOW_HMAC"),
        // .define("HMAC_CTX_cleanup", to: "GRPC_SHADOW_HMAC_CTX_cleanup"),
        // .define("HMAC_CTX_copy", to: "GRPC_SHADOW_HMAC_CTX_copy"),
        // .define("HMAC_CTX_copy_ex", to: "GRPC_SHADOW_HMAC_CTX_copy_ex"),
        // .define("HMAC_CTX_free", to: "GRPC_SHADOW_HMAC_CTX_free"),
        // .define("HMAC_CTX_init", to: "GRPC_SHADOW_HMAC_CTX_init"),
        // .define("HMAC_CTX_new", to: "GRPC_SHADOW_HMAC_CTX_new"),
        // .define("HMAC_CTX_reset", to: "GRPC_SHADOW_HMAC_CTX_reset"),
        // .define("HMAC_Final", to: "GRPC_SHADOW_HMAC_Final"),
        // .define("HMAC_Init", to: "GRPC_SHADOW_HMAC_Init"),
        // .define("HMAC_Init_ex", to: "GRPC_SHADOW_HMAC_Init_ex"),
        // .define("HMAC_size", to: "GRPC_SHADOW_HMAC_size"),
        // .define("HMAC_Update", to: "GRPC_SHADOW_HMAC_Update"),
        // .define("HRSS_decap", to: "GRPC_SHADOW_HRSS_decap"),
        // .define("HRSS_encap", to: "GRPC_SHADOW_HRSS_encap"),
        // .define("HRSS_generate_key", to: "GRPC_SHADOW_HRSS_generate_key"),
        // .define("HRSS_marshal_public_key", to: "GRPC_SHADOW_HRSS_marshal_public_key"),
        // .define("HRSS_parse_public_key", to: "GRPC_SHADOW_HRSS_parse_public_key"),
        // .define("HRSS_poly3_invert", to: "GRPC_SHADOW_HRSS_poly3_invert"),
        // .define("HRSS_poly3_mul", to: "GRPC_SHADOW_HRSS_poly3_mul"),
        // .define("i2a_ACCESS_DESCRIPTION", to: "GRPC_SHADOW_i2a_ACCESS_DESCRIPTION"),
        // .define("i2a_ASN1_ENUMERATED", to: "GRPC_SHADOW_i2a_ASN1_ENUMERATED"),
        // .define("i2a_ASN1_INTEGER", to: "GRPC_SHADOW_i2a_ASN1_INTEGER"),
        // .define("i2a_ASN1_OBJECT", to: "GRPC_SHADOW_i2a_ASN1_OBJECT"),
        // .define("i2a_ASN1_STRING", to: "GRPC_SHADOW_i2a_ASN1_STRING"),
        // .define("i2c_ASN1_BIT_STRING", to: "GRPC_SHADOW_i2c_ASN1_BIT_STRING"),
        // .define("i2c_ASN1_INTEGER", to: "GRPC_SHADOW_i2c_ASN1_INTEGER"),
        // .define("i2d_ACCESS_DESCRIPTION", to: "GRPC_SHADOW_i2d_ACCESS_DESCRIPTION"),
        // .define("i2d_ASN1_BIT_STRING", to: "GRPC_SHADOW_i2d_ASN1_BIT_STRING"),
        // .define("i2d_ASN1_BMPSTRING", to: "GRPC_SHADOW_i2d_ASN1_BMPSTRING"),
        // .define("i2d_ASN1_BOOLEAN", to: "GRPC_SHADOW_i2d_ASN1_BOOLEAN"),
        // .define("i2d_ASN1_ENUMERATED", to: "GRPC_SHADOW_i2d_ASN1_ENUMERATED"),
        // .define("i2d_ASN1_GENERALIZEDTIME", to: "GRPC_SHADOW_i2d_ASN1_GENERALIZEDTIME"),
        // .define("i2d_ASN1_GENERALSTRING", to: "GRPC_SHADOW_i2d_ASN1_GENERALSTRING"),
        // .define("i2d_ASN1_IA5STRING", to: "GRPC_SHADOW_i2d_ASN1_IA5STRING"),
        // .define("i2d_ASN1_INTEGER", to: "GRPC_SHADOW_i2d_ASN1_INTEGER"),
        // .define("i2d_ASN1_NULL", to: "GRPC_SHADOW_i2d_ASN1_NULL"),
        // .define("i2d_ASN1_OBJECT", to: "GRPC_SHADOW_i2d_ASN1_OBJECT"),
        // .define("i2d_ASN1_OCTET_STRING", to: "GRPC_SHADOW_i2d_ASN1_OCTET_STRING"),
        // .define("i2d_ASN1_PRINTABLE", to: "GRPC_SHADOW_i2d_ASN1_PRINTABLE"),
        // .define("i2d_ASN1_PRINTABLESTRING", to: "GRPC_SHADOW_i2d_ASN1_PRINTABLESTRING"),
        // .define("i2d_ASN1_SEQUENCE_ANY", to: "GRPC_SHADOW_i2d_ASN1_SEQUENCE_ANY"),
        // .define("i2d_ASN1_SET_ANY", to: "GRPC_SHADOW_i2d_ASN1_SET_ANY"),
        // .define("i2d_ASN1_T61STRING", to: "GRPC_SHADOW_i2d_ASN1_T61STRING"),
        // .define("i2d_ASN1_TIME", to: "GRPC_SHADOW_i2d_ASN1_TIME"),
        // .define("i2d_ASN1_TYPE", to: "GRPC_SHADOW_i2d_ASN1_TYPE"),
        // .define("i2d_ASN1_UNIVERSALSTRING", to: "GRPC_SHADOW_i2d_ASN1_UNIVERSALSTRING"),
        // .define("i2d_ASN1_UTCTIME", to: "GRPC_SHADOW_i2d_ASN1_UTCTIME"),
        // .define("i2d_ASN1_UTF8STRING", to: "GRPC_SHADOW_i2d_ASN1_UTF8STRING"),
        // .define("i2d_ASN1_VISIBLESTRING", to: "GRPC_SHADOW_i2d_ASN1_VISIBLESTRING"),
        // .define("i2d_AUTHORITY_INFO_ACCESS", to: "GRPC_SHADOW_i2d_AUTHORITY_INFO_ACCESS"),
        // .define("i2d_AUTHORITY_KEYID", to: "GRPC_SHADOW_i2d_AUTHORITY_KEYID"),
        // .define("i2d_BASIC_CONSTRAINTS", to: "GRPC_SHADOW_i2d_BASIC_CONSTRAINTS"),
        // .define("i2d_CERTIFICATEPOLICIES", to: "GRPC_SHADOW_i2d_CERTIFICATEPOLICIES"),
        // .define("i2d_CRL_DIST_POINTS", to: "GRPC_SHADOW_i2d_CRL_DIST_POINTS"),
        // .define("i2d_DHparams", to: "GRPC_SHADOW_i2d_DHparams"),
        // .define("i2d_DHparams_bio", to: "GRPC_SHADOW_i2d_DHparams_bio"),
        // .define("i2d_DIRECTORYSTRING", to: "GRPC_SHADOW_i2d_DIRECTORYSTRING"),
        // .define("i2d_DISPLAYTEXT", to: "GRPC_SHADOW_i2d_DISPLAYTEXT"),
        // .define("i2d_DIST_POINT", to: "GRPC_SHADOW_i2d_DIST_POINT"),
        // .define("i2d_DIST_POINT_NAME", to: "GRPC_SHADOW_i2d_DIST_POINT_NAME"),
        // .define("i2d_DSAparams", to: "GRPC_SHADOW_i2d_DSAparams"),
        // .define("i2d_DSAPrivateKey", to: "GRPC_SHADOW_i2d_DSAPrivateKey"),
        // .define("i2d_DSAPrivateKey_bio", to: "GRPC_SHADOW_i2d_DSAPrivateKey_bio"),
        // .define("i2d_DSAPrivateKey_fp", to: "GRPC_SHADOW_i2d_DSAPrivateKey_fp"),
        // .define("i2d_DSA_PUBKEY", to: "GRPC_SHADOW_i2d_DSA_PUBKEY"),
        // .define("i2d_DSA_PUBKEY_bio", to: "GRPC_SHADOW_i2d_DSA_PUBKEY_bio"),
        // .define("i2d_DSA_PUBKEY_fp", to: "GRPC_SHADOW_i2d_DSA_PUBKEY_fp"),
        // .define("i2d_DSAPublicKey", to: "GRPC_SHADOW_i2d_DSAPublicKey"),
        // .define("i2d_DSA_SIG", to: "GRPC_SHADOW_i2d_DSA_SIG"),
        // .define("i2d_ECDSA_SIG", to: "GRPC_SHADOW_i2d_ECDSA_SIG"),
        // .define("i2d_ECParameters", to: "GRPC_SHADOW_i2d_ECParameters"),
        // .define("i2d_ECPrivateKey", to: "GRPC_SHADOW_i2d_ECPrivateKey"),
        // .define("i2d_ECPrivateKey_bio", to: "GRPC_SHADOW_i2d_ECPrivateKey_bio"),
        // .define("i2d_ECPrivateKey_fp", to: "GRPC_SHADOW_i2d_ECPrivateKey_fp"),
        // .define("i2d_EC_PUBKEY", to: "GRPC_SHADOW_i2d_EC_PUBKEY"),
        // .define("i2d_EC_PUBKEY_bio", to: "GRPC_SHADOW_i2d_EC_PUBKEY_bio"),
        // .define("i2d_EC_PUBKEY_fp", to: "GRPC_SHADOW_i2d_EC_PUBKEY_fp"),
        // .define("i2d_EDIPARTYNAME", to: "GRPC_SHADOW_i2d_EDIPARTYNAME"),
        // .define("i2d_EXTENDED_KEY_USAGE", to: "GRPC_SHADOW_i2d_EXTENDED_KEY_USAGE"),
        // .define("i2d_GENERAL_NAME", to: "GRPC_SHADOW_i2d_GENERAL_NAME"),
        // .define("i2d_GENERAL_NAMES", to: "GRPC_SHADOW_i2d_GENERAL_NAMES"),
        // .define("i2d_ISSUING_DIST_POINT", to: "GRPC_SHADOW_i2d_ISSUING_DIST_POINT"),
        // .define("i2d_NETSCAPE_SPKAC", to: "GRPC_SHADOW_i2d_NETSCAPE_SPKAC"),
        // .define("i2d_NETSCAPE_SPKI", to: "GRPC_SHADOW_i2d_NETSCAPE_SPKI"),
        // .define("i2d_NOTICEREF", to: "GRPC_SHADOW_i2d_NOTICEREF"),
        // .define("i2d_OTHERNAME", to: "GRPC_SHADOW_i2d_OTHERNAME"),
        // .define("i2d_PKCS12", to: "GRPC_SHADOW_i2d_PKCS12"),
        // .define("i2d_PKCS12_bio", to: "GRPC_SHADOW_i2d_PKCS12_bio"),
        // .define("i2d_PKCS12_fp", to: "GRPC_SHADOW_i2d_PKCS12_fp"),
        // .define("i2d_PKCS7", to: "GRPC_SHADOW_i2d_PKCS7"),
        // .define("i2d_PKCS7_bio", to: "GRPC_SHADOW_i2d_PKCS7_bio"),
        // .define("i2d_PKCS8_bio", to: "GRPC_SHADOW_i2d_PKCS8_bio"),
        // .define("i2d_PKCS8_fp", to: "GRPC_SHADOW_i2d_PKCS8_fp"),
        // .define("i2d_PKCS8PrivateKey_bio", to: "GRPC_SHADOW_i2d_PKCS8PrivateKey_bio"),
        // .define("i2d_PKCS8PrivateKey_fp", to: "GRPC_SHADOW_i2d_PKCS8PrivateKey_fp"),
        // .define("i2d_PKCS8PrivateKeyInfo_bio", to: "GRPC_SHADOW_i2d_PKCS8PrivateKeyInfo_bio"),
        // .define("i2d_PKCS8PrivateKeyInfo_fp", to: "GRPC_SHADOW_i2d_PKCS8PrivateKeyInfo_fp"),
        // .define("i2d_PKCS8PrivateKey_nid_bio", to: "GRPC_SHADOW_i2d_PKCS8PrivateKey_nid_bio"),
        // .define("i2d_PKCS8PrivateKey_nid_fp", to: "GRPC_SHADOW_i2d_PKCS8PrivateKey_nid_fp"),
        // .define("i2d_PKCS8_PRIV_KEY_INFO", to: "GRPC_SHADOW_i2d_PKCS8_PRIV_KEY_INFO"),
        // .define("i2d_PKCS8_PRIV_KEY_INFO_bio", to: "GRPC_SHADOW_i2d_PKCS8_PRIV_KEY_INFO_bio"),
        // .define("i2d_PKCS8_PRIV_KEY_INFO_fp", to: "GRPC_SHADOW_i2d_PKCS8_PRIV_KEY_INFO_fp"),
        // .define("i2d_PKEY_USAGE_PERIOD", to: "GRPC_SHADOW_i2d_PKEY_USAGE_PERIOD"),
        // .define("i2d_POLICYINFO", to: "GRPC_SHADOW_i2d_POLICYINFO"),
        // .define("i2d_POLICYQUALINFO", to: "GRPC_SHADOW_i2d_POLICYQUALINFO"),
        // .define("i2d_PrivateKey", to: "GRPC_SHADOW_i2d_PrivateKey"),
        // .define("i2d_PrivateKey_bio", to: "GRPC_SHADOW_i2d_PrivateKey_bio"),
        // .define("i2d_PrivateKey_fp", to: "GRPC_SHADOW_i2d_PrivateKey_fp"),
        // .define("i2d_PROXY_CERT_INFO_EXTENSION", to: "GRPC_SHADOW_i2d_PROXY_CERT_INFO_EXTENSION"),
        // .define("i2d_PROXY_POLICY", to: "GRPC_SHADOW_i2d_PROXY_POLICY"),
        // .define("i2d_PUBKEY", to: "GRPC_SHADOW_i2d_PUBKEY"),
        // .define("i2d_PUBKEY_bio", to: "GRPC_SHADOW_i2d_PUBKEY_bio"),
        // .define("i2d_PUBKEY_fp", to: "GRPC_SHADOW_i2d_PUBKEY_fp"),
        // .define("i2d_PublicKey", to: "GRPC_SHADOW_i2d_PublicKey"),
        // .define("i2d_re_X509_CRL_tbs", to: "GRPC_SHADOW_i2d_re_X509_CRL_tbs"),
        // .define("i2d_re_X509_REQ_tbs", to: "GRPC_SHADOW_i2d_re_X509_REQ_tbs"),
        // .define("i2d_re_X509_tbs", to: "GRPC_SHADOW_i2d_re_X509_tbs"),
        // .define("i2d_RSAPrivateKey", to: "GRPC_SHADOW_i2d_RSAPrivateKey"),
        // .define("i2d_RSAPrivateKey_bio", to: "GRPC_SHADOW_i2d_RSAPrivateKey_bio"),
        // .define("i2d_RSAPrivateKey_fp", to: "GRPC_SHADOW_i2d_RSAPrivateKey_fp"),
        // .define("i2d_RSA_PSS_PARAMS", to: "GRPC_SHADOW_i2d_RSA_PSS_PARAMS"),
        // .define("i2d_RSA_PUBKEY", to: "GRPC_SHADOW_i2d_RSA_PUBKEY"),
        // .define("i2d_RSA_PUBKEY_bio", to: "GRPC_SHADOW_i2d_RSA_PUBKEY_bio"),
        // .define("i2d_RSA_PUBKEY_fp", to: "GRPC_SHADOW_i2d_RSA_PUBKEY_fp"),
        // .define("i2d_RSAPublicKey", to: "GRPC_SHADOW_i2d_RSAPublicKey"),
        // .define("i2d_RSAPublicKey_bio", to: "GRPC_SHADOW_i2d_RSAPublicKey_bio"),
        // .define("i2d_RSAPublicKey_fp", to: "GRPC_SHADOW_i2d_RSAPublicKey_fp"),
        // .define("i2d_SSL_SESSION", to: "GRPC_SHADOW_i2d_SSL_SESSION"),
        // .define("i2d_SSL_SESSION_bio", to: "GRPC_SHADOW_i2d_SSL_SESSION_bio"),
        // .define("i2d_SXNET", to: "GRPC_SHADOW_i2d_SXNET"),
        // .define("i2d_SXNETID", to: "GRPC_SHADOW_i2d_SXNETID"),
        // .define("i2d_USERNOTICE", to: "GRPC_SHADOW_i2d_USERNOTICE"),
        // .define("i2d_X509", to: "GRPC_SHADOW_i2d_X509"),
        // .define("i2d_X509_ALGOR", to: "GRPC_SHADOW_i2d_X509_ALGOR"),
        // .define("i2d_X509_ALGORS", to: "GRPC_SHADOW_i2d_X509_ALGORS"),
        // .define("i2d_X509_ATTRIBUTE", to: "GRPC_SHADOW_i2d_X509_ATTRIBUTE"),
        // .define("i2d_X509_AUX", to: "GRPC_SHADOW_i2d_X509_AUX"),
        // .define("i2d_X509_bio", to: "GRPC_SHADOW_i2d_X509_bio"),
        // .define("i2d_X509_CERT_AUX", to: "GRPC_SHADOW_i2d_X509_CERT_AUX"),
        // .define("i2d_X509_CINF", to: "GRPC_SHADOW_i2d_X509_CINF"),
        // .define("i2d_X509_CRL", to: "GRPC_SHADOW_i2d_X509_CRL"),
        // .define("i2d_X509_CRL_bio", to: "GRPC_SHADOW_i2d_X509_CRL_bio"),
        // .define("i2d_X509_CRL_fp", to: "GRPC_SHADOW_i2d_X509_CRL_fp"),
        // .define("i2d_X509_CRL_INFO", to: "GRPC_SHADOW_i2d_X509_CRL_INFO"),
        // .define("i2d_X509_EXTENSION", to: "GRPC_SHADOW_i2d_X509_EXTENSION"),
        // .define("i2d_X509_EXTENSIONS", to: "GRPC_SHADOW_i2d_X509_EXTENSIONS"),
        // .define("i2d_X509_fp", to: "GRPC_SHADOW_i2d_X509_fp"),
        // .define("i2d_X509_NAME", to: "GRPC_SHADOW_i2d_X509_NAME"),
        // .define("i2d_X509_NAME_ENTRY", to: "GRPC_SHADOW_i2d_X509_NAME_ENTRY"),
        // .define("i2d_X509_PUBKEY", to: "GRPC_SHADOW_i2d_X509_PUBKEY"),
        // .define("i2d_X509_REQ", to: "GRPC_SHADOW_i2d_X509_REQ"),
        // .define("i2d_X509_REQ_bio", to: "GRPC_SHADOW_i2d_X509_REQ_bio"),
        // .define("i2d_X509_REQ_fp", to: "GRPC_SHADOW_i2d_X509_REQ_fp"),
        // .define("i2d_X509_REQ_INFO", to: "GRPC_SHADOW_i2d_X509_REQ_INFO"),
        // .define("i2d_X509_REVOKED", to: "GRPC_SHADOW_i2d_X509_REVOKED"),
        // .define("i2d_X509_SIG", to: "GRPC_SHADOW_i2d_X509_SIG"),
        // .define("i2d_X509_VAL", to: "GRPC_SHADOW_i2d_X509_VAL"),
        // .define("i2o_ECPublicKey", to: "GRPC_SHADOW_i2o_ECPublicKey"),
        // .define("i2s_ASN1_ENUMERATED", to: "GRPC_SHADOW_i2s_ASN1_ENUMERATED"),
        // .define("i2s_ASN1_ENUMERATED_TABLE", to: "GRPC_SHADOW_i2s_ASN1_ENUMERATED_TABLE"),
        // .define("i2s_ASN1_INTEGER", to: "GRPC_SHADOW_i2s_ASN1_INTEGER"),
        // .define("i2s_ASN1_OCTET_STRING", to: "GRPC_SHADOW_i2s_ASN1_OCTET_STRING"),
        // .define("i2t_ASN1_OBJECT", to: "GRPC_SHADOW_i2t_ASN1_OBJECT"),
        // .define("i2v_ASN1_BIT_STRING", to: "GRPC_SHADOW_i2v_ASN1_BIT_STRING"),
        // .define("i2v_GENERAL_NAME", to: "GRPC_SHADOW_i2v_GENERAL_NAME"),
        // .define("i2v_GENERAL_NAMES", to: "GRPC_SHADOW_i2v_GENERAL_NAMES"),
        // .define("ISSUING_DIST_POINT_free", to: "GRPC_SHADOW_ISSUING_DIST_POINT_free"),
        // .define("ISSUING_DIST_POINT_it", to: "GRPC_SHADOW_ISSUING_DIST_POINT_it"),
        // .define("ISSUING_DIST_POINT_new", to: "GRPC_SHADOW_ISSUING_DIST_POINT_new"),
        // .define("kBoringSSLRSASqrtTwo", to: "GRPC_SHADOW_kBoringSSLRSASqrtTwo"),
        // .define("kBoringSSLRSASqrtTwoLen", to: "GRPC_SHADOW_kBoringSSLRSASqrtTwoLen"),
        // .define("kOpenSSLReasonStringData", to: "GRPC_SHADOW_kOpenSSLReasonStringData"),
        // .define("kOpenSSLReasonValues", to: "GRPC_SHADOW_kOpenSSLReasonValues"),
        // .define("kOpenSSLReasonValuesLen", to: "GRPC_SHADOW_kOpenSSLReasonValuesLen"),
        // .define("level_add_node", to: "GRPC_SHADOW_level_add_node"),
        // .define("level_find_node", to: "GRPC_SHADOW_level_find_node"),
        // .define("lh_delete", to: "GRPC_SHADOW_lh_delete"),
        // .define("lh_doall_arg", to: "GRPC_SHADOW_lh_doall_arg"),
        // .define("lh_free", to: "GRPC_SHADOW_lh_free"),
        // .define("lh_insert", to: "GRPC_SHADOW_lh_insert"),
        // .define("lh_new", to: "GRPC_SHADOW_lh_new"),
        // .define("lh_num_items", to: "GRPC_SHADOW_lh_num_items"),
        // .define("lh_retrieve", to: "GRPC_SHADOW_lh_retrieve"),
        // .define("lh_retrieve_key", to: "GRPC_SHADOW_lh_retrieve_key"),
        // .define("lh_strhash", to: "GRPC_SHADOW_lh_strhash"),
        // .define("MD4", to: "GRPC_SHADOW_MD4"),
        // .define("md4_block_data_order", to: "GRPC_SHADOW_md4_block_data_order"),
        // .define("MD4_Final", to: "GRPC_SHADOW_MD4_Final"),
        // .define("MD4_Init", to: "GRPC_SHADOW_MD4_Init"),
        // .define("MD4_Transform", to: "GRPC_SHADOW_MD4_Transform"),
        // .define("MD4_Update", to: "GRPC_SHADOW_MD4_Update"),
        // .define("MD5", to: "GRPC_SHADOW_MD5"),
        // .define("md5_block_asm_data_order", to: "GRPC_SHADOW_md5_block_asm_data_order"),
        // .define("MD5_Final", to: "GRPC_SHADOW_MD5_Final"),
        // .define("MD5_Init", to: "GRPC_SHADOW_MD5_Init"),
        // .define("MD5_Transform", to: "GRPC_SHADOW_MD5_Transform"),
        // .define("MD5_Update", to: "GRPC_SHADOW_MD5_Update"),
        // .define("METHOD_ref", to: "GRPC_SHADOW_METHOD_ref"),
        // .define("METHOD_unref", to: "GRPC_SHADOW_METHOD_unref"),
        // .define("NAME_CONSTRAINTS_check", to: "GRPC_SHADOW_NAME_CONSTRAINTS_check"),
        // .define("NAME_CONSTRAINTS_free", to: "GRPC_SHADOW_NAME_CONSTRAINTS_free"),
        // .define("NAME_CONSTRAINTS_it", to: "GRPC_SHADOW_NAME_CONSTRAINTS_it"),
        // .define("NAME_CONSTRAINTS_new", to: "GRPC_SHADOW_NAME_CONSTRAINTS_new"),
        // .define("NCONF_free", to: "GRPC_SHADOW_NCONF_free"),
        // .define("NCONF_get_section", to: "GRPC_SHADOW_NCONF_get_section"),
        // .define("NCONF_get_string", to: "GRPC_SHADOW_NCONF_get_string"),
        // .define("NCONF_load", to: "GRPC_SHADOW_NCONF_load"),
        // .define("NCONF_load_bio", to: "GRPC_SHADOW_NCONF_load_bio"),
        // .define("NCONF_new", to: "GRPC_SHADOW_NCONF_new"),
        // .define("NETSCAPE_SPKAC_free", to: "GRPC_SHADOW_NETSCAPE_SPKAC_free"),
        // .define("NETSCAPE_SPKAC_it", to: "GRPC_SHADOW_NETSCAPE_SPKAC_it"),
        // .define("NETSCAPE_SPKAC_new", to: "GRPC_SHADOW_NETSCAPE_SPKAC_new"),
        // .define("NETSCAPE_SPKI_b64_decode", to: "GRPC_SHADOW_NETSCAPE_SPKI_b64_decode"),
        // .define("NETSCAPE_SPKI_b64_encode", to: "GRPC_SHADOW_NETSCAPE_SPKI_b64_encode"),
        // .define("NETSCAPE_SPKI_free", to: "GRPC_SHADOW_NETSCAPE_SPKI_free"),
        // .define("NETSCAPE_SPKI_get_pubkey", to: "GRPC_SHADOW_NETSCAPE_SPKI_get_pubkey"),
        // .define("NETSCAPE_SPKI_it", to: "GRPC_SHADOW_NETSCAPE_SPKI_it"),
        // .define("NETSCAPE_SPKI_new", to: "GRPC_SHADOW_NETSCAPE_SPKI_new"),
        // .define("NETSCAPE_SPKI_set_pubkey", to: "GRPC_SHADOW_NETSCAPE_SPKI_set_pubkey"),
        // .define("NETSCAPE_SPKI_sign", to: "GRPC_SHADOW_NETSCAPE_SPKI_sign"),
        // .define("NETSCAPE_SPKI_verify", to: "GRPC_SHADOW_NETSCAPE_SPKI_verify"),
        // .define("NOTICEREF_free", to: "GRPC_SHADOW_NOTICEREF_free"),
        // .define("NOTICEREF_it", to: "GRPC_SHADOW_NOTICEREF_it"),
        // .define("NOTICEREF_new", to: "GRPC_SHADOW_NOTICEREF_new"),
        // .define("o2i_ECPublicKey", to: "GRPC_SHADOW_o2i_ECPublicKey"),
        // .define("OBJ_cbs2nid", to: "GRPC_SHADOW_OBJ_cbs2nid"),
        // .define("OBJ_cleanup", to: "GRPC_SHADOW_OBJ_cleanup"),
        // .define("OBJ_cmp", to: "GRPC_SHADOW_OBJ_cmp"),
        // .define("OBJ_create", to: "GRPC_SHADOW_OBJ_create"),
        // .define("OBJ_dup", to: "GRPC_SHADOW_OBJ_dup"),
        // .define("OBJ_find_sigid_algs", to: "GRPC_SHADOW_OBJ_find_sigid_algs"),
        // .define("OBJ_find_sigid_by_algs", to: "GRPC_SHADOW_OBJ_find_sigid_by_algs"),
        // .define("OBJ_get0_data", to: "GRPC_SHADOW_OBJ_get0_data"),
        // .define("OBJ_length", to: "GRPC_SHADOW_OBJ_length"),
        // .define("OBJ_ln2nid", to: "GRPC_SHADOW_OBJ_ln2nid"),
        // .define("OBJ_nid2cbb", to: "GRPC_SHADOW_OBJ_nid2cbb"),
        // .define("OBJ_nid2ln", to: "GRPC_SHADOW_OBJ_nid2ln"),
        // .define("OBJ_nid2obj", to: "GRPC_SHADOW_OBJ_nid2obj"),
        // .define("OBJ_nid2sn", to: "GRPC_SHADOW_OBJ_nid2sn"),
        // .define("OBJ_obj2nid", to: "GRPC_SHADOW_OBJ_obj2nid"),
        // .define("OBJ_obj2txt", to: "GRPC_SHADOW_OBJ_obj2txt"),
        // .define("OBJ_sn2nid", to: "GRPC_SHADOW_OBJ_sn2nid"),
        // .define("OBJ_txt2nid", to: "GRPC_SHADOW_OBJ_txt2nid"),
        // .define("OBJ_txt2obj", to: "GRPC_SHADOW_OBJ_txt2obj"),
        // .define("OpenSSL_add_all_algorithms", to: "GRPC_SHADOW_OpenSSL_add_all_algorithms"),
        // .define("OPENSSL_add_all_algorithms_conf", to: "GRPC_SHADOW_OPENSSL_add_all_algorithms_conf"),
        // .define("OpenSSL_add_all_ciphers", to: "GRPC_SHADOW_OpenSSL_add_all_ciphers"),
        // .define("OpenSSL_add_all_digests", to: "GRPC_SHADOW_OpenSSL_add_all_digests"),
        // .define("OPENSSL_built_in_curves", to: "GRPC_SHADOW_OPENSSL_built_in_curves"),
        // .define("OPENSSL_cleanse", to: "GRPC_SHADOW_OPENSSL_cleanse"),
        // .define("OPENSSL_cleanup", to: "GRPC_SHADOW_OPENSSL_cleanup"),
        // .define("OPENSSL_clear_free", to: "GRPC_SHADOW_OPENSSL_clear_free"),
        // .define("OPENSSL_config", to: "GRPC_SHADOW_OPENSSL_config"),
        // .define("OPENSSL_cpuid_setup", to: "GRPC_SHADOW_OPENSSL_cpuid_setup"),
        // .define("OPENSSL_free", to: "GRPC_SHADOW_OPENSSL_free"),
        // .define("OPENSSL_gmtime", to: "GRPC_SHADOW_OPENSSL_gmtime"),
        // .define("OPENSSL_gmtime_adj", to: "GRPC_SHADOW_OPENSSL_gmtime_adj"),
        // .define("OPENSSL_gmtime_diff", to: "GRPC_SHADOW_OPENSSL_gmtime_diff"),
        // .define("OPENSSL_hash32", to: "GRPC_SHADOW_OPENSSL_hash32"),
        // .define("OPENSSL_ia32cap_P", to: "GRPC_SHADOW_OPENSSL_ia32cap_P"),
        // .define("OPENSSL_init_crypto", to: "GRPC_SHADOW_OPENSSL_init_crypto"),
        // .define("OPENSSL_init_ssl", to: "GRPC_SHADOW_OPENSSL_init_ssl"),
        // .define("OPENSSL_load_builtin_modules", to: "GRPC_SHADOW_OPENSSL_load_builtin_modules"),
        // .define("OPENSSL_malloc", to: "GRPC_SHADOW_OPENSSL_malloc"),
        // .define("OPENSSL_malloc_init", to: "GRPC_SHADOW_OPENSSL_malloc_init"),
        // .define("OPENSSL_memdup", to: "GRPC_SHADOW_OPENSSL_memdup"),
        // .define("OPENSSL_no_config", to: "GRPC_SHADOW_OPENSSL_no_config"),
        // .define("OPENSSL_realloc", to: "GRPC_SHADOW_OPENSSL_realloc"),
        // .define("OPENSSL_strcasecmp", to: "GRPC_SHADOW_OPENSSL_strcasecmp"),
        // .define("OPENSSL_strdup", to: "GRPC_SHADOW_OPENSSL_strdup"),
        // .define("OPENSSL_strlcat", to: "GRPC_SHADOW_OPENSSL_strlcat"),
        // .define("OPENSSL_strlcpy", to: "GRPC_SHADOW_OPENSSL_strlcpy"),
        // .define("OPENSSL_strncasecmp", to: "GRPC_SHADOW_OPENSSL_strncasecmp"),
        // .define("OPENSSL_strndup", to: "GRPC_SHADOW_OPENSSL_strndup"),
        // .define("OPENSSL_strnlen", to: "GRPC_SHADOW_OPENSSL_strnlen"),
        // .define("OPENSSL_tolower", to: "GRPC_SHADOW_OPENSSL_tolower"),
        // .define("OpenSSL_version", to: "GRPC_SHADOW_OpenSSL_version"),
        // .define("OpenSSL_version_num", to: "GRPC_SHADOW_OpenSSL_version_num"),
        // .define("OTHERNAME_cmp", to: "GRPC_SHADOW_OTHERNAME_cmp"),
        // .define("OTHERNAME_free", to: "GRPC_SHADOW_OTHERNAME_free"),
        // .define("OTHERNAME_it", to: "GRPC_SHADOW_OTHERNAME_it"),
        // .define("OTHERNAME_new", to: "GRPC_SHADOW_OTHERNAME_new"),
        // .define("PEM_ASN1_read", to: "GRPC_SHADOW_PEM_ASN1_read"),
        // .define("PEM_ASN1_read_bio", to: "GRPC_SHADOW_PEM_ASN1_read_bio"),
        // .define("PEM_ASN1_write", to: "GRPC_SHADOW_PEM_ASN1_write"),
        // .define("PEM_ASN1_write_bio", to: "GRPC_SHADOW_PEM_ASN1_write_bio"),
        // .define("PEM_bytes_read_bio", to: "GRPC_SHADOW_PEM_bytes_read_bio"),
        // .define("PEM_def_callback", to: "GRPC_SHADOW_PEM_def_callback"),
        // .define("PEM_dek_info", to: "GRPC_SHADOW_PEM_dek_info"),
        // .define("PEM_do_header", to: "GRPC_SHADOW_PEM_do_header"),
        // .define("PEM_get_EVP_CIPHER_INFO", to: "GRPC_SHADOW_PEM_get_EVP_CIPHER_INFO"),
        // .define("PEM_proc_type", to: "GRPC_SHADOW_PEM_proc_type"),
        // .define("PEM_read", to: "GRPC_SHADOW_PEM_read"),
        // .define("PEM_read_bio", to: "GRPC_SHADOW_PEM_read_bio"),
        // .define("PEM_read_bio_DHparams", to: "GRPC_SHADOW_PEM_read_bio_DHparams"),
        // .define("PEM_read_bio_DSAparams", to: "GRPC_SHADOW_PEM_read_bio_DSAparams"),
        // .define("PEM_read_bio_DSAPrivateKey", to: "GRPC_SHADOW_PEM_read_bio_DSAPrivateKey"),
        // .define("PEM_read_bio_DSA_PUBKEY", to: "GRPC_SHADOW_PEM_read_bio_DSA_PUBKEY"),
        // .define("PEM_read_bio_ECPrivateKey", to: "GRPC_SHADOW_PEM_read_bio_ECPrivateKey"),
        // .define("PEM_read_bio_EC_PUBKEY", to: "GRPC_SHADOW_PEM_read_bio_EC_PUBKEY"),
        // .define("PEM_read_bio_PKCS7", to: "GRPC_SHADOW_PEM_read_bio_PKCS7"),
        // .define("PEM_read_bio_PKCS8", to: "GRPC_SHADOW_PEM_read_bio_PKCS8"),
        // .define("PEM_read_bio_PKCS8_PRIV_KEY_INFO", to: "GRPC_SHADOW_PEM_read_bio_PKCS8_PRIV_KEY_INFO"),
        // .define("PEM_read_bio_PrivateKey", to: "GRPC_SHADOW_PEM_read_bio_PrivateKey"),
        // .define("PEM_read_bio_PUBKEY", to: "GRPC_SHADOW_PEM_read_bio_PUBKEY"),
        // .define("PEM_read_bio_RSAPrivateKey", to: "GRPC_SHADOW_PEM_read_bio_RSAPrivateKey"),
        // .define("PEM_read_bio_RSA_PUBKEY", to: "GRPC_SHADOW_PEM_read_bio_RSA_PUBKEY"),
        // .define("PEM_read_bio_RSAPublicKey", to: "GRPC_SHADOW_PEM_read_bio_RSAPublicKey"),
        // .define("PEM_read_bio_SSL_SESSION", to: "GRPC_SHADOW_PEM_read_bio_SSL_SESSION"),
        // .define("PEM_read_bio_X509", to: "GRPC_SHADOW_PEM_read_bio_X509"),
        // .define("PEM_read_bio_X509_AUX", to: "GRPC_SHADOW_PEM_read_bio_X509_AUX"),
        // .define("PEM_read_bio_X509_CRL", to: "GRPC_SHADOW_PEM_read_bio_X509_CRL"),
        // .define("PEM_read_bio_X509_REQ", to: "GRPC_SHADOW_PEM_read_bio_X509_REQ"),
        // .define("PEM_read_DHparams", to: "GRPC_SHADOW_PEM_read_DHparams"),
        // .define("PEM_read_DSAparams", to: "GRPC_SHADOW_PEM_read_DSAparams"),
        // .define("PEM_read_DSAPrivateKey", to: "GRPC_SHADOW_PEM_read_DSAPrivateKey"),
        // .define("PEM_read_DSA_PUBKEY", to: "GRPC_SHADOW_PEM_read_DSA_PUBKEY"),
        // .define("PEM_read_ECPrivateKey", to: "GRPC_SHADOW_PEM_read_ECPrivateKey"),
        // .define("PEM_read_EC_PUBKEY", to: "GRPC_SHADOW_PEM_read_EC_PUBKEY"),
        // .define("PEM_read_PKCS7", to: "GRPC_SHADOW_PEM_read_PKCS7"),
        // .define("PEM_read_PKCS8", to: "GRPC_SHADOW_PEM_read_PKCS8"),
        // .define("PEM_read_PKCS8_PRIV_KEY_INFO", to: "GRPC_SHADOW_PEM_read_PKCS8_PRIV_KEY_INFO"),
        // .define("PEM_read_PrivateKey", to: "GRPC_SHADOW_PEM_read_PrivateKey"),
        // .define("PEM_read_PUBKEY", to: "GRPC_SHADOW_PEM_read_PUBKEY"),
        // .define("PEM_read_RSAPrivateKey", to: "GRPC_SHADOW_PEM_read_RSAPrivateKey"),
        // .define("PEM_read_RSA_PUBKEY", to: "GRPC_SHADOW_PEM_read_RSA_PUBKEY"),
        // .define("PEM_read_RSAPublicKey", to: "GRPC_SHADOW_PEM_read_RSAPublicKey"),
        // .define("PEM_read_SSL_SESSION", to: "GRPC_SHADOW_PEM_read_SSL_SESSION"),
        // .define("PEM_read_X509", to: "GRPC_SHADOW_PEM_read_X509"),
        // .define("PEM_read_X509_AUX", to: "GRPC_SHADOW_PEM_read_X509_AUX"),
        // .define("PEM_read_X509_CRL", to: "GRPC_SHADOW_PEM_read_X509_CRL"),
        // .define("PEM_read_X509_REQ", to: "GRPC_SHADOW_PEM_read_X509_REQ"),
        // .define("PEM_write", to: "GRPC_SHADOW_PEM_write"),
        // .define("PEM_write_bio", to: "GRPC_SHADOW_PEM_write_bio"),
        // .define("PEM_write_bio_DHparams", to: "GRPC_SHADOW_PEM_write_bio_DHparams"),
        // .define("PEM_write_bio_DSAparams", to: "GRPC_SHADOW_PEM_write_bio_DSAparams"),
        // .define("PEM_write_bio_DSAPrivateKey", to: "GRPC_SHADOW_PEM_write_bio_DSAPrivateKey"),
        // .define("PEM_write_bio_DSA_PUBKEY", to: "GRPC_SHADOW_PEM_write_bio_DSA_PUBKEY"),
        // .define("PEM_write_bio_ECPrivateKey", to: "GRPC_SHADOW_PEM_write_bio_ECPrivateKey"),
        // .define("PEM_write_bio_EC_PUBKEY", to: "GRPC_SHADOW_PEM_write_bio_EC_PUBKEY"),
        // .define("PEM_write_bio_PKCS7", to: "GRPC_SHADOW_PEM_write_bio_PKCS7"),
        // .define("PEM_write_bio_PKCS8", to: "GRPC_SHADOW_PEM_write_bio_PKCS8"),
        // .define("PEM_write_bio_PKCS8PrivateKey", to: "GRPC_SHADOW_PEM_write_bio_PKCS8PrivateKey"),
        // .define("PEM_write_bio_PKCS8PrivateKey_nid", to: "GRPC_SHADOW_PEM_write_bio_PKCS8PrivateKey_nid"),
        // .define("PEM_write_bio_PKCS8_PRIV_KEY_INFO", to: "GRPC_SHADOW_PEM_write_bio_PKCS8_PRIV_KEY_INFO"),
        // .define("PEM_write_bio_PrivateKey", to: "GRPC_SHADOW_PEM_write_bio_PrivateKey"),
        // .define("PEM_write_bio_PUBKEY", to: "GRPC_SHADOW_PEM_write_bio_PUBKEY"),
        // .define("PEM_write_bio_RSAPrivateKey", to: "GRPC_SHADOW_PEM_write_bio_RSAPrivateKey"),
        // .define("PEM_write_bio_RSA_PUBKEY", to: "GRPC_SHADOW_PEM_write_bio_RSA_PUBKEY"),
        // .define("PEM_write_bio_RSAPublicKey", to: "GRPC_SHADOW_PEM_write_bio_RSAPublicKey"),
        // .define("PEM_write_bio_SSL_SESSION", to: "GRPC_SHADOW_PEM_write_bio_SSL_SESSION"),
        // .define("PEM_write_bio_X509", to: "GRPC_SHADOW_PEM_write_bio_X509"),
        // .define("PEM_write_bio_X509_AUX", to: "GRPC_SHADOW_PEM_write_bio_X509_AUX"),
        // .define("PEM_write_bio_X509_CRL", to: "GRPC_SHADOW_PEM_write_bio_X509_CRL"),
        // .define("PEM_write_bio_X509_REQ", to: "GRPC_SHADOW_PEM_write_bio_X509_REQ"),
        // .define("PEM_write_bio_X509_REQ_NEW", to: "GRPC_SHADOW_PEM_write_bio_X509_REQ_NEW"),
        // .define("PEM_write_DHparams", to: "GRPC_SHADOW_PEM_write_DHparams"),
        // .define("PEM_write_DSAparams", to: "GRPC_SHADOW_PEM_write_DSAparams"),
        // .define("PEM_write_DSAPrivateKey", to: "GRPC_SHADOW_PEM_write_DSAPrivateKey"),
        // .define("PEM_write_DSA_PUBKEY", to: "GRPC_SHADOW_PEM_write_DSA_PUBKEY"),
        // .define("PEM_write_ECPrivateKey", to: "GRPC_SHADOW_PEM_write_ECPrivateKey"),
        // .define("PEM_write_EC_PUBKEY", to: "GRPC_SHADOW_PEM_write_EC_PUBKEY"),
        // .define("PEM_write_PKCS7", to: "GRPC_SHADOW_PEM_write_PKCS7"),
        // .define("PEM_write_PKCS8", to: "GRPC_SHADOW_PEM_write_PKCS8"),
        // .define("PEM_write_PKCS8PrivateKey", to: "GRPC_SHADOW_PEM_write_PKCS8PrivateKey"),
        // .define("PEM_write_PKCS8PrivateKey_nid", to: "GRPC_SHADOW_PEM_write_PKCS8PrivateKey_nid"),
        // .define("PEM_write_PKCS8_PRIV_KEY_INFO", to: "GRPC_SHADOW_PEM_write_PKCS8_PRIV_KEY_INFO"),
        // .define("PEM_write_PrivateKey", to: "GRPC_SHADOW_PEM_write_PrivateKey"),
        // .define("PEM_write_PUBKEY", to: "GRPC_SHADOW_PEM_write_PUBKEY"),
        // .define("PEM_write_RSAPrivateKey", to: "GRPC_SHADOW_PEM_write_RSAPrivateKey"),
        // .define("PEM_write_RSA_PUBKEY", to: "GRPC_SHADOW_PEM_write_RSA_PUBKEY"),
        // .define("PEM_write_RSAPublicKey", to: "GRPC_SHADOW_PEM_write_RSAPublicKey"),
        // .define("PEM_write_SSL_SESSION", to: "GRPC_SHADOW_PEM_write_SSL_SESSION"),
        // .define("PEM_write_X509", to: "GRPC_SHADOW_PEM_write_X509"),
        // .define("PEM_write_X509_AUX", to: "GRPC_SHADOW_PEM_write_X509_AUX"),
        // .define("PEM_write_X509_CRL", to: "GRPC_SHADOW_PEM_write_X509_CRL"),
        // .define("PEM_write_X509_REQ", to: "GRPC_SHADOW_PEM_write_X509_REQ"),
        // .define("PEM_write_X509_REQ_NEW", to: "GRPC_SHADOW_PEM_write_X509_REQ_NEW"),
        // .define("PEM_X509_INFO_read", to: "GRPC_SHADOW_PEM_X509_INFO_read"),
        // .define("PEM_X509_INFO_read_bio", to: "GRPC_SHADOW_PEM_X509_INFO_read_bio"),
        // .define("PEM_X509_INFO_write_bio", to: "GRPC_SHADOW_PEM_X509_INFO_write_bio"),
        // .define("PKCS12_create", to: "GRPC_SHADOW_PKCS12_create"),
        // .define("PKCS12_free", to: "GRPC_SHADOW_PKCS12_free"),
        // .define("PKCS12_get_key_and_certs", to: "GRPC_SHADOW_PKCS12_get_key_and_certs"),
        // .define("pkcs12_iterations_acceptable", to: "GRPC_SHADOW_pkcs12_iterations_acceptable"),
        // .define("pkcs12_key_gen", to: "GRPC_SHADOW_pkcs12_key_gen"),
        // .define("PKCS12_parse", to: "GRPC_SHADOW_PKCS12_parse"),
        // .define("PKCS12_PBE_add", to: "GRPC_SHADOW_PKCS12_PBE_add"),
        // .define("pkcs12_pbe_encrypt_init", to: "GRPC_SHADOW_pkcs12_pbe_encrypt_init"),
        // .define("PKCS12_verify_mac", to: "GRPC_SHADOW_PKCS12_verify_mac"),
        // .define("PKCS5_pbe2_decrypt_init", to: "GRPC_SHADOW_PKCS5_pbe2_decrypt_init"),
        // .define("PKCS5_pbe2_encrypt_init", to: "GRPC_SHADOW_PKCS5_pbe2_encrypt_init"),
        // .define("PKCS5_PBKDF2_HMAC", to: "GRPC_SHADOW_PKCS5_PBKDF2_HMAC"),
        // .define("PKCS5_PBKDF2_HMAC_SHA1", to: "GRPC_SHADOW_PKCS5_PBKDF2_HMAC_SHA1"),
        // .define("pkcs7_bundle", to: "GRPC_SHADOW_pkcs7_bundle"),
        // .define("PKCS7_bundle_certificates", to: "GRPC_SHADOW_PKCS7_bundle_certificates"),
        // .define("PKCS7_bundle_CRLs", to: "GRPC_SHADOW_PKCS7_bundle_CRLs"),
        // .define("PKCS7_free", to: "GRPC_SHADOW_PKCS7_free"),
        // .define("PKCS7_get_certificates", to: "GRPC_SHADOW_PKCS7_get_certificates"),
        // .define("PKCS7_get_CRLs", to: "GRPC_SHADOW_PKCS7_get_CRLs"),
        // .define("PKCS7_get_PEM_certificates", to: "GRPC_SHADOW_PKCS7_get_PEM_certificates"),
        // .define("PKCS7_get_PEM_CRLs", to: "GRPC_SHADOW_PKCS7_get_PEM_CRLs"),
        // .define("PKCS7_get_raw_certificates", to: "GRPC_SHADOW_PKCS7_get_raw_certificates"),
        // .define("pkcs7_parse_header", to: "GRPC_SHADOW_pkcs7_parse_header"),
        // .define("PKCS7_sign", to: "GRPC_SHADOW_PKCS7_sign"),
        // .define("PKCS7_type_is_data", to: "GRPC_SHADOW_PKCS7_type_is_data"),
        // .define("PKCS7_type_is_digest", to: "GRPC_SHADOW_PKCS7_type_is_digest"),
        // .define("PKCS7_type_is_encrypted", to: "GRPC_SHADOW_PKCS7_type_is_encrypted"),
        // .define("PKCS7_type_is_enveloped", to: "GRPC_SHADOW_PKCS7_type_is_enveloped"),
        // .define("PKCS7_type_is_signed", to: "GRPC_SHADOW_PKCS7_type_is_signed"),
        // .define("PKCS7_type_is_signedAndEnveloped", to: "GRPC_SHADOW_PKCS7_type_is_signedAndEnveloped"),
        // .define("PKCS8_decrypt", to: "GRPC_SHADOW_PKCS8_decrypt"),
        // .define("PKCS8_encrypt", to: "GRPC_SHADOW_PKCS8_encrypt"),
        // .define("PKCS8_marshal_encrypted_private_key", to: "GRPC_SHADOW_PKCS8_marshal_encrypted_private_key"),
        // .define("PKCS8_parse_encrypted_private_key", to: "GRPC_SHADOW_PKCS8_parse_encrypted_private_key"),
        // .define("pkcs8_pbe_decrypt", to: "GRPC_SHADOW_pkcs8_pbe_decrypt"),
        // .define("PKCS8_pkey_get0", to: "GRPC_SHADOW_PKCS8_pkey_get0"),
        // .define("PKCS8_pkey_set0", to: "GRPC_SHADOW_PKCS8_pkey_set0"),
        // .define("PKCS8_PRIV_KEY_INFO_free", to: "GRPC_SHADOW_PKCS8_PRIV_KEY_INFO_free"),
        // .define("PKCS8_PRIV_KEY_INFO_it", to: "GRPC_SHADOW_PKCS8_PRIV_KEY_INFO_it"),
        // .define("PKCS8_PRIV_KEY_INFO_new", to: "GRPC_SHADOW_PKCS8_PRIV_KEY_INFO_new"),
        // .define("PKEY_USAGE_PERIOD_free", to: "GRPC_SHADOW_PKEY_USAGE_PERIOD_free"),
        // .define("PKEY_USAGE_PERIOD_it", to: "GRPC_SHADOW_PKEY_USAGE_PERIOD_it"),
        // .define("PKEY_USAGE_PERIOD_new", to: "GRPC_SHADOW_PKEY_USAGE_PERIOD_new"),
        // .define("policy_cache_find_data", to: "GRPC_SHADOW_policy_cache_find_data"),
        // .define("policy_cache_free", to: "GRPC_SHADOW_policy_cache_free"),
        // .define("policy_cache_set", to: "GRPC_SHADOW_policy_cache_set"),
        // .define("policy_cache_set_mapping", to: "GRPC_SHADOW_policy_cache_set_mapping"),
        // .define("POLICY_CONSTRAINTS_free", to: "GRPC_SHADOW_POLICY_CONSTRAINTS_free"),
        // .define("POLICY_CONSTRAINTS_it", to: "GRPC_SHADOW_POLICY_CONSTRAINTS_it"),
        // .define("POLICY_CONSTRAINTS_new", to: "GRPC_SHADOW_POLICY_CONSTRAINTS_new"),
        // .define("policy_data_free", to: "GRPC_SHADOW_policy_data_free"),
        // .define("policy_data_new", to: "GRPC_SHADOW_policy_data_new"),
        // .define("POLICYINFO_free", to: "GRPC_SHADOW_POLICYINFO_free"),
        // .define("POLICYINFO_it", to: "GRPC_SHADOW_POLICYINFO_it"),
        // .define("POLICYINFO_new", to: "GRPC_SHADOW_POLICYINFO_new"),
        // .define("POLICY_MAPPING_free", to: "GRPC_SHADOW_POLICY_MAPPING_free"),
        // .define("POLICY_MAPPING_it", to: "GRPC_SHADOW_POLICY_MAPPING_it"),
        // .define("POLICY_MAPPING_new", to: "GRPC_SHADOW_POLICY_MAPPING_new"),
        // .define("POLICY_MAPPINGS_it", to: "GRPC_SHADOW_POLICY_MAPPINGS_it"),
        // .define("policy_node_cmp_new", to: "GRPC_SHADOW_policy_node_cmp_new"),
        // .define("policy_node_free", to: "GRPC_SHADOW_policy_node_free"),
        // .define("policy_node_match", to: "GRPC_SHADOW_policy_node_match"),
        // .define("POLICYQUALINFO_free", to: "GRPC_SHADOW_POLICYQUALINFO_free"),
        // .define("POLICYQUALINFO_it", to: "GRPC_SHADOW_POLICYQUALINFO_it"),
        // .define("POLICYQUALINFO_new", to: "GRPC_SHADOW_POLICYQUALINFO_new"),
        // .define("poly_Rq_mul", to: "GRPC_SHADOW_poly_Rq_mul"),
        // .define("PROXY_CERT_INFO_EXTENSION_free", to: "GRPC_SHADOW_PROXY_CERT_INFO_EXTENSION_free"),
        // .define("PROXY_CERT_INFO_EXTENSION_it", to: "GRPC_SHADOW_PROXY_CERT_INFO_EXTENSION_it"),
        // .define("PROXY_CERT_INFO_EXTENSION_new", to: "GRPC_SHADOW_PROXY_CERT_INFO_EXTENSION_new"),
        // .define("PROXY_POLICY_free", to: "GRPC_SHADOW_PROXY_POLICY_free"),
        // .define("PROXY_POLICY_it", to: "GRPC_SHADOW_PROXY_POLICY_it"),
        // .define("PROXY_POLICY_new", to: "GRPC_SHADOW_PROXY_POLICY_new"),
        // .define("RAND_add", to: "GRPC_SHADOW_RAND_add"),
        // .define("RAND_bytes", to: "GRPC_SHADOW_RAND_bytes"),
        // .define("RAND_bytes_with_additional_data", to: "GRPC_SHADOW_RAND_bytes_with_additional_data"),
        // .define("RAND_cleanup", to: "GRPC_SHADOW_RAND_cleanup"),
        // .define("RAND_egd", to: "GRPC_SHADOW_RAND_egd"),
        // .define("RAND_enable_fork_unsafe_buffering", to: "GRPC_SHADOW_RAND_enable_fork_unsafe_buffering"),
        // .define("RAND_file_name", to: "GRPC_SHADOW_RAND_file_name"),
        // .define("rand_fork_unsafe_buffering_enabled", to: "GRPC_SHADOW_rand_fork_unsafe_buffering_enabled"),
        // .define("RAND_get_rand_method", to: "GRPC_SHADOW_RAND_get_rand_method"),
        // .define("RAND_load_file", to: "GRPC_SHADOW_RAND_load_file"),
        // .define("RAND_poll", to: "GRPC_SHADOW_RAND_poll"),
        // .define("RAND_pseudo_bytes", to: "GRPC_SHADOW_RAND_pseudo_bytes"),
        // .define("RAND_seed", to: "GRPC_SHADOW_RAND_seed"),
        // .define("RAND_set_rand_method", to: "GRPC_SHADOW_RAND_set_rand_method"),
        // .define("RAND_set_urandom_fd", to: "GRPC_SHADOW_RAND_set_urandom_fd"),
        // .define("RAND_SSLeay", to: "GRPC_SHADOW_RAND_SSLeay"),
        // .define("RAND_status", to: "GRPC_SHADOW_RAND_status"),
        // .define("RC4", to: "GRPC_SHADOW_RC4"),
        // .define("RC4_set_key", to: "GRPC_SHADOW_RC4_set_key"),
        // .define("RSA_add_pkcs1_prefix", to: "GRPC_SHADOW_RSA_add_pkcs1_prefix"),
        // .define("rsa_asn1_meth", to: "GRPC_SHADOW_rsa_asn1_meth"),
        // .define("RSA_bits", to: "GRPC_SHADOW_RSA_bits"),
        // .define("RSA_blinding_on", to: "GRPC_SHADOW_RSA_blinding_on"),
        // .define("RSA_check_fips", to: "GRPC_SHADOW_RSA_check_fips"),
        // .define("RSA_check_key", to: "GRPC_SHADOW_RSA_check_key"),
        // .define("RSA_decrypt", to: "GRPC_SHADOW_RSA_decrypt"),
        // .define("rsa_default_decrypt", to: "GRPC_SHADOW_rsa_default_decrypt"),
        // .define("RSA_default_method", to: "GRPC_SHADOW_RSA_default_method"),
        // .define("rsa_default_private_transform", to: "GRPC_SHADOW_rsa_default_private_transform"),
        // .define("rsa_default_sign_raw", to: "GRPC_SHADOW_rsa_default_sign_raw"),
        // .define("rsa_default_size", to: "GRPC_SHADOW_rsa_default_size"),
        // .define("RSA_encrypt", to: "GRPC_SHADOW_RSA_encrypt"),
        // .define("RSA_flags", to: "GRPC_SHADOW_RSA_flags"),
        // .define("RSA_free", to: "GRPC_SHADOW_RSA_free"),
        // .define("RSA_generate_key_ex", to: "GRPC_SHADOW_RSA_generate_key_ex"),
        // .define("RSA_generate_key_fips", to: "GRPC_SHADOW_RSA_generate_key_fips"),
        // .define("RSA_get0_crt_params", to: "GRPC_SHADOW_RSA_get0_crt_params"),
        // .define("RSA_get0_factors", to: "GRPC_SHADOW_RSA_get0_factors"),
        // .define("RSA_get0_key", to: "GRPC_SHADOW_RSA_get0_key"),
        // .define("RSA_get_ex_data", to: "GRPC_SHADOW_RSA_get_ex_data"),
        // .define("RSA_get_ex_new_index", to: "GRPC_SHADOW_RSA_get_ex_new_index"),
        // .define("RSA_is_opaque", to: "GRPC_SHADOW_RSA_is_opaque"),
        // .define("RSA_marshal_private_key", to: "GRPC_SHADOW_RSA_marshal_private_key"),
        // .define("RSA_marshal_public_key", to: "GRPC_SHADOW_RSA_marshal_public_key"),
        // .define("RSA_new", to: "GRPC_SHADOW_RSA_new"),
        // .define("RSA_new_method", to: "GRPC_SHADOW_RSA_new_method"),
        // .define("RSA_padding_add_none", to: "GRPC_SHADOW_RSA_padding_add_none"),
        // .define("RSA_padding_add_PKCS1_OAEP_mgf1", to: "GRPC_SHADOW_RSA_padding_add_PKCS1_OAEP_mgf1"),
        // .define("RSA_padding_add_PKCS1_PSS_mgf1", to: "GRPC_SHADOW_RSA_padding_add_PKCS1_PSS_mgf1"),
        // .define("RSA_padding_add_PKCS1_type_1", to: "GRPC_SHADOW_RSA_padding_add_PKCS1_type_1"),
        // .define("RSA_padding_add_PKCS1_type_2", to: "GRPC_SHADOW_RSA_padding_add_PKCS1_type_2"),
        // .define("RSA_padding_check_PKCS1_OAEP_mgf1", to: "GRPC_SHADOW_RSA_padding_check_PKCS1_OAEP_mgf1"),
        // .define("RSA_padding_check_PKCS1_type_1", to: "GRPC_SHADOW_RSA_padding_check_PKCS1_type_1"),
        // .define("RSA_padding_check_PKCS1_type_2", to: "GRPC_SHADOW_RSA_padding_check_PKCS1_type_2"),
        // .define("RSA_parse_private_key", to: "GRPC_SHADOW_RSA_parse_private_key"),
        // .define("RSA_parse_public_key", to: "GRPC_SHADOW_RSA_parse_public_key"),
        // .define("rsa_pkey_meth", to: "GRPC_SHADOW_rsa_pkey_meth"),
        // .define("RSA_print", to: "GRPC_SHADOW_RSA_print"),
        // .define("RSA_private_decrypt", to: "GRPC_SHADOW_RSA_private_decrypt"),
        // .define("RSA_private_encrypt", to: "GRPC_SHADOW_RSA_private_encrypt"),
        // .define("RSAPrivateKey_dup", to: "GRPC_SHADOW_RSAPrivateKey_dup"),
        // .define("RSA_private_key_from_bytes", to: "GRPC_SHADOW_RSA_private_key_from_bytes"),
        // .define("RSA_private_key_to_bytes", to: "GRPC_SHADOW_RSA_private_key_to_bytes"),
        // .define("RSA_private_transform", to: "GRPC_SHADOW_RSA_private_transform"),
        // .define("RSA_PSS_PARAMS_free", to: "GRPC_SHADOW_RSA_PSS_PARAMS_free"),
        // .define("RSA_PSS_PARAMS_it", to: "GRPC_SHADOW_RSA_PSS_PARAMS_it"),
        // .define("RSA_PSS_PARAMS_new", to: "GRPC_SHADOW_RSA_PSS_PARAMS_new"),
        // .define("RSA_public_decrypt", to: "GRPC_SHADOW_RSA_public_decrypt"),
        // .define("RSA_public_encrypt", to: "GRPC_SHADOW_RSA_public_encrypt"),
        // .define("RSAPublicKey_dup", to: "GRPC_SHADOW_RSAPublicKey_dup"),
        // .define("RSA_public_key_from_bytes", to: "GRPC_SHADOW_RSA_public_key_from_bytes"),
        // .define("RSA_public_key_to_bytes", to: "GRPC_SHADOW_RSA_public_key_to_bytes"),
        // .define("RSA_set0_crt_params", to: "GRPC_SHADOW_RSA_set0_crt_params"),
        // .define("RSA_set0_factors", to: "GRPC_SHADOW_RSA_set0_factors"),
        // .define("RSA_set0_key", to: "GRPC_SHADOW_RSA_set0_key"),
        // .define("RSA_set_ex_data", to: "GRPC_SHADOW_RSA_set_ex_data"),
        // .define("RSA_sign", to: "GRPC_SHADOW_RSA_sign"),
        // .define("RSA_sign_pss_mgf1", to: "GRPC_SHADOW_RSA_sign_pss_mgf1"),
        // .define("RSA_sign_raw", to: "GRPC_SHADOW_RSA_sign_raw"),
        // .define("RSA_size", to: "GRPC_SHADOW_RSA_size"),
        // .define("RSA_up_ref", to: "GRPC_SHADOW_RSA_up_ref"),
        // .define("RSA_verify", to: "GRPC_SHADOW_RSA_verify"),
        // .define("RSA_verify_PKCS1_PSS_mgf1", to: "GRPC_SHADOW_RSA_verify_PKCS1_PSS_mgf1"),
        // .define("RSA_verify_pss_mgf1", to: "GRPC_SHADOW_RSA_verify_pss_mgf1"),
        // .define("RSA_verify_raw", to: "GRPC_SHADOW_RSA_verify_raw"),
        // .define("rsaz_1024_gather5_avx2", to: "GRPC_SHADOW_rsaz_1024_gather5_avx2"),
        // .define("RSAZ_1024_mod_exp_avx2", to: "GRPC_SHADOW_RSAZ_1024_mod_exp_avx2"),
        // .define("rsaz_1024_mul_avx2", to: "GRPC_SHADOW_rsaz_1024_mul_avx2"),
        // .define("rsaz_1024_norm2red_avx2", to: "GRPC_SHADOW_rsaz_1024_norm2red_avx2"),
        // .define("rsaz_1024_red2norm_avx2", to: "GRPC_SHADOW_rsaz_1024_red2norm_avx2"),
        // .define("rsaz_1024_scatter5_avx2", to: "GRPC_SHADOW_rsaz_1024_scatter5_avx2"),
        // .define("rsaz_1024_sqr_avx2", to: "GRPC_SHADOW_rsaz_1024_sqr_avx2"),
        // .define("s2i_ASN1_INTEGER", to: "GRPC_SHADOW_s2i_ASN1_INTEGER"),
        // .define("s2i_ASN1_OCTET_STRING", to: "GRPC_SHADOW_s2i_ASN1_OCTET_STRING"),
        // .define("sdallocx", to: "GRPC_SHADOW_sdallocx"),
        // .define("SHA1", to: "GRPC_SHADOW_SHA1"),
        // .define("sha1_block_data_order", to: "GRPC_SHADOW_sha1_block_data_order"),
        // .define("SHA1_Final", to: "GRPC_SHADOW_SHA1_Final"),
        // .define("SHA1_Init", to: "GRPC_SHADOW_SHA1_Init"),
        // .define("SHA1_Transform", to: "GRPC_SHADOW_SHA1_Transform"),
        // .define("SHA1_Update", to: "GRPC_SHADOW_SHA1_Update"),
        // .define("SHA224", to: "GRPC_SHADOW_SHA224"),
        // .define("SHA224_Final", to: "GRPC_SHADOW_SHA224_Final"),
        // .define("SHA224_Init", to: "GRPC_SHADOW_SHA224_Init"),
        // .define("SHA224_Update", to: "GRPC_SHADOW_SHA224_Update"),
        // .define("SHA256", to: "GRPC_SHADOW_SHA256"),
        // .define("sha256_block_data_order", to: "GRPC_SHADOW_sha256_block_data_order"),
        // .define("SHA256_Final", to: "GRPC_SHADOW_SHA256_Final"),
        // .define("SHA256_Init", to: "GRPC_SHADOW_SHA256_Init"),
        // .define("SHA256_Transform", to: "GRPC_SHADOW_SHA256_Transform"),
        // .define("SHA256_TransformBlocks", to: "GRPC_SHADOW_SHA256_TransformBlocks"),
        // .define("SHA256_Update", to: "GRPC_SHADOW_SHA256_Update"),
        // .define("SHA384", to: "GRPC_SHADOW_SHA384"),
        // .define("SHA384_Final", to: "GRPC_SHADOW_SHA384_Final"),
        // .define("SHA384_Init", to: "GRPC_SHADOW_SHA384_Init"),
        // .define("SHA384_Update", to: "GRPC_SHADOW_SHA384_Update"),
        // .define("SHA512", to: "GRPC_SHADOW_SHA512"),
        // .define("sha512_block_data_order", to: "GRPC_SHADOW_sha512_block_data_order"),
        // .define("SHA512_Final", to: "GRPC_SHADOW_SHA512_Final"),
        // .define("SHA512_Init", to: "GRPC_SHADOW_SHA512_Init"),
        // .define("SHA512_Transform", to: "GRPC_SHADOW_SHA512_Transform"),
        // .define("SHA512_Update", to: "GRPC_SHADOW_SHA512_Update"),
        // .define("SIPHASH_24", to: "GRPC_SHADOW_SIPHASH_24"),
        // .define("sk_CRYPTO_BUFFER_call_copy_func", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_call_copy_func"),
        // .define("sk_CRYPTO_BUFFER_call_copy_func", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_call_copy_func"),
        // .define("sk_CRYPTO_BUFFER_call_free_func", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_call_free_func"),
        // .define("sk_CRYPTO_BUFFER_call_free_func", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_call_free_func"),
        // .define("sk_CRYPTO_BUFFER_deep_copy", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_deep_copy"),
        // .define("sk_CRYPTO_BUFFER_deep_copy", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_deep_copy"),
        // .define("sk_CRYPTO_BUFFER_new_null", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_new_null"),
        // .define("sk_CRYPTO_BUFFER_new_null", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_new_null"),
        // .define("sk_CRYPTO_BUFFER_new_null", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_new_null"),
        // .define("sk_CRYPTO_BUFFER_new_null", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_new_null"),
        // .define("sk_CRYPTO_BUFFER_new_null", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_new_null"),
        // .define("sk_CRYPTO_BUFFER_new_null", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_new_null"),
        // .define("sk_CRYPTO_BUFFER_num", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_num"),
        // .define("sk_CRYPTO_BUFFER_num", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_num"),
        // .define("sk_CRYPTO_BUFFER_num", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_num"),
        // .define("sk_CRYPTO_BUFFER_num", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_num"),
        // .define("sk_CRYPTO_BUFFER_num", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_num"),
        // .define("sk_CRYPTO_BUFFER_num", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_num"),
        // .define("sk_CRYPTO_BUFFER_num", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_num"),
        // .define("sk_CRYPTO_BUFFER_num", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_num"),
        // .define("sk_CRYPTO_BUFFER_num", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_num"),
        // .define("sk_CRYPTO_BUFFER_push", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_push"),
        // .define("sk_CRYPTO_BUFFER_set", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_set"),
        // .define("sk_CRYPTO_BUFFER_value", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_value"),
        // .define("sk_CRYPTO_BUFFER_value", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_value"),
        // .define("sk_CRYPTO_BUFFER_value", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_value"),
        // .define("sk_CRYPTO_BUFFER_value", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_value"),
        // .define("sk_CRYPTO_BUFFER_value", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_value"),
        // .define("sk_CRYPTO_BUFFER_value", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_value"),
        // .define("sk_CRYPTO_BUFFER_value", to: "GRPC_SHADOW_sk_CRYPTO_BUFFER_value"),
        // .define("sk_deep_copy", to: "GRPC_SHADOW_sk_deep_copy"),
        // .define("sk_delete", to: "GRPC_SHADOW_sk_delete"),
        // .define("sk_delete_ptr", to: "GRPC_SHADOW_sk_delete_ptr"),
        // .define("sk_dup", to: "GRPC_SHADOW_sk_dup"),
        // .define("sk_find", to: "GRPC_SHADOW_sk_find"),
        // .define("sk_free", to: "GRPC_SHADOW_sk_free"),
        // .define("sk_insert", to: "GRPC_SHADOW_sk_insert"),
        // .define("sk_is_sorted", to: "GRPC_SHADOW_sk_is_sorted"),
        // .define("sk_new", to: "GRPC_SHADOW_sk_new"),
        // .define("sk_new_null", to: "GRPC_SHADOW_sk_new_null"),
        // .define("sk_num", to: "GRPC_SHADOW_sk_num"),
        // .define("sk_pop", to: "GRPC_SHADOW_sk_pop"),
        // .define("sk_pop_free", to: "GRPC_SHADOW_sk_pop_free"),
        // .define("sk_pop_free_ex", to: "GRPC_SHADOW_sk_pop_free_ex"),
        // .define("sk_push", to: "GRPC_SHADOW_sk_push"),
        // .define("sk_set", to: "GRPC_SHADOW_sk_set"),
        // .define("sk_set_cmp_func", to: "GRPC_SHADOW_sk_set_cmp_func"),
        // .define("sk_shift", to: "GRPC_SHADOW_sk_shift"),
        // .define("sk_sort", to: "GRPC_SHADOW_sk_sort"),
        // .define("sk_SRTP_PROTECTION_PROFILE_new_null", to: "GRPC_SHADOW_sk_SRTP_PROTECTION_PROFILE_new_null"),
        // .define("sk_SRTP_PROTECTION_PROFILE_num", to: "GRPC_SHADOW_sk_SRTP_PROTECTION_PROFILE_num"),
        // .define("sk_SRTP_PROTECTION_PROFILE_push", to: "GRPC_SHADOW_sk_SRTP_PROTECTION_PROFILE_push"),
        // .define("sk_SSL_CIPHER_call_cmp_func", to: "GRPC_SHADOW_sk_SSL_CIPHER_call_cmp_func"),
        // .define("sk_SSL_CIPHER_call_cmp_func", to: "GRPC_SHADOW_sk_SSL_CIPHER_call_cmp_func"),
        // .define("sk_SSL_CIPHER_call_cmp_func", to: "GRPC_SHADOW_sk_SSL_CIPHER_call_cmp_func"),
        // .define("sk_SSL_CIPHER_call_cmp_func", to: "GRPC_SHADOW_sk_SSL_CIPHER_call_cmp_func"),
        // .define("sk_SSL_CIPHER_delete", to: "GRPC_SHADOW_sk_SSL_CIPHER_delete"),
        // .define("sk_SSL_CIPHER_dup", to: "GRPC_SHADOW_sk_SSL_CIPHER_dup"),
        // .define("sk_SSL_CIPHER_find", to: "GRPC_SHADOW_sk_SSL_CIPHER_find"),
        // .define("sk_SSL_CIPHER_find", to: "GRPC_SHADOW_sk_SSL_CIPHER_find"),
        // .define("sk_SSL_CIPHER_find", to: "GRPC_SHADOW_sk_SSL_CIPHER_find"),
        // .define("sk_SSL_CIPHER_find", to: "GRPC_SHADOW_sk_SSL_CIPHER_find"),
        // .define("sk_SSL_CIPHER_new_null", to: "GRPC_SHADOW_sk_SSL_CIPHER_new_null"),
        // .define("sk_SSL_CIPHER_new_null", to: "GRPC_SHADOW_sk_SSL_CIPHER_new_null"),
        // .define("sk_SSL_CIPHER_new_null", to: "GRPC_SHADOW_sk_SSL_CIPHER_new_null"),
        // .define("sk_SSL_CIPHER_num", to: "GRPC_SHADOW_sk_SSL_CIPHER_num"),
        // .define("sk_SSL_CIPHER_num", to: "GRPC_SHADOW_sk_SSL_CIPHER_num"),
        // .define("sk_SSL_CIPHER_num", to: "GRPC_SHADOW_sk_SSL_CIPHER_num"),
        // .define("sk_SSL_CIPHER_num", to: "GRPC_SHADOW_sk_SSL_CIPHER_num"),
        // .define("sk_SSL_CIPHER_push", to: "GRPC_SHADOW_sk_SSL_CIPHER_push"),
        // .define("sk_SSL_CIPHER_push", to: "GRPC_SHADOW_sk_SSL_CIPHER_push"),
        // .define("sk_SSL_CIPHER_push", to: "GRPC_SHADOW_sk_SSL_CIPHER_push"),
        // .define("sk_SSL_CIPHER_value", to: "GRPC_SHADOW_sk_SSL_CIPHER_value"),
        // .define("sk_SSL_CIPHER_value", to: "GRPC_SHADOW_sk_SSL_CIPHER_value"),
        // .define("sk_value", to: "GRPC_SHADOW_sk_value"),
        // .define("sk_X509_call_free_func", to: "GRPC_SHADOW_sk_X509_call_free_func"),
        // .define("sk_X509_NAME_call_cmp_func", to: "GRPC_SHADOW_sk_X509_NAME_call_cmp_func"),
        // .define("sk_X509_NAME_call_copy_func", to: "GRPC_SHADOW_sk_X509_NAME_call_copy_func"),
        // .define("sk_X509_NAME_call_free_func", to: "GRPC_SHADOW_sk_X509_NAME_call_free_func"),
        // .define("sk_X509_NAME_call_free_func", to: "GRPC_SHADOW_sk_X509_NAME_call_free_func"),
        // .define("sk_X509_NAME_deep_copy", to: "GRPC_SHADOW_sk_X509_NAME_deep_copy"),
        // .define("sk_X509_NAME_find", to: "GRPC_SHADOW_sk_X509_NAME_find"),
        // .define("sk_X509_NAME_free", to: "GRPC_SHADOW_sk_X509_NAME_free"),
        // .define("sk_X509_NAME_new", to: "GRPC_SHADOW_sk_X509_NAME_new"),
        // .define("sk_X509_NAME_new_null", to: "GRPC_SHADOW_sk_X509_NAME_new_null"),
        // .define("sk_X509_NAME_new_null", to: "GRPC_SHADOW_sk_X509_NAME_new_null"),
        // .define("sk_X509_NAME_pop_free", to: "GRPC_SHADOW_sk_X509_NAME_pop_free"),
        // .define("sk_X509_NAME_pop_free", to: "GRPC_SHADOW_sk_X509_NAME_pop_free"),
        // .define("sk_X509_NAME_push", to: "GRPC_SHADOW_sk_X509_NAME_push"),
        // .define("sk_X509_NAME_set_cmp_func", to: "GRPC_SHADOW_sk_X509_NAME_set_cmp_func"),
        // .define("sk_X509_NAME_sort", to: "GRPC_SHADOW_sk_X509_NAME_sort"),
        // .define("sk_X509_new_null", to: "GRPC_SHADOW_sk_X509_new_null"),
        // .define("sk_X509_num", to: "GRPC_SHADOW_sk_X509_num"),
        // .define("sk_X509_pop_free", to: "GRPC_SHADOW_sk_X509_pop_free"),
        // .define("sk_X509_shift", to: "GRPC_SHADOW_sk_X509_shift"),
        // .define("sk_X509_value", to: "GRPC_SHADOW_sk_X509_value"),
        // .define("sk_zero", to: "GRPC_SHADOW_sk_zero"),
        // .define("SPAKE2_CTX_free", to: "GRPC_SHADOW_SPAKE2_CTX_free"),
        // .define("SPAKE2_CTX_new", to: "GRPC_SHADOW_SPAKE2_CTX_new"),
        // .define("SPAKE2_generate_msg", to: "GRPC_SHADOW_SPAKE2_generate_msg"),
        // .define("SPAKE2_process_msg", to: "GRPC_SHADOW_SPAKE2_process_msg"),
        // .define("SSL_accept", to: "GRPC_SHADOW_SSL_accept"),
        // .define("SSL_add0_chain_cert", to: "GRPC_SHADOW_SSL_add0_chain_cert"),
        // .define("SSL_add1_chain_cert", to: "GRPC_SHADOW_SSL_add1_chain_cert"),
        // .define("SSL_add_client_CA", to: "GRPC_SHADOW_SSL_add_client_CA"),
        // .define("SSL_add_file_cert_subjects_to_stack", to: "GRPC_SHADOW_SSL_add_file_cert_subjects_to_stack"),
        // .define("SSL_alert_desc_string", to: "GRPC_SHADOW_SSL_alert_desc_string"),
        // .define("SSL_alert_desc_string_long", to: "GRPC_SHADOW_SSL_alert_desc_string_long"),
        // .define("SSL_alert_from_verify_result", to: "GRPC_SHADOW_SSL_alert_from_verify_result"),
        // .define("SSL_alert_type_string", to: "GRPC_SHADOW_SSL_alert_type_string"),
        // .define("SSL_alert_type_string_long", to: "GRPC_SHADOW_SSL_alert_type_string_long"),
        // .define("SSL_cache_hit", to: "GRPC_SHADOW_SSL_cache_hit"),
        // .define("SSL_certs_clear", to: "GRPC_SHADOW_SSL_certs_clear"),
        // .define("SSL_check_private_key", to: "GRPC_SHADOW_SSL_check_private_key"),
        // .define("SSL_CIPHER_description", to: "GRPC_SHADOW_SSL_CIPHER_description"),
        // .define("SSL_CIPHER_get_auth_nid", to: "GRPC_SHADOW_SSL_CIPHER_get_auth_nid"),
        // .define("SSL_CIPHER_get_bits", to: "GRPC_SHADOW_SSL_CIPHER_get_bits"),
        // .define("SSL_CIPHER_get_cipher_nid", to: "GRPC_SHADOW_SSL_CIPHER_get_cipher_nid"),
        // .define("SSL_CIPHER_get_digest_nid", to: "GRPC_SHADOW_SSL_CIPHER_get_digest_nid"),
        // .define("SSL_CIPHER_get_id", to: "GRPC_SHADOW_SSL_CIPHER_get_id"),
        // .define("SSL_CIPHER_get_kx_name", to: "GRPC_SHADOW_SSL_CIPHER_get_kx_name"),
        // .define("SSL_CIPHER_get_kx_nid", to: "GRPC_SHADOW_SSL_CIPHER_get_kx_nid"),
        // .define("SSL_CIPHER_get_max_version", to: "GRPC_SHADOW_SSL_CIPHER_get_max_version"),
        // .define("SSL_CIPHER_get_min_version", to: "GRPC_SHADOW_SSL_CIPHER_get_min_version"),
        // .define("SSL_CIPHER_get_name", to: "GRPC_SHADOW_SSL_CIPHER_get_name"),
        // .define("SSL_CIPHER_get_prf_nid", to: "GRPC_SHADOW_SSL_CIPHER_get_prf_nid"),
        // .define("SSL_CIPHER_get_rfc_name", to: "GRPC_SHADOW_SSL_CIPHER_get_rfc_name"),
        // .define("SSL_CIPHER_get_value", to: "GRPC_SHADOW_SSL_CIPHER_get_value"),
        // .define("SSL_CIPHER_get_version", to: "GRPC_SHADOW_SSL_CIPHER_get_version"),
        // .define("SSL_CIPHER_is_aead", to: "GRPC_SHADOW_SSL_CIPHER_is_aead"),
        // .define("SSL_CIPHER_is_block_cipher", to: "GRPC_SHADOW_SSL_CIPHER_is_block_cipher"),
        // .define("SSL_CIPHER_standard_name", to: "GRPC_SHADOW_SSL_CIPHER_standard_name"),
        // .define("SSL_clear", to: "GRPC_SHADOW_SSL_clear"),
        // .define("SSL_clear_chain_certs", to: "GRPC_SHADOW_SSL_clear_chain_certs"),
        // .define("SSL_clear_mode", to: "GRPC_SHADOW_SSL_clear_mode"),
        // .define("SSL_clear_options", to: "GRPC_SHADOW_SSL_clear_options"),
        // .define("SSL_COMP_add_compression_method", to: "GRPC_SHADOW_SSL_COMP_add_compression_method"),
        // .define("SSL_COMP_free_compression_methods", to: "GRPC_SHADOW_SSL_COMP_free_compression_methods"),
        // .define("SSL_COMP_get0_name", to: "GRPC_SHADOW_SSL_COMP_get0_name"),
        // .define("SSL_COMP_get_compression_methods", to: "GRPC_SHADOW_SSL_COMP_get_compression_methods"),
        // .define("SSL_COMP_get_id", to: "GRPC_SHADOW_SSL_COMP_get_id"),
        // .define("SSL_COMP_get_name", to: "GRPC_SHADOW_SSL_COMP_get_name"),
        // .define("SSL_connect", to: "GRPC_SHADOW_SSL_connect"),
        // .define("SSL_CTX_add0_chain_cert", to: "GRPC_SHADOW_SSL_CTX_add0_chain_cert"),
        // .define("SSL_CTX_add1_chain_cert", to: "GRPC_SHADOW_SSL_CTX_add1_chain_cert"),
        // .define("SSL_CTX_add_cert_compression_alg", to: "GRPC_SHADOW_SSL_CTX_add_cert_compression_alg"),
        // .define("SSL_CTX_add_client_CA", to: "GRPC_SHADOW_SSL_CTX_add_client_CA"),
        // .define("SSL_CTX_add_extra_chain_cert", to: "GRPC_SHADOW_SSL_CTX_add_extra_chain_cert"),
        // .define("SSL_CTX_add_session", to: "GRPC_SHADOW_SSL_CTX_add_session"),
        // .define("SSL_CTX_check_private_key", to: "GRPC_SHADOW_SSL_CTX_check_private_key"),
        // .define("SSL_CTX_cipher_in_group", to: "GRPC_SHADOW_SSL_CTX_cipher_in_group"),
        // .define("SSL_CTX_clear_chain_certs", to: "GRPC_SHADOW_SSL_CTX_clear_chain_certs"),
        // .define("SSL_CTX_clear_extra_chain_certs", to: "GRPC_SHADOW_SSL_CTX_clear_extra_chain_certs"),
        // .define("SSL_CTX_clear_mode", to: "GRPC_SHADOW_SSL_CTX_clear_mode"),
        // .define("SSL_CTX_clear_options", to: "GRPC_SHADOW_SSL_CTX_clear_options"),
        // .define("SSL_CTX_enable_ocsp_stapling", to: "GRPC_SHADOW_SSL_CTX_enable_ocsp_stapling"),
        // .define("SSL_CTX_enable_signed_cert_timestamps", to: "GRPC_SHADOW_SSL_CTX_enable_signed_cert_timestamps"),
        // .define("SSL_CTX_enable_tls_channel_id", to: "GRPC_SHADOW_SSL_CTX_enable_tls_channel_id"),
        // .define("SSL_CTX_flush_sessions", to: "GRPC_SHADOW_SSL_CTX_flush_sessions"),
        // .define("SSL_CTX_free", to: "GRPC_SHADOW_SSL_CTX_free"),
        // .define("SSL_CTX_get0_certificate", to: "GRPC_SHADOW_SSL_CTX_get0_certificate"),
        // .define("SSL_CTX_get0_chain_certs", to: "GRPC_SHADOW_SSL_CTX_get0_chain_certs"),
        // .define("SSL_CTX_get0_param", to: "GRPC_SHADOW_SSL_CTX_get0_param"),
        // .define("SSL_CTX_get0_privatekey", to: "GRPC_SHADOW_SSL_CTX_get0_privatekey"),
        // .define("SSL_CTX_get_cert_store", to: "GRPC_SHADOW_SSL_CTX_get_cert_store"),
        // .define("SSL_CTX_get_channel_id_cb", to: "GRPC_SHADOW_SSL_CTX_get_channel_id_cb"),
        // .define("SSL_CTX_get_ciphers", to: "GRPC_SHADOW_SSL_CTX_get_ciphers"),
        // .define("SSL_CTX_get_client_CA_list", to: "GRPC_SHADOW_SSL_CTX_get_client_CA_list"),
        // .define("SSL_CTX_get_default_passwd_cb", to: "GRPC_SHADOW_SSL_CTX_get_default_passwd_cb"),
        // .define("SSL_CTX_get_default_passwd_cb_userdata", to: "GRPC_SHADOW_SSL_CTX_get_default_passwd_cb_userdata"),
        // .define("SSL_CTX_get_ex_data", to: "GRPC_SHADOW_SSL_CTX_get_ex_data"),
        // .define("SSL_CTX_get_ex_new_index", to: "GRPC_SHADOW_SSL_CTX_get_ex_new_index"),
        // .define("SSL_CTX_get_extra_chain_certs", to: "GRPC_SHADOW_SSL_CTX_get_extra_chain_certs"),
        // .define("SSL_CTX_get_info_callback", to: "GRPC_SHADOW_SSL_CTX_get_info_callback"),
        // .define("SSL_CTX_get_keylog_callback", to: "GRPC_SHADOW_SSL_CTX_get_keylog_callback"),
        // .define("SSL_CTX_get_max_cert_list", to: "GRPC_SHADOW_SSL_CTX_get_max_cert_list"),
        // .define("SSL_CTX_get_max_proto_version", to: "GRPC_SHADOW_SSL_CTX_get_max_proto_version"),
        // .define("SSL_CTX_get_min_proto_version", to: "GRPC_SHADOW_SSL_CTX_get_min_proto_version"),
        // .define("SSL_CTX_get_mode", to: "GRPC_SHADOW_SSL_CTX_get_mode"),
        // .define("SSL_CTX_get_options", to: "GRPC_SHADOW_SSL_CTX_get_options"),
        // .define("SSL_CTX_get_quiet_shutdown", to: "GRPC_SHADOW_SSL_CTX_get_quiet_shutdown"),
        // .define("SSL_CTX_get_read_ahead", to: "GRPC_SHADOW_SSL_CTX_get_read_ahead"),
        // .define("SSL_CTX_get_session_cache_mode", to: "GRPC_SHADOW_SSL_CTX_get_session_cache_mode"),
        // .define("SSL_CTX_get_timeout", to: "GRPC_SHADOW_SSL_CTX_get_timeout"),
        // .define("SSL_CTX_get_tlsext_ticket_keys", to: "GRPC_SHADOW_SSL_CTX_get_tlsext_ticket_keys"),
        // .define("SSL_CTX_get_verify_callback", to: "GRPC_SHADOW_SSL_CTX_get_verify_callback"),
        // .define("SSL_CTX_get_verify_depth", to: "GRPC_SHADOW_SSL_CTX_get_verify_depth"),
        // .define("SSL_CTX_get_verify_mode", to: "GRPC_SHADOW_SSL_CTX_get_verify_mode"),
        // .define("SSL_CTX_load_verify_locations", to: "GRPC_SHADOW_SSL_CTX_load_verify_locations"),
        // .define("SSL_CTX_need_tmp_RSA", to: "GRPC_SHADOW_SSL_CTX_need_tmp_RSA"),
        // .define("SSL_CTX_new", to: "GRPC_SHADOW_SSL_CTX_new"),
        // .define("SSL_CTX_remove_session", to: "GRPC_SHADOW_SSL_CTX_remove_session"),
        // .define("SSL_CTX_sess_accept", to: "GRPC_SHADOW_SSL_CTX_sess_accept"),
        // .define("SSL_CTX_sess_accept_good", to: "GRPC_SHADOW_SSL_CTX_sess_accept_good"),
        // .define("SSL_CTX_sess_accept_renegotiate", to: "GRPC_SHADOW_SSL_CTX_sess_accept_renegotiate"),
        // .define("SSL_CTX_sess_cache_full", to: "GRPC_SHADOW_SSL_CTX_sess_cache_full"),
        // .define("SSL_CTX_sess_cb_hits", to: "GRPC_SHADOW_SSL_CTX_sess_cb_hits"),
        // .define("SSL_CTX_sess_connect", to: "GRPC_SHADOW_SSL_CTX_sess_connect"),
        // .define("SSL_CTX_sess_connect_good", to: "GRPC_SHADOW_SSL_CTX_sess_connect_good"),
        // .define("SSL_CTX_sess_connect_renegotiate", to: "GRPC_SHADOW_SSL_CTX_sess_connect_renegotiate"),
        // .define("SSL_CTX_sess_get_cache_size", to: "GRPC_SHADOW_SSL_CTX_sess_get_cache_size"),
        // .define("SSL_CTX_sess_get_get_cb", to: "GRPC_SHADOW_SSL_CTX_sess_get_get_cb"),
        // .define("SSL_CTX_sess_get_new_cb", to: "GRPC_SHADOW_SSL_CTX_sess_get_new_cb"),
        // .define("SSL_CTX_sess_get_remove_cb", to: "GRPC_SHADOW_SSL_CTX_sess_get_remove_cb"),
        // .define("SSL_CTX_sess_hits", to: "GRPC_SHADOW_SSL_CTX_sess_hits"),
        // .define("SSL_CTX_sess_misses", to: "GRPC_SHADOW_SSL_CTX_sess_misses"),
        // .define("SSL_CTX_sess_number", to: "GRPC_SHADOW_SSL_CTX_sess_number"),
        // .define("SSL_CTX_sess_set_cache_size", to: "GRPC_SHADOW_SSL_CTX_sess_set_cache_size"),
        // .define("SSL_CTX_sess_set_get_cb", to: "GRPC_SHADOW_SSL_CTX_sess_set_get_cb"),
        // .define("SSL_CTX_sess_set_new_cb", to: "GRPC_SHADOW_SSL_CTX_sess_set_new_cb"),
        // .define("SSL_CTX_sess_set_remove_cb", to: "GRPC_SHADOW_SSL_CTX_sess_set_remove_cb"),
        // .define("SSL_CTX_sess_timeouts", to: "GRPC_SHADOW_SSL_CTX_sess_timeouts"),
        // .define("SSL_CTX_set0_buffer_pool", to: "GRPC_SHADOW_SSL_CTX_set0_buffer_pool"),
        // .define("SSL_CTX_set0_chain", to: "GRPC_SHADOW_SSL_CTX_set0_chain"),
        // .define("SSL_CTX_set0_client_CAs", to: "GRPC_SHADOW_SSL_CTX_set0_client_CAs"),
        // .define("SSL_CTX_set0_verify_cert_store", to: "GRPC_SHADOW_SSL_CTX_set0_verify_cert_store"),
        // .define("SSL_CTX_set1_chain", to: "GRPC_SHADOW_SSL_CTX_set1_chain"),
        // .define("SSL_CTX_set1_curves", to: "GRPC_SHADOW_SSL_CTX_set1_curves"),
        // .define("SSL_CTX_set1_curves_list", to: "GRPC_SHADOW_SSL_CTX_set1_curves_list"),
        // .define("SSL_CTX_set1_param", to: "GRPC_SHADOW_SSL_CTX_set1_param"),
        // .define("SSL_CTX_set1_sigalgs", to: "GRPC_SHADOW_SSL_CTX_set1_sigalgs"),
        // .define("SSL_CTX_set1_sigalgs_list", to: "GRPC_SHADOW_SSL_CTX_set1_sigalgs_list"),
        // .define("SSL_CTX_set1_tls_channel_id", to: "GRPC_SHADOW_SSL_CTX_set1_tls_channel_id"),
        // .define("SSL_CTX_set1_verify_cert_store", to: "GRPC_SHADOW_SSL_CTX_set1_verify_cert_store"),
        // .define("SSL_CTX_set_allow_unknown_alpn_protos", to: "GRPC_SHADOW_SSL_CTX_set_allow_unknown_alpn_protos"),
        // .define("SSL_CTX_set_alpn_protos", to: "GRPC_SHADOW_SSL_CTX_set_alpn_protos"),
        // .define("SSL_CTX_set_alpn_select_cb", to: "GRPC_SHADOW_SSL_CTX_set_alpn_select_cb"),
        // .define("SSL_CTX_set_cert_cb", to: "GRPC_SHADOW_SSL_CTX_set_cert_cb"),
        // .define("SSL_CTX_set_cert_store", to: "GRPC_SHADOW_SSL_CTX_set_cert_store"),
        // .define("SSL_CTX_set_cert_verify_callback", to: "GRPC_SHADOW_SSL_CTX_set_cert_verify_callback"),
        // .define("SSL_CTX_set_chain_and_key", to: "GRPC_SHADOW_SSL_CTX_set_chain_and_key"),
        // .define("SSL_CTX_set_channel_id_cb", to: "GRPC_SHADOW_SSL_CTX_set_channel_id_cb"),
        // .define("SSL_CTX_set_cipher_list", to: "GRPC_SHADOW_SSL_CTX_set_cipher_list"),
        // .define("SSL_CTX_set_client_CA_list", to: "GRPC_SHADOW_SSL_CTX_set_client_CA_list"),
        // .define("SSL_CTX_set_client_cert_cb", to: "GRPC_SHADOW_SSL_CTX_set_client_cert_cb"),
        // .define("SSL_CTX_set_current_time_cb", to: "GRPC_SHADOW_SSL_CTX_set_current_time_cb"),
        // .define("SSL_CTX_set_custom_verify", to: "GRPC_SHADOW_SSL_CTX_set_custom_verify"),
        // .define("SSL_CTX_set_default_passwd_cb", to: "GRPC_SHADOW_SSL_CTX_set_default_passwd_cb"),
        // .define("SSL_CTX_set_default_passwd_cb_userdata", to: "GRPC_SHADOW_SSL_CTX_set_default_passwd_cb_userdata"),
        // .define("SSL_CTX_set_default_verify_paths", to: "GRPC_SHADOW_SSL_CTX_set_default_verify_paths"),
        // .define("SSL_CTX_set_dos_protection_cb", to: "GRPC_SHADOW_SSL_CTX_set_dos_protection_cb"),
        // .define("SSL_CTX_set_early_data_enabled", to: "GRPC_SHADOW_SSL_CTX_set_early_data_enabled"),
        // .define("SSL_CTX_set_ed25519_enabled", to: "GRPC_SHADOW_SSL_CTX_set_ed25519_enabled"),
        // .define("SSL_CTX_set_ex_data", to: "GRPC_SHADOW_SSL_CTX_set_ex_data"),
        // .define("SSL_CTX_set_false_start_allowed_without_alpn", to: "GRPC_SHADOW_SSL_CTX_set_false_start_allowed_without_alpn"),
        // .define("SSL_CTX_set_grease_enabled", to: "GRPC_SHADOW_SSL_CTX_set_grease_enabled"),
        // .define("SSL_CTX_set_ignore_tls13_downgrade", to: "GRPC_SHADOW_SSL_CTX_set_ignore_tls13_downgrade"),
        // .define("SSL_CTX_set_info_callback", to: "GRPC_SHADOW_SSL_CTX_set_info_callback"),
        // .define("SSL_CTX_set_keylog_callback", to: "GRPC_SHADOW_SSL_CTX_set_keylog_callback"),
        // .define("SSL_CTX_set_max_cert_list", to: "GRPC_SHADOW_SSL_CTX_set_max_cert_list"),
        // .define("SSL_CTX_set_max_proto_version", to: "GRPC_SHADOW_SSL_CTX_set_max_proto_version"),
        // .define("SSL_CTX_set_max_send_fragment", to: "GRPC_SHADOW_SSL_CTX_set_max_send_fragment"),
        // .define("SSL_CTX_set_min_proto_version", to: "GRPC_SHADOW_SSL_CTX_set_min_proto_version"),
        // .define("SSL_CTX_set_mode", to: "GRPC_SHADOW_SSL_CTX_set_mode"),
        // .define("SSL_CTX_set_msg_callback", to: "GRPC_SHADOW_SSL_CTX_set_msg_callback"),
        // .define("SSL_CTX_set_msg_callback_arg", to: "GRPC_SHADOW_SSL_CTX_set_msg_callback_arg"),
        // .define("SSL_CTX_set_next_protos_advertised_cb", to: "GRPC_SHADOW_SSL_CTX_set_next_protos_advertised_cb"),
        // .define("SSL_CTX_set_next_proto_select_cb", to: "GRPC_SHADOW_SSL_CTX_set_next_proto_select_cb"),
        // .define("SSL_CTX_set_ocsp_response", to: "GRPC_SHADOW_SSL_CTX_set_ocsp_response"),
        // .define("SSL_CTX_set_options", to: "GRPC_SHADOW_SSL_CTX_set_options"),
        // .define("SSL_CTX_set_private_key_method", to: "GRPC_SHADOW_SSL_CTX_set_private_key_method"),
        // .define("SSL_CTX_set_psk_client_callback", to: "GRPC_SHADOW_SSL_CTX_set_psk_client_callback"),
        // .define("SSL_CTX_set_psk_server_callback", to: "GRPC_SHADOW_SSL_CTX_set_psk_server_callback"),
        // .define("SSL_CTX_set_purpose", to: "GRPC_SHADOW_SSL_CTX_set_purpose"),
        // .define("SSL_CTX_set_quic_method", to: "GRPC_SHADOW_SSL_CTX_set_quic_method"),
        // .define("SSL_CTX_set_quiet_shutdown", to: "GRPC_SHADOW_SSL_CTX_set_quiet_shutdown"),
        // .define("SSL_CTX_set_read_ahead", to: "GRPC_SHADOW_SSL_CTX_set_read_ahead"),
        // .define("SSL_CTX_set_retain_only_sha256_of_client_certs", to: "GRPC_SHADOW_SSL_CTX_set_retain_only_sha256_of_client_certs"),
        // .define("SSL_CTX_set_reverify_on_resume", to: "GRPC_SHADOW_SSL_CTX_set_reverify_on_resume"),
        // .define("SSL_CTX_set_select_certificate_cb", to: "GRPC_SHADOW_SSL_CTX_set_select_certificate_cb"),
        // .define("SSL_CTX_set_session_cache_mode", to: "GRPC_SHADOW_SSL_CTX_set_session_cache_mode"),
        // .define("SSL_CTX_set_session_id_context", to: "GRPC_SHADOW_SSL_CTX_set_session_id_context"),
        // .define("SSL_CTX_set_session_psk_dhe_timeout", to: "GRPC_SHADOW_SSL_CTX_set_session_psk_dhe_timeout"),
        // .define("SSL_CTX_set_signed_cert_timestamp_list", to: "GRPC_SHADOW_SSL_CTX_set_signed_cert_timestamp_list"),
        // .define("SSL_CTX_set_signing_algorithm_prefs", to: "GRPC_SHADOW_SSL_CTX_set_signing_algorithm_prefs"),
        // .define("SSL_CTX_set_srtp_profiles", to: "GRPC_SHADOW_SSL_CTX_set_srtp_profiles"),
        // .define("SSL_CTX_set_strict_cipher_list", to: "GRPC_SHADOW_SSL_CTX_set_strict_cipher_list"),
        // .define("SSL_CTX_set_ticket_aead_method", to: "GRPC_SHADOW_SSL_CTX_set_ticket_aead_method"),
        // .define("SSL_CTX_set_timeout", to: "GRPC_SHADOW_SSL_CTX_set_timeout"),
        // .define("SSL_CTX_set_tls_channel_id_enabled", to: "GRPC_SHADOW_SSL_CTX_set_tls_channel_id_enabled"),
        // .define("SSL_CTX_set_tlsext_servername_arg", to: "GRPC_SHADOW_SSL_CTX_set_tlsext_servername_arg"),
        // .define("SSL_CTX_set_tlsext_servername_callback", to: "GRPC_SHADOW_SSL_CTX_set_tlsext_servername_callback"),
        // .define("SSL_CTX_set_tlsext_status_arg", to: "GRPC_SHADOW_SSL_CTX_set_tlsext_status_arg"),
        // .define("SSL_CTX_set_tlsext_status_cb", to: "GRPC_SHADOW_SSL_CTX_set_tlsext_status_cb"),
        // .define("SSL_CTX_set_tlsext_ticket_key_cb", to: "GRPC_SHADOW_SSL_CTX_set_tlsext_ticket_key_cb"),
        // .define("SSL_CTX_set_tlsext_ticket_keys", to: "GRPC_SHADOW_SSL_CTX_set_tlsext_ticket_keys"),
        // .define("SSL_CTX_set_tlsext_use_srtp", to: "GRPC_SHADOW_SSL_CTX_set_tlsext_use_srtp"),
        // .define("SSL_CTX_set_tmp_dh", to: "GRPC_SHADOW_SSL_CTX_set_tmp_dh"),
        // .define("SSL_CTX_set_tmp_dh_callback", to: "GRPC_SHADOW_SSL_CTX_set_tmp_dh_callback"),
        // .define("SSL_CTX_set_tmp_ecdh", to: "GRPC_SHADOW_SSL_CTX_set_tmp_ecdh"),
        // .define("SSL_CTX_set_tmp_rsa", to: "GRPC_SHADOW_SSL_CTX_set_tmp_rsa"),
        // .define("SSL_CTX_set_tmp_rsa_callback", to: "GRPC_SHADOW_SSL_CTX_set_tmp_rsa_callback"),
        // .define("SSL_CTX_set_trust", to: "GRPC_SHADOW_SSL_CTX_set_trust"),
        // .define("SSL_CTX_set_verify", to: "GRPC_SHADOW_SSL_CTX_set_verify"),
        // .define("SSL_CTX_set_verify_algorithm_prefs", to: "GRPC_SHADOW_SSL_CTX_set_verify_algorithm_prefs"),
        // .define("SSL_CTX_set_verify_depth", to: "GRPC_SHADOW_SSL_CTX_set_verify_depth"),
        // .define("SSL_CTX_up_ref", to: "GRPC_SHADOW_SSL_CTX_up_ref"),
        // .define("SSL_CTX_use_certificate", to: "GRPC_SHADOW_SSL_CTX_use_certificate"),
        // .define("SSL_CTX_use_certificate_ASN1", to: "GRPC_SHADOW_SSL_CTX_use_certificate_ASN1"),
        // .define("SSL_CTX_use_certificate_chain_file", to: "GRPC_SHADOW_SSL_CTX_use_certificate_chain_file"),
        // .define("SSL_CTX_use_certificate_file", to: "GRPC_SHADOW_SSL_CTX_use_certificate_file"),
        // .define("SSL_CTX_use_PrivateKey", to: "GRPC_SHADOW_SSL_CTX_use_PrivateKey"),
        // .define("SSL_CTX_use_PrivateKey_ASN1", to: "GRPC_SHADOW_SSL_CTX_use_PrivateKey_ASN1"),
        // .define("SSL_CTX_use_PrivateKey_file", to: "GRPC_SHADOW_SSL_CTX_use_PrivateKey_file"),
        // .define("SSL_CTX_use_psk_identity_hint", to: "GRPC_SHADOW_SSL_CTX_use_psk_identity_hint"),
        // .define("SSL_CTX_use_RSAPrivateKey", to: "GRPC_SHADOW_SSL_CTX_use_RSAPrivateKey"),
        // .define("SSL_CTX_use_RSAPrivateKey_ASN1", to: "GRPC_SHADOW_SSL_CTX_use_RSAPrivateKey_ASN1"),
        // .define("SSL_CTX_use_RSAPrivateKey_file", to: "GRPC_SHADOW_SSL_CTX_use_RSAPrivateKey_file"),
        // .define("SSL_cutthrough_complete", to: "GRPC_SHADOW_SSL_cutthrough_complete"),
        // .define("SSL_delegated_credential_used", to: "GRPC_SHADOW_SSL_delegated_credential_used"),
        // .define("SSL_do_handshake", to: "GRPC_SHADOW_SSL_do_handshake"),
        // .define("SSL_dup_CA_list", to: "GRPC_SHADOW_SSL_dup_CA_list"),
        // .define("SSL_early_callback_ctx_extension_get", to: "GRPC_SHADOW_SSL_early_callback_ctx_extension_get"),
        // .define("SSL_early_data_accepted", to: "GRPC_SHADOW_SSL_early_data_accepted"),
        // .define("SSLeay", to: "GRPC_SHADOW_SSLeay"),
        // .define("SSLeay_version", to: "GRPC_SHADOW_SSLeay_version"),
        // .define("SSL_enable_ocsp_stapling", to: "GRPC_SHADOW_SSL_enable_ocsp_stapling"),
        // .define("SSL_enable_signed_cert_timestamps", to: "GRPC_SHADOW_SSL_enable_signed_cert_timestamps"),
        // .define("SSL_enable_tls_channel_id", to: "GRPC_SHADOW_SSL_enable_tls_channel_id"),
        // .define("SSL_error_description", to: "GRPC_SHADOW_SSL_error_description"),
        // .define("SSL_export_keying_material", to: "GRPC_SHADOW_SSL_export_keying_material"),
        // .define("SSL_free", to: "GRPC_SHADOW_SSL_free"),
        // .define("SSL_generate_key_block", to: "GRPC_SHADOW_SSL_generate_key_block"),
        // .define("SSL_get0_alpn_selected", to: "GRPC_SHADOW_SSL_get0_alpn_selected"),
        // .define("SSL_get0_certificate_types", to: "GRPC_SHADOW_SSL_get0_certificate_types"),
        // .define("SSL_get0_chain_certs", to: "GRPC_SHADOW_SSL_get0_chain_certs"),
        // .define("SSL_get0_next_proto_negotiated", to: "GRPC_SHADOW_SSL_get0_next_proto_negotiated"),
        // .define("SSL_get0_ocsp_response", to: "GRPC_SHADOW_SSL_get0_ocsp_response"),
        // .define("SSL_get0_param", to: "GRPC_SHADOW_SSL_get0_param"),
        // .define("SSL_get0_peer_certificates", to: "GRPC_SHADOW_SSL_get0_peer_certificates"),
        // .define("SSL_get0_peer_verify_algorithms", to: "GRPC_SHADOW_SSL_get0_peer_verify_algorithms"),
        // .define("SSL_get0_server_requested_CAs", to: "GRPC_SHADOW_SSL_get0_server_requested_CAs"),
        // .define("SSL_get0_session_id_context", to: "GRPC_SHADOW_SSL_get0_session_id_context"),
        // .define("SSL_get0_signed_cert_timestamp_list", to: "GRPC_SHADOW_SSL_get0_signed_cert_timestamp_list"),
        // .define("SSL_get1_session", to: "GRPC_SHADOW_SSL_get1_session"),
        // .define("SSL_get_certificate", to: "GRPC_SHADOW_SSL_get_certificate"),
        // .define("SSL_get_cipher_by_value", to: "GRPC_SHADOW_SSL_get_cipher_by_value"),
        // .define("SSL_get_cipher_list", to: "GRPC_SHADOW_SSL_get_cipher_list"),
        // .define("SSL_get_ciphers", to: "GRPC_SHADOW_SSL_get_ciphers"),
        // .define("SSL_get_client_CA_list", to: "GRPC_SHADOW_SSL_get_client_CA_list"),
        // .define("SSL_get_client_random", to: "GRPC_SHADOW_SSL_get_client_random"),
        // .define("SSL_get_current_cipher", to: "GRPC_SHADOW_SSL_get_current_cipher"),
        // .define("SSL_get_current_compression", to: "GRPC_SHADOW_SSL_get_current_compression"),
        // .define("SSL_get_current_expansion", to: "GRPC_SHADOW_SSL_get_current_expansion"),
        // .define("SSL_get_curve_id", to: "GRPC_SHADOW_SSL_get_curve_id"),
        // .define("SSL_get_curve_name", to: "GRPC_SHADOW_SSL_get_curve_name"),
        // .define("SSL_get_default_timeout", to: "GRPC_SHADOW_SSL_get_default_timeout"),
        // .define("SSL_get_early_data_reason", to: "GRPC_SHADOW_SSL_get_early_data_reason"),
        // .define("SSL_get_error", to: "GRPC_SHADOW_SSL_get_error"),
        // .define("SSL_get_ex_data", to: "GRPC_SHADOW_SSL_get_ex_data"),
        // .define("SSL_get_ex_data_X509_STORE_CTX_idx", to: "GRPC_SHADOW_SSL_get_ex_data_X509_STORE_CTX_idx"),
        // .define("SSL_get_ex_new_index", to: "GRPC_SHADOW_SSL_get_ex_new_index"),
        // .define("SSL_get_extms_support", to: "GRPC_SHADOW_SSL_get_extms_support"),
        // .define("SSL_get_fd", to: "GRPC_SHADOW_SSL_get_fd"),
        // .define("SSL_get_finished", to: "GRPC_SHADOW_SSL_get_finished"),
        // .define("SSL_get_info_callback", to: "GRPC_SHADOW_SSL_get_info_callback"),
        // .define("SSL_get_ivs", to: "GRPC_SHADOW_SSL_get_ivs"),
        // .define("SSL_get_key_block_len", to: "GRPC_SHADOW_SSL_get_key_block_len"),
        // .define("SSL_get_max_cert_list", to: "GRPC_SHADOW_SSL_get_max_cert_list"),
        // .define("SSL_get_max_proto_version", to: "GRPC_SHADOW_SSL_get_max_proto_version"),
        // .define("SSL_get_min_proto_version", to: "GRPC_SHADOW_SSL_get_min_proto_version"),
        // .define("SSL_get_mode", to: "GRPC_SHADOW_SSL_get_mode"),
        // .define("SSL_get_negotiated_token_binding_param", to: "GRPC_SHADOW_SSL_get_negotiated_token_binding_param"),
        // .define("SSL_get_options", to: "GRPC_SHADOW_SSL_get_options"),
        // .define("SSL_get_peer_cert_chain", to: "GRPC_SHADOW_SSL_get_peer_cert_chain"),
        // .define("SSL_get_peer_certificate", to: "GRPC_SHADOW_SSL_get_peer_certificate"),
        // .define("SSL_get_peer_finished", to: "GRPC_SHADOW_SSL_get_peer_finished"),
        // .define("SSL_get_peer_full_cert_chain", to: "GRPC_SHADOW_SSL_get_peer_full_cert_chain"),
        // .define("SSL_get_peer_quic_transport_params", to: "GRPC_SHADOW_SSL_get_peer_quic_transport_params"),
        // .define("SSL_get_peer_signature_algorithm", to: "GRPC_SHADOW_SSL_get_peer_signature_algorithm"),
        // .define("SSL_get_pending_cipher", to: "GRPC_SHADOW_SSL_get_pending_cipher"),
        // .define("SSL_get_privatekey", to: "GRPC_SHADOW_SSL_get_privatekey"),
        // .define("SSL_get_psk_identity", to: "GRPC_SHADOW_SSL_get_psk_identity"),
        // .define("SSL_get_psk_identity_hint", to: "GRPC_SHADOW_SSL_get_psk_identity_hint"),
        // .define("SSL_get_quiet_shutdown", to: "GRPC_SHADOW_SSL_get_quiet_shutdown"),
        // .define("SSL_get_rbio", to: "GRPC_SHADOW_SSL_get_rbio"),
        // .define("SSL_get_read_ahead", to: "GRPC_SHADOW_SSL_get_read_ahead"),
        // .define("SSL_get_read_sequence", to: "GRPC_SHADOW_SSL_get_read_sequence"),
        // .define("SSL_get_rfd", to: "GRPC_SHADOW_SSL_get_rfd"),
        // .define("SSL_get_secure_renegotiation_support", to: "GRPC_SHADOW_SSL_get_secure_renegotiation_support"),
        // .define("SSL_get_selected_srtp_profile", to: "GRPC_SHADOW_SSL_get_selected_srtp_profile"),
        // .define("SSL_get_servername", to: "GRPC_SHADOW_SSL_get_servername"),
        // .define("SSL_get_servername_type", to: "GRPC_SHADOW_SSL_get_servername_type"),
        // .define("SSL_get_server_random", to: "GRPC_SHADOW_SSL_get_server_random"),
        // .define("SSL_get_server_tmp_key", to: "GRPC_SHADOW_SSL_get_server_tmp_key"),
        // .define("SSL_get_session", to: "GRPC_SHADOW_SSL_get_session"),
        // .define("SSL_get_shared_ciphers", to: "GRPC_SHADOW_SSL_get_shared_ciphers"),
        // .define("SSL_get_shared_sigalgs", to: "GRPC_SHADOW_SSL_get_shared_sigalgs"),
        // .define("SSL_get_shutdown", to: "GRPC_SHADOW_SSL_get_shutdown"),
        // .define("SSL_get_signature_algorithm_digest", to: "GRPC_SHADOW_SSL_get_signature_algorithm_digest"),
        // .define("SSL_get_signature_algorithm_key_type", to: "GRPC_SHADOW_SSL_get_signature_algorithm_key_type"),
        // .define("SSL_get_signature_algorithm_name", to: "GRPC_SHADOW_SSL_get_signature_algorithm_name"),
        // .define("SSL_get_srtp_profiles", to: "GRPC_SHADOW_SSL_get_srtp_profiles"),
        // .define("SSL_get_SSL_CTX", to: "GRPC_SHADOW_SSL_get_SSL_CTX"),
        // .define("SSL_get_ticket_age_skew", to: "GRPC_SHADOW_SSL_get_ticket_age_skew"),
        // .define("SSL_get_tls_channel_id", to: "GRPC_SHADOW_SSL_get_tls_channel_id"),
        // .define("SSL_get_tlsext_status_ocsp_resp", to: "GRPC_SHADOW_SSL_get_tlsext_status_ocsp_resp"),
        // .define("SSL_get_tlsext_status_type", to: "GRPC_SHADOW_SSL_get_tlsext_status_type"),
        // .define("SSL_get_tls_unique", to: "GRPC_SHADOW_SSL_get_tls_unique"),
        // .define("SSL_get_verify_callback", to: "GRPC_SHADOW_SSL_get_verify_callback"),
        // .define("SSL_get_verify_depth", to: "GRPC_SHADOW_SSL_get_verify_depth"),
        // .define("SSL_get_verify_mode", to: "GRPC_SHADOW_SSL_get_verify_mode"),
        // .define("SSL_get_verify_result", to: "GRPC_SHADOW_SSL_get_verify_result"),
        // .define("SSL_get_version", to: "GRPC_SHADOW_SSL_get_version"),
        // .define("SSL_get_wbio", to: "GRPC_SHADOW_SSL_get_wbio"),
        // .define("SSL_get_wfd", to: "GRPC_SHADOW_SSL_get_wfd"),
        // .define("SSL_get_write_sequence", to: "GRPC_SHADOW_SSL_get_write_sequence"),
        // .define("SSL_in_early_data", to: "GRPC_SHADOW_SSL_in_early_data"),
        // .define("SSL_in_false_start", to: "GRPC_SHADOW_SSL_in_false_start"),
        // .define("SSL_in_init", to: "GRPC_SHADOW_SSL_in_init"),
        // .define("SSL_is_dtls", to: "GRPC_SHADOW_SSL_is_dtls"),
        // .define("SSL_is_init_finished", to: "GRPC_SHADOW_SSL_is_init_finished"),
        // .define("SSL_is_server", to: "GRPC_SHADOW_SSL_is_server"),
        // .define("SSL_is_signature_algorithm_rsa_pss", to: "GRPC_SHADOW_SSL_is_signature_algorithm_rsa_pss"),
        // .define("SSL_is_tls13_downgrade", to: "GRPC_SHADOW_SSL_is_tls13_downgrade"),
        // .define("SSL_is_token_binding_negotiated", to: "GRPC_SHADOW_SSL_is_token_binding_negotiated"),
        // .define("SSL_key_update", to: "GRPC_SHADOW_SSL_key_update"),
        // .define("SSL_library_init", to: "GRPC_SHADOW_SSL_library_init"),
        // .define("SSL_load_client_CA_file", to: "GRPC_SHADOW_SSL_load_client_CA_file"),
        // .define("SSL_load_error_strings", to: "GRPC_SHADOW_SSL_load_error_strings"),
        // .define("SSL_magic_pending_session_ptr", to: "GRPC_SHADOW_SSL_magic_pending_session_ptr"),
        // .define("SSL_max_seal_overhead", to: "GRPC_SHADOW_SSL_max_seal_overhead"),
        // .define("SSL_need_tmp_RSA", to: "GRPC_SHADOW_SSL_need_tmp_RSA"),
        // .define("SSL_new", to: "GRPC_SHADOW_SSL_new"),
        // .define("SSL_num_renegotiations", to: "GRPC_SHADOW_SSL_num_renegotiations"),
        // .define("SSL_peek", to: "GRPC_SHADOW_SSL_peek"),
        // .define("SSL_pending", to: "GRPC_SHADOW_SSL_pending"),
        // .define("SSL_process_quic_post_handshake", to: "GRPC_SHADOW_SSL_process_quic_post_handshake"),
        // .define("SSL_provide_quic_data", to: "GRPC_SHADOW_SSL_provide_quic_data"),
        // .define("SSL_quic_max_handshake_flight_len", to: "GRPC_SHADOW_SSL_quic_max_handshake_flight_len"),
        // .define("SSL_quic_read_level", to: "GRPC_SHADOW_SSL_quic_read_level"),
        // .define("SSL_quic_write_level", to: "GRPC_SHADOW_SSL_quic_write_level"),
        // .define("SSL_read", to: "GRPC_SHADOW_SSL_read"),
        // .define("SSL_renegotiate", to: "GRPC_SHADOW_SSL_renegotiate"),
        // .define("SSL_renegotiate_pending", to: "GRPC_SHADOW_SSL_renegotiate_pending"),
        // .define("SSL_reset_early_data_reject", to: "GRPC_SHADOW_SSL_reset_early_data_reject"),
        // .define("SSL_select_next_proto", to: "GRPC_SHADOW_SSL_select_next_proto"),
        // .define("SSL_send_fatal_alert", to: "GRPC_SHADOW_SSL_send_fatal_alert"),
        // .define("SSL_SESSION_early_data_capable", to: "GRPC_SHADOW_SSL_SESSION_early_data_capable"),
        // .define("SSL_SESSION_free", to: "GRPC_SHADOW_SSL_SESSION_free"),
        // .define("SSL_SESSION_from_bytes", to: "GRPC_SHADOW_SSL_SESSION_from_bytes"),
        // .define("SSL_SESSION_get0_cipher", to: "GRPC_SHADOW_SSL_SESSION_get0_cipher"),
        // .define("SSL_SESSION_get0_id_context", to: "GRPC_SHADOW_SSL_SESSION_get0_id_context"),
        // .define("SSL_SESSION_get0_ocsp_response", to: "GRPC_SHADOW_SSL_SESSION_get0_ocsp_response"),
        // .define("SSL_SESSION_get0_peer", to: "GRPC_SHADOW_SSL_SESSION_get0_peer"),
        // .define("SSL_SESSION_get0_peer_certificates", to: "GRPC_SHADOW_SSL_SESSION_get0_peer_certificates"),
        // .define("SSL_SESSION_get0_peer_sha256", to: "GRPC_SHADOW_SSL_SESSION_get0_peer_sha256"),
        // .define("SSL_SESSION_get0_signed_cert_timestamp_list", to: "GRPC_SHADOW_SSL_SESSION_get0_signed_cert_timestamp_list"),
        // .define("SSL_SESSION_get0_ticket", to: "GRPC_SHADOW_SSL_SESSION_get0_ticket"),
        // .define("SSL_SESSION_get_ex_data", to: "GRPC_SHADOW_SSL_SESSION_get_ex_data"),
        // .define("SSL_SESSION_get_ex_new_index", to: "GRPC_SHADOW_SSL_SESSION_get_ex_new_index"),
        // .define("SSL_SESSION_get_id", to: "GRPC_SHADOW_SSL_SESSION_get_id"),
        // .define("SSL_SESSION_get_master_key", to: "GRPC_SHADOW_SSL_SESSION_get_master_key"),
        // .define("SSL_SESSION_get_protocol_version", to: "GRPC_SHADOW_SSL_SESSION_get_protocol_version"),
        // .define("SSL_SESSION_get_ticket_lifetime_hint", to: "GRPC_SHADOW_SSL_SESSION_get_ticket_lifetime_hint"),
        // .define("SSL_SESSION_get_time", to: "GRPC_SHADOW_SSL_SESSION_get_time"),
        // .define("SSL_SESSION_get_timeout", to: "GRPC_SHADOW_SSL_SESSION_get_timeout"),
        // .define("SSL_SESSION_get_version", to: "GRPC_SHADOW_SSL_SESSION_get_version"),
        // .define("SSL_SESSION_has_peer_sha256", to: "GRPC_SHADOW_SSL_SESSION_has_peer_sha256"),
        // .define("SSL_SESSION_has_ticket", to: "GRPC_SHADOW_SSL_SESSION_has_ticket"),
        // .define("SSL_SESSION_is_resumable", to: "GRPC_SHADOW_SSL_SESSION_is_resumable"),
        // .define("SSL_SESSION_new", to: "GRPC_SHADOW_SSL_SESSION_new"),
        // .define("SSL_session_reused", to: "GRPC_SHADOW_SSL_session_reused"),
        // .define("SSL_SESSION_set1_id", to: "GRPC_SHADOW_SSL_SESSION_set1_id"),
        // .define("SSL_SESSION_set1_id_context", to: "GRPC_SHADOW_SSL_SESSION_set1_id_context"),
        // .define("SSL_SESSION_set_ex_data", to: "GRPC_SHADOW_SSL_SESSION_set_ex_data"),
        // .define("SSL_SESSION_set_protocol_version", to: "GRPC_SHADOW_SSL_SESSION_set_protocol_version"),
        // .define("SSL_SESSION_set_ticket", to: "GRPC_SHADOW_SSL_SESSION_set_ticket"),
        // .define("SSL_SESSION_set_time", to: "GRPC_SHADOW_SSL_SESSION_set_time"),
        // .define("SSL_SESSION_set_timeout", to: "GRPC_SHADOW_SSL_SESSION_set_timeout"),
        // .define("SSL_SESSION_should_be_single_use", to: "GRPC_SHADOW_SSL_SESSION_should_be_single_use"),
        // .define("SSL_SESSION_to_bytes", to: "GRPC_SHADOW_SSL_SESSION_to_bytes"),
        // .define("SSL_SESSION_to_bytes_for_ticket", to: "GRPC_SHADOW_SSL_SESSION_to_bytes_for_ticket"),
        // .define("SSL_SESSION_up_ref", to: "GRPC_SHADOW_SSL_SESSION_up_ref"),
        // .define("SSL_set0_chain", to: "GRPC_SHADOW_SSL_set0_chain"),
        // .define("SSL_set0_client_CAs", to: "GRPC_SHADOW_SSL_set0_client_CAs"),
        // .define("SSL_set0_rbio", to: "GRPC_SHADOW_SSL_set0_rbio"),
        // .define("SSL_set0_verify_cert_store", to: "GRPC_SHADOW_SSL_set0_verify_cert_store"),
        // .define("SSL_set0_wbio", to: "GRPC_SHADOW_SSL_set0_wbio"),
        // .define("SSL_set1_chain", to: "GRPC_SHADOW_SSL_set1_chain"),
        // .define("SSL_set1_curves", to: "GRPC_SHADOW_SSL_set1_curves"),
        // .define("SSL_set1_curves_list", to: "GRPC_SHADOW_SSL_set1_curves_list"),
        // .define("SSL_set1_delegated_credential", to: "GRPC_SHADOW_SSL_set1_delegated_credential"),
        // .define("SSL_set1_param", to: "GRPC_SHADOW_SSL_set1_param"),
        // .define("SSL_set1_sigalgs", to: "GRPC_SHADOW_SSL_set1_sigalgs"),
        // .define("SSL_set1_sigalgs_list", to: "GRPC_SHADOW_SSL_set1_sigalgs_list"),
        // .define("SSL_set1_tls_channel_id", to: "GRPC_SHADOW_SSL_set1_tls_channel_id"),
        // .define("SSL_set1_verify_cert_store", to: "GRPC_SHADOW_SSL_set1_verify_cert_store"),
        // .define("SSL_set_accept_state", to: "GRPC_SHADOW_SSL_set_accept_state"),
        // .define("SSL_set_alpn_protos", to: "GRPC_SHADOW_SSL_set_alpn_protos"),
        // .define("SSL_set_bio", to: "GRPC_SHADOW_SSL_set_bio"),
        // .define("SSL_set_cert_cb", to: "GRPC_SHADOW_SSL_set_cert_cb"),
        // .define("SSL_set_chain_and_key", to: "GRPC_SHADOW_SSL_set_chain_and_key"),
        // .define("SSL_set_cipher_list", to: "GRPC_SHADOW_SSL_set_cipher_list"),
        // .define("SSL_set_client_CA_list", to: "GRPC_SHADOW_SSL_set_client_CA_list"),
        // .define("SSL_set_connect_state", to: "GRPC_SHADOW_SSL_set_connect_state"),
        // .define("SSL_set_custom_verify", to: "GRPC_SHADOW_SSL_set_custom_verify"),
        // .define("SSL_set_early_data_enabled", to: "GRPC_SHADOW_SSL_set_early_data_enabled"),
        // .define("SSL_set_enforce_rsa_key_usage", to: "GRPC_SHADOW_SSL_set_enforce_rsa_key_usage"),
        // .define("SSL_set_ex_data", to: "GRPC_SHADOW_SSL_set_ex_data"),
        // .define("SSL_set_fd", to: "GRPC_SHADOW_SSL_set_fd"),
        // .define("SSL_set_ignore_tls13_downgrade", to: "GRPC_SHADOW_SSL_set_ignore_tls13_downgrade"),
        // .define("SSL_set_info_callback", to: "GRPC_SHADOW_SSL_set_info_callback"),
        // .define("SSL_set_jdk11_workaround", to: "GRPC_SHADOW_SSL_set_jdk11_workaround"),
        // .define("SSL_set_max_cert_list", to: "GRPC_SHADOW_SSL_set_max_cert_list"),
        // .define("SSL_set_max_proto_version", to: "GRPC_SHADOW_SSL_set_max_proto_version"),
        // .define("SSL_set_max_send_fragment", to: "GRPC_SHADOW_SSL_set_max_send_fragment"),
        // .define("SSL_set_min_proto_version", to: "GRPC_SHADOW_SSL_set_min_proto_version"),
        // .define("SSL_set_mode", to: "GRPC_SHADOW_SSL_set_mode"),
        // .define("SSL_set_msg_callback", to: "GRPC_SHADOW_SSL_set_msg_callback"),
        // .define("SSL_set_msg_callback_arg", to: "GRPC_SHADOW_SSL_set_msg_callback_arg"),
        // .define("SSL_set_mtu", to: "GRPC_SHADOW_SSL_set_mtu"),
        // .define("SSL_set_ocsp_response", to: "GRPC_SHADOW_SSL_set_ocsp_response"),
        // .define("SSL_set_options", to: "GRPC_SHADOW_SSL_set_options"),
        // .define("SSL_set_private_key_method", to: "GRPC_SHADOW_SSL_set_private_key_method"),
        // .define("SSL_set_psk_client_callback", to: "GRPC_SHADOW_SSL_set_psk_client_callback"),
        // .define("SSL_set_psk_server_callback", to: "GRPC_SHADOW_SSL_set_psk_server_callback"),
        // .define("SSL_set_purpose", to: "GRPC_SHADOW_SSL_set_purpose"),
        // .define("SSL_set_quic_method", to: "GRPC_SHADOW_SSL_set_quic_method"),
        // .define("SSL_set_quic_transport_params", to: "GRPC_SHADOW_SSL_set_quic_transport_params"),
        // .define("SSL_set_quiet_shutdown", to: "GRPC_SHADOW_SSL_set_quiet_shutdown"),
        // .define("SSL_set_read_ahead", to: "GRPC_SHADOW_SSL_set_read_ahead"),
        // .define("SSL_set_renegotiate_mode", to: "GRPC_SHADOW_SSL_set_renegotiate_mode"),
        // .define("SSL_set_retain_only_sha256_of_client_certs", to: "GRPC_SHADOW_SSL_set_retain_only_sha256_of_client_certs"),
        // .define("SSL_set_rfd", to: "GRPC_SHADOW_SSL_set_rfd"),
        // .define("SSL_set_session", to: "GRPC_SHADOW_SSL_set_session"),
        // .define("SSL_set_session_id_context", to: "GRPC_SHADOW_SSL_set_session_id_context"),
        // .define("SSL_set_shed_handshake_config", to: "GRPC_SHADOW_SSL_set_shed_handshake_config"),
        // .define("SSL_set_shutdown", to: "GRPC_SHADOW_SSL_set_shutdown"),
        // .define("SSL_set_signed_cert_timestamp_list", to: "GRPC_SHADOW_SSL_set_signed_cert_timestamp_list"),
        // .define("SSL_set_signing_algorithm_prefs", to: "GRPC_SHADOW_SSL_set_signing_algorithm_prefs"),
        // .define("SSL_set_srtp_profiles", to: "GRPC_SHADOW_SSL_set_srtp_profiles"),
        // .define("SSL_set_SSL_CTX", to: "GRPC_SHADOW_SSL_set_SSL_CTX"),
        // .define("SSL_set_state", to: "GRPC_SHADOW_SSL_set_state"),
        // .define("SSL_set_strict_cipher_list", to: "GRPC_SHADOW_SSL_set_strict_cipher_list"),
        // .define("SSL_set_tls_channel_id_enabled", to: "GRPC_SHADOW_SSL_set_tls_channel_id_enabled"),
        // .define("SSL_set_tlsext_host_name", to: "GRPC_SHADOW_SSL_set_tlsext_host_name"),
        // .define("SSL_set_tlsext_status_ocsp_resp", to: "GRPC_SHADOW_SSL_set_tlsext_status_ocsp_resp"),
        // .define("SSL_set_tlsext_status_type", to: "GRPC_SHADOW_SSL_set_tlsext_status_type"),
        // .define("SSL_set_tlsext_use_srtp", to: "GRPC_SHADOW_SSL_set_tlsext_use_srtp"),
        // .define("SSL_set_tmp_dh", to: "GRPC_SHADOW_SSL_set_tmp_dh"),
        // .define("SSL_set_tmp_dh_callback", to: "GRPC_SHADOW_SSL_set_tmp_dh_callback"),
        // .define("SSL_set_tmp_ecdh", to: "GRPC_SHADOW_SSL_set_tmp_ecdh"),
        // .define("SSL_set_tmp_rsa", to: "GRPC_SHADOW_SSL_set_tmp_rsa"),
        // .define("SSL_set_tmp_rsa_callback", to: "GRPC_SHADOW_SSL_set_tmp_rsa_callback"),
        // .define("SSL_set_token_binding_params", to: "GRPC_SHADOW_SSL_set_token_binding_params"),
        // .define("SSL_set_trust", to: "GRPC_SHADOW_SSL_set_trust"),
        // .define("SSL_set_verify", to: "GRPC_SHADOW_SSL_set_verify"),
        // .define("SSL_set_verify_depth", to: "GRPC_SHADOW_SSL_set_verify_depth"),
        // .define("SSL_set_verify_result", to: "GRPC_SHADOW_SSL_set_verify_result"),
        // .define("SSL_set_wfd", to: "GRPC_SHADOW_SSL_set_wfd"),
        // .define("SSL_shutdown", to: "GRPC_SHADOW_SSL_shutdown"),
        // .define("SSL_state", to: "GRPC_SHADOW_SSL_state"),
        // .define("SSL_state_string", to: "GRPC_SHADOW_SSL_state_string"),
        // .define("SSL_state_string_long", to: "GRPC_SHADOW_SSL_state_string_long"),
        // .define("SSL_total_renegotiations", to: "GRPC_SHADOW_SSL_total_renegotiations"),
        // .define("SSL_use_certificate", to: "GRPC_SHADOW_SSL_use_certificate"),
        // .define("SSL_use_certificate_ASN1", to: "GRPC_SHADOW_SSL_use_certificate_ASN1"),
        // .define("SSL_use_certificate_file", to: "GRPC_SHADOW_SSL_use_certificate_file"),
        // .define("SSL_used_hello_retry_request", to: "GRPC_SHADOW_SSL_used_hello_retry_request"),
        // .define("SSL_use_PrivateKey", to: "GRPC_SHADOW_SSL_use_PrivateKey"),
        // .define("SSL_use_PrivateKey_ASN1", to: "GRPC_SHADOW_SSL_use_PrivateKey_ASN1"),
        // .define("SSL_use_PrivateKey_file", to: "GRPC_SHADOW_SSL_use_PrivateKey_file"),
        // .define("SSL_use_psk_identity_hint", to: "GRPC_SHADOW_SSL_use_psk_identity_hint"),
        // .define("SSL_use_RSAPrivateKey", to: "GRPC_SHADOW_SSL_use_RSAPrivateKey"),
        // .define("SSL_use_RSAPrivateKey_ASN1", to: "GRPC_SHADOW_SSL_use_RSAPrivateKey_ASN1"),
        // .define("SSL_use_RSAPrivateKey_file", to: "GRPC_SHADOW_SSL_use_RSAPrivateKey_file"),
        // .define("SSLv23_client_method", to: "GRPC_SHADOW_SSLv23_client_method"),
        // .define("SSLv23_method", to: "GRPC_SHADOW_SSLv23_method"),
        // .define("SSLv23_server_method", to: "GRPC_SHADOW_SSLv23_server_method"),
        // .define("SSL_version", to: "GRPC_SHADOW_SSL_version"),
        // .define("SSL_want", to: "GRPC_SHADOW_SSL_want"),
        // .define("SSL_write", to: "GRPC_SHADOW_SSL_write"),
        // .define("SXNET_add_id_asc", to: "GRPC_SHADOW_SXNET_add_id_asc"),
        // .define("SXNET_add_id_INTEGER", to: "GRPC_SHADOW_SXNET_add_id_INTEGER"),
        // .define("SXNET_add_id_ulong", to: "GRPC_SHADOW_SXNET_add_id_ulong"),
        // .define("SXNET_free", to: "GRPC_SHADOW_SXNET_free"),
        // .define("SXNET_get_id_asc", to: "GRPC_SHADOW_SXNET_get_id_asc"),
        // .define("SXNET_get_id_INTEGER", to: "GRPC_SHADOW_SXNET_get_id_INTEGER"),
        // .define("SXNET_get_id_ulong", to: "GRPC_SHADOW_SXNET_get_id_ulong"),
        // .define("SXNETID_free", to: "GRPC_SHADOW_SXNETID_free"),
        // .define("SXNETID_it", to: "GRPC_SHADOW_SXNETID_it"),
        // .define("SXNETID_new", to: "GRPC_SHADOW_SXNETID_new"),
        // .define("SXNET_it", to: "GRPC_SHADOW_SXNET_it"),
        // .define("SXNET_new", to: "GRPC_SHADOW_SXNET_new"),
        // .define("TLS_client_method", to: "GRPC_SHADOW_TLS_client_method"),
        // .define("TLS_method", to: "GRPC_SHADOW_TLS_method"),
        // .define("TLS_server_method", to: "GRPC_SHADOW_TLS_server_method"),
        // .define("TLSv1_1_client_method", to: "GRPC_SHADOW_TLSv1_1_client_method"),
        // .define("TLSv1_1_method", to: "GRPC_SHADOW_TLSv1_1_method"),
        // .define("TLSv1_1_server_method", to: "GRPC_SHADOW_TLSv1_1_server_method"),
        // .define("TLSv1_2_client_method", to: "GRPC_SHADOW_TLSv1_2_client_method"),
        // .define("TLSv1_2_method", to: "GRPC_SHADOW_TLSv1_2_method"),
        // .define("TLSv1_2_server_method", to: "GRPC_SHADOW_TLSv1_2_server_method"),
        // .define("TLSv1_client_method", to: "GRPC_SHADOW_TLSv1_client_method"),
        // .define("TLSv1_method", to: "GRPC_SHADOW_TLSv1_method"),
        // .define("TLSv1_server_method", to: "GRPC_SHADOW_TLSv1_server_method"),
        // .define("TLS_with_buffers_method", to: "GRPC_SHADOW_TLS_with_buffers_method"),
        // .define("tree_find_sk", to: "GRPC_SHADOW_tree_find_sk"),
        // .define("USERNOTICE_free", to: "GRPC_SHADOW_USERNOTICE_free"),
        // .define("USERNOTICE_it", to: "GRPC_SHADOW_USERNOTICE_it"),
        // .define("USERNOTICE_new", to: "GRPC_SHADOW_USERNOTICE_new"),
        // .define("UTF8_getc", to: "GRPC_SHADOW_UTF8_getc"),
        // .define("UTF8_putc", to: "GRPC_SHADOW_UTF8_putc"),
        // .define("v2i_ASN1_BIT_STRING", to: "GRPC_SHADOW_v2i_ASN1_BIT_STRING"),
        // .define("v2i_GENERAL_NAME", to: "GRPC_SHADOW_v2i_GENERAL_NAME"),
        // .define("v2i_GENERAL_NAME_ex", to: "GRPC_SHADOW_v2i_GENERAL_NAME_ex"),
        // .define("v2i_GENERAL_NAMES", to: "GRPC_SHADOW_v2i_GENERAL_NAMES"),
        // .define("v3_akey_id", to: "GRPC_SHADOW_v3_akey_id"),
        // .define("v3_alt", to: "GRPC_SHADOW_v3_alt"),
        // .define("v3_bcons", to: "GRPC_SHADOW_v3_bcons"),
        // .define("v3_cpols", to: "GRPC_SHADOW_v3_cpols"),
        // .define("v3_crld", to: "GRPC_SHADOW_v3_crld"),
        // .define("v3_crl_invdate", to: "GRPC_SHADOW_v3_crl_invdate"),
        // .define("v3_crl_num", to: "GRPC_SHADOW_v3_crl_num"),
        // .define("v3_crl_reason", to: "GRPC_SHADOW_v3_crl_reason"),
        // .define("v3_delta_crl", to: "GRPC_SHADOW_v3_delta_crl"),
        // .define("v3_ext_ku", to: "GRPC_SHADOW_v3_ext_ku"),
        // .define("v3_freshest_crl", to: "GRPC_SHADOW_v3_freshest_crl"),
        // .define("v3_idp", to: "GRPC_SHADOW_v3_idp"),
        // .define("v3_info", to: "GRPC_SHADOW_v3_info"),
        // .define("v3_inhibit_anyp", to: "GRPC_SHADOW_v3_inhibit_anyp"),
        // .define("v3_key_usage", to: "GRPC_SHADOW_v3_key_usage"),
        // .define("v3_name_constraints", to: "GRPC_SHADOW_v3_name_constraints"),
        // .define("v3_nscert", to: "GRPC_SHADOW_v3_nscert"),
        // .define("v3_ns_ia5_list", to: "GRPC_SHADOW_v3_ns_ia5_list"),
        // .define("v3_ocsp_accresp", to: "GRPC_SHADOW_v3_ocsp_accresp"),
        // .define("v3_ocsp_nocheck", to: "GRPC_SHADOW_v3_ocsp_nocheck"),
        // .define("v3_pci", to: "GRPC_SHADOW_v3_pci"),
        // .define("v3_pkey_usage_period", to: "GRPC_SHADOW_v3_pkey_usage_period"),
        // .define("v3_policy_constraints", to: "GRPC_SHADOW_v3_policy_constraints"),
        // .define("v3_policy_mappings", to: "GRPC_SHADOW_v3_policy_mappings"),
        // .define("v3_sinfo", to: "GRPC_SHADOW_v3_sinfo"),
        // .define("v3_skey_id", to: "GRPC_SHADOW_v3_skey_id"),
        // .define("v3_sxnet", to: "GRPC_SHADOW_v3_sxnet"),
        // .define("vpaes_cbc_encrypt", to: "GRPC_SHADOW_vpaes_cbc_encrypt"),
        // .define("vpaes_ctr32_encrypt_blocks", to: "GRPC_SHADOW_vpaes_ctr32_encrypt_blocks"),
        // .define("vpaes_decrypt", to: "GRPC_SHADOW_vpaes_decrypt"),
        // .define("vpaes_encrypt", to: "GRPC_SHADOW_vpaes_encrypt"),
        // .define("vpaes_set_decrypt_key", to: "GRPC_SHADOW_vpaes_set_decrypt_key"),
        // .define("vpaes_set_encrypt_key", to: "GRPC_SHADOW_vpaes_set_encrypt_key"),
        // .define("X25519", to: "GRPC_SHADOW_X25519"),
        // .define("x25519_asn1_meth", to: "GRPC_SHADOW_x25519_asn1_meth"),
        // .define("x25519_ge_add", to: "GRPC_SHADOW_x25519_ge_add"),
        // .define("x25519_ge_frombytes_vartime", to: "GRPC_SHADOW_x25519_ge_frombytes_vartime"),
        // .define("x25519_ge_p1p1_to_p2", to: "GRPC_SHADOW_x25519_ge_p1p1_to_p2"),
        // .define("x25519_ge_p1p1_to_p3", to: "GRPC_SHADOW_x25519_ge_p1p1_to_p3"),
        // .define("x25519_ge_p3_to_cached", to: "GRPC_SHADOW_x25519_ge_p3_to_cached"),
        // .define("x25519_ge_scalarmult", to: "GRPC_SHADOW_x25519_ge_scalarmult"),
        // .define("x25519_ge_scalarmult_base", to: "GRPC_SHADOW_x25519_ge_scalarmult_base"),
        // .define("x25519_ge_scalarmult_small_precomp", to: "GRPC_SHADOW_x25519_ge_scalarmult_small_precomp"),
        // .define("x25519_ge_sub", to: "GRPC_SHADOW_x25519_ge_sub"),
        // .define("x25519_ge_tobytes", to: "GRPC_SHADOW_x25519_ge_tobytes"),
        // .define("X25519_keypair", to: "GRPC_SHADOW_X25519_keypair"),
        // .define("x25519_pkey_meth", to: "GRPC_SHADOW_x25519_pkey_meth"),
        // .define("X25519_public_from_private", to: "GRPC_SHADOW_X25519_public_from_private"),
        // .define("x25519_sc_reduce", to: "GRPC_SHADOW_x25519_sc_reduce"),
        // .define("X509_add1_ext_i2d", to: "GRPC_SHADOW_X509_add1_ext_i2d"),
        // .define("X509_add1_reject_object", to: "GRPC_SHADOW_X509_add1_reject_object"),
        // .define("X509_add1_trust_object", to: "GRPC_SHADOW_X509_add1_trust_object"),
        // .define("X509_add_ext", to: "GRPC_SHADOW_X509_add_ext"),
        // .define("X509_ALGOR_cmp", to: "GRPC_SHADOW_X509_ALGOR_cmp"),
        // .define("X509_ALGOR_dup", to: "GRPC_SHADOW_X509_ALGOR_dup"),
        // .define("X509_ALGOR_free", to: "GRPC_SHADOW_X509_ALGOR_free"),
        // .define("X509_ALGOR_get0", to: "GRPC_SHADOW_X509_ALGOR_get0"),
        // .define("X509_ALGOR_it", to: "GRPC_SHADOW_X509_ALGOR_it"),
        // .define("X509_ALGOR_new", to: "GRPC_SHADOW_X509_ALGOR_new"),
        // .define("X509_ALGOR_set0", to: "GRPC_SHADOW_X509_ALGOR_set0"),
        // .define("X509_ALGOR_set_md", to: "GRPC_SHADOW_X509_ALGOR_set_md"),
        // .define("X509_ALGORS_it", to: "GRPC_SHADOW_X509_ALGORS_it"),
        // .define("X509_alias_get0", to: "GRPC_SHADOW_X509_alias_get0"),
        // .define("X509_alias_set1", to: "GRPC_SHADOW_X509_alias_set1"),
        // .define("X509at_add1_attr", to: "GRPC_SHADOW_X509at_add1_attr"),
        // .define("X509at_add1_attr_by_NID", to: "GRPC_SHADOW_X509at_add1_attr_by_NID"),
        // .define("X509at_add1_attr_by_OBJ", to: "GRPC_SHADOW_X509at_add1_attr_by_OBJ"),
        // .define("X509at_add1_attr_by_txt", to: "GRPC_SHADOW_X509at_add1_attr_by_txt"),
        // .define("X509at_delete_attr", to: "GRPC_SHADOW_X509at_delete_attr"),
        // .define("X509at_get0_data_by_OBJ", to: "GRPC_SHADOW_X509at_get0_data_by_OBJ"),
        // .define("X509at_get_attr", to: "GRPC_SHADOW_X509at_get_attr"),
        // .define("X509at_get_attr_by_NID", to: "GRPC_SHADOW_X509at_get_attr_by_NID"),
        // .define("X509at_get_attr_by_OBJ", to: "GRPC_SHADOW_X509at_get_attr_by_OBJ"),
        // .define("X509at_get_attr_count", to: "GRPC_SHADOW_X509at_get_attr_count"),
        // .define("X509_ATTRIBUTE_count", to: "GRPC_SHADOW_X509_ATTRIBUTE_count"),
        // .define("X509_ATTRIBUTE_create", to: "GRPC_SHADOW_X509_ATTRIBUTE_create"),
        // .define("X509_ATTRIBUTE_create_by_NID", to: "GRPC_SHADOW_X509_ATTRIBUTE_create_by_NID"),
        // .define("X509_ATTRIBUTE_create_by_OBJ", to: "GRPC_SHADOW_X509_ATTRIBUTE_create_by_OBJ"),
        // .define("X509_ATTRIBUTE_create_by_txt", to: "GRPC_SHADOW_X509_ATTRIBUTE_create_by_txt"),
        // .define("X509_ATTRIBUTE_dup", to: "GRPC_SHADOW_X509_ATTRIBUTE_dup"),
        // .define("X509_ATTRIBUTE_free", to: "GRPC_SHADOW_X509_ATTRIBUTE_free"),
        // .define("X509_ATTRIBUTE_get0_data", to: "GRPC_SHADOW_X509_ATTRIBUTE_get0_data"),
        // .define("X509_ATTRIBUTE_get0_object", to: "GRPC_SHADOW_X509_ATTRIBUTE_get0_object"),
        // .define("X509_ATTRIBUTE_get0_type", to: "GRPC_SHADOW_X509_ATTRIBUTE_get0_type"),
        // .define("X509_ATTRIBUTE_it", to: "GRPC_SHADOW_X509_ATTRIBUTE_it"),
        // .define("X509_ATTRIBUTE_new", to: "GRPC_SHADOW_X509_ATTRIBUTE_new"),
        // .define("X509_ATTRIBUTE_set1_data", to: "GRPC_SHADOW_X509_ATTRIBUTE_set1_data"),
        // .define("X509_ATTRIBUTE_set1_object", to: "GRPC_SHADOW_X509_ATTRIBUTE_set1_object"),
        // .define("X509_ATTRIBUTE_SET_it", to: "GRPC_SHADOW_X509_ATTRIBUTE_SET_it"),
        // .define("X509_CERT_AUX_free", to: "GRPC_SHADOW_X509_CERT_AUX_free"),
        // .define("X509_CERT_AUX_it", to: "GRPC_SHADOW_X509_CERT_AUX_it"),
        // .define("X509_CERT_AUX_new", to: "GRPC_SHADOW_X509_CERT_AUX_new"),
        // .define("X509_CERT_AUX_print", to: "GRPC_SHADOW_X509_CERT_AUX_print"),
        // .define("X509_chain_check_suiteb", to: "GRPC_SHADOW_X509_chain_check_suiteb"),
        // .define("X509_chain_up_ref", to: "GRPC_SHADOW_X509_chain_up_ref"),
        // .define("X509_check_akid", to: "GRPC_SHADOW_X509_check_akid"),
        // .define("X509_check_ca", to: "GRPC_SHADOW_X509_check_ca"),
        // .define("X509_check_email", to: "GRPC_SHADOW_X509_check_email"),
        // .define("X509_check_host", to: "GRPC_SHADOW_X509_check_host"),
        // .define("X509_check_ip", to: "GRPC_SHADOW_X509_check_ip"),
        // .define("X509_check_ip_asc", to: "GRPC_SHADOW_X509_check_ip_asc"),
        // .define("X509_check_issued", to: "GRPC_SHADOW_X509_check_issued"),
        // .define("X509_check_private_key", to: "GRPC_SHADOW_X509_check_private_key"),
        // .define("X509_check_purpose", to: "GRPC_SHADOW_X509_check_purpose"),
        // .define("X509_check_trust", to: "GRPC_SHADOW_X509_check_trust"),
        // .define("X509_CINF_free", to: "GRPC_SHADOW_X509_CINF_free"),
        // .define("X509_CINF_it", to: "GRPC_SHADOW_X509_CINF_it"),
        // .define("X509_CINF_new", to: "GRPC_SHADOW_X509_CINF_new"),
        // .define("X509_cmp", to: "GRPC_SHADOW_X509_cmp"),
        // .define("X509_cmp_current_time", to: "GRPC_SHADOW_X509_cmp_current_time"),
        // .define("X509_cmp_time", to: "GRPC_SHADOW_X509_cmp_time"),
        // .define("X509_CRL_add0_revoked", to: "GRPC_SHADOW_X509_CRL_add0_revoked"),
        // .define("X509_CRL_add1_ext_i2d", to: "GRPC_SHADOW_X509_CRL_add1_ext_i2d"),
        // .define("X509_CRL_add_ext", to: "GRPC_SHADOW_X509_CRL_add_ext"),
        // .define("X509_CRL_check_suiteb", to: "GRPC_SHADOW_X509_CRL_check_suiteb"),
        // .define("X509_CRL_cmp", to: "GRPC_SHADOW_X509_CRL_cmp"),
        // .define("X509_CRL_delete_ext", to: "GRPC_SHADOW_X509_CRL_delete_ext"),
        // .define("X509_CRL_diff", to: "GRPC_SHADOW_X509_CRL_diff"),
        // .define("X509_CRL_digest", to: "GRPC_SHADOW_X509_CRL_digest"),
        // .define("X509_CRL_dup", to: "GRPC_SHADOW_X509_CRL_dup"),
        // .define("X509_CRL_free", to: "GRPC_SHADOW_X509_CRL_free"),
        // .define("X509_CRL_get0_by_cert", to: "GRPC_SHADOW_X509_CRL_get0_by_cert"),
        // .define("X509_CRL_get0_by_serial", to: "GRPC_SHADOW_X509_CRL_get0_by_serial"),
        // .define("X509_CRL_get0_lastUpdate", to: "GRPC_SHADOW_X509_CRL_get0_lastUpdate"),
        // .define("X509_CRL_get0_nextUpdate", to: "GRPC_SHADOW_X509_CRL_get0_nextUpdate"),
        // .define("X509_CRL_get0_signature", to: "GRPC_SHADOW_X509_CRL_get0_signature"),
        // .define("X509_CRL_get_ext", to: "GRPC_SHADOW_X509_CRL_get_ext"),
        // .define("X509_CRL_get_ext_by_critical", to: "GRPC_SHADOW_X509_CRL_get_ext_by_critical"),
        // .define("X509_CRL_get_ext_by_NID", to: "GRPC_SHADOW_X509_CRL_get_ext_by_NID"),
        // .define("X509_CRL_get_ext_by_OBJ", to: "GRPC_SHADOW_X509_CRL_get_ext_by_OBJ"),
        // .define("X509_CRL_get_ext_count", to: "GRPC_SHADOW_X509_CRL_get_ext_count"),
        // .define("X509_CRL_get_ext_d2i", to: "GRPC_SHADOW_X509_CRL_get_ext_d2i"),
        // .define("X509_CRL_get_meth_data", to: "GRPC_SHADOW_X509_CRL_get_meth_data"),
        // .define("X509_CRL_get_signature_nid", to: "GRPC_SHADOW_X509_CRL_get_signature_nid"),
        // .define("X509_CRL_INFO_free", to: "GRPC_SHADOW_X509_CRL_INFO_free"),
        // .define("X509_CRL_INFO_it", to: "GRPC_SHADOW_X509_CRL_INFO_it"),
        // .define("X509_CRL_INFO_new", to: "GRPC_SHADOW_X509_CRL_INFO_new"),
        // .define("X509_CRL_it", to: "GRPC_SHADOW_X509_CRL_it"),
        // .define("X509_CRL_match", to: "GRPC_SHADOW_X509_CRL_match"),
        // .define("X509_CRL_METHOD_free", to: "GRPC_SHADOW_X509_CRL_METHOD_free"),
        // .define("X509_CRL_METHOD_new", to: "GRPC_SHADOW_X509_CRL_METHOD_new"),
        // .define("X509_CRL_new", to: "GRPC_SHADOW_X509_CRL_new"),
        // .define("X509_CRL_print", to: "GRPC_SHADOW_X509_CRL_print"),
        // .define("X509_CRL_print_fp", to: "GRPC_SHADOW_X509_CRL_print_fp"),
        // .define("X509_CRL_set_default_method", to: "GRPC_SHADOW_X509_CRL_set_default_method"),
        // .define("X509_CRL_set_issuer_name", to: "GRPC_SHADOW_X509_CRL_set_issuer_name"),
        // .define("X509_CRL_set_lastUpdate", to: "GRPC_SHADOW_X509_CRL_set_lastUpdate"),
        // .define("X509_CRL_set_meth_data", to: "GRPC_SHADOW_X509_CRL_set_meth_data"),
        // .define("X509_CRL_set_nextUpdate", to: "GRPC_SHADOW_X509_CRL_set_nextUpdate"),
        // .define("X509_CRL_set_version", to: "GRPC_SHADOW_X509_CRL_set_version"),
        // .define("X509_CRL_sign", to: "GRPC_SHADOW_X509_CRL_sign"),
        // .define("X509_CRL_sign_ctx", to: "GRPC_SHADOW_X509_CRL_sign_ctx"),
        // .define("X509_CRL_sort", to: "GRPC_SHADOW_X509_CRL_sort"),
        // .define("X509_CRL_up_ref", to: "GRPC_SHADOW_X509_CRL_up_ref"),
        // .define("X509_CRL_verify", to: "GRPC_SHADOW_X509_CRL_verify"),
        // .define("X509_delete_ext", to: "GRPC_SHADOW_X509_delete_ext"),
        // .define("X509_digest", to: "GRPC_SHADOW_X509_digest"),
        // .define("x509_digest_sign_algorithm", to: "GRPC_SHADOW_x509_digest_sign_algorithm"),
        // .define("x509_digest_verify_init", to: "GRPC_SHADOW_x509_digest_verify_init"),
        // .define("X509_dup", to: "GRPC_SHADOW_X509_dup"),
        // .define("X509_email_free", to: "GRPC_SHADOW_X509_email_free"),
        // .define("X509_EXTENSION_create_by_NID", to: "GRPC_SHADOW_X509_EXTENSION_create_by_NID"),
        // .define("X509_EXTENSION_create_by_OBJ", to: "GRPC_SHADOW_X509_EXTENSION_create_by_OBJ"),
        // .define("X509_EXTENSION_dup", to: "GRPC_SHADOW_X509_EXTENSION_dup"),
        // .define("X509_EXTENSION_free", to: "GRPC_SHADOW_X509_EXTENSION_free"),
        // .define("X509_EXTENSION_get_critical", to: "GRPC_SHADOW_X509_EXTENSION_get_critical"),
        // .define("X509_EXTENSION_get_data", to: "GRPC_SHADOW_X509_EXTENSION_get_data"),
        // .define("X509_EXTENSION_get_object", to: "GRPC_SHADOW_X509_EXTENSION_get_object"),
        // .define("X509_EXTENSION_it", to: "GRPC_SHADOW_X509_EXTENSION_it"),
        // .define("X509_EXTENSION_new", to: "GRPC_SHADOW_X509_EXTENSION_new"),
        // .define("X509_EXTENSION_set_critical", to: "GRPC_SHADOW_X509_EXTENSION_set_critical"),
        // .define("X509_EXTENSION_set_data", to: "GRPC_SHADOW_X509_EXTENSION_set_data"),
        // .define("X509_EXTENSION_set_object", to: "GRPC_SHADOW_X509_EXTENSION_set_object"),
        // .define("X509_EXTENSIONS_it", to: "GRPC_SHADOW_X509_EXTENSIONS_it"),
        // .define("X509_find_by_issuer_and_serial", to: "GRPC_SHADOW_X509_find_by_issuer_and_serial"),
        // .define("X509_find_by_subject", to: "GRPC_SHADOW_X509_find_by_subject"),
        // .define("X509_free", to: "GRPC_SHADOW_X509_free"),
        // .define("X509_get0_extensions", to: "GRPC_SHADOW_X509_get0_extensions"),
        // .define("X509_get0_notAfter", to: "GRPC_SHADOW_X509_get0_notAfter"),
        // .define("X509_get0_notBefore", to: "GRPC_SHADOW_X509_get0_notBefore"),
        // .define("X509_get0_pubkey_bitstr", to: "GRPC_SHADOW_X509_get0_pubkey_bitstr"),
        // .define("X509_get0_signature", to: "GRPC_SHADOW_X509_get0_signature"),
        // .define("X509_get0_tbs_sigalg", to: "GRPC_SHADOW_X509_get0_tbs_sigalg"),
        // .define("X509_get1_email", to: "GRPC_SHADOW_X509_get1_email"),
        // .define("X509_get1_ocsp", to: "GRPC_SHADOW_X509_get1_ocsp"),
        // .define("X509_get_default_cert_area", to: "GRPC_SHADOW_X509_get_default_cert_area"),
        // .define("X509_get_default_cert_dir", to: "GRPC_SHADOW_X509_get_default_cert_dir"),
        // .define("X509_get_default_cert_dir_env", to: "GRPC_SHADOW_X509_get_default_cert_dir_env"),
        // .define("X509_get_default_cert_file", to: "GRPC_SHADOW_X509_get_default_cert_file"),
        // .define("X509_get_default_cert_file_env", to: "GRPC_SHADOW_X509_get_default_cert_file_env"),
        // .define("X509_get_default_private_dir", to: "GRPC_SHADOW_X509_get_default_private_dir"),
        // .define("X509_get_ex_data", to: "GRPC_SHADOW_X509_get_ex_data"),
        // .define("X509_get_ex_new_index", to: "GRPC_SHADOW_X509_get_ex_new_index"),
        // .define("X509_get_ext", to: "GRPC_SHADOW_X509_get_ext"),
        // .define("X509_get_ext_by_critical", to: "GRPC_SHADOW_X509_get_ext_by_critical"),
        // .define("X509_get_ext_by_NID", to: "GRPC_SHADOW_X509_get_ext_by_NID"),
        // .define("X509_get_ext_by_OBJ", to: "GRPC_SHADOW_X509_get_ext_by_OBJ"),
        // .define("X509_get_ext_count", to: "GRPC_SHADOW_X509_get_ext_count"),
        // .define("X509_get_ext_d2i", to: "GRPC_SHADOW_X509_get_ext_d2i"),
        // .define("X509_get_extended_key_usage", to: "GRPC_SHADOW_X509_get_extended_key_usage"),
        // .define("X509_get_extension_flags", to: "GRPC_SHADOW_X509_get_extension_flags"),
        // .define("X509_get_issuer_name", to: "GRPC_SHADOW_X509_get_issuer_name"),
        // .define("X509_get_key_usage", to: "GRPC_SHADOW_X509_get_key_usage"),
        // .define("X509_get_pubkey", to: "GRPC_SHADOW_X509_get_pubkey"),
        // .define("X509_get_serialNumber", to: "GRPC_SHADOW_X509_get_serialNumber"),
        // .define("X509_get_signature_nid", to: "GRPC_SHADOW_X509_get_signature_nid"),
        // .define("X509_get_subject_name", to: "GRPC_SHADOW_X509_get_subject_name"),
        // .define("X509_gmtime_adj", to: "GRPC_SHADOW_X509_gmtime_adj"),
        // .define("X509_INFO_free", to: "GRPC_SHADOW_X509_INFO_free"),
        // .define("X509_INFO_new", to: "GRPC_SHADOW_X509_INFO_new"),
        // .define("X509_issuer_and_serial_cmp", to: "GRPC_SHADOW_X509_issuer_and_serial_cmp"),
        // .define("X509_issuer_and_serial_hash", to: "GRPC_SHADOW_X509_issuer_and_serial_hash"),
        // .define("X509_issuer_name_cmp", to: "GRPC_SHADOW_X509_issuer_name_cmp"),
        // .define("X509_issuer_name_hash", to: "GRPC_SHADOW_X509_issuer_name_hash"),
        // .define("X509_issuer_name_hash_old", to: "GRPC_SHADOW_X509_issuer_name_hash_old"),
        // .define("X509_it", to: "GRPC_SHADOW_X509_it"),
        // .define("X509_keyid_get0", to: "GRPC_SHADOW_X509_keyid_get0"),
        // .define("X509_keyid_set1", to: "GRPC_SHADOW_X509_keyid_set1"),
        // .define("X509_load_cert_crl_file", to: "GRPC_SHADOW_X509_load_cert_crl_file"),
        // .define("X509_load_cert_file", to: "GRPC_SHADOW_X509_load_cert_file"),
        // .define("X509_load_crl_file", to: "GRPC_SHADOW_X509_load_crl_file"),
        // .define("X509_LOOKUP_by_alias", to: "GRPC_SHADOW_X509_LOOKUP_by_alias"),
        // .define("X509_LOOKUP_by_fingerprint", to: "GRPC_SHADOW_X509_LOOKUP_by_fingerprint"),
        // .define("X509_LOOKUP_by_issuer_serial", to: "GRPC_SHADOW_X509_LOOKUP_by_issuer_serial"),
        // .define("X509_LOOKUP_by_subject", to: "GRPC_SHADOW_X509_LOOKUP_by_subject"),
        // .define("X509_LOOKUP_ctrl", to: "GRPC_SHADOW_X509_LOOKUP_ctrl"),
        // .define("X509_LOOKUP_file", to: "GRPC_SHADOW_X509_LOOKUP_file"),
        // .define("X509_LOOKUP_free", to: "GRPC_SHADOW_X509_LOOKUP_free"),
        // .define("X509_LOOKUP_hash_dir", to: "GRPC_SHADOW_X509_LOOKUP_hash_dir"),
        // .define("X509_LOOKUP_init", to: "GRPC_SHADOW_X509_LOOKUP_init"),
        // .define("X509_LOOKUP_new", to: "GRPC_SHADOW_X509_LOOKUP_new"),
        // .define("X509_LOOKUP_shutdown", to: "GRPC_SHADOW_X509_LOOKUP_shutdown"),
        // .define("X509_NAME_add_entry", to: "GRPC_SHADOW_X509_NAME_add_entry"),
        // .define("X509_NAME_add_entry_by_NID", to: "GRPC_SHADOW_X509_NAME_add_entry_by_NID"),
        // .define("X509_NAME_add_entry_by_OBJ", to: "GRPC_SHADOW_X509_NAME_add_entry_by_OBJ"),
        // .define("X509_NAME_add_entry_by_txt", to: "GRPC_SHADOW_X509_NAME_add_entry_by_txt"),
        // .define("X509_NAME_cmp", to: "GRPC_SHADOW_X509_NAME_cmp"),
        // .define("X509_NAME_delete_entry", to: "GRPC_SHADOW_X509_NAME_delete_entry"),
        // .define("X509_NAME_digest", to: "GRPC_SHADOW_X509_NAME_digest"),
        // .define("X509_NAME_dup", to: "GRPC_SHADOW_X509_NAME_dup"),
        // .define("X509_NAME_ENTRIES_it", to: "GRPC_SHADOW_X509_NAME_ENTRIES_it"),
        // .define("X509_NAME_entry_count", to: "GRPC_SHADOW_X509_NAME_entry_count"),
        // .define("X509_NAME_ENTRY_create_by_NID", to: "GRPC_SHADOW_X509_NAME_ENTRY_create_by_NID"),
        // .define("X509_NAME_ENTRY_create_by_OBJ", to: "GRPC_SHADOW_X509_NAME_ENTRY_create_by_OBJ"),
        // .define("X509_NAME_ENTRY_create_by_txt", to: "GRPC_SHADOW_X509_NAME_ENTRY_create_by_txt"),
        // .define("X509_NAME_ENTRY_dup", to: "GRPC_SHADOW_X509_NAME_ENTRY_dup"),
        // .define("X509_NAME_ENTRY_free", to: "GRPC_SHADOW_X509_NAME_ENTRY_free"),
        // .define("X509_NAME_ENTRY_get_data", to: "GRPC_SHADOW_X509_NAME_ENTRY_get_data"),
        // .define("X509_NAME_ENTRY_get_object", to: "GRPC_SHADOW_X509_NAME_ENTRY_get_object"),
        // .define("X509_NAME_ENTRY_it", to: "GRPC_SHADOW_X509_NAME_ENTRY_it"),
        // .define("X509_NAME_ENTRY_new", to: "GRPC_SHADOW_X509_NAME_ENTRY_new"),
        // .define("X509_NAME_ENTRY_set", to: "GRPC_SHADOW_X509_NAME_ENTRY_set"),
        // .define("X509_NAME_ENTRY_set_data", to: "GRPC_SHADOW_X509_NAME_ENTRY_set_data"),
        // .define("X509_NAME_ENTRY_set_object", to: "GRPC_SHADOW_X509_NAME_ENTRY_set_object"),
        // .define("X509_NAME_free", to: "GRPC_SHADOW_X509_NAME_free"),
        // .define("X509_NAME_get0_der", to: "GRPC_SHADOW_X509_NAME_get0_der"),
        // .define("X509_NAME_get_entry", to: "GRPC_SHADOW_X509_NAME_get_entry"),
        // .define("X509_NAME_get_index_by_NID", to: "GRPC_SHADOW_X509_NAME_get_index_by_NID"),
        // .define("X509_NAME_get_index_by_OBJ", to: "GRPC_SHADOW_X509_NAME_get_index_by_OBJ"),
        // .define("X509_NAME_get_text_by_NID", to: "GRPC_SHADOW_X509_NAME_get_text_by_NID"),
        // .define("X509_NAME_get_text_by_OBJ", to: "GRPC_SHADOW_X509_NAME_get_text_by_OBJ"),
        // .define("X509_NAME_hash", to: "GRPC_SHADOW_X509_NAME_hash"),
        // .define("X509_NAME_hash_old", to: "GRPC_SHADOW_X509_NAME_hash_old"),
        // .define("X509_NAME_INTERNAL_it", to: "GRPC_SHADOW_X509_NAME_INTERNAL_it"),
        // .define("X509_NAME_it", to: "GRPC_SHADOW_X509_NAME_it"),
        // .define("X509_NAME_new", to: "GRPC_SHADOW_X509_NAME_new"),
        // .define("X509_NAME_oneline", to: "GRPC_SHADOW_X509_NAME_oneline"),
        // .define("X509_NAME_print", to: "GRPC_SHADOW_X509_NAME_print"),
        // .define("X509_NAME_print_ex", to: "GRPC_SHADOW_X509_NAME_print_ex"),
        // .define("X509_NAME_print_ex_fp", to: "GRPC_SHADOW_X509_NAME_print_ex_fp"),
        // .define("X509_NAME_set", to: "GRPC_SHADOW_X509_NAME_set"),
        // .define("X509_new", to: "GRPC_SHADOW_X509_new"),
        // .define("X509_OBJECT_free_contents", to: "GRPC_SHADOW_X509_OBJECT_free_contents"),
        // .define("X509_OBJECT_get0_X509", to: "GRPC_SHADOW_X509_OBJECT_get0_X509"),
        // .define("X509_OBJECT_get_type", to: "GRPC_SHADOW_X509_OBJECT_get_type"),
        // .define("X509_OBJECT_idx_by_subject", to: "GRPC_SHADOW_X509_OBJECT_idx_by_subject"),
        // .define("X509_OBJECT_retrieve_by_subject", to: "GRPC_SHADOW_X509_OBJECT_retrieve_by_subject"),
        // .define("X509_OBJECT_retrieve_match", to: "GRPC_SHADOW_X509_OBJECT_retrieve_match"),
        // .define("X509_OBJECT_up_ref_count", to: "GRPC_SHADOW_X509_OBJECT_up_ref_count"),
        // .define("X509_ocspid_print", to: "GRPC_SHADOW_X509_ocspid_print"),
        // .define("X509_parse_from_buffer", to: "GRPC_SHADOW_X509_parse_from_buffer"),
        // .define("X509_PKEY_free", to: "GRPC_SHADOW_X509_PKEY_free"),
        // .define("X509_PKEY_new", to: "GRPC_SHADOW_X509_PKEY_new"),
        // .define("X509_policy_check", to: "GRPC_SHADOW_X509_policy_check"),
        // .define("X509_policy_level_get0_node", to: "GRPC_SHADOW_X509_policy_level_get0_node"),
        // .define("X509_policy_level_node_count", to: "GRPC_SHADOW_X509_policy_level_node_count"),
        // .define("X509_policy_node_get0_parent", to: "GRPC_SHADOW_X509_policy_node_get0_parent"),
        // .define("X509_policy_node_get0_policy", to: "GRPC_SHADOW_X509_policy_node_get0_policy"),
        // .define("X509_policy_node_get0_qualifiers", to: "GRPC_SHADOW_X509_policy_node_get0_qualifiers"),
        // .define("X509_POLICY_NODE_print", to: "GRPC_SHADOW_X509_POLICY_NODE_print"),
        // .define("X509_policy_tree_free", to: "GRPC_SHADOW_X509_policy_tree_free"),
        // .define("X509_policy_tree_get0_level", to: "GRPC_SHADOW_X509_policy_tree_get0_level"),
        // .define("X509_policy_tree_get0_policies", to: "GRPC_SHADOW_X509_policy_tree_get0_policies"),
        // .define("X509_policy_tree_get0_user_policies", to: "GRPC_SHADOW_X509_policy_tree_get0_user_policies"),
        // .define("X509_policy_tree_level_count", to: "GRPC_SHADOW_X509_policy_tree_level_count"),
        // .define("X509_print", to: "GRPC_SHADOW_X509_print"),
        // .define("X509_print_ex", to: "GRPC_SHADOW_X509_print_ex"),
        // .define("X509_print_ex_fp", to: "GRPC_SHADOW_X509_print_ex_fp"),
        // .define("X509_print_fp", to: "GRPC_SHADOW_X509_print_fp"),
        // .define("x509_print_rsa_pss_params", to: "GRPC_SHADOW_x509_print_rsa_pss_params"),
        // .define("X509_pubkey_digest", to: "GRPC_SHADOW_X509_pubkey_digest"),
        // .define("X509_PUBKEY_free", to: "GRPC_SHADOW_X509_PUBKEY_free"),
        // .define("X509_PUBKEY_get", to: "GRPC_SHADOW_X509_PUBKEY_get"),
        // .define("X509_PUBKEY_get0_param", to: "GRPC_SHADOW_X509_PUBKEY_get0_param"),
        // .define("X509_PUBKEY_it", to: "GRPC_SHADOW_X509_PUBKEY_it"),
        // .define("X509_PUBKEY_new", to: "GRPC_SHADOW_X509_PUBKEY_new"),
        // .define("X509_PUBKEY_set", to: "GRPC_SHADOW_X509_PUBKEY_set"),
        // .define("X509_PUBKEY_set0_param", to: "GRPC_SHADOW_X509_PUBKEY_set0_param"),
        // .define("X509_PURPOSE_add", to: "GRPC_SHADOW_X509_PURPOSE_add"),
        // .define("X509_PURPOSE_cleanup", to: "GRPC_SHADOW_X509_PURPOSE_cleanup"),
        // .define("X509_PURPOSE_get0", to: "GRPC_SHADOW_X509_PURPOSE_get0"),
        // .define("X509_PURPOSE_get0_name", to: "GRPC_SHADOW_X509_PURPOSE_get0_name"),
        // .define("X509_PURPOSE_get0_sname", to: "GRPC_SHADOW_X509_PURPOSE_get0_sname"),
        // .define("X509_PURPOSE_get_by_id", to: "GRPC_SHADOW_X509_PURPOSE_get_by_id"),
        // .define("X509_PURPOSE_get_by_sname", to: "GRPC_SHADOW_X509_PURPOSE_get_by_sname"),
        // .define("X509_PURPOSE_get_count", to: "GRPC_SHADOW_X509_PURPOSE_get_count"),
        // .define("X509_PURPOSE_get_id", to: "GRPC_SHADOW_X509_PURPOSE_get_id"),
        // .define("X509_PURPOSE_get_trust", to: "GRPC_SHADOW_X509_PURPOSE_get_trust"),
        // .define("X509_PURPOSE_set", to: "GRPC_SHADOW_X509_PURPOSE_set"),
        // .define("X509_reject_clear", to: "GRPC_SHADOW_X509_reject_clear"),
        // .define("X509_REQ_add1_attr", to: "GRPC_SHADOW_X509_REQ_add1_attr"),
        // .define("X509_REQ_add1_attr_by_NID", to: "GRPC_SHADOW_X509_REQ_add1_attr_by_NID"),
        // .define("X509_REQ_add1_attr_by_OBJ", to: "GRPC_SHADOW_X509_REQ_add1_attr_by_OBJ"),
        // .define("X509_REQ_add1_attr_by_txt", to: "GRPC_SHADOW_X509_REQ_add1_attr_by_txt"),
        // .define("X509_REQ_add_extensions", to: "GRPC_SHADOW_X509_REQ_add_extensions"),
        // .define("X509_REQ_add_extensions_nid", to: "GRPC_SHADOW_X509_REQ_add_extensions_nid"),
        // .define("X509_REQ_check_private_key", to: "GRPC_SHADOW_X509_REQ_check_private_key"),
        // .define("X509_REQ_delete_attr", to: "GRPC_SHADOW_X509_REQ_delete_attr"),
        // .define("X509_REQ_digest", to: "GRPC_SHADOW_X509_REQ_digest"),
        // .define("X509_REQ_dup", to: "GRPC_SHADOW_X509_REQ_dup"),
        // .define("X509_REQ_extension_nid", to: "GRPC_SHADOW_X509_REQ_extension_nid"),
        // .define("X509_REQ_free", to: "GRPC_SHADOW_X509_REQ_free"),
        // .define("X509_REQ_get0_signature", to: "GRPC_SHADOW_X509_REQ_get0_signature"),
        // .define("X509_REQ_get1_email", to: "GRPC_SHADOW_X509_REQ_get1_email"),
        // .define("X509_REQ_get_attr", to: "GRPC_SHADOW_X509_REQ_get_attr"),
        // .define("X509_REQ_get_attr_by_NID", to: "GRPC_SHADOW_X509_REQ_get_attr_by_NID"),
        // .define("X509_REQ_get_attr_by_OBJ", to: "GRPC_SHADOW_X509_REQ_get_attr_by_OBJ"),
        // .define("X509_REQ_get_attr_count", to: "GRPC_SHADOW_X509_REQ_get_attr_count"),
        // .define("X509_REQ_get_extension_nids", to: "GRPC_SHADOW_X509_REQ_get_extension_nids"),
        // .define("X509_REQ_get_extensions", to: "GRPC_SHADOW_X509_REQ_get_extensions"),
        // .define("X509_REQ_get_pubkey", to: "GRPC_SHADOW_X509_REQ_get_pubkey"),
        // .define("X509_REQ_get_signature_nid", to: "GRPC_SHADOW_X509_REQ_get_signature_nid"),
        // .define("X509_REQ_INFO_free", to: "GRPC_SHADOW_X509_REQ_INFO_free"),
        // .define("X509_REQ_INFO_it", to: "GRPC_SHADOW_X509_REQ_INFO_it"),
        // .define("X509_REQ_INFO_new", to: "GRPC_SHADOW_X509_REQ_INFO_new"),
        // .define("X509_REQ_it", to: "GRPC_SHADOW_X509_REQ_it"),
        // .define("X509_REQ_new", to: "GRPC_SHADOW_X509_REQ_new"),
        // .define("X509_REQ_print", to: "GRPC_SHADOW_X509_REQ_print"),
        // .define("X509_REQ_print_ex", to: "GRPC_SHADOW_X509_REQ_print_ex"),
        // .define("X509_REQ_print_fp", to: "GRPC_SHADOW_X509_REQ_print_fp"),
        // .define("X509_REQ_set_extension_nids", to: "GRPC_SHADOW_X509_REQ_set_extension_nids"),
        // .define("X509_REQ_set_pubkey", to: "GRPC_SHADOW_X509_REQ_set_pubkey"),
        // .define("X509_REQ_set_subject_name", to: "GRPC_SHADOW_X509_REQ_set_subject_name"),
        // .define("X509_REQ_set_version", to: "GRPC_SHADOW_X509_REQ_set_version"),
        // .define("X509_REQ_sign", to: "GRPC_SHADOW_X509_REQ_sign"),
        // .define("X509_REQ_sign_ctx", to: "GRPC_SHADOW_X509_REQ_sign_ctx"),
        // .define("X509_REQ_to_X509", to: "GRPC_SHADOW_X509_REQ_to_X509"),
        // .define("X509_REQ_verify", to: "GRPC_SHADOW_X509_REQ_verify"),
        // .define("X509_REVOKED_add1_ext_i2d", to: "GRPC_SHADOW_X509_REVOKED_add1_ext_i2d"),
        // .define("X509_REVOKED_add_ext", to: "GRPC_SHADOW_X509_REVOKED_add_ext"),
        // .define("X509_REVOKED_delete_ext", to: "GRPC_SHADOW_X509_REVOKED_delete_ext"),
        // .define("X509_REVOKED_dup", to: "GRPC_SHADOW_X509_REVOKED_dup"),
        // .define("X509_REVOKED_free", to: "GRPC_SHADOW_X509_REVOKED_free"),
        // .define("X509_REVOKED_get0_revocationDate", to: "GRPC_SHADOW_X509_REVOKED_get0_revocationDate"),
        // .define("X509_REVOKED_get0_serialNumber", to: "GRPC_SHADOW_X509_REVOKED_get0_serialNumber"),
        // .define("X509_REVOKED_get_ext", to: "GRPC_SHADOW_X509_REVOKED_get_ext"),
        // .define("X509_REVOKED_get_ext_by_critical", to: "GRPC_SHADOW_X509_REVOKED_get_ext_by_critical"),
        // .define("X509_REVOKED_get_ext_by_NID", to: "GRPC_SHADOW_X509_REVOKED_get_ext_by_NID"),
        // .define("X509_REVOKED_get_ext_by_OBJ", to: "GRPC_SHADOW_X509_REVOKED_get_ext_by_OBJ"),
        // .define("X509_REVOKED_get_ext_count", to: "GRPC_SHADOW_X509_REVOKED_get_ext_count"),
        // .define("X509_REVOKED_get_ext_d2i", to: "GRPC_SHADOW_X509_REVOKED_get_ext_d2i"),
        // .define("X509_REVOKED_it", to: "GRPC_SHADOW_X509_REVOKED_it"),
        // .define("X509_REVOKED_new", to: "GRPC_SHADOW_X509_REVOKED_new"),
        // .define("X509_REVOKED_set_revocationDate", to: "GRPC_SHADOW_X509_REVOKED_set_revocationDate"),
        // .define("X509_REVOKED_set_serialNumber", to: "GRPC_SHADOW_X509_REVOKED_set_serialNumber"),
        // .define("x509_rsa_ctx_to_pss", to: "GRPC_SHADOW_x509_rsa_ctx_to_pss"),
        // .define("x509_rsa_pss_to_ctx", to: "GRPC_SHADOW_x509_rsa_pss_to_ctx"),
        // .define("X509_set_ex_data", to: "GRPC_SHADOW_X509_set_ex_data"),
        // .define("X509_set_issuer_name", to: "GRPC_SHADOW_X509_set_issuer_name"),
        // .define("X509_set_notAfter", to: "GRPC_SHADOW_X509_set_notAfter"),
        // .define("X509_set_notBefore", to: "GRPC_SHADOW_X509_set_notBefore"),
        // .define("X509_set_pubkey", to: "GRPC_SHADOW_X509_set_pubkey"),
        // .define("X509_set_serialNumber", to: "GRPC_SHADOW_X509_set_serialNumber"),
        // .define("X509_set_subject_name", to: "GRPC_SHADOW_X509_set_subject_name"),
        // .define("X509_set_version", to: "GRPC_SHADOW_X509_set_version"),
        // .define("X509_SIG_free", to: "GRPC_SHADOW_X509_SIG_free"),
        // .define("X509_SIG_it", to: "GRPC_SHADOW_X509_SIG_it"),
        // .define("X509_sign", to: "GRPC_SHADOW_X509_sign"),
        // .define("X509_signature_dump", to: "GRPC_SHADOW_X509_signature_dump"),
        // .define("X509_signature_print", to: "GRPC_SHADOW_X509_signature_print"),
        // .define("X509_sign_ctx", to: "GRPC_SHADOW_X509_sign_ctx"),
        // .define("X509_SIG_new", to: "GRPC_SHADOW_X509_SIG_new"),
        // .define("X509_STORE_add_cert", to: "GRPC_SHADOW_X509_STORE_add_cert"),
        // .define("X509_STORE_add_crl", to: "GRPC_SHADOW_X509_STORE_add_crl"),
        // .define("X509_STORE_add_lookup", to: "GRPC_SHADOW_X509_STORE_add_lookup"),
        // .define("X509_STORE_CTX_cleanup", to: "GRPC_SHADOW_X509_STORE_CTX_cleanup"),
        // .define("X509_STORE_CTX_free", to: "GRPC_SHADOW_X509_STORE_CTX_free"),
        // .define("X509_STORE_CTX_get0_cert", to: "GRPC_SHADOW_X509_STORE_CTX_get0_cert"),
        // .define("X509_STORE_CTX_get0_current_crl", to: "GRPC_SHADOW_X509_STORE_CTX_get0_current_crl"),
        // .define("X509_STORE_CTX_get0_current_issuer", to: "GRPC_SHADOW_X509_STORE_CTX_get0_current_issuer"),
        // .define("X509_STORE_CTX_get0_param", to: "GRPC_SHADOW_X509_STORE_CTX_get0_param"),
        // .define("X509_STORE_CTX_get0_parent_ctx", to: "GRPC_SHADOW_X509_STORE_CTX_get0_parent_ctx"),
        // .define("X509_STORE_CTX_get0_policy_tree", to: "GRPC_SHADOW_X509_STORE_CTX_get0_policy_tree"),
        // .define("X509_STORE_CTX_get0_store", to: "GRPC_SHADOW_X509_STORE_CTX_get0_store"),
        // .define("X509_STORE_CTX_get0_untrusted", to: "GRPC_SHADOW_X509_STORE_CTX_get0_untrusted"),
        // .define("X509_STORE_CTX_get1_chain", to: "GRPC_SHADOW_X509_STORE_CTX_get1_chain"),
        // .define("X509_STORE_CTX_get1_issuer", to: "GRPC_SHADOW_X509_STORE_CTX_get1_issuer"),
        // .define("X509_STORE_CTX_get_chain", to: "GRPC_SHADOW_X509_STORE_CTX_get_chain"),
        // .define("X509_STORE_CTX_get_current_cert", to: "GRPC_SHADOW_X509_STORE_CTX_get_current_cert"),
        // .define("X509_STORE_CTX_get_error", to: "GRPC_SHADOW_X509_STORE_CTX_get_error"),
        // .define("X509_STORE_CTX_get_error_depth", to: "GRPC_SHADOW_X509_STORE_CTX_get_error_depth"),
        // .define("X509_STORE_CTX_get_ex_data", to: "GRPC_SHADOW_X509_STORE_CTX_get_ex_data"),
        // .define("X509_STORE_CTX_get_ex_new_index", to: "GRPC_SHADOW_X509_STORE_CTX_get_ex_new_index"),
        // .define("X509_STORE_CTX_get_explicit_policy", to: "GRPC_SHADOW_X509_STORE_CTX_get_explicit_policy"),
        // .define("X509_STORE_CTX_init", to: "GRPC_SHADOW_X509_STORE_CTX_init"),
        // .define("X509_STORE_CTX_new", to: "GRPC_SHADOW_X509_STORE_CTX_new"),
        // .define("X509_STORE_CTX_purpose_inherit", to: "GRPC_SHADOW_X509_STORE_CTX_purpose_inherit"),
        // .define("X509_STORE_CTX_set0_crls", to: "GRPC_SHADOW_X509_STORE_CTX_set0_crls"),
        // .define("X509_STORE_CTX_set0_param", to: "GRPC_SHADOW_X509_STORE_CTX_set0_param"),
        // .define("X509_STORE_CTX_set_cert", to: "GRPC_SHADOW_X509_STORE_CTX_set_cert"),
        // .define("X509_STORE_CTX_set_chain", to: "GRPC_SHADOW_X509_STORE_CTX_set_chain"),
        // .define("X509_STORE_CTX_set_default", to: "GRPC_SHADOW_X509_STORE_CTX_set_default"),
        // .define("X509_STORE_CTX_set_depth", to: "GRPC_SHADOW_X509_STORE_CTX_set_depth"),
        // .define("X509_STORE_CTX_set_error", to: "GRPC_SHADOW_X509_STORE_CTX_set_error"),
        // .define("X509_STORE_CTX_set_ex_data", to: "GRPC_SHADOW_X509_STORE_CTX_set_ex_data"),
        // .define("X509_STORE_CTX_set_flags", to: "GRPC_SHADOW_X509_STORE_CTX_set_flags"),
        // .define("X509_STORE_CTX_set_purpose", to: "GRPC_SHADOW_X509_STORE_CTX_set_purpose"),
        // .define("X509_STORE_CTX_set_time", to: "GRPC_SHADOW_X509_STORE_CTX_set_time"),
        // .define("X509_STORE_CTX_set_trust", to: "GRPC_SHADOW_X509_STORE_CTX_set_trust"),
        // .define("X509_STORE_CTX_set_verify_cb", to: "GRPC_SHADOW_X509_STORE_CTX_set_verify_cb"),
        // .define("X509_STORE_CTX_trusted_stack", to: "GRPC_SHADOW_X509_STORE_CTX_trusted_stack"),
        // .define("X509_STORE_CTX_zero", to: "GRPC_SHADOW_X509_STORE_CTX_zero"),
        // .define("X509_STORE_free", to: "GRPC_SHADOW_X509_STORE_free"),
        // .define("X509_STORE_get0_objects", to: "GRPC_SHADOW_X509_STORE_get0_objects"),
        // .define("X509_STORE_get0_param", to: "GRPC_SHADOW_X509_STORE_get0_param"),
        // .define("X509_STORE_get1_certs", to: "GRPC_SHADOW_X509_STORE_get1_certs"),
        // .define("X509_STORE_get1_crls", to: "GRPC_SHADOW_X509_STORE_get1_crls"),
        // .define("X509_STORE_get_by_subject", to: "GRPC_SHADOW_X509_STORE_get_by_subject"),
        // .define("X509_STORE_get_cert_crl", to: "GRPC_SHADOW_X509_STORE_get_cert_crl"),
        // .define("X509_STORE_get_check_crl", to: "GRPC_SHADOW_X509_STORE_get_check_crl"),
        // .define("X509_STORE_get_check_issued", to: "GRPC_SHADOW_X509_STORE_get_check_issued"),
        // .define("X509_STORE_get_check_revocation", to: "GRPC_SHADOW_X509_STORE_get_check_revocation"),
        // .define("X509_STORE_get_cleanup", to: "GRPC_SHADOW_X509_STORE_get_cleanup"),
        // .define("X509_STORE_get_get_crl", to: "GRPC_SHADOW_X509_STORE_get_get_crl"),
        // .define("X509_STORE_get_get_issuer", to: "GRPC_SHADOW_X509_STORE_get_get_issuer"),
        // .define("X509_STORE_get_lookup_certs", to: "GRPC_SHADOW_X509_STORE_get_lookup_certs"),
        // .define("X509_STORE_get_lookup_crls", to: "GRPC_SHADOW_X509_STORE_get_lookup_crls"),
        // .define("X509_STORE_get_verify", to: "GRPC_SHADOW_X509_STORE_get_verify"),
        // .define("X509_STORE_get_verify_cb", to: "GRPC_SHADOW_X509_STORE_get_verify_cb"),
        // .define("X509_STORE_load_locations", to: "GRPC_SHADOW_X509_STORE_load_locations"),
        // .define("X509_STORE_new", to: "GRPC_SHADOW_X509_STORE_new"),
        // .define("X509_STORE_set0_additional_untrusted", to: "GRPC_SHADOW_X509_STORE_set0_additional_untrusted"),
        // .define("X509_STORE_set1_param", to: "GRPC_SHADOW_X509_STORE_set1_param"),
        // .define("X509_STORE_set_cert_crl", to: "GRPC_SHADOW_X509_STORE_set_cert_crl"),
        // .define("X509_STORE_set_check_crl", to: "GRPC_SHADOW_X509_STORE_set_check_crl"),
        // .define("X509_STORE_set_check_issued", to: "GRPC_SHADOW_X509_STORE_set_check_issued"),
        // .define("X509_STORE_set_check_revocation", to: "GRPC_SHADOW_X509_STORE_set_check_revocation"),
        // .define("X509_STORE_set_cleanup", to: "GRPC_SHADOW_X509_STORE_set_cleanup"),
        // .define("X509_STORE_set_default_paths", to: "GRPC_SHADOW_X509_STORE_set_default_paths"),
        // .define("X509_STORE_set_depth", to: "GRPC_SHADOW_X509_STORE_set_depth"),
        // .define("X509_STORE_set_flags", to: "GRPC_SHADOW_X509_STORE_set_flags"),
        // .define("X509_STORE_set_get_crl", to: "GRPC_SHADOW_X509_STORE_set_get_crl"),
        // .define("X509_STORE_set_get_issuer", to: "GRPC_SHADOW_X509_STORE_set_get_issuer"),
        // .define("X509_STORE_set_lookup_certs", to: "GRPC_SHADOW_X509_STORE_set_lookup_certs"),
        // .define("X509_STORE_set_lookup_crls", to: "GRPC_SHADOW_X509_STORE_set_lookup_crls"),
        // .define("X509_STORE_set_purpose", to: "GRPC_SHADOW_X509_STORE_set_purpose"),
        // .define("X509_STORE_set_trust", to: "GRPC_SHADOW_X509_STORE_set_trust"),
        // .define("X509_STORE_set_verify", to: "GRPC_SHADOW_X509_STORE_set_verify"),
        // .define("X509_STORE_set_verify_cb", to: "GRPC_SHADOW_X509_STORE_set_verify_cb"),
        // .define("X509_STORE_up_ref", to: "GRPC_SHADOW_X509_STORE_up_ref"),
        // .define("X509_subject_name_cmp", to: "GRPC_SHADOW_X509_subject_name_cmp"),
        // .define("X509_subject_name_hash", to: "GRPC_SHADOW_X509_subject_name_hash"),
        // .define("X509_subject_name_hash_old", to: "GRPC_SHADOW_X509_subject_name_hash_old"),
        // .define("X509_supported_extension", to: "GRPC_SHADOW_X509_supported_extension"),
        // .define("X509_time_adj", to: "GRPC_SHADOW_X509_time_adj"),
        // .define("X509_time_adj_ex", to: "GRPC_SHADOW_X509_time_adj_ex"),
        // .define("X509_to_X509_REQ", to: "GRPC_SHADOW_X509_to_X509_REQ"),
        // .define("X509_TRUST_add", to: "GRPC_SHADOW_X509_TRUST_add"),
        // .define("X509_TRUST_cleanup", to: "GRPC_SHADOW_X509_TRUST_cleanup"),
        // .define("X509_trust_clear", to: "GRPC_SHADOW_X509_trust_clear"),
        // .define("X509_TRUST_get0", to: "GRPC_SHADOW_X509_TRUST_get0"),
        // .define("X509_TRUST_get0_name", to: "GRPC_SHADOW_X509_TRUST_get0_name"),
        // .define("X509_TRUST_get_by_id", to: "GRPC_SHADOW_X509_TRUST_get_by_id"),
        // .define("X509_TRUST_get_count", to: "GRPC_SHADOW_X509_TRUST_get_count"),
        // .define("X509_TRUST_get_flags", to: "GRPC_SHADOW_X509_TRUST_get_flags"),
        // .define("X509_TRUST_get_trust", to: "GRPC_SHADOW_X509_TRUST_get_trust"),
        // .define("X509_TRUST_set", to: "GRPC_SHADOW_X509_TRUST_set"),
        // .define("X509_TRUST_set_default", to: "GRPC_SHADOW_X509_TRUST_set_default"),
        // .define("X509_up_ref", to: "GRPC_SHADOW_X509_up_ref"),
        // .define("X509V3_add1_i2d", to: "GRPC_SHADOW_X509V3_add1_i2d"),
        // .define("X509v3_add_ext", to: "GRPC_SHADOW_X509v3_add_ext"),
        // .define("X509V3_add_standard_extensions", to: "GRPC_SHADOW_X509V3_add_standard_extensions"),
        // .define("X509V3_add_value", to: "GRPC_SHADOW_X509V3_add_value"),
        // .define("X509V3_add_value_bool", to: "GRPC_SHADOW_X509V3_add_value_bool"),
        // .define("X509V3_add_value_bool_nf", to: "GRPC_SHADOW_X509V3_add_value_bool_nf"),
        // .define("X509V3_add_value_int", to: "GRPC_SHADOW_X509V3_add_value_int"),
        // .define("X509V3_add_value_uchar", to: "GRPC_SHADOW_X509V3_add_value_uchar"),
        // .define("x509v3_bytes_to_hex", to: "GRPC_SHADOW_x509v3_bytes_to_hex"),
        // .define("X509V3_conf_free", to: "GRPC_SHADOW_X509V3_conf_free"),
        // .define("X509v3_delete_ext", to: "GRPC_SHADOW_X509v3_delete_ext"),
        // .define("X509V3_EXT_add", to: "GRPC_SHADOW_X509V3_EXT_add"),
        // .define("X509V3_EXT_add_alias", to: "GRPC_SHADOW_X509V3_EXT_add_alias"),
        // .define("X509V3_EXT_add_list", to: "GRPC_SHADOW_X509V3_EXT_add_list"),
        // .define("X509V3_EXT_add_nconf", to: "GRPC_SHADOW_X509V3_EXT_add_nconf"),
        // .define("X509V3_EXT_add_nconf_sk", to: "GRPC_SHADOW_X509V3_EXT_add_nconf_sk"),
        // .define("X509V3_EXT_cleanup", to: "GRPC_SHADOW_X509V3_EXT_cleanup"),
        // .define("X509V3_EXT_CRL_add_nconf", to: "GRPC_SHADOW_X509V3_EXT_CRL_add_nconf"),
        // .define("X509V3_EXT_d2i", to: "GRPC_SHADOW_X509V3_EXT_d2i"),
        // .define("X509V3_extensions_print", to: "GRPC_SHADOW_X509V3_extensions_print"),
        // .define("X509V3_EXT_free", to: "GRPC_SHADOW_X509V3_EXT_free"),
        // .define("X509V3_EXT_get", to: "GRPC_SHADOW_X509V3_EXT_get"),
        // .define("X509V3_EXT_get_nid", to: "GRPC_SHADOW_X509V3_EXT_get_nid"),
        // .define("X509V3_EXT_i2d", to: "GRPC_SHADOW_X509V3_EXT_i2d"),
        // .define("X509V3_EXT_nconf", to: "GRPC_SHADOW_X509V3_EXT_nconf"),
        // .define("X509V3_EXT_nconf_nid", to: "GRPC_SHADOW_X509V3_EXT_nconf_nid"),
        // .define("X509V3_EXT_print", to: "GRPC_SHADOW_X509V3_EXT_print"),
        // .define("X509V3_EXT_print_fp", to: "GRPC_SHADOW_X509V3_EXT_print_fp"),
        // .define("X509V3_EXT_REQ_add_nconf", to: "GRPC_SHADOW_X509V3_EXT_REQ_add_nconf"),
        // .define("X509V3_EXT_val_prn", to: "GRPC_SHADOW_X509V3_EXT_val_prn"),
        // .define("X509V3_get_d2i", to: "GRPC_SHADOW_X509V3_get_d2i"),
        // .define("X509v3_get_ext", to: "GRPC_SHADOW_X509v3_get_ext"),
        // .define("X509v3_get_ext_by_critical", to: "GRPC_SHADOW_X509v3_get_ext_by_critical"),
        // .define("X509v3_get_ext_by_NID", to: "GRPC_SHADOW_X509v3_get_ext_by_NID"),
        // .define("X509v3_get_ext_by_OBJ", to: "GRPC_SHADOW_X509v3_get_ext_by_OBJ"),
        // .define("X509v3_get_ext_count", to: "GRPC_SHADOW_X509v3_get_ext_count"),
        // .define("X509V3_get_section", to: "GRPC_SHADOW_X509V3_get_section"),
        // .define("X509V3_get_string", to: "GRPC_SHADOW_X509V3_get_string"),
        // .define("X509V3_get_value_bool", to: "GRPC_SHADOW_X509V3_get_value_bool"),
        // .define("X509V3_get_value_int", to: "GRPC_SHADOW_X509V3_get_value_int"),
        // .define("x509v3_hex_to_bytes", to: "GRPC_SHADOW_x509v3_hex_to_bytes"),
        // .define("x509v3_looks_like_dns_name", to: "GRPC_SHADOW_x509v3_looks_like_dns_name"),
        // .define("x509v3_name_cmp", to: "GRPC_SHADOW_x509v3_name_cmp"),
        // .define("X509V3_NAME_from_section", to: "GRPC_SHADOW_X509V3_NAME_from_section"),
        // .define("X509V3_parse_list", to: "GRPC_SHADOW_X509V3_parse_list"),
        // .define("X509V3_section_free", to: "GRPC_SHADOW_X509V3_section_free"),
        // .define("X509V3_set_ctx", to: "GRPC_SHADOW_X509V3_set_ctx"),
        // .define("X509V3_set_nconf", to: "GRPC_SHADOW_X509V3_set_nconf"),
        // .define("X509V3_string_free", to: "GRPC_SHADOW_X509V3_string_free"),
        // .define("X509_VAL_free", to: "GRPC_SHADOW_X509_VAL_free"),
        // .define("X509_VAL_it", to: "GRPC_SHADOW_X509_VAL_it"),
        // .define("X509_VAL_new", to: "GRPC_SHADOW_X509_VAL_new"),
        // .define("X509_verify", to: "GRPC_SHADOW_X509_verify"),
        // .define("X509_verify_cert", to: "GRPC_SHADOW_X509_verify_cert"),
        // .define("X509_verify_cert_error_string", to: "GRPC_SHADOW_X509_verify_cert_error_string"),
        // .define("X509_VERIFY_PARAM_add0_policy", to: "GRPC_SHADOW_X509_VERIFY_PARAM_add0_policy"),
        // .define("X509_VERIFY_PARAM_add0_table", to: "GRPC_SHADOW_X509_VERIFY_PARAM_add0_table"),
        // .define("X509_VERIFY_PARAM_add1_host", to: "GRPC_SHADOW_X509_VERIFY_PARAM_add1_host"),
        // .define("X509_VERIFY_PARAM_clear_flags", to: "GRPC_SHADOW_X509_VERIFY_PARAM_clear_flags"),
        // .define("X509_VERIFY_PARAM_free", to: "GRPC_SHADOW_X509_VERIFY_PARAM_free"),
        // .define("X509_VERIFY_PARAM_get0", to: "GRPC_SHADOW_X509_VERIFY_PARAM_get0"),
        // .define("X509_VERIFY_PARAM_get0_name", to: "GRPC_SHADOW_X509_VERIFY_PARAM_get0_name"),
        // .define("X509_VERIFY_PARAM_get0_peername", to: "GRPC_SHADOW_X509_VERIFY_PARAM_get0_peername"),
        // .define("X509_VERIFY_PARAM_get_count", to: "GRPC_SHADOW_X509_VERIFY_PARAM_get_count"),
        // .define("X509_VERIFY_PARAM_get_depth", to: "GRPC_SHADOW_X509_VERIFY_PARAM_get_depth"),
        // .define("X509_VERIFY_PARAM_get_flags", to: "GRPC_SHADOW_X509_VERIFY_PARAM_get_flags"),
        // .define("X509_VERIFY_PARAM_inherit", to: "GRPC_SHADOW_X509_VERIFY_PARAM_inherit"),
        // .define("X509_VERIFY_PARAM_lookup", to: "GRPC_SHADOW_X509_VERIFY_PARAM_lookup"),
        // .define("X509_VERIFY_PARAM_new", to: "GRPC_SHADOW_X509_VERIFY_PARAM_new"),
        // .define("X509_VERIFY_PARAM_set1", to: "GRPC_SHADOW_X509_VERIFY_PARAM_set1"),
        // .define("X509_VERIFY_PARAM_set1_email", to: "GRPC_SHADOW_X509_VERIFY_PARAM_set1_email"),
        // .define("X509_VERIFY_PARAM_set1_host", to: "GRPC_SHADOW_X509_VERIFY_PARAM_set1_host"),
        // .define("X509_VERIFY_PARAM_set1_ip", to: "GRPC_SHADOW_X509_VERIFY_PARAM_set1_ip"),
        // .define("X509_VERIFY_PARAM_set1_ip_asc", to: "GRPC_SHADOW_X509_VERIFY_PARAM_set1_ip_asc"),
        // .define("X509_VERIFY_PARAM_set1_name", to: "GRPC_SHADOW_X509_VERIFY_PARAM_set1_name"),
        // .define("X509_VERIFY_PARAM_set1_policies", to: "GRPC_SHADOW_X509_VERIFY_PARAM_set1_policies"),
        // .define("X509_VERIFY_PARAM_set_depth", to: "GRPC_SHADOW_X509_VERIFY_PARAM_set_depth"),
        // .define("X509_VERIFY_PARAM_set_flags", to: "GRPC_SHADOW_X509_VERIFY_PARAM_set_flags"),
        // .define("X509_VERIFY_PARAM_set_hostflags", to: "GRPC_SHADOW_X509_VERIFY_PARAM_set_hostflags"),
        // .define("X509_VERIFY_PARAM_set_purpose", to: "GRPC_SHADOW_X509_VERIFY_PARAM_set_purpose"),
        // .define("X509_VERIFY_PARAM_set_time", to: "GRPC_SHADOW_X509_VERIFY_PARAM_set_time"),
        // .define("X509_VERIFY_PARAM_set_trust", to: "GRPC_SHADOW_X509_VERIFY_PARAM_set_trust"),
        // .define("X509_VERIFY_PARAM_table_cleanup", to: "GRPC_SHADOW_X509_VERIFY_PARAM_table_cleanup"),

      ]
    ),
  ],

  cxxLanguageStandard: CXXLanguageStandard.gnucxx14
)

