package termeverything

/**
 * @see [input-event-codes.h](https://github.com/torvalds/linux/blob/master/include/uapi/linux/input-event-codes.h)
 */
type Linux_Event_Codes int

const (
	KEY_RESERVED   Linux_Event_Codes = 0
	KEY_ESC        Linux_Event_Codes = 1
	KEY_1          Linux_Event_Codes = 2
	KEY_2          Linux_Event_Codes = 3
	KEY_3          Linux_Event_Codes = 4
	KEY_4          Linux_Event_Codes = 5
	KEY_5          Linux_Event_Codes = 6
	KEY_6          Linux_Event_Codes = 7
	KEY_7          Linux_Event_Codes = 8
	KEY_8          Linux_Event_Codes = 9
	KEY_9          Linux_Event_Codes = 10
	KEY_0          Linux_Event_Codes = 11
	KEY_MINUS      Linux_Event_Codes = 12
	KEY_EQUAL      Linux_Event_Codes = 13
	KEY_BACKSPACE  Linux_Event_Codes = 14
	KEY_TAB        Linux_Event_Codes = 15
	KEY_Q          Linux_Event_Codes = 16
	KEY_W          Linux_Event_Codes = 17
	KEY_E          Linux_Event_Codes = 18
	KEY_R          Linux_Event_Codes = 19
	KEY_T          Linux_Event_Codes = 20
	KEY_Y          Linux_Event_Codes = 21
	KEY_U          Linux_Event_Codes = 22
	KEY_I          Linux_Event_Codes = 23
	KEY_O          Linux_Event_Codes = 24
	KEY_P          Linux_Event_Codes = 25
	KEY_LEFTBRACE  Linux_Event_Codes = 26
	KEY_RIGHTBRACE Linux_Event_Codes = 27
	KEY_ENTER      Linux_Event_Codes = 28
	KEY_LEFTCTRL   Linux_Event_Codes = 29
	KEY_A          Linux_Event_Codes = 30
	KEY_S          Linux_Event_Codes = 31
	KEY_D          Linux_Event_Codes = 32
	KEY_F          Linux_Event_Codes = 33
	KEY_G          Linux_Event_Codes = 34
	KEY_H          Linux_Event_Codes = 35
	KEY_J          Linux_Event_Codes = 36
	KEY_K          Linux_Event_Codes = 37
	KEY_L          Linux_Event_Codes = 38
	KEY_SEMICOLON  Linux_Event_Codes = 39
	KEY_APOSTROPHE Linux_Event_Codes = 40
	KEY_GRAVE      Linux_Event_Codes = 41
	KEY_LEFTSHIFT  Linux_Event_Codes = 42
	KEY_BACKSLASH  Linux_Event_Codes = 43
	KEY_Z          Linux_Event_Codes = 44
	KEY_X          Linux_Event_Codes = 45
	KEY_C          Linux_Event_Codes = 46
	KEY_V          Linux_Event_Codes = 47
	KEY_B          Linux_Event_Codes = 48
	KEY_N          Linux_Event_Codes = 49
	KEY_M          Linux_Event_Codes = 50
	KEY_COMMA      Linux_Event_Codes = 51
	KEY_DOT        Linux_Event_Codes = 52
	KEY_SLASH      Linux_Event_Codes = 53
	KEY_RIGHTSHIFT Linux_Event_Codes = 54
	KEY_KPASTERISK Linux_Event_Codes = 55
	KEY_LEFTALT    Linux_Event_Codes = 56
	KEY_SPACE      Linux_Event_Codes = 57
	KEY_CAPSLOCK   Linux_Event_Codes = 58
	KEY_F1         Linux_Event_Codes = 59
	KEY_F2         Linux_Event_Codes = 60
	KEY_F3         Linux_Event_Codes = 61
	KEY_F4         Linux_Event_Codes = 62
	KEY_F5         Linux_Event_Codes = 63
	KEY_F6         Linux_Event_Codes = 64
	KEY_F7         Linux_Event_Codes = 65
	KEY_F8         Linux_Event_Codes = 66
	KEY_F9         Linux_Event_Codes = 67
	KEY_F10        Linux_Event_Codes = 68
	KEY_NUMLOCK    Linux_Event_Codes = 69
	KEY_SCROLLLOCK Linux_Event_Codes = 70
	KEY_KP7        Linux_Event_Codes = 71
	KEY_KP8        Linux_Event_Codes = 72
	KEY_KP9        Linux_Event_Codes = 73
	KEY_KPMINUS    Linux_Event_Codes = 74
	KEY_KP4        Linux_Event_Codes = 75
	KEY_KP5        Linux_Event_Codes = 76
	KEY_KP6        Linux_Event_Codes = 77
	KEY_KPPLUS     Linux_Event_Codes = 78
	KEY_KP1        Linux_Event_Codes = 79
	KEY_KP2        Linux_Event_Codes = 80
	KEY_KP3        Linux_Event_Codes = 81
	KEY_KP0        Linux_Event_Codes = 82
	KEY_KPDOT      Linux_Event_Codes = 83

	KEY_ZENKAKUHANKAKU   Linux_Event_Codes = 85
	KEY_102ND            Linux_Event_Codes = 86
	KEY_F11              Linux_Event_Codes = 87
	KEY_F12              Linux_Event_Codes = 88
	KEY_RO               Linux_Event_Codes = 89
	KEY_KATAKANA         Linux_Event_Codes = 90
	KEY_HIRAGANA         Linux_Event_Codes = 91
	KEY_HENKAN           Linux_Event_Codes = 92
	KEY_KATAKANAHIRAGANA Linux_Event_Codes = 93
	KEY_MUHENKAN         Linux_Event_Codes = 94
	KEY_KPJPCOMMA        Linux_Event_Codes = 95
	KEY_KPENTER          Linux_Event_Codes = 96
	KEY_RIGHTCTRL        Linux_Event_Codes = 97
	KEY_KPSLASH          Linux_Event_Codes = 98
	KEY_SYSRQ            Linux_Event_Codes = 99
	KEY_RIGHTALT         Linux_Event_Codes = 100
	KEY_LINEFEED         Linux_Event_Codes = 101
	KEY_HOME             Linux_Event_Codes = 102
	KEY_UP               Linux_Event_Codes = 103
	KEY_PAGEUP           Linux_Event_Codes = 104
	KEY_LEFT             Linux_Event_Codes = 105
	KEY_RIGHT            Linux_Event_Codes = 106
	KEY_END              Linux_Event_Codes = 107
	KEY_DOWN             Linux_Event_Codes = 108
	KEY_PAGEDOWN         Linux_Event_Codes = 109
	KEY_INSERT           Linux_Event_Codes = 110
	KEY_DELETE           Linux_Event_Codes = 111
	KEY_MACRO            Linux_Event_Codes = 112
	KEY_MUTE             Linux_Event_Codes = 113
	KEY_VOLUMEDOWN       Linux_Event_Codes = 114
	KEY_VOLUMEUP         Linux_Event_Codes = 115
	KEY_POWER            Linux_Event_Codes = 116 /* SC System Power Down */
	KEY_KPEQUAL          Linux_Event_Codes = 117
	KEY_KPPLUSMINUS      Linux_Event_Codes = 118
	KEY_PAUSE            Linux_Event_Codes = 119
	KEY_SCALE            Linux_Event_Codes = 120 /* AL Compiz Scale (Expose) */

	KEY_KPCOMMA Linux_Event_Codes = 121
	KEY_HANGEUL Linux_Event_Codes = 122
	// KEY_HANGUEL same as KEY_HANGEUL
	KEY_HANJA      Linux_Event_Codes = 123
	KEY_YEN        Linux_Event_Codes = 124
	KEY_LEFTMETA   Linux_Event_Codes = 125
	KEY_RIGHTMETA  Linux_Event_Codes = 126
	KEY_COMPOSE    Linux_Event_Codes = 127
	KEY_STOP       Linux_Event_Codes = 128 /* AC Stop */
	KEY_AGAIN      Linux_Event_Codes = 129
	KEY_PROPS      Linux_Event_Codes = 130 /* AC Properties */
	KEY_UNDO       Linux_Event_Codes = 131 /* AC Undo */
	KEY_FRONT      Linux_Event_Codes = 132
	KEY_COPY       Linux_Event_Codes = 133 /* AC Copy */
	KEY_OPEN       Linux_Event_Codes = 134 /* AC Open */
	KEY_PASTE      Linux_Event_Codes = 135 /* AC Paste */
	KEY_FIND       Linux_Event_Codes = 136 /* AC Search */
	KEY_CUT        Linux_Event_Codes = 137 /* AC Cut */
	KEY_HELP       Linux_Event_Codes = 138 /* AL Integrated Help Center */
	KEY_MENU       Linux_Event_Codes = 139 /* Menu (show menu) */
	KEY_CALC       Linux_Event_Codes = 140 /* AL Calculator */
	KEY_SETUP      Linux_Event_Codes = 141
	KEY_SLEEP      Linux_Event_Codes = 142 /* SC System Sleep */
	KEY_WAKEUP     Linux_Event_Codes = 143 /* System Wake Up */
	KEY_FILE       Linux_Event_Codes = 144 /* AL Local Machine Browser */
	KEY_SENDFILE   Linux_Event_Codes = 145
	KEY_DELETEFILE Linux_Event_Codes = 146
	KEY_XFER       Linux_Event_Codes = 147
	KEY_PROG1      Linux_Event_Codes = 148
	KEY_PROG2      Linux_Event_Codes = 149
	KEY_WWW        Linux_Event_Codes = 150 /* AL Internet Browser */
	KEY_MSDOS      Linux_Event_Codes = 151
	KEY_COFFEE     Linux_Event_Codes = 152 /* AL Terminal Lock/Screensaver */
	// KEY_SCREENLOCK same as KEY_COFFEE
	KEY_ROTATE_DISPLAY Linux_Event_Codes = 153 /* Display orientation */
	// KEY_DIRECTION same as KEY_ROTATE_DISPLAY
	KEY_CYCLEWINDOWS Linux_Event_Codes = 154
	KEY_MAIL         Linux_Event_Codes = 155
	KEY_BOOKMARKS    Linux_Event_Codes = 156 /* AC Bookmarks */
	KEY_COMPUTER     Linux_Event_Codes = 157
	KEY_BACK         Linux_Event_Codes = 158 /* AC Back */
	KEY_FORWARD      Linux_Event_Codes = 159 /* AC Forward */
	KEY_CLOSECD      Linux_Event_Codes = 160
	KEY_EJECTCD      Linux_Event_Codes = 161
	KEY_EJECTCLOSECD Linux_Event_Codes = 162
	KEY_NEXTSONG     Linux_Event_Codes = 163
	KEY_PLAYPAUSE    Linux_Event_Codes = 164
	KEY_PREVIOUSSONG Linux_Event_Codes = 165
	KEY_STOPCD       Linux_Event_Codes = 166
	KEY_RECORD       Linux_Event_Codes = 167
	KEY_REWIND       Linux_Event_Codes = 168
	KEY_PHONE        Linux_Event_Codes = 169 /* Media Select Telephone */
	KEY_ISO          Linux_Event_Codes = 170
	KEY_CONFIG       Linux_Event_Codes = 171 /* AL Consumer Control Configuration */
	KEY_HOMEPAGE     Linux_Event_Codes = 172 /* AC Home */
	KEY_REFRESH      Linux_Event_Codes = 173 /* AC Refresh */
	KEY_EXIT         Linux_Event_Codes = 174 /* AC Exit */
	KEY_MOVE         Linux_Event_Codes = 175
	KEY_EDIT         Linux_Event_Codes = 176
	KEY_SCROLLUP     Linux_Event_Codes = 177
	KEY_SCROLLDOWN   Linux_Event_Codes = 178
	KEY_KPLEFTPAREN  Linux_Event_Codes = 179
	KEY_KPRIGHTPAREN Linux_Event_Codes = 180
	KEY_NEW          Linux_Event_Codes = 181 /* AC New */
	KEY_REDO         Linux_Event_Codes = 182 /* AC Redo/Repeat */

	KEY_F13 Linux_Event_Codes = 183
	KEY_F14 Linux_Event_Codes = 184
	KEY_F15 Linux_Event_Codes = 185
	KEY_F16 Linux_Event_Codes = 186
	KEY_F17 Linux_Event_Codes = 187
	KEY_F18 Linux_Event_Codes = 188
	KEY_F19 Linux_Event_Codes = 189
	KEY_F20 Linux_Event_Codes = 190
	KEY_F21 Linux_Event_Codes = 191
	KEY_F22 Linux_Event_Codes = 192
	KEY_F23 Linux_Event_Codes = 193
	KEY_F24 Linux_Event_Codes = 194

	KEY_PLAYCD           Linux_Event_Codes = 200
	KEY_PAUSECD          Linux_Event_Codes = 201
	KEY_PROG3            Linux_Event_Codes = 202
	KEY_PROG4            Linux_Event_Codes = 203
	KEY_ALL_APPLICATIONS Linux_Event_Codes = 204 /* AC Desktop Show All Applications */
	// KEY_DASHBOARD same as KEY_ALL_APPLICATIONS
	KEY_SUSPEND        Linux_Event_Codes = 205
	KEY_CLOSE          Linux_Event_Codes = 206 /* AC Close */
	KEY_PLAY           Linux_Event_Codes = 207
	KEY_FASTFORWARD    Linux_Event_Codes = 208
	KEY_BASSBOOST      Linux_Event_Codes = 209
	KEY_PRINT          Linux_Event_Codes = 210 /* AC Print */
	KEY_HP             Linux_Event_Codes = 211
	KEY_CAMERA         Linux_Event_Codes = 212
	KEY_SOUND          Linux_Event_Codes = 213
	KEY_QUESTION       Linux_Event_Codes = 214
	KEY_EMAIL          Linux_Event_Codes = 215
	KEY_CHAT           Linux_Event_Codes = 216
	KEY_SEARCH         Linux_Event_Codes = 217
	KEY_CONNECT        Linux_Event_Codes = 218
	KEY_FINANCE        Linux_Event_Codes = 219 /* AL Checkbook/Finance */
	KEY_SPORT          Linux_Event_Codes = 220
	KEY_SHOP           Linux_Event_Codes = 221
	KEY_ALTERASE       Linux_Event_Codes = 222
	KEY_CANCEL         Linux_Event_Codes = 223 /* AC Cancel */
	KEY_BRIGHTNESSDOWN Linux_Event_Codes = 224
	KEY_BRIGHTNESSUP   Linux_Event_Codes = 225
	KEY_MEDIA          Linux_Event_Codes = 226

	KEY_SWITCHVIDEOMODE Linux_Event_Codes = 227 /* Cycle video outputs */
	KEY_KBDILLUMTOGGLE  Linux_Event_Codes = 228
	KEY_KBDILLUMDOWN    Linux_Event_Codes = 229
	KEY_KBDILLUMUP      Linux_Event_Codes = 230

	KEY_SEND             Linux_Event_Codes = 231 /* AC Send */
	KEY_REPLY            Linux_Event_Codes = 232 /* AC Reply */
	KEY_FORWARDMAIL      Linux_Event_Codes = 233 /* AC Forward Msg */
	KEY_SAVE             Linux_Event_Codes = 234 /* AC Save */
	KEY_DOCUMENTS        Linux_Event_Codes = 235
	KEY_BATTERY          Linux_Event_Codes = 236
	KEY_BLUETOOTH        Linux_Event_Codes = 237
	KEY_WLAN             Linux_Event_Codes = 238
	KEY_UWB              Linux_Event_Codes = 239
	KEY_UNKNOWN          Linux_Event_Codes = 240
	KEY_VIDEO_NEXT       Linux_Event_Codes = 241
	KEY_VIDEO_PREV       Linux_Event_Codes = 242
	KEY_BRIGHTNESS_CYCLE Linux_Event_Codes = 243
	KEY_BRIGHTNESS_AUTO  Linux_Event_Codes = 244
	// KEY_BRIGHTNESS_ZERO same as KEY_BRIGHTNESS_AUTO
	KEY_DISPLAY_OFF Linux_Event_Codes = 245
	KEY_WWAN        Linux_Event_Codes = 246
	// KEY_WIMAX same as KEY_WWAN
	KEY_RFKILL  Linux_Event_Codes = 247
	KEY_MICMUTE Linux_Event_Codes = 248
)

// LINUX_BUTTON_CODES corresponds to Linux button codes.
// @see input-event-codes.h
type LINUX_BUTTON_CODES int

const (
	BTN_MISC LINUX_BUTTON_CODES = 0x100
	BTN_0    LINUX_BUTTON_CODES = 0x100
	BTN_1    LINUX_BUTTON_CODES = 0x101
	BTN_2    LINUX_BUTTON_CODES = 0x102
	BTN_3    LINUX_BUTTON_CODES = 0x103
	BTN_4    LINUX_BUTTON_CODES = 0x104
	BTN_5    LINUX_BUTTON_CODES = 0x105
	BTN_6    LINUX_BUTTON_CODES = 0x106
	BTN_7    LINUX_BUTTON_CODES = 0x107
	BTN_8    LINUX_BUTTON_CODES = 0x108
	BTN_9    LINUX_BUTTON_CODES = 0x109

	BTN_MOUSE   LINUX_BUTTON_CODES = 0x110
	BTN_LEFT    LINUX_BUTTON_CODES = 0x110
	BTN_RIGHT   LINUX_BUTTON_CODES = 0x111
	BTN_MIDDLE  LINUX_BUTTON_CODES = 0x112
	BTN_SIDE    LINUX_BUTTON_CODES = 0x113
	BTN_EXTRA   LINUX_BUTTON_CODES = 0x114
	BTN_FORWARD LINUX_BUTTON_CODES = 0x115
	BTN_BACK    LINUX_BUTTON_CODES = 0x116
	BTN_TASK    LINUX_BUTTON_CODES = 0x117

	BTN_JOYSTICK LINUX_BUTTON_CODES = 0x120
	BTN_TRIGGER  LINUX_BUTTON_CODES = 0x120
	BTN_THUMB    LINUX_BUTTON_CODES = 0x121
	BTN_THUMB2   LINUX_BUTTON_CODES = 0x122
	BTN_TOP      LINUX_BUTTON_CODES = 0x123
	BTN_TOP2     LINUX_BUTTON_CODES = 0x124
	BTN_PINKIE   LINUX_BUTTON_CODES = 0x125
	BTN_BASE     LINUX_BUTTON_CODES = 0x126
	BTN_BASE2    LINUX_BUTTON_CODES = 0x127
	BTN_BASE3    LINUX_BUTTON_CODES = 0x128
	BTN_BASE4    LINUX_BUTTON_CODES = 0x129
	BTN_BASE5    LINUX_BUTTON_CODES = 0x12a
	BTN_BASE6    LINUX_BUTTON_CODES = 0x12b
	BTN_DEAD     LINUX_BUTTON_CODES = 0x12f

	BTN_GAMEPAD LINUX_BUTTON_CODES = 0x130
	BTN_SOUTH   LINUX_BUTTON_CODES = 0x130
	BTN_A       LINUX_BUTTON_CODES = BTN_SOUTH
	BTN_EAST    LINUX_BUTTON_CODES = 0x131
	BTN_B       LINUX_BUTTON_CODES = BTN_EAST
	BTN_C       LINUX_BUTTON_CODES = 0x132
	BTN_NORTH   LINUX_BUTTON_CODES = 0x133
	BTN_X       LINUX_BUTTON_CODES = BTN_NORTH
	BTN_WEST    LINUX_BUTTON_CODES = 0x134
	BTN_Y       LINUX_BUTTON_CODES = BTN_WEST
	BTN_Z       LINUX_BUTTON_CODES = 0x135
	BTN_TL      LINUX_BUTTON_CODES = 0x136
	BTN_TR      LINUX_BUTTON_CODES = 0x137
	BTN_TL2     LINUX_BUTTON_CODES = 0x138
	BTN_TR2     LINUX_BUTTON_CODES = 0x139
	BTN_SELECT  LINUX_BUTTON_CODES = 0x13a
	BTN_START   LINUX_BUTTON_CODES = 0x13b
	BTN_MODE    LINUX_BUTTON_CODES = 0x13c
	BTN_THUMBL  LINUX_BUTTON_CODES = 0x13d
	BTN_THUMBR  LINUX_BUTTON_CODES = 0x13e

	BTN_DIGI           LINUX_BUTTON_CODES = 0x140
	BTN_TOOL_PEN       LINUX_BUTTON_CODES = 0x140
	BTN_TOOL_RUBBER    LINUX_BUTTON_CODES = 0x141
	BTN_TOOL_BRUSH     LINUX_BUTTON_CODES = 0x142
	BTN_TOOL_PENCIL    LINUX_BUTTON_CODES = 0x143
	BTN_TOOL_AIRBRUSH  LINUX_BUTTON_CODES = 0x144
	BTN_TOOL_FINGER    LINUX_BUTTON_CODES = 0x145
	BTN_TOOL_MOUSE     LINUX_BUTTON_CODES = 0x146
	BTN_TOOL_LENS      LINUX_BUTTON_CODES = 0x147
	BTN_TOOL_QUINTTAP  LINUX_BUTTON_CODES = 0x148 /* Five fingers on trackpad */
	BTN_STYLUS3        LINUX_BUTTON_CODES = 0x149
	BTN_TOUCH          LINUX_BUTTON_CODES = 0x14a
	BTN_STYLUS         LINUX_BUTTON_CODES = 0x14b
	BTN_STYLUS2        LINUX_BUTTON_CODES = 0x14c
	BTN_TOOL_DOUBLETAP LINUX_BUTTON_CODES = 0x14d
	BTN_TOOL_TRIPLETAP LINUX_BUTTON_CODES = 0x14e
	BTN_TOOL_QUADTAP   LINUX_BUTTON_CODES = 0x14f /* Four fingers on trackpad */

	BTN_WHEEL     LINUX_BUTTON_CODES = 0x150
	BTN_GEAR_DOWN LINUX_BUTTON_CODES = 0x150
	BTN_GEAR_UP   LINUX_BUTTON_CODES = 0x151
)
